@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion

chcp 65001

pushd "%~dp0\" && call :GostLibDemoSize "%~n0.crc"
popd
goto :EOF

:GostLibDemoSize
if "%~1" == "" goto :EOF
set crc=%~1
set /a posx=0
set /a posy=0
set /a ystp=48
set /a count=0
call :DeleteFile  "%crc%"
call :AddHeader >> "%crc%" && echo Add header...Ok
call :SensorsValveGenerate
call :SensorsPumpGenerate
call :SensorsVacuometerGenerate
call :SensorsCompressorGenerate
echo %count% sensors generated
echo Done.
sleep 10
goto :EOF

:AddHeader
echo [Circuit]
echo GeneralMap = ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_1600_2560_4_silver.bmp
echo Hint = ДЕМО для GostLib
echo Name = GostLib Demo
echo []
echo [ConfigFileList]
echo ConfigFile = ~~\Resource\DaqSite\Default\Painter.crc
echo []
unix true
goto :EOF

:SensorsCompressorGenerate
set sensor_list=Up Down Right Left
for %%i in ( %sensor_list% ) do (
 call :AddS "Compressor %%i"
 set /a posy=posy+%ystp%
 set /a posx=0
 echo Compressor %%i Ok
)
goto :EOF

:SensorsPumpGenerate
set sensor_list=RotSingle.Up RotDouble.Left Turbomol.Down Roots.Right Diffusion.None SputIon.None
for %%i in ( %sensor_list% ) do (
 call :AddS "Pump %%i"
 set /a posy=posy+%ystp%
 set /a posx=0
 echo %%i Ok
)
goto :EOF

:SensorsValveGenerate
set sensor_list=ThruWayHor.LimSwNone.PneumaticOp ThruWayVer.LimSwNone.PneumaticOp AngUpLeft.LimSwNone.PneumaticOp 3WayUp.LimSwNone.PneumaticOp
set sensor_list=%sensor_list% ThruWayHor.LimSwNone.SolenoidOp ThruWayVer.LimSwNone.SolenoidOp AngUpLeft.LimSwNone.SolenoidOp 3WayUp.LimSwNone.SolenoidOp
set sensor_list=%sensor_list% ThruWayHor.LimSwNone.MotorOp ThruWayVer.LimSwNone.MotorOp AngUpLeft.LimSwNone.MotorOp 3WayUp.LimSwNone.MotorOp
set sensor_list=%sensor_list% ThruWayHor.LimSwNone.ManualOp ThruWayVer.LimSwNone.ManualOp AngUpLeft.LimSwNone.ManualOp 3WayUp.LimSwNone.ManualOp
set sensor_list=%sensor_list% VlvGateHor.LimSwNone.NoneOp VlvGateVer.LimSwNone.NoneOp
set sensor_list=%sensor_list% RotGateHor.LimSwNone.NoneOp RotGateVer.LimSwNone.NoneOp
for %%i in ( %sensor_list% ) do (
 call :AddS "Valve %%i"
 set /a posy=posy+%ystp%
 set /a posx=0
 echo %%i Ok
)
goto :EOF

:SensorsVacuometerGenerate
set sensor_list=Penning.Up Penning.Down Penning.Right Penning.Left Ionization.Up Ionization.Down Ionization.Right Ionization.Left Thermal.None
for %%i in ( %sensor_list% ) do (
 call :AddS "Vacuometer %%i"
 set /a posy=posy+%ystp%
 set /a posx=0
 echo %%i Ok
)
goto :EOF

:AddS
if "%~1" == "" goto :EOF
for /L %%j in (15,1,48) do call :AddSensor %~1 %%j >> "%crc%"
goto :EOF

:AddSensor
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if "%~3" == "" goto :EOF
set "type=%~1" & shift
set "name=%~1" & shift
set /a numb=%~1 & shift
echo [SensorList]
echo Sensor = %type%.%name%.%numb%
echo [%type%.%name%.%numb%]
echo Pos = %posx%, %posy%
echo Painter(v) = [Painter(v).GostLib.%type%.%name%]
echo Painter(v) = (glButtonBevel=2)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_%numb%_%numb%_24_silver.bmp
echo Hint = Demo %type%: %name%.%numb%
echo []
echo.
set /a posx=posx+%numb%
set /a count=count+1
unix true
goto :EOF

:DeleteFile
if "%~1" == "" goto :EOF
if exist "%~1" unix rm -f "%~1" 
unix true
goto :EOF
