 {
 ***********************************************************************
 DEMO_OPCUAMON main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @MenuToolsOpen - open Menu Tools dialog.
| @MenuConsolesOpen - open consoles menu.
| @MenuEditProgramOpen - open edit program menu.
| @MenuDeviceRestartOpen - open device restart menu.
|********************************************************
[]
 }
program demo_opcuamon_main_ctrl; { Main control program             }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SmilePeriod       = 1000;       { Polling period for smile face    }
 AwakePeriod       = 100;        { Period of checks to awake DatSrv }
 ao_pollrate       = 0;          { AnalogOutput - pollrate          }
 ao_pingtime       = 1;          { AnalogOutput - pingtime          }
 ao_ram_rss        = 2;          { AnalogOutput - RAM RSS           }
 ao_ram_vms        = 3;          { AnalogOutput - RAM VMS           }
 ao_ram_gc_enabled = 4;          { AnalogOutput - RAM GC ENABLED    }
 ao_ram_gc_objects = 5;          { AnalogOutput - RAM GC OBJECTS    }
 ao_ram_gc_countg0 = 6;          { AnalogOutput - RAM GC COUNTG0    }
 ao_ram_gc_countg1 = 7;          { AnalogOutput - RAM GC COUNTG1    }
 ao_ram_gc_countg2 = 8;          { AnalogOutput - RAM GC COUNTG2    }
 ao_ram_gc_garbage = 9;          { AnalogOutput - RAM GC GARBAGE    }
 ao_stat_readrate  = 10;         { AnalogOutput - STAT READRATE     }
 ao_stat_sendrate  = 11;         { AnalogOutput - STAT SENDRATE     }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 TDEMO_OPCUAMONMainRec = record  { Main control & GUI               }
  CMD    : record                { Commands to control GUI          }
   OPEN  : TTagRef;              { Open DAT file(s)                 }
   SAVE  : TTagRef;              { Save DAT file(s)                 }
   SOUND : TTagRef;              { Sound menu                       }
   SMILE : TTagRef;              { Smile menu                       }
   CLOSE : TTagRef;              { Close DAQ/CRW/WIN                }
  end;                           {                                  }
 end;                            {                                  }
 TDEMO_OPCUAMONWaveRec = record  { Wave simulator                   }
  STARTED   : TTagRef;           {                                  }
  FREQUENCY : TTagRef;           {                                  }
  AMPLITUDE : TTagRef;           {                                  }
  NOISE     : TTagRef;           {                                  }
  SIN       : TTagRef;           {                                  }
  COS       : TTagRef;           {                                  }
 end;                            {                                  }
 TDEMO_OPCUAMONTestRec = record  { Test perfotmance                 }
  ON        : TTagRef;           {                                  }
  NODES     : TTagRef;           {                                  }
  PERIOD    : TTagRef;           {                                  }
  LastTimeTestPerf : Real;       { Last time when test performance  }
 end;                            {                                  }
 TOPCUA_STAT = record            { &OpcuaMon/Srv statictics         }
  tagStdPyAppStat  : Integer;    { &OpcuaMon tagStdPyAppStat        }
  updStdPyAppStat  : Real;       { &OpcuaMon stat update marker     }
  tagOpcuaMonStat  : Integer;    { &OpcuaMon tagOpcuaMonStat        }
  updOpcuaMonStat  : Real;       { &OpcuaMon stat update marker     }
  updOpcuaMonMemo  : Real;       { &OpcuaMon memo update marker     }
  updOpcuaMonPoll  : Real;       { &OpcuaMon poll update marker     }
  updOpcuaMonPing  : Real;       { &OpcuaMon ping update marker     }
  ao_base          : Integer;    { Base AO index                    }
  tagProcState     : Integer;    { DEMO_OPCUAMON/SRV.PROC.STATE     }
 end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 DEMO_OPCUAMON        : record   { All DEMO_OPCUAMON data           }
  MAIN       : TDEMO_OPCUAMONMainRec; { Main control & GUI          }
  WAVE       : TDEMO_OPCUAMONWaveRec; { Wave simulator              }
  TEST       : TDEMO_OPCUAMONTestRec; { Test performance            }
  STAT       : TOPCUA_STAT;      { &OpcuaMon statistics             }
 end;                            {                                  }
 DEMO_OPCUASRV        : record   { All DEMO_OPCUASRV data           }
  WAVE       : TDEMO_OPCUAMONWaveRec; { Wave simulator              }
  TEST       : TDEMO_OPCUAMONTestRec; { Test performance            }
  STAT       : TOPCUA_STAT;      { &OpcuaSrv statistics             }
 end;                            {                                  }
 devOpcuaMon       : Integer;    { &OpcuaMon device reference       }
 devOpcuaSrv       : Integer;    { &OpcuaSrv device reference       }
 cmd_MenuToolsOpen : Integer;    { @MenuToolsOpen                   }
 cmd_MenuConsolesOpen : Integer; { @MenuConsolesOpen                }
 cmd_MenuEditProgramOpen : Integer; { @MenuEditProgramOpen          }
 cmd_MenuDeviceRestartOpen : Integer; { @MenuDeviceRestartOpen      }
 DatSrvAwokeTime   : Real;       { Time when DatSrv last awoke      }
 DatSrvGate        : TTagRef;    { Save data to DatSrv              }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_StdMenuTools}          { Standard Menu Tools  functions,  }

 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Initilize DEMO_OPCUAMON.MAIN record tags
 }
 procedure TDEMO_OPCUAMONMainRec_Init(var Rec:TDEMO_OPCUAMONMainRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.CMD.OPEN.tag,  TagPrefix+'.CMD.OPEN',  1);
   InitTag(Rec.CMD.SAVE.tag,  TagPrefix+'.CMD.SAVE',  1);
   InitTag(Rec.CMD.SOUND.tag, TagPrefix+'.CMD.SOUND', 1);
   InitTag(Rec.CMD.SMILE.tag, TagPrefix+'.CMD.SMILE', 1);
   InitTag(Rec.CMD.CLOSE.tag, TagPrefix+'.CMD.CLOSE', 1);
   Rec.CMD.SMILE.val:=GetErrCount(-2);
  end;
 end;
 {
 Initilize DEMO_OPCUAMON.WAVE record tags
 }
 procedure TDEMO_OPCUAMONWaveRec_Init(var Rec:TDEMO_OPCUAMONWaveRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.STARTED.tag,   TagPrefix+'.STARTED',   1);
   InitTag(Rec.FREQUENCY.tag, TagPrefix+'.FREQUENCY', 2);
   InitTag(Rec.AMPLITUDE.tag, TagPrefix+'.AMPLITUDE', 2);
   InitTag(Rec.NOISE.tag,     TagPrefix+'.NOISE',     2);
   InitTag(Rec.SIN.tag,       TagPrefix+'.SIN',       2);
   InitTag(Rec.COS.tag,       TagPrefix+'.COS',       2);
   Rec.STARTED.val:=MaxReal;
   Rec.FREQUENCY.val:=MaxReal;
   Rec.AMPLITUDE.val:=MaxReal;
   Rec.NOISE.val:=MaxReal;
   Rec.SIN.val:=0;
   Rec.COS.val:=0;
  end;
 end;
 {
 Initilize DEMO_OPCUAMON.TEST record tags
 }
 procedure TDEMO_OPCUAMONTestRec_Init(var Rec:TDEMO_OPCUAMONTestRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.ON.tag,     TagPrefix+'.ON',     1);
   InitTag(Rec.NODES.tag,  TagPrefix+'.NODES',  1);
   InitTag(Rec.PERIOD.tag, TagPrefix+'.PERIOD', 1);
   Rec.ON.val:=MaxReal;
   Rec.NODES.val:=MaxReal;
   Rec.PERIOD.val:=MaxReal;
  end;
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  if Length(s)>0 then ShowTooltip('guid '+Str(getpid)+'@'+ProgName+' text "'+s+'" preset stdHelp delay 15000'
                                 +' btn1 Справка cmd1 "unix getapppath firefox firefox.exe -t htmlfile -t text/html -a .html --run '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm')+'"');
 end;
 {
 Menu CLOSE Starter to start editing.
 }
 procedure MenuCloseStarter;
 var i,n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Меню выхода ');
   n:=n+EditAddInputLn('Выберите, что хотите сделать:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Продолжить работу текущего сеанса АСУ');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@tooltip text "Желаю успешной работы" preset stdSuccess delay 15000');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и закрыть программу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Crw Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и продолжить работу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить сеанс АСУ и начать заново');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Restart');
   //////////////////////////////////////////
   for i:=1 to WordCount(EditGetWellKnownDevices(DevName)) do
   if (RefFind('device '+ExtractWord(i,EditGetWellKnownDevices(DevName)))<>0) then begin
    n:=n+EditAddInputLn('Перезапустить сервер '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
    n:=n+EditAddConfirm(EditGetLastInputLn);
    n:=n+EditAddCommand('@SysEval @Daq Compile '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
   end;
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс Windows');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Logout');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Restart');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Выключить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Exit');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 530 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CLOSE'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu CLOSE Handler to handle editing.
 }
 procedure MenuCloseHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_CLOSE'));
 end;
 {
 Menu TOOLS Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Меню инструментов ');
   n:=n+EditAddInputLn('Выберите, что хотите сделать:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Посмотреть справочную информацию (help)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Загрузить параметры из ini-файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@LoadIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сохранить параметры в  ini-файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SaveIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть Консольное Окно …');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@MenuConsolesOpen');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Отредактировать Программу …');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@MenuEditProgramOpen');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезапустить Устройство …');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@MenuDeviceRestartOpen');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 375 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu TOOLS Handler to handle editing.
 }
 procedure MenuToolsHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
 end;
 {
 Awake DatSrv to enforce data save.
 }
 procedure AwakeDatSrv;
 begin
  DatSrvAwokeTime:=mSecNow;
  DevPostCmd(devDatSrv,'  ');
 end;
 {
 Update statistics on &OpcuaMon.
 }
 procedure UpdateOpcuaMonStat(var STAT:TOPCUA_STAT);
 var sdat,gc,poll,ping,ps:String; sep,ge,go,g0,g1,g2,gg:Integer; rss,vms,gw,pc,pr,wp,pt,pw,mb,rr,sr:Real;
  procedure Cleanup;
  begin
   sdat:=''; gc:=''; poll:=''; ping:=''; ps:='';
  end;
 begin
  Cleanup;
  if (TypeTag(STAT.tagStdPyAppStat)=tag_type_string) then begin
   sdat:=sGetTag(STAT.tagStdPyAppStat); sep:=Ord(';'); mb:=1024*1024;
   if ShouldRefresh(STAT.updStdPyAppStat,hashindexof(sdat,0,0))>0 then begin
    gc:=CookieScan(sdat,'gc',sep); gw:=rValDef(ExtractWord(7,gc),0);
    poll:=CookieScan(sdat,'poll',sep); wp:=rValDef(ExtractWord(3,poll),0);
    ping:=CookieScan(sdat,'ping',sep); pw:=rValDef(ExtractWord(2,ping),0);
    if ShouldRefresh(STAT.updOpcuaMonMemo,gw)>0 then begin    
     rss:=rValDef(CookieScan(sdat,'rss',sep),0)/mb;
     vms:=rValDef(CookieScan(sdat,'vms',sep),0)/mb;
     ge:=iValDef(ExtractWord(1,gc),0);
     go:=iValDef(ExtractWord(2,gc),0);
     g0:=iValDef(ExtractWord(3,gc),0);
     g1:=iValDef(ExtractWord(4,gc),0);
     g2:=iValDef(ExtractWord(5,gc),0);
     gg:=iValDef(ExtractWord(6,gc),0);
     UpdateAo(STAT.ao_base+ao_ram_rss,time,rss);
     UpdateAo(STAT.ao_base+ao_ram_vms,time,vms);
     UpdateAo(STAT.ao_base+ao_ram_gc_enabled,time,ge);
     UpdateAo(STAT.ao_base+ao_ram_gc_objects,time,go);
     UpdateAo(STAT.ao_base+ao_ram_gc_countg0,time,g0);
     UpdateAo(STAT.ao_base+ao_ram_gc_countg1,time,g1);
     UpdateAo(STAT.ao_base+ao_ram_gc_countg2,time,g2);
     UpdateAo(STAT.ao_base+ao_ram_gc_garbage,time,gg);
    end;
    if ShouldRefresh(STAT.updOpcuaMonPoll,wp)>0 then begin
     pc:=rValDef(ExtractWord(1,poll),0);
     pr:=rValDef(ExtractWord(2,poll),0);
     UpdateAo(STAT.ao_base+ao_pollrate,time,pr);
    end;
    if ShouldRefresh(STAT.updOpcuaMonPing,pw)>0 then begin
     pt:=rValDef(ExtractWord(1,ping),0);
     UpdateAo(STAT.ao_base+ao_pingtime,time,pt);
    end;
   end;
  end;
  if (TypeTag(STAT.tagOpcuaMonStat)=tag_type_string) then begin
   sdat:=sGetTag(STAT.tagOpcuaMonStat); sep:=Ord(';'); mb:=1024*1024;
   if ShouldRefresh(STAT.updOpcuaMonStat,hashindexof(sdat,0,0))>0 then begin
    rr:=rValDef(CookieScan(sdat,'ReadRate',sep),0);
    sr:=rValDef(CookieScan(sdat,'SendRate',sep),0);
    UpdateAo(STAT.ao_base+ao_stat_readrate,time,rr);
    UpdateAo(STAT.ao_base+ao_stat_sendrate,time,sr);
    ps:=Trim(CookieScan(sdat,'State',sep));
    if (TypeTag(STAT.tagProcState)=tag_type_string)
    then bNul(sSetTag(STAT.tagProcState,ps));
    case WordIndex(ps,'DEAD STARTING PREPARING RUNNING STOPPED RESTARTING') of
     1: bNul(SetTagColor(STAT.tagProcState,clGray));   // DEAD
     2: bNul(SetTagColor(STAT.tagProcState,clAqua));   // STARTING
     3: bNul(SetTagColor(STAT.tagProcState,clYellow)); // PREPARING
     4: bNul(SetTagColor(STAT.tagProcState,clLime));   // RUNNING
     5: bNul(SetTagColor(STAT.tagProcState,clRed));    // STOPPED
     6: bNul(SetTagColor(STAT.tagProcState,clYellow)); // RESTARTING
    end;
   end;
  end;
  Cleanup;
 end;
 {
 DEMO_OPCUASRV generate SIN/COS WAVE.
 }
 procedure DEMO_OPCUASRV_WaveGen;
 var t,ampl,freq,nois,wsin,wcos:Real; btn:Integer;
 begin
  t:=SecNow;
  btn:=iGetTag(DEMO_OPCUASRV.WAVE.Started.tag);
  if IsBit(btn,0) then begin
   ampl:=rGetTag(DEMO_OPCUASRV.WAVE.Amplitude.tag);
   freq:=rGetTag(DEMO_OPCUASRV.WAVE.Frequency.tag);
   nois:=rGetTag(DEMO_OPCUASRV.WAVE.Noise.tag);
   wsin:=ampl*sin(t*freq)+nois*random(-0.5,+0.5);
   wcos:=ampl*cos(t*freq)+nois*random(-0.5,+0.5);
   DevPostCmd(devOpcuaSrv,'@OpcNodeSend WaveSin '+str(wsin));
   DevPostCmd(devOpcuaSrv,'@OpcNodeSend WaveCos '+str(wcos));
  end;
 end;
 {
 DEMO_OPCUAMON clear strings
 }
 procedure DEMO_OPCUAMON_CLEAR;
 begin
 end;
 {
 DEMO_OPCUAMON initialization
 }
 procedure DEMO_OPCUAMON_INIT;
 begin
  //
  // Initialize tags & devices...
  //
  TDEMO_OPCUAMONMainRec_Init(DEMO_OPCUAMON.MAIN,ReadIni('tagDEMO_OPCUAMON')+'.MAIN');
  TDEMO_OPCUAMONWaveRec_Init(DEMO_OPCUAMON.WAVE,ReadIni('tagDEMO_OPCUAMON')+'.WAVE');
  TDEMO_OPCUAMONWaveRec_Init(DEMO_OPCUASRV.WAVE,ReadIni('tagDEMO_OPCUASRV')+'.WAVE');
  TDEMO_OPCUAMONTestRec_Init(DEMO_OPCUAMON.TEST,ReadIni('tagDEMO_OPCUAMON')+'.TESTPERF');
  TDEMO_OPCUAMONTestRec_Init(DEMO_OPCUASRV.TEST,ReadIni('tagDEMO_OPCUASRV')+'.TESTPERF');
  InitTag(DEMO_OPCUAMON.STAT.tagStdPyAppStat,ReadIni('[&OpcuaMon] tagStdPyAppStat'),-3);
  InitTag(DEMO_OPCUASRV.STAT.tagStdPyAppStat,ReadIni('[&OpcuaSrv] tagStdPyAppStat'),-3);
  InitTag(DEMO_OPCUAMON.STAT.tagOpcuaMonStat,ReadIni('[&OpcuaMon] tagOpcuaMonStat'),-3);
  InitTag(DEMO_OPCUASRV.STAT.tagOpcuaMonStat,ReadIni('[&OpcuaSrv] tagOpcuaSrvStat'),-3);
  InitTag(DEMO_OPCUAMON.STAT.tagProcState,ReadIni('tagDEMO_OPCUAMON')+'.PROC.STATE',-3);
  InitTag(DEMO_OPCUASRV.STAT.tagProcState,ReadIni('tagDEMO_OPCUASRV')+'.PROC.STATE',-3);
  bNul(SetTagColor(DEMO_OPCUAMON.STAT.tagProcState,clSilver));
  bNul(SetTagColor(DEMO_OPCUASRV.STAT.tagProcState,clSilver));
  DEMO_OPCUAMON.STAT.ao_base:=0;
  DEMO_OPCUASRV.STAT.ao_base:=12;
  InitTag(DatSrvGate.tag,'DATSRV.GATE',-1);
  InitDevice(devOpcuaMon,'&OpcuaMon',2);
  InitDevice(devOpcuaSrv,'&OpcuaSrv',2);
  DEMO_OPCUAMON.TEST.LastTimeTestPerf:=0;
  DEMO_OPCUASRV.TEST.LastTimeTestPerf:=0;
  //
  // Initialize values...
  //
  DatSrvAwokeTime:=0;
 end;
 {
 DEMO_OPCUAMON finalization
 }
 procedure DEMO_OPCUAMON_FREE;
 begin
 end;
 {
 DEMO_OPCUAMON polling
 }
 procedure DEMO_OPCUAMON_POLL;
 var s:String; ClickCurve,i:Integer; nerrors,fv:Real;
  procedure Cleanup;
  begin
   s:=''; ClickCurve:=0;
  end;
 begin
  Cleanup;
  {
  Update &OpcuaMon statistics.
  }
  if (SysTimer_Pulse(20)>0) then begin
   UpdateOpcuaMonStat(DEMO_OPCUAMON.STAT);
   UpdateOpcuaMonStat(DEMO_OPCUASRV.STAT);
  end;
  {
  Wave generation.
  }
  if (SysTimer_Pulse(100)>0) then begin
   DEMO_OPCUASRV_WaveGen;
  end;
  {
  Test
  }
  if (iGetTag(DEMO_OPCUAMON.TEST.ON.tag)>0) then
  if (mSecNow>=DEMO_OPCUAMON.TEST.LastTimeTestPerf+iGetTag(DEMO_OPCUAMON.TEST.PERIOD.tag)) then begin
   for i:=0 to iGetTag(DEMO_OPCUAMON.TEST.NODES.tag)-1 do begin
    fv:=i+frac(SecNow/5);
    DevPostCmd(devOpcuaMon,StrFmt('@OpcNodeSend TestPerf%.2d ',i)+Str(fv));
   end;
   DEMO_OPCUAMON.TEST.LastTimeTestPerf:=mSecNow;
  end;
  if (iGetTag(DEMO_OPCUASRV.TEST.ON.tag)>0) then
  if (mSecNow>=DEMO_OPCUASRV.TEST.LastTimeTestPerf+iGetTag(DEMO_OPCUASRV.TEST.PERIOD.tag)) then begin
   for i:=0 to iGetTag(DEMO_OPCUASRV.TEST.NODES.tag)-1 do begin
    fv:=i+frac(SecNow/5);
    DevPostCmd(devOpcuaSrv,StrFmt('@OpcNodeSend TestPerf%.2d ',i)+Str(fv));
   end;
   DEMO_OPCUASRV.TEST.LastTimeTestPerf:=mSecNow;
  end;
  {
  Awake DatSrv to enforce data save.
  }
  if (SysTimer_Pulse(AwakePeriod)>0) then bNul(iSetTag(DatSrvGate.tag,Ord(iGetTag(DEMO_OPCUAMON.MAIN.CMD.SAVE.tag)<>0)));
  {
  Execute GUI commands
  }
  if (iGetTag(DEMO_OPCUAMON.MAIN.CMD.OPEN.tag)<>0) then begin
   Cron('@FileOpenDialog '+URL_Packed(AddBackSlash(DaqFileRef(ReadIni('['+DatSrv+'] DataPath'),''))+'*.dat;*.crw'));
   bNul(iSetTag(DEMO_OPCUAMON.MAIN.CMD.OPEN.tag,0));
  end;
  if (iGetTag(DEMO_OPCUAMON.MAIN.CMD.CLOSE.tag)<>0) then begin
   bNul(iSetTag(DEMO_OPCUAMON.MAIN.CMD.CLOSE.tag,0));
   MenuCloseStarter;
  end;
  {
  Handle Smile button state
  }
  if (SysTimer_Pulse(SmilePeriod)>0) then begin
   nerrors:=GetErrCount(-2);
   if nerrors>DEMO_OPCUAMON.MAIN.CMD.SMILE.val then bNul(iSetTag(DEMO_OPCUAMON.MAIN.CMD.SMILE.tag,2)) else
   if iGetTag(DEMO_OPCUAMON.MAIN.CMD.SMILE.tag)>1 then bNul(iSetTag(DEMO_OPCUAMON.MAIN.CMD.SMILE.tag,1));
   DEMO_OPCUAMON.MAIN.CMD.SMILE.val:=nerrors;
  end;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     //
     // Toolbar buttons...
     //
     ClickBitXorLocal(DEMO_OPCUAMON.MAIN.CMD.OPEN.tag,1);
     ClickBitXorLocal(DEMO_OPCUAMON.MAIN.CMD.SAVE.tag,1);
     ClickBitXorLocal(DEMO_OPCUAMON.MAIN.CMD.SOUND.tag,1);
     ClickBitXorLocal(DEMO_OPCUAMON.MAIN.CMD.CLOSE.tag,1);
     if (ClickTag=DEMO_OPCUAMON.MAIN.CMD.SAVE.tag) then begin
      bNul(iSetTag(DatSrvGate.tag,Ord(iGetTag(DEMO_OPCUAMON.MAIN.CMD.SAVE.tag)<>0)));
      if iGetTag(DEMO_OPCUAMON.MAIN.CMD.SAVE.tag)<>0 then AwakeDatSrv;
     end;
     if IsSameText(ClickSensor,'DEMO_OPCUAMON.MAIN.CMD.HOME') then begin
      DevPostCmdLocal('@Cron @Cron.Run DEMO_OPCUAMON.MAIN.CTRL.HOME');
      DevPostCmdLocal('@Cron @Cron.Run DEMO_OPCUASRV.MAIN.CTRL.HOME');
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'DEMO_OPCUAMON.MAIN.CMD.HELP') then begin
      DevPostCmdLocal('@BrowseHelp');
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'DEMO_OPCUAMON.MAIN.CMD.TOOLS') then begin
      DevPostCmdLocal('@MenuToolsOpen');
      bNul(Voice(snd_Click));
     end;
     //
     if (ClickTag=DEMO_OPCUAMON.WAVE.STARTED.tag) then begin
      s:=Str(iand(ixor(iGetTag(DEMO_OPCUAMON.WAVE.STARTED.tag),1),1));
      DevPostCmd(devOpcuaMon,'@OpcNodeSend WaveStarted '+Trim(s));
      bNul(Voice(snd_Click));
     end;
     ClickBitXorLocal(DEMO_OPCUAMON.TEST.ON.tag,1);
     //
     if (ClickTag=DEMO_OPCUASRV.WAVE.STARTED.tag) then begin
      s:=Str(iand(ixor(iGetTag(DEMO_OPCUASRV.WAVE.STARTED.tag),1),1));
      DevPostCmd(devOpcuaSrv,'@OpcNodeSend WaveStarted '+Trim(s));
      bNul(Voice(snd_Click));
     end;
     ClickBitXorLocal(DEMO_OPCUASRV.TEST.ON.tag,1);
     //
     // Start edit tags...
     //
     if (ClickTag=DEMO_OPCUAMON.WAVE.AMPLITUDE.tag) then begin
      StartEditTag(ClickTag,'Wave Amplitude');
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DEMO_OPCUAMON.WAVE.FREQUENCY.tag) then begin
      StartEditTag(ClickTag,'Wave Frequency, Hz');
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DEMO_OPCUAMON.WAVE.NOISE.tag) then begin
      StartEditTag(ClickTag,'Wave Noise');
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DEMO_OPCUAMON.TEST.NODES.tag) then begin
      StartEditTag(ClickTag,'Number of Nodes to Test');
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DEMO_OPCUAMON.TEST.PERIOD.tag) then begin
      StartEditTag(ClickTag,'Poll Perios to Test, ms');
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DEMO_OPCUASRV.WAVE.AMPLITUDE.tag) then begin
      StartEditTag(ClickTag,'Wave Amplitude');
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DEMO_OPCUASRV.WAVE.FREQUENCY.tag) then begin
      StartEditTag(ClickTag,'Wave Frequency, Hz');
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DEMO_OPCUASRV.WAVE.NOISE.tag) then begin
      StartEditTag(ClickTag,'Wave Noise');
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DEMO_OPCUASRV.TEST.NODES.tag) then begin
      StartEditTag(ClickTag,'Number of Nodes to Test');
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DEMO_OPCUASRV.TEST.PERIOD.tag) then begin
      StartEditTag(ClickTag,'Poll Perios to Test, ms');
      bNul(Voice(snd_Click));
     end;
     //
     // Smile face button...
     //
     if (ClickTag=DEMO_OPCUAMON.MAIN.CMD.SMILE.tag) then begin
      bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
      bNul(iSetTag(DEMO_OPCUAMON.MAIN.CMD.SMILE.tag,0));
      bNul(Voice(snd_Click));
     end;
     //
     // Select Plot & Tab windows by curve...
     //
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     //
     // Console commands: @url_encoded_sensor ...
     //
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
     //
     // Calibrations
     //
     if IsSameText(ExtractFileExt(ClickSensor),'.CAL') then begin
      bNul(CalibrOpenByCurve(RefFind('Curve '+ExtractFileName(ClickSensor))));
      bNul(Voice(snd_Click));
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Menu CLOSE.
   }
   MenuCloseHandler;
   {
   Menu TOOLS.
   }
   MenuToolsHandler;
   {
   Menu CONSOLES
   }
   MenuConsolesHandler;
   {
   Menu EDITPROGRAM
   }
   MenuEditProgramHandler;
   {
   Menu DEVICERESTART
   }
   MenuDeviceRestartHandler;
   {
   Warning, Information dialog completion.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
   {
   Accept edit tags.
   }
   if CheckEditTag(DEMO_OPCUAMON.WAVE.AMPLITUDE.tag,s) then DevPostCmd(devOpcuaMon,'@OpcNodeSend WaveAmplitude '+Trim(s));
   if CheckEditTag(DEMO_OPCUAMON.WAVE.FREQUENCY.tag,s) then DevPostCmd(devOpcuaMon,'@OpcNodeSend WaveFrequency '+Trim(s));
   if CheckEditTag(DEMO_OPCUAMON.WAVE.NOISE.tag,s) then DevPostCmd(devOpcuaMon,'@OpcNodeSend WaveNoise '+Trim(s));
   CheckEditTagUpdate(DEMO_OPCUAMON.TEST.PERIOD.tag,1,5000);
   CheckEditTagUpdate(DEMO_OPCUAMON.TEST.NODES.tag,1,20);
   if CheckEditTag(DEMO_OPCUASRV.WAVE.AMPLITUDE.tag,s) then DevPostCmd(devOpcuaSrv,'@OpcNodeSend WaveAmplitude '+Trim(s));
   if CheckEditTag(DEMO_OPCUASRV.WAVE.FREQUENCY.tag,s) then DevPostCmd(devOpcuaSrv,'@OpcNodeSend WaveFrequency '+Trim(s));
   if CheckEditTag(DEMO_OPCUASRV.WAVE.NOISE.tag,s) then DevPostCmd(devOpcuaSrv,'@OpcNodeSend WaveNoise '+Trim(s));
   CheckEditTagUpdate(DEMO_OPCUASRV.TEST.PERIOD.tag,1,5000);
   CheckEditTagUpdate(DEMO_OPCUASRV.TEST.NODES.tag,1,20);
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  Cleanup;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  DEMO_OPCUAMON_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('@StartupScript','@FinallyScript');
  StdIn_SetTimeouts(60000,60000,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  DEMO_OPCUAMON_INIT;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then DevPostCmdLocal('@LoadIni');
  cmd_MenuToolsOpen:=RegisterStdInCmd('@MenuToolsOpen','');
  cmd_MenuConsolesOpen:=RegisterStdInCmd('@MenuConsolesOpen','');
  cmd_MenuEditProgramOpen:=RegisterStdInCmd('@MenuEditProgramOpen','');
  cmd_MenuDeviceRestartOpen:=RegisterStdInCmd('@MenuDeviceRestartOpen','');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then DevPostCmdLocal('@SaveIni');
  DEMO_OPCUAMON_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  DEMO_OPCUAMON_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
  procedure Cleanup;
  begin
   cmd:=''; arg:='';
  end;
 begin
  Cleanup;
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @MenuToolsOpen
   }
   if (cmdid=cmd_MenuToolsOpen) then begin
    MenuToolsStarter;
    Data:='';
   end else
   {
   @MenuConsolesOpen
   }
   if (cmdid=cmd_MenuConsolesOpen) then begin
    MenuConsolesStarter;
    Data:='';
   end else
   {
   @MenuEditProgramOpen
   }
   if (cmdid=cmd_MenuEditProgramOpen) then begin
    if HasUserAccessLevelTip('root',cmd,7,7000) then MenuEditProgramStarter;
    Data:='';
   end else
   {
   @MenuDeviceRestartOpen
   }
   if (cmdid=cmd_MenuDeviceRestartOpen) then begin 
    if HasUserAccessLevelTip('root',cmd,7,7000) then MenuDeviceRestartStarter;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  Cleanup;
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
