 {
 ***********************************************************************
 MDBS - main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
|********************************************************
[]
 }
program mdbs_main_ctrl;          { MDBS - main control program      }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SmilePeriod       = 1000;       { Polling period for smile face    }
 RatePeriod        = 1000;       { Calculate rate period            }

type
 TTagRef           = record tag,nai,ndi,nao,ndo:Integer; val:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 MDBS              : record      { All MDBS data                    }
  CMD              : record      { CoMmandDs to control MDBS GUI    }
   HELP            : TTagRef;    { Open Help                        }
   OPEN            : TTagRef;    { Open DAT file(s)                 }
   SAVE            : TTagRef;    { Save DAT file(s)                 }
   ZERO            : TTagRef;    { Zero all stat. counters          }
   TOOLS           : TTagRef;    { Tools menu                       }
   SMILE           : TTagRef;    { Smile menu                       }
   CLOSE           : TTagRef;    { Close DAQ/CRW/WIN                }
  end;                           {                                  }
  ADAMPOLLC,                     { ADAM poll counter                }
  ADAMPOLLR,                     { ADAM poll rate                   }
  ADAMBYTEC,                     { ADAM byte counter                }
  ADAMBYTER        : record      { ADAM byte rate                   }
   Rx,Tx           : TTagRef;    { Receiver, Transmitter            }
  end;                           {                                  }
  LastRate         : Real;       { Time of last rate                }
 end;

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var nv:Integer;
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Menu Close Starter to start editing.
 }
 procedure MenuCloseStarter;
 var i,n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Закрыть"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Продолжить работу текущего сеанса АСУ');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@tooltip text "Желаю успешной работы" preset stdNotify delay 15000');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и закрыть программу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Crw Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и продолжить работу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить сеанс АСУ и начать заново');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Restart');
   //////////////////////////////////////////
   for i:=1 to WordCount(EditGetWellKnownDevices(DevName)) do
   if (RefFind('device '+ExtractWord(i,EditGetWellKnownDevices(DevName)))<>0) then begin
    n:=n+EditAddInputLn('Перезапустить сервер '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
    n:=n+EditAddConfirm(EditGetLastInputLn);
    n:=n+EditAddCommand('@SysEval @Daq Compile '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
   end;
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс Windows');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Logout');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Restart');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Выключить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Exit');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 630 relative '+ForceExtension(Copy(DevName,2),'.GUI')+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+ForceExtension(Copy(DevName,2),'.GUI')+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CLOSE'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Close Handler to handle editing.
 }
 procedure MenuCloseHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_CLOSE'));
 end;
 {
 Find comma separated window list where curve is inside.
 }
 function ListWinByCurve(crv:Integer):String;
 var list,win:String; n,m,i,j,t,c:Integer;
 begin
  list:=''; win:='';
  if not IsEmptyStr(CrvName(crv)) then for m:=1 to 2 do begin
   n:=0;
   repeat
    c:=0;
    win:=ParamStr(ExtractWord(m,'CURWINNAME,TABWINNAME')+' '+Str(n)); n:=n+1;
    if not IsEmptyStr(win) then begin
     t:=ReadIniSection(Text_New,16+8+4+1,'', StrAddBrackets(win,'[',']'));
     for i:=0 to Text_NumLn(t)-1 do
     if IsSameText(ExtractWord(1,Text_GetLn(t,i)),'CurveList') then
     for j:=2 to WordCount(Text_GetLn(t,i)) do
     if IsSameText(ExtractWord(j,Text_GetLn(t,i)),CrvName(crv)) then c:=c+1;
     bNul(Text_Free(t));
     if c>0 then
     if IsEmptyStr(list) then list:=win else list:=list+','+Trim(win);
    end;
   until IsEmptyStr(win);
  end;
  ListWinByCurve:=list;
  list:=''; win:='';
 end;
 {
 Select windows where curve is inside.
 }
 procedure SelectWinByCurve(crv:Integer);
 var list:String; i:Integer;
 begin
  list:='';
  list:=ListWinByCurve(crv);
  for i:=1 to WordCountDelims(list,Dump(',')) do begin
   bNul(WinSelect(ExtractWordDelims(i,list,Dump(','))));
   bNul(WinDraw(ExtractWordDelims(i,list,Dump(','))+'|SelectCurve='+CrvName(crv)));
  end;
  list:='';
 end;
 {
 MDBS initialization
 }
 procedure MDBS_INIT;
 begin
  {
  Initialize tags...
  }
  InitTag(MDBS.CMD.HELP.tag,     ReadIni('tagMDBS')+'.CMD.HELP',      1);
  InitTag(MDBS.CMD.OPEN.tag,     ReadIni('tagMDBS')+'.CMD.OPEN',      1);
  InitTag(MDBS.CMD.TOOLS.tag,    ReadIni('tagMDBS')+'.CMD.TOOLS',     1);
  InitTag(MDBS.CMD.SAVE.tag,     ReadIni('tagMDBS')+'.CMD.SAVE',      1);
  InitTag(MDBS.CMD.ZERO.tag,     ReadIni('tagMDBS')+'.CMD.ZERO',      1);
  InitTag(MDBS.CMD.SMILE.tag,    ReadIni('tagMDBS')+'.CMD.SMILE',     1);
  InitTag(MDBS.CMD.CLOSE.tag,    ReadIni('tagMDBS')+'.CMD.CLOSE',     1);
  InitTag(MDBS.ADAMPOLLC.RX.tag, ReadIni('tagMDBS')+'.ADAMPOLLC.RX',  2);
  InitTag(MDBS.ADAMPOLLC.TX.tag, ReadIni('tagMDBS')+'.ADAMPOLLC.TX',  2);
  InitTag(MDBS.ADAMPOLLR.RX.tag, ReadIni('tagMDBS')+'.ADAMPOLLR.RX',  2);
  InitTag(MDBS.ADAMPOLLR.TX.tag, ReadIni('tagMDBS')+'.ADAMPOLLR.TX',  2);
  InitTag(MDBS.ADAMBYTEC.RX.tag, ReadIni('tagMDBS')+'.ADAMBYTEC.RX',  2);
  InitTag(MDBS.ADAMBYTEC.TX.tag, ReadIni('tagMDBS')+'.ADAMBYTEC.TX',  2);
  InitTag(MDBS.ADAMBYTER.RX.tag, ReadIni('tagMDBS')+'.ADAMBYTER.RX',  2);
  InitTag(MDBS.ADAMBYTER.TX.tag, ReadIni('tagMDBS')+'.ADAMBYTER.TX',  2);
  {
  Initialize values
  }
  MDBS.CMD.SMILE.val:=GetErrCount(-2);
  bNul(rSetTag(MDBS.ADAMPOLLC.RX.tag,0));
  bNul(rSetTag(MDBS.ADAMPOLLC.TX.tag,0));
  bNul(rSetTag(MDBS.ADAMPOLLR.RX.tag,0));
  bNul(rSetTag(MDBS.ADAMPOLLR.TX.tag,0));
  bNul(rSetTag(MDBS.ADAMBYTEC.RX.tag,0));
  bNul(rSetTag(MDBS.ADAMBYTEC.TX.tag,0));
  bNul(rSetTag(MDBS.ADAMBYTER.RX.tag,0));
  bNul(rSetTag(MDBS.ADAMBYTER.TX.tag,0));
  MDBS.LastRate:=0;
 end;
 {
 MDBS finalization
 }
 procedure MDBS_FREE;
 begin
 end;
 {
 MDBS polling
 }
 procedure MDBS_POLL;
 var errors:Real; ClickCurve:Integer;
  procedure AdamTraffic(data:String; ms:Real);
  var pctx,bctx,pcrx,bcrx,dt:Real;
   procedure CalcRate(rtag,ctag:Integer; var cval:Real; val,dt:Real);
   begin
    bNul(rSetTag(ctag,val));
    bNul(rSetTag(rtag,1000*(val-cval)/dt));
    cval:=val;
   end;
  begin
   if Length(data)>0 then begin
    dt:=ms-MDBS.LastRate;
    if dt>0 then begin
     pctx:=rValDef(ExtractWord(1,data),0);
     bctx:=rValDef(ExtractWord(2,data),0);
     pcrx:=rValDef(ExtractWord(3,data),0);
     bcrx:=rValDef(ExtractWord(4,data),0);
     CalcRate(MDBS.ADAMPOLLR.TX.tag,MDBS.ADAMPOLLC.TX.tag,MDBS.ADAMPOLLC.TX.val,pctx,dt);
     CalcRate(MDBS.ADAMBYTER.TX.tag,MDBS.ADAMBYTEC.TX.tag,MDBS.ADAMBYTEC.TX.val,bctx,dt);
     CalcRate(MDBS.ADAMPOLLR.RX.tag,MDBS.ADAMPOLLC.RX.tag,MDBS.ADAMPOLLC.RX.val,pcrx,dt);
     CalcRate(MDBS.ADAMBYTER.RX.tag,MDBS.ADAMBYTEC.RX.tag,MDBS.ADAMBYTEC.RX.val,bcrx,dt);
    end;
    MDBS.LastRate:=ms;
   end;
  end;
 begin
  {
  Execute GUI commands.
  }
  if iGetTag(MDBS.CMD.HELP.tag)<>0 then begin
   Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
   bNul(iSetTag(MDBS.CMD.HELP.tag,0));
  end;
  if iGetTag(MDBS.CMD.OPEN.tag)<>0 then begin
   Cron('@FileOpenDialog '+
    URL_Packed(AddBackSlash(DaqFileRef(ReadIni('['+DatSrv+'] DataPath'),''))+'*.dat;*.crw'));
   bNul(iSetTag(MDBS.CMD.OPEN.tag,0));
  end;
  if iGetTag(MDBS.CMD.ZERO.tag)<>0 then begin
   DevSendCmd(devModbusSrv,'@ZeroPortCounters');
   bNul(iSetTag(MDBS.CMD.ZERO.tag,0));
  end;
  if iGetTag(MDBS.CMD.TOOLS.tag)<>0 then begin
   bNul(Action('&MDBS.DLG.SIM'));
   bNul(iSetTag(MDBS.CMD.TOOLS.tag,0));
  end;
  if iGetTag(MDBS.CMD.CLOSE.tag)<>0 then begin
   bNul(iSetTag(MDBS.CMD.CLOSE.tag,0));
   MenuCloseStarter;
  end;
  {
  Handle Smile
  }
  if SysTimer_Pulse(SmilePeriod)>0 then begin
   errors:=GetErrCount(-2);
   if errors>MDBS.CMD.SMILE.val then bNul(iSetTag(MDBS.CMD.SMILE.tag,2)) else
   if iGetTag(MDBS.CMD.SMILE.tag)>1 then bNul(iSetTag(MDBS.CMD.SMILE.tag,1));
   MDBS.CMD.SMILE.val:=errors;
  end;
  {
  Calculate ADAM rate
  }
  if SysTimer_Pulse(RatePeriod)>0 then AdamTraffic(ParamStr('AdamTraffic'),mSecNow);
  {
  Edit tags...
  }
  if EditStateDone then begin
   {
   Menu CLOSE.
   }
   MenuCloseHandler;
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end;
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  {
  Handle left button clicks...
  }
  if ClickButton=1 then begin
   {
   Toolbar buttons
   }
   ClickBitXorLocal(MDBS.CMD.HELP.tag,1);
   ClickBitXorLocal(MDBS.CMD.OPEN.tag,1);
   ClickBitXorLocal(MDBS.CMD.SAVE.tag,1);
   ClickBitXorLocal(MDBS.CMD.ZERO.tag,1);
   ClickBitXorLocal(MDBS.CMD.TOOLS.tag,1);
   ClickBitXorLocal(MDBS.CMD.CLOSE.tag,1);
   {
   Smile face button...
   }
   if ClickTag=MDBS.CMD.SMILE.tag then begin
    bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
    bNul(iSetTag(MDBS.CMD.SMILE.tag,0));
    bNul(Voice(snd_Click));
   end;
   {
   Plot & Tab windows
   }
   ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
   if ClickCurve<>0 then SelectWinByCurve(ClickCurve);
   {
   User utilities: @Name
   }
   if Pos('@MOD',ClickSensor)=1 then begin
    DevSendCmd(devModbusSrv,ClickSensor);
    bNul(Voice(snd_Click));
   end;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  MDBS_INIT;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  MDBS_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  MDBS_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; n:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
