 {
 ***********************************************************************
 OVRTRIGGER - main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Cmd.LoadIni           - load params from INI.
| @Cmd.SaveIni           - save params to   INI.
| @AssignTag t v         - assign value v to tag t.
|********************************************************
[]
 }
program ovrtrigger;              { OverRange Trigger program        }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 ai_CurrValue      = 0;          { AI - current value               }
 do_Trigger        = 0;          { DO - trigger value               }

type
 TTagRef   = record tag,nai,nao,ndi,ndo:Integer; val:Real; end;
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 OVRTRIGGER        : record      { All OvrTrigger data              }
  State            : TTagRef;    { Trigger state                    }
  Start            : TTagRef;    { Start button                     }
  Formula          : TTagRef;    { Formula                          }
  Command1         : TTagRef;    { Command 1                        }
  Command2         : TTagRef;    { Command 2                        }
  Command3         : TTagRef;    { Command 3                        }
  Period           : TTagRef;    { Period, sec                      }
  SaveIni          : TTagRef;    { Save INI file                    }
  LoadIni          : TTagRef;    { Load INI file                    }
  X0,Y0,T0         : TTagRef;    { Start value of X,Y,Time          }
 end;                            {                                  }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var nv:Integer;
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Find comma separated window list where curve is inside.
 }
 function ListWinByCurve(crv:Integer):String;
 var list,win:String; n,m,i,j,t,c:Integer;
 begin
  list:=''; win:='';
  if not IsEmptyStr(CrvName(crv)) then for m:=1 to 2 do begin
   n:=0;
   repeat
    c:=0;
    win:=ParamStr(ExtractWord(m,'CURWINNAME,TABWINNAME')+' '+Str(n)); n:=n+1;
    if not IsEmptyStr(win) then begin
     t:=ReadIniSection(Text_New,16+8+4+1,'', StrAddBrackets(win,'[',']'));
     for i:=0 to Text_NumLn(t)-1 do
     if IsSameText(ExtractWord(1,Text_GetLn(t,i)),'CurveList') then
     for j:=2 to WordCount(Text_GetLn(t,i)) do
     if IsSameText(ExtractWord(j,Text_GetLn(t,i)),CrvName(crv)) then c:=c+1;
     bNul(Text_Free(t));
     if c>0 then
     if IsEmptyStr(list) then list:=win else list:=list+','+Trim(win);
    end;
   until IsEmptyStr(win);
  end;
  ListWinByCurve:=list;
  list:=''; win:='';
 end;
 {
 Select windows where curve is inside.
 }
 procedure SelectWinByCurve(crv:Integer);
 var list:String; i:Integer;
 begin
  list:='';
  list:=ListWinByCurve(crv);
  for i:=1 to WordCountDelims(list,Dump(',')) do begin
   bNul(WinSelect(ExtractWordDelims(i,list,Dump(','))));
   bNul(WinDraw(ExtractWordDelims(i,list,Dump(','))+'|SelectCurve='+CrvName(crv)));
  end;
  list:='';
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  if Length(s)>0 then begin
   InfoBox(s);
   Speak(s);
  end;
 end;
 {
 Evaluate tag by expression.
 }
 procedure EvalTag(tag:Integer; expr:String);
 var r:Real;
 begin
  if TypeTag(tag)>0 then begin
   r:=eval(expr);
   if IsNan(r) or IsInf(r) then Trouble(NameTag(tag)+' eval bug: '+expr) else
   if TypeTag(tag)=1 then bNul(iSetTag(tag,Trunc(r))) else
   if TypeTag(tag)=2 then bNul(rSetTag(tag,r)) else
   if TypeTag(tag)=3 then bNul(sSetTag(tag,Str(r)));
  end; 
 end;
 {
 OVRTRIGGER clear strings
 }
 procedure OVRTRIGGER_CLEAR;
 begin
 end;
 {
 OVRTRIGGER initialization
 }
 procedure OVRTRIGGER_INIT;
 begin  
  {
  Initialize tags & devices...
  }
  InitTag(OVRTRIGGER.X0.tag,       ReadIni('tagTrigger')+'.X0',        2);
  InitTag(OVRTRIGGER.Y0.tag,       ReadIni('tagTrigger')+'.Y0',        2);
  InitTag(OVRTRIGGER.T0.tag,       ReadIni('tagTrigger')+'.T0',        2);
  InitTag(OVRTRIGGER.STATE.tag,    ReadIni('tagTrigger')+'.STATE',     1);
  InitTag(OVRTRIGGER.START.tag,    ReadIni('tagTrigger')+'.START',     1);
  InitTag(OVRTRIGGER.PERIOD.tag,   ReadIni('tagTrigger')+'.PERIOD',    1);
  InitTag(OVRTRIGGER.SAVEINI.tag,  ReadIni('tagTrigger')+'.SAVEINI',   1);
  InitTag(OVRTRIGGER.LOADINI.tag,  ReadIni('tagTrigger')+'.LOADINI',   1);
  InitTag(OVRTRIGGER.FORMULA.tag,  ReadIni('tagTrigger')+'.FORMULA',   3);
  InitTag(OVRTRIGGER.COMMAND1.tag, ReadIni('tagTrigger')+'.COMMAND1',  3);
  InitTag(OVRTRIGGER.COMMAND2.tag, ReadIni('tagTrigger')+'.COMMAND2',  3);
  InitTag(OVRTRIGGER.COMMAND3.tag, ReadIni('tagTrigger')+'.COMMAND3',  3);
  {
  Initialize values
  }
  OVRTRIGGER.START.val:=0;
  OVRTRIGGER.PERIOD.val:=0;
  bNul(iSetTag(OVRTRIGGER.STATE.tag,0));
  bNul(iSetTag(OVRTRIGGER.START.tag,0));
  bNul(rSetTag(OVRTRIGGER.X0.tag,0));
  bNul(rSetTag(OVRTRIGGER.Y0.tag,0));
  bNul(rSetTag(OVRTRIGGER.T0.tag,0));
 end;
 {
 OVRTRIGGER finalization
 }
 procedure OVRTRIGGER_FREE;
 begin
 end;
 {
 OVRTRIGGER polling
 }
 procedure OVRTRIGGER_POLL;
 var ClickCurve:Integer; s:string; t,y,y0:Real; trig:Boolean;
 begin
  s:='';
  {
  If start pressed, check trigger.
  }
  if OVRTRIGGER.START.val<>0 then begin
   y:=GetAi_Yn(ai_CurrValue);
   bNul(evar('y',y));
   bNul(evar('x0',rGetTag(OVRTRIGGER.X0.tag)));
   bNul(evar('y0',rGetTag(OVRTRIGGER.Y0.tag)));
   bNul(evar('t0',rGetTag(OVRTRIGGER.T0.tag)));
   t:=Eval(sGetTag(OVRTRIGGER.Formula.tag));
   trig:=not IsNan(t) and not IsInf(t) and (t<>0);
   bNul(iSetTag(OVRTRIGGER.STATE.tag,Ord(trig)));
   UpdateDo(do_Trigger,time,Ord(trig));
   if trig then begin
    if mSecNow>OVRTRIGGER.PERIOD.val+iGetTag(OVRTRIGGER.PERIOD.tag)*1000 then begin
     OVRTRIGGER.PERIOD.val:=mSecNow;
     Cron(sGetTag(OVRTRIGGER.Command1.tag));
     Cron(sGetTag(OVRTRIGGER.Command2.tag));
     Cron(sGetTag(OVRTRIGGER.Command3.tag));
    end;
   end;
  end else begin
   bNul(iSetTag(OVRTRIGGER.STATE.tag,0));
   UpdateDo(do_Trigger,time,0);
  end;
  {
  Execute GUI commands
  }
  if iGetTag(OVRTRIGGER.START.tag)<>OVRTRIGGER.START.val then begin
   OVRTRIGGER.START.val:=iGetTag(OVRTRIGGER.START.tag);
   if OVRTRIGGER.START.val<>0 then begin   // On Start remember X,Y,T value
    bNul(rSetTag(OVRTRIGGER.X0.tag,GetAi_Xn(ai_CurrValue)));
    bNul(rSetTag(OVRTRIGGER.Y0.tag,GetAi_Yn(ai_CurrValue)));
    bNul(rSetTag(OVRTRIGGER.T0.tag,Time));
   end else begin                          // On Stop clear X,Y,T value
    bNul(iSetTag(OVRTRIGGER.STATE.tag,0));
    bNul(rSetTag(OVRTRIGGER.X0.tag,0));
    bNul(rSetTag(OVRTRIGGER.Y0.tag,0));
    bNul(rSetTag(OVRTRIGGER.T0.tag,0));
   end;
  end;
  if iGetTag(OVRTRIGGER.SAVEINI.tag)<>0 then  begin
   bNul(iSetTag(OVRTRIGGER.SAVEINI.tag,0));
   DevSendCmdLocal('@Cmd.SaveIni');
  end;
  if iGetTag(OVRTRIGGER.LOADINI.tag)<>0 then  begin
   bNul(iSetTag(OVRTRIGGER.LOADINI.tag,0));
   DevSendCmdLocal('@Cmd.LoadIni');
  end;
  {
  Edit tags...
  }
  if EditStateDone then begin
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
   {
   Edit Formulas
   }
   CheckEditTagUpdate(OVRTRIGGER.Period.tag,1,3600);
   CheckEditTagUpdate(OVRTRIGGER.Formula.tag,_MinusInf,_PlusInf);
   CheckEditTagUpdate(OVRTRIGGER.Command1.tag,_MinusInf,_PlusInf);
   CheckEditTagUpdate(OVRTRIGGER.Command2.tag,_MinusInf,_PlusInf);
   CheckEditTagUpdate(OVRTRIGGER.Command3.tag,_MinusInf,_PlusInf);
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end;
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  {
  Handle left button clicks...
  }
  if ClickButton=1 then begin
   {
   Buttons
   }
   ClickBitXorLocal(OVRTRIGGER.START.tag,1);
   ClickBitXorLocal(OVRTRIGGER.SAVEINI.tag,1);
   ClickBitXorLocal(OVRTRIGGER.LOADINI.tag,1);
   {
   Edit params
   }
   s:=SetFormUnderSensorLeftBottom(ClickParams(''));
   if ClickTag=OVRTRIGGER.Period.tag then StartEditTagEx(ClickTag,URL_Decode(ClickParams('Hint')),s);
   if ClickTag=OVRTRIGGER.Formula.tag then StartEditTagEx(ClickTag,URL_Decode(ClickParams('Hint')),s);
   if ClickTag=OVRTRIGGER.Command1.tag then StartEditTagEx(ClickTag,URL_Decode(ClickParams('Hint')),s);
   if ClickTag=OVRTRIGGER.Command2.tag then StartEditTagEx(ClickTag,URL_Decode(ClickParams('Hint')),s);
   if ClickTag=OVRTRIGGER.Command3.tag then StartEditTagEx(ClickTag,URL_Decode(ClickParams('Hint')),s);
   {
   Plot & Tab windows
   }
   ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
   if ClickCurve<>0 then SelectWinByCurve(ClickCurve);
  end;
  {
  Handle right button clicks...
  }
  if ClickButton=2 then begin
   SensorHelp(Url_Decode(ClickParams('Hint')));
  end;
  s:='';
 end;
 
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  OVRTRIGGER_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  OVRTRIGGER_INIT;
  RunStartupScript;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRw('R','',2));
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
  RunFinallyScript;
  OVRTRIGGER_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  OVRTRIGGER_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; n,tag,crv:Integer; r,a,b:Real;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Cmd.LoadIni
   }
   if IsSameText(cmd,'@Cmd.LoadIni') then begin
    iNul(CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @Cmd.SaveIni
   }
   if IsSameText(cmd,'@Cmd.SaveIni') then begin
    iNul(CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @AssignTag TRIGGER.START 0
   }
   if IsSameText(cmd,'@AssignTag') then begin
    tag:=FindTag(ExtractWord(1,arg));
    if TypeTag(tag)>0 then UpdateTag(tag,Trim(SkipWords(1,arg)),_MinusInf,_PlusInf);
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
