@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem ******************************
rem INTEK devices config generator
rem ******************************

chcp 65001 >nul & REM Set charset UTF-8

:Main
call :InitializeVariables
pushd "%~dp0" && call :INTEKDevices
popd
goto :EOF

:InitializeVariables
set hdwcfg=%~n0_hdw.cfg
set simcfg=%~n0_sim.cfg
set /a numhdwcfg=0
set /a CTRL_TOP=0
set /a CTRL_LEFT=450
set /a CTRL_TOP_STEP=80
goto :EOF

:INTEKDevices
call :DeleteFiles %hdwcfg% %simcfg%
rem  Device  Facility Identitier Port UnitId Polling
call :INTEK  INTEK    DRV01      1    247    10
call :INTEK  INTEK    DRV02      1    246    10
type %hdwcfg% %simcfg%
goto :EOF

:INTEK
call :INTEK_HDW %* >> %hdwcfg%
call :INTEK_SIM %* >> %simcfg%
set /a CTRL_TOP+=CTRL_TOP_STEP
goto :EOF

:INTEK_HDW
set FN=%~1&shift
set IDEN=%~1&shift
set ModbusPort=%~1&shift
set ModbusUnitId=%~1&shift
set ModbusPolling=%~1&shift
echo ;**********************************************************
echo ; %FN% Driver for INTSIEK HVPS (High Voltage Power Supply)
echo ;**********************************************************
echo [DeviceList]
echo ^&%FN%.%IDEN%.CTRL = device software program
echo [^&%FN%.%IDEN%.CTRL]
echo Comment        = MODBUS RTU DRIVER FOR INTSIEK HIGH VOLTAGE POWER SUPPLY.
echo InquiryPeriod  = 0
echo DevicePolling  = 10, tpHigher
echo ProgramSource  = ..\DaqPas\intek_drv.pas
echo DigitalFifo    = 1024
echo AnalogFifo     = 1024
echo DebugFlags     = 3
echo OpenConsole    = 2
echo Simulator      = 0
echo ModbusPort     = %ModbusPort%
echo ModbusUnitId   = %ModbusUnitId%
echo ModbusTimeout  = 1000
echo ModbusDeadline = 60000
echo ModbusPolling  = %ModbusPolling%
echo DelayOnStart   = 1000
echo tagPrefix      = %FN%.%IDEN%
echo AnalogOutputs  = 10
echo Link AnalogOutput  0  with curve %FN%.%IDEN%.ADDRESS       ; Source address (modbus)
echo Link AnalogOutput  1  with curve %FN%.%IDEN%.CMDCTRL       ; Control instructions register
echo Link AnalogOutput  2  with curve %FN%.%IDEN%.DIAGNOS       ; Source diagnostics
echo Link AnalogOutput  3  with curve %FN%.%IDEN%.ACPTCNT       ; Accept packet counter
echo Link AnalogOutput  4  with curve %FN%.%IDEN%.FLPTCNT       ; Fault  packet counter
echo Link AnalogOutput  5  with curve %FN%.%IDEN%.MEAS.CURR     ; Current measure
echo Link AnalogOutput  6  with curve %FN%.%IDEN%.MEAS.VOLT     ; Voltage measure
echo Link AnalogOutput  7  with curve %FN%.%IDEN%.SET.VOLT      ; Setting voltage stabilization
echo Link AnalogOutput  8  with curve %FN%.%IDEN%.SET.CURR      ; Output current limitation
echo Link AnalogOutput  9  with curve %FN%.%IDEN%.SET.CTRL      ; Source control register
echo DigitalOutputs = 8
echo Link DigitalOutput 0 with curve %FN%.%IDEN%.STATE.INDIC history 1000
echo Link DigitalOutput 1 with curve %FN%.%IDEN%.POLLRATE.RX history 1000
echo Link DigitalOutput 2 with curve %FN%.%IDEN%.POLLRATE.TX history 1000
echo Link DigitalOutput 3 with curve %FN%.%IDEN%.POLLRATE.EX history 1000
echo Link DigitalOutput 4 with curve %FN%.%IDEN%.ERROR.COUNT history 1000
echo Link DigitalOutput 5 with curve %FN%.%IDEN%.POLLSUMM.RX history 1000
echo Link DigitalOutput 6 with curve %FN%.%IDEN%.POLLSUMM.TX history 1000
echo Link DigitalOutput 7 with curve %FN%.%IDEN%.POLLSUMM.EX history 1000
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [%IDEN%.CustomParameters.TagList]
echo CustomIniFileRef  = ..\..\%FN%_DATA\%IDEN%_Custom.ini
echo CustomIniSection  = [%IDEN%.CustomParameters]
echo CustomIniBackups  = ..\..\%FN%_DATA\Custom
echo CustomIniAutoLoad = 1
echo CustomIniAutoSave = 0
echo []
echo [ConfigFileList]
echo ConfigFile = ..\..\%FN%_DATA\%IDEN%_Custom.ini
echo []
echo.
echo [TagList]
echo %FN%.%IDEN%.ADDRESS     = integer 0  ; Reg1   - Текущий сетевой адрес: 0-247
echo %FN%.%IDEN%.CMDCTRL     = integer 0  ; Reg6   - Команды управления: 0x1111(hex) = 4369(dec) - Запись адреса. SYS.CMD
echo %FN%.%IDEN%.DIAGNOS     = integer 0  ; Reg7   - Диагностика контроллера: Бит8="1"- ош. КС Eeprom, Бит9="1"- ош. КС Flash
echo %FN%.%IDEN%.ACPTCNT     = integer 0  ; Reg8   - Счетчик принятых пакетов
echo %FN%.%IDEN%.FLPTCNT     = integer 0  ; Reg9   - Счетчик сбойных пакетов
echo %FN%.%IDEN%.MEAS.CURR   = real    0  ; Reg37  - Измерение выходного тока. Единица: 1 мА.
echo %FN%.%IDEN%.MEAS.VOLT   = real    0  ; Reg38  - Измерение выходного напряжения. Единица: 0.1 кВ.
echo %FN%.%IDEN%.SET.VOLT    = real    0  ; Reg54  - Уставка стабилизации выходного напряжения. Единица: 0.1 кВ.
echo %FN%.%IDEN%.SET.CURR    = real    0  ; Reg55  - Уставка ограничения выходного тока. Единица: 0.01 мА.
echo %FN%.%IDEN%.SET.CTRL    = integer 0  ; Reg100 - Регистр управления источником. Битовое поле. SRC.CTRL
echo %FN%.%IDEN%.POLL.ENABLE = integer 1  ; Enable poll cycle
echo %FN%.%IDEN%.CMD.HELP    = integer 0  ; Command to call Help
echo %FN%.%IDEN%.CMD.SAVEINI = integer 0  ; Command to save INI file
echo %FN%.%IDEN%.CMD.LOADINI = integer 0  ; Command to load INI file
echo %FN%.%IDEN%.CMD.CONSOLE = integer 0  ; Command to open CONSOLE window
echo %FN%.%IDEN%.CMD.TOOLS   = integer 0  ; Command to call TOOLS menu
echo []
echo [DataStorage]
echo %FN%.%IDEN%.ADDRESS     = Curve 0 10 Black  15 1  ; Source address (modbus)
echo %FN%.%IDEN%.CMDCTRL     = Curve 0 10 Black  15 1  ; Control instructions register
echo %FN%.%IDEN%.DIAGNOS     = Curve 0 10 Black  15 1  ; Source diagnostics
echo %FN%.%IDEN%.ACPTCNT     = Curve 0 10 Black  15 1  ; Accept packet counter
echo %FN%.%IDEN%.FLPTCNT     = Curve 0 10 Black  15 1  ; Fault  packet counter
echo %FN%.%IDEN%.MEAS.CURR   = Curve 0 10 Black  15 1  ; Current measure
echo %FN%.%IDEN%.MEAS.VOLT   = Curve 0 10 Black  15 1  ; Voltage measure
echo %FN%.%IDEN%.SET.VOLT    = Curve 0 10 Black  15 1  ; Setting voltage stabilization
echo %FN%.%IDEN%.SET.CURR    = Curve 0 10 Black  15 1  ; Output current limitation
echo %FN%.%IDEN%.SET.CTRL    = Curve 0 10 Black  15 1  ; Source control register
echo %FN%.%IDEN%.STATE.INDIC = Curve 0 10 Black  15 1  ;
echo %FN%.%IDEN%.POLLRATE.RX = Curve 0 10 Black  15 1  ; Poll rate, receiver    (per sec)
echo %FN%.%IDEN%.POLLRATE.TX = Curve 0 10 Black  15 1  ; Poll rate, transmitter (per sec)
echo %FN%.%IDEN%.POLLRATE.EX = Curve 0 10 Black  15 1  ; Poll rate, errors      (per sec)
echo %FN%.%IDEN%.ERROR.COUNT = Curve 0 10 Black  15 1  ; Error counter          (counter)
echo %FN%.%IDEN%.POLLSUMM.RX = Curve 0 10 Black  15 1  ; Poll summ, receiver    (counter)
echo %FN%.%IDEN%.POLLSUMM.TX = Curve 0 10 Black  15 1  ; Poll summ, transmitter (counter)
echo %FN%.%IDEN%.POLLSUMM.EX = Curve 0 10 Black  15 1  ; Poll summ, errors      (counter)
echo []
echo.
echo [Windows]
echo %FN%.%IDEN%.PARAM = Circuit_Window
echo [%FN%.%IDEN%.PARAM]
echo Circuit = ..\Circuits\intek_param_ctrl.crc
echo Link sensor %FN%.PAR.ADDRESS   with curve %FN%.%IDEN%.ADDRESS     device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.PAR.CMDCTRL   with curve %FN%.%IDEN%.CMDCTRL     device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.PAR.ACPTCNT   with curve %FN%.%IDEN%.ACPTCNT     device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.PAR.FLPTCNT   with curve %FN%.%IDEN%.FLPTCNT     device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.PAR.MEAS.CURR with curve %FN%.%IDEN%.MEAS.CURR   device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.PAR.MEAS.VOLT with curve %FN%.%IDEN%.MEAS.VOLT   device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.PAR.SET.VOLT  with tag   %FN%.%IDEN%.SET.VOLT    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.PAR.SET.CURR  with tag   %FN%.%IDEN%.SET.CURR    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.PAR.SET.ADDR  with tag   %FN%.%IDEN%.ADDRESS     device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.RESET.ACPTCNT with tag   %FN%.%IDEN%.ACPTCNT     device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.RESET.FLPTCNT with tag   %FN%.%IDEN%.FLPTCNT     device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.0    with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.1    with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.2    with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.3    with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.4    with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.5    with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.6    with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.7    with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.8    with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.9    with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.10   with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.11   with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.12   with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.13   with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.14   with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SRC.CTRL.15   with curve %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.CMD.POWERON   with tag   %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.CMD.SAVEROM   with tag   %FN%.%IDEN%.CMDCTRL     device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.CMD.RESTART   with tag   %FN%.%IDEN%.CMDCTRL     device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.CMD.SETPROM   with tag   %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.CMD.RESET     with tag   %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.CMD.HELP      with tag   %FN%.%IDEN%.CMD.HELP    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.CMD.SAVEINI   with tag   %FN%.%IDEN%.CMD.SAVEINI device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.CMD.LOADINI   with tag   %FN%.%IDEN%.CMD.LOADINI device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.CMD.CONSOLE   with tag   %FN%.%IDEN%.CMD.CONSOLE device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.CMD.TOOLS     with tag   %FN%.%IDEN%.CMD.TOOLS   device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.POLL.ENABLE   with tag   %FN%.%IDEN%.POLL.ENABLE device ^&%FN%.%IDEN%.CTRL  ;
echo Link sensor %FN%.POLLRATE.RX   with curve %FN%.%IDEN%.POLLRATE.RX device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.POLLRATE.TX   with curve %FN%.%IDEN%.POLLRATE.TX device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.POLLRATE.EX   with curve %FN%.%IDEN%.POLLRATE.EX device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.POLLSUMM.EX   with curve %FN%.%IDEN%.POLLSUMM.EX device ^&%FN%.%IDEN%.CTRL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%IDEN%.PARAM.HOME 0 0 0
echo @cron.job %FN%.%IDEN%.PARAM.HOME @WinShow %FN%.%IDEN%.PARAM
echo @cron.job %FN%.%IDEN%.PARAM.HOME @WinDraw %FN%.%IDEN%.PARAM^|Left=%CTRL_LEFT%^|Top=%CTRL_TOP%^|Width=710^|Height=320
echo @cron.job %FN%.%IDEN%.PARAM.HOME @WinDraw %FN%.%IDEN%.PARAM^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%IDEN%.PARAM.HOME @WinDraw %FN%.%IDEN%.PARAM^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%IDEN%.PARAM.SHOW 0 0 0
echo @cron.job %FN%.%IDEN%.PARAM.SHOW @WinShow %FN%.%IDEN%.PARAM
echo @cron.tab %FN%.%IDEN%.PARAM.HIDE 0 0 0
echo @cron.job %FN%.%IDEN%.PARAM.HIDE @WinHide %FN%.%IDEN%.PARAM
echo @cron.tab %FN%.%IDEN%.PARAM.SELECT 0 0 0
echo @cron.job %FN%.%IDEN%.PARAM.SELECT @WinSelect %FN%.%IDEN%.PARAM
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%IDEN%.PARAM.HOME
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%IDEN%.PARAM.HIDE
echo []
echo.
echo [Windows]
echo %FN%.%IDEN%.CTRL = Circuit_Window
echo [%FN%.%IDEN%.CTRL]
echo Circuit = ..\Circuits\intek_ctrl.crc
echo Link sensor %FN%.PARAM       with tag   %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.POLL.RATE   with curve %FN%.%IDEN%.POLLRATE.TX device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.POLL.ENABLE with tag   %FN%.%IDEN%.POLL.ENABLE device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.POWER.STAT  with tag   %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.CMD.POWERON with tag   %FN%.%IDEN%.SET.CTRL    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.MEAS.CURR   with curve %FN%.%IDEN%.MEAS.CURR   device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.MEAS.VOLT   with curve %FN%.%IDEN%.MEAS.VOLT   device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SET.VOLT    with tag   %FN%.%IDEN%.SET.VOLT    device ^&%FN%.%IDEN%.CTRL
echo Link sensor %FN%.SET.CURR    with tag   %FN%.%IDEN%.SET.CURR    device ^&%FN%.%IDEN%.CTRL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%IDEN%.CTRL.HOME 0 0 0
echo @cron.job %FN%.%IDEN%.CTRL.HOME @WinShow %FN%.%IDEN%.CTRL
echo @cron.job %FN%.%IDEN%.CTRL.HOME @WinDraw %FN%.%IDEN%.CTRL^|Left=%CTRL_LEFT%^|Top=%CTRL_TOP%^|Width=475^|Height=340
echo @cron.job %FN%.%IDEN%.CTRL.HOME @WinDraw %FN%.%IDEN%.CTRL^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%IDEN%.CTRL.HOME @WinDraw %FN%.%IDEN%.CTRL^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%IDEN%.CTRL.SHOW 0 0 0
echo @cron.job %FN%.%IDEN%.CTRL.SHOW @WinShow %FN%.%IDEN%.CTRL
echo @cron.tab %FN%.%IDEN%.CTRL.HIDE 0 0 0
echo @cron.job %FN%.%IDEN%.CTRL.HIDE @WinHide %FN%.%IDEN%.CTRL
echo @cron.tab %FN%.%IDEN%.CTRL.SELECT 0 0 0
echo @cron.job %FN%.%IDEN%.CTRL.SELECT @WinSelect %FN%.%IDEN%.CTRL
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%IDEN%.CTRL.HOME
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%IDEN%.CTRL.HIDE
echo []
echo.
echo [Windows]
echo %FN%.%IDEN%.PARAM.PLOT = Curve_Window
echo [%FN%.%IDEN%.PARAM.PLOT]
echo AxisX = ^^R{Часов}___^^N^^CВремя, 0, 0.25
echo AxisY = ^^CСостояние_каналов^^N^^L___{Статус}, 0, 1000
echo CurveList = %FN%.%IDEN%.ADDRESS
echo CurveList = %FN%.%IDEN%.CMDCTRL
echo CurveList = %FN%.%IDEN%.DIAGNOS
echo CurveList = %FN%.%IDEN%.ACPTCNT
echo CurveList = %FN%.%IDEN%.FLPTCNT
echo CurveList = %FN%.%IDEN%.MEAS.CURR
echo CurveList = %FN%.%IDEN%.MEAS.VOLT
echo CurveList = %FN%.%IDEN%.SET.VOLT
echo CurveList = %FN%.%IDEN%.SET.CURR
echo CurveList = %FN%.%IDEN%.SET.CTRL
echo CurveList = %FN%.%IDEN%.POLLRATE.RX
echo CurveList = %FN%.%IDEN%.POLLRATE.TX
echo CurveList = %FN%.%IDEN%.POLLRATE.EX
echo CurveList = %FN%.%IDEN%.STATE.INDIC
echo CurveList = %FN%.%IDEN%.ERROR.COUNT
echo CurveList = %FN%.%IDEN%.POLLSUMM.RX
echo CurveList = %FN%.%IDEN%.POLLSUMM.TX
echo CurveList = %FN%.%IDEN%.POLLSUMM.EX
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%IDEN%.PARAM.PLOT.HOME 0 0 0
echo @cron.job %FN%.%IDEN%.PARAM.PLOT.HOME @WinShow %FN%.%IDEN%.PARAM.PLOT
echo @cron.job %FN%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%IDEN%.PARAM.PLOT^|Left=167^|Top=120^|Height=600^|Width=1000
echo @cron.job %FN%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%IDEN%.PARAM.PLOT^|Options=-Min,-Max,+Close,+VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%IDEN%.PARAM.PLOT^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%IDEN%.PARAM.PLOT.SHOW 0 0 0
echo @cron.job %FN%.%IDEN%.PARAM.PLOT.SHOW @WinShow %FN%.%IDEN%.PARAM.PLOT
echo @cron.tab %FN%.%IDEN%.PARAM.PLOT.HIDE 0 0 0
echo @cron.job %FN%.%IDEN%.PARAM.PLOT.HIDE @WinHide %FN%.%IDEN%.PARAM.PLOT
echo @cron.tab %FN%.%IDEN%.PARAM.PLOT.SELECT 0 0 0
echo @cron.job %FN%.%IDEN%.PARAM.PLOT.SELECT @WinSelect %FN%.%IDEN%.PARAM.PLOT
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%IDEN%.PARAM.PLOT.HOME
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%IDEN%.PARAM.PLOT.HIDE
echo []
echo.
echo [%FN%.MAIN.CTRL]
echo Link sensor %FN%.%IDEN%.CTRL  with                             device ^&%FN%.MAIN.CTRL
echo Link sensor %FN%.%IDEN%.VALUE with curve %FN%.%IDEN%.MEAS.VOLT device ^&%FN%.MAIN.CTRL
echo []
echo.
echo [^&DATSRV]
echo CurveList = %FN%.%IDEN%.ADDRESS
echo CurveList = %FN%.%IDEN%.CMDCTRL
echo CurveList = %FN%.%IDEN%.DIAGNOS
echo CurveList = %FN%.%IDEN%.ACPTCNT
echo CurveList = %FN%.%IDEN%.FLPTCNT
echo CurveList = %FN%.%IDEN%.MEAS.CURR
echo CurveList = %FN%.%IDEN%.MEAS.VOLT
echo CurveList = %FN%.%IDEN%.SET.VOLT
echo CurveList = %FN%.%IDEN%.SET.CURR
echo CurveList = %FN%.%IDEN%.SET.CTRL
echo CurveList = %FN%.%IDEN%.POLLRATE.RX
echo CurveList = %FN%.%IDEN%.POLLRATE.TX
echo CurveList = %FN%.%IDEN%.POLLRATE.EX
echo CurveList = %FN%.%IDEN%.STATE.INDIC
echo CurveList = %FN%.%IDEN%.ERROR.COUNT
echo CurveList = %FN%.%IDEN%.POLLSUMM.RX
echo CurveList = %FN%.%IDEN%.POLLSUMM.TX
echo CurveList = %FN%.%IDEN%.POLLSUMM.EX
echo []
echo.
echo [%IDEN%.CustomParameters.TagList]
echo TagList = %FN%.%IDEN%.POLL.ENABLE
echo TagList = %FN%.%IDEN%.SET.VOLT,%FN%.%IDEN%.SET.CURR,%FN%.%IDEN%.SET.CTRL
echo []
goto :EOF

:INTEK_SIM
echo [^&%FN%.%IDEN%.CTRL]
echo Simulator = 1
echo []
echo.
rem Include hardware config if one not done yet
if "%numhdwcfg%" == "0" ( set /a numhdwcfg=numhdwcfg+1 ) else ( goto :EOF )
echo [ConfigFileList]
echo ConfigFile = %hdwcfg%
echo []
echo.
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
