 {
 ***********************************************************************
 Daq Pascal application program IMG_drv.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Unit n - Change measure unit, where n: 0 - mbar, 1 - Torr, 2 - Pascal, 3 - Micron, 4 -hPa
| @SMF1 n - Change sensor measuring filter, channel 1, where n: 0 - none, 1 - fast, 2 - Normal, 3 - slow
| @SMF2 n - Change sensor measuring filter, channel 2, where n: 0 - none, 1 - fast, 2 - Normal, 3 - slow
| @SMF3 n - Change sensor measuring filter, channel 3, where n: 0 - none, 1 - fast, 2 - Normal, 3 - slow
| @SMF4 n - Change sensor measuring filter, channel 4, where n: 0 - none, 1 - fast, 2 - Normal, 3 - slow
| @SGC1 n - Change gas coefficient, channel 1, where n: 0 - none, 1 - Ar, 2 - H2, 3 - He, 4 - Ne, 5 - Kr, 6 - Xe, 7 - CO2
| @SGC2 n - Change gas coefficient, channel 2, where n: 0 - none, 1 - Ar, 2 - H2, 3 - He, 4 - Ne, 5 - Kr, 6 - Xe, 7 - CO2
| @SGC3 n - Change gas coefficient, channel 3, where n: 0 - none, 1 - Ar, 2 - H2, 3 - He, 4 - Ne, 5 - Kr, 6 - Xe, 7 - CO2
| @SGC4 n - Change gas coefficient, channel 4, where n: 0 - none, 1 - Ar, 2 - H2, 3 - He, 4 - Ne, 5 - Kr, 6 - Xe, 7 - CO2
| @DGS n  - Switch degassing stasus, where n: 0 - degassing off, 1 - degassing on
| @EMI1 n - Switch on/off the emission,channel 1, where n: 0 - emission off, 1 - emission on
| @EMI2 n - Switch on/off the emission,channel 2, where n: 0 - emission off, 1 - emission on
| @RST    - Reset the device
|********************************************************
[]
 }
program IMG_drv;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 st_NoReq           = 0;         { Status : No request sent         }
 st_WaitAns         = 1;         { Status : Waiting answer          }
 st_WaitGap         = 2;         { Status : Waiting time gap        }
 st_TimeOut         = 3;         { Status : TimeOut found           }
 cm_PRS1            = 1;         {                                  }
 cm_PRS2            = 2;         {                                  }
 cm_PRS3            = 3;         {                                  }
 cm_PRS4            = 4;         {                                  }
 cm_GDE             = 5;         {                                  }
 cm_DGS_read        = 6;         {                                  }
 cm_DGS_write       = 7;         {                                  }
 cm_SGC_read_1      = 8;         {                                  }
 cm_SGC_read_2      = 9;         {                                  }
 cm_SGC_read_3      = 10;        {                                  }
 cm_SGC_read_4      = 11;        {                                  }
 cm_STI_read_1      = 12;        {                                  }
 cm_STI_read_2      = 13;        {                                  }
 cm_STI_read_3      = 14;        {                                  }
 cm_STI_read_4      = 15;        {                                  }
 cm_UNI_read        = 16;        {                                  }
 cm_UNI_write       = 17;        {                                  }
 cm_SGC_write_1     = 18;        {                                  }
 cm_SGC_write_2     = 19;        {                                  }
 cm_SGC_write_3     = 20;        {                                  }
 cm_SGC_write_4     = 21;        {                                  }
 cm_SMF_read_1      = 22;        {                                  }
 cm_SMF_read_2      = 23;        {                                  }
 cm_SMF_read_3      = 24;        {                                  }
 cm_SMF_read_4      = 25;        {                                  }
 cm_SMF_write_1     = 26;        {                                  }
 cm_SMF_write_2     = 27;        {                                  }
 cm_SMF_write_3     = 28;        {                                  }
 cm_SMF_write_4     = 29;        {                                  }
 cm_RESET           = 30;        {                                  }
 cm_EMI_read_1      = 31;        {                                  }
 cm_EMI_read_2      = 32;        {                                  }
 cm_EMI_write_1     = 33;        {                                  }
 cm_EMI_write_2     = 34;        {                                  }
 MaxCmdNum          = 34;        { Max command id number            }
 DelayOnStart       = 1000;      { Delay before start polling       }
 ao_POLLRATE_TX     = 4;         {                                  }
 ao_POLLRATE_RX     = 5;         {                                  }

type
 TTagRef = record tag,nai,ndi,nao,ndo:Integer; val,dat:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 IMG               : record      { IMG data                         }
  Simulator        : Boolean;    { Simulator or Driver mode         }
  CmdReqENQ        : Boolean;    { Require ENQ char                 }
  COM              : record      { COM port data                    }
   Port            : Integer;    {  Port number                     }
   Status          : Integer;    {  Status flag                     }
   TimeOut         : Integer;    {  TimeOut, ms                     }
   TimeGap         : Integer;    {  Time delay after poll, ms       }
   Req,Ans,Buf     : String;     {  Request, Answer                 }
   ReqTime,AnsTime : Real;       {  Request, Answer time, ms        }
   POLLRATE        : record      {  Poll Rate                       }
    Rx,Tx          : Real;       {   Receiver/Transmitter, Hz       }
   end;                          {                                  }
  end;                           {                                  }
  CMD              : record      { Command cycle data               }
   Num             : Integer;    { Current command number           }
   Enabled         : array [1..MaxCmdNum] of Boolean; {             }
   Acronym         : array [1..MaxCmdNum] of String;  {             }
   AoNum           : array [1..MaxCmdNum] of Integer; {             }
   Tag             : array [1..MaxCmdNum] of Integer; {             }
   ENQ             : array [1..MaxCmdNum] of Integer; { Enquiry chr }
  end;                           {                                  }
  POLL_ENABLE      : TTagRef;    {                                  }
  PRESSURE1        : TTagRef;    {                                  }
  PRESSURE2        : TTagRef;    {                                  }
  PRESSURE3        : TTagRef;    {                                  }
  PRESSURE4        : TTagRef;    {                                  }
  DEGAS            : TTagRef;    {                                  }
  ERROR            : TTagRef;    {                                  }
  SGC1             : TTagRef;    {                                  }
  SGC2             : TTagRef;    {                                  }
  SGC3             : TTagRef;    {                                  }
  SGC4             : TTagRef;    {                                  }
  SENS_TYPE1       : TTagRef;    {                                  }
  SENS_TYPE2       : TTagRef;    {                                  }
  SENS_TYPE3       : TTagRef;    {                                  }
  SENS_TYPE4       : TTagRef;    {                                  }
  UNI              : TTagRef;    {                                  }
  SMF1             : TTagRef;    {                                  }
  SMF2             : TTagRef;    {                                  }
  SMF3             : TTagRef;    {                                  }
  SMF4             : TTagRef;    {                                  }
  CH1_STATE        : TTagRef;    {                                  }
  CH2_STATE        : TTagRef;    {                                  }
  CH3_STATE        : TTagRef;    {                                  }
  CH4_STATE        : TTagRef;    {                                  }
  EMI1             : TTagRef;    {                                  }
  EMI2             : TTagRef;    {                                  }
  SIM              : record      { Simulator data:                  }
   CMD             : Integer;    { Current executable command       }
   UNI             : Integer;    { UNI Command data                 }
   DGS             : Integer;    { DGS Command data                 }
   EMI1            : Integer;    { EMI Command data                 }
   EMI2            : Integer;    {                                  }
   SGC1            : Integer;    { SGC Command data                 }
   SGC2            : Integer;    {                                  }
   SGC3            : Integer;    {                                  }
   SGC4            : Integer;    {                                  }
   SMF1            : Integer;    { SMF Command data                 }
   SMF2            : Integer;    {                                  }
   SMF3            : Integer;    {                                  }
   SMF4            : Integer;    {                                  }
  end;                           {                                  }
 end;                            {                                  }
 Counter           : Real;       {                                  }
 cmd_Unit          : Integer;    {                                  }
 cmd_SMF1          : Integer;    {                                  }
 cmd_SMF2          : Integer;    {                                  }
 cmd_SMF3          : Integer;    {                                  }
 cmd_SMF4          : Integer;    {                                  }
 cmd_SGC1          : Integer;    {                                  }
 cmd_SGC2          : Integer;    {                                  }
 cmd_SGC3          : Integer;    {                                  }
 cmd_SGC4          : Integer;    {                                  }
 cmd_DGS           : Integer;    {                                  }
 cmd_EMI1          : Integer;    {                                  }
 cmd_EMI2          : Integer;    {                                  }
 cmd_RST           : Integer;    {                                  }
 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,15000);
 end;
 //
 // Clear poll rate counters.
 //
 procedure ClearPollRate;
 begin
  IMG.COM.POLLRATE.Rx:=0;
  IMG.COM.POLLRATE.Tx:=0;
 end;
 //
 // Increment counters.
 //
 procedure Increment(var rate:Real);
 begin
  rate:=rate+1;
 end;
 {
 Xor tag on click (local version)
 }
 procedure ClickTagXorLocal(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Read line (Line) from port with CR terminator and LF ignore.
 Temporary buffer (Buff) should be global lifetime variable with startup initialization.
 }
 function IMG_Readln(var Line,Buff:String):Boolean;
 const MaxLeng = 16384;
 var i,p,L:Integer;
 begin
  Line:='';
  IMG_Readln:=false;
  if ComCount>=0 then begin
   L:=Length(Buff);
   p:=Pos(Chr(_CR),Buff);
   if p=0 then begin
    if L<MaxLeng then Buff:=Buff+ComRead(MaxLeng-L);
    L:=Length(Buff);
   end;
   if L>0 then begin
    if p=0 then p:=Pos(Chr(_CR),Buff);
    if Pos(Chr(_ENQ),Buff)>0 then begin
     IMG_Readln:=true;
     if IMG.Simulator then Line:=Copy(Buff,Pos(Chr(_ENQ),Buff),1)
     else Line:=Copy(Buff,Pos(Chr(_ENQ),Buff)+1,Length(Buff));
     Buff:='';
    end else
    if p>0 then begin
     IMG_Readln:=true;
     i:=1;
     while (i<p) and (strFetch(Buff,i)=Chr(_LF)) do i:=i+1;
     if i<p then Line:=Copy(Buff,i,p-i);
     i:=p+1;
     while i<=L do begin
      if strFetch(Buff,i)=Chr(_LF) then p:=i else i:=L;
      i:=i+1;
     end;
     Buff:=Copy(Buff,p+1);
    end else begin
     if Length(Buff)>=MaxLeng then begin
      Trouble('Received line is too long!');
      Buff:='';
     end;
    end;
   end;
  end;
 end;
 {
 Check is ENQ required
 }
 function IsReqENQ:Boolean;
 begin
  IsReqENQ:=IMG.CmdReqENQ;
 end;
 //
 // Check if COM port opened
 //
 function ComOpened:Boolean;
 begin
  ComOpened:=(ComSpace>=0);
 end;
 //
 // Check command number is valid
 //
 function IsValidCmdNum(n:Integer):Boolean;
 begin
  IsValidCmdNum:=(n>=1) and (n<=MaxCmdNum);
 end;
 //
 // Enable/disable command n
 //
 procedure EnableCmdNum(n:Integer; Enabled:Boolean);
 begin
  if IsValidCmdNum(n) then IMG.CMD.Enabled[n]:=Enabled;
 end;
 //
 // Clear commands
 //
 procedure IMG_Clear_Cmd;
 var i:Integer;
 begin
  for i:=1 to MaxCmdNum do begin
   IMG.CMD.Acronym[i]:='';
   IMG.CMD.Enabled[i]:=False;
   IMG.CMD.AoNum[i]:=-1;
   IMG.CMD.Tag[i]:=0;
   IMG.CMD.ENQ[i]:=0;
  end;
 end;
 //
 // Initialize commands
 //
 procedure IMG_Init_Cmd;
  procedure Add(n,AoNum,En,Enq:Integer; Acronym:string);
  begin
   if IsValidCmdNum(n) then begin
    IMG.CMD.Acronym[n]:=Acronym;
    IMG.CMD.Enabled[n]:=En>0;
    IMG.CMD.Tag[n]:=FindTag(CrvName(RefAo(AoNum)));
    IMG.CMD.AoNum[n]:=AoNum;
    IMG.CMD.ENQ[n]:=Enq;
   end;
  end;
 begin
  IMG.CMD.Num:=1;
  //Command           AoNum En ENQ Acronym
  Add(cm_PRS1,        0,    1, 1,  'PRS,1');
  Add(cm_PRS2,        1,    1, 1,  'PRS,2');
  Add(cm_PRS3,        2,    1, 1,  'PRS,3');
  Add(cm_PRS4,        3,    1, 1,  'PRS,4');
  Add(cm_GDE,         -1,   1, 1,  'GDE');
  Add(cm_DGS_read,    -1,   1, 1,  'DGS');
  Add(cm_DGS_write,   -1,   0, 1,  'DGS,');
  Add(cm_SGC_read_1,  -1,   1, 1,  'SGC,1');
  Add(cm_SGC_read_2,  -1,   1, 1,  'SGC,2');
  Add(cm_SGC_read_3,  -1,   1, 1,  'SGC,3');
  Add(cm_SGC_read_4,  -1,   1, 1,  'SGC,4');
  Add(cm_STI_read_1,  -1,   1, 1,  'STI,1');
  Add(cm_STI_read_2,  -1,   1, 1,  'STI,2');
  Add(cm_STI_read_3,  -1,   1, 1,  'STI,3');
  Add(cm_STI_read_4,  -1,   1, 1,  'STI,4');
  Add(cm_UNI_read,    -1,   1, 1,  'UNI');
  Add(cm_UNI_write,   -1,   0, 1,  'UNI,');
  Add(cm_SGC_write_1, -1,   0, 1,  'SGC,1,');
  Add(cm_SGC_write_2, -1,   0, 1,  'SGC,2,');
  Add(cm_SGC_write_3, -1,   0, 1,  'SGC,3,');
  Add(cm_SGC_write_4, -1,   0, 1,  'SGC,4,');
  Add(cm_SMF_read_1,  -1,   1, 1,  'SMF,1');
  Add(cm_SMF_read_2,  -1,   1, 1,  'SMF,2');
  Add(cm_SMF_read_3,  -1,   1, 1,  'SMF,3');
  Add(cm_SMF_read_4,  -1,   1, 1,  'SMF,4');
  Add(cm_SMF_write_1, -1,   0, 1,  'SMF,1,');
  Add(cm_SMF_write_2, -1,   0, 1,  'SMF,2,');
  Add(cm_SMF_write_3, -1,   0, 1,  'SMF,3,');
  Add(cm_SMF_write_4, -1,   0, 1,  'SMF,4,');
  Add(cm_EMI_read_1,  -1,   1, 1,  'EMI,1');
  Add(cm_EMI_read_2,  -1,   1, 1,  'EMI,2');
  Add(cm_EMI_write_1, -1,   0, 1,  'EMI,1,');
  Add(cm_EMI_write_2, -1,   0, 1,  'EMI,2,');
  Add(cm_RESET,       -1,   0, 0,  'RES');
 end;
 //
 // Main command cycle
 //
 procedure IMG_CMD_CYCLE;
  //
  // Enable/disable command n
  //
  procedure EnableCmdNum(n:Integer; Enabled:Boolean);
  begin
   if IsValidCmdNum(n) then IMG.CMD.Enabled[n]:=Enabled;
  end;
  function ValidateCmdNum(Num:Integer):Integer;
  begin
   if IsValidCmdNum(Num) then ValidateCmdNum:=Num else ValidateCmdNum:=1;
  end;
  function NextCmdNum(Num:Integer):Integer;
  var i:Integer;
  begin
   i:=0;
   while (i<MaxCmdNum) do begin
    Num:=ValidateCmdNum(Num+1);
    if IMG.CMD.Enabled[Num] then i:=MaxCmdNum else i:=i+1;
   end;
   NextCmdNum:=Num;
  end;
  procedure ClearRequest(Num,Status:Integer);
  begin
   IMG.COM.Req:='';
   IMG.COM.Ans:='';
   IMG.COM.Buf:='';
   IMG.COM.ReqTime:=0;
   IMG.COM.AnsTime:=0;
   IMG.COM.Status:=Status;
   IMG.CMD.Num:=ValidateCmdNum(Num);
  end;
  function UpdateData(tag,AoNum:Integer; dat:Real):Boolean;
  begin
   UpdateData:=false;
   if not IsNan(dat) then begin
    if TypeTag(tag)=1 then bNul(iSetTag(tag,Round(dat))) else
    if TypeTag(tag)=2 then bNul(rSetTag(tag,dat));
    if AoNum>=0 then UpdateAo(AoNum,time,dat);
    UpdateData:=true;
   end;
  end;
  function PrepareRequest(Num:Integer; s:String):String;
  var req:String;
  begin
   req:='';
   if Num=cm_UNI_write   then req:=s+Str(IMG.UNI.dat)   else
   if Num=cm_SMF_write_1 then req:=s+Str(IMG.SMF1.dat)  else
   if Num=cm_SMF_write_2 then req:=s+Str(IMG.SMF2.dat)  else
   if Num=cm_SMF_write_3 then req:=s+Str(IMG.SMF3.dat)  else
   if Num=cm_SMF_write_4 then req:=s+Str(IMG.SMF4.dat)  else
   if Num=cm_SGC_write_1 then req:=s+Str(IMG.SGC1.dat)  else
   if Num=cm_SGC_write_2 then req:=s+Str(IMG.SGC2.dat)  else
   if Num=cm_SGC_write_3 then req:=s+Str(IMG.SGC3.dat)  else
   if Num=cm_SGC_write_4 then req:=s+Str(IMG.SGC4.dat)  else
   if Num=cm_DGS_write   then req:=s+Str(IMG.DEGAS.dat) else
   if Num=cm_EMI_write_1 then req:=s+Str(IMG.EMI1.dat)  else
   if Num=cm_EMI_write_2 then req:=s+Str(IMG.EMI2.dat)  else req:=s;
   PrepareRequest:=req+CRLF;
   req:='';
  end;
  function HandleRequest(Num,Aonum:Integer; Ans:String):Boolean;
  var Handle:Boolean; stt:Integer;
  begin
   Handle:=false;
   if IsValidCmdNum(Num) and (Length(Ans)>0) then begin
    if IsSameText(Trim(Ans),Trim(IMG.COM.Req)) then begin
     Handle:=true;
    end else
    if (Num=cm_PRS1) then begin
     stt:=Val('$'+ExtractWord(1,Ans));
     if stt=8 then Handle:=true;
     bNul(iSetTag(IMG.CH1_STATE.tag,stt));
     if UpdateData(IMG.PRESSURE1.tag,AoNum,rVal(ExtractWord(2,Ans))) then Handle:=true;
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_PRS2) then begin
     stt:=Val('$'+ExtractWord(1,Ans));
     if stt=8 then Handle:=true;
     bNul(iSetTag(IMG.CH2_STATE.tag,stt));
     if UpdateData(IMG.PRESSURE2.tag,AoNum,rVal(ExtractWord(2,Ans))) then Handle:=true;
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_PRS3) then begin
     stt:=Val('$'+ExtractWord(1,Ans));
     if stt=8 then Handle:=true;
     bNul(iSetTag(IMG.CH3_STATE.tag,stt));
     if UpdateData(IMG.PRESSURE3.tag,AoNum,rVal(ExtractWord(2,Ans))) then Handle:=true;
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_PRS4) then begin
     stt:=Val('$'+ExtractWord(1,Ans));
     if stt=8 then Handle:=true;
     bNul(iSetTag(IMG.CH4_STATE.tag,stt));
     if UpdateData(IMG.PRESSURE4.tag,AoNum,rVal(ExtractWord(2,Ans))) then Handle:=true;
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_GDE) then begin
     if Length(Trim(Ans))=4 then begin
      if UpdateData(IMG.ERROR.tag,-1,Val('$'+Trim(Ans))) then Handle:=true;
      EnableCmdNum(cm_GDE,false);
     end;
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_DGS_read) then begin
     if UpdateData(IMG.DEGAS.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_DGS_write,false);
     EnableCmdNum(cm_DGS_read,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SGC_read_1) then begin
     if UpdateData(IMG.SGC1.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_SGC_write_1,false);
     EnableCmdNum(cm_SGC_read_1,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SGC_read_2) then begin
     if UpdateData(IMG.SGC2.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_SGC_write_2,false);
     EnableCmdNum(cm_SGC_read_2,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SGC_read_3) then begin
     if UpdateData(IMG.SGC3.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_SGC_write_3,false);
     EnableCmdNum(cm_SGC_read_3,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SGC_read_4) then begin
     if UpdateData(IMG.SGC4.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_SGC_write_4,false);
     EnableCmdNum(cm_SGC_read_4,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_STI_read_1) then begin
     if UpdateData(IMG.SENS_TYPE1.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_STI_read_1,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_STI_read_2) then begin
     if UpdateData(IMG.SENS_TYPE2.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_STI_read_2,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_STI_read_3) then begin
     if UpdateData(IMG.SENS_TYPE3.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_STI_read_3,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_STI_read_4) then begin
     if UpdateData(IMG.SENS_TYPE4.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_STI_read_4,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_UNI_read) then begin
     if UpdateData(IMG.UNI.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_UNI_write,false);
     EnableCmdNum(cm_UNI_read,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_UNI_write) then begin
     if (Val(Ans))=IMG.UNI.dat then Handle:=true;
     EnableCmdNum(cm_UNI_read,true);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SGC_write_1) then begin
     if (Val(Ans))=IMG.SGC1.dat then Handle:=true;
     EnableCmdNum(cm_SGC_read_1,true);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SGC_write_2) then begin
     if (Val(Ans))=IMG.SGC2.dat then Handle:=true;
     EnableCmdNum(cm_SGC_read_2,true);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SGC_write_3) then begin
     if (Val(Ans))=IMG.SGC3.dat then Handle:=true;
     EnableCmdNum(cm_SGC_read_3,true);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SGC_write_4) then begin
     if (Val(Ans))=IMG.SGC4.dat then Handle:=true;
     EnableCmdNum(cm_SGC_read_4,true);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SMF_read_1) then begin
     if UpdateData(IMG.SMF1.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_SMF_write_1,false);
     EnableCmdNum(cm_SMF_read_1,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SMF_read_2) then begin
     if UpdateData(IMG.SMF2.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_SMF_write_2,false);
     EnableCmdNum(cm_SMF_read_2,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SMF_read_3) then begin
     if UpdateData(IMG.SMF3.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_SMF_write_3,false);
     EnableCmdNum(cm_SMF_read_3,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SMF_read_4) then begin
     if UpdateData(IMG.SMF4.tag,-1,Val(Ans)) then Handle:=true;
     EnableCmdNum(cm_SMF_write_4,false);
     EnableCmdNum(cm_SMF_read_4,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SMF_write_1) then begin
     if (Val(Ans))=IMG.SMF1.dat then Handle:=true;
     EnableCmdNum(cm_SMF_read_1,true);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SMF_write_2) then begin
     if (Val(Ans))=IMG.SMF2.dat then Handle:=true;
     EnableCmdNum(cm_SMF_read_2,true);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SMF_write_3) then begin
     if (Val(Ans))=IMG.SMF3.dat then Handle:=true;
     EnableCmdNum(cm_SMF_read_3,true);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_SMF_write_4) then begin
     if (Val(Ans))=IMG.SMF4.dat then Handle:=true;
     EnableCmdNum(cm_SMF_read_4,true);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_DGS_write) then begin
     if (Val(Ans))=IMG.DEGAS.dat then Handle:=true;
     EnableCmdNum(cm_DGS_read,true);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_EMI_read_1) then begin
     if UpdateData(IMG.EMI1.tag,-1,Val(ExtractWord(2,Ans))) then Handle:=true;
     EnableCmdNum(cm_EMI_read_1,false);
     EnableCmdNum(cm_EMI_write_1,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_EMI_read_2) then begin
     if UpdateData(IMG.EMI2.tag,-1,Val(ExtractWord(2,Ans))) then Handle:=true;
     EnableCmdNum(cm_EMI_read_2,false);
     EnableCmdNum(cm_EMI_write_2,false);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_EMI_write_1) then begin
     if (Val(ExtractWord(2,Ans)))=IMG.EMI1.dat then Handle:=true;
     EnableCmdNum(cm_EMI_read_1,true);
     IMG.CmdReqENQ:=false;
    end else
    if (Num=cm_EMI_write_2) then begin
     if (Val(ExtractWord(2,Ans)))=IMG.EMI2.dat then Handle:=true;
     EnableCmdNum(cm_EMI_read_2,true);
     IMG.CmdReqENQ:=false;
    end;
   end;
   HandleRequest:=Handle;
  end;
 begin
  //
  // COM port communication handler
  //
  if ComOpened then begin
   if iGetTag(IMG.POLL_ENABLE.tag)>0 then begin
    IMG.CMD.Num:=ValidateCmdNum(IMG.CMD.Num);
    if IMG.COM.Status=st_NoReq then begin
     ClearRequest(IMG.CMD.Num,st_NoReq);
     if IMG.CMD.Enabled[IMG.CMD.Num] then begin
      PurgeComPort;
      if IsReqENQ then IMG.COM.Req:=Chr(_ENQ)
      else IMG.COM.Req:=PrepareRequest(IMG.CMD.Num,IMG.CMD.Acronym[IMG.CMD.Num]);
      if ComWrite(IMG.COM.Req) then begin
       ViewExp('COM > '+IMG.COM.Req);
       IMG.COM.Status:=st_WaitAns;
       IMG.COM.ReqTime:=mSecNow;
       if IMG.CMD.ENQ[IMG.CMD.Num]=1 then IMG.CmdReqENQ:=true;
       Increment(IMG.COM.POLLRATE.Tx);
      end else begin
       Trouble('Could not send request '+IMG.COM.Req);
       ClearRequest(NextCmdNum(IMG.CMD.Num),st_NoReq);
      end;
     end else ClearRequest(NextCmdNum(IMG.CMD.Num),st_NoReq);
    end else
    if IMG.COM.Status=st_WaitAns then begin
     if IMG_Readln(IMG.COM.Ans,IMG.COM.Buf) then begin
      ViewImp('COM < '+IMG.COM.Ans);
      if HandleRequest(IMG.CMD.Num,IMG.CMD.AoNum[IMG.CMD.Num],IMG.COM.Ans) then begin
       IMG.COM.Status:=st_WaitGap;
       IMG.COM.AnsTime:=mSecNow;
       Increment(IMG.COM.POLLRATE.Rx);
      end;
      if IMG.CMD.Num=cm_RESET then EnableCmdNum(cm_RESET,false);
     end;
     if mSecNow>IMG.COM.ReqTime+IMG.COM.TimeOut then begin
      IMG.COM.Status:=st_TimeOut;
     end;
    end;
    if IMG.COM.Status=st_WaitGap then begin
     if mSecNow>=IMG.COM.AnsTime+IMG.COM.TimeGap then begin
      if IsReqENQ then ClearRequest(IMG.CMD.Num,st_NoReq) else
      ClearRequest(NextCmdNum(IMG.CMD.Num),st_NoReq);
     end;
    end;
    if IMG.COM.Status=st_TimeOut then begin
     Trouble('TimeOut on command '+IMG.CMD.Acronym[IMG.CMD.Num]);
     ClearRequest(NextCmdNum(IMG.CMD.Num),st_NoReq);
     IMG.CmdReqENQ:=false;
    end;
   end else begin
    ClearRequest(NextCmdNum(0),st_NoReq);
    IMG.CmdReqENQ:=false;
   end;
  end;
  if SysTimer_Pulse(1000)>0 then begin
   UpdateAo(ao_POLLRATE_RX,time,IMG.COM.POLLRATE.Rx);
   UpdateAo(ao_POLLRATE_TX,time,IMG.COM.POLLRATE.Tx);
   ClearPollRate;
  end;
  if SysTimer_Pulse(2500)>0 then begin
   if Counter=0  then EnableCmdNum(cm_GDE,true) else
   if Counter=1  then EnableCmdNum(cm_DGS_read,true) else
   if Counter=2  then EnableCmdNum(cm_SGC_read_1,true) else
   if Counter=3  then EnableCmdNum(cm_SGC_read_2,true) else
   if Counter=4  then EnableCmdNum(cm_SGC_read_3,true) else
   if Counter=5  then EnableCmdNum(cm_SGC_read_4,true) else
   if Counter=6  then EnableCmdNum(cm_SMF_read_1,true) else
   if Counter=7  then EnableCmdNum(cm_SMF_read_2,true) else
   if Counter=8  then EnableCmdNum(cm_SMF_read_3,true) else
   if Counter=9  then EnableCmdNum(cm_SMF_read_4,true) else
   if Counter=10 then EnableCmdNum(cm_UNI_read,true) else
   if Counter=11 then EnableCmdNum(cm_STI_read_1,true) else
   if Counter=12 then EnableCmdNum(cm_STI_read_2,true) else
   if Counter=13 then EnableCmdNum(cm_STI_read_3,true) else
   if Counter=14 then EnableCmdNum(cm_STI_read_4,true) else
   if Counter=15 then EnableCmdNum(cm_EMI_read_1,true) else
   if Counter=16 then EnableCmdNum(cm_EMI_read_2,true);
   Increment(Counter); if Counter>16 then Counter:=0;
  end;
 end;
 {
 Menu Tools Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   n:=n+EditAddInputLn('Режим отладки консоли: нормальный (3)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   n:=n+EditAddInputLn('Режим отладки консоли: ввод-вывод (15)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   n:=n+EditAddInputLn('Режим отладки консоли: детальный (31)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   n:=n+EditAddInputLn('Открыть окно: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   n:=n+EditAddInputLn('Перезапустить драйвер '+DevName);
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SysEval @Daq Compile '+DevName);
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Tools Handler to handle editing.
 }
 procedure MenuToolsHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
 end;
 //
 // Menu GUI dialogs
 //
 procedure MenuGas1Selected;
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Выбор поправочного коэффициента газа для канала №1');
   n:=n+EditAddInputLn('Выберете поправочный коэффициент газа:');
   n:=n+EditAddInputLn('Отсутствует');
   n:=n+EditAddInputLn('Аr');
   n:=n+EditAddInputLn('H2');
   n:=n+EditAddInputLn('He');
   n:=n+EditAddInputLn('Ne');
   n:=n+EditAddInputLn('Kr');
   n:=n+EditAddInputLn('Xe');
   n:=n+EditAddInputLn('CO2');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[Bold]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_GAS1'),Str(iGetTag(IMG.SGC1.tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 procedure MenuGas2Selected;
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Выбор поправочного коэффициента газа для канала №2');
   n:=n+EditAddInputLn('Выберете поправочный коэффициент газа:');
   n:=n+EditAddInputLn('Отсутствует');
   n:=n+EditAddInputLn('Аr');
   n:=n+EditAddInputLn('H2');
   n:=n+EditAddInputLn('He');
   n:=n+EditAddInputLn('Ne');
   n:=n+EditAddInputLn('Kr');
   n:=n+EditAddInputLn('Xe');
   n:=n+EditAddInputLn('CO2');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[Bold]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_GAS2'),Str(iGetTag(IMG.SGC2.tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 procedure MenuGas3Selected;
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Выбор поправочного коэффициента газа для канала №3');
   n:=n+EditAddInputLn('Выберете поправочный коэффициент газа:');
   n:=n+EditAddInputLn('Отсутствует');
   n:=n+EditAddInputLn('Аr');
   n:=n+EditAddInputLn('H2');
   n:=n+EditAddInputLn('He');
   n:=n+EditAddInputLn('Ne');
   n:=n+EditAddInputLn('Kr');
   n:=n+EditAddInputLn('Xe');
   n:=n+EditAddInputLn('CO2');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[Bold]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_GAS3'),Str(iGetTag(IMG.SGC3.tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 procedure MenuGas4Selected;
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Выбор поправочного коэффициента газа для канала №4');
   n:=n+EditAddInputLn('Выберете поправочный коэффициент газа:');
   n:=n+EditAddInputLn('Отсутствует');
   n:=n+EditAddInputLn('Аr');
   n:=n+EditAddInputLn('H2');
   n:=n+EditAddInputLn('He');
   n:=n+EditAddInputLn('Ne');
   n:=n+EditAddInputLn('Kr');
   n:=n+EditAddInputLn('Xe');
   n:=n+EditAddInputLn('CO2');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[Bold]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_GAS4'),Str(iGetTag(IMG.SGC4.tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 procedure MenuUniSelected;
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Выбор единицы измерения давления');
   n:=n+EditAddInputLn('Выберете единицу измерения давления:');
   n:=n+EditAddInputLn('мбар');
   n:=n+EditAddInputLn('Торр');
   n:=n+EditAddInputLn('Па');
   n:=n+EditAddInputLn('Микрон');
   n:=n+EditAddInputLn('гПа');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[Bold]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_UNI'),Str(iGetTag(IMG.UNI.tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 procedure MenuSMF1Selected;
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Выбор типа фильтрации значений канала №1');
   n:=n+EditAddInputLn('Выберете тип фильтрации значений канала №1:');
   n:=n+EditAddInputLn('Отсутствует');
   n:=n+EditAddInputLn('Быстро');
   n:=n+EditAddInputLn('Нормально');
   n:=n+EditAddInputLn('Медленно');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[Bold]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_SMF1'),Str(iGetTag(IMG.SMF1.tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 procedure MenuSMF2Selected;
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Выбор типа фильтрации значений канала №2');
   n:=n+EditAddInputLn('Выберете тип фильтрации значений канала №2:');
   n:=n+EditAddInputLn('Отсутствует');
   n:=n+EditAddInputLn('Быстро');
   n:=n+EditAddInputLn('Нормально');
   n:=n+EditAddInputLn('Медленно');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[Bold]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_SMF2'),Str(iGetTag(IMG.SMF2.tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 procedure MenuSMF3Selected;
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Выбор типа фильтрации значений канала №3');
   n:=n+EditAddInputLn('Выберете тип фильтрации значений канала №3:');
   n:=n+EditAddInputLn('Отсутствует');
   n:=n+EditAddInputLn('Быстро');
   n:=n+EditAddInputLn('Нормально');
   n:=n+EditAddInputLn('Медленно');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[Bold]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_SMF3'),Str(iGetTag(IMG.SMF3.tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 procedure MenuSMF4Selected;
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Выбор типа фильтрации значений канала №4');
   n:=n+EditAddInputLn('Выберете тип фильтрации значений канала №4:');
   n:=n+EditAddInputLn('Отсутствует');
   n:=n+EditAddInputLn('Быстро');
   n:=n+EditAddInputLn('Нормально');
   n:=n+EditAddInputLn('Медленно');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[Bold]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_SMF4'),Str(iGetTag(IMG.SMF4.tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 GUI Handler to process user input...
 }
 procedure GUIHandler;
 var ClickCurve,sttChan:Integer;
 begin
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     if ClickTag=IMG.POLL_ENABLE.tag then ClickTagXorLocal(ClickTag,1);
     if ClickTag=IMG.SGC1.tag  then MenuGas1Selected;
     if ClickTag=IMG.SGC2.tag  then MenuGas2Selected;
     if ClickTag=IMG.SGC3.tag  then MenuGas3Selected;
     if ClickTag=IMG.SGC4.tag  then MenuGas4Selected;
     if ClickTag=IMG.UNI.tag   then MenuUniSelected;
     if ClickTag=IMG.SMF1.tag  then MenuSMF1Selected;
     if ClickTag=IMG.SMF2.tag  then MenuSMF2Selected;
     if ClickTag=IMG.SMF3.tag  then MenuSMF3Selected;
     if ClickTag=IMG.SMF4.tag  then MenuSMF4Selected;
     if ClickTag=IMG.DEGAS.tag then DevSendCmdLocal('@DGS '+Str(iXor(iGetTag(ClickTag),1)));
     if ClickTag=IMG.EMI1.tag  then DevSendCmdLocal('@EMI1 '+Str(iXor(iGetTag(ClickTag),1)));
     if ClickTag=IMG.EMI2.tag  then DevSendCmdLocal('@EMI2 '+Str(iXor(iGetTag(ClickTag),1)));
     if ClickTag=IMG.CH1_STATE.tag then begin
      sttChan:=iGetTag(ClickTag);
      if sttChan=1  then ShowTooltip('text "КАНАЛ 1: Состояние канала в норме" delay 15000 preset stdSuccess');
      if sttChan=2  then ShowTooltip('text "КАНАЛ 1: Выход за верхний предел диапазона" delay 15000  preset stdWarning');
      if sttChan=4  then ShowTooltip('text "КАНАЛ 1: Выход за нижний предел диапазона" delay 15000  preset stdWarning');
      if sttChan=8  then ShowTooltip('text "КАНАЛ 1: Датчик не подключен" delay 15000 preset stdError');
      if sttChan=10 then ShowTooltip('text "КАНАЛ 1: Ошибка датчика" delay 15000  preset stdError');
      if sttChan=20 then ShowTooltip('text "КАНАЛ 1: Эмиссия на датчике включена" delay 15000   preset stdInformation');
      if sttChan=40 then ShowTooltip('text "КАНАЛ 1: Дегазация на датчике включена" delay 15000  preset stdInformation');
      if sttChan=80 then ShowTooltip('text "КАНАЛ 1: Выбран ионо-вакуумный датчик" delay 15000  preset stdInformation');
     end;
     if ClickTag=IMG.CH2_STATE.tag then begin
      sttChan:=iGetTag(ClickTag);
      if sttChan=1  then ShowTooltip('text "КАНАЛ 2: Состояние канала в норме" delay 15000 preset stdSuccess');
      if sttChan=2  then ShowTooltip('text "КАНАЛ 2: Выход за верхний предел диапазона" delay 15000 preset stdWarning');
      if sttChan=4  then ShowTooltip('text "КАНАЛ 2: Выход за нижний предел диапазона" delay 15000 preset stdWarning');
      if sttChan=8  then ShowTooltip('text "КАНАЛ 2: Датчик не подключен" delay 15000 preset stdError');
      if sttChan=10 then ShowTooltip('text "КАНАЛ 2: Ошибка датчика" delay 15000 preset stdError');
      if sttChan=20 then ShowTooltip('text "КАНАЛ 2: Эмиссия на датчике включена" delay 15000 preset stdInformation');
      if sttChan=40 then ShowTooltip('text "КАНАЛ 2: Дегазация на датчике включена" delay 15000 preset stdInformation');
      if sttChan=80 then ShowTooltip('text "КАНАЛ 2: Выбран ионо-вакуумный датчик" delay 15000 preset stdInformation');
     end;
     if ClickTag=IMG.CH3_STATE.tag then begin
      sttChan:=iGetTag(ClickTag);
      if sttChan=1  then ShowTooltip('text "КАНАЛ 3: Состояние канала в норме" delay 15000 preset stdSuccess');
      if sttChan=2  then ShowTooltip('text "КАНАЛ 3: Выход за верхний предел диапазона" delay 15000 preset stdWarning');
      if sttChan=4  then ShowTooltip('text "КАНАЛ 3: Выход за нижний предел диапазона" delay 15000 preset stdWarning');
      if sttChan=8  then ShowTooltip('text "КАНАЛ 3: Датчик не подключен" delay 15000 preset stdError');
      if sttChan=10 then ShowTooltip('text "КАНАЛ 3: Ошибка датчика" delay 15000 preset stdError');
     end;
     if ClickTag=IMG.CH4_STATE.tag then begin
      sttChan:=iGetTag(ClickTag);
      if sttChan=1  then ShowTooltip('text "КАНАЛ 4: Состояние канала в норме" delay 15000 preset stdSuccess');
      if sttChan=2  then ShowTooltip('text "КАНАЛ 4: Выход за верхний предел диапазона" delay 15000 preset stdWarning');
      if sttChan=4  then ShowTooltip('text "КАНАЛ 4: Выход за нижний предел диапазона" delay 15000 preset stdWarning');
      if sttChan=8  then ShowTooltip('text "КАНАЛ 4: Датчик не подключен" delay 15000 preset stdError');
      if sttChan=10 then ShowTooltip('text "КАНАЛ 4: Ошибка датчика" delay 15000 preset stdError');
     end;
     if ClickTag=IMG.ERROR.tag then ShowTooltip('text "'+URL_Decode(ClickParams('Hint'))+'" delay 15000 preset stdInformation');
     if IsSameText(ClickSensor,'HELP') then DevPostCmdLocal('@BrowseHelp '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
     if IsSameText(ClickSensor,'IMG.RESET') then DevSendCmdLocal('@RST');
     if IsSameText(ClickSensor,'IMG.TITLE') then MenuToolsStarter;
     {
     Select Plot & Tab windows by curve...
     }
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     {
     Console commands: @url_encoded_sensor ...
     }
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   MenuToolsHandler; // Menu TOOLS
   if EditTestResultName(EditGetUID('MENU_GAS1')) then begin
    if EditTestResultCode(mr_OK) then DevSendCmdLocal('@SGC1 '+Str(EditGetMenuListSelectedIndex));
    EditReset;
   end;
   if EditTestResultName(EditGetUID('MENU_GAS2')) then begin
    if EditTestResultCode(mr_OK) then DevSendCmdLocal('@SGC2 '+Str(EditGetMenuListSelectedIndex));
    EditReset;
   end;
   if EditTestResultName(EditGetUID('MENU_GAS3')) then begin
    if EditTestResultCode(mr_OK) then DevSendCmdLocal('@SGC3 '+Str(EditGetMenuListSelectedIndex));
    EditReset;
   end;
   if EditTestResultName(EditGetUID('MENU_GAS4')) then begin
    if EditTestResultCode(mr_OK) then DevSendCmdLocal('@SGC4 '+Str(EditGetMenuListSelectedIndex));
    EditReset;
   end;
   if EditTestResultName(EditGetUID('MENU_UNI')) then begin
    if EditTestResultCode(mr_OK) then DevSendCmdLocal('@Unit '+Str(EditGetMenuListSelectedIndex));
    EditReset;
   end;
   if EditTestResultName(EditGetUID('MENU_SMF1')) then begin
    if EditTestResultCode(mr_OK) then DevSendCmdLocal('@SMF1 '+Str(EditGetMenuListSelectedIndex));
    EditReset;
   end;
   if EditTestResultName(EditGetUID('MENU_SMF2')) then begin
    if EditTestResultCode(mr_OK) then DevSendCmdLocal('@SMF2 '+Str(EditGetMenuListSelectedIndex));
    EditReset;
   end;
   if EditTestResultName(EditGetUID('MENU_SMF3')) then begin
    if EditTestResultCode(mr_OK) then DevSendCmdLocal('@SMF3 '+Str(EditGetMenuListSelectedIndex));
    EditReset;
   end;
   if EditTestResultName(EditGetUID('MENU_SMF4')) then begin
    if EditTestResultCode(mr_OK) then DevSendCmdLocal('@SMF4 '+Str(EditGetMenuListSelectedIndex));
    EditReset;
   end;
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Uncompleted edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
 end;
 {
 IMG Simply simulator
 }
 procedure IMG_SIMULATOR(Req:String);
 var i:Integer; p1,p2,p3,acr:String;
 begin
  acr:=''; p1:=''; p2:=''; p3:='';
  if Length(Req)>0 then begin
   ViewImp('COM < '+Trim(Req));
   if Pos(Chr(05),Req)>0 then begin
    if IMG.SIM.CMD=cm_PRS1 then IMG.COM.Ans:='01,+1.'+StrFmt('%2.4d',2980+Round(1*sin(100*time*(pi*2))*1000+Random(-1,1)))+'E+01' else
    if IMG.SIM.CMD=cm_PRS2 then IMG.COM.Ans:='01,+1.'+StrFmt('%2.4d',3980+Round(2*sin(100*time*(pi*2))*1000+Random(-1,1)))+'E+01' else
    if IMG.SIM.CMD=cm_PRS3 then IMG.COM.Ans:='01,+1.'+StrFmt('%2.4d',4980+Round(3*sin(100*time*(pi*2))*1000+Random(-1,1)))+'E+01' else
    if IMG.SIM.CMD=cm_PRS4 then IMG.COM.Ans:='01,+1.'+StrFmt('%2.4d',5980+Round(4*sin(100*time*(pi*2))*1000+Random(-1,1)))+'E+01' else
    if IMG.SIM.CMD=cm_GDE  then IMG.COM.Ans:='0000' else
    if IMG.SIM.CMD=cm_UNI_read   then IMG.COM.Ans:=Str(IMG.SIM.UNI) else
    if IMG.SIM.CMD=cm_DGS_read   then IMG.COM.Ans:=Str(IMG.SIM.DGS) else
    if IMG.SIM.CMD=cm_EMI_read_1 then IMG.COM.Ans:='1,'+Str(IMG.SIM.EMI1) else
    if IMG.SIM.CMD=cm_EMI_read_2 then IMG.COM.Ans:='2,'+Str(IMG.SIM.EMI2) else
    if IMG.SIM.CMD=cm_STI_read_1 then IMG.COM.Ans:='05' else
    if IMG.SIM.CMD=cm_STI_read_2 then IMG.COM.Ans:='06' else
    if IMG.SIM.CMD=cm_STI_read_3 then IMG.COM.Ans:='07' else
    if IMG.SIM.CMD=cm_STI_read_4 then IMG.COM.Ans:='08' else
    if IMG.SIM.CMD=cm_SGC_read_1 then IMG.COM.Ans:=Str(IMG.SIM.SGC1) else
    if IMG.SIM.CMD=cm_SGC_read_2 then IMG.COM.Ans:=Str(IMG.SIM.SGC2) else
    if IMG.SIM.CMD=cm_SGC_read_3 then IMG.COM.Ans:=Str(IMG.SIM.SGC3) else
    if IMG.SIM.CMD=cm_SGC_read_4 then IMG.COM.Ans:=Str(IMG.SIM.SGC4) else
    if IMG.SIM.CMD=cm_SMF_read_1 then IMG.COM.Ans:=Str(IMG.SIM.SMF1) else
    if IMG.SIM.CMD=cm_SMF_read_2 then IMG.COM.Ans:=Str(IMG.SIM.SMF2) else
    if IMG.SIM.CMD=cm_SMF_read_3 then IMG.COM.Ans:=Str(IMG.SIM.SMF3) else
    if IMG.SIM.CMD=cm_SMF_read_4 then IMG.COM.Ans:=Str(IMG.SIM.SMF4) else
    IMG.COM.Ans:='08';
   end else
   for i:=1 to maxCmdNum do begin
    if IsSameText(Trim(Req),IMG.CMD.ACRONYM[i]) then begin
     IMG.SIM.CMD:=i;
     IMG.COM.Ans:=Trim(Req);
     i:=maxCmdNum;
    end else begin
     acr:=ExtractWord(1,IMG.CMD.ACRONYM[i]);
     p1:=ExtractWord(1,Req);
     p2:=ExtractWord(2,Req);
     p3:=ExtractWord(3,Req);
     if IsSameText(acr,p1) then begin
      if IsSameText(acr,'UNI') then begin
       IMG.SIM.UNI:=Val(p2);
       IMG.COM.Ans:=Trim(p2);
      end else
      if IsSameText(acr,'DGS') then begin
       IMG.SIM.DGS:=Val(p2);
       IMG.COM.Ans:=Trim(p2);
      end else
      if IsSameText(acr,'EMI') then begin
       if IsSameText(p2,'1') then if p3<>'' then IMG.SIM.EMI1:=Val(p3);
       if IsSameText(p2,'2') then if p3<>'' then IMG.SIM.EMI2:=Val(p3);
       IMG.COM.Ans:=Trim(p2+','+p3);
      end else
      if IsSameText(acr,'SGC') then begin
       if IsSameText(p2,'1') then if p3<>'' then IMG.SIM.SGC1:=Val(p3);
       if IsSameText(p2,'2') then if p3<>'' then IMG.SIM.SGC2:=Val(p3);
       if IsSameText(p2,'3') then if p3<>'' then IMG.SIM.SGC3:=Val(p3);
       if IsSameText(p2,'4') then if p3<>'' then IMG.SIM.SGC4:=Val(p3);
       IMG.COM.Ans:=Trim(p3);
      end else
      if IsSameText(acr,'SMF') then begin
       if IsSameText(p2,'1') then if p3<>'' then IMG.SIM.SMF1:=Val(p3);
       if IsSameText(p2,'2') then if p3<>'' then IMG.SIM.SMF2:=Val(p3);
       if IsSameText(p2,'3') then if p3<>'' then IMG.SIM.SMF3:=Val(p3);
       if IsSameText(p2,'4') then if p3<>'' then IMG.SIM.SMF4:=Val(p3);
       IMG.COM.Ans:=Trim(p3);
      end;
     end;
    end;
   end;
   if IMG.SIM.CMD=cm_RESET then begin
    IMG.SIM.CMD:=0;
    IMG.SIM.UNI:=0;
    IMG.SIM.DGS:=0;
    IMG.SIM.EMI1:=0;
    IMG.SIM.EMI2:=0;
    IMG.SIM.SGC1:=0;
    IMG.SIM.SGC2:=0;
    IMG.SIM.SGC3:=0;
    IMG.SIM.SGC4:=0;
    IMG.SIM.SMF1:=2;
    IMG.SIM.SMF2:=2;
    IMG.SIM.SMF3:=2;
    IMG.SIM.SMF4:=2;
   end;
   if Length(IMG.COM.Ans)>0 then begin
    if ComWrite(IMG.COM.Ans+CRLF) then ViewExp('COM > '+Trim(IMG.COM.Ans)) else Trouble('Could not send '+Trim(IMG.COM.Ans));
   end;
  end;
  IMG.COM.Req:='';
  IMG.COM.Ans:='';
  acr:=''; p1:=''; p2:=''; p3:='';
 end;
 {
 IMG Tags initialization...
 }
 procedure IMG_InitTags(Prefix:String);
 begin
  if not IsEmptyStr(Prefix) then begin
   InitTag(IMG.POLL_ENABLE.tag, Prefix+'.POLL_ENABLE', 1);
   InitTag(IMG.PRESSURE1.tag,   Prefix+'.PRESSURE1',   2);
   InitTag(IMG.PRESSURE2.tag,   Prefix+'.PRESSURE2',   2);
   InitTag(IMG.PRESSURE3.tag,   Prefix+'.PRESSURE3',   2);
   InitTag(IMG.PRESSURE4.tag,   Prefix+'.PRESSURE4',   2);
   InitTag(IMG.DEGAS.tag,       Prefix+'.DEGAS',       1);
   InitTag(IMG.ERROR.tag,       Prefix+'.ERROR',       1);
   InitTag(IMG.SGC1.tag,        Prefix+'.SGC1',        1);
   InitTag(IMG.SGC2.tag,        Prefix+'.SGC2',        1);
   InitTag(IMG.SGC3.tag,        Prefix+'.SGC3',        1);
   InitTag(IMG.SGC4.tag,        Prefix+'.SGC4',        1);
   InitTag(IMG.SENS_TYPE1.tag,  Prefix+'.SENS_TYPE1',  1);
   InitTag(IMG.SENS_TYPE2.tag,  Prefix+'.SENS_TYPE2',  1);
   InitTag(IMG.SENS_TYPE3.tag,  Prefix+'.SENS_TYPE3',  1);
   InitTag(IMG.SENS_TYPE4.tag,  Prefix+'.SENS_TYPE4',  1);
   InitTag(IMG.UNI.tag,         Prefix+'.UNI',         1);
   InitTag(IMG.SMF1.tag,        Prefix+'.SMF1',        1);
   InitTag(IMG.SMF2.tag,        Prefix+'.SMF2',        1);
   InitTag(IMG.SMF3.tag,        Prefix+'.SMF3',        1);
   InitTag(IMG.SMF4.tag,        Prefix+'.SMF4',        1);
   InitTag(IMG.CH1_STATE.tag,   Prefix+'.CH1_STATE',   1);
   InitTag(IMG.CH2_STATE.tag,   Prefix+'.CH2_STATE',   1);
   InitTag(IMG.CH3_STATE.tag,   Prefix+'.CH3_STATE',   1);
   InitTag(IMG.CH4_STATE.tag,   Prefix+'.CH4_STATE',   1);
   InitTag(IMG.EMI1.tag,        Prefix+'.EMI1',        1);
   InitTag(IMG.EMI2.tag,        Prefix+'.EMI2',        1);
  end;
 end;
 {
 IMG cleanup
 }
 procedure IMG_Clear;
 begin
  IMG_Clear_Cmd;
  IMG.COM.Req:='';
  IMG.COM.Ans:='';
  IMG.COM.Buf:='';
  ClearPollRate;
 end;
 {
 IMG Initialization
 }
 procedure IMG_INIT(Prefix:String);
 begin
  //
  // Initialize variables
  //
  IMG.COM.ReqTime:=0;
  IMG.COM.AnsTime:=0;
  IMG.COM.Status:=st_NoReq;
  IMG_InitTags(Prefix);
  IMG_Init_Cmd;
  IMG.COM.Port:=iValDef(ReadIni('ComPort'),0);          Success('Com port: '+Str(IMG.COM.Port));
  IMG.COM.TimeOut:=iValDef(ReadIni('ComTimeOut'),2500); Success('TimeOut: ' +Str(IMG.COM.TimeOut));
  IMG.COM.TimeGap:=iValDef(ReadIni('ComTimeGap'),0);    Success('TimeGap: ' +Str(IMG.COM.TimeGap));
  IMG.Simulator:=iValDef(ReadIni('Simulator'),0)<>0;
  if IMG.Simulator then Success('Run simulator mode.') else Success('Run as driver mode.');
  //
  // Initialize COM port
  //
  if ComOpen('[SerialPort-COM'+Str(IMG.COM.Port)+']') then Success('COM port initialized.') else Trouble('COM port failed.');
  //
  // Initialize simulator variables
  //
  IMG.SIM.CMD:=0;
  IMG.SIM.UNI:=0;
  IMG.SIM.DGS:=0;
  IMG.SIM.EMI1:=0;
  IMG.SIM.EMI2:=0;
  IMG.SIM.SGC1:=0;
  IMG.SIM.SGC2:=0;
  IMG.SIM.SGC3:=0;
  IMG.SIM.SGC4:=0;
  IMG.SIM.SMF1:=2;
  IMG.SIM.SMF2:=2;
  IMG.SIM.SMF3:=2;
  IMG.SIM.SMF4:=2;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  IMG_Clear;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  IMG_INIT(ReadIni('tagIMG'));
  cmd_Unit:=RegisterStdInCmd('@Unit','');
  cmd_SMF1:=RegisterStdInCmd('@SMF1','');
  cmd_SMF2:=RegisterStdInCmd('@SMF2','');
  cmd_SMF3:=RegisterStdInCmd('@SMF3','');
  cmd_SMF4:=RegisterStdInCmd('@SMF4','');
  cmd_SGC1:=RegisterStdInCmd('@SGC1','');
  cmd_SGC2:=RegisterStdInCmd('@SGC2','');
  cmd_SGC3:=RegisterStdInCmd('@SGC3','');
  cmd_SGC4:=RegisterStdInCmd('@SGC4','');
  cmd_DGS:=RegisterStdInCmd ('@DGS','');
  cmd_EMI1:=RegisterStdInCmd('@EMI1','');
  cmd_EMI2:=RegisterStdInCmd('@EMI2','');
  cmd_RST:=RegisterStdInCmd ('@RST','');
 end;
 //
 // IMG finalization
 //
 procedure IMG_Free;
 begin
  bNul(ComClose);
 end;
 //
 // IMG polling
 //
 procedure IMG_Poll;
 begin
  if IMG.Simulator then begin
   if ComOpened then while IMG_Readln(IMG.COM.Req,IMG.COM.Buf) do IMG_SIMULATOR(IMG.COM.Req);
  end else begin
   if mSecNow-FixmSecNow>DelayOnStart then IMG_CMD_CYCLE;
  end;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  IMG_Free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  GUIHandler;
  IMG_Poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @Unit n
   }
   if (cmdid = cmd_Unit) then begin
    IMG.UNI.dat:=Val(arg);
    EnableCmdNum(cm_UNI_write,true);
    Data:='';
   end else
   {
   SMF1 n
   }
   if (cmdid = cmd_SMF1) then begin
    IMG.SMF1.dat:=Val(arg);
    EnableCmdNum(cm_SMF_write_1,true);
    Data:='';
   end else
   {
   @SMF2 n
   }
   if (cmdid = cmd_SMF2) then begin
    IMG.SMF2.dat:=Val(arg);
    EnableCmdNum(cm_SMF_write_2,true);
    Data:='';
   end else
   {
   @SMF3 n
   }
   if (cmdid = cmd_SMF3) then begin
    IMG.SMF3.dat:=Val(arg);
    EnableCmdNum(cm_SMF_write_3,true);
    Data:='';
   end else
   {
   @SMF4 n
   }
   if (cmdid = cmd_SMF4) then begin
    IMG.SMF4.dat:=Val(arg);
    EnableCmdNum(cm_SMF_write_4,true);
    Data:='';
   end else
   {
   SGC1 n
   }
   if (cmdid = cmd_SGC1) then begin
    IMG.SGC1.dat:=Val(arg);
    EnableCmdNum(cm_SGC_write_1,true);
    Data:='';
   end else
   {
   @SGC2 n
   }
   if (cmdid = cmd_SGC2) then begin
    IMG.SGC2.dat:=Val(arg);
    EnableCmdNum(cm_SGC_write_2,true);
    Data:='';
   end else
   {
   @SGC3 n
   }
   if (cmdid = cmd_SGC3) then begin
    IMG.SGC3.dat:=Val(arg);
    EnableCmdNum(cm_SGC_write_3,true);
    Data:='';
   end else
   {
   @SGC4 n
   }
   if (cmdid = cmd_SGC4) then begin
    IMG.SGC4.dat:=Val(arg);
    EnableCmdNum(cm_SGC_write_4,true);
    Data:='';
   end else
   {
   @DGS n
   }
   if (cmdid = cmd_DGS) then begin
    IMG.DEGAS.dat:=Val(arg);
    EnableCmdNum(cm_DGS_write,true);
    Data:='';
   end else
   {
   @EMI1 n
   }
   if (cmdid = cmd_EMI1) then begin
    IMG.EMI1.dat:=Val(arg);
    EnableCmdNum(cm_EMI_write_1,true);
    Data:='';
   end else
   {
   @EMI2 n
   }
   if (cmdid = cmd_EMI2) then begin
    IMG.EMI2.dat:=Val(arg);
    EnableCmdNum(cm_EMI_write_2,true);
    Data:='';
   end else
   {
   @RST
   }
   if (cmdid = cmd_RST) then begin
    EnableCmdNum(cm_RESET,true);
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
