---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

<a name="content"></a>

# Пример DEMO_HART

Демонстрационная конфигурация **[demo_hart](./)** может служить иллюстрацией и прототипом
для драйверов устройств с протоколом обмена **[HART](hart_spc.djvu)**,
см. также **[обзор](hart_cta.djvu)** и **[коды](hart_drv.pas)**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Состав

В состав демонстрационной **[конфигурации](demo_hart.cfg)** входит:

- драйвер **`&HART_DRV`** и  
- симулятор **`&HART_SIM`**.  

Они полностью моделируют протокол обмена **HART** для реального устройства.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Описание

В рабочем режиме симулятор надо отключить, а также закомментировать канал **`PipeName = .\DEMO_HART`**,
который служит для симуляции **COM** порта.

Как драйвер, так и симулятор реализованы в виде одной и той же программы **[hart_drv.pas](hart_drv.pas)**,
только драйвер имеет ненулевое число **`AnalogOutputs`**, а симулятор - не имеет.
 
В драйвере реализован базовый декодер **[HART](hart_spc.djvu)** протокола,
что позволяет на его основе создавать драйверы для конкретных устройств.

В данном частном случае задаются шаблоны запросов и ответов
``` ini
Cmd#0 = FFFFFFFFFF82ABEF0247C501004700               ; запрос 0
Cmd#1 = FFFFFFFFFF826BECE0F7CE0100DD00               ; запрос 1
Ans#0 = 00FFFFFFFF86ABEF0247C5010700002041B49EB0BF   ; ответ  0
Ans#1 = 00FFFFFFFFFF862BECE0F7CE01070040073CA2BCA45F ; ответ  1
```
Считается ошибкой, если ответ имеет другой адрес, нежели запрос.
Предполагается, что запрос и ответ содержат шаблоны с командой **1** (чтение переменной).
При этом драйвер гоняет запросы по кругу, а симулятор (если запущен) возвращает ответ,
добавляя к шаблону ответа синусоиду с небольшим шумом, для красоты.
Для рабочих драйверов, если нужна только команда чтения данных, достаточно просто
добавить в список соответствующие запросы-ответы и подключить кривые.
Если требуются и другие команды, драйвер берется за основу и расширяется.

Шаблоны запроса и ответа можно (и лучше всего) получить в терминале (например, **AdmiLink**),  
при этом используются параметры: **BaudRate=1200, Parity=ODD, DataBits=8, StopBits=1, DcbFlags=$3020**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---
