VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   5130
   ClientLeft      =   120
   ClientTop       =   450
   ClientWidth     =   4560
   LinkTopic       =   "Form1"
   ScaleHeight     =   5130
   ScaleWidth      =   4560
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox TextRetryCount 
      Alignment       =   1  'Right Justify
      BeginProperty Font 
         Name            =   "Consolas"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1320
      TabIndex        =   3
      Text            =   "0"
      Top             =   2640
      Width           =   1215
   End
   Begin VB.TextBox TextSentCount 
      Alignment       =   1  'Right Justify
      BeginProperty Font 
         Name            =   "Consolas"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   840
      TabIndex        =   1
      TabStop         =   0   'False
      Text            =   "0"
      Top             =   1680
      Width           =   1695
   End
   Begin VB.CommandButton Command1 
      Caption         =   "START"
      Height          =   495
      Left            =   360
      TabIndex        =   0
      Top             =   480
      Width           =   1095
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   3720
      Top             =   4320
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      CommPort        =   4
      DTREnable       =   0   'False
      InBufferSize    =   256
      OutBufferSize   =   256
      BaudRate        =   19200
   End
   Begin VB.Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Retrys Sent"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   1320
      TabIndex        =   4
      Top             =   2280
      Width           =   1095
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Commands Sent"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   1080
      TabIndex        =   2
      Top             =   1320
      Width           =   1335
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Dim stata As Integer        ' 0 = Start button active,  1 = Stop button active
Dim i As Integer

Dim debugSendCount As Long      ' Debug only, count how many commands are sent
Dim debugRetryCount As Long     ' Debug only,  count how mant times command had
                                '     to be sent two or more times

Const SUCCESS = True
Const ERROR = False


Private Sub Command1_Click()

    Dim sendStr As String   ' Command to PU of RS-232
    Dim res As String       ' Response from PU RS-232, "OK" or value or error.
    Dim status As Boolean   ' TRUE if command was successful
    Dim button As VbMsgBoxResult  ' Return Error Msgbox button select, "OK" or "Cancel"
    Dim index1 As Integer   ' PU loop Count, 1,2,3
    Dim Voltage As Integer  ' Set Voltage
    
    If stata = 0 Then
    ' If "Start" clicked
        stata = 1
        Command1.Caption = "Stop"

       ' Use the COM4 serial port.
        MSComm1.CommPort = 4
        MSComm1.Settings = "19200,N,8,1"
        MSComm1.InputLen = 0
        MSComm1.InputMode() = InputModeConstants.comInputModeText
 
        MSComm1.PortOpen = True
        
        For index1 = 1 To 3                                    '機種選択のループ
'            If Check1(index1 - 1).Value = 1 Then                '機種選択ありの確認
                sendStr = "ADR " & index1
                status = PuSend(sendStr, res)
                    If (status = ERROR) Then button = popUpErrorMesg(sendStr, res)
                    If (button = vbCancel) Then End
                
                sendStr = "OUT 1"
                status = PuSend(sendStr, res)
                    If (status = ERROR) Then button = popUpErrorMesg(sendStr, res)
                    If (button = vbCancel) Then End
                
                sendStr = "PC 1"
                status = PuSend(sendStr, res)
                    If (status = ERROR) Then button = popUpErrorMesg(sendStr, res)
                    If (button = vbCancel) Then End
                
                sendStr = "REV?"
                status = PuSend(sendStr, res)
                    If (status = ERROR) Then button = popUpErrorMesg(sendStr, res)
                    If (button = vbCancel) Then End
                
'            End If
        Next index1
        
        While stata = 1
            For Voltage = 1 To 8                                       '電圧変更のループ
                For index1 = 1 To 3            ' Only 3 PU supported    '機種選択のループ
        
                    sendStr = "ADR " & index1
                    status = PuSend(sendStr, res)
                        If (status = ERROR) Then button = popUpErrorMesg(sendStr, res)
                        If (button = vbCancel) Then End
    
                    sendStr = "PV " & Trim(Str(Voltage + (index1 / 10) + (index1 / 100)))
                    status = PuSend(sendStr, res)
                        If (status = ERROR) Then button = popUpErrorMesg(sendStr, res)
                        If (button = vbCancel) Then End
            
                    sendStr = "MV?"
                    status = PuSend(sendStr, res)
                        If (status = ERROR) Then button = popUpErrorMesg(sendStr, res)
                        If (button = vbCancel) Then End
            
                    sendStr = "MC?"
                    status = PuSend(sendStr, res)
                        If (status = ERROR) Then button = popUpErrorMesg(sendStr, res)
                        If (button = vbCancel) Then End
                Next index1
            Next Voltage
            ' Read if the "START/Stop" button was clicked.
            ' The "Stop" click will close the port.
            ' Any more cmds will returnd "CLOSED" error
            DoEvents
        Wend

    Else
        ' If "Stop" clicked
        For index1 = 1 To 3                ' Only 3 PU supported     '機種選択のループ
            
            sendStr = "ADR " & index1
            status = PuSend(sendStr, res)
                If (status = ERROR) Then button = popUpErrorMesg(sendStr, res)
                If (button = vbCancel) Then End

            sendStr = "OUT 0"
            status = PuSend(sendStr, res)
                If (status = ERROR) Then button = popUpErrorMesg(sendStr, res)
                If (button = vbCancel) Then End
        Next index1

        MSComm1.InBufferCount = 0
        stata = 0
        MSComm1.PortOpen = False
        Command1.Caption = "START"
    End If
End Sub

' PU Driver function for sending any RS-232 command or query.
' Will attempt to send command four times until a successful response is returned.
' Adds 50 mSec Sleep if command is address "ADR n"
' Returns ERROR if PU returns an error response, or if RS-232 timeout or checksum error.
' Returns SUCCESS with "response" string being "OK" or string from PU.


Private Function PuSend(command, response) As Boolean

    Dim respAccum As String         ' Cummulate characters as they come back as response from PU
    Dim respError As Boolean        ' Set TRUE if error and need to retry send again
    Dim charInPort As String        ' Number of chars received from PU since last MSComm1.Input
    Dim retryCount As Integer        ' How many times command sent,  trying to get response with <CR>
    
    Dim comChksum As String         ' Command with checksum "$xx" appended
    Dim intChkSum As Integer        ' Interger used to calculate checksum
    Dim dollarPos As Integer        ' Used to parse checksum from response string
    Dim respChksum As String * 2    ' Checksum from response string
    Dim respChksumExpect As String  ' Expected checksum from response string

    Dim i As Integer
    
debugSendCount = debugSendCount + 1     ' Debug counter for adding random faults
TextSentCount.Text = debugSendCount
    
    If MSComm1.PortOpen = False Then    ' The STOP button may close the port
        response = "CLOSED"             '   before the program can finish sending
        PuSend = ERROR                  '   all of its command loop
        Exit Function
    End If
    
    ' Optionally, wait before sending "ADR n" command
    If (InStr(UCase(command), "ADR") > 0) Then
        Sleep (50)
    End If
    
    ' Add checksum to command
    comChksum = Trim(command)
    intChkSum = 0
    For i = 1 To Len(comChksum)
        intChkSum = intChkSum + Asc(Mid(comChksum, i, 1))
    Next i
    comChksum = comChksum & "$" & Right(Hex("00" & intChkSum), 2)
    
    '=======================================================
    ' Try to send command, up to four times, to get a response with <CR>
    '=======================================================
    For retryCount = 0 To 3

If (retryCount > 0) Then
debugRetryCount = debugRetryCount + 1  ' Debug only.  Track how often commands
TextRetryCount.Text = debugRetryCount  '   had to be send more than once
End If
        response = ""
        respAccum = ""
        respError = True        ' By default,  keep sending command until have success
        MSComm1.InBufferCount() = 0     'Clear the receive buffer,  if anything left in it
        
        ' **************  Send the command  ******
        MSComm1.Output = comChksum & vbCr
        
        ' Look for response and <CR>.  Loop up to 50 * 10 = 500 mSec
        For i = 1 To 50
            Sleep (10)
            charInPort = MSComm1.InBufferCount
            If (charInPort > 0) Then
                ' **************  Read part of the response  ******
                respAccum = respAccum + MSComm1.Input
            End If
            
            If (InStr(respAccum, vbCr) > 0) Then
                Exit For            ' Found <CR> returned from the PU
            End If
        Next i
        
        ' **************  Done Reading the response  ******
        If (i > 49) Then
            ' This send of command had no response,  is timeout error
            response = "TMO"        ' Return error description,  or retry sending
            respError = True
        Else
            ' Now have response with <CR> within 500 mSec after sending command
            ' Verify that checksum returned with response from supply matches
            '    checksum calculated here
            dollarPos = InStr(respAccum, "$")   ' Find "$" that marks start of checksum
            ' Verify at least two chars after "$"
            If (dollarPos > 0 And (Len(respAccum) - dollarPos) > 2) Then
                respChksum = Mid(respAccum, dollarPos + 1, 2)
            
                ' Calculate expected checksum for response
                intChkSum = 0
                For i = 1 To (dollarPos - 1)
                    intChkSum = intChkSum + Asc(Mid(respAccum, i, 1))
                Next i
                respChksumExpect = Right(Hex("00" & intChkSum), 2)

                If (respChksum <> respChksumExpect) Then
                    response = "CHKSUM"       ' Return error description,  or retry sending
                    respError = True
                Else
                    ' Response is complete with good checksum.  No need to retry sending
                    ' "respAccum" has actual response string from PU
                    respError = False
                End If
            Else
                ' Not proper checksum returned
                response = "CHKSUM"       ' Return error description,  or retry sending
                respError = True
            End If
        
        End If
        
        ' Exit retry loop if we have response with <CR> and checksum is good
        If ((respError = False) Or _
            (retryCount = 3)) Then
            Exit For
        End If

    Next retryCount
        
    '=======================================================
    ' Finished trying to send command and getting good response
    '=======================================================

    If (respError = True And retryCount = 3) Then
        ' If could not fix communication problem after four retries,
            ' "response" not change, return last error description
            PuSend = ERROR
            Exit Function
    End If
            
    '=======================================================
    ' Now have response with <CR> and good checksum.
    ' Look to see if PU sent an error code for the response
    '=======================================================
    response = Trim(respAccum)
    dollarPos = InStr(response, "$")   ' Find "$" that marks start of checksum
    response = Left(response, dollarPos - 1)    ' Remove checksum from response
    
    If Len(response) = 3 Then
        If (Left(response, 2) = "E0" Or Left(response, 2) = "C0") Then
            PuSend = ERROR        ' response is error string from PU, "E0n" or "C0n"
            Exit Function
        End If
    End If
    ' Response is "OK" or "5.220" (or any valid string from query)
    PuSend = SUCCESS
    Exit Function

End Function

Private Function popUpErrorMesg(command, response)
                
    Dim button As VbMsgBoxResult
    
    button = MsgBox("ERROR with PU message." & vbCrLf & vbCrLf & _
        "SENT: " & command & vbCrLf & _
        "RECV: " & response & vbCrLf & vbCrLf & _
        "Click CANCEL to close program.", vbOKCancel)
    popUpErrorMesg = button
        
End Function

Private Sub Form_Load()
    stata = 0
End Sub
