
//						
// INTRODUCTION
//    This is a simple RS-232 program for the standard Lambda Genesys power supply.
//    It opens a console window with a prompt to enter address and Baud rate.
//    It then sends many "PVD xxxx" commands where 'xxxx' are ASCI hex values.
//    It waits for an "OK<CR>" response betweeen each command.
//    The goal is to see the fastest square wave that can be remotely programmed.
//		Author:   Walter Heyck, TDK-Lambda, 

//      Versions: "GEN RS-232 Console"	 June 2, 2009
//		1. Created a "SendCmd" class, but it does nothing.
//		2. Added a "Console.Read()" to input a RS cmd string.
//		3. Added a SerialPort Read TMO value.
//		4. Added exception handling for ReadLine timeout.
//		   Added 100 mSec wait and then check read buffer. 
//		5. Rename project from "Fast PVD" to "Console".
//		6. Removed double <CR> after <Enter> pressed.

using System;
using System.Collections.Generic;
using System.Text;
using System.IO.Ports;
using System.Threading;			// For 'thread.sleep' delay method

namespace GEN_RS232_Console
{
	class SendCmd
	{
		public string strCmd;
		
		// Constructor: Null
		public SendCmd( )
		{
		}

		public string AddCsCr( string shortCmd )
		{
			return ( string.Concat( shortCmd, "1234"));
		}

	}



	class Program
	{
		static void Main( string[ ] args )
		{
			string inputLine;	    // User message from console input
			string recv;		    // Received response from GEN, ex: "OK"
			string sExit = "X";	    // Comparitor for exiting loop
            string sComNum = "1";   // "COM1" is default port
			string sBaud = "9600";  // "9600" is default BAUD rate

			Console.WriteLine( "\n" );
			Console.WriteLine( "Genesys: RS-232 Console program v07." );
			Console.WriteLine( "-----  Enter \"X\" to exit.  ------" );
			Console.WriteLine( " " );

            Console.WriteLine("Enter COM Port number.");
            Console.Write(    "        (default \"COM1\") --> ");
			sComNum = Console.ReadLine();

			if (sComNum.Length == 0)
				sComNum = "1";			// default "COM1"

			Console.WriteLine("Enter BAUD rate.");
			Console.Write(    "        (default \"9600\") --> ");
			sBaud = Console.ReadLine();
			if (sBaud.Length == 0)
				sBaud = "9600";			// Default 9600 Baud
			Console.WriteLine(" ");

			SerialPort myPort = new SerialPort();

			myPort.PortName = "COM" + sComNum;
			myPort.BaudRate = Convert.ToInt16(sBaud);
			myPort.NewLine = "\r";
			myPort.ReadTimeout = 2000;		// Read TMO = 2.0 Sec

			myPort.Open( );

			while( true)
			{
				while ( myPort.BytesToRead != 0 )
				{
					Console.Write( "      **** Extra Chars: \"" );
					Console.WriteLine(myPort.ReadLine());
					Console.WriteLine( "\"" );
					Thread.Sleep( 100 );
				}
				
				Console.Write( "Send: " );
				inputLine = Console.ReadLine( );

				// Check if quitting program by typing "x" or "X"
				if ( string.Equals( inputLine.ToUpper( ), sExit ) )
					break;

				inputLine.Trim();
				myPort.WriteLine(inputLine);		// Appends <CR> automatically

				try
				{
					recv = myPort.ReadLine( );

					Console.Write( "    \\ " );
					Console.WriteLine( recv );
				}
				catch (TimeoutException)
				{
					Console.WriteLine( "      **** TMO Error ** " );
				}
				Thread.Sleep( 100 );	// Wait for trailing response chars

			}  //End infinite While

			myPort.Close( );

			/////// /////////////////////////////////////////////

			//SendCmd rsCmd = new SendCmd( );

			//rsCmd.strCmd = "MV?";

			//rsCmd.AddCsCr( );



			//string rsCmd = new string( '\0', 50 );

			//rsCmd = string.Copy( "MV?" );

			//SendCmd

			// Hold window open you you can examine it.
			Console.WriteLine( "\nPress <Enter> to close console and quit." );
			inputLine = Console.ReadLine( );
		}
	}
}
