#!/bin/bash

##################################################
# Copyright (c) 2025 negurin <theshitcode@mail.ru>
##################################################

##################################################
# Pacman: map data & gui links & sensors generator
##################################################

# script identification
#######################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";
readonly pacmanMapCrc="../circuits/${scriptbase}_map.crc";
readonly pacmanMapCfg="${scriptbase}_map.cfg";
readonly pacmanTagCfg="${scriptbase}_tags.cfg";

declare -i mapWidth=19;
declare -i mapHeight=21;
declare -i sensStep=16;
declare -i initX=200;
declare -i sensX=200;
declare -i sensY=60;
declare -i x;
declare -i y;

function pacman_make(){
 delete_files $pacmanMapCrc $pacmanTagCfg $pacmanMapCfg;
 make_map_crc >> $pacmanMapCrc;
 make_map_cfg >> $pacmanMapCfg;
 make_tag_cfg >> $pacmanTagCfg;
}

function make_map_cfg(){
 add_links;
}

function make_tag_cfg(){
 add_tags;
}

function make_map_crc(){
 for (( y = 0; y < mapHeight; y++ )) ; do
  for (( x = 0; x < mapWidth; x++ )) ; do
   add_map_sensors;
   let sensX+=$sensStep;
  done;
  let sensY+=$sensStep;
  let sensX=$initX;
 done;
}

function add_tags(){
 echo "[TagList]";
 echo "PACMAN.LIVES = Integer 0";
 echo "PACMAN.LEVEL = Integer 0";
 echo "PACMAN.SCORE = Integer 0";
 echo "PACMAN.STATUS = Integer 0";
 echo "PACMAN.BESTSCORE = Integer 0";
 echo "[]";
 echo "";
 echo "[TagList]";
 for (( y = 0; y < mapHeight; y++ )) ; do
  for (( x = 0; x < mapWidth; x++ )) ; do
   echo "PACMAN.$x.$y = Integer 0";
   let sensX+=$sensStep;
  done;
  let sensY+=$sensStep;
 done;
 echo "[]";
 echo "";
}

function add_links(){
 echo "[PACMAN.MAIN.CTRL]";
 for (( y = 0; y < mapHeight; y++ )) ; do
  for (( x = 0; x < mapWidth; x++ )) ; do
   echo "Link sensor PACMAN.$x.$y with tag PACMAN.$x.$y device &PACMAN.CTRL";
   let sensX+=$sensStep;
  done;
  let sensY+=$sensStep;
 done;
 echo "[]";
 echo "";
}

function add_map_sensors(){
 echo "[SensorList]";
 echo "Sensor = PACMAN.$x.$y";
 echo "[PACMAN.$x.$y]";
 echo "Pos = $sensX, $sensY";
 echo "Tag#1 = 0, ~~/resource/daqsite/stdlib/bitmaps/barbmp_16_16_24_silver.bmp ";
 echo "Tag#2 = 1, ../bitmaps/pacman_food.bmp"   ;
 echo "Tag#3 = 2, ../bitmaps/pacman_self.bmp"   ;
 echo "Tag#4 = 3, ../bitmaps/pacman_blinky.bmp" ;
 echo "Tag#5 = 4, ../bitmaps/pacman_pinky.bmp"  ;
 echo "Tag#6 = 5, ../bitmaps/pacman_inky.bmp"   ;
 echo "Tag#7 = 6, ../bitmaps/pacman_clyde.bmp"  ;
 echo "Tag#8 = 7, ../bitmaps/pacman_dead.bmp"   ;
 echo "Tag#9 = 8, ../bitmaps/pacman_wall.bmp"   ;
 echo "Hint = Pacman map $x,$y (x$x y$y)";
 echo "[]";
 echo "";
}

function delete_files(){
 while [ -n "$1" ]; do
  if [ -e "$1" ]; then rm -f "$1"; fi;
  shift;
 done;
};

function main(){
 if pushd $scriptHOME >/dev/null 2>&1; then
  pacman_make;
 fi;
 popd >/dev/null 2>&1;
};

main "$@";

##############
## END OF FILE
##############
