 {
 ***********************************************************
 Daq Pascal application program TDS_GUI. GUI for driver TDS.
 ***********************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @REG_MODE mmm - TDS remote mode mmm = ALL/NONE
|********************************************************
[]
 }
program TDS_DRV;                 { Driver for Tektronix TDS3012     }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 sDelay1           = 50;         { Small delay after message sent   }

type
 TTagRef     = record tag,nai,ndi,nao,ndo:Integer; val:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 TDS               : record      { All TDS related data             }
  CR               : Char;       { Carriage return symbol           }
  tag              : record      { All TDS tags                     }
   Mode            : Integer;    { TDS is in remote mode            }
  end;                           {                                  }
  GUI              : record      { GUI tags                         }
   CMD             : record      {                                  }
    HELP           : TTagRef;    {                                  }
   end;                          {                                  }
  end;                           {                                  }
 end;                            {                                  }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 var nv:Integer;
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Send message to TDS, i.e. write to COM port. temporary
 }
 function TDS_Send(msg:String; aDelay:Integer):Integer;
 begin
  if Length(msg)>0 then begin
   if ComWrite(msg) then begin
    ViewExp('TDS: '+TrimRight(msg));
    if aDelay>0 then bNul(Sleep(aDelay));
    TDS_Send:=Length(msg);
   end else begin
    Trouble('TDS: Can`t send: '+msg);
    TDS_Send:=0;
   end;
  end else TDS_Send:=0;
 end;
 {
 Handle GUI commands, edit tags etc.
 }
 procedure TDS_GUI_POLL;
 var ClickCurve:Integer;
 begin
  //
  // Handle commands...
  //
  if iGetTag(TDS.GUI.CMD.HELP.tag)<>0 then begin
   DevPostCmdLocal('@BrowseHelp '+DaqFileRef(AdaptFileName(ReadIni('HelpFile')),'.htm'));
   bNul(iSetTag(TDS.GUI.CMD.HELP.tag,0));
  end;
  //
  // Handle sensor clicks...
  //
  if ClickButton=1 then begin
   if IsSameText(ClickSensor,'TDS.MODE') then begin
    //if iGetTag(TDS.tag.Mode)=0
    //then DevSendCmd(devMySelf,'@REG_MODE=ALL')
    //else DevSendCmd(devMySelf,'@REG_MODE=NON');
    bNul(Voice(snd_Click));
   end;
   ClickBitXorLocal(TDS.GUI.CMD.HELP.tag,1);
   {
   Plot & Tab windows
   }
   ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
   if ClickCurve<>0 then begin
    iNul(WinSelectByCurve(ClickCurve,ClickCurve));
    bNul(Voice(snd_Wheel));
   end;
  end;
 end;
 {
 Initialize tags.
 }
 procedure TDS_InitTags(Prefix:String);
 begin
  if not IsEmptyStr(Prefix) then begin
   InitTag(TDS.tag.Mode,            Prefix+'.MODE',           1);
   InitTag(TDS.GUI.CMD.HELP.tag,    Prefix+'.CMD.HELP',       1);
  end;
 end;
 {
 Initialize TDS data
 }
 procedure TDS_Init;
 begin
  TDS.CR:=Chr(_CR);
  //
  // Initialize tags...
  //
  TDS_InitTags(ReadIni('tagTDS'));
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  {
  Initialize device references & tags
  }
  TDS_Init;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  TDS_GUI_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,w1,w2:String;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   w1:=ExtractWord(1,arg);
   w2:=ExtractWord(2,arg);
   {
   @REG_MODE ALL
   }
   if IsSameText(cmd,'@REG_MODE') then begin
    if IsSameText(w1,'ALL') then iNul(TDS_Send(':LOC ALL'+TDS.CR,sDelay1)) else
    if IsSameText(w1,'NON') then iNul(TDS_Send(':LOC NON'+TDS.CR,sDelay1));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
  w1:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
