 {
 ***********************************************************************
 Daq Pascal application program TDS_DRV. Driver for "Tektronix" TDS3012.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @REG_MODE mmm - TDS remote mode mmm = ALL/NONE
| @CLEARM   - Clears the current menu
| @ACQ_SET  - Set acquisition mode of the oscilloscope
| @CHN_SET  - Set vertical parameters
| @HOR_SET  - Set horizontal settings
| @TRIG_SET - Set trigger parameters
|********************************************************
[]
 }
program TDS_DRV;                 { Driver for Tektronix TDS3012     }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 TdsTimeout        = 2000;       { TDS timeout to read COM port     }
 cmdStartup        = 0;          { Startup command, run once        }
 cmdStatus         = 1;          { Command index to read status     }
 cmdReadFreq       = 2;          { Read frequency                   }
 cmdReadAmpl       = 3;          { Read amplitude                   }
 cmdCheckPreset    = 4;          { Checking current presets         }
 MaxNumChan        = 4;          { Maximal number of channels       }
 sDelay1           = 50;         { Small delay after message sent   }
 sDelay2           = 100;        { Small delay after message sent   }
 ao_TDS_FREQ       = 0;          { Analog Outputs                   }
 ao_TDS_AMPL       = 1;          {                                  }
 ao_TDS_SIGN_FREQ  = 2;          {                                  }
 ao_POLLRATE       = 3;          {                                  }
 ao_ERRORCNT       = 4;          {                                  }
 pre_AcqMod        = 1;          { Presets...                       }
 pre_AcqNma        = 2;          {                                  }
 pre_AcqNme        = 3;          {                                  }
 pre_AcqStt        = 4;          {                                  }
 pre_AcqStp        = 5;          {                                  }
 pre_ChnScl        = 6;          {                                  }
 pre_ChnPos        = 7;          {                                  }
 pre_ChnOff        = 8;          {                                  }
 pre_ChnCpl        = 9;          {                                  }
 pre_ChnBnd        = 10;         {                                  }
 pre_ChnDsk        = 11;         {                                  }
 pre_ChnImp        = 12;         {                                  }
 pre_ChnPrb        = 13;         {                                  }
 pre_ChnYun        = 14;         {                                  }
 pre_ChnInv        = 15;         {                                  }
 pre_HorRes        = 16;         {                                  }
 pre_HorTrg        = 17;         {                                  }
 pre_HorScl        = 18;         {                                  }
 pre_HorStt        = 19;         {                                  }
 pre_HorTim        = 20;         {                                  }
 pre_TrgTyp        = 21;         {                                  }
 pre_TrgCpl        = 22;         {                                  }
 pre_TrgSlo        = 23;         {                                  }
 pre_TrgSou        = 24;         {                                  }
 pre_TrgTim        = 25;         {                                  }
 pre_TrgLev        = 26;         {                                  }
 pre_MaxCmd        = 26;         {                                  }
 max_freq          = 250;        { Maximum frequency                }
 max_ampl          = 10;         { Maximum amplitude                }

type
 TTagRef     = record tag,nai,ndi,nao,ndo:Integer; val:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 TDS               : record      { All TDS related data             }
  CR               : Char;       { Carriage return symbol           }
  ModelNum         : Integer;    { The model number, like 3012      }
  Simulation       : Boolean;    { Simulation mode                  }
  ComPort          : Integer;    { COM port number                  }
  ChanMap          : String;     { Uses channels list, like 1010    }
  cmdIndex         : Integer;    { Index of command to execute next }
  QueryTime        : Real;       { Time when last DataQuery sent    }
  Query            : String;     { Query (request) sent tpo TDS     }
  Reply            : String;     { Reply (answer) got from TDS      }
  ComBuff          : String;     { Buffer to readout from COM port  }
  PollRate         : Integer;    { Poll rate, poll/sec              }
  PresetTime       : Real;       {                                  }
  frq_val          : Real;       {                                  }
  amp_val          : Real;       {                                  }
  amplThresh       : Integer;    {                                  }
  UpdDateTime      : Real;       {                                  }
  UpdOnline        : Real;       {                                  }
  UpdMode          : Real;       {                                  }
  UpdThresh        : Real;       {                                  }
  CMD              : record      {                                  }
   Acronim         : array [1..pre_MaxCmd] of String; {             }
   OpData          : array [1..pre_MaxCmd] of String; {             }
   Number          : Integer;    {                                  }
  end;                           {                                  }
  tag              : record      { All TDS tags                     }
   Ident           : Integer;    { TDS identifier                   }
   DateTime        : Integer;    { TDS date and time                }
   Online          : Integer;    { TDS is online, RS232 connected   }
   Mode            : Integer;    { TDS is in remote mode            }
  end;                           {                                  }
 end;                            {                                  }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {
 String filter: skip Reject chars, pass Include chars.
 Mode 1 (bit0): no case sensetive filtering.
 Mode 2 (bit1): replace skipped  chars to Space char.
 Mode 4 (bit2): replace rejected chars to Space char.
 }
 function StrFilter(Data,Includ,Reject:String; Mode:Integer; Space:Char):String;
 var s,c:String; LR,LI,i:Integer;
 begin
  s:=''; c:='';
  LR:=Length(Reject); LI:=Length(Includ);
  if iAnd(Mode,1)>0 then Reject:=UpCaseStr(Reject);
  if iAnd(Mode,1)>0 then Includ:=UpCaseStr(Includ);
  for i:=1 to Length(Data) do begin
   c:=Copy(Data,i,1);
   if iAnd(Mode,1)>0 then c:=UpCaseStr(c);
   if (LR=0) or (Pos(c,Reject)=0) then begin
    if (LI=0) or (Pos(c,Includ)>0) then s:=s+c else if iAnd(mode,2)>0 then s:=s+Space;
   end else begin
    if iAnd(mode,4)>0 then s:=s+Space;
   end;
  end;
  StrFilter:=s;
  s:=''; c:='';
 end;
 {
 Send message to TDS, i.e. write to COM port.
 }
 function TDS_Send(msg:String; aDelay:Integer):Integer;
 begin
  if Length(msg)>0 then begin
   if ComWrite(msg) then begin
    ViewExp('TDS: '+TrimRight(msg));
    if aDelay>0 then bNul(Sleep(aDelay));
    TDS_Send:=Length(msg);
   end else begin
    Trouble('TDS: Can`t send: '+msg);
    TDS_Send:=0;
   end;
  end else TDS_Send:=0;
 end;
 {
 Очистить приемник COM-порта и передать в порт новый запрос
 }
 procedure TDS_SendQuery(aQuery:string);
 begin
  PurgeComPort;
  TDS.Query:='';
  TDS.Reply:='';
  TDS.ComBuff:='';
  if Length(aQuery)>0 then
  if TDS_Send(aQuery+TDS.CR,0)>0 then begin
   TDS.Query:=aQuery;
   TDS.QueryTime:=mSecNow;
   Details('QUERY: '+aQuery);
  end else Trouble('SendQuery fails');
 end;
 {
 Очистить запрос
 }
 procedure TDS_FreeQuery(aReply:string);
 begin
  if Length(aReply)>0 then Details('TDS: REPLY '+aReply);
  TDS.ComBuff:='';
  TDS.Query:='';
  TDS.Reply:='';
  PurgeComPort;
 end;
 {
 Reset TDS data after TimeOut.
 }
 procedure TDS_ResetTimeout(aReply:string);
 begin
  if not IsEmptyStr(aReply) then Trouble(aReply);
  TDS_FreeQuery(aReply);
  TDS.cmdIndex:=cmdStartup;
  bNul(iSetTag(TDS.tag.Mode,0));
  bNul(iSetTag(TDS.tag.Online,0));
  bNul(sSetTag(TDS.tag.Ident,'?'));
  bNul(sSetTag(TDS.tag.DateTime,'?'));
 end;
 {
 Send TDS preset parameters to COM port
 }
 procedure TDS_SendPresets;
 begin
  DevSendCmd(devMySelf,'@ACQ_SET');
  DevSendCmd(devMySelf,'@CHN_SET');
  DevSendCmd(devMySelf,'@HOR_SET');
  DevSendCmd(devMySelf,'@TRIG_SET');
  DevSendCmd(devMySelf,'@CLEARM');
 end;
 {
 Check preset
 }
 procedure Check_Preset;
 var i:Integer; s:String;
 begin
  for i:=1 to pre_MaxCmd do begin
   if TDS.CMD.Number=i then begin
    if Length(TDS.Query)=0 then begin
     TDS_SendQuery(TDS.CMD.Acronim[i]+'?');
    end else
    if Length(TDS.Reply)>0 then begin
     s:=ExtractWord(1,TDS.Reply);
     if not IsSameText(s,TDS.CMD.OpData[i]) then begin
      TDS_SendPresets;
      TDS.CMD.Number:=0;
     end;
     if TDS.CMD.Number<pre_MaxCmd
     then TDS.CMD.Number:=TDS.CMD.Number+1
     else TDS.CMD.Number:=1;
     TDS.PresetTime:=mSecNow;
     TDS.cmdIndex:=cmdStatus;
     TDS_FreeQuery(TDS.Reply);
    end;
   end;
  end;
 end;
 {
 Clear commands.
 }
 procedure TDS_Clear_Cmd;
 var i:Integer;
 begin
  for i:=1 to pre_MaxCmd do begin
   TDS.Cmd.Acronim[i]:='';
   TDS.Cmd.OpData[i]:='';
  end;
 end;
 {
 Initialize preset commands.
 }
 procedure TDS_Init_Cmd;
  //
  // Check command number.
  //
  function IsValidCmdNum(n:Integer):Boolean;
  begin
   IsValidCmdNum:=(n>=1) and (n<=pre_MaxCmd);
  end;
  procedure CmdSet(n:Integer; Acronim,OpData:String);
  begin
   if IsValidCmdNum(n) then begin
    TDS.Cmd.Acronim[n]:=Acronim;
    TDS.Cmd.OpData[n]:=OpData;
   end;
  end;
 begin
  ////// Command      Acronim           OpDatax
  CmdSet(pre_acqmod, 'ACQ:MOD',         'AVE');
  CmdSet(pre_acqnma, 'ACQ:NUMAV',       '16');
  CmdSet(pre_acqnme, 'ACQ:NUME',        '128');
  CmdSet(pre_acqstt, 'ACQ:STATE',       str(1));
  CmdSet(pre_acqstp, 'ACQ:STOPA',       'RUNST');
  CmdSet(pre_chnscl, 'CH1:SCAL',        '1.0E0');
  CmdSet(pre_chnpos, 'CH1:POS',         '-3.0E0');
  CmdSet(pre_chnoff, 'CH1:OFFSET',      '0.0E0');
  CmdSet(pre_chncpl, 'CH1:COUP',        'DC');
  CmdSet(pre_chnbnd, 'CH1:BAND',        'FUL');
  CmdSet(pre_chndsk, 'CH1:DESK',        '0.0E0');
  CmdSet(pre_chnimp, 'CH1:IMP',         'MEG');
  CmdSet(pre_chnprb, 'CH1:PROB',        '1.0E0');
  CmdSet(pre_chnyun, 'CH1:YUN',         '"V"');
  CmdSet(pre_chninv, 'CH1:INV',         str(0));
  CmdSet(pre_horres, 'HOR:RESO',        'HIGH');
  CmdSet(pre_hortrg, 'HOR:TRIG:POS',    '1.0E1');
  CmdSet(pre_horscl, 'HOR:MAI:SCAL',    '2.0E-3');
  CmdSet(pre_horstt, 'HOR:DEL:STATE',   str(1));
  CmdSet(pre_hortim, 'HOR:DEL:TIM',     '0.0E0');
  CmdSet(pre_trgtyp, 'TRIG:A:TYP',      'EDG');
  CmdSet(pre_trgcpl, 'TRIG:A:EDG:COUP', 'DC');
  CmdSet(pre_trgslo, 'TRIG:A:EDG:SLO',  'RIS');
  CmdSet(pre_trgsou, 'TRIG:A:EDG:SOU',  'EXT');
  CmdSet(pre_trgtim, 'TRIG:A:HOL:TIM',  '2.508E-7');
  CmdSet(pre_trglev, 'TRIG:A:LEV',      '8.0E-1');
 end;
 {
 Initialize tags.
 }
 procedure TDS_InitTags(Prefix:String);
 begin
  if not IsEmptyStr(Prefix) then begin
   InitTag(TDS.tag.Ident,       Prefix+'.IDENT',    3);
   InitTag(TDS.tag.DateTime,    Prefix+'.DATETIME', 3);
   InitTag(TDS.tag.Online,      Prefix+'.ONLINE',   1);
   InitTag(TDS.tag.Mode,        Prefix+'.MODE',     1);
   InitTag(TDS.amplThresh,      Prefix+'.THRESH',   2);
  end;
 end;
 {
 Clear all TDS data
 }
 procedure TDS_Clear;
 begin
  TDS.ComPort:=0;
  TDS.ChanMap:='';
  TDS.Simulation:=False;
  TDS.cmdIndex:=cmdStartup;
  TDS.Query:='';
  TDS.Reply:='';
  TDS.ComBuff:='';
  TDS_Clear_Cmd;
 end;
 {
 Initialize TDS data
 }
 procedure TDS_Init;
 begin
  TDS_Clear;
  TDS.CR:=Chr(_CR);
  TDS.Simulation:=(Val(ReadIni('Simulation'))=1);
  //
  // Read and open ComPort
  //
  TDS.ComPort:=Val(ReadIni('ComPort'));
  if TDS.ComPort>0 then begin
   if ComOpen('[SerialPort-COM'+Str(TDS.ComPort)+']')
   then Success('ComPort '+Str(TDS.ComPort)+' opened') else begin
    Trouble('Could not open ComPort '+Str(TDS.ComPort));
    TDS.ComPort:=0;
   end;
  end else begin
   Trouble('Invalid ComPort='+Str(TDS.ComPort));
   TDS.ComPort:=0;
  end;
  //
  // Initialize tags...
  //
  TDS_InitTags(ReadIni('tagTDS'));
  //
  // Read and check ChanMap
  //
  TDS.ChanMap:=StrFilter(Copy(Trim(ReadIni('ChanMap')),1,MaxNumChan),'01','',0,' ');
  if Length(TDS.ChanMap)>0
  then Success('ChanMap = '+TDS.ChanMap)
  else Trouble('ChanMap is not specified.');
  //
  // Open COM port
  //
  if ComOpen('[SerialPort-COM'+Str(TDS.ComPort)+']')
  then Success('Serial port COM'+Str(TDS.ComPort)+' is opened.')
  else Trouble('Could not open serial port COM'+Str(TDS.ComPort));
  //
  // Initialize variables
  //
  TDS_Init_Cmd;
  TDS.CMD.Number:=1;
  TDS.PresetTime:=mSecNow;
  TDS.frq_val:=0;
  TDS.amp_val:=0;
  TDS.UpdDateTime:=-1e300;
  TDS.UpdOnline:=-1e300;
  TDS.UpdMode:=-1e300;
  TDS.UpdThresh:=-1e300;
 end;
 {
 Free TDS data
 }
 procedure TDS_Free;
 begin
  if not TDS.Simulation then
  if TDS.ComPort>0 then begin
   iNul(TDS_Send(':LOC NON'+TDS.CR,250));
   if ComClose then Success('Serial port COM'+Str(TDS.ComPort)+' was closed.');
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  TDS_Clear;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  {
  Initialize device references & tags
  }
  TDS_Init;
  TDS_ResetTimeOut('');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  TDS_Free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 var x,y,r,sim_val:Real; i,j,code:Integer;
  function ExtractDateTime(date,time:String):Real;
  var dy,dm,dd,th,tm,ts:Integer;
  begin
   date:=StrReplace(date,dump('"'),dump(' '),3);
   date:=StrReplace(date,dump('-'),dump(' '),3);
   time:=StrReplace(time,dump('"'),dump(' '),3);
   time:=StrReplace(time,dump(':'),dump(' '),3);
   dy:=Val(ExtractWord(1,date)); dm:=Val(ExtractWord(2,date)); dd:=Val(ExtractWord(3,date));
   th:=Val(ExtractWord(1,time)); tm:=Val(ExtractWord(2,time)); ts:=Val(ExtractWord(3,time));
   ExtractDateTime:=DateTime2ms(dy,dm,dd,th,tm,ts,0);
  end;
  function FormatDate(t:Real):String;
  begin
   FormatDate:= StrAddQuotes(StrReplace(Copy(GetDateTime(t),1,10),Dump('.'),Dump('-'),3),'"');
  end;
  function FormatTime(t:Real):String;
  begin
   FormatTime:= StrAddQuotes(Copy(GetDateTime(t),12),'"');
  end;
  function SimulateWave(i:Integer):real;
  var t,w:Real;
  begin
   t:=time;
   w:=(sin(i*0.1*(t*t*i))+power(i,1/2));
   SimulateWave:=w;
  end;
 begin
  if ShouldRefresh(TDS.UpdThresh,rGetTag(TDS.amplThresh))>0 then DIM_UpdateTag(TDS.amplThresh,'');
  //
  // Update error count curve and poll rate curve
  //
  if SysTimer_Pulse(1000)>0 then begin
   UpdateAo(ao_ERRORCNT,time,GetErrCount(-1));
   UpdateAo(ao_POLLRATE,time,TDS.PollRate);
   TDS.PollRate:=0;
  end;
  //
  // Simulation mode: receive Query, answer Reply
  //
  if TDS.Simulation then begin
   while Com_ReadLn(TDS.Query,TDS.ComBuff) do begin
    ViewImp('TDS: '+TDS.Query);
    if IsSameText(TDS.Query,':RS232:TRAN:TERM?;:RS232:HARDF?;:MESS:STATE?;:VERB?;:HEAD?;:ID?') then begin
     iNul(TDS_Send('CR;0;0;0;0;ID TEK/TDS 3012B,CF:91.1CT,FV:v3.26 TDS3GV:v1.00 TDS3FFT:v1.00 TDS3TRG:v1.00'+TDS.CR,0));
    end;
    if IsSameText(TDS.Query,':TRIG:STATE?;:LOC?;DATE?;:TIME?;') then begin
     iNul(TDS_Send('SAV;ALL;'+FormatDate(mSecNow)+';'+FormatTime(mSecNow)+TDS.CR,0));
    end;
    if IsSameText(Tds.Query,':MEASU:IMM:TYP FREQ;:MEASU:IMM:DAT?;') then begin
     sim_val:=SimulateWave(10000);
     iNul(TDS_Send(str(sim_val)+TDS.CR,0));
    end;
    if IsSameText(Tds.Query,':MEASU:IMM:TYP AMPL;:MEASU:IMM:DAT?;') then begin
     sim_val:=SimulateWave(10);
     iNul(TDS_Send(str(sim_val)+TDS.CR,0));
    end;
    for i:=1 to pre_MaxCmd do
    if IsSameText(Tds.Query,TDS.CMD.Acronim[i]+'?') then begin
     iNul(TDS_Send(TDS.Cmd.OpData[i]+TDS.CR,0));
    end;
   end;
  end;
  //
  // Driver mode: receive Reply, send Query
  //
  if not TDS.Simulation then
  if (Length(TDS.Query)>0) and (Length(TDS.Reply)=0) then begin
   {
   При чтении ASCII данных ищем символ CR для выделения сообщения.
   По таймауту сбрасываем операцию чтения.
   }
   if mSecNow<TDS.QueryTime+TdsTimeout then begin
    if Com_ReadLn(TDS.Reply,TDS.ComBuff) then begin
     ViewImp('TDS: '+TDS.Reply);
     bNul(iSetTag(TDS.tag.Online,1));
     TDS.PollRate:=TDS.PollRate+1;
    end else begin
     if Length(TDS.ComBuff)>250 then begin
      TDS_FreeQuery('Line is too long.');
      Trouble('Line is too long.');
     end;
    end;
   end else begin
    TDS_ResetTimeOut('TIMEOUT, QUERY');
   end;
   if ShouldRefresh(TDS.UpdOnline,iGetTag(TDS.tag.Online))>0 then DIM_UpdateTag(TDS.tag.Online,'');
  end else begin
   {
   Основной цикл команд
   }
   {Initialization, run once on startup}
   if TDS.cmdIndex = cmdStartup then begin
    Details('cmdStartup');
    if Length(TDS.Query)=0 then begin
     iNul(TDS_Send(':RS232:TRAN:TERM CR;'
                  +':RS232:HARDF OFF;'
                  +':MESS:STATE OFF;'
                  +':VERB OFF;'
                  +':HEAD OFF;'
                  +':LOC NON;' // ALL/NON
                  +':DATE '+FormatDate(mSecNow)+';'
                  +':TIME '+FormatTime(mSecNow)+TDS.CR,sDelay2));
     TDS_SendQuery(':RS232:TRAN:TERM?;:RS232:HARDF?;:MESS:STATE?;:VERB?;:HEAD?;:ID?');
    end else
    if Length(TDS.Reply)>0 then begin
     if (ExtractWord(1,TDS.Reply)='CR') and
        (ExtractWord(2,TDS.Reply)='0')  and
        (ExtractWord(3,TDS.Reply)='0')  and
        (ExtractWord(4,TDS.Reply)='0')  and
        (ExtractWord(5,TDS.Reply)='0')  then
     begin
      TDS_SendPresets;
      TDS.cmdIndex:=cmdStatus;
      if IsSameText(ExtractWord(6,TDS.Reply),'ID')
      then bNul(sSetTag(TDS.tag.Ident,ExtractWordDelims(2,ExtractWord(7,TDS.Reply),' ,/')+' '
                                     +ExtractWord(8,TDS.Reply)));
      TDS.ModelNum:=Val(StrFilter(ExtractWord(2,sGetTag(TDS.tag.Ident)),'0123456789','',0,' '));
      Success('TDS model is '+Str(TDS.ModelNum));
     end;
     TDS_FreeQuery(TDS.Reply);
    end;
   end else
   {
   Readout status, frequency, amplitude and check presets.
   }
   if TDS.cmdIndex = cmdStatus then begin
    Details('cmdStatus');
    if Length(TDS.Query)=0 then begin
     TDS_SendQuery(':TRIG:STATE?;:LOC?;DATE?;:TIME?;');
    end else
    if Length(TDS.Reply)>0 then begin
     r:=ExtractDateTime(ExtractWord(3,TDS.Reply),ExtractWord(4,TDS.Reply));
     if not IsNan(r) then bNul(sSetTag(TDS.tag.DATETIME,GetDateTime(r)));
     if not IsEmptyStr(ExtractWord(2,TDS.Reply)) then
     bNul(iSetTag(TDS.tag.Mode,Ord(IsSameText(ExtractWord(2,TDS.Reply),'ALL'))));
     TDS.cmdIndex:=cmdReadFreq;
     TDS_FreeQuery(TDS.Reply);
     if ShouldRefresh(TDS.UpdMode,iGetTag(TDS.tag.Mode))>0 then DIM_UpdateTag(TDS.tag.Mode,'');
     if ShouldRefresh(TDS.UpdDateTime,r)>0 then DIM_UpdateTag(TDS.tag.DATETIME,'');
    end;
   end else
   if TDS.cmdIndex = cmdReadFreq then begin
    Details('cmdStatus');
    if Length(TDS.Query)=0 then begin
     TDS_SendQuery(':MEASU:IMM:TYP FREQ;:MEASU:IMM:DAT?;');
    end else
    if Length(TDS.Reply)>0 then begin
     r:=rVal(ExtractWord(1,TDS.Reply));
     if r<=max_freq
     then begin
      UpdateAo(ao_TDS_FREQ, time, r);
      TDS.frq_val:=r;
     end else begin
      UpdateAo(ao_TDS_FREQ, time, 0);
      TDS.frq_val:=0;
     end;
     TDS.cmdIndex:=cmdReadAmpl;
     TDS_FreeQuery(TDS.Reply);
    end;
   end else
   if TDS.cmdIndex = cmdReadAmpl then begin
    Details('cmdStatus');
    if Length(TDS.Query)=0 then begin
     TDS_SendQuery(':MEASU:IMM:TYP AMPL;:MEASU:IMM:DAT?;');
    end else
    if Length(TDS.Reply)>0 then begin
     r:=rVal(ExtractWord(1,TDS.Reply));
     if r<=max_ampl
     then begin
      UpdateAo(ao_TDS_AMPL, time, r);
      TDS.amp_val:=r;
     end else begin
      UpdateAo(ao_TDS_AMPL, time, 0);
      TDS.amp_val:=0;
     end;
     TDS.cmdIndex:=cmdCheckPreset;
     TDS_FreeQuery(TDS.Reply);
    end;
   end else
   if TDS.cmdIndex=cmdCheckPreset then
   if mSecNow>TDS.PresetTime+1000 then Check_Preset
   else TDS.cmdIndex:=cmdStatus;
  end;
  if TDS.amp_val>=rGetTag(TDS.amplThresh)
  then UpdateAo(ao_TDS_SIGN_FREQ, time, TDS.frq_val)
  else UpdateAo(ao_TDS_SIGN_FREQ, time, 0);
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,w1,w2:String;
 begin
  ViewImp('CON: '+Data);
  TDS.cmdIndex:=cmdStatus;
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  {
  Simulation mode
  }
  if TDS.Simulation then
  if GotCommand(Data,cmd,arg) then begin
   w1:=ExtractWord(1,arg);
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  {
  Driver mode
  }
  if not TDS.Simulation then
  if GotCommand(Data,cmd,arg) then begin
   w1:=ExtractWord(1,arg);
   w2:=ExtractWord(2,arg);
   {
   @REG_MODE ALL
   }
   if IsSameText(cmd,'@REG_MODE') then begin
    if IsSameText(w1,'ALL') then iNul(TDS_Send(':LOC ALL'+TDS.CR,sDelay1)) else
    if IsSameText(w1,'NON') then iNul(TDS_Send(':LOC NON'+TDS.CR,sDelay1));
    Data:='';
   end else
   {
   @CLEARM
   }
   if IsSameText(cmd,'@CLEARM') then begin
    iNul(TDS_Send(':CLEARM'+TDS.CR,sDelay1));
    Data:='';
   end else
   {
   @ACQ_SET
   }
   if IsSameText(cmd,'@ACQ_SET') then begin
    iNul(TDS_Send(':'+TDS.Cmd.Acronim[pre_acqmod]+' '+TDS.Cmd.OpData[pre_acqmod]+';'+
                  ':'+TDS.Cmd.Acronim[pre_acqnma]+' '+TDS.Cmd.OpData[pre_acqnma]+';'+
                  ':'+TDS.Cmd.Acronim[pre_acqnme]+' '+TDS.Cmd.OpData[pre_acqnme]+';'+
                  ':'+TDS.Cmd.Acronim[pre_acqstt]+' '+TDS.Cmd.OpData[pre_acqstt]+';'+
                  ':'+TDS.Cmd.Acronim[pre_acqstp]+' '+TDS.Cmd.OpData[pre_acqstp]+';'+
                  TDS.CR,sDelay2));
    Data:='';
   end else
   {
   @CHN_SET
   }
   if IsSameText(cmd,'@CHN_SET') then begin
    iNul(TDS_Send(':'+TDS.Cmd.Acronim[pre_chnprb]+' '+TDS.Cmd.OpData[pre_chnprb]+';'+
                  ':'+TDS.Cmd.Acronim[pre_chnscl]+' '+TDS.Cmd.OpData[pre_chnscl]+';'+
                  ':'+TDS.Cmd.Acronim[pre_chnpos]+' '+TDS.Cmd.OpData[pre_chnpos]+';'+
                  ':'+TDS.Cmd.Acronim[pre_chnoff]+' '+TDS.Cmd.OpData[pre_chnoff]+';'+
                  ':'+TDS.Cmd.Acronim[pre_chncpl]+' '+TDS.Cmd.OpData[pre_chncpl]+';'+
                  ':'+TDS.Cmd.Acronim[pre_chnbnd]+' '+TDS.Cmd.OpData[pre_chnbnd]+';'+
                  ':'+TDS.Cmd.Acronim[pre_chndsk]+' '+TDS.Cmd.OpData[pre_chndsk]+';'+
                  ':'+TDS.Cmd.Acronim[pre_chnimp]+' '+TDS.Cmd.OpData[pre_chnimp]+';'+
                  ':'+TDS.Cmd.Acronim[pre_chnyun]+' '+TDS.Cmd.OpData[pre_chnyun]+';'+
                  ':'+TDS.Cmd.Acronim[pre_chninv]+' '+TDS.Cmd.OpData[pre_chninv]+';'+
                  TDS.CR,sDelay2));
    Data:='';
   end else
   {
   @HOR_SET
   }
   if IsSameText(cmd,'@HOR_SET') then begin
    iNul(TDS_Send(':'+TDS.Cmd.Acronim[pre_horres]+' '+TDS.Cmd.OpData[pre_horres]+';'+
                  ':'+TDS.Cmd.Acronim[pre_hortrg]+' '+TDS.Cmd.OpData[pre_hortrg]+';'+
                  ':'+TDS.Cmd.Acronim[pre_horscl]+' '+TDS.Cmd.OpData[pre_horscl]+';'+
                  ':'+TDS.Cmd.Acronim[pre_horstt]+' '+TDS.Cmd.OpData[pre_horstt]+';'+
                  ':'+TDS.Cmd.Acronim[pre_hortim]+' '+TDS.Cmd.OpData[pre_hortim]+';'+
                  TDS.CR,sDelay2));
    Data:='';
   end else
   {
   @TRIG_SET
   }
   if IsSameText(cmd,'@TRIG_SET') then begin
    iNul(TDS_Send(':'+TDS.Cmd.Acronim[pre_trgtyp]+' '+TDS.Cmd.OpData[pre_trgtyp]+';'+
                  ':'+TDS.Cmd.Acronim[pre_trgcpl]+' '+TDS.Cmd.OpData[pre_trgcpl]+';'+
                  ':'+TDS.Cmd.Acronim[pre_trgslo]+' '+TDS.Cmd.OpData[pre_trgslo]+';'+
                  ':'+TDS.Cmd.Acronim[pre_trgsou]+' '+TDS.Cmd.OpData[pre_trgsou]+';'+
                  ':'+TDS.Cmd.Acronim[pre_trgtim]+' '+TDS.Cmd.OpData[pre_trgtim]+';'+
                  ':'+TDS.Cmd.Acronim[pre_trglev]+' '+TDS.Cmd.OpData[pre_trglev]+';'+
                  TDS.CR,sDelay2));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
  w1:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
