@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion
:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright(c) 2021 Alexey Kuryakin kouriakine@mail.ru
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Tool to Write dim_ping_benchmark DAQ config file.
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:Main
:SetSelfInfo
set SelfArgs=%*
set "SelfExt=%~x0"
set "SelfBase=%~n0"
set "SelfName=%~nx0"
set "SelfFile=%~f0"
set "SelfDir=%~dp0"
set "SelfDir=%SelfDir:~0,-1%"
for %%i in ("%~dp0\.") do set "SelfDir=%%~fi"

:StartProcessing
call :InitVariables
call :SetErrorLevel 0
call :SelfTitle %SelfArgs%

:CheckOptions
if "%~1" == ""          ( call :Help %~n0    & goto :EOF )
if "%~1" == "/?"        ( call :Help %~n0    & goto :EOF )
if "%~1" == "-h"        ( call :Help %~n0    & goto :EOF )
if "%~1" == "--help"    ( call :Help %~n0    & goto :EOF )
if "%~1" == "--version" ( call :Version %~n0 & goto :EOF )

:MainProcessing
call :SetErrorLevel 0
::
:: Process command line arguments and options
::
:ProcessArgumentsCycle
if /I "%~1" == "" goto :ProcessArgumentsBreak
::
:: option --dns node
::
:CheckOptDns
if /I "%~1" == "--dns" goto :ExecOptDns
goto :DoneOptDns
:ExecOptDns
call :SetEnv DIM_DNS_NODE %2 || ( 1>&2 echo Error: Invalid option %1. & exit /b 1)
shift /1 & shift /1
goto :ProcessArgumentsCycle
:DoneOptDns
::
:: option --numserv num
::
:CheckOptNumserv
if /I "%~1" == "--numserv" goto :ExecOptNumserv
goto :DoneOptNumserv
:ExecOptNumserv
call :SetEnv NUMSERV %2 || ( 1>&2 echo Error: Invalid option %1. & exit /b 1)
shift /1 & shift /1
goto :ProcessArgumentsCycle
:DoneOptNumserv
::
:: option --prefix DEMO
::
:CheckOptPrefix
if /I "%~1" == "--prefix" goto :ExecOptPrefix
goto :DoneOptPrefix
:ExecOptPrefix
call :SetEnv PREFIX %2 || ( 1>&2 echo Error: Invalid --option %1. & exit /b 1)
shift /1 & shift /1
goto :ProcessArgumentsCycle
:DoneOptPrefix
::
:: option --defaults
::
:CheckOptPrefix
if /I "%~1" == "--defaults" goto :ExecOptDefaults
goto :DoneOptDefaults
:ExecOptDefaults
call :InitVariables
shift /1
goto :ProcessArgumentsCycle
:DoneOptDefaults
::
:: option --verbose
::
:CheckOptVerbose
if /I "%~1" == "--verbose" goto :ExecOptVerbose
goto :DoneOptVerbose
:ExecOptVerbose
set "VERBOSE=1"
shift /1
goto :ProcessArgumentsCycle
:DoneOptVerbose
::
:: other arguments unknown, skip it
::
:ExecArgUnknown
shift /1
goto :ProcessArgumentsCycle
::
:: break process arguments
::
:ProcessArgumentsBreak
::
:: after cmdline parsing
::
goto :MainExecution
goto :EOF

:MainExecution
call :ValidateVariables
for %%a in ("%SERVER_CONFIG%" "%CLIENT_CONFIG%") do (
 if /i %%a == "%SERVER_CONFIG%" set "DIM_MODE=SERVER"
 if /i %%a == "%CLIENT_CONFIG%" set "DIM_MODE=CLIENT"
 call :PrintWaitFor         !DIM_MODE!
 call :DeleteFiles          %%a
 call :WriteConfigFile    > %%a
 call :TypeConfigFile       %%a
)
call :Sleep 3 Done. .
exit /b 0
goto :EOF

:Version
echo %~1 version 1.0
goto :EOF

:Help
call :Version %1
echo Copyright^(c^) 2021 Alexey Kuryakin kouriakinemail.ru
echo Tool to generate dim_ping_benchmark configuration
echo Usage :
echo  call %1 [options]
echo Options:
echo  -h --help      to print help
echo  --version      to print version
echo  --dns node     to set DIM_DNS_NODE=node
echo  --prefix name  to set DIM service prefix [name] like DEMO
echo  --numserv  n   to set number of services
echo Examples:
echo  call %1 --dns localhost --prefix DEMO --numserv 10
echo.
goto :EOF

:SelfTitle
if not defined SelfFile goto :EOF
if     "%SelfFile: =%" == "%SelfFile%" Title %SelfFile% %*
if not "%SelfFile: =%" == "%SelfFile%" Title "%SelfFile%" %*
goto :EOF

:InitVariables
set "VERBOSE=0"
set "NUMSERV=10"
set "PREFIX=DEMO"
set "DIM_MODE=UNKNOWN"
set "FACILITY=DIM_PING"
set "devmsg=devPostMsg"
set "SERVER_CONFIG=%SelfDir%\%SelfBase:~0,8%_dis.cfg"
set "CLIENT_CONFIG=%SelfDir%\%SelfBase:~0,8%_dic.cfg"
goto :EOF

:ValidateVariables
if not defined DIM_DNS_NODE set "DIM_DNS_NODE=localhost"
goto :EOF

:TypeConfigFile
if "%~1" == "" goto :EOF
if "%VERBOSE%" == "0" goto :EOF
if not exist "%~f1" goto :EOF
type "%~f1"
goto :EOF

:PrintWaitFor
echo.
echo Please wait for generating %1 for %FACILITY%
echo  with options: --prefix %PREFIX% --numserv %NUMSERV% --dns %DIM_DNS_NODE%
echo.
goto :EOF

:WriteConfigFile
if not defined DIM_DNS_NODE goto :EOF
if not defined FACILITY goto :EOF
if not defined PREFIX goto :EOF
call :WriteDimDnsTask
call :WriteTagPrefix
call :WriteTagList
call :WriteDataStorage
call :WriteMainCtrl
call :WriteSpectrWindow
call :WriteCurveWindow
call :WriteTabWindow
call :WriteDatSrv
call :WriteCustomParameters
if /i "%DIM_MODE%" == "SERVER" call :WriteDis
if /i "%DIM_MODE%" == "CLIENT" call :WriteDic
goto :EOF

:WriteDimDnsTask
echo [^&DimSrv]
echo DIM_DNS_NODE = %DIM_DNS_NODE%
echo DIM_TASK     = DIM_TASK/%PREFIX%/%FACILITY%/SERVER
echo StdInFifo    = 4096
echo StdOutFifo   = 4096
echo StdInPipe    = 4096
echo StdOutPipe   = 4096
echo []
echo.
goto :EOF

:WriteTagList
echo [TagList]
echo %PREFIX%.%FACILITY%.DIC_CMND_RATE    = real    0    ; DIM client command     send per second
echo %PREFIX%.%FACILITY%.DIS_CMND_RATE    = real    0    ; DIM server command     read per second
echo %PREFIX%.%FACILITY%.DIC_INFO_RATE    = real    0    ; DIM client information read per second
echo %PREFIX%.%FACILITY%.DIS_INFO_RATE    = real    0    ; DIM server information send per second
echo %PREFIX%.%FACILITY%.DIC_CMND_COUNT   = real    0    ; DIM client command     send counter
echo %PREFIX%.%FACILITY%.DIS_CMND_COUNT   = real    0    ; DIM server command     read counter
echo %PREFIX%.%FACILITY%.DIC_INFO_COUNT   = real    0    ; DIM client information read counter
echo %PREFIX%.%FACILITY%.DIS_INFO_COUNT   = real    0    ; DIM server information send counter
echo %PREFIX%.%FACILITY%.DIC_CMND_B_RATE  = real    0    ; DIM client command     send per second
echo %PREFIX%.%FACILITY%.DIS_CMND_B_RATE  = real    0    ; DIM server command     read per second
echo %PREFIX%.%FACILITY%.DIC_INFO_B_RATE  = real    0    ; DIM client information read per second
echo %PREFIX%.%FACILITY%.DIS_INFO_B_RATE  = real    0    ; DIM server information send per second
echo %PREFIX%.%FACILITY%.DIC_CMND_B_COUNT = real    0    ; DIM client command     send counter
echo %PREFIX%.%FACILITY%.DIS_CMND_B_COUNT = real    0    ; DIM server command     read counter
echo %PREFIX%.%FACILITY%.DIC_INFO_B_COUNT = real    0    ; DIM client information read counter
echo %PREFIX%.%FACILITY%.DIS_INFO_B_COUNT = real    0    ; DIM server information send counter
echo %PREFIX%.%FACILITY%.PING_SEND_BTN    = integer 0    ; Send ping to DIM server button   [Ping]
echo %PREFIX%.%FACILITY%.PING_SEND_CYCLE  = integer 0    ; Send ping to DIM server checkbox [Cycle]
echo %PREFIX%.%FACILITY%.PING_SEND_COUNT  = integer 1    ; Send ping to DIM server [Iteration Count]
echo %PREFIX%.%FACILITY%.PING_SEND_PERIOD = integer 100  ; Send ping to DIM server [Period ms]
echo %PREFIX%.%FACILITY%.PING_SERVER_ON   = integer 1    ; Ping server is ON flag
echo %PREFIX%.%FACILITY%.PING_CLIENT_ON   = integer 1    ; Ping client is ON flag
echo %PREFIX%.%FACILITY%.PING_TIME        = real    0    ; Ping time, i.e. send/receive response time, [ms]
echo %PREFIX%.%FACILITY%.PING_TIME_MEAN   = real    0    ; Ping time, mean value (average value), [ms]
echo %PREFIX%.%FACILITY%.PING_TIME_RMSD   = real    0    ; Ping time, Root Mean Square Deviation, [ms]
echo %PREFIX%.%FACILITY%.PING_STAT_PERIOD = integer 1000 ; Ping time, statistics collect perod, [ms]
echo %PREFIX%.%FACILITY%.NUMSERV          = integer %NUMSERV%    ; Number of services
echo %PREFIX%.%FACILITY%.DATALEN          = integer 24   ; Data lenght to ping [bytes]
echo %PREFIX%.%FACILITY%.DIM_TASK         = string  DIM_TASK/%PREFIX%/%FACILITY%/SERVER
echo %PREFIX%.%FACILITY%.DIM_DNS_NODE     = string  %DIM_DNS_NODE%
echo %PREFIX%.%FACILITY%.DIM_MODE         = string  %DIM_MODE%
echo %PREFIX%.%FACILITY%.CPU_LOAD         = real    0    ; CPU Load, Percent
for /l %%i in (1,1,%NUMSERV%) do call :WriteTagServIter %%i
echo []
echo.
goto :EOF

:WriteTagServIter
if "%~1" == "" goto :EOF
echo %PREFIX%.%FACILITY%.DIC_CMND_%1 = string  ?
echo %PREFIX%.%FACILITY%.DIS_CMND_%1 = string  ?
echo %PREFIX%.%FACILITY%.DIC_INFO_%1 = string  ?
echo %PREFIX%.%FACILITY%.DIS_INFO_%1 = string  ?
goto :EOF

:WriteDataStorage
echo [DataStorage]
echo %PREFIX%.%FACILITY%.PING_TIME_HISTOGRAM = Curve 1002 0 Black       15 0
echo %PREFIX%.%FACILITY%.PING_TIME           = Curve 0 1000 Black       15 1
echo %PREFIX%.%FACILITY%.PING_TIME_MEAN      = Curve 0 1000 Black       15 1
echo %PREFIX%.%FACILITY%.PING_TIME_RMSD      = Curve 0 1000 Black       15 1
echo %PREFIX%.%FACILITY%.DIC_CMND_RATE       = Curve 0 1000 LightRed     0 2
echo %PREFIX%.%FACILITY%.DIS_CMND_RATE       = Curve 0 1000 Red          0 2
echo %PREFIX%.%FACILITY%.DIC_INFO_RATE       = Curve 0 1000 LightBlue    0 2
echo %PREFIX%.%FACILITY%.DIS_INFO_RATE       = Curve 0 1000 Blue         0 2
echo %PREFIX%.%FACILITY%.DIC_CMND_B_RATE     = Curve 0 1000 LightRed     0 2
echo %PREFIX%.%FACILITY%.DIS_CMND_B_RATE     = Curve 0 1000 Red          0 2
echo %PREFIX%.%FACILITY%.DIC_INFO_B_RATE     = Curve 0 1000 LightBlue    0 2
echo %PREFIX%.%FACILITY%.DIS_INFO_B_RATE     = Curve 0 1000 Blue         0 2
echo %PREFIX%.%FACILITY%.CPU_LOAD            = Curve 0 1000 Black        0 2
echo []
echo.
goto :EOF

:WriteMainCtrl
echo [%FACILITY%.MAIN.CTRL]
echo Link sensor DIC_CMND_RATE      with curve %PREFIX%.%FACILITY%.DIC_CMND_RATE    device ^&%FACILITY%.MAIN.CTRL
echo Link sensor DIS_CMND_RATE      with curve %PREFIX%.%FACILITY%.DIS_CMND_RATE    device ^&%FACILITY%.MAIN.CTRL
echo Link sensor DIC_INFO_RATE      with curve %PREFIX%.%FACILITY%.DIC_INFO_RATE    device ^&%FACILITY%.MAIN.CTRL
echo Link sensor DIS_INFO_RATE      with curve %PREFIX%.%FACILITY%.DIS_INFO_RATE    device ^&%FACILITY%.MAIN.CTRL
echo Link sensor DIC_CMND_COUNT     with tag   %PREFIX%.%FACILITY%.DIC_CMND_COUNT   device ^&%FACILITY%.MAIN.CTRL
echo Link sensor DIS_CMND_COUNT     with tag   %PREFIX%.%FACILITY%.DIS_CMND_COUNT   device ^&%FACILITY%.MAIN.CTRL
echo Link sensor DIC_INFO_COUNT     with tag   %PREFIX%.%FACILITY%.DIC_INFO_COUNT   device ^&%FACILITY%.MAIN.CTRL
echo Link sensor DIS_INFO_COUNT     with tag   %PREFIX%.%FACILITY%.DIS_INFO_COUNT   device ^&%FACILITY%.MAIN.CTRL
echo Link sensor PING_SEND_BTN      with tag   %PREFIX%.%FACILITY%.PING_SEND_BTN    device ^&%FACILITY%.MAIN.CTRL
echo Link sensor PING_SEND_CYCLE    with tag   %PREFIX%.%FACILITY%.PING_SEND_CYCLE  device ^&%FACILITY%.MAIN.CTRL
echo Link sensor PING_SEND_COUNT    with tag   %PREFIX%.%FACILITY%.PING_SEND_COUNT  device ^&%FACILITY%.MAIN.CTRL
echo Link sensor PING_SEND_PERIOD   with tag   %PREFIX%.%FACILITY%.PING_SEND_PERIOD device ^&%FACILITY%.MAIN.CTRL
echo Link sensor PING_SERVER_ON     with tag   %PREFIX%.%FACILITY%.PING_SERVER_ON   device ^&%FACILITY%.MAIN.CTRL
echo Link sensor PING_CLIENT_ON     with tag   %PREFIX%.%FACILITY%.PING_CLIENT_ON   device ^&%FACILITY%.MAIN.CTRL
echo Link sensor PING_TIME          with curve %PREFIX%.%FACILITY%.PING_TIME        device ^&%FACILITY%.MAIN.CTRL
echo Link sensor PING_TIME_MEAN     with curve %PREFIX%.%FACILITY%.PING_TIME_MEAN   device ^&%FACILITY%.MAIN.CTRL
echo Link sensor PING_TIME_RMSD     with curve %PREFIX%.%FACILITY%.PING_TIME_RMSD   device ^&%FACILITY%.MAIN.CTRL
echo Link sensor PING_STAT_PERIOD   with tag   %PREFIX%.%FACILITY%.PING_STAT_PERIOD device ^&%FACILITY%.MAIN.CTRL
echo Link sensor NUMSERV            with tag   %PREFIX%.%FACILITY%.NUMSERV          device ^&%FACILITY%.MAIN.CTRL
echo Link sensor DATALEN            with tag   %PREFIX%.%FACILITY%.DATALEN          device ^&%FACILITY%.MAIN.CTRL
echo Link sensor DIM_TASK           with tag   %PREFIX%.%FACILITY%.DIM_TASK         device ^&%FACILITY%.MAIN.CTRL
echo Link sensor DIM_DNS_NODE       with tag   %PREFIX%.%FACILITY%.DIM_DNS_NODE     device ^&%FACILITY%.MAIN.CTRL
echo Link sensor DIM_MODE           with tag   %PREFIX%.%FACILITY%.DIM_MODE         device ^&%FACILITY%.MAIN.CTRL
echo Link sensor CPU_LOAD           with curve %PREFIX%.%FACILITY%.CPU_LOAD         device ^&%FACILITY%.MAIN.CTRL
echo Link sensor @cron+@run+/hide+dim+gui                                      with device ^&%FACILITY%.MAIN.CTRL
echo Link sensor @cron+@run+dimtree                                            with device ^&%FACILITY%.MAIN.CTRL
echo Link sensor @RESET_COUNTS                                                 with device ^&%FACILITY%.MAIN.CTRL
echo Link sensor @PING_CONFIGS                                                 with device ^&%FACILITY%.MAIN.CTRL
echo Link sensor @PING_REPORT+NEW                                              with device ^&%FACILITY%.MAIN.CTRL
echo Link sensor @PING_REPORT+ADD                                              with device ^&%FACILITY%.MAIN.CTRL
echo Link sensor @PING_REPORT+EDIT                                             with device ^&%FACILITY%.MAIN.CTRL
echo Link sensor @PING_REPORT+SEE                                              with device ^&%FACILITY%.MAIN.CTRL
echo Link sensor DIM_DATAFLOW_DIAGRAM                                          with device ^&%FACILITY%.MAIN.CTRL
echo Link sensor @CRON+@CRON.RUN+DIM_PING.HISTOGRAM.SELECT                     with device ^&%FACILITY%.MAIN.CTRL
echo Link sensor @CRON+@CRON.RUN+DIM_PING.TAB.PING_PARAM.SELECT                with device ^&%FACILITY%.MAIN.CTRL
echo []
echo.
goto :EOF

:WriteSpectrWindow
echo [Windows]
echo %FACILITY%.PING_TIME_HISTOGRAM = Spectr_Window
echo [%FACILITY%.PING_TIME_HISTOGRAM]
echo WindowClass    = SpecManFitWin
echo Spectr         = %PREFIX%.%FACILITY%.PING_TIME_HISTOGRAM
echo Spectrometr    = ^&%FACILITY%.MAIN.CTRL
echo EnCalibration  = 0
echo HwCalibration  = 1
echo MarkerLabel    = CHN,CNT,PING,*,ROI,*,INT,GND,PIK ; Chan,Count,Ping,HW
echo []
echo.
goto :EOF

:WriteCurveWindow
echo [Windows]
echo %FACILITY%.PLOT.PING_TIME = Curve_Window
echo [%FACILITY%.PLOT.PING_TIME]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.016666667
echo AxisY = ^^CPing_Time^^N^^L___{ms}, 0, 1000
echo CurveList = %PREFIX%.%FACILITY%.PING_TIME
echo CurveList = %PREFIX%.%FACILITY%.PING_TIME_MEAN
echo CurveList = %PREFIX%.%FACILITY%.PING_TIME_RMSD
echo []
echo [Windows]
echo %FACILITY%.PLOT.PING_RATE = Curve_Window
echo [%FACILITY%.PLOT.PING_RATE]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.016666667
echo AxisY = ^^CPing_Rate^^N^^L___{Ping/sec}, 0, 1e3
echo CurveList = %PREFIX%.%FACILITY%.DIC_CMND_RATE
echo CurveList = %PREFIX%.%FACILITY%.DIS_CMND_RATE
echo CurveList = %PREFIX%.%FACILITY%.DIC_INFO_RATE
echo CurveList = %PREFIX%.%FACILITY%.DIS_INFO_RATE
echo []
echo [Windows]
echo %FACILITY%.PLOT.PING_B_RATE = Curve_Window
echo [%FACILITY%.PLOT.PING_B_RATE]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.016666667
echo AxisY = ^^CData_Rate^^N^^L___{Byte/sec}, 0, 1e5
echo CurveList = %PREFIX%.%FACILITY%.DIC_CMND_B_RATE
echo CurveList = %PREFIX%.%FACILITY%.DIS_CMND_B_RATE
echo CurveList = %PREFIX%.%FACILITY%.DIC_INFO_B_RATE
echo CurveList = %PREFIX%.%FACILITY%.DIS_INFO_B_RATE
echo []
echo [Windows]
echo %FACILITY%.PLOT.CPU_LOAD = Curve_Window
echo [%FACILITY%.PLOT.CPU_LOAD]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.016666667
echo AxisY = ^^CCPU_Load^^N^^L___{Percent}, 0, 100
echo CurveList = %PREFIX%.%FACILITY%.CPU_LOAD
echo []
echo.
goto :EOF

:WriteTabWindow
echo [Windows]
echo %FACILITY%.TAB.PING_PARAM = Tab_Window
echo [%FACILITY%.TAB.PING_PARAM]
echo Font      = Name:PT_Mono\Color:Black\Size:14\Style:[Bold]
echo Format    = 16 0 f
echo Colors    = Default, White, Navy
echo TagList   = %PREFIX%.%FACILITY%.PING_TIME
echo TagList   = %PREFIX%.%FACILITY%.PING_TIME_MEAN
echo TagList   = %PREFIX%.%FACILITY%.PING_TIME_RMSD
echo TagList   = %PREFIX%.%FACILITY%.DIC_CMND_RATE
echo TagList   = %PREFIX%.%FACILITY%.DIS_CMND_RATE
echo TagList   = %PREFIX%.%FACILITY%.DIC_INFO_RATE
echo TagList   = %PREFIX%.%FACILITY%.DIS_INFO_RATE
echo TagList   = %PREFIX%.%FACILITY%.DIC_CMND_B_RATE
echo TagList   = %PREFIX%.%FACILITY%.DIS_CMND_B_RATE
echo TagList   = %PREFIX%.%FACILITY%.DIC_INFO_B_RATE
echo TagList   = %PREFIX%.%FACILITY%.DIS_INFO_B_RATE
echo TagList   = %PREFIX%.%FACILITY%.DIC_CMND_COUNT
echo TagList   = %PREFIX%.%FACILITY%.DIS_CMND_COUNT
echo TagList   = %PREFIX%.%FACILITY%.DIC_INFO_COUNT
echo TagList   = %PREFIX%.%FACILITY%.DIS_INFO_COUNT
echo TagList   = %PREFIX%.%FACILITY%.DIC_CMND_B_COUNT
echo TagList   = %PREFIX%.%FACILITY%.DIS_CMND_B_COUNT
echo TagList   = %PREFIX%.%FACILITY%.DIC_INFO_B_COUNT
echo TagList   = %PREFIX%.%FACILITY%.DIS_INFO_B_COUNT
echo TagList   = %PREFIX%.%FACILITY%.CPU_LOAD
echo []
echo.
goto :EOF

:WriteDatSrv
echo [^&DatSrv]
echo CurveList = %PREFIX%.%FACILITY%.PING_TIME
echo CurveList = %PREFIX%.%FACILITY%.PING_TIME_MEAN
echo CurveList = %PREFIX%.%FACILITY%.PING_TIME_RMSD
echo CurveList = %PREFIX%.%FACILITY%.DIC_CMND_RATE
echo CurveList = %PREFIX%.%FACILITY%.DIS_CMND_RATE
echo CurveList = %PREFIX%.%FACILITY%.DIC_INFO_RATE
echo CurveList = %PREFIX%.%FACILITY%.DIS_INFO_RATE
echo CurveList = %PREFIX%.%FACILITY%.DIC_CMND_B_RATE
echo CurveList = %PREFIX%.%FACILITY%.DIS_CMND_B_RATE
echo CurveList = %PREFIX%.%FACILITY%.DIC_INFO_B_RATE
echo CurveList = %PREFIX%.%FACILITY%.DIS_INFO_B_RATE
echo CurveList = %PREFIX%.%FACILITY%.CPU_LOAD
echo []
echo.
goto :EOF

:WriteCustomParameters
echo [CustomParameters.TagList]
echo TagList = %PREFIX%.%FACILITY%.PING_STAT_PERIOD
echo TagList = %PREFIX%.%FACILITY%.PING_SEND_CYCLE
echo TagList = %PREFIX%.%FACILITY%.PING_SEND_COUNT
echo TagList = %PREFIX%.%FACILITY%.PING_SEND_PERIOD
echo TagList = %PREFIX%.%FACILITY%.PING_SERVER_ON
echo TagList = %PREFIX%.%FACILITY%.PING_CLIENT_ON
echo TagList = %PREFIX%.%FACILITY%.DATALEN
echo []
echo.
goto :EOF

:WriteTagPrefix
echo [^&%FACILITY%.MAIN.CTRL]
echo tagDimPing    = %PREFIX%.%FACILITY%
echo DIM_MODE      = %DIM_MODE%
echo NumServ       = %NUMSERV%
echo winHistogram  = %FACILITY%.PING_TIME_HISTOGRAM
echo winPingTime   = %FACILITY%.PLOT.PING_TIME
echo winPingRate   = %FACILITY%.PLOT.PING_RATE
echo winPingTab    = %FACILITY%.TAB.PING_PARAM
echo winCpuLoad    = %FACILITY%.PLOT.CPU_LOAD
echo winPingBRate  = %FACILITY%.PLOT.PING_B_RATE
echo AnalogOutputs = 13
echo Link AnalogOutput 0  with curve %PREFIX%.%FACILITY%.PING_TIME_HISTOGRAM
echo Link AnalogOutput 1  with curve %PREFIX%.%FACILITY%.PING_TIME           history 50000
echo Link AnalogOutput 2  with curve %PREFIX%.%FACILITY%.DIC_CMND_RATE       history 5000
echo Link AnalogOutput 3  with curve %PREFIX%.%FACILITY%.DIS_CMND_RATE       history 5000
echo Link AnalogOutput 4  with curve %PREFIX%.%FACILITY%.DIC_INFO_RATE       history 5000
echo Link AnalogOutput 5  with curve %PREFIX%.%FACILITY%.DIS_INFO_RATE       history 5000
echo Link AnalogOutput 6  with curve %PREFIX%.%FACILITY%.DIC_CMND_B_RATE     history 5000
echo Link AnalogOutput 7  with curve %PREFIX%.%FACILITY%.DIS_CMND_B_RATE     history 5000
echo Link AnalogOutput 8  with curve %PREFIX%.%FACILITY%.DIC_INFO_B_RATE     history 5000
echo Link AnalogOutput 9  with curve %PREFIX%.%FACILITY%.DIS_INFO_B_RATE     history 5000
echo Link AnalogOutput 10 with curve %PREFIX%.%FACILITY%.CPU_LOAD            history 5000
echo Link AnalogOutput 11 with curve %PREFIX%.%FACILITY%.PING_TIME_MEAN      history 5000
echo Link AnalogOutput 12 with curve %PREFIX%.%FACILITY%.PING_TIME_RMSD      history 5000
echo Calibrations  = 2
echo Calibration#0 = ..\Calibr\PingTime.cal  Chan Ping  * Line Line 0 10000
echo Calibration#1 = ..\Calibr\HalfWidth.cal Chan HW    * Line Line 0 10000
echo []
echo.
goto :EOF

:WriteDis
for /l %%i in (1,1,%NUMSERV%) do call :WriteDisIter %%i
echo.
goto :EOF

:WriteDisIter
if "%~1" == "" goto :EOF
unix dimcfg ^
  -n dis_cmnd %PREFIX%/%FACILITY%/DIM_CMND_%1 ^
  -n tag      %PREFIX%.%FACILITY%.DIS_CMND_%1 ^
  -n %devmsg% "&%FACILITY%.MAIN.CTRL @DIM_CMND=%1, %%**" ^
  -n end ^
  -n dis_info %PREFIX%/%FACILITY%/DIM_INFO_%1 ^
  -n tag      %PREFIX%.%FACILITY%.DIS_INFO_%1 ^
  -n end ^
  -n dic_cmnd %PREFIX%/%FACILITY%/DIM_CMND_%1 ^
  -n tag      %PREFIX%.%FACILITY%.DIC_CMND_%1 ^
  -n end ^
  -n dic_info %PREFIX%/%FACILITY%/DIM_INFO_%1 ^
  -n tag      %PREFIX%.%FACILITY%.DIC_INFO_%1 ^
  -n %devmsg% "&%FACILITY%.MAIN.CTRL @DIM_INFO=%1, %%**" ^
  -n print    "filling  /////w==  ////  &%FACILITY%.MAIN.CTRL" ^
  -n
goto :EOF

:WriteDic
for /l %%i in (1,1,%NUMSERV%) do call :WriteDicIter %%i
echo.
goto :EOF

:WriteDicIter
if "%~1" == "" goto :EOF
unix dimcfg ^
  -n dic_cmnd %PREFIX%/%FACILITY%/DIM_CMND_%1 ^
  -n tag      %PREFIX%.%FACILITY%.DIC_CMND_%1 ^
  -n end ^
  -n dic_info %PREFIX%/%FACILITY%/DIM_INFO_%1 ^
  -n tag      %PREFIX%.%FACILITY%.DIC_INFO_%1 ^
  -n %devmsg% "&%FACILITY%.MAIN.CTRL @DIM_INFO=%1, %%**" ^
  -n print    "filling  /////w==  ////  &%FACILITY%.MAIN.CTRL" ^
  -n end ^
  -n
goto :EOF


:SetEnv 
if "%~1" == "" exit /b 1
if "%~2" == "" exit /b 1
set "%~1=%~2"
exit /b 0
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF

:RemoveFile
rem Usage: call :RemoveFile "filename"
rem Check if file exists and delete file.
if "%~1" == "" goto :EOF
if not exist "%~1" goto :EOF
unix rm -f "%~1"
goto :EOF

:Sleep
:: Usage = call :Sleep NumSeconds [StartMessage] [ProgressChar]
if "%~1" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
set /a "PingCount=%~1+1"
if not "%~2" == "" call :Print %2
if not "%~3" == "" ( for /L %%i in (1,1,%1) do ( call :Sleep 1 & call :Print %~3 ) ) else ( call ping -n %PingCount% 127.0.0.1 1>nul 2>nul  )
EndLocal
goto :EOF

:Print
:: Usage = call :Print "The Message"
if "%~1" == "" goto :EOF
SetLocal EnableExtensions EnableDelayedExpansion
<nul set /p "_=%~1"
EndLocal
goto :EOF

:SetErrorLevel
:: Usage = call :SetErrorLevel ExitCode
exit /b %1
goto :EOF
