 {
 Example for Daq Pascal performance eastimation.
 }
program demo_benchmark;       { Daq Pascal performance benchmark }
{$T+}
const
 dfTrouble         = 1;       { DebugFlags - Trouble             }
 dfSuccess         = 2;       { DebugFlags - Success             }
 dfViewExp         = 4;       { DebugFlags - ViewExp             }
 dfViewImp         = 8;       { DebugFlags - ViewImp             }
var
 b                 : Boolean; { Temporary                        }
 Ok                : Boolean; { Program initialization is Ok?    }
 errors            : Integer; { Program error counter            }
 errorcode         : Integer; { Error code for this device       }
 fixmaxavail       : Integer; { String manager leak control      }
 DebugFlags        : Integer; { Debug bit flags                  }
 Report            : Integer; { Report text                      }
 i,j               : Integer; { Temporary                        }
 t1,t2,c1,c2,p1,p2 : Real;    { Temporary                        }
 q,q1,q2           : Real;    { Temporary                        }
 s                 : String;  { Temporary                        }
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Show/hide device console.
 }
 procedure OpenConsole(Mode:Integer);
 var b:Boolean;
  procedure ShowWin(WinName:String);
  begin
   b:=WinShow(WinName);
   b:=WinDraw(WinName+'|top=317|left=0|width=600|height=317');
   if Mode=1 then b:=WinSelect(WinName) else b:=WinHide(WinName);
  end;
 begin
  if Mode>0 then ShowWin(ParamStr('Console '+DevName))
 end;
 {
 Clear text: remove all lines, but do not free text instance.
 }
 procedure ClearText(aText:Integer);
 var i,N:Integer; b:Boolean;
 begin
  N:=text_NumLn(aText);
  for i:=N-1 downto 0 do b:=text_DelLn(aText,i);
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 begin
  s:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Add text line to Report.
 }
 procedure AddReport(s:String);
 begin
  b:=text_Addln(Report,s);
 end;
 {
 Benchmark REAL := + - * /
 }
 procedure Benchmark1(TimeOut:Real);
 const n1=100;
 var i:Integer; x,y,z,t0,t1,t2,c1,c2,p1,p2,q1,q2:Real;
 begin
  q1:=q;
  t0:=msecnow;
  t1:=mksecnow;
  c1:=cpu_clock;
  p1:=vdpm_opcount;
  while msecnow-t0<TimeOut do begin
   for i:=1 to 100 do begin
    x:=pi;    y:=1.0;
    z:=x+y;   z:=x-y;
    z:=x*y;   z:=x/y;
    z:=x+1.0; z:=x-1.0;
    z:=x*1.0; z:=x/1.0;
   end;
   q:=q+1e3;
  end;
  p2:=vdpm_opcount;
  c2:=cpu_clock;
  t2:=mksecnow;
  q2:=q;
  AddReport('Performance, REAL := + - * / statement :');
  AddReport(' '+StrFix((q2-q1)/(t2-t1),12,3)+' million Pascal operators per second');
  AddReport(' '+StrFix((p2-p1)/(t2-t1),12,3)+' million P-Code operators per second');
  AddReport(' '+StrFix((c2-c1)/(t2-t1),12,3)+' million native operators per second');
  AddReport(' '+StrFix((c2-c1)/(q2-q1),12,3)+' native operators per Pascal operators');
  AddReport(' '+StrFix((c2-c1)/(p2-p1),12,3)+' native operators per P-code operators');
  AddReport(' '+StrFix((p2-p1)/(q2-q1),12,3)+' P-code operators per Pascal operators');
  b:=putao(0,time,(q2-q1)/(t2-t1));
 end;
 {
 Benchmark CALL with Fibonnaci
 }
 procedure Benchmark2(TimeOut:Real);
 const n1=100;
 var i,j:Integer; x,y,z,t0,t1,t2,c1,c2,p1,p2,q1,q2:Real;
  function Fibonnaci(arg:Integer):Integer;
  begin
   if arg<=2
   then Fibonnaci:=1
   else Fibonnaci:=Fibonnaci(arg-1)+Fibonnaci(arg-2);
   q:=q+1;
  end;
 begin
  q1:=q;
  t0:=msecnow;
  t1:=mksecnow;
  c1:=cpu_clock;
  p1:=vdpm_opcount;
  while msecnow-t0<TimeOut do begin
   j:=Fibonnaci(20);
  end;
  p2:=vdpm_opcount;
  c2:=cpu_clock;
  t2:=mksecnow;
  q2:=q;
  AddReport('Performance, CALL Fibonnaci(20) statement :');
  AddReport(' '+StrFix((q2-q1)/(t2-t1),12,3)+' million Pascal operators per second');
  AddReport(' '+StrFix((p2-p1)/(t2-t1),12,3)+' million P-Code operators per second');
  AddReport(' '+StrFix((c2-c1)/(t2-t1),12,3)+' million native operators per second');
  AddReport(' '+StrFix((c2-c1)/(q2-q1),12,3)+' native operators per Pascal operators');
  AddReport(' '+StrFix((c2-c1)/(p2-p1),12,3)+' native operators per P-code operators');
  AddReport(' '+StrFix((p2-p1)/(q2-q1),12,3)+' P-code operators per Pascal operators');
 end;
 {
 Benchmark STRING := + copy pos dump
 }
 procedure Benchmark3(TimeOut:Real);
 const n1=100;
 var i,j:Integer; x,y,z,t0,t1,t2,c1,c2,p1,p2,q1,q2:Real;
 begin
  q1:=q;
  t0:=msecnow;
  t1:=mksecnow;
  c1:=cpu_clock;
  p1:=vdpm_opcount;
  while msecnow-t0<TimeOut do begin
   for i:=1 to 100 do begin
    s:=dump(time);
    s:=s+dump(time);
    s:=dump(time)+dump(time);
    s:=s+s;
    x:=dump2r(s);
    x:=dump2r(copy(s,9,8));
    x:=dump2r(copy(s,17,8));
    x:=dump2r(copy(s,25,8));
    x:=dump2r(copy(s,33,8));
    j:=pos('123',s);
   end;
   q:=q+1e3;
  end;
  p2:=vdpm_opcount;
  c2:=cpu_clock;
  t2:=mksecnow;
  q2:=q;
  AddReport('Performance, STRING := + copy pos dump statement :');
  AddReport(' '+StrFix((q2-q1)/(t2-t1),12,3)+' million Pascal operators per second');
  AddReport(' '+StrFix((p2-p1)/(t2-t1),12,3)+' million P-Code operators per second');
  AddReport(' '+StrFix((c2-c1)/(t2-t1),12,3)+' million native operators per second');
  AddReport(' '+StrFix((c2-c1)/(q2-q1),12,3)+' native operators per Pascal operators');
  AddReport(' '+StrFix((c2-c1)/(p2-p1),12,3)+' native operators per P-code operators');
  AddReport(' '+StrFix((p2-p1)/(q2-q1),12,3)+' P-code operators per Pascal operators');
  s:='';
 end;
 {
 Benchmark DUMP operations
 }
 procedure Benchmark4(TimeOut:Real);
 const n1=100;
 var i,j:Integer; x,y,z,t0,t1,t2,c1,c2,p1,p2,q1,q2:Real; b:Boolean;
 begin
  s:=StringOfChar(chr(0),SizeOfReal*5);
  q1:=q;
  t0:=msecnow;
  t1:=mksecnow;
  c1:=cpu_clock;
  p1:=vdpm_opcount;
  while msecnow-t0<TimeOut do begin
   for i:=1 to 100 do begin
    j:=0;
    b:=rsetdump(s,j,t0); j:=j+SizeOfReal;
    b:=rsetdump(s,j,t1); j:=j+SizeOfReal;
    b:=rsetdump(s,j,c1); j:=j+SizeOfReal;
    b:=rsetdump(s,j,p1); j:=j+SizeOfReal;
    b:=rsetdump(s,j,n1); j:=j+SizeOfReal;
    j:=0;
    x:=rgetdump(s,j); j:=j+SizeOfReal;
    x:=rgetdump(s,j); j:=j+SizeOfReal;
    x:=rgetdump(s,j); j:=j+SizeOfReal;
    x:=rgetdump(s,j); j:=j+SizeOfReal;
    x:=rgetdump(s,j); j:=j+SizeOfReal;
   end;
   q:=q+1e3;
  end;
  p2:=vdpm_opcount;
  c2:=cpu_clock;
  t2:=mksecnow;
  q2:=q;
  AddReport('Performance, DUMP := rGetDump/rSetDump statements :');
  AddReport(' '+StrFix((q2-q1)/(t2-t1),12,3)+' million Pascal operators per second');
  AddReport(' '+StrFix((p2-p1)/(t2-t1),12,3)+' million P-Code operators per second');
  AddReport(' '+StrFix((c2-c1)/(t2-t1),12,3)+' million native operators per second');
  AddReport(' '+StrFix((c2-c1)/(q2-q1),12,3)+' native operators per Pascal operators');
  AddReport(' '+StrFix((c2-c1)/(p2-p1),12,3)+' native operators per P-code operators');
  AddReport(' '+StrFix((p2-p1)/(q2-q1),12,3)+' P-code operators per Pascal operators');
  s:='';
 end;
begin
 {
 Initialization actions on Start
 }
 if runcount=1 then begin
  errors:=0;
  errorcode:=RegisterErr(DevName);
  ClearStrings;
  Report:=text_New;
  DebugFlags:=val(ReadIni('DebugFlags'));
  OpenConsole(Val(ReadIni('OpenConsole')));
  Success('Start DAQ PASCAL BENCHMARK program.');
  Success('CPU frequency is about '+StrFix(cpu_mhz,1,0)+' MHz');
  {
  For multiprocessor systems set thread affinity
  }
  if cpu_count>0 then begin
   j:=PidAffinity(0,0);
   for i:=31 downto 0 do
   if iAnd(iShift(1,i),j)<>0 then begin
    Success('Set thread affinity '+Str(DevAffinity(0,iShift(1,i))));
    j:=0;
   end;
  end;
  {
  Is it Ok?
  }
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop
 }
 if isinf(runcount) then begin
  ClearStrings;
  b:=text_Free(Report);
  Success('Stop  BENCHMARK program.');
 end else
 {
 Actions on Poll
 }
 if Ok then begin
  ClearText(Report);
  AddReport(EOL+EOL);
  AddReport('RunCount '+Str(RunCount));
  b:=cpu_start;
  q:=0;
  q1:=q;
  t1:=mksecnow;
  c1:=cpu_clock;
  p1:=vdpm_opcount;
  Benchmark1(300);
  Benchmark2(300);
  Benchmark3(300);
  Benchmark4(300);
  p2:=vdpm_opcount;
  c2:=cpu_clock;
  t2:=mksecnow;
  q2:=q;
  AddReport('Performance, TOTAL :');
  AddReport(' '+StrFix((q2-q1)/(t2-t1),12,3)+' million Pascal operators per second');
  AddReport(' '+StrFix((p2-p1)/(t2-t1),12,3)+' million P-code operators per second');
  AddReport(' '+StrFix((c2-c1)/(t2-t1),12,3)+' million native operators per second');
  AddReport(' '+StrFix((c2-c1)/(q2-q1),12,3)+' native operators per Pascal operators');
  AddReport(' '+StrFix((c2-c1)/(p2-p1),12,3)+' native operators per P-code operators');
  AddReport(' '+StrFix((p2-p1)/(q2-q1),12,3)+' P-code operators per Pascal operators');
  AddReport('CPU frequency is about '+StrFix((c2-c1)/(t2-t1),1,3)+' MHz');
  for i:=0 to text_NumLn(Report)-1 do Success(text_GetLn(Report,i));
 end;
end.
