 {
 ***********************************************************************
 Daq Pascal application program apc_drv.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @DimTagUpdate  - Dim Tag Update.
| @DimCMD_MY arg - Dim My Command, arg = @cmd in base64 code
| @Enable      - Enable UPS
| @Disable     - Disable UPS
| @Test        - Testing UPS
| @PollEn      - Enable polling UPS
| @MenuTools   - Open menu tools
| @Remote @cmd - run @cmd remotely: send to DIM server
| @DimGuiClick   - handle remote click from DIM
|********************************************************
[]
 }
program apc_drv;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_NetLibrary}            { NetLibrary constants             }
 st_NoReq    = 0;                { State : No request sent          }
 st_WaitAns  = 1;                { State : Waiting answer           }
 st_WaitGap  = 2;                { State : Waiting time gap         }
 st_TimeOut  = 3;                { State : TimeOut found            }
 stt_Off     = 0;                { Status : Device is OFF           }
 stt_Line    = 1;                { Status : Device is ON from Line  }
 stt_Bat     = 2;                { Status : Device is ON from Batt  }
 stt_Wrn     = 3;                { Status : Warning                 }
 stt_Ref     = 4;                { Status : Refused                 }
 stt_Tout    = 5;                { Status : Timeout                 }
 stt_Sim     = 6;                { Status : Simulation mode         }
 bit_Line    = 3;                { State bit : From Line            }
 bit_Bat     = 4;                { State bit : From Battery         }
 bit_Ovld    = 5;                { State bit : Overload             }
 bit_LowB    = 6;                { State bit : Low Battery          }
 bit_RepB    = 7;                { State bit : Replace battery      }
 ao_Uinp     = 0;                { Analog outputs: input voltage    }
 ao_Freq     = 1;                { AO input frequency               }
 ao_Uout     = 2;                { AO output voltage on line        }
 ao_Ubat     = 3;                { AO output voltage on battery     }
 ao_Vbat     = 4;                { AO voltage battery               }
 ao_Cbat     = 5;                { AO charge battery                }
 ao_Pout     = 6;                { AO work-load battery             }
 ao_Temp     = 7;                { AO temperature battery           }
 ao_Poll     = 8;                { AO pollrate                      }
 do_State    = 0;                { DO state UPS                     }
 do_Status   = 1;                { DO status UPS                    }
 cm_Enb1     = 1;                { CMD ID: Enable UPS 1             }
 cm_Enb2     = 2;                { CMD ID: Enable UPS 2             }
 cm_Dis1     = 3;                { CMD ID: Disable UPS 1            }
 cm_Dis2     = 4;                { CMD ID: Disable UPS 2            }
 cm_Indt     = 5;                { CMD ID: Test Indicator           }
 cm_Itst     = 6;                { CMD ID: Itself test              }
 cm_Enrs     = 7;                { CMD ID: Enable RS232 (Smart Mode)}
 cm_Name     = 8;                { CMD ID: Get name UPS             }
 cm_Resf     = 9;                { CMD ID: Factory Reset            }
 cm_Stat     = 10;               { CMD ID: State UPS                }
 cm_Inpv     = 11;               { CMD ID: Input Voltage            }
 cm_Outv     = 12;               { CMD ID: Output Voltage           }
 cm_Batv     = 13;               { CMD ID: Battery Voltage          }
 cm_Outb     = 14;               { CMD ID: Output Battery Voltage   }
 cm_Char     = 15;               { CMD ID: Battery charge           }
 cm_Outl     = 16;               { CMD ID: Output Load              }
 cm_Freq     = 17;               { CMD ID: Input Frequency          }
 cm_Temp     = 18;               { CMD ID: Temperature UPS          }
 MaxCmdNum   = 18;               { Max command id number            }

type
 TTagRef = record tag,nai,ndi,nao,ndo:Integer; val,tim:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_NetLibrary}            { NetLibrary variables             }
 cmd_Enable       : Integer;     { @Enable    - Enable  UPS         }
 cmd_Disable      : Integer;     { @Disable   - Disable UPS         }
 cmd_Test         : Integer;     { @Test      - Testing UPS         }
 cmd_PollEn       : Integer;     { @PollEn    - Enable polling UPS  }
 cmd_MenuTools    : Integer;     { @MenuTools - Open menu tools     }
 cmd_DimCmdMy     : Integer;     { System Command @DimCMD_MY        }
 cmd_DimTagUpdate : Integer;
 cmd_Remote       : Integer;
 APC              : record       { APC data                         }
  Simulator       : Boolean;     { Simulator mode                   }
  EnableDevSim    : Boolean;     { Device simulator mode            }
  POLL_EN         : TTagRef;     { Enable polling                   }
  ENABLE          : TTagRef;     { On/Off Smart UPS                 }
  TEST            : TTagRef;     { Test button                      }
  UOUTSTT         : TTagRef;     { Status: on line                  }
  UBATSTT         : TTagRef;     { Status: on battery               }
  OVERSTT         : TTagRef;     { Status: out overload             }
  LOWSTT          : TTagRef;     { Status: low charge of battery    }
  REPBAT          : TTagRef;     { Status: replace battery          }
  INDIC           : TTagRef;     { Result testing device indicators }
  ITSELF          : TTagRef;     { Result testing device itself     }
  NAME            : TTagRef;     { Answer: 'UPS Name'               }
  UINP            : TTagRef;     { Answer: 'Input voltage'          }
  FREQ            : TTagRef;     { Answer: 'Input frequency'        }
  UOUT            : TTagRef;     { Answer: 'Output voltage'         }
  UBAT            : TTagRef;     { Answer: 'Output battery voltage' }
  VBAT            : TTagRef;     { Answer: 'Battery voltage'        }
  CBAT            : TTagRef;     { Answer: 'Battery charge'         }
  POUT            : TTagRef;     { Answer: 'Load on output'         }
  TEMP            : TTagRef;     { Answer: 'Temperature of UPS'     }
  STATE           : TTagRef;     { Answer: 'State of UPS'           }
  STATUS          : TTagRef;     { UPS Status                       }
  POLLRATE        : TTagRef;     { UPS Pollrate                     }
  SERVMODE         : TTagRef;    { Is DIM Server Mode?              }
  ModeConnect     : String;      { Connection mode: TCP or COM      }
  PipeCon         : record       { Comunication data                }
   Port           : String;      { Port number                      }
   Baudrate       : String;      { Baudrate Com Port                }
   TcpPort        : String;      { TCP port                         }
   ClientIP       : String;      { Client IP adress                 }
   PipePolling    : String;      { Polling connection               }
   PipePriority   : String;      { Priority connection              }
   TxPipeSize     : String;      { Tx Buffer Size                   }
   RxPipeSize     : String;      { Rx Buffer Size                   }
   PipeTimeout    : String;      { Timeout connection               }
   PipeID         : Integer;     { PIPE ID                          }
   PipeSIM        : Integer;     { Local PIPE for Simulation        }
   Req,Ans,Buf    : String;      { Request, Answer                  }
   ReqTime,AnsTime: Real;        { Request, Answer time, ms         }
   PollRate       : Integer;     { Poll rate, poll/sec              }
   CntTimeOut     : Integer;     { Count Timeouts                   }
  end;
  Cmd             : record       { Table of command for Smart-UPS   }
   Status         : Integer;     { CmdCycle Status flag             }
   Num            : Integer;     { Current Number of command        }
   Enable         : array [1..MaxCmdNum] of Boolean;{ En/Dis cmd    }
   Symbol         : array [1..MaxCmdNum] of Char;   { ASCII symbol  }
   AoNum          : array [1..MaxCmdNum] of Integer;{ AoNum for cmd }
   DoNum          : array [1..MaxCmdNum] of Integer;{ DoNum for cmd }
   TimeOut        : array [1..MaxCmdNum] of Integer;{TimeOut for cmd}
   Tag            : array [1..MaxCmdNum] of Integer;{Associated tag }
  end;
 end;

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_NetLibrary}            { NetLibrary functions             }
 {
 APC clear strings
 }
 Procedure APC_ClearStrings;
 begin
  APC.PipeCon.Port:='';     // Clear data about Com Port
  APC.PipeCon.Baudrate:=''; // Clear data about baudrate
  APC.PipeCon.TcpPort:='';
  APC.PipeCon.ClientIP:='';
  APC.PipeCon.PipePolling:='';
  APC.PipeCon.PipePriority:='';
  APC.PipeCon.TxPipeSize:='';
  APC.PipeCon.RxPipeSize:='';
  APC.PipeCon.PipeTimeout:='';
  APC.PipeCon.Req:='';      // Clear request to device
  APC.PipeCon.Ans:='';      // Clear answer on command
  APC.PipeCon.Buf:='';      // Clear buffer
  if APC.PipeCon.PipeID<>0 then begin
   bNul(pipe_txclear(APC.PipeCon.PipeID));
   bNul(pipe_rxclear(APC.PipeCon.PipeID));
  end;
  if APC.PipeCon.PipeSIM<>0 then begin
   bNul(pipe_txclear(APC.PipeCon.PipeSIM));
   bNul(pipe_rxclear(APC.PipeCon.PipeSIM));
  end;
 end;
 {
 Procedure to clear Command Table
 }
 Procedure APC_ClearCmdTab;
 var i:Integer;
 begin
  for i:=1 to MaxCmdNum do begin
   APC.Cmd.Enable[i]:=false;
   APC.Cmd.Symbol[i]:='0';
   APC.Cmd.AoNum[i]:=0;
   APC.Cmd.DoNum[i]:=0;
   APC.Cmd.Timeout[i]:=0;
  end;
 end;
 {
 Check command number is valid.
 }
 function IsValidCmdNum(n:Integer):Boolean;
 begin
  IsValidCmdNum:=(n>=1) and (n<=MaxCmdNum);
 end;
 {
 Enable/disable command n.
 }
 procedure EnableCmdNum(n:Integer; Enable:Boolean);
 begin
  if IsValidCmdNum(n) then APC.Cmd.Enable[n]:=Enable;
 end;
 {
 Check if command (n) is query
 }
 function IsQueryCmdNum(n:Integer):Boolean;
 begin
  if IsValidCmdNum(n)
  then IsQueryCmdNum:=(n<>cm_Enb1)and(n<>cm_Enb2)and(n<>cm_Dis1)and(n<>cm_Dis2)
  else IsQueryCmdNum:=false;
 end;
 {
 APC tag Initialization
 }
 procedure APC_FillTags(InitVal:Real);
 begin
  APC.POLL_EN.val :=InitVal;
  APC.ENABLE.val  :=InitVal;
  APC.TEST.val    :=InitVal;
  APC.UOUTSTT.val :=InitVal;
  APC.UBATSTT.val :=InitVal;
  APC.OVERSTT.val :=InitVal;
  APC.LOWSTT.val  :=InitVal;
  APC.REPBAT.val  :=InitVal;
  APC.STATUS.val  :=InitVal;
  APC.POLLRATE.val:=InitVal;
  APC.INDIC.val   :=InitVal;
  APC.ITSELF.val  :=InitVal;
  APC.NAME.val    :=InitVal;
  APC.UINP.val    :=InitVal;
  APC.FREQ.val    :=InitVal;
  APC.UOUT.val    :=InitVal;
  APC.UBAT.val    :=InitVal;
  APC.VBAT.val    :=InitVal;
  APC.CBAT.val    :=InitVal;
  APC.POUT.val    :=InitVal;
  APC.TEMP.val    :=InitVal;
  APC.STATE.val   :=InitVal;
 end;
 procedure APC_InitTags(Prefix:String; InitVal:Real);
 begin
  if not IsEmptyStr(Prefix) then begin
   DIM_GuiClickInit(Prefix+'.DIMGUICLICK');
   InitTag(APC.POLL_EN.tag, Prefix+'.POLL_EN', 1);
   InitTag(APC.ENABLE.tag,  Prefix+'.ENABLE',  1);
   InitTag(APC.TEST.tag,    Prefix+'.TEST',    1);
   InitTag(APC.UOUTSTT.tag, Prefix+'.UOUTSTT', 1);
   InitTag(APC.UBATSTT.tag, Prefix+'.UBATSTT', 1);
   InitTag(APC.OVERSTT.tag, Prefix+'.OVERSTT', 1);
   InitTag(APC.LOWSTT.tag,  Prefix+'.LOWSTT',  1);
   InitTag(APC.REPBAT.tag,  Prefix+'.REPBAT',  1);
   InitTag(APC.STATUS.tag,  Prefix+'.STATUS',  1);
   InitTag(APC.POLLRATE.tag,Prefix+'.POLLRATE',1);
   InitTag(APC.INDIC.tag,   Prefix+'.INDIC',   3);
   InitTag(APC.ITSELF.tag,  Prefix+'.ITSELF',  3);
   InitTag(APC.NAME.tag,    Prefix+'.NAME',    3);
   InitTag(APC.UINP.tag,    Prefix+'.UINP',    2);
   InitTag(APC.FREQ.tag,    Prefix+'.FREQ',    2);
   InitTag(APC.UOUT.tag,    Prefix+'.UOUT',    2);
   InitTag(APC.UBAT.tag,    Prefix+'.UBAT',    2);
   InitTag(APC.VBAT.tag,    Prefix+'.VBAT',    2);
   InitTag(APC.CBAT.tag,    Prefix+'.CBAT',    2);
   InitTag(APC.POUT.tag,    Prefix+'.POUT',    2);
   InitTag(APC.TEMP.tag,    Prefix+'.TEMP',    2);
   InitTag(APC.STATE.tag,   Prefix+'.STATE',   2);
   InitTag(APC.SERVMODE.tag,Prefix+'.SERVMODE',1);
   APC_FillTags(InitVal);
  end;
  bNul(iSetTag(APC.ENABLE.tag,0));
 end;
 {
 Procedure for add command in table
 }
 procedure Add(num,enb:Integer; sym:Char; aon,don,tio:Integer);
 begin
  if IsValidCmdNum(num) then begin
   APC.Cmd.Enable[num]:=enb>0;
   APC.Cmd.Symbol[num]:=sym;
   APC.Cmd.AoNum[num]:=aon;
   APC.Cmd.DoNum[num]:=don;
   APC.Cmd.Timeout[num]:=tio;
   APC.Cmd.Tag[num]:=FindTag(CrvName(RefAo(aon))); // Find tag assocciate with name curve
  end;
 end;
 {
 APC command table initialization
 }
 Procedure APC_InitCmdTab;
 begin
  APC.Cmd.Num:=1;
  //  Command  Enable Symbol   AoNum    DoNum    TimeOut
  Add(cm_Enb1, 0,     chr(14), -1,      -1,      1500);  { 1  - '^N' First cmd 'on UPS'  }
  Add(cm_Enb2, 0,     chr(14), -1,      -1,      25000); { 2  - '^N' Second cmd 'on UPS' }
  Add(cm_Dis1, 0,     'Z',     -1,      -1,      1500);  { 3  - 'Z'  First cmd 'off UPS' }
  Add(cm_Dis2, 0,     'Z',     -1,      -1,      1500);  { 4  - 'Z'  Second cmd 'off UPS'}
  Add(cm_Indt, 0,     'A',     -1,      -1,      250);  { 5  - 'A'  Test indicators     }
  Add(cm_Itst, 0,     'W',     -1,      -1,      250);  { 6  - 'W'  Itself test         }
  Add(cm_Enrs, 1,     'Y',     -1,      -1,      250);  { 7  - 'Y'  Entering Smart Mode }
  Add(cm_Name, 1,      chr(1), -1,      -1,      250);  { 8  - '^A' Reading Name UPS    }
  Add(cm_Resf, 0,     'z',     -1,      -1,      250);  { 9  - 'z'  Fectory reset       }
  Add(cm_Stat, 1,     'Q',     -1,      do_State,250);  { 10 - 'Q'  Read state          }
  Add(cm_Inpv, 1,     'L',     ao_Uinp, -1,      250);  { 11 - 'L'  Input voltage       }
  Add(cm_Outv, 1,     'O',     ao_Uout, -1,      250);  { 12 - 'O'  Output voltage      }
  Add(cm_Batv, 1,     'B',     ao_Vbat, -1,      250);  { 13 - 'B'  Battary voltage     }
  Add(cm_Outb, 1,     'o',     ao_Ubat, -1,      250);  { 14 - 'o'  Battery out voltage }
  Add(cm_Char, 1,     'f',     ao_Cbat, -1,      250);  { 15 - 'f'  Charge battery %    }
  Add(cm_Outl, 1,     'P',     ao_Pout, -1,      250);  { 16 - 'P'  Output load         }
  Add(cm_Freq, 1,     'F',     ao_Freq, -1,      250);  { 17 - 'F'  Output frequency    }
  Add(cm_Temp, 1,     'C',     ao_Temp, -1,      250);  { 18 - 'C'  Temperature UPS     }
 end;
 {
 Pipe connection for APC
 }
 Function APC_PipeConnect:Boolean;
 var sPID,sPSIM:String;
 begin
  APC_PipeConnect:=false;
  sPID:='';
  sPSIM:='';
  if APC.Simulator then begin
   //Pipe connection for simulation
   APC.PipeCon.PipeID:=Pipe_Init('pipe '+ReadIni('tagPrefix'));
   APC.PipeCon.PipeSIM:=Pipe_Init('pipe .\'+ReadIni('tagPrefix'));
   APC_PipeConnect:=(Pipe_Run(APC.PipeCon.PipeID) and Pipe_Run(APC.PipeCon.PipeSIM));
   sPID:=str(APC.PipeCon.PipeID);
   sPSIM:=str(APC.PipeCon.PipeSIM);
   Details('APC.PipeCon.PipeID = '+sPID);
   Details('APC.PipeCon.PipeSIM = '+sPSIM);
  end else begin
   //Pipe connection for device control by COM connection
   if APC.ModeConnect='COM' then begin
    APC.PipeCon.Port:=ReadIni('ComPort');
    APC.PipeCon.Baudrate:=ReadIni('Baudrate');
    APC.PipeCon.PipeID:=Pipe_Init('com port '+APC.PipeCon.Port+' baudrate '+APC.PipeCon.Baudrate);
    bNul(Pipe_Run(APC.PipeCon.PipeID));
    APC_PipeConnect:=Pipe_Connected(APC.PipeCon.PipeID)>0;
    sPID:=str(APC.PipeCon.PipeID);
    Details('APC.PipeCon.PipeID = '+sPID);
   end else
   if APC.ModeConnect='TCP' then begin
   //Pipe connection for device control by TCP connection
    APC.PipeCon.TcpPort     :=ReadIni('TcpPort');
    APC.PipeCon.ClientIP    :=ReadIni('ClientIP');
    APC.PipeCon.PipePolling :=ReadIni('PipePolling');
    APC.PipeCon.PipePriority:=ReadIni('PipePriority');
    APC.PipeCon.TxPipeSize  :=ReadIni('TxPipeSize');
    APC.PipeCon.RxPipeSize  :=ReadIni('RxPipeSize');
    APC.PipeCon.PipeTimeout :=ReadIni('PipeTimeout');
    APC.PipeCon.PipeID:=Pipe_Init('Tcp Port '+APC.PipeCon.TcpPort+' Client '+APC.PipeCon.ClientIP+
    ' Polling '+APC.PipeCon.PipePolling+' Priority '+APC.PipeCon.PipePriority+
    ' TxPipeSize '+APC.PipeCon.TxPipeSize+' RxPipeSize '+APC.PipeCon.RxPipeSize+
    ' Timeout '+APC.PipeCon.PipeTimeout);
    bNul(Pipe_Run(APC.PipeCon.PipeID));
    APC_PipeConnect:=Pipe_Ref(APC.PipeCon.PipeID)>0;
    sPID:=str(APC.PipeCon.PipeID);
    Details('APC.PipeCon.PipeID = '+sPID);
   end else Trouble('Connection type not supported');
  end;
  sPID:='';
  sPSIM:='';
 end;
 {
 Pipe free for finalization application
 }
 Procedure APC_PipeFree;
 begin
  bNul(pipe_free(APC.PipeCon.PipeID)); 
  bNul(pipe_free(APC.PipeCon.PipeSIM));
 end;
 {
 Update status tag and curve of UPS
 }
 Procedure UpdateAPCStatus(v:Real);
 begin
  if v=0 then begin
   bNul(iSetTagBitState(APC.ENABLE.tag,1,false));
   bNul(iSetTag(APC.STATUS.tag,stt_Off));
  end
  else if isBit(v,bit_Line) then begin
   bNul(iSetTag(APC.STATUS.tag,stt_Line));
   bNul(iSetTag(APC.ENABLE.tag,3));
  end else if isBit(v,bit_Bat) then begin
   bNul(iSetTag(APC.STATUS.tag,stt_Bat));
   bNul(iSetTag(APC.ENABLE.tag,3));
  end;
  if (isBit(v,bit_Ovld) or isBit(v,bit_LowB) or isBit(v,bit_RepB)) then bNul(iSetTag(APC.STATUS.tag,stt_Wrn));
  if APC.Simulator then bNul(iSetTag(APC.STATUS.tag,stt_Sim));
  UpdateDo(do_Status,time,iGetTag(APC.STATUS.tag));
 end;
 {
 Decoding data
 }
 procedure DecodeData(n:Integer; data:String);
 var v:Real;
  {
  Update register of state APC
  }
  procedure UpdateAPCState(n:Integer; value:Real);
  var donum:Integer;
  begin
   if IsValidCmdNum(n) and not IsNan(value) and not IsInf(value) then begin
    donum:=APC.Cmd.DoNum[n];
    bNul(rSetTag(APC.STATE.tag,value));
    UpdateAPCStatus(value);
    if donum>=0 then UpdateDo(donum,time,rGetTag(APC.STATE.tag));
   end;
  end;
  {
  Update values associate with answer on commands
  }
  procedure UpdateCmdValue(n:Integer; value:Real);
  var aonum,tag:Integer;
  begin
   if IsValidCmdNum(n) and not IsNan(value) and not IsInf(value) then begin
    tag:=APC.Cmd.Tag[n]; aonum:=APC.Cmd.AoNum[n];
    if TypeTag(tag)=1 then begin
     bNul(iSetTag(tag,Round(value)));
     if aonum>=0 then UpdateAo(aonum,time,iGetTag(tag));
    end;
    if TypeTag(tag)=2 then begin
     bNul(rSetTag(tag,value));
     if aonum>=0 then UpdateAo(aonum,time,rGetTag(tag));
    end;
   end;
  end;
  {
  Update name APC
  }
  procedure UpdateNameDev(n:Integer; name:String);
  begin
   if (IsValidCmdNum(n) and not IsEmptyStr(name)) then bNul(sSetTag(APC.NAME.tag,name));
  end;
  {
  Update result on command "Indicators Tests UPS"
  }
  procedure UpdateIndicTestDev(n:Integer; result:String);
  begin
   if (IsValidCmdNum(n) and not IsEmptyStr(result)) then bNul(sSetTag(APC.INDIC.tag,result));
  end;
  {
  Update result on command "Itself test UPS"
  }
  procedure UpdateItselfTestDev(n:Integer; result:String);
  begin
   if IsValidCmdNum(n) and not IsEmptyStr(result) then begin
    bNul(sSetTag(APC.ITSELF.tag,result));
    bNul(iSetTag(APC.TEST.Tag,0));
   end;
  end;
 begin
  if IsValidCmdNum(n) then begin
   if Length(data)>0 then begin
    if (n=cm_Enrs) then begin
     if not (data='SM') then Trouble(GetDateTime(mSecNow)+': Smart Mode Is Not Available!');
    end else if (n=cm_Name) then begin
     UpdateNameDev(n, data);
    end else if (n=cm_Indt) then begin
     UpdateIndicTestDev(n, data);
    end else if (n=cm_Itst) then begin
     UpdateItselfTestDev(n, data);
    end else if (n=cm_Stat) then begin
     v:=rVal('$'+data);
     if not IsNan(v) then UpdateAPCState(n,v);
    end else if (n=cm_Inpv) then begin
     v:=rVal(data);
     if not IsNan(v) then UpdateCmdValue(n,v);
    end else if (n=cm_Outv) then begin
     v:=rVal(data);
     if not IsNan(v) then UpdateCmdValue(n,v);
    end else if (n=cm_Batv) then begin
     v:=rVal(data);
     if not IsNan(v) then UpdateCmdValue(n,v);
    end else if (n=cm_Outb) then begin
     v:=rVal(data);
     if not IsNan(v) then UpdateCmdValue(n,v);
    end else if (n=cm_Char) then begin
     v:=rVal(data);
     if not IsNan(v) then UpdateCmdValue(n,v);
    end else if (n=cm_Outl) then begin
     v:=rVal(data);
     if not IsNan(v) then UpdateCmdValue(n,v);
    end else if (n=cm_Freq) then begin
     v:=rVal(data);
     if not IsNan(v) then UpdateCmdValue(n,v);
    end else if (n=cm_Temp) then begin
     v:=rVal(data);
     if not IsNan(v) then UpdateCmdValue(n,v);
    end;
   end;
  end;
 end;
 {
 Simulator mode (handling receive command)
 }
 procedure APC_Simulation(Req:String);
 var L,O,F,T,C,P,B,x:Real; sL,sO,sF,sT,sC,sP,sB:String;
 begin
  sL:='';
  sO:='';
  sF:='';
  sT:='';
  sC:='';
  sP:='';
  sB:='';
  x:=sin(2*pi*time*60);
  L:=220+30*x+random(-1,1);
  sL:=str(L);
  O:=230+random(-1,1);
  sO:=str(O);
  F:=50+5*x;
  sF:=str(F);
  T:=25+10*x;
  sT:=str(T);
  C:=abs(100*x);
  sC:=str(C);
  P:=abs(130*x);
  sP:=str(P);
  B:=abs(27*x);
  sB:=str(B);
  if Req=chr(14) then APC.EnableDevSim:=true;
  if Req='Z'     then APC.EnableDevSim:=false;
  if Req='A'     then iNul(pipe_send(APC.PipeCon.PipeSIM,'Indic Sim'+CRLF));
  if Req='W'     then iNul(pipe_send(APC.PipeCon.PipeSIM,'Itself Sim'+CRLF));
  if Req='Y'     then iNul(pipe_send(APC.PipeCon.PipeSIM,'SM'+CRLF));
  if Req=chr(1)  then iNul(pipe_send(APC.PipeCon.PipeSIM,'Simulation mode'+CRLF));
  if Req='z'     then iNul(pipe_send(APC.PipeCon.PipeSIM,'Factory Sim'+CRLF));
  if Req='L'     then iNul(pipe_send(APC.PipeCon.PipeSIM,sL+CRLF));
  if Req='B'     then iNul(pipe_send(APC.PipeCon.PipeSIM,sB+CRLF));
  if Req='o'     then iNul(pipe_send(APC.PipeCon.PipeSIM, '230'+CRLF));
  if Req='f'     then iNul(pipe_send(APC.PipeCon.PipeSIM,sC+CRLF));
  if Req='P'     then iNul(pipe_send(APC.PipeCon.PipeSIM,sP+CRLF));
  if Req='F'     then iNul(pipe_send(APC.PipeCon.PipeSIM,sF+CRLF));
  if Req='C'     then iNul(pipe_send(APC.PipeCon.PipeSIM,sT+CRLF));
  if Req='O'     then if (L>210) and (L<235) then iNul(pipe_send(APC.PipeCon.PipeSIM,sL+CRLF)) else iNul(pipe_send(APC.PipeCon.PipeSIM,sO+CRLF));
  if Req='Q' then begin
   if APC.EnableDevSim then begin
    if (L>210) and (L<235) then begin
     if (P>100) then begin
      if (C<20) then begin
       if (B<15) then iNul(pipe_send(APC.PipeCon.PipeSIM,'E8'+CRLF))
       else iNul(pipe_send(APC.PipeCon.PipeSIM,'68'+CRLF));
      end else begin
       if (B<15) then iNul(pipe_send(APC.PipeCon.PipeSIM,'A8'+CRLF))
       else iNul(pipe_send(APC.PipeCon.PipeSIM,'28'+CRLF));
      end;
     end else begin
      if (C<20) then begin
       if (B<15) then iNul(pipe_send(APC.PipeCon.PipeSIM,'C8'+CRLF))
       else iNul(pipe_send(APC.PipeCon.PipeSIM,'48'+CRLF));
      end else begin
       if (B<15) then iNul(pipe_send(APC.PipeCon.PipeSIM,'88'+CRLF))
       else iNul(pipe_send(APC.PipeCon.PipeSIM,'08'+CRLF));
      end;
     end;
    end else begin
     if (P>100) then begin
      if (C<20) then iNul(pipe_send(APC.PipeCon.PipeSIM,'70'+CRLF))
      else iNul(pipe_send(APC.PipeCon.PipeSIM,'30'+CRLF));
     end else begin
      if (C<20) then iNul(pipe_send(APC.PipeCon.PipeSIM,'50'+CRLF))
      else iNul(pipe_send(APC.PipeCon.PipeSIM,'10'+CRLF));
     end;
    end;
   end else iNul(pipe_send(APC.PipeCon.PipeSIM,'00'+CRLF));
  end;
  sL:='';
  sO:='';
  sF:='';
  sT:='';
  sC:='';
  sP:='';
  sB:='';
 end;
 {
 APC Main Cmd Cycle
 }
 Procedure APC_CmdCycle;
 var sPID:String;
  function ValidateCmdNum(Num:Integer):Integer;
  begin
   if IsValidCmdNum(Num)
   then ValidateCmdNum:=Num
   else ValidateCmdNum:=1;
  end;
  function NextCmdNum(Num:Integer):Integer;
  var i:Integer;
  begin
   i:=0;
   while (i<MaxCmdNum) do begin
    Num:=ValidateCmdNum(Num+1);
    if APC.Cmd.Enable[Num]
    then i:=MaxCmdNum
    else i:=i+1;
   end;
   NextCmdNum:=Num;
  end;
  procedure ClearRequest(Num,Status:Integer);
  begin
   APC.PipeCon.Ans:='';
   APC.PipeCon.Buf:='';
   APC.PipeCon.ReqTime:=0;
   APC.PipeCon.AnsTime:=0;
   APC.Cmd.Status:=Status;
   APC.Cmd.Num:=ValidateCmdNum(Num);
   if APC.PipeCon.PipeID<>0 then begin
    bNul(pipe_txclear(APC.PipeCon.PipeID));
    bNul(pipe_rxclear(APC.PipeCon.PipeID));
   end;
   if APC.PipeCon.PipeSIM<>0 then begin
    bNul(pipe_txclear(APC.PipeCon.PipeSIM));
    bNul(pipe_rxclear(APC.PipeCon.PipeSIM));
   end;
  end;
  function HandleRequest(n:Integer; Ans:String):Boolean;
  var Handled:Boolean;
  begin
   Handled:=false;
   if IsValidCmdNum(n) and (Length(Ans)>0) then begin
    DecodeData(n,Ans);
    Handled:=True;
   end;
   HandleRequest:=Handled;
  end;
  procedure DisCtrlCmd(n:Integer);
  begin
   if (n=cm_Enb1) then begin
    bNul(iSetTagBitState(APC.ENABLE.tag,0,true));
    APC.Cmd.Enable[cm_Enb1]:=false;
   end else if (n=cm_Enb2) then begin
    APC.Cmd.Enable[cm_Enb2]:=false;
   end else if (n=cm_Dis1) then begin
    bNul(iSetTagBitState(APC.ENABLE.tag,0,false));
    APC.Cmd.Enable[cm_Dis1]:=false;
   end else if (n=cm_Dis2) then begin
    bNul(iSetTag(APC.STATUS.tag,stt_Off));
    APC.Cmd.Enable[cm_Dis2]:=false;
    UpdateDo(do_Status,time,iGetTag(APC.STATUS.tag));
   end else if (n=cm_Indt) then begin
    APC.Cmd.Enable[cm_Indt]:=false;
   end else if (n=cm_Itst) then begin
    APC.Cmd.Enable[cm_Itst]:=false;
   end;
  end;
 begin
  sPID:='';
  if not DIM_IsClientMode then begin
   if APC.Simulator or (Pipe_Connected(APC.PipeCon.PipeID)=1) then begin
    sPID:=str(APC.PipeCon.PipeID);
    APC.Cmd.Num:=ValidateCmdNum(APC.Cmd.Num);
    if APC.Cmd.Status=st_NoReq then begin
     ClearRequest(APC.Cmd.Num,st_NoReq);
     if APC.Cmd.Enable[APC.Cmd.Num]=true then begin
      if Pipe_Send(APC.PipeCon.PipeID, APC.Cmd.Symbol[APC.Cmd.Num])>0 then begin
       ViewExp('PIPE '+sPID+' > '+APC.Cmd.Symbol[APC.Cmd.Num]);
       APC.Cmd.Status:=st_WaitAns;
       APC.PipeCon.ReqTime:=mSecNow;
      end else begin
       Trouble(GetDateTime(mSecNow)+': Send Cmd not done, repeat send');
       ClearRequest(NextCmdNum(APC.Cmd.Num),st_NoReq);
      end;
     end else ClearRequest(NextCmdNum(APC.Cmd.Num),st_NoReq);
    end else
    if APC.Cmd.Status=st_WaitAns then begin
     if IsQueryCmdNum(APC.Cmd.Num) then begin
      if Pipe_Readln(APC.PipeCon.PipeID,APC.PipeCon.Ans,APC.PipeCon.Buf) then begin
       ViewImp('PIPE '+sPID+' < '+APC.PipeCon.Ans);
       if HandleRequest(APC.Cmd.Num,APC.PipeCon.Ans) then begin
        APC.PipeCon.PollRate:=APC.PipeCon.PollRate+1;
        DisCtrlCmd(APC.Cmd.Num);
        ClearRequest(NextCmdNum(APC.Cmd.Num),st_NoReq);
       end;
      end else if mSecNow>APC.PipeCon.ReqTime+APC.Cmd.TimeOut[APC.Cmd.Num] then begin
       APC.Cmd.Status:=st_TimeOut;
      end else APC.Cmd.Status:=st_WaitAns;
     end else APC.Cmd.Status:=st_WaitGap;
    end;
    if APC.Cmd.Status=st_WaitGap then begin
     if not IsQueryCmdNum(APC.Cmd.Num) then begin
      if mSecNow>APC.PipeCon.ReqTime+APC.Cmd.TimeOut[APC.Cmd.Num] then begin
       DisCtrlCmd(APC.Cmd.Num);
       ClearRequest(NextCmdNum(APC.Cmd.Num),st_NoReq);
      end else APC.Cmd.Status:=st_WaitGap;
     end;
    end;
    if APC.Cmd.Status=st_TimeOut then begin
     APC.PipeCon.CntTimeOut:=APC.PipeCon.CntTimeOut+1;
     bNul(iSetTag(APC.STATUS.tag,stt_Tout));
     UpdateDo(do_Status,time,iGetTag(APC.STATUS.tag));
     Problem(GetDateTime(mSecNow)+': TimeOut on command: '+APC.Cmd.Symbol[APC.Cmd.Num]);
     ClearRequest(NextCmdNum(APC.Cmd.Num),st_NoReq);
     if APC.PipeCon.CntTimeOut>=20 then begin
      Trouble(GetDateTime(mSecNow)+': Timeout Very Long - Try Reconnect');
      APC_PipeFree;
      bNul(APC_PipeConnect);
      APC.PipeCon.CntTimeOut:=0;
      APC.Cmd.Status:=st_NoReq;
     end;
    end;
   end else begin
    bNul(iSetTag(APC.STATUS.tag,stt_Ref));
    UpdateDo(do_Status,time,iGetTag(APC.STATUS.tag));
   end;
   sPID:='';
  end;
 end;
 {
 Enabling Polling
 }
 Procedure EnabledPoll;
 begin
  if iGetTag(APC.POLL_EN.tag)>0 then begin
   APC.Cmd.Enable[cm_Name]:=true;
   APC.Cmd.Enable[cm_Inpv]:=true;
   APC.Cmd.Enable[cm_Outv]:=true;
   APC.Cmd.Enable[cm_Batv]:=true;
   APC.Cmd.Enable[cm_Outb]:=true;
   APC.Cmd.Enable[cm_Char]:=true;
   APC.Cmd.Enable[cm_Outl]:=true;
   APC.Cmd.Enable[cm_Freq]:=true;
   APC.Cmd.Enable[cm_Temp]:=true;
  end else begin
   APC.Cmd.Enable[cm_Name]:=false;
   APC.Cmd.Enable[cm_Inpv]:=false;
   APC.Cmd.Enable[cm_Outv]:=false;
   APC.Cmd.Enable[cm_Batv]:=false;
   APC.Cmd.Enable[cm_Outb]:=false;
   APC.Cmd.Enable[cm_Char]:=false;
   APC.Cmd.Enable[cm_Outl]:=false;
   APC.Cmd.Enable[cm_Freq]:=false;
   APC.Cmd.Enable[cm_Temp]:=false;
  end;
 end;
 //
 // Post command to local/remote server.
 //
 procedure PostCmdLocal(cmd:String);
 begin
  DevPostCmdLocal(cmd);
 end;
 procedure PostCmdRemote(cmd:String);
 begin
  Dim_GuiConsoleSend(DevName,cmd);
 end;
 {
 Menu Tools Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть окно: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: нормальный  (3)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: ввод-вывод (15)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: детальный  (31)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Загрузить параметры из INI файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@LoadIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сохранить параметры в  INI файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SaveIni');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Tools Handler to handle editing.
 }
 procedure MenuToolsHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
 end;
 {
 Menu Yes/No.
 }
 procedure MenuConfirmStarter;
 var n:Integer;s:String;
 begin
  s:='';
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Выключение устройства"');
   n:=n+EditAddInputLn('Вы уверены, что хотите выключить UPS?');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   s:=Str(APC.ENABLE.tag);
   n:=n+EditAddClosing('YesNo',EditGetUID('APC_DISABLE'),s);
   if (n>0) then Problem('Error initializing YesNo!');
  end else Problem('Cannot edit right now!');
  s:='';
 end;
 {
 GUI Handler to process user input...
 }
 procedure APC_GUI_POLL;
 var s:String; ClickCurve:Integer;
  //
  // Xor bit on click (local version).
  //
  procedure ClickBitXorLocal(tag,XorMask:Integer);
  begin
   if (ClickTag=tag) then begin
    bNul(iSetTagXor(tag,XorMask));
    bNul(Voice(snd_Click));
   end;
  end;
  {
  Xor bit on click (remote version).
  }
  procedure ClickTagXorRemote(tag,XorMask:Integer);
  var b:Boolean; nv:Integer;
  begin
   if IsRefTag(tag) then
   if (ClickTag=tag) then begin
    DIM_GuiClickSend(DIM_GuiClickBuff+'NewValue='+Str(iXor(iGetTag(tag),XorMask)));
    b:=Voice(snd_Click);
   end;
  end;
  //
  // Send command (cmd) to device (dev) on tag click.
  //
  procedure ClickTagDevSendCmd(tag,dev:Integer; cmd:String);
  begin
   if Length(cmd)>0 then
   if IsRefTag(tag) then
   if IsRefDevice(dev) then
   if ClickTag=tag then begin
    bNul(Voice(snd_Click));
    DevSendCmd(dev,cmd);
   end;
  end;
 begin
  s:='';
  DIM_GuiClickBuff:='';
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   //
   // Copy GUI click to DIM buffer for remote execution.
   //
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     //
     // Handle local clicks
     //
     if ClickIsLocal then begin
      {
      Click Tags...
      }
      if ClickTag<>0 then begin
       ClickTagXorRemote(APC.POLL_EN.tag,1);
       ClickTagXorRemote(APC.TEST.tag,0);
       ClickTagXorRemote(APC.ENABLE.tag,1);
       ClickTagDevSendCmd(APC.TEST.tag,devMySelf,'@Test');
       ClickTagDevSendCmd(APC.POLL_EN.tag,devMySelf,'@PollEn');
       if ClickTag=APC.ENABLE.tag  then begin
        if not iGetTagBitState(APC.ENABLE.tag,1) then DevSendCmd(devMySelf,'@Enable') else MenuConfirmStarter;
       end;
      end;
     end;
     {
     Handle sensor clicks...
     }
     if IsSameText(ClickSensor,'HELP') then begin
      DevPostCmdLocal('@BrowseHelp');
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'APC.TITLE') then begin
      MenuToolsStarter;
      bNul(Voice(snd_Click));
     end;
     {
     Select Plot & Tab windows by curve...
     }
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     {
     Console commands: @url_encoded_sensor ...
     }
     if LooksLikeCommand(ClickSensor) then begin
      DevPostCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
     //
     // Handle remote clicks comes from DIM via @DimGuiClick message.
     // @DimGuiClick default handler decode and write events to FIFO,
     // so we can find it as clicks and can handle it in usual way.
     //
     if ClickIsRemote then begin
      //
      // Show time difference.
      //
      if DebugFlagEnabled(dfDetails) then
      Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
      //
      // Handle remote console commands...
      //
      s:=Dim_GuiConsoleRecv(DevName,'');
      if LooksLikeCommand(s) then DevSendCmdLocal(s);
      //
      // Handle remote sensor clicks...
      //
      if TypeTag(ClickTag)>0 then begin
       s:=ClickParams('NewValue');
       if Length(s)>0 then begin
        if ClickTag=APC.TEST.tag then begin
         UpdateTag(ClickTag,s,0,1);
         devSendCmd(devMySelf,'@Test');
        end;
        if ClickTag=APC.POLL_EN.tag then UpdateTag(ClickTag,s,0,1);
        if ClickTag=APC.ENABLE.tag then begin
         UpdateTag(ClickTag,s,0,3);
         if not iGetTagBitState(APC.ENABLE.tag,1) then DevSendCmd(devMySelf,'@Enable');
        end;
       end;
      end;
     end;
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Warning, Information dialog completion.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  {
  YesNo dialog for confirmation of Diasable UPS
  }
  if EditTestResultName(EditGetUID('APC_DISABLE')) then begin
   if EditTestResultCode(mr_YES) then begin
    DevSendCmd(devMySelf,'@Disable');
    if DIM_IsClientMode then DevSendCmd(devMySelf,'@Remote @Disable');
   end;
   if EditTestResultCode(mr_NO) then Success('Now I do not something');
   EditReset;
  end;
  {
  Menu TOOLS.
  }
  MenuToolsHandler;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end;
  if EditStateError then begin
   Problem('Dialog error detected!');
   EditReset;
  end;
 end;
 {
 DIM Update tag
 }
 procedure APC_DIM_Update_tag;
 begin
 if DIM_IsServerMode then begin
   if SysTimer_Pulse(10000)>0 then APC_FillTags(-MaxReal);
   if ShouldRefresh(APC.POLL_EN.val,iGetTag(APC.POLL_EN.tag))>0
   then DIM_UpdateTag(APC.POLL_EN.tag,'');
   if ShouldRefresh(APC.ENABLE.val,iGetTag(APC.ENABLE.tag))>0
   then DIM_UpdateTag(APC.ENABLE.tag,'');
   if ShouldRefresh(APC.TEST.val,iGetTag(APC.TEST.tag))>0
   then DIM_UpdateTag(APC.TEST.tag,'');
   if ShouldRefresh(APC.STATUS.val,iGetTag(APC.STATUS.tag))>0
   then DIM_UpdateTag(APC.STATUS.tag,'');
   if ShouldRefresh(APC.INDIC.val,HashIndexOf(sGetTag(APC.INDIC.tag),0,0))>0
   then DIM_UpdateTag(APC.INDIC.tag,'');
   if ShouldRefresh(APC.ITSELF.val,HashIndexOf(sGetTag(APC.ITSELF.tag),0,0))>0
   then DIM_UpdateTag(APC.ITSELF.tag,'');
   if ShouldRefresh(APC.NAME.val,HashIndexOf(sGetTag(APC.NAME.tag),0,0))>0
   then DIM_UpdateTag(APC.NAME.tag,'');
   if ShouldRefresh(APC.UINP.val,rGetTag(APC.UINP.tag))>0
   then DIM_UpdateTag(APC.UINP.tag,'');
   if ShouldRefresh(APC.FREQ.val,rGetTag(APC.FREQ.tag))>0
   then DIM_UpdateTag(APC.FREQ.tag,'');
   if ShouldRefresh(APC.UOUT.val,rGetTag(APC.UOUT.tag))>0
   then DIM_UpdateTag(APC.UOUT.tag,'');
   if ShouldRefresh(APC.UBAT.val,rGetTag(APC.UBAT.tag))>0
   then DIM_UpdateTag(APC.UBAT.tag,'');
   if ShouldRefresh(APC.VBAT.val,rGetTag(APC.VBAT.tag))>0
   then DIM_UpdateTag(APC.VBAT.tag,'');
   if ShouldRefresh(APC.CBAT.val,rGetTag(APC.CBAT.tag))>0
   then DIM_UpdateTag(APC.CBAT.tag,'');
   if ShouldRefresh(APC.POUT.val,rGetTag(APC.POUT.tag))>0
   then DIM_UpdateTag(APC.POUT.tag,'');
   if ShouldRefresh(APC.TEMP.val,rGetTag(APC.TEMP.tag))>0
   then DIM_UpdateTag(APC.TEMP.tag,'');
   if ShouldRefresh(APC.STATE.val,rGetTag(APC.STATE.tag))>0
   then DIM_UpdateTag(APC.STATE.tag,'');
   if ShouldRefresh(APC.POLLRATE.val,iGetTag(APC.POLLRATE.tag))>0
   then DIM_UpdateTag(APC.POLLRATE.tag,'');
  end;
 end;
 {
 APC Polling
 }
 procedure APC_Poll;
 begin
  if not DIM_IsClientMode then begin
   EnabledPoll;
   if APC.Simulator then begin
    if (pipe_connected(APC.PipeCon.PipeSIM)>0) then begin
     APC.PipeCon.Req:=pipe_recv(APC.PipeCon.PipeSIM,1);
     if (Length(APC.PipeCon.Req)>0) then APC_Simulation(APC.PipeCon.Req);
    end;
   end else begin
    if SysTimer_Pulse(1000)>0 then begin
     bNul(iSetTag(APC.POLLRATE.tag,APC.PipeCon.PollRate));
     UpdateAo(ao_Poll,time,APC.PipeCon.PollRate);
     APC.PipeCon.PollRate:=0;
    end;
   end;
   APC_CmdCycle;
   APC_DIM_Update_tag;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  APC_ClearStrings;
  APC_ClearCmdTab;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  cmd_Enable      := RegisterStdInCmd('@Enable',      '');
  cmd_Disable     := RegisterStdInCmd('@Disable',     '');
  cmd_Test        := RegisterStdInCmd('@Test',        '');
  cmd_PollEn      := RegisterStdInCmd('@PollEn',      '');
  cmd_MenuTools   := RegisterStdInCmd('@MenuTools',   '');
  cmd_DimTagUpdate:= RegisterStdInCmd('@DimTagUpdate','');
  cmd_DimCmdMy    := RegisterStdInCmd('@DimCmd_my'   ,'');
  cmd_Remote      := RegisterStdInCmd('@Remote',      '');
  APC.Simulator:=Val(ReadIni('Simulator'))>0;
  APC.ModeConnect := ReadIni('ModeConnect');
  APC_InitTags(ReadIni('tagPrefix'),-MaxReal);
  APC_InitCmdTab;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then DevSendCmdLocal('@LoadIni');
  if not DIM_IsClientMode then begin
   if DIM_IsServerMode then begin 
    Details('IsServerMode = yes');
    bNul(iSetTag(APC.SERVMODE.tag,0));
   end;
   if APC_PipeConnect then Success('Connection success') else begin
    bNul(iSetTag(APC.STATUS.tag,stt_Ref));
    UpdateDo(do_Status,time,iGetTag(APC.STATUS.tag));
    Problem(GetDateTime(mSecNow)+': Connection fault!');
   end;
  end else begin
   Details('IsServerMode = No');
   bNul(iSetTag(APC.SERVMODE.tag,1));
   Details('DIM_ClientServerMode = '+str(DIM_ClientServerMode));
  end;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  APC_PipeFree;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  APC_GUI_POLL;
  APC_Poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,cdm_arg_nocode:String; cmdid:Integer; i,tag:Integer; r:Real;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @Enable - Enable of device APC
   }
   if (cmdid=cmd_Enable) then begin
    if not DIM_IsClientMode then begin
     bNul(iSetTagBitState(APC.ENABLE.tag,0,true));
     APC.Cmd.Enable[cm_Enb1]:=true;
     APC.Cmd.Enable[cm_Enb2]:=true;
    end;
   end else
   {
   @Disable - Disable of device APC
   }
   if (cmdid=cmd_Disable) then begin
    if not DIM_IsClientMode then begin
     bNul(iSetTagBitState(APC.ENABLE.tag,0,false));
     APC.Cmd.Enable[cm_Dis1]:=true;
     APC.Cmd.Enable[cm_Dis2]:=true;
    end;
   end else
   {
   @Test - Test of device APC (Test indicators and Itself test)
   }
   if (cmdid=cmd_Test) then begin
    if not DIM_IsClientMode then begin
     if iGetTag(APC.TEST.tag)=0 then begin
      if (iGetTag(APC.ENABLE.tag)=0) or (iGetTag(APC.ENABLE.tag)=3) then begin
       bNul(iSetTag(APC.TEST.tag,1));
       APC.Cmd.Enable[cm_Indt]:=true;
       APC.Cmd.Enable[cm_Itst]:=true;
      end;
     end;
    end;
   end else
   {
   @PollEn - Enabled sending command all commands
   }
   if (cmdid=cmd_PollEn) then begin
    if not DIM_IsClientMode then begin
     if iGetTag(APC.POLL_EN.tag)=0 then bNul(iSetTag(APC.POLL_EN.tag,1))
     else if iGetTag(APC.POLL_EN.tag)=1 then bNul(iSetTag(APC.POLL_EN.tag,0))
    end;
   end else
   {
   @MenuTools - Open menu for save load from ini-file and call console
   }
   if (cmdid=cmd_MenuTools) then begin
    MenuToolsStarter;
   end else
   {
   @Remote
   }
   if (cmdid=cmd_Remote) then begin
    if not IsEmptyStr(arg) then PostCmdRemote(Trim(arg));
    Data:='';
   end else
   {
   @DimTagUpdate tag
   }
   if (cmdid=cmd_DimTagUpdate) then begin
    if DIM_IsClientMode and not DIM_IsServerMode then begin
     tag:=FindTag(Trim(arg));
     if tag=APC.UINP.tag     then UpdateAo(ao_Uinp,  time,rGetTag(tag));
     if tag=APC.FREQ.tag     then UpdateAo(ao_Freq,  time,rGetTag(tag));
     if tag=APC.UOUT.tag     then UpdateAo(ao_Uout,  time,rGetTag(tag));
     if tag=APC.UBAT.tag     then UpdateAo(ao_Ubat,  time,rGetTag(tag));
     if tag=APC.VBAT.tag     then UpdateAo(ao_Vbat,  time,rGetTag(tag));
     if tag=APC.CBAT.tag     then UpdateAo(ao_Cbat,  time,rGetTag(tag));
     if tag=APC.POUT.tag     then UpdateAo(ao_Pout,  time,rGetTag(tag));
     if tag=APC.TEMP.tag     then UpdateAo(ao_Temp,  time,rGetTag(tag));
     if tag=APC.STATE.tag    then UpdateDo(do_State, time,rGetTag(tag));
     if tag=APC.STATUS.tag   then UpdateDo(do_Status,time,iGetTag(tag));
     if tag=APC.POLLRATE.tag then UpdateAo(ao_Poll,  time,iGetTag(tag));
    end;
   end else
   {
   @DimCmd_my
   }
   if (cmdid=cmd_DimCmdMy) then begin
    //декодируем из base64
    cdm_arg_nocode:=base64_decode(arg);
    // Избавляемся от символ NUL (\x00).
    cdm_arg_nocode:=Trim(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@Enable') then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@Disable') then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@Test') then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@PollEn') then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@MenuTools') then DevPostCmdLocal(cdm_arg_nocode);
    Success('@DIMCMD_MY='+cmd+' arg<'+cdm_arg_nocode+'>');
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
