﻿---

[[toc]]

---

# Справка по AKIP

---

**AKIP** - Драйвер удаленного управления осциллографом модели АКИП-4134/1А.

Документация: [Worksheet](Worksheet/).

---

## Назначение

---

**AKIP** - Драйвер удаленного управления осциллографом модели **АКИП-4134/1А** компании **SIGLENT TECHNOLOGIES CO**

- Осциллограф запоминающий цифровой АКИП-4134/1А предназначен для исследования и измерений параметров однократных сигналов и периодических сигналов в полосе частот 0...1 ГГц.
- Осциллограф обеспечивает цифровое запоминание, цифровое измерение в диапазоне амплитуд от 500 мкВ до 400 Впик (вход 1 МОм) и временных интервалов от 200 пс/дел до 1000 с/дел, автоматическую установку размеров изображения,
  автоматическое измерение амплитудно-временных параметров входного сигнала с выводом результата измерения на экране осциллографа.
- Осциллограф обеспечивает возможность подключения к персональному компьютеру через интерфейсы USB (host/device), LAN, опционально WIFI (через USB WIFI адаптер).
- Данная модель осциллографа имеет 4 канала, полосу пропускания в 350 МГц, максимальную частоту дискретизации 2,5 ГГц/канал и 5 ГГц при объединении каналов, Максимальный объем памяти состовляет 125 МБ/канал и 250 МБ при объединении каналов.

![](worksheet/osc.png)

Драйвер разработан с использованием стандартной библиотеки **[StdLibrary](../../../Resource/DaqSite/StdLib/Include/__readme__.htm)**
и использует сетевую технологию DIM для передачи данных **[&DIMSRV](../../../Resource/DaqSite/DimServer/dimsrv.htm)

**Задачи** драйвера:

- Удаленное управление списком параметров;
- Получение, обработка и сохранение осциллограмм;
- Сохранение осциллограмм в файлы и копирование этих файлов на управляющий компьютер.

---

## Конфигурирование и использование AKIP

---

Для конфигурирования драйвера **AKIP** используйте
файл-генератор **[akip_devices.cmd](../Config/akip_devices.cmd)**.

В генераторе описывается таблица устройств __:AKIPDevices__.
В ней указываются следующие параметры:

- *Device*     - Отображаемое имя устройства.
- *Facility*   - Имя (префикс) установки в составе которой будет работать драйвер;
- *Identifier* - Идентификатор устройства, который используется для разделения экземпляров драйвера (для каждого осциллографа отдельно);
- *HostName*   - Адрес **TCP** соединения
- *Polling*    - Период опроса, мс;
- *TimeOut*    - Время выхода из опроса при зависании, мс.

Для использования драйвера **AKIP** в целевой **DAQ**-системе,
необходимо скопировать файл-генератор **[akip_devices.cmd](../Config/akip_devices.cmd)**
в каталог **`Config`** **DAQ**-системы, сконфигруировать таблицу устройств
и запустить файл на исполнение.
После успешного выполнения генератора, в каталог **Config**  будут добавлены файлы:

- *akip_devices_dic.cfg* - клиентский DIM файл;
- *akip_devices_dis.cfg* - серверный DIM файл;
- *akip_devices_hdw.cfg* - основная конфигурация драйвера;
- *akip_devices_sim.cfg* - симулятор драйвера.

В каталог **Circuits** будет добавлен файл **akip_devices_link.crc**.

Так же нужно перенести два pas-файла **[akip_drv.pas](../DaqPas/akip_drv.pas)** и **[akip_waveform.pas](../DaqPas/akip_waveform.pas)**
 в каталог **`DaqPas`** **DAQ**-системы , и файл с мнемосхеммой **[akip_ctrl_param.crc](../Circuits/akip_devices_link.crc)** в каталог **`Circuits`**.

В драйвере предусмотренна возможность обработки осциллограмм в двух режимах: 1) Сразу после получения *(Online)*; 2) По мере необходимости *(Offline)*;

Параметр обработки можно указать при первичной настройке конфигурации или по необходимости в интерфейсе пользователя обработчика осциллограмм.

---

## Использование драйвера

---

![Интерфейс удаленного управления осциллографом](worksheet/int.png){.border2px .dashed .bdblack width=1500}

Окно разделено на 8 *блоков*: 
- *Сбор информации*
- *Настройка каналов*
- *Запуск*
- *Настройка осциллограммы*
- *Получение осциллограмм и их обработка*
- *Настройка триггера типа EDGE*
- *Состояния устройства с дополнительными инструментами*
- *Сохранение и копирование*

** Блок сбора информации **

В *блоке сбора информации* указывается количество выделяемой памяти на канал, которое меняется в зависимости от того в каком режиме включен каналы(раздельный и объединенный).
Указывается тип получаемых данных, полседовательность получения данных, временная задержка и масштабируемость, режим триггера.
Здесь же можно включить автно-настройку, запустить триггер в последнем его состоянии или остановить его.

Сенсор *Memory* - поле выбора количества выделяемой памяти на канал. В зависимости от режима работы каналов выборка памяти меняется, как представленно в таблице ниже.
| Режим работы каналов | Размер выделенной памяти |
|----------------------|--------------------------|
|                      | 10k, 50k, 250k,          |
|      Один канал      | 1.25M, 2.5M, 12.5M,      |
|                      | 25M, 125M, 250M.         |
|----------------------|--------------------------|
|                      | 5k, 25k, 125k,           |
|  Объединенные каналы | 625k, 1.25M, 6.25M,      |
|                      | 12.5M, 62.5M, 125M.      |

** Блок настройки каналов **

В *блоке настройки каналов* происходит настройка каналов, а имеенно какие каналы будут включены, их видимость, тип подключения, масштабируемость, сопротивление и смещение.
Включенные каналы подсвечиваются зелёным цветом. Если канал выключен, взаимодействие с параметрами этого канала будет не возможной.

Режим связи канала может принимать следующие параметры:
| Параметр | Описание            |
|----------|---------------------|
|  **DC**  | direct current      |
|  **AC**  | alternating current |
|  **GND** | ground              |

Входное сопротивление канала может быть двух видов: 
| Параметр  | Описание |
|-----------|----------|
| **ONEMeg**| 1  MOhm  |
| **FIFTy** | 50 ohm   |

** Блок запуска **

В *блоке запуска* 3 активных сенсора и 1 сенсор состояния. Сенсор *Trig Stat* отвечает за состояние триггера, *Trig Mode* за режим триггера, кнопки *Run* и *Stop* за запуск последнего запущенного режима триггера и его отсановку.

** Блок настройки осциллограмм **

В *блоке настройки осциллограмм* указываются формат осциллограммы, источник, с какой точки считывать осциллограмму, какой интервал будет между точками и количество интересующих точек.
**Следует обратить внимание**, что осциллограф считывает осциллограмму с её начала (если не указаны начальная точка) и может возникнуть ситуация, где искомый сигнал не попадает в выставленные рамки точек.
Так же следует учитывать, что в *блоке сбора информации* есть окошко показывающее количество доступных точек на данный момент, которое зависит от выделенной памяти, временной задержки и её масштаба.
И если вы указали условно **50000** точек, а в окошке указано всего **10000**, то осциллограмма будет записана на **10000** точек.
Если будет указано 0 количество точек, то в этом случае в осциллограмме будет исполльзоваться количество точек указанное в *блоке сбора информации*.

** Блок получение осциллограмм и их обработка**

В блоке 6 активных сенсоров отвечающие за получение, обработку, копирование и отрисовку осциллограмм. 
Сенсор *Online/Offline* показывает статус обработчика осйиллограмм, который может обрабатывать осциллограммы при получении или не обрбатывать их.
Обработка производится по этой формуле ![Формула обработки данных](worksheet/form.png)
Сенсор *Auto drw* отвечает за автоматическую отрисовку графиков кривых на экране.

** Блок настройки триггера типа EDGE **

В *блоке настройки триггера типа EDGE* происходит настройка EDGE триггера. Сразу стоит выделить, что в драйвере реализована работа **только**{.red} с **EDGE** триггерами и в случае выбора другого типа триггера, данная секция будет не доступна.
Здесь указываются тип триггера, отбраковка шума, задержка, соединение, количество событий для фиксации, время для фиксации, начальная позиция для фиксации, уровень срабатывания триггера, крутизна триггера, источник триггера.


** Блок состояния устройства с дополнительными инструментами **

В *блоке состояния устройства с дополнительными инструментами* отображаются модель устройства, дата и время сервера, имя сервера, состояние опроса, количество отправляемых запросов в секунду, количество ошибок, дополнительные параметры.

** Блок сохранения и копирования **

В *блоке сохранения и копирования* отображаются и указываются пути сохранения и копирования полученных осциллограмм.
Здесь же имеется возможность обработки осциллограмм полученных ранее, записанных в **raw** формате.

Здесь же отображаются статусы получения, записи и копирования осциллограмм в виде 5 сенсоров соответственно.

---

## Получение осциллограмм

---

Перед получением осциллограм, необходимо выставить нужные параметры или загрузить их из ini-файла.

Получение осциллограмм реализовано несколькими способами:

1) Консольная команда **@SingleStart**. Команду можно ввести через консоль или отправить через DIM сервис **DIMCMDMY**.
При получении команды, драйвер выставляет режим триггера в **Single** режим и в окне статуса триггера будет надпись **Ready**.
В это время в цикле опрашивается только одна команда, связанная со статусом триггера. После получения сигнала, статус триггера измениться на **Stop**, после чего драйвер начнет отправлять команды на получение осциллограмм.
Команда на получение осциллограмм, отправляется для каждого **включенного** канала. После получения ответа на команду, данные записываются в теги, после чего работа переходит второму драйверу.

2) Через интерфейс. В этом случае нужно в поле **Trig Mode** выбрать режим **Single**, полсле чего осциллограф будет ждать сигнала. Дальнейший алгоритм не отличается от того что был описан в способе выше.

3) Есть возможность получить осциллограмму ещё раз, в случае если не было нового сигнала и осцилллографф не выходил из режима **Получить**. В этом случае нужно нажать кнопку **WaveForm** после чего осциллограмма будет получена для всех активных каналов.

При использовании любого из выше перечисленных спопобов, в случае успешного сохранения файлов загорятся сенсоры статусов.
Помимо этого в самом драйвере будет выведенно окно с отображением полученных осциллограмм в виде графика кривой.

---

## Решение проблем

---

(выключен канал)(включете нужный вам канал).

(выбран не тот тип триггера)(выбран не EDGE тип триггера).

(не указано ни одной точки для получения осциллограммы)(укажите количестов точек).

(не сохранились данные в укзанном месте)(проверьте путь).

(не правильно записалась осциллограмма)(проверьте количество точек).

(не меняются параметры в драйвере и как следствие на устройстве)(проверьте не зависло ли устройство или в каком режиме оно находится. Такое возможно если устройство находится в режиме ожидания сигнала, в этом случае следует перевести устройство в режим **Авто** и проверить как себя ведет драйвер и устройство. Если не помогло перезагрузите устройство.).

---

---

> <img height=16 width=16 src="data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAADySURBVEhL7ZZBDoMgEEU9U7feyhNwHq/AhhM1Tbrrqt98+KEipalD0wUvaGaG8f9RN0whcV+W6zybLEhF0RCiwa7DZFF5M1AJzo91PbnyL7EZKMfezQhIURPik6K4aYTmjgaG4xO9xDCoMQyaHBtcEs457z1bCVIUy61avWEg2I0nY56gVq0OqgYYhB2aS3Eu+r4O2gYAKWCQ16mLoFYH/2dQwvr3BuxmiqBEPfqxHxnsYDcCGQMJ8cdyl0Xc2dMwQJ/mAqzE5HVStDEV7Dw2OI+8exmIYdDk5wYdjy2KDF9C40O8/9ERV+5huKjc+fgewhMcGb5AepwFjgAAAABJRU5ErkJggg=="/>
  AKIP Copyright (c) 2024 DaqGroup <daqgroup@mail.ru>.  
 <img height=16 width=16 src="data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAAQhJREFUSEvtljEOgzAUQ3MvbsUJOA9XYMmJ2qFbp5q+YH2VINQSlgorjRz//+3QKSkvePT9reuaLFkV05xLwEdHk4XzHGBJyc9xPLjiPzEH+KzavRFkhafMk1kpNoLvXQIaXh/4I66ALVwBu9gMmKZpGIaUknZxRHHDIj1wQ4p0kXqAhlWOwK4cFlj8OoAy84RhYVIVhUiki9QD4kxE1NcBpHKtQwGyiF5u1g7gPwYYuAtvzzkVkR1R1XqAarZghm4IVZTYINja4/UAZiLoFtGwCBZwH+lh1qV6gKA+uzAprE3hNMOFOLIZ0ApXwC7+L+DEZ4tZw4/w9WV+/tNRv5jRcOF88vM95xfHjbs66Lo86gAAAABJRU5ErkJggg=="/>
 CRW-DAQ Copyright (c) 2001-2024 Alexey Kuryakin <daqgroup@mail.ru>.

---
