 {
 ***********************************************************************
 Daq Pascal application program AKIP_DRV.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @PrintCmdTable   - Print Command Table state.
| @Setting cmd v   - Send command with data v.
| @Edit cmd        - Edit command preferences.
| @LoadIni         - Load params from INI file.
| @SaveIni         - Save params to   INI file.
| @AssignTag t v   - Assign tag t to value v.
| @DimTagUpdate    - Update tag from DIM.
| @GetWaveForm     - Receipt waveform
| @Autoset         - Automatically adjust oscilloscope
| @TrigRun         - Command sets the oscilloscope to run.
| @TrigStop        - Command sets the oscilloscope to stop
| @SingleStart     - Set trigger to single mode
| @SingleStop      - Ser trigger to auto mode
| @SaveWaveForm    - Save oscillogram
| @ModeCalcDev arg - Mode calculate device offline or online
| @TrigDone        - Simulator get waveform
| @SetDirBase      - Set base directory
| @SetDirExp       - Set experiment directory
|********************************************************
[]
[Compiler.Options]
Compiler.sLenMax = 1024*1024*64;
[]
 }
program AKIP_DRV;                { AKIP driver                      }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 st_NoReq               = 0;     { Status : No request sent         }
 st_WaitAns             = 1;     { Status : Waiting answer          }
 st_WaitGap             = 2;     { Status : Waiting time gap        }
 st_TimeOut             = 3;     { Status : TimeOut found           }
 {------------------------------}{                                  }
 MaxCmdNum              = 92;   { Maximal number of commands       }
 cm_IDEN                = 1;     { Identifies instrument type       }
 cm_OPC                 = 2;     { Status pending device operations }
 cm_AUT                 = 3;     { Automatically adjust device      }
 cm_ACQ_MDEP            = 4;     { Set maximum memory depth         }
 cm_ACQ_MDEP_Q          = 5;     { Get maximum memory depth         }
 cm_ACQ_POIN_Q          = 6;     { Get number of sampled points     }
 cm_ACQ_SEQ             = 7;     { Set sequence acquisition mode    }
 cm_ACQ_SEQ_Q           = 8;     { Get sequence acquisition mode    }
 cm_ACQ_SMPLRT_Q        = 9;     { Get current sampling rate        }
 cm_ACQ_TYPE            = 10;    { Set type of data acquisition     }
 cm_ACQ_TYPE_Q          = 11;    { Get type of data acquisition     }
 cm_CN1_COUP            = 12;    { Set coupling mode for chan 1     }
 cm_CN2_COUP            = 13;    {                        ... 2     }
 cm_CN3_COUP            = 14;    {                        ... 3     }
 cm_CN4_COUP            = 15;    {                        ... 4     }
 cm_CN1_COUP_Q          = 16;    { Get coupling mode for chan 1     }
 cm_CN2_COUP_Q          = 17;    {                        ... 2     }
 cm_CN3_COUP_Q          = 18;    {                        ... 3     }
 cm_CN4_COUP_Q          = 19;    {                        ... 4     }
 cm_CN1_IMP             = 20;    { Set input impedance for chan 1   }
 cm_CN2_IMP             = 21;    {                          ... 2   }
 cm_CN3_IMP             = 22;    {                          ... 3   }
 cm_CN4_IMP             = 23;    {                          ... 4   }
 cm_CN1_IMP_Q           = 24;    { Get input impedance for chan 1   }
 cm_CN2_IMP_Q           = 25;    {                          ... 2   }
 cm_CN3_IMP_Q           = 26;    {                          ... 3   }
 cm_CN4_IMP_Q           = 27;    {                          ... 4   }
 cm_CN1_OFFS            = 28;    { Set vertical offset for chan 1   }
 cm_CN2_OFFS            = 29;    {                          ... 2   }
 cm_CN3_OFFS            = 30;    {                          ... 3   }
 cm_CN4_OFFS            = 31;    {                          ... 4   }
 cm_CN1_OFFS_Q          = 32;    { Get vertical offset for chan 1   }
 cm_CN2_OFFS_Q          = 33;    {                          ... 2   }
 cm_CN3_OFFS_Q          = 34;    {                          ... 3   }
 cm_CN4_OFFS_Q          = 35;    {                          ... 4   }
 cm_CN1_SCAL            = 36;    { Set vert sensitivity for chan 1  }
 cm_CN2_SCAL            = 37;    {                           ... 2  }
 cm_CN3_SCAL            = 38;    {                           ... 3  }
 cm_CN4_SCAL            = 39;    {                           ... 4  }
 cm_CN1_SCAL_Q          = 40;    { Get vert sensitivity for chan 1  }
 cm_CN2_SCAL_Q          = 41;    {                           ... 2  }
 cm_CN3_SCAL_Q          = 42;    {                           ... 3  }
 cm_CN4_SCAL_Q          = 43;    {                           ... 4  }
 cm_CN1_SWIT            = 44;    { Set display of the chan 1        }
 cm_CN2_SWIT            = 45;    {                     ... 2        }
 cm_CN3_SWIT            = 46;    {                     ... 3        }
 cm_CN4_SWIT            = 47;    {                     ... 4        }
 cm_CN1_SWIT_Q          = 48;    { Get display of the chan 1        }
 cm_CN2_SWIT_Q          = 49;    {                     ... 2        }
 cm_CN3_SWIT_Q          = 50;    {                     ... 3        }
 cm_CN4_SWIT_Q          = 51;    {                     ... 4        }
 cm_TIM_DEL             = 52;    { Set main timebase delay          }
 cm_TIM_DEL_Q           = 53;    { Get main timebase delay          }
 cm_TIM_SCAL            = 54;    { Set scale division horizontal    }
 cm_TIM_SCAL_Q          = 55;    { Get scale division horizontal    }
 cm_TRIG_MODE           = 56;    { Set trig mode                    }
 cm_TRIG_MODE_Q         = 57;    { Get trig mode                    }
 cm_TRIG_RUN            = 58;    { Set to run mode by trig          }
 cm_TRIG_STAT_Q         = 59;    { Get trig status                  }
 cm_TRIG_STOP           = 60;    { Set to stop from run mode        }
 cm_TRIG_TYPE           = 61;    { Set trig type                    }
 cm_TRIG_TYPE_Q         = 62;    { Get trig type                    }
 cm_TRIG_EDGE_COUP      = 63;    { Set coupling mode of edge trig   }
 cm_TRIG_EDGE_COUP_Q    = 64;    { Get coupling mode of edge trig   }
 cm_TRIG_EDGE_HLDEV     = 65;    { Set number of holdoff events     }
 cm_TRIG_EDGE_HLDEV_Q   = 66;    { Get number of holdoff events     }
 cm_TRIG_EDGE_HLDT      = 67;    { Set holdoff time of edge trig    }
 cm_TRIG_EDGE_HLDT_Q    = 68;    { Get holdoff time of edge trig    }
 cm_TRIG_EDGE_HOLD      = 69;    { Set holdoff type of edge trig    }
 cm_TRIG_EDGE_HOLD_Q    = 70;    { Get holdoff type of edge trig    }
 cm_TRIG_EDGE_HST       = 71;    { Set holdoff initial position     }
 cm_TRIG_EDGE_HST_Q     = 72;    { Get holdoff initial position     }
 cm_TRIG_EDGE_LEV       = 73;    { Set edge trig level              }
 cm_TRIG_EDGE_LEV_Q     = 74;    { Get edge trig level              }
 cm_TRIG_EDGE_NREJ      = 75;    { Set noise rejection state        }
 cm_TRIG_EDGE_NREJ_Q    = 76;    { Get noise rejection state        }
 cm_TRIG_EDGE_SLOP      = 77;    { Set edge trig slope              }
 cm_TRIG_EDGE_SLOP_Q    = 78;    { Get edge trig slope              }
 cm_TRIG_EDGE_SOUR      = 79;    { Set edge trig source             }
 cm_TRIG_EDGE_SOUR_Q    = 80;    { Get edge trig source             }
 cm_WAV_DATA_Q          = 81;    { Get the waveform source          }
 cm_WAV_INT             = 82;    { Set interval between data point  }
 cm_WAV_INT_Q           = 83;    { Get interval between data point  }
 cm_WAV_MAXP_Q          = 84;    { Get maximum points of one piece  }
 cm_WAV_POIN            = 85;    { Set number waveform points       }
 cm_WAV_POIN_Q          = 86;    { Get number waveform points       }
 cm_WAV_SOUR            = 87;    { Set waveform source              }
 cm_WAV_SOUR_Q          = 88;    { Get waveform source              }
 cm_WAV_STAR            = 89;    { Set starting data point          }
 cm_WAV_STAR_Q          = 90;    { Get starting data point          }
 cm_WAV_WIDT            = 91;    { Set waveform data output format  }
 cm_WAV_WIDT_Q          = 92;    { Get waveform data output format  }
 {------------------------------}{ Digital outputs:                 }
 do_POLL_RATE           = 0;     { Poll rate                        }
 do_ERROR_CNT           = 1;     { Error counter                    }
 {------------------------------}{ Analog outputs:                  }
 ao_ACQ_POIN            = 0;     { Acquisition points               }
 ao_ACQ_SMPLRT          = 1;     { Acquisition sampling rate        }
 ao_CN1_SCAL            = 2;     { Vertical sensitivity channel 1   }
 ao_CN2_SCAL            = 3;     { Vertical sensitivity channel 2   }
 ao_CN3_SCAL            = 4;     { Vertical sensitivity channel 3   }
 ao_CN4_SCAL            = 5;     { Vertical sensitivity channel 4   }
 ao_TIM_DEL             = 6;     { Timebase delay                   }
 ao_TIM_SCAL            = 7;     { Horizontal scale                 }
 ao_TRIG_EDGE_HLDEV     = 8;     { Number holdoff events edge trig  }
 ao_TRIG_EDGE_HLDT      = 9;     { Holdoff time edge trigger        }
 ao_TRIG_EDGE_LEV       = 10;    { Trigger level edge trigger       }
 ao_WAV_INT             = 11;    { Interval between data point      }
 ao_WAV_MAXP            = 12;    { Maximum points one piece waveform}
 ao_WAV_POIN            = 13;    { Number waveform points           }
 ao_WAV_STAR            = 14;    { Starting data point waveform     }
 DelayOnStart           = 1000;  { Delay before start polling       }
 UseCmdHash             = false; { Use CmdHash for fast search      }
 DimDeadline            = 5000;  { Detect DIM server is dead        }
 stt_wfNone             = 0;     { Waveform request statuses:       }
 stt_wfSetSource        = 1;     {  Set data source                 }
 stt_wfChkSource        = 2;     {  Check data source               }
 stt_wfGetData          = 3;     {  Get wavedata                    }
 stt_wfIncSource        = 4;     {  Increment source number         }
 stt_wfGetSource        = 5;     {  Get source number               }
 stt_wfDone             = 6;     {  Waveform received success       }
 stt_trigNone           = 0;     { Trigger request status:          }
 stt_trigSetSingle      = 1;     {  Set edge trigger mode Single    }
 stt_trigReady          = 2;     {  Get edge trigger status Ready   }
 stt_trigDone           = 3;     {  Trigger done                    }
 stt_trigGetWaveForm    = 4;     {  Get wave form data              }
 stt_trigAuto           = 5;     {                                  }
 stt_trigAutoWork       = 6;     {                                  }
 stt_trigAutoStop       = 7;     {                                  }
 stat_Off               = 0;     { Status device off                }
 stat_On                = 1;     { Status device on                 }
 stat_TimeOut           = 2;     { Status TimeOut                   }
 stat_FalseTrig         = 3;     { Status False Trigger             }
 stat_Refuse            = 4;     { Status device refuse             }
 stat_Simulator         = 5;     { Status device simulator          }
 stat_Warning           = 6;     { Status device warning            }
 tm_wfSetSource         = 10000; { Data source setting timeout      }
 tm_trigSetSingle       = 15000; { Trigger mode setting timeout     }
 {------------------------------}{                                  }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types       }
 TChanRec = record               { AKIP channel data                }
  COUP    : TTagRef;             {  Coupling                        }
  IMP     : TTagRef;             {  Impedance                       }
  OFFS    : TTagRef;             {  Offset                          }
  SCAL    : TTagRef;             {  Scale                           }
  SWIT    : TTagRef;             {  Switch                          }
  WAVFORM : TTagRef;             {  Waveform                        }
 end;                            {                                  }
 {------------------------------}{                                  }
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables   }
 AKIP               : record     { AKIP data                        }
  IsWaveFormDataRequest : Boolean;{                                 }
  GetWaveFormStatus     : Integer;{                                 }
  GetWaveFormSource     : Integer;{                                 }
  GetWaveFormTimer      : Real;   {                                 }
  CalcDevRef        : Integer;   {                                  }
  WavePnt           : Integer;
  CalcDevName       : String;    {                                  }
  Simulator         : Boolean;   { Simulator mode                   }
  AutoSaveMode      : Boolean;   { Auto Save WaveForm mode          }
  ecTimeOut         : Integer;   { Error code: TimeOut              }
  GetTrigStatus     : Integer;   {                                  }
  GetTrigStatusTimer: Real;      {                                  }
  TagPrefix         : String;    {                                  }
  FilePrefix        : String;    {                                  }
  Pipe              : record     { Pipe port data                   }
   LastPoll         : Real;      { Time of last poll, ms            }
   PipeId           : Integer;   { Identification pipe port         }
   PipeName         : String;    { Ip address pipe port             }
   PipePort         : String;    { Number pipe port                 }
   PipeSIM          : Integer;   { Simulator pipe port              }
   PollPeriod       : Integer;   { Poll period, ms                  }
   PollRate         : Integer;   { Poll rate, poll/sec              }
   Req,Ans,Buf      : String;    { Request, Answer, Buffer          }
   ReqTime,AnsTime  : Real;      { Request time, Answer time, ms    }
   Status           : Integer;   { Status flag                      }
   TimeGap,TimeOut  : Integer;   { Time delay after poll,TimeOut, ms}
   LongTimeOut      : Integer;   { TimeOut for transfer wavedata, ms}
  end;                           {                                  }
  Cmd               : record     { Command cycle data               }
   Num              : Integer;   { Current command number           }
   Acronym          : array [1..MaxCmdNum] of String; {             }
   AoNum            : array [1..MaxCmdNum] of Integer;{             }
   Enabled          : array [1..MaxCmdNum] of Boolean;{             }
   OpData           : array [1..MaxCmdNum] of String; {             }
   OpBuff           : array [1..MaxCmdNum] of String; {             }
  end;                           {                                  }
  CmdHash           : Integer;   { Hash list ref. for fast search   }
  BASEDIR           : TTagRef;   { Base directory                   }
  EXPDIR            : TTagRef;   { Experiment directory             }
  EXTRACTNUM        : TTagRef;   { Extraction number                }
  MODECALCDEV       : TTagRef;   { Mode calculate device            }
  FILENAME          : TTagRef;   {                                  }
  CLOCK             : TTagRef;   { Server date time                 }
  SERVID            : TTagRef;   { Server identifier                }
  STATUS            : TTagRef;   { Status device                    }
  OSCNAME           : TTagRef;   { Name oscilloscope                }
  POLL              : record     { Polling parameters               }
   ENABLE           : TTagRef;   { Poll enable flag                 }
   RATE             : TTagRef;   { Poll rate on last second         }
  end;                           {                                  }
  DEF               : record;    { Default                          }
   DIRBASE          : TTagRef;   {  Base directory                  }
   DIREXP           : TTagRef;   {  Experiment directory            }
  end;                           {                                  }
  ERROR             : record     { Error count                      }
   CNT              : TTagRef;   {                                  }
  end;                           {                                  }
  IDENT             : TTagRef;   { Identification dev oscilloscope  }
  OPC               : TTagRef;   { Status device operation          }
  AUT               : TTagRef;   { Automatical setting device       }
  WAVESAVESTT       : TTagRef;   {                                  }
  ACQ               : record     { Acquire parametrs                }
   MDEP             : TTagRef;   { Maximum memory depth             }
   POIN             : TTagRef;   { Number points current waveform   }
   SEQ              : TTagRef;   { Sequence acquisition mode        }
   TYP              : TTagRef;   { Acquisition type                 }
   SMPLRT           : TTagRef;   { Sampling rate                    }
  end;                           {                                  }
  CN1,CN2,CN3,CN4   : TChanRec;  { Channels parametrs               }
  TIM               : record     { Time parametrs                   }
   DEL              : TTagRef;   { Delay value                      }
   SCAL             : TTagRef;   { Horizontal scale setting         }
  end;                           {                                  }
  TRIG              : record     { Trigger parametrs                }
   MODE             : TTagRef;   { Mode trigger                     }
   RUN              : TTagRef;   { Run oscilloscope trigger         }
   STAT             : TTagRef;   { State trigger                    }
   STOP             : TTagRef;   { Stop oscilloscope trigger        }
   TYP              : TTagRef;   { Type trigger                     }
   EDGE             : record     { Trigger EDGE parametrs           }
    COUP            : TTagRef;   { Coupling mode                    }
    HLDEV           : TTagRef;   { Number holdoff events            }
    HLDT            : TTagRef;   { Holdoff time                     }
    HOLD            : TTagRef;   { Holdoff type                     }
    HST             : TTagRef;   { Initial position holdoff ivents  }
    LEV             : TTagRef;   { Trigger level value              }
    NREJ            : TTagRef;   { State noise rejection            }
    SLOP            : TTagRef;   { Slope setting                    }
    SOUR            : TTagRef;   { Trigger source                   }
   end;                          {                                  }
  end;                           {                                  }
  WAV               : record     { Waveform data parametrs          }
   DATA             : TTagRef;   { Waveform data source             }
   INT              : TTagRef;   { Interval between data point      }
   MAXP             : TTagRef;   { Maximum points                   }
   POIN             : TTagRef;   { Number waveform points           }
   SOUR             : TTagRef;   { Source waveform                  }
   STAR             : TTagRef;   { Starting data point              }
   WIDT             : TTagRef;   { Output format                    }
  end;                           {                                  }
  SelfId            : String;    { Self pid@hostname                }
  SIM               : record     { Simulators data                  }
   IDENT            : String;    {                                  }
   OPC              : Integer;   {                                  }
   AUT              : Integer;   {                                  }
   ACQ_MDEP         : String;    {                                  }
   ACQ_POIN         : Integer;   {                                  }
   ACQ_SEQ          : String;    {                                  }
   ACQ_SMPLRT       : Real;      {                                  }
   ACQ_TYPE         : String;    {                                  }
   CN1_COUP         : String;    {                                  }
   CN2_COUP         : String;    {                                  }
   CN3_COUP         : String;    {                                  }
   CN4_COUP         : String;    {                                  }
   CN1_IMP          : String;    {                                  }
   CN2_IMP          : String;    {                                  }
   CN3_IMP          : String;    {                                  }
   CN4_IMP          : String;    {                                  }
   CN1_OFFS         : Real;      {                                  }
   CN2_OFFS         : Real;      {                                  }
   CN3_OFFS         : Real;      {                                  }
   CN4_OFFS         : Real;      {                                  }
   CN1_SCAL         : Real;      {                                  }
   CN2_SCAL         : Real;      {                                  }
   CN3_SCAL         : Real;      {                                  }
   CN4_SCAL         : Real;      {                                  }
   CN1_SWIT         : String;    {                                  }
   CN2_SWIT         : String;    {                                  }
   CN3_SWIT         : String;    {                                  }
   CN4_SWIT         : String;    {                                  }
   TIM_DEL          : Real;      {                                  }
   TIM_SCAL         : Real;      {                                  }
   TRIG_MODE        : String;    {                                  }
   TRIG_RUN         : Integer;   {                                  }
   TRIG_STAT        : String;    {                                  }
   TRIG_STOP        : Integer;   {                                  }
   TRIG_TYPE        : String;    {                                  }
   TRIG_EDGE_COUP   : String;    {                                  }
   TRIG_EDGE_HLDEV  : Integer;   {                                  }
   TRIG_EDGE_HLDT   : Real;      {                                  }
   TRIG_EDGE_HOLD   : String;    {                                  }
   TRIG_EDGE_HST    : String;    {                                  }
   TRIG_EDGE_LEV    : Real;      {                                  }
   TRIG_EDGE_NREJ   : String;    {                                  }
   TRIG_EDGE_SLOP   : String;    {                                  }
   TRIG_EDGE_SOUR   : String;    {                                  }
   WAV_DATA         : String;    {                                  }
   WAV_INT          : Integer;   {                                  }
   WAV_MAXP         : Integer;   {                                  }
   WAV_POIN         : Integer;   {                                  }
   WAV_SOUR         : String;    {                                  }
   WAV_STAR         : Integer;   {                                  }
   WAV_WIDT         : String;    {                                  }
  end;                           {                                  }
 end;                            {                                  }
 ColorNorm          : Integer;   { Color in normal state            }
 ColorWarn          : Integer;   { Color in warning state           }
 cmd_Edit           : Integer;   { Common commands                  }
 cmd_LoadIni        : Integer;   { Load INI                         }
 cmd_PrintCmdTable  : Integer;   { Print command table              }
 cmd_Setting        : Integer;   { Extra setting                    }
 cmd_SaveIni        : Integer;   { Save INI                         }
 cmd_AssignTag      : Integer;   { @AssignTag                       }
 cmd_DimTagUpdate   : Integer;   { @DimTagUpdate                    }
 cmd_GetWaveForm    : Integer;   { @GetWaveForm                     }
 cmd_Autoset        : Integer;   { @Autoset                         }
 cmd_TrigRun        : Integer;   { @TrigRun                         }
 cmd_TrigStop       : Integer;   { @TrigStop                        }
 cmd_DimCmdMy       : Integer;   { System Command @DimCmdMy         }
 cmd_SingleStart    : Integer;   { @SingleStart                     }
 cmd_SingleStop     : Integer;   { @SingleStop                      }
 cmd_AutoSaveWvFrm  : Integer;   { @AutoSave                        }
 cmd_AutoSaveStop   : Integer;   { @AutoStop                        }
 cmd_SaveWaveForm   : Integer;   { @SaveWaveForm                    }
 cmd_ModeCalcDev    : Integer;   { @ModeCalcDev                     }
 cmd_TrigDone       : Integer;   { @TrigDone                        }
 cmd_SetDirBase     : Integer;   { @SetDirBase                      }
 cmd_SetDirExp      : Integer;   { @SetDirExp                       }
 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions   }
 {------------------------------}{ And add User defined functions   }
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,15000);
 end;
 {
 Initialization tags
 }
 procedure AkipInitTags(Prefix:String);
 begin
  if not IsEmptyStr(Prefix) then begin
   DIM_GuiClickInit(Prefix+'.DIMGUICLICK');
   InitTag(AKIP.POLL.ENABLE.tag,    Prefix+'.POLL.ENABLE',      1);
   InitTag(AKIP.CLOCK.tag,          Prefix+'.CLOCK',            3);
   InitTag(AKIP.SERVID.tag,         Prefix+'.SERVID',           3);
   InitTag(AKIP.POLL.RATE.tag,      Prefix+'.POLL.RATE',        1);
   InitTag(AKIP.ERROR.CNT.tag,      Prefix+'.ERROR.CNT',        1);
   InitTag(AKIP.STATUS.tag,         Prefix+'.STATUS',           1);
   InitTag(AKIP.IDENT.tag,          Prefix+'.IDENT',            3);
   InitTag(AKIP.OPC.tag,            Prefix+'.OPC',              1);
   InitTag(AKIP.AUT.tag,            Prefix+'.AUT',              1);
   InitTag(AKIP.ACQ.MDEP.tag,       Prefix+'.ACQ.MDEP',         3);
   InitTag(AKIP.ACQ.POIN.tag,       Prefix+'.ACQ.POIN',         2);
   InitTag(AKIP.ACQ.SEQ.tag,        Prefix+'.ACQ.SEQ',          1);
   InitTag(AKIP.ACQ.SMPLRT.tag,     Prefix+'.ACQ.SMPLRT',       2);
   InitTag(AKIP.ACQ.TYP.tag,        Prefix+'.ACQ.TYP',          3);
   InitTag(AKIP.CN1.COUP.tag,       Prefix+'.CN1.COUP',         3);
   InitTag(AKIP.CN2.COUP.tag,       Prefix+'.CN2.COUP',         3);
   InitTag(AKIP.CN3.COUP.tag,       Prefix+'.CN3.COUP',         3);
   InitTag(AKIP.CN4.COUP.tag,       Prefix+'.CN4.COUP',         3);
   InitTag(AKIP.CN1.IMP.tag,        Prefix+'.CN1.IMP',          3);
   InitTag(AKIP.CN2.IMP.tag,        Prefix+'.CN2.IMP',          3);
   InitTag(AKIP.CN3.IMP.tag,        Prefix+'.CN3.IMP',          3);
   InitTag(AKIP.CN4.IMP.tag,        Prefix+'.CN4.IMP',          3);
   InitTag(AKIP.CN1.OFFS.tag,       Prefix+'.CN1.OFFS',         2);
   InitTag(AKIP.CN2.OFFS.tag,       Prefix+'.CN2.OFFS',         2);
   InitTag(AKIP.CN3.OFFS.tag,       Prefix+'.CN3.OFFS',         2);
   InitTag(AKIP.CN4.OFFS.tag,       Prefix+'.CN4.OFFS',         2);
   InitTag(AKIP.CN1.SCAL.tag,       Prefix+'.CN1.SCAL',         2);
   InitTag(AKIP.CN2.SCAL.tag,       Prefix+'.CN2.SCAL',         2);
   InitTag(AKIP.CN3.SCAL.tag,       Prefix+'.CN3.SCAL',         2);
   InitTag(AKIP.CN4.SCAL.tag,       Prefix+'.CN4.SCAL',         2);
   InitTag(AKIP.CN1.SWIT.tag,       Prefix+'.CN1.SWIT',         1);
   InitTag(AKIP.CN2.SWIT.tag,       Prefix+'.CN2.SWIT',         1);
   InitTag(AKIP.CN3.SWIT.tag,       Prefix+'.CN3.SWIT',         1);
   InitTag(AKIP.CN4.SWIT.tag,       Prefix+'.CN4.SWIT',         1);
   InitTag(AKIP.CN1.WAVFORM.tag,    Prefix+'.CN1.WAVFORM',      3);
   InitTag(AKIP.CN2.WAVFORM.tag,    Prefix+'.CN2.WAVFORM',      3);
   InitTag(AKIP.CN3.WAVFORM.tag,    Prefix+'.CN3.WAVFORM',      3);
   InitTag(AKIP.CN4.WAVFORM.tag,    Prefix+'.CN4.WAVFORM',      3);
   InitTag(AKIP.TIM.DEL.tag,        Prefix+'.TIM.DEL',          2);
   InitTag(AKIP.TIM.SCAL.tag,       Prefix+'.TIM.SCAL',         2);
   InitTag(AKIP.TRIG.MODE.tag,      Prefix+'.TRIG.MODE',        3);
   InitTag(AKIP.TRIG.RUN.tag,       Prefix+'.TRIG.RUN',         1);
   InitTag(AKIP.TRIG.STAT.tag,      Prefix+'.TRIG.STAT',        3);
   InitTag(AKIP.TRIG.STOP.tag,      Prefix+'.TRIG.STOP',        1);
   InitTag(AKIP.TRIG.TYP.tag,       Prefix+'.TRIG.TYP',         3);
   InitTag(AKIP.TRIG.EDGE.COUP.tag, Prefix+'.TRIG.EDGE.COUP',   3);
   InitTag(AKIP.TRIG.EDGE.HLDEV.tag,Prefix+'.TRIG.EDGE.HLDEV',  1);
   InitTag(AKIP.TRIG.EDGE.HLDT.tag, Prefix+'.TRIG.EDGE.HLDT',   2);
   InitTag(AKIP.TRIG.EDGE.HOLD.tag, Prefix+'.TRIG.EDGE.HOLD',   3);
   InitTag(AKIP.TRIG.EDGE.HST.tag,  Prefix+'.TRIG.EDGE.HST',    3);
   InitTag(AKIP.TRIG.EDGE.LEV.tag,  Prefix+'.TRIG.EDGE.LEV',    2);
   InitTag(AKIP.TRIG.EDGE.NREJ.tag, Prefix+'.TRIG.EDGE.NREJ',   1);
   InitTag(AKIP.TRIG.EDGE.SLOP.tag, Prefix+'.TRIG.EDGE.SLOP',   3);
   InitTag(AKIP.TRIG.EDGE.SOUR.tag, Prefix+'.TRIG.EDGE.SOUR',   3);
   InitTag(AKIP.WAV.DATA.tag,       Prefix+'.WAV.DATA',         1);
   InitTag(AKIP.WAV.INT.tag,        Prefix+'.WAV.INT',          1);
   InitTag(AKIP.WAV.MAXP.tag,       Prefix+'.WAV.MAXP',         1);
   InitTag(AKIP.WAV.POIN.tag,       Prefix+'.WAV.POIN',         1);
   InitTag(AKIP.WAV.SOUR.tag,       Prefix+'.WAV.SOUR',         3);
   InitTag(AKIP.WAV.STAR.tag,       Prefix+'.WAV.STAR',         1);
   InitTag(AKIP.WAV.WIDT.tag,       Prefix+'.WAV.WIDT',         3);
   InitTag(AKIP.BASEDIR.tag,        Prefix+'.BASEDIR',          3);
   InitTag(AKIP.EXPDIR.tag,         Prefix+'.EXPDIR',           3);
   InitTag(AKIP.DEF.DIRBASE.tag,    Prefix+'.DEF.DIRBASE',      3);
   InitTag(AKIP.DEF.DIREXP.tag,     Prefix+'.DEF.DIREXP',       3);
   InitTag(AKIP.EXTRACTNUM.tag,     Prefix+'.EXTRACTNUM',       3);
   InitTag(AKIP.MODECALCDEV.tag,    Prefix+'.MODECALCDEV',      1);
   InitTag(AKIP.FILENAME.tag,       Prefix+'.FILENAME',         3);
   InitTag(AKIP.WAVESAVESTT.tag,    Prefix+'.WAVESAVESTT',      1);
   InitTag(AKIP.OSCNAME.tag,        Prefix+'.OSCNAME',          3);
  end else Trouble('Tags initialization error. Prefix not specified!');
 end;
 {
 Initialization simulation data
 }
 procedure InitSimulation;
 begin
  AKIP.SIM.IDENT:='AKIP AKIP-4134/1A';
  AKIP.SIM.OPC:=1;
  AKIP.SIM.AUT:=0;
  AKIP.SIM.ACQ_MDEP:='250k';
  AKIP.SIM.ACQ_POIN:=1000;
  AKIP.SIM.ACQ_SEQ:='OFF';
  AKIP.SIM.ACQ_SMPLRT:=1.25E+09;
  AKIP.SIM.ACQ_TYPE:='Norm';
  AKIP.SIM.CN1_COUP:='DC';
  AKIP.SIM.CN2_COUP:='DC';
  AKIP.SIM.CN3_COUP:='DC';
  AKIP.SIM.CN4_COUP:='DC';
  AKIP.SIM.CN1_IMP:='ONEMeg';
  AKIP.SIM.CN2_IMP:='ONEMeg';
  AKIP.SIM.CN3_IMP:='ONEMeg';
  AKIP.SIM.CN4_IMP:='ONEMeg';
  AKIP.SIM.CN1_OFFS:=-2.8E+0;
  AKIP.SIM.CN2_OFFS:=-2.8E+0;
  AKIP.SIM.CN3_OFFS:=-2.8E+0;
  AKIP.SIM.CN4_OFFS:=-2.8E+0;
  AKIP.SIM.CN1_SCAL:=5.00E-2;
  AKIP.SIM.CN2_SCAL:=5.00E-2;
  AKIP.SIM.CN3_SCAL:=5.00E-2;
  AKIP.SIM.CN4_SCAL:=5.00E-2;
  AKIP.SIM.CN1_SWIT:='ON';
  AKIP.SIM.CN2_SWIT:='ON';
  AKIP.SIM.CN3_SWIT:='ON';
  AKIP.SIM.CN4_SWIT:='ON';
  AKIP.SIM.TIM_DEL:=1.00E-05;
  AKIP.SIM.TIM_SCAL:=1.00E-07;
  AKIP.SIM.TRIG_MODE:='Auto';
  AKIP.SIM.TRIG_RUN:=1;
  AKIP.SIM.TRIG_STAT:='Roll';
  AKIP.SIM.TRIG_STOP:=0;
  AKIP.SIM.TRIG_TYPE:='EDGE';
  AKIP.SIM.TRIG_EDGE_COUP:='DC';
  AKIP.SIM.TRIG_EDGE_HLDEV:=3;
  AKIP.SIM.TRIG_EDGE_HLDT:=1.50E-08;
  AKIP.SIM.TRIG_EDGE_HOLD:='OFF';
  AKIP.SIM.TRIG_EDGE_HST:='LAST_TRIG';
  AKIP.SIM.TRIG_EDGE_LEV:=5.00E-01;
  AKIP.SIM.TRIG_EDGE_NREJ:='OFF';
  AKIP.SIM.TRIG_EDGE_SLOP:='RISing';
  AKIP.SIM.TRIG_EDGE_SOUR:='EX5';
  AKIP.SIM.WAV_DATA:='#9000000100';
  AKIP.SIM.WAV_INT:=200;
  AKIP.SIM.WAV_MAXP:=2500000;
  AKIP.SIM.WAV_POIN:=1000;
  AKIP.SIM.WAV_SOUR:='C1';
  AKIP.SIM.WAV_STAR:=1000;
  AKIP.SIM.WAV_WIDT:='BYTE';
 end;
 {
 Tags filling
 }
 procedure AkipFillTags(InitVal:Real);
 begin
  AKIP.POLL.ENABLE.val:=InitVal;
  AKIP.CLOCK.val:=InitVal;
  AKIP.SERVID.val:=InitVal;
  AKIP.POLL.RATE.val:=InitVal;
  AKIP.ERROR.CNT.val:=InitVal;
  AKIP.STATUS.val:=InitVal;
  AKIP.OPC.val:=InitVal;
  AKIP.AUT.val:=InitVal;
  AKIP.IDENT.val:=InitVal;
  AKIP.ACQ.MDEP.val:=InitVal;
  AKIP.ACQ.POIN.val:=InitVal;
  AKIP.ACQ.SEQ.val:=InitVal;
  AKIP.ACQ.SMPLRT.val:=InitVal;
  AKIP.ACQ.TYP.val:=InitVal;
  AKIP.CN1.COUP.val:=InitVal;
  AKIP.CN2.COUP.val:=InitVal;
  AKIP.CN3.COUP.val:=InitVal;
  AKIP.CN4.COUP.val:=InitVal;
  AKIP.CN1.IMP.val:=InitVal;
  AKIP.CN2.IMP.val:=InitVal;
  AKIP.CN3.IMP.val:=InitVal;
  AKIP.CN4.IMP.val:=InitVal;
  AKIP.CN1.OFFS.val:=InitVal;
  AKIP.CN2.OFFS.val:=InitVal;
  AKIP.CN3.OFFS.val:=InitVal;
  AKIP.CN4.OFFS.val:=InitVal;
  AKIP.CN1.SCAL.val:=InitVal;
  AKIP.CN2.SCAL.val:=InitVal;
  AKIP.CN3.SCAL.val:=InitVal;
  AKIP.CN4.SCAL.val:=InitVal;
  AKIP.CN1.SWIT.val:=InitVal;
  AKIP.CN2.SWIT.val:=InitVal;
  AKIP.CN3.SWIT.val:=InitVal;
  AKIP.CN4.SWIT.val:=InitVal;
  AKIP.CN1.WAVFORM.val:=InitVal;
  AKIP.CN2.WAVFORM.val:=InitVal;
  AKIP.CN3.WAVFORM.val:=InitVal;
  AKIP.CN4.WAVFORM.val:=InitVal;
  AKIP.TIM.DEL.val:=InitVal;
  AKIP.TIM.SCAL.val:=InitVal;
  AKIP.TRIG.MODE.val:=InitVal;
  AKIP.TRIG.RUN.val:=InitVal;
  AKIP.TRIG.STAT.val:=InitVal;
  AKIP.TRIG.STOP.val:=InitVal;
  AKIP.TRIG.TYP.val:=InitVal;
  AKIP.TRIG.EDGE.COUP.val:=InitVal;
  AKIP.TRIG.EDGE.HLDEV.val:=InitVal;
  AKIP.TRIG.EDGE.HLDT.val:=InitVal;
  AKIP.TRIG.EDGE.HOLD.val:=InitVal;
  AKIP.TRIG.EDGE.HST.val:=InitVal;
  AKIP.TRIG.EDGE.LEV.val:=InitVal;
  AKIP.TRIG.EDGE.NREJ.val:=InitVal;
  AKIP.TRIG.EDGE.SLOP.val:=InitVal;
  AKIP.TRIG.EDGE.SOUR.val:=InitVal;
  AKIP.WAV.DATA.val:=InitVal;
  AKIP.WAV.INT.val:=InitVal;
  AKIP.WAV.MAXP.val:=InitVal;
  AKIP.WAV.POIN.val:=InitVal;
  AKIP.WAV.SOUR.val:=InitVal;
  AKIP.WAV.STAR.val:=InitVal;
  AKIP.WAV.WIDT.val:=InitVal;
  AKIP.MODECALCDEV.val:=InitVal;
  AKIP.BASEDIR.val:=InitVal;
  AKIP.EXPDIR.val:=InitVal;
  AKIP.WAVESAVESTT.val:=InitVal;
  AKIP.OSCNAME.val:=InitVal;
 end;
 {
 Update DIM services
 }
 procedure DimUpdateState;
 begin
  if DIM_IsServerMode then begin
   if SysTimer_Pulse(10000)>0 then AkipFillTags(-MaxReal);
   if ShouldRefresh(AKIP.POLL.ENABLE.val,     GetStampOfTag(AKIP.POLL.ENABLE.tag,0))>0     then DIM_UpdateTag(AKIP.POLL.ENABLE.tag,'');
   if ShouldRefresh(AKIP.CLOCK.val,           GetStampOfTag(AKIP.CLOCK.tag,0))>0           then DIM_UpdateTag(AKIP.CLOCK.tag,'');
   if ShouldRefresh(AKIP.SERVID.val,          GetStampOfTag(AKIP.SERVID.tag,0))>0          then DIM_UpdateTag(AKIP.SERVID.tag,'');
   if ShouldRefresh(AKIP.POLL.RATE.val,       GetStampOfTag(AKIP.POLL.RATE.tag,0))>0       then DIM_UpdateTag(AKIP.POLL.RATE.tag,'');
   if ShouldRefresh(AKIP.ERROR.CNT.val,       GetStampOfTag(AKIP.ERROR.CNT.tag,0))>0       then DIM_UpdateTag(AKIP.ERROR.CNT.tag,'');
   if ShouldRefresh(AKIP.STATUS.val,          GetStampOfTag(AKIP.STATUS.tag,0))>0          then DIM_UpdateTag(AKIP.STATUS.tag,'');
   if ShouldRefresh(AKIP.OPC.val,             GetStampOfTag(AKIP.OPC.tag,0))>0             then DIM_UpdateTag(AKIP.OPC.tag,'');
   if ShouldRefresh(AKIP.AUT.val,             GetStampOfTag(AKIP.AUT.tag,0))>0             then DIM_UpdateTag(AKIP.AUT.tag,'');
   if ShouldRefresh(AKIP.IDENT.val,           GetStampOfTag(AKIP.IDENT.tag,0))>0           then DIM_UpdateTag(AKIP.IDENT.tag,'');
   if ShouldRefresh(AKIP.ACQ.MDEP.val,        GetStampOfTag(AKIP.ACQ.MDEP.tag,0))>0        then DIM_UpdateTag(AKIP.ACQ.MDEP.tag,'');
   if ShouldRefresh(AKIP.ACQ.POIN.val,        GetStampOfTag(AKIP.ACQ.POIN.tag,0))>0        then DIM_UpdateTag(AKIP.ACQ.POIN.tag,'');
   if ShouldRefresh(AKIP.ACQ.SEQ.val,         GetStampOfTag(AKIP.ACQ.SEQ.tag,0))>0         then DIM_UpdateTag(AKIP.ACQ.SEQ.tag,'');
   if ShouldRefresh(AKIP.ACQ.SMPLRT.val,      GetStampOfTag(AKIP.ACQ.SMPLRT.tag,0))>0      then DIM_UpdateTag(AKIP.ACQ.SMPLRT.tag,'');
   if ShouldRefresh(AKIP.ACQ.TYP.val,         GetStampOfTag(AKIP.ACQ.TYP.tag,0))>0         then DIM_UpdateTag(AKIP.ACQ.TYP.tag,'');
   if ShouldRefresh(AKIP.CN1.COUP.val,        GetStampOfTag(AKIP.CN1.COUP.tag,0))>0        then DIM_UpdateTag(AKIP.CN1.COUP.tag,'');
   if ShouldRefresh(AKIP.CN2.COUP.val,        GetStampOfTag(AKIP.CN2.COUP.tag,0))>0        then DIM_UpdateTag(AKIP.CN2.COUP.tag,'');
   if ShouldRefresh(AKIP.CN3.COUP.val,        GetStampOfTag(AKIP.CN3.COUP.tag,0))>0        then DIM_UpdateTag(AKIP.CN3.COUP.tag,'');
   if ShouldRefresh(AKIP.CN4.COUP.val,        GetStampOfTag(AKIP.CN4.COUP.tag,0))>0        then DIM_UpdateTag(AKIP.CN4.COUP.tag,'');
   if ShouldRefresh(AKIP.CN1.IMP.val,         GetStampOfTag(AKIP.CN1.IMP.tag,0))>0         then DIM_UpdateTag(AKIP.CN1.IMP.tag,'');
   if ShouldRefresh(AKIP.CN2.IMP.val,         GetStampOfTag(AKIP.CN2.IMP.tag,0))>0         then DIM_UpdateTag(AKIP.CN2.IMP.tag,'');
   if ShouldRefresh(AKIP.CN3.IMP.val,         GetStampOfTag(AKIP.CN3.IMP.tag,0))>0         then DIM_UpdateTag(AKIP.CN3.IMP.tag,'');
   if ShouldRefresh(AKIP.CN4.IMP.val,         GetStampOfTag(AKIP.CN4.IMP.tag,0))>0         then DIM_UpdateTag(AKIP.CN4.IMP.tag,'');
   if ShouldRefresh(AKIP.CN1.OFFS.val,        GetStampOfTag(AKIP.CN1.OFFS.tag,0))>0        then DIM_UpdateTag(AKIP.CN1.OFFS.tag,'');
   if ShouldRefresh(AKIP.CN2.OFFS.val,        GetStampOfTag(AKIP.CN2.OFFS.tag,0))>0        then DIM_UpdateTag(AKIP.CN2.OFFS.tag,'');
   if ShouldRefresh(AKIP.CN3.OFFS.val,        GetStampOfTag(AKIP.CN3.OFFS.tag,0))>0        then DIM_UpdateTag(AKIP.CN3.OFFS.tag,'');
   if ShouldRefresh(AKIP.CN4.OFFS.val,        GetStampOfTag(AKIP.CN4.OFFS.tag,0))>0        then DIM_UpdateTag(AKIP.CN4.OFFS.tag,'');
   if ShouldRefresh(AKIP.CN1.SCAL.val,        GetStampOfTag(AKIP.CN1.SCAL.tag,0))>0        then DIM_UpdateTag(AKIP.CN1.SCAL.tag,'');
   if ShouldRefresh(AKIP.CN2.SCAL.val,        GetStampOfTag(AKIP.CN2.SCAL.tag,0))>0        then DIM_UpdateTag(AKIP.CN2.SCAL.tag,'');
   if ShouldRefresh(AKIP.CN3.SCAL.val,        GetStampOfTag(AKIP.CN3.SCAL.tag,0))>0        then DIM_UpdateTag(AKIP.CN3.SCAL.tag,'');
   if ShouldRefresh(AKIP.CN4.SCAL.val,        GetStampOfTag(AKIP.CN4.SCAL.tag,0))>0        then DIM_UpdateTag(AKIP.CN4.SCAL.tag,'');
   if ShouldRefresh(AKIP.CN1.SWIT.val,        GetStampOfTag(AKIP.CN1.SWIT.tag,0))>0        then DIM_UpdateTag(AKIP.CN1.SWIT.tag,'');
   if ShouldRefresh(AKIP.CN2.SWIT.val,        GetStampOfTag(AKIP.CN2.SWIT.tag,0))>0        then DIM_UpdateTag(AKIP.CN2.SWIT.tag,'');
   if ShouldRefresh(AKIP.CN3.SWIT.val,        GetStampOfTag(AKIP.CN3.SWIT.tag,0))>0        then DIM_UpdateTag(AKIP.CN3.SWIT.tag,'');
   if ShouldRefresh(AKIP.CN4.SWIT.val,        GetStampOfTag(AKIP.CN4.SWIT.tag,0))>0        then DIM_UpdateTag(AKIP.CN4.SWIT.tag,'');
   if ShouldRefresh(AKIP.CN1.WAVFORM.val,     GetStampOfTag(AKIP.CN1.WAVFORM.tag,0))>0     then DIM_UpdateTag(AKIP.CN1.WAVFORM.tag,'');
   if ShouldRefresh(AKIP.CN2.WAVFORM.val,     GetStampOfTag(AKIP.CN2.WAVFORM.tag,0))>0     then DIM_UpdateTag(AKIP.CN2.WAVFORM.tag,'');
   if ShouldRefresh(AKIP.CN3.WAVFORM.val,     GetStampOfTag(AKIP.CN3.WAVFORM.tag,0))>0     then DIM_UpdateTag(AKIP.CN3.WAVFORM.tag,'');
   if ShouldRefresh(AKIP.CN4.WAVFORM.val,     GetStampOfTag(AKIP.CN4.WAVFORM.tag,0))>0     then DIM_UpdateTag(AKIP.CN4.WAVFORM.tag,'');
   if ShouldRefresh(AKIP.TIM.DEL.val,         GetStampOfTag(AKIP.TIM.DEL.tag,0))>0         then DIM_UpdateTag(AKIP.TIM.DEL.tag,'');
   if ShouldRefresh(AKIP.TIM.SCAL.val,        GetStampOfTag(AKIP.TIM.SCAL.tag,0))>0        then DIM_UpdateTag(AKIP.TIM.SCAL.tag,'');
   if ShouldRefresh(AKIP.TRIG.MODE.val,       GetStampOfTag(AKIP.TRIG.MODE.tag,0))>0       then DIM_UpdateTag(AKIP.TRIG.MODE.tag,'');
   if ShouldRefresh(AKIP.TRIG.RUN.val,        GetStampOfTag(AKIP.TRIG.RUN.tag,0))>0        then DIM_UpdateTag(AKIP.TRIG.RUN.tag,'');
   if ShouldRefresh(AKIP.TRIG.STAT.val,       GetStampOfTag(AKIP.TRIG.STAT.tag,0))>0       then DIM_UpdateTag(AKIP.TRIG.STAT.tag,'');
   if ShouldRefresh(AKIP.TRIG.STOP.val,       GetStampOfTag(AKIP.TRIG.STOP.tag,0))>0       then DIM_UpdateTag(AKIP.TRIG.STOP.tag,'');
   if ShouldRefresh(AKIP.TRIG.TYP.val,        GetStampOfTag(AKIP.TRIG.TYP.tag,0))>0        then DIM_UpdateTag(AKIP.TRIG.TYP.tag,'');
   if ShouldRefresh(AKIP.TRIG.EDGE.COUP.val,  GetStampOfTag(AKIP.TRIG.EDGE.COUP.tag,0))>0  then DIM_UpdateTag(AKIP.TRIG.EDGE.COUP.tag,'');
   if ShouldRefresh(AKIP.TRIG.EDGE.HLDEV.val, GetStampOfTag(AKIP.TRIG.EDGE.HLDEV.tag,0))>0 then DIM_UpdateTag(AKIP.TRIG.EDGE.HLDEV.tag,'');
   if ShouldRefresh(AKIP.TRIG.EDGE.HLDT.val,  GetStampOfTag(AKIP.TRIG.EDGE.HLDT.tag,0))>0  then DIM_UpdateTag(AKIP.TRIG.EDGE.HLDT.tag,'');
   if ShouldRefresh(AKIP.TRIG.EDGE.HOLD.val,  GetStampOfTag(AKIP.TRIG.EDGE.HOLD.tag,0))>0  then DIM_UpdateTag(AKIP.TRIG.EDGE.HOLD.tag,'');
   if ShouldRefresh(AKIP.TRIG.EDGE.HST.val,   GetStampOfTag(AKIP.TRIG.EDGE.HST.tag,0))>0   then DIM_UpdateTag(AKIP.TRIG.EDGE.HST.tag,'');
   if ShouldRefresh(AKIP.TRIG.EDGE.LEV.val,   GetStampOfTag(AKIP.TRIG.EDGE.LEV.tag,0))>0   then DIM_UpdateTag(AKIP.TRIG.EDGE.LEV.tag,'');
   if ShouldRefresh(AKIP.TRIG.EDGE.NREJ.val,  GetStampOfTag(AKIP.TRIG.EDGE.NREJ.tag,0))>0  then DIM_UpdateTag(AKIP.TRIG.EDGE.NREJ.tag,'');
   if ShouldRefresh(AKIP.TRIG.EDGE.SLOP.val,  GetStampOfTag(AKIP.TRIG.EDGE.SLOP.tag,0))>0  then DIM_UpdateTag(AKIP.TRIG.EDGE.SLOP.tag,'');
   if ShouldRefresh(AKIP.TRIG.EDGE.SOUR.val,  GetStampOfTag(AKIP.TRIG.EDGE.SOUR.tag,0))>0  then DIM_UpdateTag(AKIP.TRIG.EDGE.SOUR.tag,'');
   if ShouldRefresh(AKIP.WAV.DATA.val,        GetStampOfTag(AKIP.WAV.DATA.tag,0))>0        then DIM_UpdateTag(AKIP.WAV.DATA.tag,'');
   if ShouldRefresh(AKIP.WAV.INT.val,         GetStampOfTag(AKIP.WAV.INT.tag,0))>0         then DIM_UpdateTag(AKIP.WAV.INT.tag,'');
   if ShouldRefresh(AKIP.WAV.MAXP.val,        GetStampOfTag(AKIP.WAV.MAXP.tag,0))>0        then DIM_UpdateTag(AKIP.WAV.MAXP.tag,'');
   if ShouldRefresh(AKIP.WAV.POIN.val,        GetStampOfTag(AKIP.WAV.POIN.tag,0))>0        then DIM_UpdateTag(AKIP.WAV.POIN.tag,'');
   if ShouldRefresh(AKIP.WAV.SOUR.val,        GetStampOfTag(AKIP.WAV.SOUR.tag,0))>0        then DIM_UpdateTag(AKIP.WAV.SOUR.tag,'');
   if ShouldRefresh(AKIP.WAV.STAR.val,        GetStampOfTag(AKIP.WAV.STAR.tag,0))>0        then DIM_UpdateTag(AKIP.WAV.STAR.tag,'');
   if ShouldRefresh(AKIP.WAV.WIDT.val,        GetStampOfTag(AKIP.WAV.WIDT.tag,0))>0        then DIM_UpdateTag(AKIP.WAV.WIDT.tag,'');
   if ShouldRefresh(AKIP.MODECALCDEV.val,     GetStampOfTag(AKIP.MODECALCDEV.tag,0))>0     then DIM_UpdateTag(AKIP.MODECALCDEV.tag,'');
   if ShouldRefresh(AKIP.BASEDIR.val,         GetStampOfTag(AKIP.BASEDIR.tag,0))>0         then DIM_UpdateTag(AKIP.BASEDIR.tag,'');
   if ShouldRefresh(AKIP.EXPDIR.val,          GetStampOfTag(AKIP.EXPDIR.tag,0))>0          then DIM_UpdateTag(AKIP.EXPDIR.tag,'');
   if ShouldRefresh(AKIP.WAVESAVESTT.val,     GetStampOfTag(AKIP.WAVESAVESTT.tag,0))>0     then DIM_UpdateTag(AKIP.WAVESAVESTT.tag,'');
   if ShouldRefresh(AKIP.OSCNAME.val,         GetStampOfTag(AKIP.OSCNAME.tag,0))>0         then DIM_UpdateTag(AKIP.OSCNAME.tag,'');
  end;
 end;
 {
 Color update edge trig tag
 }
 procedure AkipEdgeTrigTagColorUpdate;
 begin
  if not (sGetTag(AKIP.TRIG.TYP.tag)='EDGE') then 
   begin 
    bNul(SetTagColor(AKIP.TRIG.EDGE.COUP.tag,clSilver));
    bNul(SetTagColor(AKIP.TRIG.EDGE.HLDEV.tag,clSilver));
    bNul(SetTagColor(AKIP.TRIG.EDGE.HLDT.tag,clSilver));
    bNul(SetTagColor(AKIP.TRIG.EDGE.HOLD.tag,clSilver));
    bNul(SetTagColor(AKIP.TRIG.EDGE.HST.tag,clSilver));
    bNul(SetTagColor(AKIP.TRIG.EDGE.LEV.tag,clSilver));
    bNul(SetTagColor(AKIP.TRIG.EDGE.SLOP.tag,clSilver));
    bNul(SetTagColor(AKIP.TRIG.EDGE.SOUR.tag,clSilver));
   end else begin
    bNul(SetTagColor(AKIP.TRIG.EDGE.COUP.tag,clWhite));
    bNul(SetTagColor(AKIP.TRIG.EDGE.HLDEV.tag,clWhite));
    bNul(SetTagColor(AKIP.TRIG.EDGE.HLDT.tag,clWhite));
    bNul(SetTagColor(AKIP.TRIG.EDGE.HOLD.tag,clWhite));
    bNul(SetTagColor(AKIP.TRIG.EDGE.HST.tag,clWhite));
    bNul(SetTagColor(AKIP.TRIG.EDGE.LEV.tag,clWhite));
    bNul(SetTagColor(AKIP.TRIG.EDGE.SLOP.tag,clWhite));
    bNul(SetTagColor(AKIP.TRIG.EDGE.SOUR.tag,clWhite));
   end;
 end;
 {
 Warning tooltip notifier
 }
 procedure ShowWarning(message:String);
 begin
  ShowTooltip('text "'+message+'" delay 15000 preset stdWarning');
 end;
 {
 Prefix for DIM @remote commands.
 }
 function DimRemote:String;
 var CanRemote:Boolean;
 begin
  CanRemote:=DIM_IsServerMode or DIM_IsClientMode;
  if (DIM_GuiClickTag=0) then CanRemote:=false;
  if (devDimSrv=0) then CanRemote:=false;
  if CanRemote
  then DimRemote:='@remote '
  else DimRemote:='';
 end;
  {
 Check switch status for channels
 }
 function IsChannelOn(var CHAN:TChanRec):Boolean;
 begin
  IsChannelOn:=IsSameText(str(iGetTag(CHAN.SWIT.tag)),'1');
 end;
 {
 Check trigger EDGE type
 }
 function IsEdgeTrigger:Boolean;
 begin
  IsEdgeTrigger:=IsSameText(sGetTag(AKIP.TRIG.TYP.tag),'EDGE');
 end;
 {
 Handle message @AssignTag argument
 }
 procedure AkipOnAssignTag(s:String);
 var tag:Integer; w1,w2:String;
  procedure Cleanup;
  begin
   w1:=''; w2:='';
  end;
 begin
  Cleanup;
  if (s<>'') then begin
   w1:=ExtractWord(1,s);
   tag:=FindTag(w1);
   if (tag<>0) then begin
    w2:=ExtractWord(2,s);
    if tag=AKIP.POLL.ENABLE.tag    then UpdateTag(tag,w2,0,1) else
    if tag=AKIP.CN1.SWIT.tag       then DevSendCmdLocal(DimRemote+'@Setting CHAN1:SWIT '+w2) else
    if tag=AKIP.CN2.SWIT.tag       then DevSendCmdLocal(DimRemote+'@Setting CHAN2:SWIT '+w2) else
    if tag=AKIP.CN3.SWIT.tag       then DevSendCmdLocal(DimRemote+'@Setting CHAN3:SWIT '+w2) else
    if tag=AKIP.CN4.SWIT.tag       then DevSendCmdLocal(DimRemote+'@Setting CHAN4:SWIT '+w2) else
    if tag=AKIP.WAV.DATA.tag       then UpdateTag(tag,w2,0,1);
    end;
   end;
  Cleanup;
 end;
 {
 Handle message @DimUpdateTag argument
 }
 procedure AkipOnDimUpdateTag(s:String);
 var tag,typ:Integer; x,y:Real;
 begin
  if (s<>'') then begin
   if DIM_IsClientMode and not DIM_IsServerMode then begin
    tag:=FindTag(ExtractWord(1,s));
    if (tag<>0) then begin
     typ:=TypeTag(tag);
     if (typ=1) then y:=iGetTag(tag) else
     if (typ=2) then y:=rGetTag(tag) else y:=_Nan;
     x:=time;
     if not IsNan(y) then begin
      if tag=AKIP.ACQ.POIN.tag then UpdateAo(ao_ACQ_POIN,x,y);
      if tag=AKIP.ACQ.SMPLRT.tag then UpdateAo(ao_ACQ_SMPLRT,x,y);
      if tag=AKIP.CN1.SCAL.tag then UpdateAo(ao_CN1_SCAL,x,y);
      if tag=AKIP.CN2.SCAL.tag then UpdateAo(ao_CN2_SCAL,x,y);
      if tag=AKIP.CN3.SCAL.tag then UpdateAo(ao_CN3_SCAL,x,y);
      if tag=AKIP.CN4.SCAL.tag then UpdateAo(ao_CN4_SCAL,x,y);
      if tag=AKIP.ERROR.CNT.tag then UpdateDo(do_ERROR_CNT,x,y);
      if tag=AKIP.POLL.RATE.tag then UpdateDo(do_POLL_RATE,x,y);
      if tag=AKIP.TIM.DEL.tag then UpdateAo(ao_TIM_DEL,x,y);
      if tag=AKIP.TIM.SCAL.tag then UpdateAo(ao_TIM_SCAL,x,y);
      if tag=AKIP.TRIG.EDGE.HLDEV.tag then UpdateAo(ao_TRIG_EDGE_HLDEV,x,y);
      if tag=AKIP.TRIG.EDGE.HLDT.tag then UpdateAo(ao_TRIG_EDGE_HLDT,x,y);
      if tag=AKIP.TRIG.EDGE.LEV.tag then UpdateAo(ao_TRIG_EDGE_LEV,x,y);
      if tag=AKIP.WAV.INT.tag then UpdateAo(ao_WAV_INT,x,y);
      if tag=AKIP.WAV.MAXP.tag then UpdateAo(ao_WAV_MAXP,x,y);
      if tag=AKIP.WAV.POIN.tag then UpdateAo(ao_WAV_POIN,x,y);
      if tag=AKIP.WAV.STAR.tag then UpdateAo(ao_WAV_STAR,x,y);
     end;
    end;
   end;
  end;
 end;
 {
 Find console commands
 }
 function AkipCmdFind(id:String):Integer;
 var i,n:Integer;
 begin
  n:=0;
  if (Length(id)>0) then
  if UseCmdHash and (AKIP.CmdHash<>0) then begin
   n:=HashList_GetLink(AKIP.CmdHash,id);
  end else begin
   for i:= 1 to MaxCmdNum do if n=0 then
   if IsSameText(id,AKIP.Cmd.Acronym[i]) then n:=i;
  end;
  AkipCmdFind:=n;
 end;
 {
 Command cycle routines
 }
 function IsValidCmdNum(n:Integer):Boolean;
 begin
  IsValidCmdNum:=(n>=1) and (n<=MaxCmdNum);
 end;
 function IsQueryCmd(cmd:String):Boolean;
 begin
  IsQueryCmd:=(Pos('?',cmd)>0);
 end;
 function IsQueryCmdNum(n:Integer):Boolean;
 begin
  if IsValidCmdNum(n) then IsQueryCmdNum:=IsQueryCmd(AKIP.Cmd.Acronym[n])
  else IsQueryCmdNum:=false;
 end;
 procedure EnableCmdNum(n:Integer;Enabled:Boolean);
 begin
  if IsValidCmdNum(n) then AKIP.Cmd.Enabled[n]:=Enabled;
 end;
 {
 Check polling enabled
 }
 function IsPollingEnabled:Boolean;
 begin
  IsPollingEnabled:=iGetTag(AKIP.POLL.ENABLE.tag)>0;
 end;
 {
 Cleanup cmd
 }
 procedure AkipClearCmd;
 var i:Integer;
 begin
  for i:=1 to MaxCmdNum do begin
   AKIP.Cmd.Acronym[i]:='';
   AKIP.Cmd.Enabled[i]:=False;
   AKIP.Cmd.OpData[i]:='';
   AKIP.Cmd.OpBuff[i]:='';
   AKIP.Cmd.AoNum[i]:=-1;
  end;
 end;
 {
 Initialization console commands
 }
 procedure AkipInitCmd;
  procedure AddHash(n:Integer; key:String);
  begin
   key:=Trim(key);
   if Length(key)>0 then
   if IsValidCmdNum(n) then
   if AKIP.CmdHash<>0 then
   bNul(HashList_SetLink(AKIP.CmdHash,key,n));
  end;
  procedure Add(n,AoNum,Enabled:Integer; Acronym:String);
  begin
   if IsValidCmdNum(n) then begin
    AKIP.Cmd.Acronym[n]:=Trim(Acronym);
    AKIP.Cmd.Enabled[n]:=Enabled>0;
    AKIP.Cmd.AoNum[n]:=AoNum;
    AddHash(n,AKIP.Cmd.Acronym[n]);
   end;
  end;
 begin
  AKIP.Cmd.Num:=1;
  // Command               AoNum               Enabled  Acronym
  Add(cm_IDEN,              -1,                 1,      '*IDN?           ');
  Add(cm_OPC,               -1,                 0,      '*OPC?           ');
  Add(cm_AUT,               -1,                 0,      'AUT             ');
  Add(cm_ACQ_MDEP,          -1,                 0,      'ACQ:MDEP        ');
  Add(cm_ACQ_MDEP_Q,        -1,                 1,      ':ACQ:MDEP?      ');
  Add(cm_ACQ_POIN_Q,        ao_ACQ_POIN,        1,      'ACQ:POIN?       ');
  Add(cm_ACQ_SEQ,           -1,                 0,      'ACQ:SEQ         ');
  Add(cm_ACQ_SEQ_Q,         -1,                 1,      'ACQ:SEQ?        ');
  Add(cm_ACQ_SMPLRT_Q,      ao_ACQ_SMPLRT,      1,      'ACQ:SRAT?       ');
  Add(cm_ACQ_TYPE,          -1,                 0,      'ACQ:TYPE        ');
  Add(cm_ACQ_TYPE_Q,        -1,                 1,      'ACQ:TYPE?       ');
  Add(cm_CN1_COUP,          -1,                 0,      'CHAN1:COUP      ');
  Add(cm_CN2_COUP,          -1,                 0,      'CHAN2:COUP      ');
  Add(cm_CN3_COUP,          -1,                 0,      'CHAN3:COUP      ');
  Add(cm_CN4_COUP,          -1,                 0,      'CHAN4:COUP      ');
  Add(cm_CN1_COUP_Q,        -1,                 1,      'CHAN1:COUP?     ');
  Add(cm_CN2_COUP_Q,        -1,                 1,      'CHAN2:COUP?     ');
  Add(cm_CN3_COUP_Q,        -1,                 1,      'CHAN3:COUP?     ');
  Add(cm_CN4_COUP_Q,        -1,                 1,      'CHAN4:COUP?     ');
  Add(cm_CN1_IMP,           -1,                 0,      'CHAN1:IMP       ');
  Add(cm_CN2_IMP,           -1,                 0,      'CHAN2:IMP       ');
  Add(cm_CN3_IMP,           -1,                 0,      'CHAN3:IMP       ');
  Add(cm_CN4_IMP,           -1,                 0,      'CHAN4:IMP       ');
  Add(cm_CN1_IMP_Q,         -1,                 1,      'CHAN1:IMP?      ');
  Add(cm_CN2_IMP_Q,         -1,                 1,      'CHAN2:IMP?      ');
  Add(cm_CN3_IMP_Q,         -1,                 1,      'CHAN3:IMP?      ');
  Add(cm_CN4_IMP_Q,         -1,                 1,      'CHAN4:IMP?      ');
  Add(cm_CN1_OFFS,          -1,                 0,      'CHAN1:OFFS      ');
  Add(cm_CN2_OFFS,          -1,                 0,      'CHAN2:OFFS      ');
  Add(cm_CN3_OFFS,          -1,                 0,      'CHAN3:OFFS      ');
  Add(cm_CN4_OFFS,          -1,                 0,      'CHAN4:OFFS      ');
  Add(cm_CN1_OFFS_Q,        -1,                 1,      'CHAN1:OFFS?     ');
  Add(cm_CN2_OFFS_Q,        -1,                 1,      'CHAN2:OFFS?     ');
  Add(cm_CN3_OFFS_Q,        -1,                 1,      'CHAN3:OFFS?     ');
  Add(cm_CN4_OFFS_Q,        -1,                 1,      'CHAN4:OFFS?     ');
  Add(cm_CN1_SCAL,          -1,                 0,      'CHAN1:SCAL      ');
  Add(cm_CN2_SCAL,          -1,                 0,      'CHAN2:SCAL      ');
  Add(cm_CN3_SCAL,          -1,                 0,      'CHAN3:SCAL      ');
  Add(cm_CN4_SCAL,          -1,                 0,      'CHAN4:SCAL      ');
  Add(cm_CN1_SCAL_Q,        ao_CN1_SCAL,        1,      'CHAN1:SCAL?     ');
  Add(cm_CN2_SCAL_Q,        ao_CN2_SCAL,        1,      'CHAN2:SCAL?     ');
  Add(cm_CN3_SCAL_Q,        ao_CN3_SCAL,        1,      'CHAN3:SCAL?     ');
  Add(cm_CN4_SCAL_Q,        ao_CN4_SCAL,        1,      'CHAN4:SCAL?     ');
  Add(cm_CN1_SWIT,          -1,                 0,      'CHAN1:SWIT      ');
  Add(cm_CN2_SWIT,          -1,                 0,      'CHAN2:SWIT      ');
  Add(cm_CN3_SWIT,          -1,                 0,      'CHAN3:SWIT      ');
  Add(cm_CN4_SWIT,          -1,                 0,      'CHAN4:SWIT      ');
  Add(cm_CN1_SWIT_Q,        -1,                 1,      'CHAN1:SWIT?     ');
  Add(cm_CN2_SWIT_Q,        -1,                 1,      'CHAN2:SWIT?     ');
  Add(cm_CN3_SWIT_Q,        -1,                 1,      'CHAN3:SWIT?     ');
  Add(cm_CN4_SWIT_Q,        -1,                 1,      'CHAN4:SWIT?     ');
  Add(cm_TIM_DEL,           -1,                 0,      'TIM:DEL         ');
  Add(cm_TIM_DEL_Q,         ao_TIM_DEL,         1,      'TIM:DEL?        ');
  Add(cm_TIM_SCAL,          -1,                 0,      'TIM:SCAL        ');
  Add(cm_TIM_SCAL_Q,        ao_TIM_SCAL,        1,      'TIM:SCAL?       ');
  Add(cm_TRIG_MODE,         -1,                 0,      'TRIG:MODE       ');
  Add(cm_TRIG_MODE_Q,       -1,                 1,      'TRIG:MODE?      ');
  Add(cm_TRIG_RUN,          -1,                 0,      'TRIG:RUN        ');
  Add(cm_TRIG_STAT_Q,       -1,                 1,      'TRIG:STAT?      ');
  Add(cm_TRIG_STOP,         -1,                 0,      'TRIG:STOP       ');
  Add(cm_TRIG_TYPE,         -1,                 0,      'TRIG:TYPE       ');
  Add(cm_TRIG_TYPE_Q,       -1,                 1,      'TRIG:TYPE?      ');
  Add(cm_TRIG_EDGE_COUP,    -1,                 0,      'TRIG:EDGE:COUP  ');
  Add(cm_TRIG_EDGE_COUP_Q,  -1,                 1,      'TRIG:EDGE:COUP? ');
  Add(cm_TRIG_EDGE_HLDEV,   -1,                 0,      'TRIG:EDGE:HLDEV ');
  Add(cm_TRIG_EDGE_HLDEV_Q, ao_TRIG_EDGE_HLDEV, 1,      'TRIG:EDGE:HLDEV?');
  Add(cm_TRIG_EDGE_HLDT,    -1,                 0,      'TRIG:EDGE:HLDT  ');
  Add(cm_TRIG_EDGE_HLDT_Q,  ao_TRIG_EDGE_HLDT,  1,      'TRIG:EDGE:HLDT? ');
  Add(cm_TRIG_EDGE_HOLD,    -1,                 0,      'TRIG:EDGE:HOLD  ');
  Add(cm_TRIG_EDGE_HOLD_Q,  -1,                 1,      'TRIG:EDGE:HOLD? ');
  Add(cm_TRIG_EDGE_HST,     -1,                 0,      'TRIG:EDGE:HST   ');
  Add(cm_TRIG_EDGE_HST_Q,   -1,                 1,      'TRIG:EDGE:HST?  ');
  Add(cm_TRIG_EDGE_LEV,     -1,                 0,      'TRIG:EDGE:LEV   ');
  Add(cm_TRIG_EDGE_LEV_Q,   ao_TRIG_EDGE_LEV,   1,      'TRIG:EDGE:LEV?  ');
  Add(cm_TRIG_EDGE_NREJ,    -1,                 0,      'TRIG:EDGE:NREJ  ');
  Add(cm_TRIG_EDGE_NREJ_Q,  -1,                 1,      'TRIG:EDGE:NREJ? ');
  Add(cm_TRIG_EDGE_SLOP,    -1,                 0,      'TRIG:EDGE:SLOP  ');
  Add(cm_TRIG_EDGE_SLOP_Q,  -1,                 1,      'TRIG:EDGE:SLOP? ');
  Add(cm_TRIG_EDGE_SOUR,    -1,                 0,      'TRIG:EDGE:SOUR  ');
  Add(cm_TRIG_EDGE_SOUR_Q,  -1,                 1,      'TRIG:EDGE:SOUR? ');
  Add(cm_WAV_DATA_Q,        -1,                 0,      ':WAV:DATA?      ');
  Add(cm_WAV_INT,           -1,                 0,      'WAV:INT         ');
  Add(cm_WAV_INT_Q,         ao_WAV_INT,         1,      'WAV:INT?        ');
  Add(cm_WAV_MAXP_Q,        ao_WAV_MAXP,        1,      ':WAV:MAXPoint?  ');
  Add(cm_WAV_POIN,          -1,                 0,      'WAV:POIN        ');
  Add(cm_WAV_POIN_Q,        ao_WAV_POIN,        1,      'WAV:POIN?       ');
  Add(cm_WAV_SOUR,          -1,                 0,      'WAV:SOUR        ');
  Add(cm_WAV_SOUR_Q,        -1,                 1,      'WAV:SOUR?       ');
  Add(cm_WAV_STAR,          -1,                 0,      'WAV:STAR        ');
  Add(cm_WAV_STAR_Q,        ao_WAV_STAR,        1,      'WAV:STAR?       ');
  Add(cm_WAV_WIDT,          -1,                 0,      'WAV:WIDT        ');
  Add(cm_WAV_WIDT_Q,        -1,                 1,      'WAV:WIDT?       ');
 end;
 {
 Print console commands table
 }
 procedure PrintCmdTable;
 var n:Integer;
 begin
  Success('Таблица команд');
  Success(StrFmt('%-3s ','Cm')+StrFmt('%-2s ','Ao')+StrFmt('%-2s ','En')+StrFmt('%-20.15s ','Acro'));
  for n:=1 to MaxCmdNum do
  Success(StrFmt('%-3d ',n)+StrFmt('%-2d',AKIP.Cmd.AoNum[n])+StrFmt('%-2d ',Ord(AKIP.Cmd.Enabled[n]))+StrFmt('%-20.15s ',AKIP.Cmd.Acronym[n]));
 end;
 {
 Simulator
 }
 procedure AkipSim(Req:String);
 var cmd,ans,w1,w2:String;
  procedure Cleanup;
  begin
   cmd:=''; ans:=''; w1:=''; w2:='';
  end;
 begin
  Cleanup;
  if Length(Req)>0 then begin
   ViewImp('PipeSim < '+Req);
   if IsQueryCmd(Req) then begin
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_IDEN])              then ans:=AKIP.SIM.IDENT                else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_OPC])               then ans:=Str(AKIP.SIM.OPC)             else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_ACQ_MDEP_Q])        then ans:=AKIP.SIM.ACQ_MDEP             else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_ACQ_POIN_Q])        then ans:=Str(AKIP.SIM.ACQ_POIN)        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_ACQ_SMPLRT_Q])      then ans:=Str(AKIP.SIM.ACQ_SMPLRT)      else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_ACQ_SEQ_Q])         then ans:=AKIP.SIM.ACQ_SEQ              else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_ACQ_TYPE_Q])        then ans:=AKIP.SIM.ACQ_TYPE             else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN1_COUP_Q])        then ans:=AKIP.SIM.CN1_COUP             else 
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN1_IMP_Q])         then ans:=AKIP.SIM.CN1_IMP              else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN1_OFFS_Q])        then ans:=Str(AKIP.SIM.CN1_OFFS)        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN1_SCAL_Q])        then ans:=Str(AKIP.SIM.CN1_SCAL)        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN2_COUP_Q])        then ans:=AKIP.SIM.CN2_COUP             else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN2_IMP_Q])         then ans:=AKIP.SIM.CN2_IMP              else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN2_OFFS_Q])        then ans:=Str(AKIP.SIM.CN2_OFFS)        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN2_SCAL_Q])        then ans:=Str(AKIP.SIM.CN2_SCAL)        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN3_COUP_Q])        then ans:=AKIP.SIM.CN3_COUP             else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN3_IMP_Q])         then ans:=AKIP.SIM.CN3_IMP              else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN3_OFFS_Q])        then ans:=Str(AKIP.SIM.CN3_OFFS)        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN3_SCAL_Q])        then ans:=Str(AKIP.SIM.CN3_SCAL)        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN4_COUP_Q])        then ans:=AKIP.SIM.CN4_COUP             else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN4_IMP_Q])         then ans:=AKIP.SIM.CN4_IMP              else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN4_OFFS_Q])        then ans:=Str(AKIP.SIM.CN4_OFFS)        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN4_SCAL_Q])        then ans:=Str(AKIP.SIM.CN4_SCAL)        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN1_SWIT_Q])        then ans:=AKIP.SIM.CN1_SWIT             else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN2_SWIT_Q])        then ans:=AKIP.SIM.CN2_SWIT             else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN3_SWIT_Q])        then ans:=AKIP.SIM.CN3_SWIT             else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_CN4_SWIT_Q])        then ans:=AKIP.SIM.CN4_SWIT             else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TIM_DEL_Q])         then ans:=Str(AKIP.SIM.TIM_DEL)         else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TIM_SCAL_Q])        then ans:=Str(AKIP.SIM.TIM_SCAL)        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TRIG_MODE_Q])       then ans:=AKIP.SIM.TRIG_MODE            else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TRIG_TYPE_Q])       then ans:=AKIP.SIM.TRIG_TYPE            else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TRIG_STAT_Q])       then begin
     if IsSameText(sGetTag(AKIP.TRIG.MODE.tag),'Auto') then ans:='Roll';
     if IsSameText(sGetTag(AKIP.TRIG.MODE.tag),'Stop') then ans:='Stop';
     if IsSameText(sGetTag(AKIP.TRIG.MODE.tag),'Sing') then ans:='Ready';
    end else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TRIG_EDGE_COUP_Q])  then ans:=AKIP.SIM.TRIG_EDGE_COUP       else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TRIG_EDGE_HLDEV_Q]) then ans:=Str(AKIP.SIM.TRIG_EDGE_HLDEV) else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TRIG_EDGE_HLDT_Q])  then ans:=Str(AKIP.SIM.TRIG_EDGE_HLDT)  else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TRIG_EDGE_HOLD_Q])  then ans:=AKIP.SIM.TRIG_EDGE_HOLD       else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TRIG_EDGE_HST_Q])   then ans:=AKIP.SIM.TRIG_EDGE_HST        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TRIG_EDGE_LEV_Q])   then ans:=Str(AKIP.SIM.TRIG_EDGE_LEV)   else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TRIG_EDGE_NREJ_Q])  then ans:=AKIP.SIM.TRIG_EDGE_NREJ       else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TRIG_EDGE_SLOP_Q])  then ans:=AKIP.SIM.TRIG_EDGE_SLOP       else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_TRIG_EDGE_SOUR_Q])  then ans:=AKIP.SIM.TRIG_EDGE_SOUR       else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_WAV_SOUR_Q])        then ans:=AKIP.SIM.WAV_SOUR             else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_WAV_STAR_Q])        then ans:=Str(AKIP.SIM.WAV_STAR)        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_WAV_INT_Q])         then ans:=Str(AKIP.SIM.WAV_INT)         else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_WAV_POIN_Q])        then ans:=Str(AKIP.SIM.WAV_POIN)        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_WAV_MAXP_Q])        then ans:=Str(AKIP.SIM.WAV_MAXP)        else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_WAV_WIDT_Q])        then ans:=AKIP.SIM.WAV_WIDT             else
    if IsSameText(Req,AKIP.Cmd.Acronym[cm_WAV_DATA_Q])        then ans:=AKIP.SIM.WAV_DATA;
    if Length(ans)>0 then begin
     if (pipe_send(AKIP.Pipe.PipeSIM,ans+EOL))>0
     then ViewExp('PipeSim > '+ans)
     else Trouble('Could not send'+Trim(ans));
    end;
   end else begin
    w1:=ExtractWord(1,Req);
    w2:=ExtractWord(2,Req);
    if IsSameText(w1,AKIP.CMD.Acronym[cm_AUT])             then AKIP.SIM.AUT:=Val(w2)             else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_ACQ_MDEP])        then AKIP.SIM.ACQ_MDEP:=w2             else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_ACQ_SEQ])         then AKIP.SIM.ACQ_SEQ:=w2              else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_ACQ_TYPE])        then AKIP.SIM.ACQ_TYPE:=w2             else
    if IsSameText(w1,AKIP.Cmd.Acronym[cm_CN1_COUP])        then AKIP.SIM.CN1_COUP:=w2             else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN2_COUP])        then AKIP.SIM.CN2_COUP:=w2             else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN3_COUP])        then AKIP.SIM.CN3_COUP:=w2             else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN4_COUP])        then AKIP.SIM.CN4_COUP:=w2             else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN1_IMP])         then AKIP.SIM.CN1_IMP:=w2              else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN2_IMP])         then AKIP.SIM.CN2_IMP:=w2              else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN3_IMP])         then AKIP.SIM.CN3_IMP:=w2              else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN4_IMP])         then AKIP.SIM.CN4_IMP:=w2              else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN1_OFFS])        then AKIP.SIM.CN1_OFFS:=rVal(w2)       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN2_OFFS])        then AKIP.SIM.CN2_OFFS:=rVal(w2)       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN3_OFFS])        then AKIP.SIM.CN3_OFFS:=rVal(w2)       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN4_OFFS])        then AKIP.SIM.CN4_OFFS:=rVal(w2)       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN1_SCAL])        then AKIP.SIM.CN1_SCAL:=rVal(w2)       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN2_SCAL])        then AKIP.SIM.CN2_SCAL:=rVal(w2)       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN3_SCAL])        then AKIP.SIM.CN3_SCAL:=rVal(w2)       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN4_SCAL])        then AKIP.SIM.CN4_SCAL:=rVal(w2)       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN1_SWIT])        then AKIP.SIM.CN1_SWIT:=w2             else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN2_SWIT])        then AKIP.SIM.CN2_SWIT:=w2             else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN3_SWIT])        then AKIP.SIM.CN3_SWIT:=w2             else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_CN4_SWIT])        then AKIP.SIM.CN4_SWIT:=w2             else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TIM_DEL])         then AKIP.SIM.TIM_DEL:=rVal(w2)        else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TIM_SCAL])        then AKIP.SIM.TIM_SCAL:=rVal(w2)       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TRIG_MODE])       then AKIP.SIM.TRIG_MODE:=w2            else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TRIG_RUN])        then AKIP.SIM.TRIG_RUN:=val(w2)        else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TRIG_STOP])       then AKIP.SIM.TRIG_STOP:=Val(w2)       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TRIG_TYPE])       then AKIP.SIM.TRIG_TYPE:=w2            else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TRIG_EDGE_COUP])  then AKIP.SIM.TRIG_EDGE_COUP:=w2       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TRIG_EDGE_HLDEV]) then AKIP.SIM.TRIG_EDGE_HLDEV:=Val(w2) else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TRIG_EDGE_HLDT])  then AKIP.SIM.TRIG_EDGE_HLDT:=rVal(w2) else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TRIG_EDGE_HOLD])  then AKIP.SIM.TRIG_EDGE_HOLD:=w2       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TRIG_EDGE_HST])   then AKIP.SIM.TRIG_EDGE_HST:=w2        else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TRIG_EDGE_LEV])   then AKIP.SIM.TRIG_EDGE_LEV:=rVal( w2) else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TRIG_EDGE_NREJ])  then AKIP.SIM.TRIG_EDGE_NREJ:=w2       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TRIG_EDGE_SLOP])  then AKIP.SIM.TRIG_EDGE_SLOP:=w2       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_TRIG_EDGE_SOUR])  then AKIP.SIM.TRIG_EDGE_SOUR:=w2       else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_WAV_SOUR])        then AKIP.SIM.WAV_SOUR:=w2             else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_WAV_STAR])        then AKIP.SIM.WAV_STAR:=Val(w2)        else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_WAV_INT])         then AKIP.SIM.WAV_INT:=Val(w2)         else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_WAV_POIN])        then AKIP.SIM.WAV_POIN:=Val(w2)        else
    if IsSameText(w1,AKIP.CMD.Acronym[cm_WAV_WIDT])        then AKIP.SIM.WAV_WIDT:=w2;
   end;
  end;
  AKIP.Pipe.Req:='';
  Cleanup;
 end;
 {
 Update curve data
 }
 procedure UpdateCmdData(n,tag:Integer; s:String);
 var v:Real; CurveRef:Integer;
 begin
  if IsRefTag(tag) then
  if not IsEmptyStr(s) then
  if TypeTag(tag)<=2 then begin
   CurveRef:=RefAo(AKIP.Cmd.AoNum[n]);
   v:=rVal(s);
   if IsNaN(v) then Trouble('Invalid tag update') else
   if TypeTag(tag)=1 then bNul(iSetTag(tag,Round(v))) else
   if TypeTag(tag)=2 then 
   if tag=AKIP.ACQ.SMPLRT.tag then bNul(rSetTag(tag,1/v))
   else bNul(rSetTag(tag,v));
   if IsRefCurve(CurveRef) then UpdateAo(AKIP.Cmd.AoNum[n],time,v);
  end else
  if TypeTag(tag)=3 then begin
   bNul(sSetTag(tag,Trim(s)));
  end;
 end;
 {
 Switch Waveform source 
 }
 procedure IncWaveFormSource;
 begin
  AKIP.GetWaveFormSource:=AKIP.GetWaveFormSource+1;
 end;
 {
 Returns enabled channel number
 }
 function GetWaveFormSourceNumber:Integer;
 var n:Integer;
 begin
  n:=0;
  if AKIP.GetWaveFormSource=1 then if IsChannelOn(AKIP.CN1) then n:=AKIP.GetWaveFormSource else IncWaveFormSource;
  if AKIP.GetWaveFormSource=2 then if IsChannelOn(AKIP.CN2) then n:=AKIP.GetWaveFormSource else IncWaveFormSource;
  if AKIP.GetWaveFormSource=3 then if IsChannelOn(AKIP.CN3) then n:=AKIP.GetWaveFormSource else IncWaveFormSource;
  if AKIP.GetWaveFormSource=4 then if IsChannelOn(AKIP.CN4) then n:=AKIP.GetWaveFormSource;
  GetWaveFormSourceNumber:=n;
 end;
 {
 Returns source name by number n
 }
 function WaveFormSourceName(n:Integer):String;
 begin
  if n=1 then WaveFormSourceName:='C1'
  else if n=2 then WaveFormSourceName:='C2'
  else if n=3 then WaveFormSourceName:='C3'
  else if n=4 then WaveFormSourceName:='C4';
 end;
 {
 Returns wave form source channel current number
 }
 function CurWaveFormSource:Integer;
 var s:String;
 begin
  s:='';
  s:=sGetTag(AKIP.WAV.SOUR.tag);
  if IsSameText(s,'C1') then CurWaveFormSource:=1
  else if IsSameText(s,'C2') then CurWaveFormSource:=2
  else if IsSameText(s,'C3') then CurWaveFormSource:=3
  else if IsSameText(s,'C4') then CurWaveFormSource:=4;
  s:='';
 end;
 {
 Disable polling of all commands except n
 }
 procedure DisablePollingExceptOf(n:Integer);
 var i:Integer;
 begin
  for i:=1 to MaxCmdNum do AKIP.Cmd.Enabled[i]:=false;
  EnableCmdNum(n,true);
 end;
 {
 Get WaveForm data
 }
 procedure GetWaveFormData;
 begin
  if AKIP.IsWaveFormDataRequest then begin
   if AKIP.GetWaveFormStatus=stt_wfNone then begin
   end else
   if AKIP.GetWaveFormStatus=stt_wfSetSource then begin
    //DisablePollingExceptOf(cm_WAV_SOUR_Q);
    DevSendCmdLocal(DimRemote+'@Setting WAV:SOUR '+WaveFormSourceName(AKIP.GetWaveFormSource));
    AKIP.GetWaveFormTimer:=mSecNow;
    AKIP.GetWaveFormStatus:=stt_wfChkSource;
   end else
   if AKIP.GetWaveFormStatus=stt_wfChkSource then begin
    if CurWaveFormSource=AKIP.GetWaveFormSource then AKIP.GetWaveFormStatus:=stt_wfGetData else
    if msElapsedSinceMarker(AKIP.GetWaveFormTimer)>tm_wfSetSource then begin
     AKIP.GetWaveFormStatus:=stt_wfSetSource;
     AKIP.GetWaveFormTimer:=0;
    end;
   end;
   if AKIP.GetWaveFormStatus=stt_wfGetData then begin
    EnableCmdNum(cm_WAV_DATA_Q,true);
    AKIP.GetWaveFormStatus:=stt_wfNone;
   end;
   if AKIP.GetWaveFormStatus=stt_wfIncSource then begin
    IncWaveFormSource;
    AKIP.GetWaveFormStatus:=stt_wfGetSource;
   end;
   if AKIP.GetWaveFormStatus=stt_wfGetSource then begin
    AKIP.GetWaveFormSource:=GetWaveFormSourceNumber;
    if AKIP.GetWaveFormSource<>0
    then AKIP.GetWaveFormStatus:=stt_wfSetSource
    else AKIP.GetWaveFormStatus:=stt_wfDone;
   end;
   if AKIP.GetWaveFormStatus=stt_wfDone then begin
    AkipInitCmd;
    AKIP.GetWaveFormTimer:=0;
    AKIP.GetWaveFormSource:=1;
    AKIP.GetWaveFormStatus:=stt_wfNone;
    AKIP.IsWaveFormDataRequest:=false;
    DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(AKIP.WAV.DATA.tag)+' 0');
    if not AKIP.Simulator then
     if iGetTag(AKIP.MODECALCDEV.tag)=1 then DevSendCmd(AKIP.CalcDevRef,'@CalculateData')
     else DevSendCmdLocal(DimRemote+'@SaveWaveForm')
    else begin
     bNul(sSetTag(AKIP.FILENAME.tag,ParamStr('daqdatapath')+PathDelim+'test_raw.osc'));
     writeln(AdaptFileName(ParamStr('daqdatapath')+PathDelim+'test_raw.osc'));
     DevSendCmd(AKIP.CalcDevRef,'@ReadFile');
    end;
   end;
  end;
 end;
 {
 Decoding data oscilloscope
 }
 procedure DecodeData(n:Integer; s:String);
 begin
  if IsValidCmdNum(n) then begin
   if Length(s)>0 then begin
    if (n=cm_IDEN)              then UpdateCmdData(n,AKIP.IDENT.tag,ExtractWord(2,s)) else
    if (n=cm_OPC)               then UpdateCmdData(n,AKIP.OPC.tag,s) else
    if (n=cm_AUT)               then UpdateCmdData(n,AKIP.AUT.tag,s) else
    if (n=cm_ACQ_MDEP_Q)        then UpdateCmdData(n,AKIP.ACQ.MDEP.tag,s) else
    if (n=cm_ACQ_POIN_Q)        then UpdateCmdData(n,AKIP.ACQ.POIN.tag,s) else
    if (n=cm_ACQ_SEQ_Q)         then bNul(iSetTag(AKIP.ACQ.SEQ.tag,Ord(IsSameText(s,'ON')))) else
    if (n=cm_ACQ_SMPLRT_Q)      then UpdateCmdData(n,AKIP.ACQ.SMPLRT.tag,s) else
    if (n=cm_ACQ_TYPE_Q)        then UpdateCmdData(n,AKIP.ACQ.TYP.tag,s) else
    if (n=cm_CN1_COUP_Q)        then UpdateCmdData(n,AKIP.CN1.COUP.tag,s) else
    if (n=cm_CN2_COUP_Q)        then UpdateCmdData(n,AKIP.CN2.COUP.tag,s) else
    if (n=cm_CN3_COUP_Q)        then UpdateCmdData(n,AKIP.CN3.COUP.tag,s) else
    if (n=cm_CN4_COUP_Q)        then UpdateCmdData(n,AKIP.CN4.COUP.tag,s) else
    if (n=cm_CN1_IMP_Q)         then begin
     if IsSameText(s,'ONEMeg')  then UpdateCmdData(n,AKIP.CN1.IMP.tag,'1 МОм') else
     if IsSameText(s,'FIFTy')   then UpdateCmdData(n,AKIP.CN1.IMP.tag,'50 Ом')
    end else
    if (n=cm_CN2_IMP_Q)         then begin
     if IsSameText(s,'ONEMeg')  then UpdateCmdData(n,AKIP.CN2.IMP.tag,'1 МОм') else
     if IsSameText(s,'FIFTy')   then UpdateCmdData(n,AKIP.CN2.IMP.tag,'50 Ом')
    end else
    if (n=cm_CN3_IMP_Q)         then begin
     if IsSameText(s,'ONEMeg')  then UpdateCmdData(n,AKIP.CN3.IMP.tag,'1 МОм') else
     if IsSameText(s,'FIFTy')   then UpdateCmdData(n,AKIP.CN3.IMP.tag,'50 Ом')
    end else
    if (n=cm_CN4_IMP_Q)         then begin
     if IsSameText(s,'ONEMeg')  then UpdateCmdData(n,AKIP.CN4.IMP.tag,'1 МОм') else
     if IsSameText(s,'FIFTy')   then UpdateCmdData(n,AKIP.CN4.IMP.tag,'50 Ом')
    end else
    if (n=cm_CN1_SCAL_Q)        then UpdateCmdData(n,AKIP.CN1.SCAL.tag,s) else
    if (n=cm_CN2_SCAL_Q)        then UpdateCmdData(n,AKIP.CN2.SCAL.tag,s) else
    if (n=cm_CN3_SCAL_Q)        then UpdateCmdData(n,AKIP.CN3.SCAL.tag,s) else
    if (n=cm_CN4_SCAL_Q)        then UpdateCmdData(n,AKIP.CN4.SCAL.tag,s) else
    if (n=cm_CN1_SWIT_Q)        then bNul(iSetTag(AKIP.CN1.SWIT.tag,Ord(IsSameText(s,'ON')))) else
    if (n=cm_CN2_SWIT_Q)        then bNul(iSetTag(AKIP.CN2.SWIT.tag,Ord(IsSameText(s,'ON')))) else
    if (n=cm_CN3_SWIT_Q)        then bNul(iSetTag(AKIP.CN3.SWIT.tag,Ord(IsSameText(s,'ON')))) else
    if (n=cm_CN4_SWIT_Q)        then bNul(iSetTag(AKIP.CN4.SWIT.tag,Ord(IsSameText(s,'ON')))) else
    if (n=cm_CN1_OFFS_Q)        then UpdateCmdData(n,AKIP.CN1.OFFS.tag,s) else
    if (n=cm_CN2_OFFS_Q)        then UpdateCmdData(n,AKIP.CN2.OFFS.tag,s) else
    if (n=cm_CN3_OFFS_Q)        then UpdateCmdData(n,AKIP.CN3.OFFS.tag,s) else
    if (n=cm_CN4_OFFS_Q)        then UpdateCmdData(n,AKIP.CN4.OFFS.tag,s) else
    if (n=cm_TIM_DEL_Q)         then UpdateCmdData(n,AKIP.TIM.DEL.tag,s) else
    if (n=cm_TIM_SCAL_Q)        then UpdateCmdData(n,AKIP.TIM.SCAL.tag,s) else
    if (n=cm_TRIG_MODE_Q)       then UpdateCmdData(n,AKIP.TRIG.MODE.tag,s) else
    if (n=cm_TRIG_RUN)          then UpdateCmdData(n,AKIP.TRIG.RUN.tag,s) else
    if (n=cm_TRIG_STAT_Q)       then UpdateCmdData(n,AKIP.TRIG.STAT.tag,s) else
    if (n=cm_TRIG_STOP)         then UpdateCmdData(n,AKIP.TRIG.STOP.tag,s) else
    if (n=cm_TRIG_TYPE_Q)       then UpdateCmdData(n,AKIP.TRIG.TYP.tag,s) else
    if (n=cm_TRIG_EDGE_COUP_Q)  then UpdateCmdData(n,AKIP.TRIG.EDGE.COUP.tag,s) else
    if (n=cm_TRIG_EDGE_HLDEV_Q) then UpdateCmdData(n,AKIP.TRIG.EDGE.HLDEV.tag,s) else
    if (n=cm_TRIG_EDGE_HLDT_Q)  then UpdateCmdData(n,AKIP.TRIG.EDGE.HLDT.tag,s) else
    if (n=cm_TRIG_EDGE_HOLD_Q)  then UpdateCmdData(n,AKIP.TRIG.EDGE.HOLD.tag,s) else
    if (n=cm_TRIG_EDGE_HST_Q)   then UpdateCmdData(n,AKIP.TRIG.EDGE.HST.tag,s) else
    if (n=cm_TRIG_EDGE_LEV_Q)   then UpdateCmdData(n,AKIP.TRIG.EDGE.LEV.tag,s) else
    if (n=cm_TRIG_EDGE_NREJ_Q)  then bNul(iSetTag(AKIP.TRIG.EDGE.NREJ.tag,Ord(IsSameText(s,'ON')))) else
    if (n=cm_TRIG_EDGE_SLOP_Q)  then UpdateCmdData(n,AKIP.TRIG.EDGE.SLOP.tag,s) else
    if (n=cm_TRIG_EDGE_SOUR_Q)  then UpdateCmdData(n,AKIP.TRIG.EDGE.SOUR.tag,s) else
    if (n=cm_WAV_DATA_Q)        then begin
     if AKIP.GetWaveFormSource=1 then bNul(sSetTag(AKIP.CN1.WAVFORM.tag,s));
     if AKIP.GetWaveFormSource=2 then bNul(sSetTag(AKIP.CN2.WAVFORM.tag,s));
     if AKIP.GetWaveFormSource=3 then bNul(sSetTag(AKIP.CN3.WAVFORM.tag,s));
     if AKIP.GetWaveFormSource=4 then bNul(sSetTag(AKIP.CN4.WAVFORM.tag,s));
     EnableCmdNum(n,false);
     AKIP.GetWaveFormStatus:=stt_wfIncSource;
    end else
    if (n=cm_WAV_INT_Q)         then UpdateCmdData(n,AKIP.WAV.INT.tag,s)  else
    if (n=cm_WAV_MAXP_Q)        then UpdateCmdData(n,AKIP.WAV.MAXP.tag,s) else
    if (n=cm_WAV_POIN_Q)        then UpdateCmdData(n,AKIP.WAV.POIN.tag,s) else
    if (n=cm_WAV_SOUR_Q)        then UpdateCmdData(n,AKIP.WAV.SOUR.tag,s) else
    if (n=cm_WAV_STAR_Q)        then UpdateCmdData(n,AKIP.WAV.STAR.tag,s) else
    if (n=cm_WAV_WIDT_Q)        then UpdateCmdData(n,AKIP.WAV.WIDT.tag,s)
   end;
  end;
 end;
 {
 Pipe channel for WaveData
 }
 function PipeReadlnWaveData(pip:Integer; var Line,Buff:String):Boolean;
 const MaxLeng = 32554432;
 var p,rxcount,wnpnt:Integer;
 begin
  Line:='';
  PipeReadlnWaveData:=false;
  if (pipe_pid(pip)<>0) then begin
   writeln(length(Buff));
   rxcount:=pipe_rxcount(pip);
   if (Length(Buff)<MaxLeng) and (rxcount>0) then begin
    Buff:=Buff+pipe_recv(pip,MaxLeng);
    p:=Pos('#9',Buff);
    if (p>0) then begin
     wnpnt:=val(copy(Buff,p+2,9));
     AKIP.WavePnt:=wnpnt;
    end;
    if (length(Buff)>=AKIP.WavePnt) then begin
     PipeReadlnWaveData:=True;
     Line:=Copy(Buff,1,11)+Copy(Buff,12,AKIP.WavePnt);
    end; 
   end
   else if Length(Buff)>=MaxLeng then begin
    Trouble('Received line is too long!');
    Buff:='';
   end;
  end;
 end;
 {
 AKIP Cmd Cycle
 }
 procedure AkipCmdCycle;
  function ValidateCmdNum(Num:Integer):Integer;
  begin
   if IsValidCmdNum(Num) then ValidateCmdNum:=Num else ValidateCmdNum:=1;
  end;
  function NextCmdNum(Num:Integer):Integer;
  var i:Integer;
  begin
   i:=0;
   while (i<MaxCmdNum) do begin
    Num:=ValidateCmdNum(Num+1);
    if AKIP.Cmd.Enabled[Num] then i:=MaxCmdNum else i:=i+1;
   end;
   NextCmdNum:=Num;
  end;
  procedure ClearRequest(Num, Status:Integer);
  begin
   AKIP.Pipe.Req:='';
   AKIP.Pipe.Ans:='';
   AKIP.Pipe.Buf:='';
   AKIP.Pipe.ReqTime:=0;
   AKIP.Pipe.AnsTime:=0;
   AKIP.Pipe.Status:=Status;
   AKIP.Cmd.Num:=ValidateCmdNum(Num);
  end;
  procedure PrepareRequest(n:Integer);
  var s,OpData:String;
   procedure Cleanup;
   begin
    s:=''; OpData:='';
   end;
  begin
   if IsValidCmdNum(n) then begin
    s:=AKIP.Cmd.Acronym[n];
    if not IsQueryCmd(s) then begin
     OpData:=AKIP.Cmd.OpData[n];
     if not IsEmptyStr(OpData) then s:=s+' '+OpData;
    end;
    if (Length(s)>0) then s:=s+EOL;
   end;
   AKIP.Pipe.Req:=s;
   Cleanup;
  end;
  function HandleRequest(n:Integer; Ans:String):Boolean;
  var Handled:Boolean;
  begin
   Handled:=false;
   if IsValidCmdNum(n) and (Length(Ans)>0) then begin
    ViewImp('Pipe < '+Ans);
    DecodeData(n,Ans);
    Handled:=True;
   end;
   HandleRequest:=Handled
  end;
  procedure PrintDetails;
  begin
   if iAnd(DebugFlags, dfDetails)>0 then Details('Run '+Str(RunCount)
    +', Cmd '+AKIP.Cmd.Acronym[AKIP.Cmd.Num]
    +', Enb '+Str(Ord(AKIP.Cmd.Enabled[AKIP.Cmd.Num]))
    +', Sta '+Str(AKIP.Pipe.Status)
    +', Req '+Trim(AKIP.Pipe.Req)
    +', Ans '+Trim(AKIP.Pipe.Ans)
    +', Buf '+Trim(AKIP.Pipe.Buf));
  end;
  procedure UpdateOpData;
  var n:Integer;
  begin
   for n:=1 to MaxCmdNum do
   if not IsEmptyStr(AKIP.Cmd.OpBuff[n]) then begin
    if not IsQueryCmdNum(n) then begin
     AKIP.Cmd.OpData[n]:=AKIP.Cmd.OpBuff[n];
     EnableCmdNum(n,true);
    end;
    AKIP.Cmd.OpBuff[n]:='';
   end;
  end;
 begin
  if pipe_connected(AKIP.Pipe.PipeId)>0 then begin
   if iGetTag(AKIP.POLL.ENABLE.tag)>0 then begin
    AKIP.Cmd.Num:=ValidateCmdNum(AKIP.Cmd.Num);
    if iAnd(DebugFlags,dfDetails)>0 then PrintDetails;
    if AKIP.Pipe.Status=st_NoReq then begin
     UpdateOpData;
     ClearRequest(AKIP.Cmd.Num,st_NoReq);
     if mSecNow>=AKIP.Pipe.LastPoll+AKIP.Pipe.PollPeriod then begin
      if AKIP.Cmd.Enabled[AKIP.Cmd.Num] then PrepareRequest(AKIP.Cmd.Num);
      if Length(AKIP.Pipe.Req)>0 then begin
       if pipe_send(AKIP.Pipe.PipeId,AKIP.Pipe.Req)>0 then begin
        ViewExp('Pipe > '+AKIP.Pipe.Req);
        AKIP.Pipe.Status:=st_WaitAns;
        AKIP.Pipe.ReqTime:=mSecNow;
        AKIP.Pipe.LastPoll:=mSecNow;
       end else begin
        Trouble('Could not send request '+AKIP.Pipe.Req);
        ClearRequest(NextCmdNum(AKIP.Cmd.Num),st_NoReq);
       end;
      end else ClearRequest(NextCmdNum(AKIP.Cmd.Num),st_NoReq);
     end;
    end else
    if AKIP.Pipe.Status=st_WaitAns then begin
     if not IsQueryCmdNum(AKIP.Cmd.Num) then begin
      AKIP.Pipe.PollRate:=AKIP.Pipe.PollRate+1;
      AKIP.Pipe.Status:=st_WaitGap;
     end else begin
      if AKIP.Cmd.Num=cm_WAV_DATA_Q then begin
       if PipeReadlnWaveData(AKIP.Pipe.PipeId,AKIP.Pipe.Ans,AKIP.Pipe.Buf) then begin
        bNul(HandleRequest(AKIP.Cmd.Num,AKIP.Pipe.Ans));
        AKIP.WavePnt:=0;
        AKIP.Pipe.PollRate:=AKIP.Pipe.PollRate+1;
        AKIP.Pipe.Status:=st_WaitGap;
        AKIP.Pipe.AnsTime:=mSecNow;
       end;
       if mSecNow>AKIP.Pipe.ReqTime+AKIP.Pipe.LongTimeOut then AKIP.Pipe.Status:=st_TimeOut;
      end else begin
       if Pipe_Readln(AKIP.Pipe.PipeId,AKIP.Pipe.Ans,AKIP.Pipe.Buf) then begin
        bNul(HandleRequest(AKIP.Cmd.Num,AKIP.Pipe.Ans));
        AKIP.Pipe.PollRate:=AKIP.Pipe.PollRate+1;
        AKIP.Pipe.Status:=st_WaitGap;
        AKIP.Pipe.AnsTime:=mSecNow;
       end;
       if mSecNow>AKIP.Pipe.ReqTime+AKIP.Pipe.TimeOut then AKIP.Pipe.Status:=st_TimeOut;
      end;
     end;
    end;
    if AKIP.Pipe.Status=st_WaitGap then begin
     if mSecNow>=AKIP.Pipe.AnsTime+AKIP.Pipe.TimeGap then begin
      if not IsQueryCmdNum(AKIP.Cmd.Num) then EnableCmdNum(AKIP.Cmd.Num,false);
      ClearRequest(NextCmdNum(AKIP.Cmd.Num),st_NoReq);
     end;
    end;
    if AKIP.Pipe.Status=st_TimeOut then begin
     Failure(AKIP.ecTimeOut,'TimeOut on command '+AKIP.Cmd.Acronym[AKIP.Cmd.Num]+' request '+Trim(AKIP.Pipe.Req));
     ClearRequest(NextCmdNum(AKIP.Cmd.Num),st_NoReq);
    end;
   end;
  end else begin
   ClearRequest(NextCmdNum(0),st_NoReq);
   bNul(sSetTag(AKIP.IDENT.tag,'REFUSE'));
  end;
 end;
 {
 Xor bit on click
 }
 procedure ClickTagXorRemote(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(tag)+' '+Str(iXor(iGetTag(tag),XorMask)));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Click tag local
 }
 procedure ClickTagXorLocal(tag,XorMask:Integer);
 begin
  if (ClickTag=tag) then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Post command (cmd) to console on tag click.
 }
 procedure DevSendCmdEdit(tag:Integer; par:String);
 begin
  if CLickTag=tag then begin
   DevPostCmdLocal('@Edit '+NameTag(tag)+' '+par);
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Menu tools starter
 }
 procedure MenuToolsStarter;
 var n:Integer; s:String;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Меню "Инструменты"');
   n:=n+EditAddInputLn('Что выбираете:');
   n:=n+EditAddInputLn('Открыть консоль: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   n:=n+EditAddInputLn('Режим отладки: нормальный');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   n:=n+EditAddInputLn('Режим отладки: ввод-вывод');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   n:=n+EditAddInputLn('Режим отладки: детальный');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   n:=n+EditAddInputLn('Загрузить параметры из INI файла');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand(DimRemote+'@LoadIni');
   n:=n+EditAddInputLn('Сохранить параметры в INI файл');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand(DimRemote+'@SaveIni');
   n:=n+EditAddInputLn('Включить обработку осциллограмм');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand(DimRemote+'@ModeCalcDev '+'Online');
   n:=n+EditAddInputLn('Выключить обработку осциллограмм');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand(DimRemote+'@ModeCalcDev '+'Offline');
   n:=n+EditAddInputLn('Вывести таблицу команд');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@PrintCmdTable');
   n:=n+EditAddInputLn('Перезапустить драйвер опроса устройства (локально) '+DevName);
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SysEval @Daq Compile '+DevName);
   n:=n+EditAddInputLn('Перезапустить драйвер обработки данных (локально) '+AKIP.CalcDevName);
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SysEval @Daq Compile '+AKIP.CalcDevName);
   if DIM_IsClientMode then begin
    n:=n+EditAddInputLn('Перезапустить драйвер опроса устройства (удаленно) '+DevName);
    n:=n+EditAddConfirm(EditGetLastInputLn);
    n:=n+EditAddCommand(DimRemote+'@SysEval @Daq Compile '+DevName);
   end;
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MenuTools'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu max memory for single mode
 }
 procedure MenuMaxMemorySingle(tag:Integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Меню "Max Memory"');
   n:=n+EditAddInputLn('Что выбираете:');
   n:=n+EditAddInputLn('10k');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 10k');
   n:=n+EditAddInputLn('50k');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 50k');
   n:=n+EditAddInputLn('250k');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 250k');
   n:=n+EditAddInputLn('1.25M');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 1.25M');
   n:=n+EditAddInputLn('2.5M');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 2.5M');
   n:=n+EditAddInputLn('12.5M');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 12.5M');
   n:=n+EditAddInputLn('25M');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 25M');
   n:=n+EditAddInputLn('125M');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 125M');
   n:=n+EditAddInputLn('250M');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 250M');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MenuMaxMemorySingle'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu max memory for dual mode
 }
 procedure MenuMaxMemoryDual(tag:Integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Меню "Max Memory"');
   n:=n+EditAddInputLn('Что выбираете:');
   n:=n+EditAddInputLn('5k');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 5k');
   n:=n+EditAddInputLn('25k');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 25k');
   n:=n+EditAddInputLn('125k');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 125k');
   n:=n+EditAddInputLn('625k');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 625k');
   n:=n+EditAddInputLn('1.25M');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 1.25M');
   n:=n+EditAddInputLn('6.25M');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 6.25M');
   n:=n+EditAddInputLn('12.5M');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 12.5M');
   n:=n+EditAddInputLn('62.5M');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 62.5M');
   n:=n+EditAddInputLn('125M');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:MDEP 125M');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MenuMaxMemoryDual'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu type acquisition
 }
 procedure MenuTypeAcquisition(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Меню "Type Acquisition"');
   n:=n+EditAddInputLn('Что выбираете:');
   n:=n+EditAddInputLn('NORM');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE NORM');
   n:=n+EditAddInputLn('PEAK');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE PEAK');
   n:=n+EditAddInputLn('AVER 4');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE AVER,4');
   n:=n+EditAddInputLn('AVER 16');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE AVER,16');
   n:=n+EditAddInputLn('AVER 32');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE AVER,32');
   n:=n+EditAddInputLn('AVER 64');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE AVER,64');
   n:=n+EditAddInputLn('AVER 128');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE AVER,128');
   n:=n+EditAddInputLn('AVER 256');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE AVER,256');
   n:=n+EditAddInputLn('AVER 512');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE AVER,512');
   n:=n+EditAddInputLn('AVER 1024');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE AVER,1024');
   n:=n+EditAddInputLn('ERES 0.5');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE ERES,0.5');
   n:=n+EditAddInputLn('ERES 1.0');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE ERES,1.0');
   n:=n+EditAddInputLn('ERES 1.5');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE ERES,1.5');
   n:=n+EditAddInputLn('ERES 2.0');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE ERES,2.0');
   n:=n+EditAddInputLn('ERES 2.5');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE ERES,2.5');
   n:=n+EditAddInputLn('ERES 3.0');
   n:=n+EditAddCommand(DimRemote+'@Setting ACQ:TYPE ERES,3.0');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MenuTypeAcquisition'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu time scale
 }
 procedure MenuTimeScale(tag:integer);
 var n:integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Меню "TimeScale source"');
   n:=n+EditAddInputLn('Что выбираете:');
   n:=n+EditAddInputLn('10 ns');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 1.00E-08');
   n:=n+EditAddInputLn('20 ns');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 2.00E-08');
   n:=n+EditAddInputLn('50 ns');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 5.00E-08');
   n:=n+EditAddInputLn('100 ns');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 1.00E-07');
   n:=n+EditAddInputLn('200 ns');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 2.00E-07');
   n:=n+EditAddInputLn('500 ns');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 5.00E-07');
   n:=n+EditAddInputLn('1 us');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 1.00E-06');
   n:=n+EditAddInputLn('2 us');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 2.00E-06');
   n:=n+EditAddInputLn('5 us');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 5.00E-06');
   n:=n+EditAddInputLn('10 us');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 1.00E-05');
   n:=n+EditAddInputLn('20 us');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 2.00E-05');
   n:=n+EditAddInputLn('50 us');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 5.00E-05');
   n:=n+EditAddInputLn('100 us');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 1.00E-04');
   n:=n+EditAddInputLn('200 us');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 2.00E-04');
   n:=n+EditAddInputLn('500 us');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 5.00E-04');
   n:=n+EditAddInputLn('1 ms');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 1.00E-03');
   n:=n+EditAddInputLn('2 ms');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 2.00E-03');
   n:=n+EditAddInputLn('5 ms');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 5.00E-03');
   n:=n+EditAddInputLn('10 ms');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 1.00E-02');
   n:=n+EditAddInputLn('20 ms');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 2.00E-02');
   n:=n+EditAddInputLn('50 ms');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 5.00E-02');
   n:=n+EditAddInputLn('100 ms');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 1.00E-01');
   n:=n+EditAddInputLn('200 ms');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 2.00E-01');
   n:=n+EditAddInputLn('500 ms');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 5.00E-01');
   n:=n+EditAddInputLn('1 s');
   n:=n+EditAddCommand(DimRemote+'@Setting TIM:SCAL 1.00E+00');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MenuTimeScale'),'');
   if (n>0) then Problem('Error initialization MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu channel 1 coupling
 }
 procedure MenuChan1Coup(tag:integer);
 var n:Integer;
 begin
  if IsChannelOn(AKIP.CN1) then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Меню "Channel 1 Coupling"');
    n:=n+EditAddInputLn('Что выбираете:');
    n:=n+EditAddInputLn('DC');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN1:COUP DC');
    n:=n+EditAddInputLn('AC');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN1:COUP AC');
    n:=n+EditAddInputLn('GND');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN1:COUP GND');
    n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
    n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
    n:=n+EditAddClosing('MenuList',EditGetUID('MenuChan1Coup'),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end else ShowWarning('Channel 1 switch off');
 end;
 {
 Menu channel 2 coupling
 }
 procedure MenuChan2Coup(tag:integer);
 var n:Integer;
 begin
  if IsChannelOn(AKIP.CN2) then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Меню "Channel 2 Coupling"');
    n:=n+EditAddInputLn('Что выбираете:');
    n:=n+EditAddInputLn('DC');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN2:COUP DC');
    n:=n+EditAddInputLn('AC');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN2:COUP AC');
    n:=n+EditAddInputLn('GND');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN2:COUP GND');
    n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
    n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
    n:=n+EditAddClosing('MenuList',EditGetUID('MenuChan2Coup'),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end else ShowWarning('Channel 2 switch off');
 end;
 {
 Menu channel 3 coupling
 }
 procedure MenuChan3Coup(tag:integer);
 var n:Integer;
 begin
  if IsChannelOn(AKIP.CN3) then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Меню "Channel 3 Coupling"');
    n:=n+EditAddInputLn('Что выбираете:');
    n:=n+EditAddInputLn('DC');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN3:COUP DC');
    n:=n+EditAddInputLn('AC');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN3:COUP AC');
    n:=n+EditAddInputLn('GND');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN3:COUP GND');
    n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
    n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
    n:=n+EditAddClosing('MenuList',EditGetUID('MenuChan3Coup'),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end else ShowWarning('Channel 3 switch off');
 end;
 {
 Menu channel 4 coupling
 }
 procedure MenuChan4Coup(tag:integer);
 var n:Integer;
 begin
  if IsChannelOn(AKIP.CN4) then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Меню "Channel 4 Coupling"');
    n:=n+EditAddInputLn('Что выбираете:');
    n:=n+EditAddInputLn('DC');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN4:COUP DC');
    n:=n+EditAddInputLn('AC');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN4:COUP AC');
    n:=n+EditAddInputLn('GND');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN4:COUP GND');
    n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
    n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
    n:=n+EditAddClosing('MenuList',EditGetUID('MenuChan4Coup'),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end else ShowWarning('Channel 4 switch off');
 end;
 {
 Menu channel 1 impedance
 }
 procedure MenuChan1Imp(tag:integer);
 var n:Integer;
 begin
  if IsChannelOn(AKIP.CN1) then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Меню "Channel 1 Impedance"');
    n:=n+EditAddInputLn('Что выбираете:');
    n:=n+EditAddInputLn('1 МОм');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN1:IMP ONEM');
    n:=n+EditAddInputLn('50 Ом');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN1:IMP FIFT');
    n:=n+EditAddSetting('@set ListBox Font Size:12\Style:[]');
    n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
    n:=n+EditAddClosing('MenuList',EditGetUID('MenuChan1Imp'),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end else ShowWarning('Channel 1 switch off');
 end;
 {
 Menu channel 2 impedance
 }
 procedure MenuChan2Imp(tag:integer);
 var n:Integer;
 begin
  if IsChannelOn(AKIP.CN2) then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Меню "Channel 2 Impedance"');
    n:=n+EditAddInputLn('Что выбираете:');
    n:=n+EditAddInputLn('1 МОм');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN2:IMP ONEM');
    n:=n+EditAddInputLn('50 Ом');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN2:IMP FIFT');
    n:=n+EditAddSetting('@set ListBox Font Size:12\Style:[]');
    n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
    n:=n+EditAddClosing('MenuList',EditGetUID('MenuChan2Imp'),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end else ShowWarning('Channel 2 switch off');
 end;
 {
 Menu channel 3 impedance
 }
 procedure MenuChan3Imp(tag:integer);
 var n:Integer;
 begin
  if IsChannelOn(AKIP.CN3) then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Меню "Channel 3 Impedance"');
    n:=n+EditAddInputLn('Что выбираете:');
    n:=n+EditAddInputLn('1 МОм');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN3:IMP ONEM');
    n:=n+EditAddInputLn('50 Ом');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN3:IMP FIFT');
    n:=n+EditAddSetting('@set ListBox Font Size:12\Style:[]');
    n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
    n:=n+EditAddClosing('MenuList',EditGetUID('MenuChan3Imp'),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end else ShowWarning('Channel 3 switch off');
 end;
 {
 Menu channel 4 impedance
 }
 procedure MenuChan4Imp(tag:integer);
 var n:Integer;
 begin
  if IsChannelOn(AKIP.CN4) then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Меню "Channel 4 Impedance"');
    n:=n+EditAddInputLn('Что выбираете:');
    n:=n+EditAddInputLn('1 МОм');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN4:IMP ONEM');
    n:=n+EditAddInputLn('50 Ом');
    n:=n+EditAddCommand(DimRemote+'@Setting CHAN4:IMP FIFT');
    n:=n+EditAddSetting('@set ListBox Font Size:12\Style:[]');
    n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
    n:=n+EditAddClosing('MenuList',EditGetUID('MenuChan4Imp'),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end else ShowWarning('Channel 4 switch off');
 end;
 {
 Menu EDGE trigger HOLD
 }
 procedure MenuTriggerHOLD(tag:integer);
 var n:Integer;
 begin
  if IsEdgeTrigger then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Меню "Trigger HOLD Type"');
    n:=n+EditAddInputLn('Что выбираете:');
    n:=n+EditAddInputLn('OFF');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:HOLD OFF');
    n:=n+EditAddInputLn('EVEN');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:HOLD EVEN');
    n:=n+EditAddInputLn('TIME');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:HOLD TIME');
    n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
    n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
    n:=n+EditAddClosing('MenuList',EditGetUID('MenuTriggerHOLD'),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end else ShowWarning('Для изменения параметра переключите тип триггера на EDGE');
 end;
 {
 Menu EDGE trigger HST
 }
 procedure MenuTriggerHST(tag:integer);
 var n:Integer;
 begin
  if IsEdgeTrigger then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Меню "Trigger Init Pos"');
    n:=n+EditAddInputLn('Что выбираете:');
    n:=n+EditAddInputLn('LAST_TRIG');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:HST LAST_TRIG');
    n:=n+EditAddInputLn('ACQ_START');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:HST ACQ_START');
    n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
    n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
    n:=n+EditAddClosing('MenuList',EditGetUID('MenuTriggerHST'),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end else ShowWarning('Для изменения параметра переключите тип триггера на EDGE');
 end;
 {
 Menu EDGE trigger slop
 }
 procedure MenuTriggerSlop(tag:integer);
 var n:Integer;
 begin
  if IsEdgeTrigger then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Меню "Trigger Slop"');
    n:=n+EditAddInputLn('Что выбираете:');
    n:=n+EditAddInputLn('RISING');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SLOP RIS');
    n:=n+EditAddInputLn('FALLING');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SLOP FALL');
    n:=n+EditAddInputLn('ALTERNATE');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SLOP ALT');
    n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
    n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
    n:=n+EditAddClosing('MenuList',EditGetUID('MenuTriggerSlop'),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end else ShowWarning('Для изменения параметра переключите тип триггера на EDGE');
 end;
 {
 Menu EDGE trigger coup
 }
 procedure MenuTriggerCoup(tag:integer);
 var n:Integer;
 begin
  if IsEdgeTrigger then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Меню "Trigger Coup"');
    n:=n+EditAddInputLn('Что выбираете:');
    n:=n+EditAddInputLn('DC');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:COUP DC');
    n:=n+EditAddInputLn('AC');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:COUP AC');
    n:=n+EditAddInputLn('LFREJECT');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:COUP LFREJ');
    n:=n+EditAddInputLn('HFREJECT');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:COUP HFREJ');
    n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
    n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
    n:=n+EditAddClosing('MenuList',EditGetUID('MenuTriggerCoup'),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end else ShowWarning('Для изменения параметра переключите тип триггера на EDGE');
 end;
 {
 Menu EDGE trigger sour
 }
 procedure MenuTriggerSour(tag:integer);
 var n:Integer;
 begin
  if IsEdgeTrigger then begin
   if EditStateReady then begin
    n:=0+EditAddOpening('Меню "Type trigger source"');
    n:=n+EditAddInputLn('Что выбираете:');
    n:=n+EditAddInputLn('Analog Channels 1');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SOUR C1');
    n:=n+EditAddInputLn('Analog Channels 2');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SOUR C2');
    n:=n+EditAddInputLn('Analog Channels 3');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SOUR C3');
    n:=n+EditAddInputLn('Analog Channels 4');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SOUR C4');
    n:=n+EditAddInputLn('Digital Channels 0');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SOUR D0');
    n:=n+EditAddInputLn('Digital Channels 1');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SOUR D1');
    n:=n+EditAddInputLn('Digital Channels 2');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SOUR D2');
    n:=n+EditAddInputLn('Digital Channels 3');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SOUR D3');
    n:=n+EditAddInputLn('EX');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SOUR EX');
    n:=n+EditAddInputLn('EX5');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SOUR EX5');
    n:=n+EditAddInputLn('LINE');
    n:=n+EditAddCommand(DimRemote+'@Setting TRIG:EDGE:SOUR LINE');
    n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
    n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
    n:=n+EditAddClosing('MenuList',EditGetUID('MenuTriggerSour'),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end else ShowWarning('Для изменения параметра переключите тип триггера на EDGE');
 end;
 {
 Menu trigger mode
 }
 procedure MenuTriggerMode(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Меню "Trigger Mode"');
   n:=n+EditAddInputLn('Что выбираете:');
   n:=n+EditAddInputLn('SINGLE');
   n:=n+EditAddCommand(DimRemote+'@SingleStart');
   n:=n+EditAddInputLn('NORMAL');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:MODE NORM');
   n:=n+EditAddInputLn('AUTO');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:MODE AUTO');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MenuTriggerMode'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu trigger type
 }
 procedure MenuTriggerType(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Меню "Trigger Type"');
   n:=n+EditAddInputLn('Что выбираете:');
   n:=n+EditAddInputLn('EDGE');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE EDGE');
   n:=n+EditAddInputLn('PULSE');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE PULSE');
   n:=n+EditAddInputLn('SLOPE');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE SLOP');
   n:=n+EditAddInputLn('INTERVAL');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE INT');
   n:=n+EditAddInputLn('PATTERN');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE PATT');
   n:=n+EditAddInputLn('RUNT');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE RUNT');
   n:=n+EditAddInputLn('QUALIFIED');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE QUAL');
   n:=n+EditAddInputLn('WINDOW');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE WIND');
   n:=n+EditAddInputLn('DROPOUT');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE DROP');
   n:=n+EditAddInputLn('VIDEO');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE VID');
   n:=n+EditAddInputLn('IIC');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE IIC');
   n:=n+EditAddInputLn('SPI');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE SPI');
   n:=n+EditAddInputLn('UART');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE UART');
   n:=n+EditAddInputLn('LIN');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE LIN');
   n:=n+EditAddInputLn('CAN');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE CAN');
   n:=n+EditAddInputLn('FLEXRAY');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE FLEX');
   n:=n+EditAddInputLn('CANFD');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE CANF');
   n:=n+EditAddInputLn('IIS');
   n:=n+EditAddCommand(DimRemote+'@Setting TRIG:TYPE IIS');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MenuTriggerType'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu WaveOutForm
 }
 procedure MenuWaveOutForm(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Меню "Wave Out Form"');
   n:=n+EditAddInputLn('Что выбираете:');
   n:=n+EditAddInputLn('BYTE');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:WIDT BYTE');
   n:=n+EditAddInputLn('WORD');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:WIDT WORD');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MenuWaveOutForm'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu WaveForm source
 }
 procedure MenuWaveFormSource(tag:integer);
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Меню "WaveForm Source"');
   n:=n+EditAddInputLn('Что выбираете:');
   n:=n+EditAddInputLn('C 1');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:SOUR C1');
   n:=n+EditAddInputLn('C 2');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:SOUR C2');
   n:=n+EditAddInputLn('C 3');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:SOUR C3');
   n:=n+EditAddInputLn('C 4');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:SOUR C4');
   n:=n+EditAddInputLn('F 1');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:SOUR F1');
   n:=n+EditAddInputLn('F 2');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:SOUR F2');
   n:=n+EditAddInputLn('F 3');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:SOUR F3');
   n:=n+EditAddInputLn('F 4');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:SOUR F4');
   n:=n+EditAddInputLn('D 0');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:SOUR D0');
   n:=n+EditAddInputLn('D 1');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:SOUR D1');
   n:=n+EditAddInputLn('D 2');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:SOUR D2');
   n:=n+EditAddInputLn('D 3');
   n:=n+EditAddCommand(DimRemote+'@Setting WAV:SOUR D3');
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   n:=n+EditAddClosing('MenuList',EditGetUID('MenuWaveFormSource'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu handler to handle editing.
 }
 procedure MenusHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MenuTools'));
  EditMenuDefaultHandler(EditGetUID('MenuMaxMemorySingle'));
  EditMenuDefaultHandler(EditGetUID('MenuMaxMemoryDual'));
  EditMenuDefaultHandler(EditGetUID('MenuTypeAcquisition'));
  EditMenuDefaultHandler(EditGetUID('MenuTimeScale'));
  EditMenuDefaultHandler(EditGetUID('MenuChan1Coup'));
  EditMenuDefaultHandler(EditGetUID('MenuChan2Coup'));
  EditMenuDefaultHandler(EditGetUID('MenuChan3Coup'));
  EditMenuDefaultHandler(EditGetUID('MenuChan4Coup'));
  EditMenuDefaultHandler(EditGetUID('MenuChan1Imp'));
  EditMenuDefaultHandler(EditGetUID('MenuChan2Imp'));
  EditMenuDefaultHandler(EditGetUID('MenuChan3Imp'));
  EditMenuDefaultHandler(EditGetUID('MenuChan4Imp'));
  EditMenuDefaultHandler(EditGetUID('MenuSwitChan1'));
  EditMenuDefaultHandler(EditGetUID('MenuSwitChan2'));
  EditMenuDefaultHandler(EditGetUID('MenuSwitChan3'));
  EditMenuDefaultHandler(EditGetUID('MenuSwitChan4'));
  EditMenuDefaultHandler(EditGetUID('MenuTriggerHOLD'));
  EditMenuDefaultHandler(EditGetUID('MenuTriggerHST'));
  EditMenuDefaultHandler(EditGetUID('MenuTriggerSlop'));
  EditMenuDefaultHandler(EditGetUID('MenuTriggerCoup'));
  EditMenuDefaultHandler(EditGetUID('MenuTriggerSour'));
  EditMenuDefaultHandler(EditGetUID('MenuTriggerMode'));
  EditMenuDefaultHandler(EditGetUID('MenuTriggerType'));
  EditMenuDefaultHandler(EditGetUID('MenuWaveOutForm'));
  EditMenuDefaultHandler(EditGetUID('MenuWaveFormSource'));
 end;
 {
 Open MaxMemory menu
 }
 procedure MenuMaxMemory;
 var c1,c2,c3,c4:Boolean;
 begin
  c1:=IsChannelOn(AKIP.CN1);
  c2:=IsChannelOn(AKIP.CN2);
  c3:=IsChannelOn(AKIP.CN3);
  c4:=IsChannelOn(AKIP.CN4);
  if ((c1 and c2) or (c3 and c4))
  then MenuMaxMemoryDual(AKIP.ACQ.MDEP.tag)
  else MenuMaxMemorySingle(AKIP.ACQ.MDEP.tag);
 end;
 {
 Save Waveform ...(filename - ?)
 }
 procedure SaveWaveForm;
 var io:Integer; FileName,FileDir,dat1,dat2,dat3,dat4,DfltDir:String;
 TimeDel,TimeScal,AcqSmplRt,SclCn1,SclCn2,SclCn3,SclCn4,OffsCn1,OffsCn2,OffsCn3,OffsCn4:String;
  procedure Cleanup;
  begin
   FileName:=''; FileDir:=''; dat1:=''; dat2:=''; dat3:=''; dat4:=''; DfltDir:='';
   TimeDel:=''; TimeScal:=''; AcqSmplRt:=''; SclCn1:=''; SclCn2:=''; SclCn3:=''; SclCn4:='';
   OffsCn1:=''; OffsCn2:=''; OffsCn3:=''; OffsCn4:='';
  end;
 begin
  Cleanup;
  FileName:=AKIP.FilePrefix+'_oscillogram_'+StrTimeFmt('yyyymmdd_hhnnss',msecnow)+'_raw.osc';
  FileDir:=sGetTag(AKIP.DEF.DIRBASE.tag)+sGetTag(AKIP.DEF.DIREXP.tag);
  DfltDir:=ParamStr('daqdatapath');
  if not DirExists(FileDir) then begin
   if not MkDir(FileDir) then begin
    FileDir:=DfltDir;
    ShowWarning('Ошибка в пути сохранения осциллограмм, будет использован путь по умолчанию '+FileDir);
    bNul(MkDir(FileDir));
   end;
  end;
  FileName:=FileDir+FileName;
  if FileExists(FileName) then io:=f_reset(FileName,2)
  else io:=f_rewrite(FileName,1);
  if io=0 then begin
   TimeDel:='Time Delay: '+str(rGetTag(AKIP.TIM.DEL.tag))+EOL;
   TimeScal:='Time Scale: '+str(rGetTag(AKIP.TIM.SCAL.tag))+EOL;
   AcqSmplRt:='Acq Sample Rate: '+str(rGetTag(AKIP.ACQ.SMPLRT.tag))+EOL;
   if IsChannelOn(AKIP.CN1) then begin 
    dat1:='DAT1,'+sGetTag(AKIP.CN1.WAVFORM.tag)+EOL;
    SclCn1:='Cn1 Scale: '+str(rGetTag(AKIP.CN1.SCAL.tag))+EOL;
    OffsCn1:='Cn1 Offset: '+str(rGetTag(AKIP.CN1.OFFS.tag))+EOL;
   end;
   if IsChannelOn(AKIP.CN2) then begin
    dat2:='DAT2,'+sGetTag(AKIP.CN2.WAVFORM.tag)+EOL;
    SclCn2:='Cn2 Scale: '+str(rGetTag(AKIP.CN2.SCAL.tag))+EOL;
    OffsCn2:='Cn2 Offset: '+str(rGetTag(AKIP.CN2.OFFS.tag))+EOL;
   end;
   if IsChannelOn(AKIP.CN3) then begin
    dat3:='DAT3,'+sGetTag(AKIP.CN3.WAVFORM.tag)+EOL;
    SclCn3:='Cn3 Scale: '+str(rGetTag(AKIP.CN3.SCAL.tag))+EOL;
    OffsCn3:='Cn3 Offset: '+str(rGetTag(AKIP.CN3.OFFS.tag))+EOL;
   end;
   if IsChannelOn(AKIP.CN4) then begin
    dat4:='DAT4,'+sGetTag(AKIP.CN4.WAVFORM.tag)+EOL;
    SclCn4:='Cn4 Scale: '+str(rGetTag(AKIP.CN4.SCAL.tag))+EOL;
    OffsCn4:='Cn4 Offset: '+str(rGetTag(AKIP.CN4.OFFS.tag))+EOL;
   end;
   if f_write(TimeDel+TimeScal+AcqSmplRt)<>length(TimeDel+TimeScal+AcqSmplRt) then ShowWarning('Произошла ошибка при записи данных для расчетов в файл '+FileName);
   if f_write(SclCn1+OffsCn1+SclCn2+OffsCn2)<>length(SclCn1+OffsCn1+SclCn2+OffsCn2) then ShowWarning('Произошла ошибка при записи доп. данных для 1 и 2 каналов в файл '+FileName);
   if f_write(SclCn3+OffsCn3+SclCn4+OffsCn4)<>length(SclCn3+OffsCn3+SclCn4+OffsCn4) then ShowWarning('Произошла ошибка при записи доп. данных для 3 и 4 каналов в файл '+FileName);
   if f_write(dat1+dat2)<>length(dat1+dat2) then ShowWarning('Произошла ошибка при записи данных 1 и 2 каналов в файл '+FileName);
   if f_write(dat3+dat4)<>length(dat3+dat4) then ShowWarning('Произошла ошибка при записи данных 3 и 4 каналов в файл '+FileName);
   bNul(f_close);
   bNul(sSetTag(AKIP.FILENAME.tag,FileName));
   ShowTooltip('text "Сохранение выполнено" delay 10000 preset stdSuccess');
   if AKIP.AutoSaveMode=true then AKIP.GetTrigStatus:=stt_trigAutoWork
   else AKIP.GetTrigStatus:=stt_trigDone;
  end else ShowWarning('Возникла ошибка при создании файла '+FileName);
  Cleanup;
  //AkipInitCmd;
  //AKIP.GetTrigStatus:=stt_trigDone;
 end;
 {}
 procedure UpdateStateDevice;
 begin
  if AKIP.Simulator then bNul(iSetTag(AKIP.STATUS.tag,stat_Simulator)) else
  begin
   if AKIP.Pipe.Status=st_TimeOut then bNul(iSetTag(AKIP.STATUS.tag,stat_TimeOut)) else
   if sGetTag(AKIP.TRIG.MODE.tag)='FTrig' then bNul(iSetTag(AKIP.STATUS.tag,stat_FalseTrig)) else
   if sGetTag(AKIP.IDENT.tag)='REFUSE' then bNul(iSetTag(AKIP.STATUS.tag,stat_Refuse)) else
   if iGetTag(AKIP.POLL.ENABLE.tag)=0 then bNul(iSetTag(AKIP.STATUS.tag,stat_Off)) else
   if iGetTag(AKIP.POLL.ENABLE.tag)<>0 then bNul(iSetTag(AKIP.STATUS.tag,stat_On)) else
   if iGetTag(AKIP.ERROR.CNT.tag)<>0 then bNul(iSetTag(AKIP.STATUS.tag,stat_Warning));
  end;
 end;
 {
 Set base directory for save wavedata file
 }
 procedure SetDirBase(arg:String);
 begin
  if not IsEmptyStr(arg) then begin
   bNul(sSetTag(AKIP.BASEDIR.tag,AdaptFileName(AddPathDelim(arg))));
   Success('New base directory: '+AddPathDelim(arg));
  end else bNul(sSetTag(AKIP.BASEDIR.tag,AdaptFileName(AddPathDelim(ReadIni('DefaultDirBase')))));
 end;
 {
 Set experiment directory for save wavedata file
 }
 procedure SetDirExp(arg:String);
 begin
  if not IsEmptyStr(arg) then begin
   bNul(sSetTag(AKIP.EXTRACTNUM.tag,''));
   bNul(sSetTag(AKIP.EXPDIR.tag,AdaptFileName(AddPathDelim(arg))));
   if IsUnix then 
    if strtointbase(ExtractWordDelims(2,arg,Dump('/')),10,0)<>0 then
     bNul(sSetTag(AKIP.EXTRACTNUM.tag,ExtractWordDelims(2,arg,Dump('/'))))
    else begin end
   else if IsWindows then
    if strtointbase(ExtractWordDelims(2,arg,Dump('\')),10,0)<>0 then
     bNul(sSetTag(AKIP.EXTRACTNUM.tag,ExtractWordDelims(2,arg,Dump('\'))))
    else begin end;
   Success('New copy catalog: '+AddPathDelim(arg));
  end else bNul(sSetTag(AKIP.EXPDIR.tag,AdaptFileName(AddPathDelim(ReadIni('DefaultExpDir')))));
 end;
 {
 GUI Handler to process user input
 }
 procedure AkipGUIHandler;
 var ClickCurve,n:Integer; s:String;
  procedure Cleanup;
  begin
   s:=''; DIM_GuiClickBuff:='';
  end;
 begin
  Cleanup;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Copy GUI click to DIM buffer for remote execution.
   }
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Handle local clicks
     }
     if ClickIsLocal then begin
      if IsSameText(ClickSensor,'AKIP.TOOLS') then begin
       bNul(Voice(snd_Click));
       MenuToolsStarter;
      end;
      if IsSameText(ClickSensor,'AKIP.PARAM.SELECT') then DevPostCmdLocal('@WinSelect '+StringReplace(Copy(DevName,2,Length(DevName)),'CTRL','PARAM',rfIgnoreCase));
      if IsSameText(ClickSensor,'AKIP.CALC.SELECT') then DevPostCmdLocal('@WinSelect '+StringReplace(Copy(DevName,2,Length(DevName)),'CTRL','CALC',rfIgnoreCase));
      if IsSameText(ClickSensor,'AKIP.ERROR.CNT') then bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
      {
      Handle tag clicks
      }
      if (ClickTag<>0) then begin
       CLickTagXorRemote(AKIP.POLL.ENABLE.tag,1);
       s:=mime_encode(SetFormUnderSensorLeftBottom(ClickParams('')));
       if IsPollingEnabled then begin
        ClickTagXorRemote(AKIP.CN1.SWIT.tag,1);
        ClickTagXorRemote(AKIP.CN2.SWIT.tag,1);
        ClickTagXorRemote(AKIP.CN3.SWIT.tag,1);
        ClickTagXorRemote(AKIP.CN4.SWIT.tag,1);
        DevSendCmdEdit(AKIP.TIM.DEL.tag,s);
        DevSendCmdEdit(AKIP.WAV.INT.tag,s);
        DevSendCmdEdit(AKIP.WAV.POIN.tag,s);
        DevSendCmdEdit(AKIP.WAV.STAR.tag,s);
        DevSendCmdEdit(AKIP.TRIG.EDGE.HLDEV.tag,s);
        DevSendCmdEdit(AKIP.TRIG.EDGE.HLDT.tag,s);
        DevSendCmdEdit(AKIP.TRIG.EDGE.LEV.tag,s);
        DevSendCmdEdit(AKIP.CN1.OFFS.tag,s);
        DevSendCmdEdit(AKIP.CN1.SCAL.tag,s);
        DevSendCmdEdit(AKIP.CN2.OFFS.tag,s);
        DevSendCmdEdit(AKIP.CN2.SCAL.tag,s);
        DevSendCmdEdit(AKIP.CN3.OFFS.tag,s);
        DevSendCmdEdit(AKIP.CN3.SCAL.tag,s);
        DevSendCmdEdit(AKIP.CN4.OFFS.tag,s);
        DevSendCmdEdit(AKIP.CN4.SCAL.tag,s);
        if ClickTag=AKIP.ACQ.SEQ.tag then begin
         UpdateTag(ClickTag,Str(iXor(iGetTag(ClickTag),1)),0,1);
         if iXor(iGetTag(ClickTag),1)=0 then DevSendCmdLocal(DimRemote+'@Setting ACQ:SEQ ON')
         else DevSendCmdLocal(DimRemote+'@Setting ACQ:SEQ OFF');
        end;
        if ClickTag=AKIP.TRIG.EDGE.NREJ.tag then
        if IsEdgeTrigger then begin
         UpdateTag(ClickTag,Str(iXor(iGetTag(ClickTag),1)),0,1);
         if iXor(iGetTag(ClickTag),1)=0 then DevSendCmdLocal(DimRemote+'@Setting TRIG:EDGE:NREJ ON')
         else DevSendCmdLocal(DimRemote+'@Setting TRIG:EDGE:NREJ OFF');
        end else ShowWarning('Для изменения параметра переключите тип триггера на EDGE');
        if ClickTag=AKIP.TRIG.EDGE.COUP.tag then MenuTriggerCoup(ClickTag);
        if ClickTag=AKIP.TRIG.EDGE.HOLD.tag then MenuTriggerHOLD(ClickTag);
        if ClickTag=AKIP.TRIG.EDGE.HST.tag  then MenuTriggerHST(ClickTag);
        if ClickTag=AKIP.TRIG.EDGE.SLOP.tag then MenuTriggerSlop(ClickTag);
        if ClickTag=AKIP.TRIG.EDGE.SOUR.tag then MenuTriggerSour(ClickTag);
        if ClickTag=AKIP.CN1.COUP.tag then MenuChan1Coup(ClickTag);
        if ClickTag=AKIP.CN1.IMP.tag  then MenuChan1Imp(ClickTag);
        if ClickTag=AKIP.CN2.COUP.tag then MenuChan2Coup(ClickTag);
        if ClickTag=AKIP.CN2.IMP.tag  then MenuChan2Imp(ClickTag);
        if ClickTag=AKIP.CN3.COUP.tag then MenuChan3Coup(ClickTag);
        if ClickTag=AKIP.CN3.IMP.tag  then MenuChan3Imp(ClickTag);
        if ClickTag=AKIP.CN4.COUP.tag then MenuChan4Coup(ClickTag);
        if ClickTag=AKIP.CN4.IMP.tag  then MenuChan4Imp(ClickTag);
        if ClickTag=AKIP.ACQ.MDEP.tag  then MenuMaxMemory;
        if ClickTag=AKIP.ACQ.TYP.tag   then MenuTypeAcquisition(ClickTag);
        if ClickTag=AKIP.TIM.SCAL.tag  then MenuTimeScale(ClickTag);
        if ClickTag=AKIP.TRIG.MODE.tag then MenuTriggerMode(ClickTag);
        if ClickTag=AKIP.TRIG.TYP.tag  then MenuTriggerType(ClickTag);
        if ClickTag=AKIP.WAV.WIDT.tag  then MenuWaveOutForm(ClickTag);
        if ClickTag=AKIP.WAV.SOUR.tag  then MenuWaveFormSource(ClickTag);
        if ClickTag=AKIP.WAV.DATA.tag  then begin
         if iGetTagBitState(ClickTag,0) then n:=0 else n:=1;
         DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(ClickTag)+' '+Str(n));
         if AKIP.Simulator then DevSendCmdLocal('@TrigDone')
         else DevSendCmdLocal(DimRemote+'@GetWaveForm');
        end;
        if ClickTag=AKIP.TRIG.RUN.tag  then DevSendCmdLocal(DimRemote+'@TrigRun');
        if ClickTag=AKIP.TRIG.STOP.tag then DevSendCmdLocal(DimRemote+'@TrigStop');
        if ClickTag=AKIP.AUT.tag       then DevSendCmdLocal(DimRemote+'@Autoset')
       end else ShowWarning('Для изменения параметров включите опрос');
      end;
      {
      Select Plot & Tab windows by curve
      }
      ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
      if IsRefCurve(ClickCurve) then begin
       iNul(WinSelectByCurve(ClickCurve,ClickCurve));
       bNul(Voice(snd_Wheel));
      end;
      {
      Console commands
      }
      if LooksLikeCommand(ClickSensor) then begin
       DevPostCmd(devMySelf,url_decode(ClickSensor));
       bNul(Voice(snd_Click));
      end;
     end;
     {
     Handle remote clicks comes from DIM via @DimGuiClick message.
     @DimGuiClick default handler decode and write events to FIFO,
     so we can find it as ckicks and can handle it in usual way.
     }
     if ClickIsRemote then begin
      {
      Show time defference.
      }
      if DebugFlagEnabled(dfDetails) then
      Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
      {
      Handle remote console commands...
      }
      s:=Dim_GuiConsoleRecv(DevName,'');
      if LooksLikeCommand(s) then DevSendCmdLocal(s);
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling
  }
  if EditStateDone then begin
   if CheckEditTag(AKIP.CN1.SCAL.tag,s)        then DevSendCmdLocal(DimRemote+'@Setting CHAN1:SCAL '+s);
   if CheckEditTag(AKIP.CN2.SCAL.tag,s)        then DevSendCmdLocal(DimRemote+'@Setting CHAN2:SCAL '+s);
   if CheckEditTag(AKIP.CN3.SCAL.tag,s)        then DevSendCmdLocal(DimRemote+'@Setting CHAN3:SCAL '+s);
   if CheckEditTag(AKIP.CN4.SCAL.tag,s)        then DevSendCmdLocal(DimRemote+'@Setting CHAN4:SCAL '+s);
   if CheckEditTag(AKIP.CN1.OFFS.tag,s)        then DevSendCmdLocal(DimRemote+'@Setting CHAN1:OFFS '+s);
   if CheckEditTag(AKIP.CN2.OFFS.tag,s)        then DevSendCmdLocal(DimRemote+'@Setting CHAN2:OFFS '+s);
   if CheckEditTag(AKIP.CN3.OFFS.tag,s)        then DevSendCmdLocal(DimRemote+'@Setting CHAN3:OFFS '+s);
   if CheckEditTag(AKIP.CN4.OFFS.tag,s)        then DevSendCmdLocal(DimRemote+'@Setting CHAN4:OFFS '+s);
   if CheckEditTag(AKIP.TIM.DEL.tag,s)         then DevSendCmdLocal(DimRemote+'@Setting TIM:DEL '+s);
   if CheckEditTag(AKIP.TRIG.EDGE.HLDEV.tag,s) then DevSendCmdLocal(DimRemote+'@Setting TRIG:EDGE:HLDEV '+s);
   if CheckEditTag(AKIP.TRIG.EDGE.HLDT.tag,s)  then DevSendCmdLocal(DimRemote+'@Setting TRIG:EDGE:HLDT '+s);
   if CheckEditTag(AKIP.TRIG.EDGE.LEV.tag,s)   then DevSendCmdLocal(DimRemote+'@Setting TRIG:EDGE:LEV '+s);
   if CheckEditTag(AKIP.WAV.STAR.tag,s)        then DevSendCmdLocal(DimRemote+'@Setting WAV:STAR '+s);
   if CheckEditTag(AKIP.WAV.INT.tag,s)         then DevSendCmdLocal(DimRemote+'@Setting WAV:INT '+s);
   if CheckEditTag(AKIP.WAV.POIN.tag,s)        then DevSendCmdLocal(DimRemote+'@Setting WAV:POIN '+s);
   {
   Menu handlers
   }
   MenusHandler;
   {
   Warning, Information dialog completion
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end;
  if EditStateError then begin
   Problem('Dialog error detected!');
   EditReset;
  end;
  Cleanup;
 end;
 {
 AKIP cleanup
 }
 procedure AkipClear;
 begin
  AkipClearCmd;
  AKIP.CmdHash:=0;
  AKIP.Pipe.PipeId:=0;
  AKIP.Pipe.PipeName:='';
  AKIP.Pipe.PipePort:='';
  AKIP.Pipe.Req:='';
  AKIP.Pipe.Ans:='';
  AKIP.Pipe.Buf:='';
  AKIP.SelfId:='';
  AKIP.TagPrefix:='';
  AKIP.FilePrefix:='';
  AKIP.CalcDevName:='';
  bNul(sSetTag(AKIP.EXTRACTNUM.tag,''));
 end;
 {
 AKIP SIM Cleanup
 }
 procedure AkipClearSim;
 begin
  AKIP.SIM.IDENT:='';
  AKIP.SIM.ACQ_MDEP:='';
  AKIP.SIM.ACQ_SEQ:='';
  AKIP.SIM.ACQ_TYPE:='';
  AKIP.SIM.CN1_COUP:='';
  AKIP.SIM.CN2_COUP:='';
  AKIP.SIM.CN3_COUP:='';
  AKIP.SIM.CN4_COUP:='';
  AKIP.SIM.CN1_IMP:='';
  AKIP.SIM.CN2_IMP:='';
  AKIP.SIM.CN3_IMP:='';
  AKIP.SIM.CN4_IMP:='';
  AKIP.SIM.CN1_SWIT:='';
  AKIP.SIM.CN2_SWIT:='';
  AKIP.SIM.CN3_SWIT:='';
  AKIP.SIM.CN4_SWIT:='';
  AKIP.SIM.TRIG_MODE:='';
  AKIP.SIM.TRIG_STAT:='';
  AKIP.SIM.TRIG_TYPE:='';
  AKIP.SIM.TRIG_EDGE_COUP:='';
  AKIP.SIM.TRIG_EDGE_HOLD:='';
  AKIP.SIM.TRIG_EDGE_HST:='';
  AKIP.SIM.TRIG_EDGE_NREJ:='';
  AKIP.SIM.TRIG_EDGE_SLOP:='';
  AKIP.SIM.TRIG_EDGE_SOUR:='';
  AKIP.SIM.WAV_DATA:='';
  AKIP.SIM.WAV_SOUR:='';
  AKIP.SIM.WAV_WIDT:='';
 end;
 {
 AKIP initialization
 }
 procedure AkipInit;
 begin
  {
  Register error codes
  }
  AKIP.ecTimeOut:=RegisterErr(progname+': TimeOut');
  {
  Initialize channel, tags and dir waveform
  }
  AkipInitTags(ReadIni('tagPrefix'));
  bNul(sSetTag(AKIP.BASEDIR.tag,AdaptFileName(AddPathDelim(DaqFileRef(ReadIni('DefaultBaseDir'),'')))));
  bNul(sSetTag(AKIP.EXPDIR.tag,AdaptFileName(AddPathDelim(ReadIni('DefaultExpDir')))));
  bNul(sSetTag(AKIP.DEF.DIRBASE.tag,AdaptFileName(AddPathDelim(DaqFileRef(ReadIni('DefaultBaseDir'),'')))));
  bNul(sSetTag(AKIP.DEF.DIREXP.tag,AdaptFileName(AddPathDelim(ReadIni('DefaultExpDir')))));
  bNul(sSetTag(AKIP.EXTRACTNUM.tag,''));
  {
  Initialize variables
  }
  if DIM_IsServerMode then begin
   AKIP.Pipe.ReqTime:=0;
   AKIP.Pipe.AnsTime:=0;
   AKIP.Pipe.LastPoll:=0;
   AKIP.Pipe.Status:=st_NoReq;
   AKIP.GetWaveFormTimer:=0;
   AKIP.GetWaveFormSource:=0;
   AKIP.GetTrigStatusTimer:=0;
  end;
  {
  Initialize command table
  }
  AKIP.CmdHash:=HashList_Init(0);
  AkipInitCmd;
  {
  Read ini file
  }
  AKIP.CalcDevRef:=RefFind('Device '+ReadIni('CalcDevName'));
  if AKIP.CalcDevRef=0 then Trouble('Device not found') else begin
   Success('CalcDevName = '+ReadIni('CalcDevName'));
   AKIP.CalcDevName:=ReadIni('CalcDevName');
  end;
  if DIM_IsServerMode then begin
   AKIP.Pipe.PipeName:=ReadIni('HostName');                     Success('PipeName = '+AKIP.Pipe.PipeName);
   AKIP.Pipe.PipePort:=ReadIni('TCPPort');                      Success('PipePort = '+AKIP.Pipe.PipePort);
   AKIP.Pipe.TimeOut:=iValDef(ReadIni('PipeTimeOut'),1500);     Success('PipeTimeOut = '+Str(AKIP.Pipe.TimeOut));
   AKIP.Pipe.LongTimeOut:=iValDef(ReadIni('WaveTimeOut'),3000); Success('WaveTimeOut ='+Str(AKIP.Pipe.LongTimeOut));
   AKIP.Pipe.TimeGap:=iValDef(ReadIni('PipeTimeGap'),10);       Success('PipeTimeGap = '+Str(AKIP.Pipe.TimeGap));
   AKIP.Pipe.PollPeriod:=iValDef(ReadIni('PollPeriod'),100);    Success('PollPeriod = '+Str(AKIP.Pipe.PollPeriod));
   AKIP.Simulator:=iValDef(ReadIni('Simulator'),0)<>0;
   AKIP.TagPrefix:=ReadIni('tagPrefix');
   AKIP.FilePrefix:=ReadIni('filePrefix');
   {}
   if AKIP.Simulator then begin 
    InitSimulation;
    AKIP.Pipe.PipeID:=Pipe_Init('pipe '+ReadIni('tagPrefix'));
    AKIP.Pipe.PipeSIM:=Pipe_Init('pipe .\'+ReadIni('tagPrefix'));
    Success('Run simulator mode.')
   end else begin
    AKIP.Pipe.PipeID:=Pipe_Init('tcp port '+AKIP.Pipe.PipePort+' client '+AKIP.Pipe.PipeName);
    Success('Run as driver mode.');
   end;
  end;
  if DIM_IsServerMode then Success('Run server mode') else if DIM_IsClientMode then Success('Run client mode');
  {
  Sever Identifier
  }
  if DIM_IsServerMode
  then AKIP.SelfId:=Str(getpid)+'@'+ParamStr('HostName')
  else AKIP.SelfId:=Str(getpid)+'@'+ParamStr('ComputerName');
  
  {
  Set tags color
  }
  ColorNorm:=clAqua;
  if DIM_IsServerMode then ColorNorm:=clLime;
  if DIM_IsClientMode then ColorNorm:=clLime;
  ColorWarn:=clYellow;
  bNul(SetTagColor(AKIP.CLOCK.tag,ColorNorm));
  bNul(SetTagColor(AKIP.SERVID.tag,ColorNorm));
  bNul(SetTagColor(AKIP.TRIG.EDGE.COUP.tag,clSilver));
  bNul(SetTagColor(AKIP.TRIG.EDGE.HLDEV.tag,clSilver));
  bNul(SetTagColor(AKIP.TRIG.EDGE.HLDT.tag,clSilver));
  bNul(SetTagColor(AKIP.TRIG.EDGE.HOLD.tag,clSilver));
  bNul(SetTagColor(AKIP.TRIG.EDGE.HST.tag,clSilver));
  bNul(SetTagColor(AKIP.TRIG.EDGE.LEV.tag,clSilver));
  bNul(SetTagColor(AKIP.TRIG.EDGE.SLOP.tag,clSilver));
  bNul(SetTagColor(AKIP.TRIG.EDGE.SOUR.tag,clSilver));
 end;
 {
 AKIP finalization
 }
 procedure AkipFree;
 begin
  bNul(pipe_free(AKIP.Pipe.PipeId));
  if AKIP.Simulator then bNul(pipe_free(AKIP.Pipe.PipeSIM));
  if (AKIP.CmdHash<>0) then begin
   bNul(HashList_Free(AKIP.CmdHash));
   AKIP.CmdHash:=0;
  end;
 end;
 {
 Update trigger status
 }
 procedure TrigStatusUpdate;
  procedure AutoFree;
  begin
   bNul(pipe_txClear(AKIP.Pipe.PipeId));
   bNul(pipe_rxClear(AKIP.Pipe.PipeId));
   AKIP.Pipe.Req:='';
   AKIP.Pipe.Ans:='';
   AKIP.Pipe.Buf:='';
   AKIP.Pipe.ReqTime:=0;
   AKIP.Pipe.AnsTime:=0;
  end;
 begin
  if AKIP.GetTrigStatus=stt_trigNone then begin
  end else
  if AKIP.GetTrigStatus=stt_trigSetSingle then begin
   if not IsSameText(sGetTag(AKIP.TRIG.STAT.tag),'Ready') then begin
    DevSendCmdLocal(DimRemote+'@Setting TRIG:MODE SING');
    AKIP.GetTrigStatus:=stt_trigReady;
   end else AKIP.GetTrigStatus:=stt_trigGetWaveForm;
  end else
  if AKIP.GetTrigStatus=stt_trigReady then begin
   if IsSameText(sGetTag(AKIP.TRIG.STAT.tag),'Ready') then AKIP.GetTrigStatus:=stt_trigGetWaveForm
   else if msElapsedSinceMarker(AKIP.GetTrigStatusTimer)>tm_trigSetSingle then begin
    AKIP.GetTrigStatus:=stt_trigSetSingle;
    AKIP.GetTrigStatusTimer:=0;
   end;
  end else
  if AKIP.GetTrigStatus=stt_trigGetWaveForm then begin
   if IsSameText(sGetTag(AKIP.TRIG.STAT.tag),'Stop') then begin
    //AkipInitCmd;
    //DisablePollingExceptOf(cm_WAV_SOUR_Q);
    DevSendCmdLocal(DimRemote+'@GetWaveForm');
    AKIP.GetTrigStatus:=stt_trigDone;
   end;
  end else
  if AKIP.GetTrigStatus=stt_trigAuto then begin
   DisablePollingExceptOf(cm_TRIG_STAT_Q);
   EnableCmdNum(cm_WAV_SOUR_Q,true);
   EnableCmdNum(cm_IDEN,true);
   AKIP.GetTrigStatus:=stt_trigAutoWork;
  end else
  if AKIP.GetTrigStatus=stt_trigAutoWork then begin
   DevSendCmdLocal(DimRemote+'@GetWaveForm');
  end else
  if AKIP.GetTrigStatus=stt_trigAutoStop then begin
   //AkipFree;
   AutoFree;
   AKIP.GetTrigStatus:=stt_trigDone;
  end else
  if AKIP.GetTrigStatus=stt_trigDone then begin
   AkipInitCmd;
   AKIP.GetTrigStatus:=stt_trigNone;
  end;
 end;
 {
 AKIP polling
 }
 procedure AkipPoll;
 begin
  if DIM_IsServerMode then begin
   UpdateStateDevice;
   if AKIP.Simulator then begin
    if (pipe_connected(AKIP.Pipe.PipeSIM)>0) then begin
     if Pipe_Readln(AKIP.Pipe.PipeSIM,AKIP.Pipe.Ans,AKIP.Pipe.Buf) then AkipSim(AKIP.Pipe.Ans);
    end else Trouble('Pipe not connected');
   end;
   if SysTimer_Pulse(1000)>0 then begin
    bNul(iSetTag(AKIP.ERROR.CNT.tag,Round(GetErrCount(-1))));
    UpdateDo(do_ERROR_CNT,time,GetErrCount(-1));
    bNul(iSetTag(AKIP.POLL.RATE.tag,AKIP.Pipe.PollRate));
    UpdateDo(do_POLL_RATE,time ,AKIP.Pipe.PollRate);
    AKIP.Pipe.PollRate:=0;
    bNul(sSetTag(AKIP.CLOCK.tag,GetDateTime(mSecNow)));
    bNul(sSetTag(AKIP.SERVID.tag,AKIP.SelfId));
    bNul(SetTagColor(AKIP.CLOCK.tag,ColorNorm));
    bNul(SetTagColor(AKIP.SERVID.tag,ColorNorm));
   end;
   if mSecNow-FixmSecNow>DelayOnStart then AkipCmdCycle;
   TrigStatusUpdate;
   GetWaveFormData;
   DimUpdateState;
  end;
  if DIM_IsClientMode then begin
   if (ShouldRefresh(AKIP.CLOCK.dat,GetStampOfTag(AKIP.CLOCK.tag,0))>0) then begin
    AKIP.CLOCK.tim:=mSecNow;
    bNul(SetTagColor(AKIP.CLOCK.tag,ColorNorm));
    bNul(SetTagColor(AKIP.SERVID.tag,ColorNorm));
   end;
   if (mSecNow-AKIP.CLOCK.tim>DimDeadline) then begin
    bNul(sSetTag(AKIP.SERVID.tag,'Server Disconnected'));
    bNul(SetTagColor(AKIP.CLOCK.tag,ColorWarn));
    bNul(SetTagColor(AKIP.SERVID.tag,ColorWarn));
   end;
  end;
  AkipGUIHandler;
  AkipEdgeTrigTagColorUpdate;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  AkipClear;
  AkipClearSim;
  AkipFillTags(-MaxReal);
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  AkipInit;
  RunStartupScript;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then DevSendCmdLocal('@LoadIni');
  cmd_PrintCmdTable  :=RegisterStdInCmd('@PrintCmdTable',  '');
  cmd_Setting        :=RegisterStdInCmd('@Setting',        '');
  cmd_Edit           :=RegisterStdInCmd('@Edit',           '');
  cmd_LoadIni        :=RegisterStdInCmd('@LoadIni',        '');
  cmd_SaveIni        :=RegisterStdInCmd('@SaveIni',        '');
  cmd_AssignTag      :=RegisterStdInCmd('@AssignTag',      '');
  cmd_DimTagUpdate   :=RegisterStdInCmd('@DimTagUpdate',   '');
  cmd_GetWaveForm    :=RegisterStdInCmd('@GetWaveForm',    '');
  cmd_Autoset        :=RegisterStdInCmd('@Autoset',        '');
  cmd_TrigRun        :=RegisterStdInCmd('@TrigRun',        '');
  cmd_TrigStop       :=RegisterStdInCmd('@TrigStop',       '');
  cmd_DimCmdMy       :=RegisterStdInCmd('@DimCmdMy',       '');
  cmd_SingleStart    :=RegisterStdInCmd('@SingleStart',    '');
  cmd_SingleStop     :=RegisterStdInCmd('@SingleStop',     '');
  cmd_AutoSaveWvFrm  :=RegisterStdInCmd('@AutoSave',       '');
  cmd_AutoSaveStop   :=RegisterStdInCmd('@AutoStop',       '');
  cmd_SaveWaveForm   :=RegisterStdInCmd('@SaveWaveForm',   '');
  cmd_ModeCalcDev    :=RegisterStdInCmd('@ModeCalcDev',    '');
  cmd_TrigDone       :=RegisterStdInCmd('@TrigDone',       '');
  cmd_SetDirBase     :=RegisterStdInCmd('@SetDirBase',     '');
  cmd_SetDirExp      :=RegisterStdInCmd('@SetDirExp',      '');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
  RunFinallyScript;
  AkipFree;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  AkipPoll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,s,par:String; cmdid,tag,n:Integer;
  procedure Cleanup;
  begin
   cmd:=''; arg:=''; s:=''; par:='';
  end;
  procedure SettingCmd(n:Integer; s:String);
  begin
   if IsValidCmdNum(n) then begin
    Success(cmd+' '+AKIP.Cmd.Acronym[n]+' '+s);
    AKIP.Cmd.OpBuff[n]:=s;
   end;
  end;
  procedure AkipUpdateLoadIni;
  begin
   if (iGetTag(AKIP.POLL.ENABLE.tag)<>0) then begin
    DevPostCmdLocal('@Setting ACQ:MDEP '        +sGetTag(AKIP.ACQ.MDEP.tag));
    DevPostCmdLocal('@Setting ACQ:SEQ '         +str(iGetTag(AKIP.ACQ.SEQ.tag)));
    DevPostCmdLocal('@Setting ACQ:TYPE '        +sGetTag(AKIP.ACQ.TYP.tag));
    DevPostCmdLocal('@Setting CHAN1:COUP '      +sGetTag(AKIP.CN1.COUP.tag));
    DevPostCmdLocal('@Setting CHAN2:COUP '      +sGetTag(AKIP.CN2.COUP.tag));
    DevPostCmdLocal('@Setting CHAN3:COUP '      +sGetTag(AKIP.CN3.COUP.tag));
    DevPostCmdLocal('@Setting CHAN4:COUP '      +sGetTag(AKIP.CN4.COUP.tag));
    DevPostCmdLocal('@Setting CHAN1:IMP '       +sGetTag(AKIP.CN1.IMP.tag));
    DevPostCmdLocal('@Setting CHAN2:IMP '       +sGetTag(AKIP.CN2.IMP.tag));
    DevPostCmdLocal('@Setting CHAN3:IMP '       +sGetTag(AKIP.CN3.IMP.tag));
    DevPostCmdLocal('@Setting CHAN4:IMP '       +sGetTag(AKIP.CN4.IMP.tag));
    DevPostCmdLocal('@Setting CHAN1:OFFS '      +str(rGetTag(AKIP.CN1.OFFS.tag)));
    DevPostCmdLocal('@Setting CHAN2:OFFS '      +str(rGetTag(AKIP.CN2.OFFS.tag)));
    DevPostCmdLocal('@Setting CHAN3:OFFS '      +str(rGetTag(AKIP.CN3.OFFS.tag)));
    DevPostCmdLocal('@Setting CHAN4:OFFS '      +str(rGetTag(AKIP.CN4.OFFS.tag)));
    DevPostCmdLocal('@Setting CHAN1:SCAL '      +str(rGetTag(AKIP.CN1.SCAL.tag)));
    DevPostCmdLocal('@Setting CHAN2:SCAL '      +str(rGetTag(AKIP.CN2.SCAL.tag)));
    DevPostCmdLocal('@Setting CHAN3:SCAL '      +str(rGetTag(AKIP.CN3.SCAL.tag)));
    DevPostCmdLocal('@Setting CHAN4:SCAL '      +str(rGetTag(AKIP.CN4.SCAL.tag)));
    DevPostCmdLocal('@Setting CHAN1:SWIT '      +str(iGetTag(AKIP.CN1.SWIT.tag)));
    DevPostCmdLocal('@Setting CHAN2:SWIT '      +str(iGetTag(AKIP.CN2.SWIT.tag)));
    DevPostCmdLocal('@Setting CHAN3:SWIT '      +str(iGetTag(AKIP.CN3.SWIT.tag)));
    DevPostCmdLocal('@Setting CHAN4:SWIT '      +str(iGetTag(AKIP.CN4.SWIT.tag)));
    DevPostCmdLocal('@Setting TIM:DEL '         +str(rGetTag(AKIP.TIM.DEL.tag)));
    DevPostCmdLocal('@Setting TIM:SCAL '        +str(rGetTag(AKIP.TIM.SCAL.tag)));
    DevPostCmdLocal('@Setting TRIG:MODE '       +sGetTag(AKIP.TRIG.MODE.tag));
    DevPostCmdLocal('@Setting TRIG:TYPE '       +sGetTag(AKIP.TRIG.TYP.tag));
    DevPostCmdLocal('@Setting TRIG:EDGE:COUP '  +sGetTag(AKIP.TRIG.EDGE.COUP.tag));
    DevPostCmdLocal('@Setting TRIG:EDGE:HLDEV ' +str(iGetTag(AKIP.TRIG.EDGE.HLDEV.tag)));
    DevPostCmdLocal('@Setting TRIG:EDGE:HLDT '  +str(rGetTag(AKIP.TRIG.EDGE.HLDT.tag)));
    DevPostCmdLocal('@Setting TRIG:EDGE:HOLD '  +sGetTag(AKIP.TRIG.EDGE.HOLD.tag));
    DevPostCmdLocal('@Setting TRIG:EDGE:HST '   +sGetTag(AKIP.TRIG.EDGE.HST.tag));
    DevPostCmdLocal('@Setting TRIG:EDGE:LEV '   +str(rGetTag(AKIP.TRIG.EDGE.LEV.tag)));
    DevPostCmdLocal('@Setting TRIG:EDGE:NREJ '  +str(iGetTag(AKIP.TRIG.EDGE.NREJ.tag)));
    DevPostCmdLocal('@Setting TRIG:EDGE:SLOP '  +sGetTag(AKIP.TRIG.EDGE.SLOP.tag));
    DevPostCmdLocal('@Setting TRIG:EDGE:SOUR '  +sGetTag(AKIP.TRIG.EDGE.SOUR.tag));
    DevPostCmdLocal('@Setting WAV:INT '         +str(iGetTag(AKIP.WAV.INT.tag)));
    DevPostCmdLocal('@Setting WAV:POIN '        +str(iGetTag(AKIP.WAV.POIN.tag)));
    DevPostCmdLocal('@Setting WAV:SOUR '        +sGetTag(AKIP.WAV.SOUR.tag));
    DevPostCmdLocal('@Setting WAV:STAR '        +str(iGetTag(AKIP.WAV.STAR.tag)));
    DevPostCmdLocal('@Setting WAV:WIDT '        +sGetTag(AKIP.WAV.WIDT.tag));
   end;
  end;
  function GetOnOffStr:String;
  begin
   if IsSameText(s,'1') or IsSameText(s,'ON') then GetOnOffStr:='ON' else GetOnOffStr:='OFF';
  end;
  function GetImpStr:String;
  begin
   if IsSameText(s,'1,МОм') or IsSameText(s,'ONEM') then GetImpStr:='ONEM' else GetImpStr:='FIFT';
  end;
 begin
  Cleanup;
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  if GotCommandId(Data,cmd,arg,cmdid) then begin
  {
  @Setting
  }
   if (cmdid=cmd_Setting) then begin
    n:=AkipCmdFind(ExtractWord(1,arg));
    if IsValidCmdNum(n) then begin
     if WordCount(arg)>2
     then s:=ExtractWord(2,arg)+','+ExtractWord(3,arg)
     else s:=ExtractWord(2,arg);
     if (n=cm_ACQ_MDEP)        then SettingCmd(n,s);
     if (n=cm_ACQ_SEQ)         then SettingCmd(n,GetOnOffStr);
     if (n=cm_ACQ_SMPLRT_Q)    then SettingCmd(n,s);
     if (n=cm_ACQ_TYPE)        then SettingCmd(n,s);
     if (n=cm_CN1_COUP)        then SettingCmd(n,s);
     if (n=cm_CN2_COUP)        then SettingCmd(n,s);
     if (n=cm_CN3_COUP)        then SettingCmd(n,s);
     if (n=cm_CN4_COUP)        then SettingCmd(n,s);
     if (n=cm_CN1_IMP)         then SettingCmd(n,GetImpStr);
     if (n=cm_CN2_IMP)         then SettingCmd(n,GetImpStr);
     if (n=cm_CN3_IMP)         then SettingCmd(n,GetImpStr);
     if (n=cm_CN4_IMP)         then SettingCmd(n,GetImpStr);
     if (n=cm_CN1_OFFS)        then SettingCmd(n,s);
     if (n=cm_CN2_OFFS)        then SettingCmd(n,s);
     if (n=cm_CN3_OFFS)        then SettingCmd(n,s);
     if (n=cm_CN4_OFFS)        then SettingCmd(n,s);
     if (n=cm_CN1_SCAL)        then SettingCmd(n,s);
     if (n=cm_CN2_SCAL)        then SettingCmd(n,s);
     if (n=cm_CN3_SCAL)        then SettingCmd(n,s);
     if (n=cm_CN4_SCAL)        then SettingCmd(n,s);
     if (n=cm_CN1_SWIT)        then SettingCmd(n,GetOnOffStr);
     if (n=cm_CN2_SWIT)        then SettingCmd(n,GetOnOffStr);
     if (n=cm_CN3_SWIT)        then SettingCmd(n,GetOnOffStr);
     if (n=cm_CN4_SWIT)        then SettingCmd(n,GetOnOffStr);
     if (n=cm_TIM_DEL)         then SettingCmd(n,s);
     if (n=cm_TIM_SCAL)        then SettingCmd(n,s);
     if (n=cm_TRIG_RUN)        then SettingCmd(n,s);
     if (n=cm_TRIG_MODE)       then SettingCmd(n,s);
     if (n=cm_TRIG_TYPE)       then SettingCmd(n,s);
     if (n=cm_TRIG_STOP)       then SettingCmd(n,s);
     if (n=cm_TRIG_EDGE_COUP)  then SettingCmd(n,s);
     if (n=cm_TRIG_EDGE_HLDEV) then SettingCmd(n,s);
     if (n=cm_TRIG_EDGE_HLDT)  then SettingCmd(n,s);
     if (n=cm_TRIG_EDGE_HOLD)  then SettingCmd(n,s);
     if (n=cm_TRIG_EDGE_HST)   then SettingCmd(n,s);
     if (n=cm_TRIG_EDGE_LEV)   then SettingCmd(n,s);
     if (n=cm_TRIG_EDGE_NREJ)  then SettingCmd(n,GetOnOffStr);
     if (n=cm_TRIG_EDGE_SLOP)  then SettingCmd(n,s);
     if (n=cm_TRIG_EDGE_SOUR)  then SettingCmd(n,s);
     if (n=cm_WAV_DATA_Q)      then SettingCmd(n,s);
     if (n=cm_WAV_INT)         then SettingCmd(n,s);
     if (n=cm_WAV_MAXP_Q)      then SettingCmd(n,s);
     if (n=cm_WAV_POIN)        then SettingCmd(n,s);
     if (n=cm_WAV_SOUR)        then SettingCmd(n,s);
     if (n=cm_WAV_STAR)        then SettingCmd(n,s);
     if (n=cm_WAV_WIDT)        then SettingCmd(n,s);
     if (n=cm_AUT)             then SettingCmd(n,s);
    end;
    Data:='';
   end else
   {
   @Edit
   }
   if (cmdid=cmd_Edit) then begin
     par:=mime_decode(ExtractWord(2,arg));
     s:=ExtractWord(1,arg);
     tag:=FindTag(s);
     if IsChannelOn(AKIP.CN1) then begin
      if Pos('CN1.SCAL',s)>0  then StartEditTagEx(tag,'Введите значение вертикальной чувствительности',par);
      if Pos('CN1.OFFS',s)>0  then StartEditTagEx(tag,'Введите значение вертикального смещения',par);
     end else ShowWarning('Для работы с параметрами канала 1 включите канал');
     if IsChannelOn(AKIP.CN2) then begin
      if Pos('CN2.SCAL',s)>0  then StartEditTagEx(tag,'Введите значение вертикальной чувствительности',par);
      if Pos('CN2.OFFS',s)>0  then StartEditTagEx(tag,'Введите значение вертикального смещения',par);
     end else ShowWarning('Для работы с параметрами канала 2 включите канал');
     if IsChannelOn(AKIP.CN3) then begin
      if Pos('CN3.SCAL',s)>0  then StartEditTagEx(tag,'Введите значение вертикальной чувствительности',par);
      if Pos('CN3.OFFS',s)>0  then StartEditTagEx(tag,'Введите значение вертикального смещения',par);
     end else ShowWarning('Для работы с параметрами канала 3 включите канал');
     if IsChannelOn(AKIP.CN4) then begin
      if Pos('CN4.SCAL',s)>0  then StartEditTagEx(tag,'Введите значение вертикальной чувствительности',par);
      if Pos('CN4.OFFS',s)>0  then StartEditTagEx(tag,'Введите значение вертикального смещения',par);
     end else ShowWarning('Для работы с параметрами канала 4 включите канал');
     if Pos('TIM.DEL',s)>0    then StartEditTagEx(tag,'Введите значение временной задержки',par);
     if IsEdgeTrigger then begin
      if Pos('TRIG.EDGE.HLDEV',s)>0 then StartEditTagEx(tag,'Введите количество событий удерживания триггера',par);
      if Pos('TRIG.EDGE.HLDT',s)>0  then StartEditTagEx(tag,'Введите значение времени удержания триггера',par);
      if Pos('TRIG.EDGE.LEV',s)>0   then StartEditTagEx(tag,'Введите значение уровня триггера',par);
     end else ShowWarning('Для изменения параметра переключите тип триггера на EDGE');
     if Pos('WAV.STAR',s)>0   then StartEditTagEx(tag,'Введите начальную точку получения осциллограмм',par);
     if Pos('WAV.INT',s)>0    then StartEditTagEx(tag,'Введите интервал между точками осциллограмм',par);
     if Pos('WAV.POIN',s)>0   then StartEditTagEx(tag,'Введите количество точек для получения осциллограмм',par);
    Data:='';
   end else
   {
   @PrintCmdTable
   }
   if (cmdid=cmd_PrintCmdTable) then begin
    PrintCmdTable;
    Data:='';
   end else
   {
   @DimTagUpdate
   }
   if (cmdid=cmd_DimTagUpdate) then begin
    AkipOnDimUpdateTag(arg);
    Data:='';
   end else
   {
   @AssignTag
   }
   if (cmdid=cmd_AssignTag) then begin
    AkipOnAssignTag(arg);
    Data:='';
   end else
   {
   @GetWaveForm
   }
   if (cmdid=cmd_GetWaveForm) then begin
    if ((not IsEmptyStr(arg)) and (Val(arg)=0))
    then AKIP.GetWaveFormStatus:=stt_wfDone
    else begin
     DisablePollingExceptOf(cm_WAV_SOUR_Q);
     AKIP.IsWaveFormDataRequest:=true;
     AKIP.GetWaveFormStatus:=stt_wfGetSource;
     GetWaveFormData;
    end;
    Data:='';
   end else
   {
   @Autoset
   }
   if (cmdid=cmd_Autoset) then begin
    EnableCmdNum(cm_AUT,true);
    Data:='';
   end else
   {
   @TrigRun
   }
   if (cmdid=cmd_TrigRun) then begin
    EnableCmdNum(cm_TRIG_RUN,true);
    Data:='';
   end else
   {
   @TrigStop
   }
   if (cmdid=cmd_TrigStop) then begin
    EnableCmdNum(cm_TRIG_STOP,true);
    AKIP.GetTrigStatus:=stt_trigDone;
    Data:='';
   end else 
   {
   @SaveIni
   }
   if (cmdid=cmd_SaveIni) then begin
    if not AKIP.Simulator then iNul(CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg))));
    Data:='';
   end else
   {
   @LoadIni
   }
   if (cmdid=cmd_LoadIni) then begin
    if not AKIP.Simulator then 
    if CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg)))>0 then AkipUpdateLoadIni;
    Data:='';
   end else
   {
   @DimCmdMy
   }
   if (cmdid=cmd_DimCmdMy) then begin
     if LooksLikeCommand(trim(base64_decode(arg))) then begin
     DevSendCmdLocal(trim(base64_decode(arg)));
     Success('@DIMCMDMY='+cmd+' arg<'+trim(base64_decode(arg))+'>');
    end;
   end else
   {
   @SingleStart
   }
   if (cmdid=cmd_SingleStart) then begin
    if not IsEmptyStr(arg) then bNul(sSetTag(AKIP.OSCNAME.tag,arg))
    else bNul(sSetTag(AKIP.OSCNAME.tag,AKIP.FilePrefix));
    DisablePollingExceptOf(cm_TRIG_STAT_Q);
    EnableCmdNum(cm_TRIG_MODE,true);
    EnableCmdNum(cm_TRIG_MODE_Q,true);
    bNul(iSetTag(AKIP.WAVESAVESTT.tag,0));
    AKIP.GetTrigStatus:=stt_trigSetSingle;
   end else
   {
   @SingleStop
   }
   if (cmdid=cmd_SingleStop) then begin
    AKIP.GetTrigStatus:=stt_trigReady;
    DevSendCmdLocal(DimRemote+'@Setting TRIG:MODE STOP');
    AkipInitCmd;
   end else
   {
   @AutoSave
   }
   if (cmdid=cmd_AutoSaveWvFrm) then begin
    AKIP.AutoSaveMode:=true;
    AKIP.GetTrigStatus:=stt_trigAuto;
   end else
   {
   @AutoStop
   }
   if (cmdid=cmd_AutoSaveStop) then begin
    AKIP.AutoSaveMode:=false;
    AKIP.GetTrigStatus:=stt_trigAutoStop;
   end else
   {
   @TrigDone - !!! ONLY SIMULATOR !!!
   }
   if (cmdid=cmd_TrigDone) then begin
   if AKIP.Simulator then begin
    AKIP.IsWaveFormDataRequest:=true;
    AKIP.GetTrigStatus:=stt_trigDone;
    DevSendCmdLocal(DimRemote+'@Setting TRIG:MODE STOP');
    AKIP.GetWaveFormStatus:=stt_wfDone;
    GetWaveFormData;
   end else begin
    ShowWarning('Функция работает только в режиме симмулятора');
   end;
   end else
   {
   @SaveWaveForm
   }
   if (cmdid=cmd_SaveWaveForm) then begin
    SaveWaveForm;
   end else
   {
   @ModeCalcDev
   }
   if (cmdid=cmd_ModeCalcDev) then begin
    DevSendCmd(AKIP.CalcDevRef,'@DeviceMode '+arg);
   end else
   {}
   if (cmdid=cmd_SetDirBase) then begin
    SetDirBase(arg);
   end else
   {}
   if (cmdid=cmd_SetDirExp) then begin
    SetDirExp(arg);
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  Cleanup;
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
