////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2025 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWDAQ.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Main project file for crwdaq system.                                       //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 1996xxxx - Created by A.K. - Crw16  for DOS DPMI  (BP7), initial           //
// 2001xxxx - Created by A.K. - Crw32  for Win32 (Delphi5), inherited Crw16   //
// 2024xxxx - Created by A.K. - Crwdaq for Win/Unix  (FPC), inherited Crw32   //
////////////////////////////////////////////////////////////////////////////////

program crwdaq; // CuRve(s) in Window(s) - for Data AcQuisition.

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

{--$DEFINE CRW_DAQ_TEST}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math, regexpr,
 Interfaces, // this includes the LCL widgetset
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd, Printers,
 lcltype, lclintf, zcomponent, printer4lazarus,
 _crw_alloc,
 _crw_atomic,
 _crw_critsect,
 _crw_tslist,
 _crw_cmdargs,
 _crw_environ,
 _crw_fpu,
 _crw_ef,
 _crw_zm,
 _crw_svd,
 _crw_rtc,
 _crw_fifo,
 _crw_sort,
 _crw_str,
 _crw_utf8,
 _crw_geoid,
 _crw_lngid,
 _crw_fio,
 _crw_dbglog,
 _crw_syslog,
 _crw_base64,
 _crw_base32,
 _crw_crypt,
 pcrelib,
 perlregex,
 _crw_regexp,
 _crw_bsencode,
 _crw_hash,
 _crw_meta,
 _crw_hl,
 _crw_pio,
 _crw_uart,
 _crw_serio,
 _crw_sharm,
 _crw_pipe,
 _crw_lm,
 _crw_tcp,
 _crw_pipeio,
 _crw_plut,
 _crw_colors,
 _crw_bmpcache,
 _crw_eldraw,
 _crw_delauna,
 _crw_procps,
 _crw_pscap,
 _crw_wmic,
 _crw_proc,
 _crw_assoc,
 _crw_mimeapps,
 _crw_mimeglob,
 _crw_polling,
 _crw_task,
 _crw_mmt,
 _crw_wmctrl,
 _crw_ee,
 _crw_syscal,
 _crw_dynar,
 _crw_rtdtc,
 _crw_couple,
 _crw_spline,
 _crw_lsqpoly,
 _crw_funmin,
 _crw_lsqmin,
 _crw_simplex,
 _crw_curves,
 _crw_lttb,
 _crw_calib,
 _crw_riff,
 _crw_snd,
 _crw_spk,
 _crw_guard,
 _crw_spcfld,
 _crw_fonts,
 _crw_sysid,
 _crw_deref,
 _crw_appforms,
 _crw_apptools,
 _crw_apputils,
 _crw_appmodal,
 _crw_rfadata,
 _crw_prmstrlst,
 _crw_uri,
 _crw_sect,
 _crw_gloss,
 _crw_daqtags,
 _crw_daqevnt,
 _crw_daqsys,
 _crw_crwdaq,
 _crw_daqdev,
 _crw_adamdev,
 _crw_pcldev,
 _crw_i8255,
 _crw_daqdio144device,
 _crw_softdev,
 _crw_softdevscript,
 _crw_softdevdialog,
 _crw_softdevconstgenerator,
 _crw_softdevbitsetgenerator,
 _crw_daqpascaldevice,
 _crw_daqpascalcompiler,
 _crw_daqpascalruntime,
 _crw_daqreaddat,
 _crw_peaksearch,
 _crw_stopion,
 _crw_dcc32,
 _crw_fpcup,
 _crw_crwapi,
 _crw_if_masters,
 _crw_crwapiserver,
 _crw_plugin_wrapper,
 _crw_uac,
 _crw_fsm,
 _crw_wine,
 _crw_vbox,
 _crw_adodb_tlb,
 _crw_dbapi,
 _crw_dbcon,
 _crw_lmd,
 _crw_az,
 ptembed,
 _crw_memo,
 _crw_flgrd,
 _crw_sever,
 {$IFDEF SKIP_DRAFT}
 Poligon,
 _crw_intlcks,
 {$ENDIF ~SKIP_DRAFT}
 form_calculator,
 form_uartterminal,
 form_listboxselection,
 form_recodecodepagedialog,
 form_checklistboxselection,
 form_stringgrideditdialog,
 form_regexpcalculator,
 form_databasebrowser,
 form_secretservice,
 form_logindialog,
 form_calibdialog,
 form_voicepreset,
 form_crwdaqsyschild,
 form_consolewindow,
 form_circuitwindow,
 form_tabwindow,
 form_tabwindowformatdialog,
 form_texteditor,
 form_texteditdialog,
 form_textfinddialog,
 form_textreplacedialog,
 form_texteditortemplates,
 form_curvetools,
 form_curvewindow,
 form_curvebyformula,
 form_curvestyledialog,
 form_curverangeselector,
 form_curveeditwindowstyledialog,
 form_curveeditdownsamplingdialog,
 form_curvetoolsrunmacrodialog,
 form_curvetoolswritetabledialog,
 form_curvetoolsreadtabledialog,
 form_curvetoolsrunplugindialog,
 form_surfwindow,
 form_surfbyformula,
 form_surfwindowstyledialog,
 form_surfwindowclipdialog,
 form_surftoolssmoothingdialog,
 form_spectrwindow,
 form_daqcontroldialog,
 form_daqhistorywarning,
 form_daqhelpviewer,
 form_daqdatetimecalculator,
 form_daqhistlendialog,
 form_daqwinoperdialog,
 form_daqopendynamicwindowdialog,
 form_daqmedianfilterdialog,
 form_daqedittagdialog,
 form_daqdevicecontrol,
 form_daqdevicecommonpropertydialog,
 form_constgeneratorpropertydialog,
 form_daqdialogdevice,
 form_daqpascaleditor,
 form_daqpascalpropertydialog,
 form_bitsetgeneratorpropertydialog,
 form_daqreaddat,
 form_daqpoint2dedit,
 form_daqcurvesmoothing,
 form_rfamendeleevtable,
 form_spectrdaqwindow,
 form_spectrpikwindow,
 form_spectrpikcontrol,
 form_spectrmanfitwindow,
 form_spectrmanfitcontrol,
 form_spectrmanfitbreaker,
 form_spectrzonfitwindow,
 form_spectrzonfitcontrol,
 form_spectrzonfitroiviewer,
 form_spectrzonfitzonviewer,
 form_spectrzonfitbreaker,
 form_spectrfitpreset,
 form_spectrpeakinpreset,
 form_spectrzonfitdiagnos,
 form_spectrzonfiteditpeak,
 form_spectrzonfiteditground,
 form_spectrzonfitroiremovebugs,
 form_spectrrfabfpwindow,
 form_spectranalysisrfabfpjobwizard,
 form_nsiswindow,
 form_termwindow,
 form_delphiprojecteditor,
 form_lazarusprojecteditor,
 _crw_pascalprojects,
 form_createnewprojectfromsample,
 form_createnewdataanalysisplugin,
 form_editdataanalysispluginarguments,
 form_mistimingservice,
 unit_keyboardlayout,
 unit_readoldcrwfiles,
 unit_resourcemonitorconsole,
 unit_crwdaqmessages,
 unit_systemconsole,
 form_crwdaqwatchdog,
 form_crwdaqbuglist,
 form_crwdaqlogo,
 form_crwdaq,
 _crw_sesman,
 unit_crwdaq_common,
 unit_crwdaq_session;

{$R *.res}

exports GetMemoryManager; // required for using plugins *.dll or *.so

begin
 if not StartSession('$ 1') then
 with SessionManager do begin
  if (DetectRunningPid(0)>0)
  then writeln('SessionManager: ',SessionID,' already running.')
  else writeln('SessionManager: Could not init '+SessionID+'.');
  ExitCode:=1;
  Exit;
 end;
 RequireDerivedFormResource:=True;
 //Application.DoubleBuffered:=adbTrue;
  Application.Scaled:=True;
 Application.Initialize;
 Application.TaskBarBehavior:=tbSingleButton;
 Application.CreateForm(TFormCrwDaq,FormCrwDaq);
 FormCrwDaq.Master:=@FormCrwDaq;
 Application.Run;
end.

//////////////
// END OF FILE
//////////////

