package spark.primitives
{
   import spark.primitives.supportClasses.FilledElement;
   import mx.core.mx_internal;
   import flash.geom.Rectangle;
   import flash.geom.Matrix;
   import mx.utils.MatrixUtil;
   import flash.display.Graphics;
   import mx.utils.GraphicsUtil;
   import flash.geom.Point;
   
   use namespace mx_internal;
   
   public class Rect extends FilledElement
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      private var _bottomLeftRadiusX:Number;
      
      private var _bottomLeftRadiusY:Number;
      
      private var _bottomRightRadiusX:Number;
      
      private var _bottomRightRadiusY:Number;
      
      private var _radiusX:Number = 0;
      
      private var _radiusY:Number = 0;
      
      private var _topLeftRadiusX:Number;
      
      private var _topLeftRadiusY:Number;
      
      private var _topRightRadiusX:Number;
      
      private var _topRightRadiusY:Number;
      
      public function Rect()
      {
         super();
      }
      
      private static function getRoundRectBoundingBox(width:Number, height:Number, r:Rect, m:Matrix) : Rectangle
      {
         var boundingBox:Rectangle = null;
         var rX:Number = NaN;
         var rY:Number = NaN;
         var radiusValue:Function = function(def:Number, value:Number, max:Number):Number
         {
            var result:Number = !!isNaN(value)?Number(def):Number(value);
            return Math.min(result,max);
         };
         var maxRadiusX:Number = width / 2;
         var maxRadiusY:Number = height / 2;
         var radiusX:Number = r.radiusX;
         var radiusY:Number = r.radiusY == 0?Number(radiusX):Number(r.radiusY);
         rX = radiusValue(radiusX,r.topLeftRadiusX,maxRadiusX);
         rY = radiusValue(rX,r.topLeftRadiusY,maxRadiusY);
         boundingBox = MatrixUtil.getEllipseBoundingBox(rX,rY,rX,rY,m,boundingBox);
         rX = radiusValue(radiusX,r.topRightRadiusX,maxRadiusX);
         rY = radiusValue(rX,r.topRightRadiusY,maxRadiusY);
         boundingBox = MatrixUtil.getEllipseBoundingBox(width - rX,rY,rX,rY,m,boundingBox);
         rX = radiusValue(radiusX,r.bottomRightRadiusX,maxRadiusX);
         rY = radiusValue(rX,r.bottomRightRadiusY,maxRadiusY);
         boundingBox = MatrixUtil.getEllipseBoundingBox(width - rX,height - rY,rX,rY,m,boundingBox);
         rX = radiusValue(radiusX,r.bottomLeftRadiusX,maxRadiusX);
         rY = radiusValue(rX,r.bottomLeftRadiusY,maxRadiusY);
         boundingBox = MatrixUtil.getEllipseBoundingBox(rX,height - rY,rX,rY,m,boundingBox);
         return boundingBox;
      }
      
      [Inspectable(minValue="0.0",category="General")]
      public function get bottomLeftRadiusX() : Number
      {
         return this._bottomLeftRadiusX;
      }
      
      public function set bottomLeftRadiusX(value:Number) : void
      {
         if(value != this._bottomLeftRadiusX)
         {
            this._bottomLeftRadiusX = value;
            invalidateSize();
            invalidateDisplayList();
            invalidateParentSizeAndDisplayList();
         }
      }
      
      [Inspectable(minValue="0.0",category="General")]
      public function get bottomLeftRadiusY() : Number
      {
         return this._bottomLeftRadiusY;
      }
      
      public function set bottomLeftRadiusY(value:Number) : void
      {
         if(value != this._bottomLeftRadiusY)
         {
            this._bottomLeftRadiusY = value;
            invalidateSize();
            invalidateDisplayList();
            invalidateParentSizeAndDisplayList();
         }
      }
      
      [Inspectable(minValue="0.0",category="General")]
      public function get bottomRightRadiusX() : Number
      {
         return this._bottomRightRadiusX;
      }
      
      public function set bottomRightRadiusX(value:Number) : void
      {
         if(value != this.bottomRightRadiusX)
         {
            this._bottomRightRadiusX = value;
            invalidateSize();
            invalidateDisplayList();
            invalidateParentSizeAndDisplayList();
         }
      }
      
      [Inspectable(minValue="0.0",category="General")]
      public function get bottomRightRadiusY() : Number
      {
         return this._bottomRightRadiusY;
      }
      
      public function set bottomRightRadiusY(value:Number) : void
      {
         if(value != this._bottomRightRadiusY)
         {
            this._bottomRightRadiusY = value;
            invalidateSize();
            invalidateDisplayList();
            invalidateParentSizeAndDisplayList();
         }
      }
      
      [Inspectable(minValue="0.0",category="General")]
      public function get radiusX() : Number
      {
         return this._radiusX;
      }
      
      public function set radiusX(value:Number) : void
      {
         if(value != this._radiusX)
         {
            this._radiusX = value;
            invalidateSize();
            invalidateDisplayList();
            invalidateParentSizeAndDisplayList();
         }
      }
      
      [Inspectable(minValue="0.0",category="General")]
      public function get radiusY() : Number
      {
         return this._radiusY;
      }
      
      public function set radiusY(value:Number) : void
      {
         if(value != this._radiusY)
         {
            this._radiusY = value;
            invalidateSize();
            invalidateDisplayList();
            invalidateParentSizeAndDisplayList();
         }
      }
      
      [Inspectable(minValue="0.0",category="General")]
      public function get topLeftRadiusX() : Number
      {
         return this._topLeftRadiusX;
      }
      
      public function set topLeftRadiusX(value:Number) : void
      {
         if(value != this._topLeftRadiusX)
         {
            this._topLeftRadiusX = value;
            invalidateSize();
            invalidateDisplayList();
            invalidateParentSizeAndDisplayList();
         }
      }
      
      [Inspectable(minValue="0.0",category="General")]
      public function get topLeftRadiusY() : Number
      {
         return this._topLeftRadiusY;
      }
      
      public function set topLeftRadiusY(value:Number) : void
      {
         if(value != this._topLeftRadiusY)
         {
            this._topLeftRadiusY = value;
            invalidateSize();
            invalidateDisplayList();
            invalidateParentSizeAndDisplayList();
         }
      }
      
      [Inspectable(minValue="0.0",category="General")]
      public function get topRightRadiusX() : Number
      {
         return this._topRightRadiusX;
      }
      
      public function set topRightRadiusX(value:Number) : void
      {
         if(value != this.topRightRadiusX)
         {
            this._topRightRadiusX = value;
            invalidateSize();
            invalidateDisplayList();
            invalidateParentSizeAndDisplayList();
         }
      }
      
      [Inspectable(minValue="0.0",category="General")]
      public function get topRightRadiusY() : Number
      {
         return this._topRightRadiusY;
      }
      
      public function set topRightRadiusY(value:Number) : void
      {
         if(value != this._topRightRadiusY)
         {
            this._topRightRadiusY = value;
            invalidateSize();
            invalidateDisplayList();
            invalidateParentSizeAndDisplayList();
         }
      }
      
      override protected function draw(g:Graphics) : void
      {
         var rX:Number = NaN;
         var rY:Number = NaN;
         if(Boolean(!isNaN(this.topLeftRadiusX)) || Boolean(!isNaN(this.topRightRadiusX)) || Boolean(!isNaN(this.bottomLeftRadiusX)) || Boolean(!isNaN(this.bottomRightRadiusX)))
         {
            GraphicsUtil.drawRoundRectComplex2(g,drawX,drawY,width,height,this.radiusX,this.radiusY,this.topLeftRadiusX,this.topLeftRadiusY,this.topRightRadiusX,this.topRightRadiusY,this.bottomLeftRadiusX,this.bottomLeftRadiusY,this.bottomRightRadiusX,this.bottomRightRadiusY);
         }
         else if(this.radiusX != 0)
         {
            rX = this.radiusX;
            rY = this.radiusY == 0?Number(this.radiusX):Number(this.radiusY);
            g.drawRoundRect(drawX,drawY,width,height,rX * 2,rY * 2);
         }
         else
         {
            g.drawRect(drawX,drawY,width,height);
         }
      }
      
      override protected function transformWidthForLayout(width:Number, height:Number, postLayoutTransform:Boolean = true) : Number
      {
         if(Boolean(postLayoutTransform) && Boolean(hasComplexLayoutMatrix))
         {
            width = getRoundRectBoundingBox(width,height,this,layoutFeatures.layoutMatrix).width;
         }
         return width + getStrokeExtents(postLayoutTransform).width;
      }
      
      override protected function transformHeightForLayout(width:Number, height:Number, postLayoutTransform:Boolean = true) : Number
      {
         if(Boolean(postLayoutTransform) && Boolean(hasComplexLayoutMatrix))
         {
            height = getRoundRectBoundingBox(width,height,this,layoutFeatures.layoutMatrix).height;
         }
         return height + getStrokeExtents(postLayoutTransform).height;
      }
      
      override public function getBoundsXAtSize(width:Number, height:Number, postLayoutTransform:Boolean = true) : Number
      {
         var strokeExtents:Rectangle = getStrokeExtents(postLayoutTransform);
         var m:Matrix = getComplexMatrix(postLayoutTransform);
         if(!m)
         {
            return strokeExtents.left + this.x;
         }
         if(!isNaN(width))
         {
            width = width - strokeExtents.width;
         }
         if(!isNaN(height))
         {
            height = height - strokeExtents.height;
         }
         var newSize:Point = MatrixUtil.fitBounds(width,height,m,preferredWidthPreTransform(),preferredHeightPreTransform(),minWidth,minHeight,maxWidth,maxHeight);
         if(!newSize)
         {
            newSize = new Point(minWidth,minHeight);
         }
         return strokeExtents.left + getRoundRectBoundingBox(newSize.x,newSize.y,this,m).x;
      }
      
      override public function getBoundsYAtSize(width:Number, height:Number, postLayoutTransform:Boolean = true) : Number
      {
         var strokeExtents:Rectangle = getStrokeExtents(postLayoutTransform);
         var m:Matrix = getComplexMatrix(postLayoutTransform);
         if(!m)
         {
            return strokeExtents.top + this.y;
         }
         if(!isNaN(width))
         {
            width = width - strokeExtents.width;
         }
         if(!isNaN(height))
         {
            height = height - strokeExtents.height;
         }
         var newSize:Point = MatrixUtil.fitBounds(width,height,m,preferredWidthPreTransform(),preferredHeightPreTransform(),minWidth,minHeight,maxWidth,maxHeight);
         if(!newSize)
         {
            newSize = new Point(minWidth,minHeight);
         }
         return strokeExtents.top + getRoundRectBoundingBox(newSize.x,newSize.y,this,m).y;
      }
      
      override public function getLayoutBoundsX(postLayoutTransform:Boolean = true) : Number
      {
         var stroke:Number = getStrokeExtents(postLayoutTransform).left;
         if(Boolean(postLayoutTransform) && Boolean(hasComplexLayoutMatrix))
         {
            return stroke + getRoundRectBoundingBox(width,height,this,layoutFeatures.layoutMatrix).x;
         }
         return stroke + this.x;
      }
      
      override public function getLayoutBoundsY(postLayoutTransform:Boolean = true) : Number
      {
         var stroke:Number = getStrokeExtents(postLayoutTransform).top;
         if(Boolean(postLayoutTransform) && Boolean(hasComplexLayoutMatrix))
         {
            return stroke + getRoundRectBoundingBox(width,height,this,layoutFeatures.layoutMatrix).y;
         }
         return stroke + this.y;
      }
   }
}
