package spark.primitives
{
   import spark.primitives.supportClasses.FilledElement;
   import mx.core.mx_internal;
   import flash.geom.Point;
   import flash.display.GraphicsPath;
   import flash.geom.Rectangle;
   import flash.geom.Matrix;
   import mx.utils.MatrixUtil;
   import mx.graphics.IStroke;
   import flash.display.Graphics;
   import mx.events.PropertyChangeEvent;
   
   use namespace mx_internal;
   
   public class Path extends FilledElement
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static var tangent:Point = new Point();
       
      private var graphicsPathChanged:Boolean = true;
      
      private var segments:PathSegmentsCollection;
      
      mx_internal var graphicsPath:GraphicsPath;
      
      private var _data:String;
      
      private var _winding:String = "evenOdd";
      
      private var _boundingBoxCached:Rectangle;
      
      private var _boundingBoxMatrixCached:Matrix;
      
      private var _boundingBoxWidthParamCached:Number;
      
      private var _boundingBoxHeightParamCached:Number;
      
      private var _boundingBoxX:Number;
      
      private var _boundingBoxY:Number;
      
      private var _drawBounds:Rectangle;
      
      public function Path()
      {
         this.graphicsPath = new GraphicsPath(new Vector.<int>(),new Vector.<Number>());
         this._drawBounds = new Rectangle();
         super();
      }
      
      [Inspectable(category="General")]
      public function set data(value:String) : void
      {
         if(this._data == value)
         {
            return;
         }
         this.segments = new PathSegmentsCollection(value);
         this.graphicsPathChanged = true;
         this.clearCachedBoundingBoxWithStroke();
         invalidateSize();
         invalidateDisplayList();
         this._data = value;
      }
      
      public function get data() : String
      {
         return this._data;
      }
      
      public function set winding(value:String) : void
      {
         if(this._winding != value)
         {
            this._winding = value;
            this.graphicsPathChanged = true;
            invalidateDisplayList();
         }
      }
      
      public function get winding() : String
      {
         return this._winding;
      }
      
      private function getBounds() : Rectangle
      {
         return Boolean(this.segments)?this.segments.getBounds():new Rectangle();
      }
      
      override protected function measure() : void
      {
         var bounds:Rectangle = null;
         bounds = this.getBounds();
         measuredWidth = bounds.width;
         measuredHeight = bounds.height;
         measuredX = bounds.left;
         measuredY = bounds.top;
      }
      
      private function getBoundingBoxWithStroke(width:Number, height:Number, m:Matrix) : Rectangle
      {
         if(Boolean(this._boundingBoxCached) && Boolean(this._boundingBoxWidthParamCached == width) && Boolean(this._boundingBoxHeightParamCached == height))
         {
            if(Boolean(!m) && Boolean(!this._boundingBoxMatrixCached))
            {
               this._boundingBoxCached.x = this._boundingBoxX;
               this._boundingBoxCached.y = this._boundingBoxY;
               return this._boundingBoxCached;
            }
            if(Boolean(m && this._boundingBoxMatrixCached && m.a == this._boundingBoxMatrixCached.a && m.b == this._boundingBoxMatrixCached.b) && Boolean(m.c == this._boundingBoxMatrixCached.c) && Boolean(m.d == this._boundingBoxMatrixCached.d))
            {
               this._boundingBoxCached.x = this._boundingBoxX + m.tx;
               this._boundingBoxCached.y = this._boundingBoxY + m.ty;
               return this._boundingBoxCached;
            }
         }
         if(m)
         {
            this._boundingBoxMatrixCached = m.clone();
            this._boundingBoxMatrixCached.tx = 0;
            this._boundingBoxMatrixCached.ty = 0;
         }
         else
         {
            this._boundingBoxMatrixCached = null;
         }
         this._boundingBoxWidthParamCached = width;
         this._boundingBoxHeightParamCached = height;
         this._boundingBoxCached = this.computeBoundsWithStroke(this._boundingBoxWidthParamCached,this._boundingBoxHeightParamCached,m);
         this._boundingBoxX = this._boundingBoxCached.x - (Boolean(m)?m.tx:0);
         this._boundingBoxY = this._boundingBoxCached.y - (Boolean(m)?m.ty:0);
         return this._boundingBoxCached;
      }
      
      private function tangentIsValid(prevSegment:PathSegment, curSegment:PathSegment, sx:Number, sy:Number, m:Matrix) : Boolean
      {
         curSegment.getTangent(prevSegment,true,sx,sy,m,tangent);
         return Boolean(tangent.x != 0) || Boolean(tangent.y != 0);
      }
      
      mx_internal function computeBoundsWithStroke(width:Number, height:Number, m:Matrix) : Rectangle
      {
         var pathBBox:Rectangle = null;
         var end:int = 0;
         var startSegment:PathSegment = null;
         var endSegment:PathSegment = null;
         var prevSegment:PathSegment = null;
         var naturalBounds:Rectangle = this.getBounds();
         var sx:Number = naturalBounds.width == 0?Number(1):Number(width / naturalBounds.width);
         var sy:Number = naturalBounds.height == 0?Number(1):Number(height / naturalBounds.height);
         if(Boolean(!m) || Boolean(MatrixUtil.isDeltaIdentity(m)) || Boolean(!this.segments))
         {
            pathBBox = new Rectangle(naturalBounds.x * sx,naturalBounds.y * sy,naturalBounds.width * sx,naturalBounds.height * sy);
            if(m)
            {
               pathBBox.offset(m.tx,m.ty);
            }
         }
         else
         {
            pathBBox = this.segments.getBoundingBox(width,height,m);
         }
         var strokeSettings:IStroke = this.stroke;
         if(Boolean(!strokeSettings) || Boolean(!this.segments))
         {
            return pathBBox;
         }
         var strokeExtents:Rectangle = getStrokeExtents();
         pathBBox.inflate(strokeExtents.right,strokeExtents.bottom);
         var seg:Vector.<PathSegment> = this.segments.data;
         if(Boolean(strokeSettings.joints != "miter") || Boolean(seg.length < 2))
         {
            return pathBBox;
         }
         var halfWeight:Number = strokeExtents.width / 2;
         var miterLimit:Number = Math.max(1,strokeSettings.miterLimit);
         var count:int = seg.length;
         var start:int = 0;
         var lastMoveX:Number = 0;
         var lastMoveY:Number = 0;
         var lastOpenSegment:int = 0;
         while(true)
         {
            while(Boolean(start < count) && Boolean(!(seg[start] is MoveSegment)))
            {
               prevSegment = start > 0?seg[start - 1]:null;
               if(this.tangentIsValid(prevSegment,seg[start],sx,sy,m))
               {
                  break;
               }
               start++;
            }
            if(start >= count)
            {
               break;
            }
            startSegment = seg[start];
            if(startSegment is MoveSegment)
            {
               lastOpenSegment = start + 1;
               lastMoveX = startSegment.x;
               lastMoveY = startSegment.y;
               start++;
            }
            else
            {
               if((Boolean(start == count - 1) || Boolean(seg[start + 1] is MoveSegment)) && Boolean(startSegment.x == lastMoveX) && Boolean(startSegment.y == lastMoveY))
               {
                  end = lastOpenSegment;
               }
               else
               {
                  end = start + 1;
               }
               while(Boolean(end < count) && Boolean(!(seg[end] is MoveSegment)))
               {
                  if(this.tangentIsValid(startSegment,seg[end],sx,sy,m))
                  {
                     break;
                  }
                  end++;
               }
               if(end >= count)
               {
                  break;
               }
               endSegment = seg[end];
               if(!(endSegment is MoveSegment))
               {
                  this.addMiterLimitStrokeToBounds(start > 0?seg[start - 1]:null,startSegment,endSegment,miterLimit,halfWeight,sx,sy,m,pathBBox);
               }
               start = start > end?int(start + 1):int(end);
            }
         }
         return pathBBox;
      }
      
      override protected function getStrokeBounds() : Rectangle
      {
         return this.getBoundingBoxWithStroke(width,height,null);
      }
      
      override protected function get needsDisplayObject() : Boolean
      {
         return Boolean(super.needsDisplayObject) || Boolean(stroke) && Boolean(stroke.joints == "miter");
      }
      
      private function addMiterLimitStrokeToBounds(segment0:PathSegment, segment1:PathSegment, segment2:PathSegment, miterLimit:Number, weight:Number, sx:Number, sy:Number, m:Matrix, result:Rectangle) : void
      {
         var pt:Point = null;
         var bisectLength:Number = NaN;
         var pt0:Point = null;
         var pt1:Point = null;
         var strokeTip:Point = null;
         pt = MatrixUtil.transformPoint(segment1.x * sx,segment1.y * sy,m).clone();
         var jointX:Number = pt.x;
         var jointY:Number = pt.y;
         var t0:Point = new Point();
         segment1.getTangent(segment0,false,sx,sy,m,t0);
         var t1:Point = new Point();
         segment2.getTangent(segment1,true,sx,sy,m,t1);
         if(Boolean(t0.length == 0) || Boolean(t1.length == 0))
         {
            return;
         }
         t0.normalize(1);
         t0.x = -t0.x;
         t0.y = -t0.y;
         t1.normalize(1);
         var halfT0T1:Point = new Point((t1.x - t0.x) * 0.5,(t1.y - t0.y) * 0.5);
         var sinHalfAlpha:Number = halfT0T1.length;
         if(Math.abs(sinHalfAlpha) < 1.0e-9)
         {
            return;
         }
         var bisect:Point = new Point(-0.5 * (t0.x + t1.x),-0.5 * (t0.y + t1.y));
         if(bisect.length == 0)
         {
            return;
         }
         if(Boolean(sinHalfAlpha == 0) || Boolean(miterLimit < 1 / sinHalfAlpha))
         {
            bisectLength = bisect.length;
            bisect.normalize(1);
            halfT0T1.normalize((weight - miterLimit * weight * sinHalfAlpha) / bisectLength);
            pt0 = new Point(jointX + miterLimit * weight * bisect.x + halfT0T1.x,jointY + miterLimit * weight * bisect.y + halfT0T1.y);
            pt1 = new Point(jointX + miterLimit * weight * bisect.x - halfT0T1.x,jointY + miterLimit * weight * bisect.y - halfT0T1.y);
            MatrixUtil.rectUnion(pt0.x,pt0.y,pt0.x,pt0.y,result);
            MatrixUtil.rectUnion(pt1.x,pt1.y,pt1.x,pt1.y,result);
         }
         else
         {
            bisect.normalize(1);
            strokeTip = new Point(jointX + bisect.x * weight / sinHalfAlpha,jointY + bisect.y * weight / sinHalfAlpha);
            MatrixUtil.rectUnion(strokeTip.x,strokeTip.y,strokeTip.x,strokeTip.y,result);
         }
      }
      
      override protected function transformWidthForLayout(width:Number, height:Number, postLayoutTransform:Boolean = true) : Number
      {
         var m:Matrix = getComplexMatrix(postLayoutTransform);
         if(Boolean(!m) && Boolean(!stroke))
         {
            return width;
         }
         return this.getBoundingBoxWithStroke(width,height,m).width;
      }
      
      override protected function transformHeightForLayout(width:Number, height:Number, postLayoutTransform:Boolean = true) : Number
      {
         var m:Matrix = getComplexMatrix(postLayoutTransform);
         if(Boolean(!m) && Boolean(!stroke))
         {
            return height;
         }
         return this.getBoundingBoxWithStroke(width,height,m).height;
      }
      
      private function getBoundsAtSize(width:Number, height:Number, m:Matrix) : Rectangle
      {
         var newSize:Point = null;
         var strokeExtents:Rectangle = null;
         if(!isNaN(width))
         {
            strokeExtents = getStrokeExtents(true);
            width = width - strokeExtents.width;
         }
         if(!isNaN(height))
         {
            if(!strokeExtents)
            {
               strokeExtents = getStrokeExtents(true);
            }
            height = height - strokeExtents.height;
         }
         var newWidth:Number = preferredWidthPreTransform();
         var newHeight:Number = preferredHeightPreTransform();
         if(m)
         {
            newSize = MatrixUtil.fitBounds(width,height,m,newWidth,newHeight,minWidth,minHeight,maxWidth,maxHeight);
            if(newSize)
            {
               newWidth = newSize.x;
               newHeight = newSize.y;
            }
            else
            {
               newWidth = minWidth;
               newHeight = minHeight;
            }
         }
         return this.getBoundingBoxWithStroke(newWidth,newHeight,m);
      }
      
      override public function getBoundsXAtSize(width:Number, height:Number, postLayoutTransform:Boolean = true) : Number
      {
         var m:Matrix = getComplexMatrix(postLayoutTransform);
         return this.getBoundsAtSize(width,height,m).x + (Boolean(m)?0:this.x);
      }
      
      override public function getBoundsYAtSize(width:Number, height:Number, postLayoutTransform:Boolean = true) : Number
      {
         var m:Matrix = getComplexMatrix(postLayoutTransform);
         return this.getBoundsAtSize(width,height,m).y + (Boolean(m)?0:this.y);
      }
      
      override public function getLayoutBoundsX(postLayoutTransform:Boolean = true) : Number
      {
         var naturalBounds:Rectangle = null;
         var sx:Number = NaN;
         var m:Matrix = getComplexMatrix(postLayoutTransform);
         if(Boolean(!m) && Boolean(!stroke))
         {
            if(measuredX == 0)
            {
               return this.x;
            }
            naturalBounds = this.getBounds();
            sx = Boolean(naturalBounds.width == 0) || Boolean(_width == 0)?Number(1):Number(_width / naturalBounds.width);
            return this.x + measuredX * sx;
         }
         return this.getBoundingBoxWithStroke(_width,_height,m).x + (Boolean(m)?0:this.x);
      }
      
      override public function getLayoutBoundsY(postLayoutTransform:Boolean = true) : Number
      {
         var naturalBounds:Rectangle = null;
         var sy:Number = NaN;
         var m:Matrix = getComplexMatrix(postLayoutTransform);
         if(Boolean(!m) && Boolean(!stroke))
         {
            if(measuredY == 0)
            {
               return this.y;
            }
            naturalBounds = this.getBounds();
            sy = Boolean(naturalBounds.height == 0) || Boolean(_height == 0)?Number(1):Number(_height / naturalBounds.height);
            return this.y + measuredY * sy;
         }
         return this.getBoundingBoxWithStroke(_width,_height,m).y + (Boolean(m)?0:this.y);
      }
      
      override protected function beginDraw(g:Graphics) : void
      {
         var naturalBounds:Rectangle = this.getBounds();
         var sx:Number = naturalBounds.width == 0?Number(1):Number(width / naturalBounds.width);
         var sy:Number = naturalBounds.height == 0?Number(1):Number(height / naturalBounds.height);
         var origin:Point = new Point(drawX,drawY);
         var bounds:Rectangle = new Rectangle(drawX + measuredX * sx,drawY + measuredY * sy,width,height);
         if(stroke)
         {
            stroke.apply(g,this.getStrokeBounds(),origin);
         }
         else
         {
            g.lineStyle();
         }
         if(fill)
         {
            fill.begin(g,bounds,origin);
         }
      }
      
      override protected function draw(g:Graphics) : void
      {
         var rcBounds:Rectangle = null;
         var sx:Number = NaN;
         var sy:Number = NaN;
         if(Boolean(drawX != this._drawBounds.x) || Boolean(drawY != this._drawBounds.y) || Boolean(width != this._drawBounds.width) || Boolean(height != this._drawBounds.height))
         {
            this.graphicsPathChanged = true;
            this._drawBounds.x = drawX;
            this._drawBounds.y = drawY;
            this._drawBounds.width = width;
            this._drawBounds.height = height;
         }
         if(this.graphicsPathChanged)
         {
            rcBounds = this.getBounds();
            sx = rcBounds.width == 0?Number(1):Number(width / rcBounds.width);
            sy = rcBounds.height == 0?Number(1):Number(height / rcBounds.height);
            if(this.segments)
            {
               this.segments.generateGraphicsPath(this.graphicsPath,drawX,drawY,sx,sy);
            }
            this.graphicsPathChanged = false;
         }
         g.drawPath(this.graphicsPath.commands,this.graphicsPath.data,this.winding);
      }
      
      override protected function endDraw(g:Graphics) : void
      {
         g.lineStyle();
         super.endDraw(g);
      }
      
      override protected function invalidateDisplayObjectSharing() : void
      {
         this.graphicsPathChanged = true;
         super.invalidateDisplayObjectSharing();
      }
      
      private function clearCachedBoundingBoxWithStroke() : void
      {
         this._boundingBoxCached = null;
         this._boundingBoxMatrixCached = null;
      }
      
      override protected function stroke_propertyChangeHandler(event:PropertyChangeEvent) : void
      {
         super.stroke_propertyChangeHandler(event);
         switch(event.property)
         {
            case "weight":
            case "scaleMode":
            case "joints":
            case "miterLimit":
               this.clearCachedBoundingBoxWithStroke();
               invalidateParentSizeAndDisplayList();
         }
      }
      
      override public function set stroke(value:IStroke) : void
      {
         super.stroke = value;
         this.clearCachedBoundingBoxWithStroke();
      }
   }
}

import flash.geom.Rectangle;
import flash.geom.Matrix;
import flash.display.GraphicsPath;

class PathSegmentsCollection
{
    
   private var _segments:Vector.<PathSegment>;
   
   private var _bounds:Rectangle;
   
   private var _charPos:int = 0;
   
   private var _dataLength:int = 0;
   
   function PathSegmentsCollection(value:String)
   {
      var newSegments:Vector.<PathSegment> = null;
      var c:Number = NaN;
      var useRelative:Boolean = false;
      var x:Number = NaN;
      var y:Number = NaN;
      var controlX:Number = NaN;
      var controlY:Number = NaN;
      var control2X:Number = NaN;
      var control2Y:Number = NaN;
      var curSegmentIndex:int = 0;
      super();
      if(!value)
      {
         this._segments = new Vector.<PathSegment>();
         return;
      }
      newSegments = new Vector.<PathSegment>();
      var charCount:int = value.length;
      var prevIdentifier:Number = 0;
      var prevX:Number = 0;
      var prevY:Number = 0;
      var lastMoveX:Number = 0;
      var lastMoveY:Number = 0;
      var lastMoveSegmentIndex:int = -1;
      this._dataLength = charCount;
      this._charPos = 0;
      loop0:
      while(true)
      {
         if(true)
         {
            this.skipWhiteSpace(value);
            if(this._charPos < charCount)
            {
               c = value.charCodeAt(this._charPos++);
               if(Boolean(c >= 48) && Boolean(c < 58) || (Boolean(c == 43) || Boolean(c == 45)) || Boolean(c == 46))
               {
                  c = prevIdentifier;
                  this._charPos--;
               }
               else if(Boolean(c >= 65) && Boolean(c <= 86))
               {
                  useRelative = false;
               }
               else if(Boolean(c >= 97) && Boolean(c <= 122))
               {
                  useRelative = true;
               }
               switch(c)
               {
                  case 99:
                  case 67:
                     controlX = this.getNumber(useRelative,prevX,value);
                     controlY = this.getNumber(useRelative,prevY,value);
                     control2X = this.getNumber(useRelative,prevX,value);
                     control2Y = this.getNumber(useRelative,prevY,value);
                     x = this.getNumber(useRelative,prevX,value);
                     y = this.getNumber(useRelative,prevY,value);
                     newSegments.push(new CubicBezierSegment(controlX,controlY,control2X,control2Y,x,y));
                     prevX = x;
                     prevY = y;
                     prevIdentifier = 99;
                     continue;
                  case 109:
                  case 77:
                     x = this.getNumber(useRelative,prevX,value);
                     y = this.getNumber(useRelative,prevY,value);
                     newSegments.push(new MoveSegment(x,y));
                     prevX = x;
                     prevY = y;
                     prevIdentifier = c == 109?Number(108):Number(76);
                     curSegmentIndex = newSegments.length - 1;
                     if(Boolean(lastMoveSegmentIndex + 2 == curSegmentIndex) && Boolean(newSegments[lastMoveSegmentIndex + 1] is QuadraticBezierSegment))
                     {
                        newSegments.splice(lastMoveSegmentIndex + 1,0,new LineSegment(lastMoveX,lastMoveY));
                        curSegmentIndex++;
                     }
                     lastMoveSegmentIndex = curSegmentIndex;
                     lastMoveX = x;
                     lastMoveY = y;
                     continue;
                  case 108:
                  case 76:
                     x = this.getNumber(useRelative,prevX,value);
                     y = this.getNumber(useRelative,prevY,value);
                     newSegments.push(new LineSegment(x,y));
                     prevX = x;
                     prevY = y;
                     prevIdentifier = 108;
                     continue;
                  case 104:
                  case 72:
                     x = this.getNumber(useRelative,prevX,value);
                     y = prevY;
                     newSegments.push(new LineSegment(x,y));
                     prevX = x;
                     prevY = y;
                     prevIdentifier = 104;
                     continue;
                  case 118:
                  case 86:
                     x = prevX;
                     y = this.getNumber(useRelative,prevY,value);
                     newSegments.push(new LineSegment(x,y));
                     prevX = x;
                     prevY = y;
                     prevIdentifier = 118;
                     continue;
                  case 113:
                  case 81:
                     controlX = this.getNumber(useRelative,prevX,value);
                     controlY = this.getNumber(useRelative,prevY,value);
                     x = this.getNumber(useRelative,prevX,value);
                     y = this.getNumber(useRelative,prevY,value);
                     newSegments.push(new QuadraticBezierSegment(controlX,controlY,x,y));
                     prevX = x;
                     prevY = y;
                     prevIdentifier = 113;
                     continue;
                  case 116:
                  case 84:
                     if(Boolean(prevIdentifier == 116) || Boolean(prevIdentifier == 113))
                     {
                        controlX = prevX + (prevX - controlX);
                        controlY = prevY + (prevY - controlY);
                     }
                     else
                     {
                        controlX = prevX;
                        controlY = prevY;
                     }
                     x = this.getNumber(useRelative,prevX,value);
                     y = this.getNumber(useRelative,prevY,value);
                     newSegments.push(new QuadraticBezierSegment(controlX,controlY,x,y));
                     prevX = x;
                     prevY = y;
                     prevIdentifier = 116;
                     continue;
                  case 115:
                  case 83:
                     if(Boolean(prevIdentifier == 115) || Boolean(prevIdentifier == 99))
                     {
                        controlX = prevX + (prevX - control2X);
                        controlY = prevY + (prevY - control2Y);
                     }
                     else
                     {
                        controlX = prevX;
                        controlY = prevY;
                     }
                     control2X = this.getNumber(useRelative,prevX,value);
                     control2Y = this.getNumber(useRelative,prevY,value);
                     x = this.getNumber(useRelative,prevX,value);
                     y = this.getNumber(useRelative,prevY,value);
                     newSegments.push(new CubicBezierSegment(controlX,controlY,control2X,control2Y,x,y));
                     prevX = x;
                     prevY = y;
                     prevIdentifier = 115;
                     continue;
                  case 122:
                  case 90:
                     x = lastMoveX;
                     y = lastMoveY;
                     newSegments.push(new LineSegment(x,y));
                     prevX = x;
                     prevY = y;
                     prevIdentifier = 122;
                     continue;
                  default:
                     break loop0;
               }
            }
         }
         curSegmentIndex = newSegments.length;
         if(Boolean(lastMoveSegmentIndex + 2 == curSegmentIndex) && Boolean(newSegments[lastMoveSegmentIndex + 1] is QuadraticBezierSegment))
         {
            newSegments.splice(lastMoveSegmentIndex + 1,0,new LineSegment(lastMoveX,lastMoveY));
            curSegmentIndex++;
         }
         this._segments = newSegments;
         return;
      }
      this._segments = new Vector.<PathSegment>();
   }
   
   public function get data() : Vector.<PathSegment>
   {
      return this._segments;
   }
   
   public function getBounds() : Rectangle
   {
      if(this._bounds)
      {
         return this._bounds;
      }
      this._bounds = new Rectangle(0,0,1,1);
      this._bounds = this.getBoundingBox(1,1,null);
      return this._bounds;
   }
   
   public function getBoundingBox(width:Number, height:Number, m:Matrix) : Rectangle
   {
      var prevSegment:PathSegment = null;
      var pathBBox:Rectangle = null;
      var segment:PathSegment = null;
      var x:Number = NaN;
      var y:Number = NaN;
      var naturalBounds:Rectangle = this.getBounds();
      var sx:Number = naturalBounds.width == 0?Number(1):Number(width / naturalBounds.width);
      var sy:Number = naturalBounds.height == 0?Number(1):Number(height / naturalBounds.height);
      var count:int = this._segments.length;
      for(var i:int = 0; i < count; i++)
      {
         segment = this._segments[i];
         pathBBox = segment.getBoundingBox(prevSegment,sx,sy,m,pathBBox);
         prevSegment = segment;
      }
      if(!pathBBox)
      {
         x = Boolean(m)?Number(m.tx):Number(0);
         y = Boolean(m)?Number(m.ty):Number(0);
         pathBBox = new Rectangle(x,y);
      }
      return pathBBox;
   }
   
   public function generateGraphicsPath(graphicsPath:GraphicsPath, tx:Number, ty:Number, sx:Number, sy:Number) : void
   {
      var curSegment:PathSegment = null;
      var prevSegment:PathSegment = null;
      graphicsPath.commands = null;
      graphicsPath.data = null;
      graphicsPath.moveTo(tx,ty);
      var count:int = this._segments.length;
      for(var i:int = 0; i < count; i++)
      {
         prevSegment = curSegment;
         curSegment = this._segments[i];
         curSegment.draw(graphicsPath,tx,ty,sx,sy,prevSegment);
      }
   }
   
   private function skipWhiteSpace(data:String) : void
   {
      var c:Number = NaN;
      while(this._charPos < this._dataLength)
      {
         c = data.charCodeAt(this._charPos);
         if(Boolean(c != 32) && Boolean(c != 44) && Boolean(c != 13) && Boolean(c != 9) && Boolean(c != 10))
         {
            break;
         }
         this._charPos++;
      }
   }
   
   private function getNumber(useRelative:Boolean, offset:Number, value:String) : Number
   {
      var digitStart:int = 0;
      this.skipWhiteSpace(value);
      if(this._charPos >= this._dataLength)
      {
         return NaN;
      }
      var numberStart:int = this._charPos;
      var hasSignCharacter:Boolean = false;
      var hasDigits:Boolean = false;
      var c:Number = value.charCodeAt(this._charPos);
      if(Boolean(c == 43) || Boolean(c == 45))
      {
         hasSignCharacter = true;
         this._charPos++;
      }
      var dotIndex:int = -1;
      while(this._charPos < this._dataLength)
      {
         c = value.charCodeAt(this._charPos);
         if(Boolean(c >= 48) && Boolean(c < 58))
         {
            hasDigits = true;
         }
         else if(Boolean(c == 46) && Boolean(dotIndex == -1))
         {
            dotIndex = this._charPos;
         }
         else
         {
            break;
         }
         this._charPos++;
      }
      if(!hasDigits)
      {
         this._charPos = this._dataLength;
         return NaN;
      }
      if(c == 46)
      {
         this._charPos--;
      }
      var numberEnd:int = this._charPos;
      if(Boolean(c == 69) || Boolean(c == 101))
      {
         this._charPos++;
         if(this._charPos < this._dataLength)
         {
            c = value.charCodeAt(this._charPos);
            if(Boolean(c == 43) || Boolean(c == 45))
            {
               this._charPos++;
            }
         }
         digitStart = this._charPos;
         while(this._charPos < this._dataLength)
         {
            c = value.charCodeAt(this._charPos);
            if(!(Boolean(c >= 48) && Boolean(c < 58)))
            {
               break;
            }
            this._charPos++;
         }
         if(digitStart < this._charPos)
         {
            numberEnd = this._charPos;
         }
         else
         {
            this._charPos = numberEnd;
         }
      }
      var subString:String = value.substr(numberStart,numberEnd - numberStart);
      var result:Number = parseFloat(subString);
      if(isNaN(result))
      {
         this._charPos = this._dataLength;
         return NaN;
      }
      this._charPos = numberEnd;
      return !!useRelative?Number(result + offset):Number(result);
   }
}

import flash.display.GraphicsPath;
import flash.geom.Rectangle;
import flash.geom.Matrix;
import flash.geom.Point;

class PathSegment
{
    
   public var x:Number = 0;
   
   public var y:Number = 0;
   
   function PathSegment(_x:Number = 0, _y:Number = 0)
   {
      super();
      this.x = _x;
      this.y = _y;
   }
   
   public function draw(graphicsPath:GraphicsPath, dx:Number, dy:Number, sx:Number, sy:Number, prev:PathSegment) : void
   {
   }
   
   public function getBoundingBox(prev:PathSegment, sx:Number, sy:Number, m:Matrix, rect:Rectangle) : Rectangle
   {
      return rect;
   }
   
   public function getTangent(prev:PathSegment, start:Boolean, sx:Number, sy:Number, m:Matrix, result:Point) : void
   {
      result.x = 0;
      result.y = 0;
   }
}

import flash.display.GraphicsPath;
import flash.geom.Rectangle;
import flash.geom.Matrix;
import flash.geom.Point;
import mx.utils.MatrixUtil;

class LineSegment extends PathSegment
{
    
   function LineSegment(x:Number = 0, y:Number = 0)
   {
      super(x,y);
   }
   
   override public function draw(graphicsPath:GraphicsPath, dx:Number, dy:Number, sx:Number, sy:Number, prev:PathSegment) : void
   {
      graphicsPath.lineTo(dx + x * sx,dy + y * sy);
   }
   
   override public function getBoundingBox(prev:PathSegment, sx:Number, sy:Number, m:Matrix, rect:Rectangle) : Rectangle
   {
      var pt:Point = null;
      pt = MatrixUtil.transformPoint(x * sx,y * sy,m);
      var x1:Number = pt.x;
      var y1:Number = pt.y;
      if(Boolean(prev != null) && Boolean(!(prev is MoveSegment)))
      {
         return MatrixUtil.rectUnion(x1,y1,x1,y1,rect);
      }
      pt = MatrixUtil.transformPoint(Boolean(prev)?Number(prev.x * sx):Number(0),Boolean(prev)?Number(prev.y * sy):Number(0),m);
      var x2:Number = pt.x;
      var y2:Number = pt.y;
      return MatrixUtil.rectUnion(Math.min(x1,x2),Math.min(y1,y2),Math.max(x1,x2),Math.max(y1,y2),rect);
   }
   
   override public function getTangent(prev:PathSegment, start:Boolean, sx:Number, sy:Number, m:Matrix, result:Point) : void
   {
      var pt0:Point = MatrixUtil.transformPoint(Boolean(prev)?Number(prev.x * sx):Number(0),Boolean(prev)?Number(prev.y * sy):Number(0),m).clone();
      var pt1:Point = MatrixUtil.transformPoint(x * sx,y * sy,m);
      result.x = pt1.x - pt0.x;
      result.y = pt1.y - pt0.y;
   }
}

import flash.display.GraphicsPath;

class MoveSegment extends PathSegment
{
    
   function MoveSegment(x:Number = 0, y:Number = 0)
   {
      super(x,y);
   }
   
   override public function draw(graphicsPath:GraphicsPath, dx:Number, dy:Number, sx:Number, sy:Number, prev:PathSegment) : void
   {
      graphicsPath.moveTo(dx + x * sx,dy + y * sy);
   }
}

import flash.display.GraphicsPath;
import flash.geom.Rectangle;
import flash.geom.Matrix;
import mx.utils.MatrixUtil;
import flash.geom.Point;

class CubicBezierSegment extends PathSegment
{
    
   private var _qPts:QuadraticPoints;
   
   public var control1X:Number = 0;
   
   public var control1Y:Number = 0;
   
   public var control2X:Number = 0;
   
   public var control2Y:Number = 0;
   
   function CubicBezierSegment(_control1X:Number = 0, _control1Y:Number = 0, _control2X:Number = 0, _control2Y:Number = 0, x:Number = 0, y:Number = 0)
   {
      super(x,y);
      this.control1X = _control1X;
      this.control1Y = _control1Y;
      this.control2X = _control2X;
      this.control2Y = _control2Y;
   }
   
   override public function draw(graphicsPath:GraphicsPath, dx:Number, dy:Number, sx:Number, sy:Number, prev:PathSegment) : void
   {
      var qPts:QuadraticPoints = this.getQuadraticPoints(prev);
      graphicsPath.curveTo(dx + qPts.control1.x * sx,dy + qPts.control1.y * sy,dx + qPts.anchor1.x * sx,dy + qPts.anchor1.y * sy);
      graphicsPath.curveTo(dx + qPts.control2.x * sx,dy + qPts.control2.y * sy,dx + qPts.anchor2.x * sx,dy + qPts.anchor2.y * sy);
      graphicsPath.curveTo(dx + qPts.control3.x * sx,dy + qPts.control3.y * sy,dx + qPts.anchor3.x * sx,dy + qPts.anchor3.y * sy);
      graphicsPath.curveTo(dx + qPts.control4.x * sx,dy + qPts.control4.y * sy,dx + qPts.anchor4.x * sx,dy + qPts.anchor4.y * sy);
   }
   
   override public function getBoundingBox(prev:PathSegment, sx:Number, sy:Number, m:Matrix, rect:Rectangle) : Rectangle
   {
      var qPts:QuadraticPoints = this.getQuadraticPoints(prev);
      rect = MatrixUtil.getQBezierSegmentBBox(Boolean(prev)?Number(prev.x):Number(0),Boolean(prev)?Number(prev.y):Number(0),qPts.control1.x,qPts.control1.y,qPts.anchor1.x,qPts.anchor1.y,sx,sy,m,rect);
      rect = MatrixUtil.getQBezierSegmentBBox(qPts.anchor1.x,qPts.anchor1.y,qPts.control2.x,qPts.control2.y,qPts.anchor2.x,qPts.anchor2.y,sx,sy,m,rect);
      rect = MatrixUtil.getQBezierSegmentBBox(qPts.anchor2.x,qPts.anchor2.y,qPts.control3.x,qPts.control3.y,qPts.anchor3.x,qPts.anchor3.y,sx,sy,m,rect);
      rect = MatrixUtil.getQBezierSegmentBBox(qPts.anchor3.x,qPts.anchor3.y,qPts.control4.x,qPts.control4.y,qPts.anchor4.x,qPts.anchor4.y,sx,sy,m,rect);
      return rect;
   }
   
   override public function getTangent(prev:PathSegment, start:Boolean, sx:Number, sy:Number, m:Matrix, result:Point) : void
   {
      var qPts:QuadraticPoints = this.getQuadraticPoints(prev);
      var pt0:Point = MatrixUtil.transformPoint(Boolean(prev)?Number(prev.x * sx):Number(0),Boolean(prev)?Number(prev.y * sy):Number(0),m).clone();
      var pt1:Point = MatrixUtil.transformPoint(qPts.control1.x * sx,qPts.control1.y * sy,m).clone();
      var pt2:Point = MatrixUtil.transformPoint(qPts.anchor1.x * sx,qPts.anchor1.y * sy,m).clone();
      var pt3:Point = MatrixUtil.transformPoint(qPts.control2.x * sx,qPts.control2.y * sy,m).clone();
      var pt4:Point = MatrixUtil.transformPoint(qPts.anchor2.x * sx,qPts.anchor2.y * sy,m).clone();
      var pt5:Point = MatrixUtil.transformPoint(qPts.control3.x * sx,qPts.control3.y * sy,m).clone();
      var pt6:Point = MatrixUtil.transformPoint(qPts.anchor3.x * sx,qPts.anchor3.y * sy,m).clone();
      var pt7:Point = MatrixUtil.transformPoint(qPts.control4.x * sx,qPts.control4.y * sy,m).clone();
      var pt8:Point = MatrixUtil.transformPoint(qPts.anchor4.x * sx,qPts.anchor4.y * sy,m).clone();
      if(start)
      {
         QuadraticBezierSegment.getQTangent(pt0.x,pt0.y,pt1.x,pt1.y,pt2.x,pt2.y,start,result);
         if(Boolean(result.x == 0) && Boolean(result.y == 0))
         {
            QuadraticBezierSegment.getQTangent(pt0.x,pt0.y,pt3.x,pt3.y,pt4.x,pt4.y,start,result);
            if(Boolean(result.x == 0) && Boolean(result.y == 0))
            {
               QuadraticBezierSegment.getQTangent(pt0.x,pt0.y,pt5.x,pt5.y,pt6.x,pt6.y,start,result);
               if(Boolean(result.x == 0) && Boolean(result.y == 0))
               {
                  QuadraticBezierSegment.getQTangent(pt0.x,pt0.y,pt7.x,pt7.y,pt8.x,pt8.y,start,result);
               }
            }
         }
      }
      else
      {
         QuadraticBezierSegment.getQTangent(pt6.x,pt6.y,pt7.x,pt7.y,pt8.x,pt8.y,start,result);
         if(Boolean(result.x == 0) && Boolean(result.y == 0))
         {
            QuadraticBezierSegment.getQTangent(pt4.x,pt4.y,pt5.x,pt5.y,pt8.x,pt8.y,start,result);
            if(Boolean(result.x == 0) && Boolean(result.y == 0))
            {
               QuadraticBezierSegment.getQTangent(pt2.x,pt2.y,pt3.x,pt3.y,pt8.x,pt8.y,start,result);
               if(Boolean(result.x == 0) && Boolean(result.y == 0))
               {
                  QuadraticBezierSegment.getQTangent(pt0.x,pt0.y,pt1.x,pt1.y,pt8.x,pt8.y,start,result);
               }
            }
         }
      }
   }
   
   private function getQuadraticPoints(prev:PathSegment) : QuadraticPoints
   {
      if(this._qPts)
      {
         return this._qPts;
      }
      var p1:Point = new Point(Boolean(prev)?Number(prev.x):Number(0),Boolean(prev)?Number(prev.y):Number(0));
      var p2:Point = new Point(x,y);
      var c1:Point = new Point(this.control1X,this.control1Y);
      var c2:Point = new Point(this.control2X,this.control2Y);
      var PA:Point = Point.interpolate(c1,p1,3 / 4);
      var PB:Point = Point.interpolate(c2,p2,3 / 4);
      var dx:Number = (p2.x - p1.x) / 16;
      var dy:Number = (p2.y - p1.y) / 16;
      this._qPts = new QuadraticPoints();
      this._qPts.control1 = Point.interpolate(c1,p1,3 / 8);
      this._qPts.control2 = Point.interpolate(PB,PA,3 / 8);
      this._qPts.control2.x = this._qPts.control2.x - dx;
      this._qPts.control2.y = this._qPts.control2.y - dy;
      this._qPts.control3 = Point.interpolate(PA,PB,3 / 8);
      this._qPts.control3.x = this._qPts.control3.x + dx;
      this._qPts.control3.y = this._qPts.control3.y + dy;
      this._qPts.control4 = Point.interpolate(c2,p2,3 / 8);
      this._qPts.anchor1 = Point.interpolate(this._qPts.control1,this._qPts.control2,0.5);
      this._qPts.anchor2 = Point.interpolate(PA,PB,0.5);
      this._qPts.anchor3 = Point.interpolate(this._qPts.control3,this._qPts.control4,0.5);
      this._qPts.anchor4 = p2;
      return this._qPts;
   }
}

import flash.geom.Point;

class QuadraticPoints
{
    
   public var control1:Point;
   
   public var anchor1:Point;
   
   public var control2:Point;
   
   public var anchor2:Point;
   
   public var control3:Point;
   
   public var anchor3:Point;
   
   public var control4:Point;
   
   public var anchor4:Point;
   
   function QuadraticPoints()
   {
      super();
   }
}

import flash.geom.Point;
import flash.display.GraphicsPath;
import flash.geom.Matrix;
import mx.utils.MatrixUtil;
import flash.geom.Rectangle;

class QuadraticBezierSegment extends PathSegment
{
    
   public var control1X:Number = 0;
   
   public var control1Y:Number = 0;
   
   function QuadraticBezierSegment(_control1X:Number = 0, _control1Y:Number = 0, x:Number = 0, y:Number = 0)
   {
      super(x,y);
      this.control1X = _control1X;
      this.control1Y = _control1Y;
   }
   
   public static function getQTangent(x0:Number, y0:Number, x1:Number, y1:Number, x2:Number, y2:Number, start:Boolean, result:Point) : void
   {
      if(start)
      {
         if(Boolean(x0 == x1) && Boolean(y0 == y1))
         {
            result.x = x2 - x0;
            result.y = y2 - y0;
         }
         else
         {
            result.x = x1 - x0;
            result.y = y1 - y0;
         }
      }
      else if(Boolean(x2 == x1) && Boolean(y2 == y1))
      {
         result.x = x2 - x0;
         result.y = y2 - y0;
      }
      else
      {
         result.x = x2 - x1;
         result.y = y2 - y1;
      }
   }
   
   override public function draw(graphicsPath:GraphicsPath, dx:Number, dy:Number, sx:Number, sy:Number, prev:PathSegment) : void
   {
      graphicsPath.curveTo(dx + this.control1X * sx,dy + this.control1Y * sy,dx + x * sx,dy + y * sy);
   }
   
   override public function getTangent(prev:PathSegment, start:Boolean, sx:Number, sy:Number, m:Matrix, result:Point) : void
   {
      var pt0:Point = MatrixUtil.transformPoint(Boolean(prev)?Number(prev.x * sx):Number(0),Boolean(prev)?Number(prev.y * sy):Number(0),m).clone();
      var pt1:Point = MatrixUtil.transformPoint(this.control1X * sx,this.control1Y * sy,m).clone();
      var pt2:Point = MatrixUtil.transformPoint(x * sx,y * sy,m).clone();
      getQTangent(pt0.x,pt0.y,pt1.x,pt1.y,pt2.x,pt2.y,start,result);
   }
   
   override public function getBoundingBox(prev:PathSegment, sx:Number, sy:Number, m:Matrix, rect:Rectangle) : Rectangle
   {
      return MatrixUtil.getQBezierSegmentBBox(Boolean(prev)?Number(prev.x):Number(0),Boolean(prev)?Number(prev.y):Number(0),this.control1X,this.control1Y,x,y,sx,sy,m,rect);
   }
}
