package spark.components.supportClasses
{
   import spark.layouts.supportClasses.LayoutBase;
   import spark.components.Scroller;
   import flash.geom.Point;
   import spark.core.IViewport;
   import mx.utils.MatrixUtil;
   import mx.core.ScrollPolicy;
   import mx.core.IUIComponent;
   
   [ExcludeClass]
   public class ScrollerLayout extends LayoutBase
   {
      
      private static const SDT:Number = 1;
       
      private var invalidationCount:int = 0;
      
      private var hsbScaleX:Number = 1;
      
      private var hsbScaleY:Number = 1;
      
      private var vsbScaleX:Number = 1;
      
      private var vsbScaleY:Number = 1;
      
      public function ScrollerLayout()
      {
         super();
      }
      
      private function getScroller() : Scroller
      {
         var g:Skin = target as Skin;
         return Boolean(g) && Boolean("hostComponent" in g)?Object(g).hostComponent as Scroller:null;
      }
      
      private function getLayoutContentSize(viewport:IViewport) : Point
      {
         var cw:Number = viewport.contentWidth;
         var ch:Number = viewport.contentHeight;
         if(Boolean(cw == 0) && Boolean(ch == 0) || (Boolean(isNaN(cw)) || Boolean(isNaN(ch))))
         {
            return new Point(0,0);
         }
         return MatrixUtil.transformSize(cw,ch,viewport.getLayoutMatrix());
      }
      
      private function get hsbVisible() : Boolean
      {
         var hsb:ScrollBarBase = this.getScroller().horizontalScrollBar;
         return Boolean(hsb) && Boolean(hsb.visible);
      }
      
      private function set hsbVisible(value:Boolean) : void
      {
         var hsb:ScrollBarBase = this.getScroller().horizontalScrollBar;
         if(!hsb)
         {
            return;
         }
         hsb.includeInLayout = hsb.visible = value;
         if(value)
         {
            if(hsb.scaleX == 0)
            {
               hsb.scaleX = this.hsbScaleX;
            }
            if(hsb.scaleY == 0)
            {
               hsb.scaleY = this.hsbScaleY;
            }
         }
         else
         {
            if(hsb.scaleX != 0)
            {
               this.hsbScaleX = hsb.scaleX;
            }
            if(hsb.scaleY != 0)
            {
               this.hsbScaleY = hsb.scaleY;
            }
            hsb.scaleX = hsb.scaleY = 0;
         }
      }
      
      private function hsbRequiredHeight() : Number
      {
         var scroller:Scroller = this.getScroller();
         var minViewportInset:Number = scroller.minViewportInset;
         var hsb:ScrollBarBase = scroller.horizontalScrollBar;
         var sy:Number = !!this.hsbVisible?Number(1):Number(this.hsbScaleY);
         return Math.max(minViewportInset,hsb.getPreferredBoundsHeight(this.hsbVisible) * sy);
      }
      
      private function hsbFits(w:Number, h:Number, includeVSB:Boolean = true) : Boolean
      {
         var vsb:ScrollBarBase = null;
         if(Boolean(this.vsbVisible) && Boolean(includeVSB))
         {
            vsb = this.getScroller().verticalScrollBar;
            w = w - vsb.getPreferredBoundsWidth();
            h = h - vsb.getMinBoundsHeight();
         }
         var hsb:ScrollBarBase = this.getScroller().horizontalScrollBar;
         return Boolean(w >= hsb.getMinBoundsWidth()) && Boolean(h >= hsb.getPreferredBoundsHeight());
      }
      
      private function get vsbVisible() : Boolean
      {
         var vsb:ScrollBarBase = this.getScroller().verticalScrollBar;
         return Boolean(vsb) && Boolean(vsb.visible);
      }
      
      private function set vsbVisible(value:Boolean) : void
      {
         var vsb:ScrollBarBase = this.getScroller().verticalScrollBar;
         if(!vsb)
         {
            return;
         }
         vsb.includeInLayout = vsb.visible = value;
         if(value)
         {
            if(vsb.scaleX == 0)
            {
               vsb.scaleX = this.vsbScaleX;
            }
            if(vsb.scaleY == 0)
            {
               vsb.scaleY = this.vsbScaleY;
            }
         }
         else
         {
            if(vsb.scaleX != 0)
            {
               this.vsbScaleX = vsb.scaleX;
            }
            if(vsb.scaleY != 0)
            {
               this.vsbScaleY = vsb.scaleY;
            }
            vsb.scaleX = vsb.scaleY = 0;
         }
      }
      
      private function vsbRequiredWidth() : Number
      {
         var scroller:Scroller = this.getScroller();
         var minViewportInset:Number = scroller.minViewportInset;
         var vsb:ScrollBarBase = scroller.verticalScrollBar;
         var sx:Number = !!this.vsbVisible?Number(1):Number(this.vsbScaleX);
         return Math.max(minViewportInset,vsb.getPreferredBoundsWidth(this.vsbVisible) * sx);
      }
      
      private function vsbFits(w:Number, h:Number, includeHSB:Boolean = true) : Boolean
      {
         var hsb:ScrollBarBase = null;
         if(Boolean(this.hsbVisible) && Boolean(includeHSB))
         {
            hsb = this.getScroller().horizontalScrollBar;
            w = w - hsb.getMinBoundsWidth();
            h = h - hsb.getPreferredBoundsHeight();
         }
         var vsb:ScrollBarBase = this.getScroller().verticalScrollBar;
         return Boolean(w >= vsb.getPreferredBoundsWidth()) && Boolean(h >= vsb.getMinBoundsHeight());
      }
      
      override public function measure() : void
      {
         var contentSize:Point = null;
         var viewportPreferredW:Number = NaN;
         var viewportContentW:Number = NaN;
         var viewportW:Number = NaN;
         var currentSizeNoHSB:Boolean = false;
         var viewportPreferredH:Number = NaN;
         var viewportContentH:Number = NaN;
         var viewportH:Number = NaN;
         var currentSizeNoVSB:Boolean = false;
         var scroller:Scroller = this.getScroller();
         if(!scroller)
         {
            return;
         }
         var minViewportInset:Number = scroller.minViewportInset;
         var measuredSizeIncludesScrollBars:Boolean = scroller.measuredSizeIncludesScrollBars;
         var measuredW:Number = minViewportInset;
         var measuredH:Number = minViewportInset;
         var hsb:ScrollBarBase = scroller.horizontalScrollBar;
         var showHSB:Boolean = false;
         var hAuto:Boolean = false;
         if(measuredSizeIncludesScrollBars)
         {
            switch(scroller.getStyle("horizontalScrollPolicy"))
            {
               case ScrollPolicy.ON:
                  if(hsb)
                  {
                     showHSB = true;
                  }
                  break;
               case ScrollPolicy.AUTO:
                  if(hsb)
                  {
                     showHSB = hsb.visible;
                  }
                  hAuto = true;
            }
         }
         var vsb:ScrollBarBase = scroller.verticalScrollBar;
         var showVSB:Boolean = false;
         var vAuto:Boolean = false;
         if(measuredSizeIncludesScrollBars)
         {
            switch(scroller.getStyle("verticalScrollPolicy"))
            {
               case ScrollPolicy.ON:
                  if(vsb)
                  {
                     showVSB = true;
                  }
                  break;
               case ScrollPolicy.AUTO:
                  if(vsb)
                  {
                     showVSB = vsb.visible;
                  }
                  vAuto = true;
            }
         }
         measuredH = measuredH + (!!showHSB?this.hsbRequiredHeight():minViewportInset);
         measuredW = measuredW + (!!showVSB?this.vsbRequiredWidth():minViewportInset);
         var viewport:IViewport = scroller.viewport;
         if(viewport)
         {
            if(measuredSizeIncludesScrollBars)
            {
               contentSize = this.getLayoutContentSize(viewport);
               viewportPreferredW = viewport.getPreferredBoundsWidth();
               viewportContentW = contentSize.x;
               viewportW = viewport.getLayoutBoundsWidth();
               currentSizeNoHSB = Boolean(!isNaN(viewportW)) && Boolean(viewportW + SDT > viewportContentW);
               if(Boolean(hAuto) && Boolean(!showHSB) && Boolean(viewportPreferredW + SDT <= viewportContentW) && Boolean(currentSizeNoHSB))
               {
                  measuredW = measuredW + viewportW;
               }
               else
               {
                  measuredW = measuredW + Math.max(viewportPreferredW,!!showHSB?Number(hsb.getMinBoundsWidth()):Number(0));
               }
               viewportPreferredH = viewport.getPreferredBoundsHeight();
               viewportContentH = contentSize.y;
               viewportH = viewport.getLayoutBoundsHeight();
               currentSizeNoVSB = Boolean(!isNaN(viewportH)) && Boolean(viewportH + SDT > viewportContentH);
               if(Boolean(vAuto) && Boolean(!showVSB) && Boolean(viewportPreferredH + SDT <= viewportContentH) && Boolean(currentSizeNoVSB))
               {
                  measuredH = measuredH + viewportH;
               }
               else
               {
                  measuredH = measuredH + Math.max(viewportPreferredH,!!showVSB?Number(vsb.getMinBoundsHeight()):Number(0));
               }
            }
            else
            {
               measuredW = measuredW + viewport.getPreferredBoundsWidth();
               measuredH = measuredH + viewport.getPreferredBoundsHeight();
            }
         }
         var minW:Number = minViewportInset * 2;
         var minH:Number = minViewportInset * 2;
         var viewportUIC:IUIComponent = viewport as IUIComponent;
         var explicitViewportW:Number = Boolean(viewportUIC)?Number(viewportUIC.explicitWidth):Number(NaN);
         var explicitViewportH:Number = Boolean(viewportUIC)?Number(viewportUIC.explicitHeight):Number(NaN);
         if(!isNaN(explicitViewportW))
         {
            minW = minW + explicitViewportW;
         }
         if(!isNaN(explicitViewportH))
         {
            minH = minH + explicitViewportH;
         }
         var g:GroupBase = target;
         g.measuredWidth = Math.ceil(measuredW);
         g.measuredHeight = Math.ceil(measuredH);
         g.measuredMinWidth = Math.ceil(minW);
         g.measuredMinHeight = Math.ceil(minH);
      }
      
      override public function updateDisplayList(w:Number, h:Number) : void
      {
         var contentSize:Point = null;
         var hsbW:Number = NaN;
         var hsbH:Number = NaN;
         var vsbW:Number = NaN;
         var vsbH:Number = NaN;
         var viewportGroup:GroupBase = null;
         var scroller:Scroller = this.getScroller();
         if(!scroller)
         {
            return;
         }
         var viewport:IViewport = scroller.viewport;
         var hsb:ScrollBarBase = scroller.horizontalScrollBar;
         var vsb:ScrollBarBase = scroller.verticalScrollBar;
         var minViewportInset:Number = scroller.minViewportInset;
         var contentW:Number = 0;
         var contentH:Number = 0;
         if(viewport)
         {
            contentSize = this.getLayoutContentSize(viewport);
            contentW = contentSize.x;
            contentH = contentSize.y;
         }
         var viewportUIC:IUIComponent = viewport as IUIComponent;
         var explicitViewportW:Number = Boolean(viewportUIC)?Number(viewportUIC.explicitWidth):Number(NaN);
         var explicitViewportH:Number = Boolean(viewportUIC)?Number(viewportUIC.explicitHeight):Number(NaN);
         var viewportW:Number = !!isNaN(explicitViewportW)?Number(w - minViewportInset * 2):Number(explicitViewportW);
         var viewportH:Number = !!isNaN(explicitViewportH)?Number(h - minViewportInset * 2):Number(explicitViewportH);
         var oldShowHSB:Boolean = this.hsbVisible;
         var oldShowVSB:Boolean = this.vsbVisible;
         var hAuto:Boolean = false;
         switch(scroller.getStyle("horizontalScrollPolicy"))
         {
            case ScrollPolicy.ON:
               this.hsbVisible = true;
               break;
            case ScrollPolicy.AUTO:
               if(Boolean(hsb) && Boolean(viewport))
               {
                  hAuto = true;
                  this.hsbVisible = contentW >= viewportW + SDT;
               }
               break;
            default:
               this.hsbVisible = false;
         }
         var vAuto:Boolean = false;
         switch(scroller.getStyle("verticalScrollPolicy"))
         {
            case ScrollPolicy.ON:
               this.vsbVisible = true;
               break;
            case ScrollPolicy.AUTO:
               if(Boolean(vsb) && Boolean(viewport))
               {
                  vAuto = true;
                  this.vsbVisible = contentH >= viewportH + SDT;
               }
               break;
            default:
               this.vsbVisible = false;
         }
         if(isNaN(explicitViewportW))
         {
            viewportW = w - (!!this.vsbVisible?minViewportInset + this.vsbRequiredWidth():minViewportInset * 2);
         }
         else
         {
            viewportW = explicitViewportW;
         }
         if(isNaN(explicitViewportH))
         {
            viewportH = h - (!!this.hsbVisible?minViewportInset + this.hsbRequiredHeight():minViewportInset * 2);
         }
         else
         {
            viewportH = explicitViewportH;
         }
         var hsbIsDependent:Boolean = false;
         var vsbIsDependent:Boolean = false;
         if(Boolean(this.vsbVisible) && Boolean(!this.hsbVisible) && Boolean(hAuto) && Boolean(contentW >= viewportW + SDT))
         {
            this.hsbVisible = hsbIsDependent = true;
         }
         else if(Boolean(!this.vsbVisible) && Boolean(this.hsbVisible) && Boolean(vAuto) && Boolean(contentH >= viewportH + SDT))
         {
            this.vsbVisible = vsbIsDependent = true;
         }
         if(Boolean(this.hsbVisible) && Boolean(this.vsbVisible))
         {
            if(!(Boolean(this.hsbFits(w,h)) && Boolean(this.vsbFits(w,h))))
            {
               if(Boolean(!this.hsbFits(w,h,false)) && Boolean(!this.vsbFits(w,h,false)))
               {
                  this.hsbVisible = false;
                  this.vsbVisible = false;
               }
               else if(hsbIsDependent)
               {
                  if(this.vsbFits(w,h,false))
                  {
                     this.hsbVisible = false;
                  }
                  else
                  {
                     this.vsbVisible = this.hsbVisible = false;
                  }
               }
               else if(vsbIsDependent)
               {
                  if(this.hsbFits(w,h,false))
                  {
                     this.vsbVisible = false;
                  }
                  else
                  {
                     this.hsbVisible = this.vsbVisible = false;
                  }
               }
               else if(this.vsbFits(w,h,false))
               {
                  this.hsbVisible = false;
               }
               else
               {
                  this.vsbVisible = false;
               }
            }
         }
         else if(Boolean(this.hsbVisible) && Boolean(!this.hsbFits(w,h)))
         {
            this.hsbVisible = false;
         }
         else if(Boolean(this.vsbVisible) && Boolean(!this.vsbFits(w,h)))
         {
            this.vsbVisible = false;
         }
         if(isNaN(explicitViewportW))
         {
            viewportW = w - (!!this.vsbVisible?minViewportInset + this.vsbRequiredWidth():minViewportInset * 2);
         }
         else
         {
            viewportW = explicitViewportW;
         }
         if(isNaN(explicitViewportH))
         {
            viewportH = h - (!!this.hsbVisible?minViewportInset + this.hsbRequiredHeight():minViewportInset * 2);
         }
         else
         {
            viewportH = explicitViewportH;
         }
         if(viewport)
         {
            viewport.setLayoutBoundsSize(viewportW,viewportH);
            viewport.setLayoutBoundsPosition(minViewportInset,minViewportInset);
         }
         if(this.hsbVisible)
         {
            hsbW = !!this.vsbVisible?Number(w - vsb.getPreferredBoundsWidth()):Number(w);
            hsbH = hsb.getPreferredBoundsHeight();
            hsb.setLayoutBoundsSize(Math.max(hsb.getMinBoundsWidth(),hsbW),hsbH);
            hsb.setLayoutBoundsPosition(0,h - hsbH);
         }
         if(this.vsbVisible)
         {
            vsbW = vsb.getPreferredBoundsWidth();
            vsbH = !!this.hsbVisible?Number(h - hsb.getPreferredBoundsHeight()):Number(h);
            vsb.setLayoutBoundsSize(vsbW,Math.max(vsb.getMinBoundsHeight(),vsbH));
            vsb.setLayoutBoundsPosition(w - vsbW,0);
         }
         if(Boolean(this.invalidationCount < 2) && (Boolean(this.vsbVisible != oldShowVSB) && Boolean(vAuto) || Boolean(this.hsbVisible != oldShowHSB) && Boolean(hAuto)))
         {
            target.invalidateSize();
            viewportGroup = viewport as GroupBase;
            if(Boolean(viewportGroup) && Boolean(viewportGroup.layout) && Boolean(viewportGroup.layout.useVirtualLayout))
            {
               viewportGroup.invalidateSize();
            }
            this.invalidationCount = this.invalidationCount + 1;
         }
         else
         {
            this.invalidationCount = 0;
         }
         target.setContentSize(w,h);
      }
   }
}
