package spark.components.supportClasses
{
   import flashx.textLayout.container.TextContainerManager;
   import spark.components.RichEditableText;
   import flash.ui.ContextMenu;
   import flash.geom.Rectangle;
   import mx.styles.IStyleClient;
   import flash.display.Graphics;
   import flashx.textLayout.tlf_internal;
   import flashx.undo.IUndoManager;
   import mx.core.mx_internal;
   import flashx.undo.UndoManager;
   import flashx.textLayout.edit.SelectionFormat;
   import flashx.textLayout.edit.EditingMode;
   import flash.display.BlendMode;
   import spark.components.TextSelectionHighlighting;
   import flashx.textLayout.edit.IEditManager;
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.edit.ISelectionManager;
   import flashx.textLayout.container.ContainerController;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.edit.SelectionState;
   import flashx.textLayout.operations.ApplyFormatOperation;
   import flashx.textLayout.edit.ElementRange;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flashx.textLayout.property.Property;
   import flashx.textLayout.formats.Category;
   import flashx.textLayout.elements.ParagraphElement;
   import flashx.textLayout.events.SelectionEvent;
   import flashx.textLayout.operations.InsertTextOperation;
   import flash.events.FocusEvent;
   import flash.events.KeyboardEvent;
   import flash.events.MouseEvent;
   import flash.events.Event;
   import flashx.textLayout.edit.SelectionManager;
   import mx.events.SandboxMouseEvent;
   import flashx.textLayout.elements.IConfiguration;
   
   use namespace mx_internal;
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class RichEditableTextContainerManager extends TextContainerManager
   {
       
      private var hasScrollRect:Boolean = false;
      
      private var textDisplay:RichEditableText;
      
      private var userContextMenu:ContextMenu;
      
      public function RichEditableTextContainerManager(container:RichEditableText, configuration:IConfiguration)
      {
         super(container,configuration);
         this.textDisplay = container;
      }
      
      override public function drawBackgroundAndSetScrollRect(scrollX:Number, scrollY:Number) : Boolean
      {
         var backgroundColor:* = undefined;
         var width:Number = this.textDisplay.width;
         var height:Number = this.textDisplay.height;
         var contentBounds:Rectangle = getContentBounds();
         if(isNaN(width))
         {
            width = contentBounds.right;
         }
         if(isNaN(height))
         {
            height = contentBounds.bottom;
         }
         var xOrigin:Number = 0;
         if(Boolean(scrollX == 0) && Boolean(scrollY == 0) && Boolean(contentBounds.left >= xOrigin) && Boolean(contentBounds.right <= width) && Boolean(contentBounds.top >= 0) && Boolean(contentBounds.bottom <= height))
         {
            if(this.hasScrollRect)
            {
               container.scrollRect = null;
               this.hasScrollRect = false;
            }
         }
         else
         {
            container.scrollRect = new Rectangle(scrollX,scrollY,width,height);
            this.hasScrollRect = true;
         }
         var color:uint = 0;
         var alpha:Number = 0;
         var styleableContainer:IStyleClient = container as IStyleClient;
         if(styleableContainer)
         {
            backgroundColor = styleableContainer.getStyle("backgroundColor");
            if(backgroundColor !== undefined)
            {
               color = uint(backgroundColor);
               alpha = styleableContainer.getStyle("backgroundAlpha");
            }
         }
         var g:Graphics = container.graphics;
         g.clear();
         g.lineStyle();
         g.beginFill(color,alpha);
         g.drawRect(scrollX,scrollY,width,height);
         g.endFill();
         return this.hasScrollRect;
      }
      
      override tlf_internal function getContextMenu() : ContextMenu
      {
         if(this.textDisplay.contextMenu)
         {
            this.userContextMenu = this.textDisplay.contextMenu;
         }
         if(!this.userContextMenu)
         {
            this.userContextMenu = super.getContextMenu();
         }
         return this.userContextMenu;
      }
      
      override protected function getUndoManager() : IUndoManager
      {
         if(!this.textDisplay.undoManager)
         {
            this.textDisplay.undoManager = new UndoManager();
            this.textDisplay.undoManager.undoAndRedoItemLimit = int.MAX_VALUE;
         }
         return this.textDisplay.undoManager;
      }
      
      override protected function getFocusedSelectionFormat() : SelectionFormat
      {
         var selectionColor:* = this.textDisplay.getStyle("focusedTextSelectionColor");
         var focusedPointAlpha:Number = editingMode == EditingMode.READ_WRITE?Number(1):Number(0);
         return new SelectionFormat(selectionColor,1,BlendMode.NORMAL,0,focusedPointAlpha,BlendMode.INVERT);
      }
      
      override protected function getUnfocusedSelectionFormat() : SelectionFormat
      {
         var unfocusedSelectionColor:* = this.textDisplay.getStyle("unfocusedTextSelectionColor");
         var unfocusedAlpha:Number = this.textDisplay.selectionHighlighting != TextSelectionHighlighting.WHEN_FOCUSED?Number(1):Number(0);
         return new SelectionFormat(unfocusedSelectionColor,unfocusedAlpha,BlendMode.NORMAL,unfocusedSelectionColor,0);
      }
      
      override protected function getInactiveSelectionFormat() : SelectionFormat
      {
         var inactiveSelectionColor:* = this.textDisplay.getStyle("inactiveTextSelectionColor");
         var inactiveAlpha:Number = this.textDisplay.selectionHighlighting == TextSelectionHighlighting.ALWAYS?Number(1):Number(0);
         return new SelectionFormat(inactiveSelectionColor,inactiveAlpha,BlendMode.NORMAL,inactiveSelectionColor,0);
      }
      
      override protected function createEditManager(undoManager:IUndoManager) : IEditManager
      {
         return new RichEditableTextEditManager(this.textDisplay,undoManager);
      }
      
      override public function setText(text:String) : void
      {
         super.setText(text);
         this.initForInputIfHaveFocus();
      }
      
      override public function setTextFlow(textFlow:TextFlow) : void
      {
         super.setTextFlow(textFlow);
         this.initForInputIfHaveFocus();
      }
      
      private function initForInputIfHaveFocus() : void
      {
         var im:ISelectionManager = null;
         var controller:ContainerController = null;
         if(Boolean(editingMode != EditingMode.READ_ONLY) && Boolean(this.textDisplay.getFocus() == this.textDisplay))
         {
            im = beginInteraction();
            controller = getTextFlow().flowComposer.getControllerAt(0);
            controller.requiredFocusInHandler(null);
            im.selectRange(0,0);
            endInteraction();
         }
      }
      
      mx_internal function applyFormatOperation(leafFormat:ITextLayoutFormat, paragraphFormat:ITextLayoutFormat, containerFormat:ITextLayoutFormat, anchorPosition:int, activePosition:int) : Boolean
      {
         if(Boolean(anchorPosition == -1) || Boolean(activePosition == -1))
         {
            return true;
         }
         var textFlow:TextFlow = this.getTextFlowWithComposer();
         var operationState:SelectionState = new SelectionState(textFlow,anchorPosition,activePosition);
         operationState.selectionManagerOperationState = true;
         var op:ApplyFormatOperation = new ApplyFormatOperation(operationState,leafFormat,paragraphFormat,containerFormat);
         var success:Boolean = op.doOperation();
         if(success)
         {
            textFlow.normalize();
            textFlow.flowComposer.updateAllControllers();
         }
         return success;
      }
      
      mx_internal function getCommonCharacterFormat(anchorPosition:int, activePosition:int) : ITextLayoutFormat
      {
         var selectionState:SelectionState = null;
         if(Boolean(anchorPosition == -1) || Boolean(activePosition == -1))
         {
            return null;
         }
         var textFlow:TextFlow = this.getTextFlowWithComposer();
         var absoluteStart:int = this.getAbsoluteStart(anchorPosition,activePosition);
         var absoluteEnd:int = this.getAbsoluteEnd(anchorPosition,activePosition);
         var selRange:ElementRange = ElementRange.createElementRange(textFlow,absoluteStart,absoluteEnd);
         var leaf:FlowLeafElement = selRange.firstLeaf;
         var attr:TextLayoutFormat = new TextLayoutFormat(leaf.computedFormat);
         if(Boolean(anchorPosition != -1) && Boolean(anchorPosition == activePosition))
         {
            if(textFlow.interactionManager)
            {
               selectionState = textFlow.interactionManager.getSelectionState();
               if(selectionState.pointFormat)
               {
                  attr.apply(selectionState.pointFormat);
               }
            }
         }
         else
         {
            while(true)
            {
               if(leaf == selRange.lastLeaf)
               {
                  break;
               }
               leaf = leaf.getNextLeaf();
               attr.removeClashing(leaf.computedFormat);
            }
         }
         return Property.extractInCategory(TextLayoutFormat,TextLayoutFormat.description,attr,Category.CHARACTER) as ITextLayoutFormat;
      }
      
      mx_internal function getCommonContainerFormat() : ITextLayoutFormat
      {
         var textFlow:TextFlow = this.getTextFlowWithComposer();
         var controller:ContainerController = textFlow.flowComposer.getControllerAt(0);
         return Property.extractInCategory(TextLayoutFormat,TextLayoutFormat.description,controller.computedFormat,Category.CONTAINER) as ITextLayoutFormat;
      }
      
      mx_internal function getCommonParagraphFormat(anchorPosition:int, activePosition:int) : ITextLayoutFormat
      {
         if(Boolean(anchorPosition == -1) || Boolean(activePosition == -1))
         {
            return null;
         }
         var textFlow:TextFlow = this.getTextFlowWithComposer();
         var absoluteStart:int = this.getAbsoluteStart(anchorPosition,activePosition);
         var absoluteEnd:int = this.getAbsoluteEnd(anchorPosition,activePosition);
         var selRange:ElementRange = ElementRange.createElementRange(textFlow,absoluteStart,absoluteEnd);
         var para:ParagraphElement = selRange.firstParagraph;
         for(var attr:TextLayoutFormat = new TextLayoutFormat(para.computedFormat); true; )
         {
            if(para == selRange.lastParagraph)
            {
               break;
            }
            para = textFlow.findAbsoluteParagraph(para.getAbsoluteStart() + para.textLength);
            attr.removeClashing(para.computedFormat);
         }
         return Property.extractInCategory(TextLayoutFormat,TextLayoutFormat.description,attr,Category.PARAGRAPH) as ITextLayoutFormat;
      }
      
      mx_internal function insertTextOperation(insertText:String, anchorPosition:int, activePosition:int) : Boolean
      {
         var insertPt:int = 0;
         var selectionState:SelectionState = null;
         var selectionEvent:SelectionEvent = null;
         if(Boolean(anchorPosition == -1) || Boolean(activePosition == -1))
         {
            return false;
         }
         var textFlow:TextFlow = this.getTextFlowWithComposer();
         var absoluteStart:int = this.getAbsoluteStart(anchorPosition,activePosition);
         var absoluteEnd:int = this.getAbsoluteEnd(anchorPosition,activePosition);
         var pointFormat:ITextLayoutFormat = this.getCommonCharacterFormat(absoluteStart,absoluteStart);
         var operationState:SelectionState = new SelectionState(textFlow,absoluteStart,absoluteEnd,pointFormat);
         operationState.selectionManagerOperationState = true;
         var op:InsertTextOperation = new InsertTextOperation(operationState,insertText);
         var success:Boolean = op.doOperation();
         if(success)
         {
            textFlow.normalize();
            textFlow.flowComposer.updateAllControllers();
            insertPt = absoluteEnd - (absoluteEnd - absoluteStart) + insertText.length;
            selectionState = new SelectionState(textFlow,insertPt,insertPt);
            selectionEvent = new SelectionEvent(SelectionEvent.SELECTION_CHANGE,false,false,selectionState);
            textFlow.dispatchEvent(selectionEvent);
            scrollToRange(insertPt,insertPt);
         }
         return success;
      }
      
      mx_internal function getTextFlowWithComposer() : TextFlow
      {
         var textFlow:TextFlow = getTextFlow();
         if(composeState != TextContainerManager.COMPOSE_COMPOSER)
         {
            convertToTextFlowWithComposer();
         }
         else if(textFlow.interactionManager)
         {
            textFlow.interactionManager.flushPendingOperations();
         }
         return textFlow;
      }
      
      private function getAbsoluteStart(anchorPosition:int, activePosition:int) : int
      {
         return anchorPosition < activePosition?int(anchorPosition):int(activePosition);
      }
      
      private function getAbsoluteEnd(anchorPosition:int, activePosition:int) : int
      {
         return anchorPosition > activePosition?int(anchorPosition):int(activePosition);
      }
      
      override public function focusInHandler(event:FocusEvent) : void
      {
         this.textDisplay.focusInHandler(event);
         super.focusInHandler(event);
      }
      
      override public function focusOutHandler(event:FocusEvent) : void
      {
         this.textDisplay.focusOutHandler(event);
         super.focusOutHandler(event);
      }
      
      override public function keyDownHandler(event:KeyboardEvent) : void
      {
         this.textDisplay.keyDownHandler(event);
         if(!event.isDefaultPrevented())
         {
            super.keyDownHandler(event);
         }
      }
      
      override public function keyUpHandler(event:KeyboardEvent) : void
      {
         if(!event.isDefaultPrevented())
         {
            super.keyUpHandler(event);
         }
      }
      
      override public function mouseWheelHandler(event:MouseEvent) : void
      {
         if(!event.isDefaultPrevented())
         {
            super.mouseWheelHandler(event);
         }
      }
      
      override public function mouseDownHandler(event:MouseEvent) : void
      {
         this.textDisplay.mouseDownHandler(event);
         super.mouseDownHandler(event);
      }
      
      override public function activateHandler(event:Event) : void
      {
         var im:SelectionManager = null;
         if(event.type == Event.ACTIVATE)
         {
            return;
         }
         super.activateHandler(event);
         if(Boolean(editingMode != EditingMode.READ_ONLY) && Boolean(this.textDisplay.getFocus() == this.textDisplay))
         {
            im = SelectionManager(beginInteraction());
            im.setFocus();
            endInteraction();
         }
      }
      
      override public function deactivateHandler(event:Event) : void
      {
         if(event.type == Event.DEACTIVATE)
         {
            return;
         }
         super.deactivateHandler(event);
      }
      
      override public function beginMouseCapture() : void
      {
         super.beginMouseCapture();
         this.textDisplay.systemManager.getSandboxRoot().addEventListener(SandboxMouseEvent.MOUSE_UP_SOMEWHERE,this.mouseUpSomewhereHandler);
         this.textDisplay.systemManager.getSandboxRoot().addEventListener(SandboxMouseEvent.MOUSE_MOVE_SOMEWHERE,this.mouseMoveSomewhereHandler);
      }
      
      override public function endMouseCapture() : void
      {
         super.endMouseCapture();
         this.textDisplay.systemManager.getSandboxRoot().removeEventListener(SandboxMouseEvent.MOUSE_UP_SOMEWHERE,this.mouseUpSomewhereHandler);
         this.textDisplay.systemManager.getSandboxRoot().removeEventListener(SandboxMouseEvent.MOUSE_MOVE_SOMEWHERE,this.mouseMoveSomewhereHandler);
      }
      
      private function mouseUpSomewhereHandler(event:Event) : void
      {
         mouseUpSomewhere(event);
      }
      
      private function mouseMoveSomewhereHandler(event:Event) : void
      {
         mouseMoveSomewhere(event);
      }
   }
}
