package spark.components.supportClasses
{
   import mx.core.UIComponent;
   import spark.core.IViewport;
   import mx.core.mx_internal;
   import mx.core.IVisualElement;
   import spark.utils.FTETextUtil;
   import spark.layouts.supportClasses.LayoutBase;
   import mx.events.PropertyChangeEvent;
   import flash.events.Event;
   import flash.geom.Rectangle;
   import spark.events.DisplayLayerObjectExistenceEvent;
   import spark.components.ResizeMode;
   import spark.layouts.BasicLayout;
   import flash.filters.ShaderFilter;
   import mx.graphics.shaderClasses.LuminosityMaskShader;
   import spark.utils.MaskUtil;
   import spark.core.MaskType;
   import flash.geom.Point;
   import flash.events.MouseEvent;
   import flash.display.Sprite;
   import flash.display.DisplayObject;
   
   use namespace mx_internal;
   
   [Exclude(kind="style",name="focusThickness")]
   [Exclude(kind="style",name="focusBlendMode")]
   [Style(inherit="yes",name="symbolColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="rollOverColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="focusColor",format="Color",theme="spark",type="uint")]
   [Style(minValue="0.0",maxValue="1.0",inherit="no",name="disabledAlpha",theme="spark",type="Number")]
   [Style(inherit="yes",name="contentBackgroundColor",format="Color",theme="spark",type="uint")]
   [Style(minValue="0.0",maxValue="1.0",inherit="yes",name="contentBackgroundAlpha",theme="spark",type="Number")]
   [Style(inherit="yes",name="chromeColor",format="Color",theme="spark",type="uint")]
   [Style(arrayType="uint",inherit="yes",name="alternatingItemColors",format="Color",theme="spark",type="Array")]
   [Style(inherit="yes",name="accentColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="unfocusedTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="inactiveTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="focusedTextSelectionColor",format="Color",type="uint")]
   [Style(inherit="yes",name="whiteSpaceCollapse",type="String",enumeration="collapse,preserve")]
   [Style(inherit="yes",name="textRotation",type="String",enumeration="auto,rotate0,rotate90,rotate180,rotate270")]
   [Style(minValue="0.0",inherit="yes",name="textIndent",format="Length",type="Number")]
   [Style(inherit="yes",name="tabStops",type="String")]
   [Style(inherit="yes",name="paragraphStartIndent",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphSpaceBefore",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphSpaceAfter",format="length",type="Number")]
   [Style(minValue="0.0",inherit="yes",name="paragraphEndIndent",format="length",type="Number")]
   [Style(inherit="yes",name="leadingModel",type="String",enumeration="auto,romanUp,ideographicTopUp,ideographicCenterUp,ideographicTopDown,ideographicCenterDown,ascentDescentUp")]
   [Style(inherit="yes",name="firstBaselineOffset",type="Object")]
   [Style(inherit="yes",name="breakOpportunity",type="String",enumeration="auto,all,any,none")]
   [Style(inherit="yes",name="blockProgression",type="String",enumeration="tb,rl")]
   [Style(inherit="yes",name="typographicCase",type="String",enumeration="default,capsToSmallCaps,uppercase,lowercase,lowercaseToSmallCaps")]
   [Style(inherit="yes",name="trackingRight",type="Object")]
   [Style(inherit="yes",name="trackingLeft",type="Object")]
   [Style(inherit="yes",name="textJustify",type="String",enumeration="interWord,distribute")]
   [Style(inherit="yes",name="textDecoration",type="String",enumeration="none,underline")]
   [Style(minValue="0.0",maxValue="1.0",inherit="yes",name="textAlpha",type="Number")]
   [Style(inherit="yes",name="textAlignLast",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="textAlign",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="renderingMode",type="String",enumeration="cff,normal")]
   [Style(inherit="yes",name="locale",type="String")]
   [Style(inherit="yes",name="lineThrough",type="Boolean")]
   [Style(inherit="yes",name="lineHeight",type="Object")]
   [Style(inherit="yes",name="ligatureLevel",type="String",enumeration="common,minimum,uncommon,exotic")]
   [Style(inherit="yes",name="kerning",type="String",enumeration="auto,on,off")]
   [Style(inherit="yes",name="justificationStyle",type="String",enumeration="auto,prioritizeLeastAdjustment,pushInKinsoku,pushOutOnly")]
   [Style(inherit="yes",name="justificationRule",type="String",enumeration="auto,space,eastAsian")]
   [Style(inherit="yes",name="fontWeight",type="String",enumeration="normal,bold")]
   [Style(inherit="yes",name="fontStyle",type="String",enumeration="normal,italic")]
   [Style(minValue="1.0",maxValue="720.0",inherit="yes",name="fontSize",format="Length",type="Number")]
   [Style(inherit="yes",name="fontLookup",type="String",enumeration="auto,device,embeddedCFF")]
   [Style(inherit="yes",name="fontFamily",type="String")]
   [Style(inherit="yes",name="dominantBaseline",type="String",enumeration="auto,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   [Style(inherit="yes",name="direction",type="String",enumeration="ltr,rtl")]
   [Style(inherit="yes",name="digitWidth",type="String",enumeration="default,proportional,tabular")]
   [Style(inherit="yes",name="digitCase",type="String",enumeration="default,lining,oldStyle")]
   [Style(inherit="yes",name="color",format="Color",type="uint")]
   [Style(inherit="yes",name="cffHinting",type="String",enumeration="horizontalStem,none")]
   [Style(inherit="yes",name="baselineShift",type="Object")]
   [Style(inherit="yes",name="alignmentBaseline",type="String",enumeration="useDominantBaseline,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   public class GroupBase extends UIComponent implements IViewport
   {
       
      private var _explicitAlpha:Number = 1.0;
      
      private var _explicitMouseChildren:Boolean = true;
      
      private var _explicitMouseEnabled:Boolean = true;
      
      private var _layout:LayoutBase;
      
      private var _layoutProperties:Object = null;
      
      private var layoutInvalidateSizeFlag:Boolean = false;
      
      private var layoutInvalidateDisplayListFlag:Boolean = false;
      
      private var clipAndEnableScrollingExplicitlySet:Boolean = false;
      
      private var _scrollRectSet:Boolean = false;
      
      private var _autoLayout:Boolean = true;
      
      mx_internal var _overlay:spark.components.supportClasses.DisplayLayer;
      
      private var _resizeMode:String = "noScale";
      
      private var _mouseEnabledWhereTransparent:Boolean = true;
      
      private var mouseEventReferenceCount:int;
      
      private var _hasMouseListeners:Boolean = false;
      
      private var _contentWidth:Number = 0;
      
      private var _contentHeight:Number = 0;
      
      private var _focusPane:Sprite;
      
      private var _mask:DisplayObject;
      
      mx_internal var maskChanged:Boolean;
      
      private var _maskType:String = "clip";
      
      private var maskTypeChanged:Boolean;
      
      private var originalMaskFilters:Array;
      
      private var _luminosityInvert:Boolean = false;
      
      private var luminositySettingsChanged:Boolean;
      
      private var _luminosityClip:Boolean = false;
      
      public function GroupBase()
      {
         super();
         showInAutomationHierarchy = false;
      }
      
      mx_internal static function sortOnLayer(a:Vector.<IVisualElement>) : void
      {
         var tmp:IVisualElement = null;
         var j:int = 0;
         var len:Number = a.length;
         if(len <= 1)
         {
            return;
         }
         for(var i:int = 1; i < len; i++)
         {
            for(j = i; j > 0; )
            {
               if(a[j].depth < a[j - 1].depth)
               {
                  tmp = a[j];
                  a[j] = a[j - 1];
                  a[j - 1] = tmp;
                  j--;
                  continue;
               }
               break;
            }
         }
      }
      
      override public function set alpha(value:Number) : void
      {
         if(enabled)
         {
            super.alpha = value;
         }
         this._explicitAlpha = value;
      }
      
      override public function get baselinePosition() : Number
      {
         if(!validateBaselinePosition())
         {
            return NaN;
         }
         return FTETextUtil.calculateFontBaseline(this,height,moduleFactory);
      }
      
      override public function set mouseChildren(value:Boolean) : void
      {
         if(enabled)
         {
            super.mouseChildren = value;
         }
         this._explicitMouseChildren = value;
      }
      
      override public function set mouseEnabled(value:Boolean) : void
      {
         if(enabled)
         {
            super.mouseEnabled = value;
         }
         this._explicitMouseEnabled = value;
      }
      
      override public function set enabled(value:Boolean) : void
      {
         var disabledAlpha:Number = NaN;
         super.enabled = value;
         super.mouseChildren = !!value?Boolean(this._explicitMouseChildren):Boolean(false);
         super.mouseEnabled = !!value?Boolean(this._explicitMouseEnabled):Boolean(false);
         if(value)
         {
            super.alpha = this._explicitAlpha;
         }
         else
         {
            disabledAlpha = getStyle("disabledAlpha");
            if(!isNaN(disabledAlpha))
            {
               super.alpha = disabledAlpha;
            }
         }
      }
      
      public function get layout() : LayoutBase
      {
         return this._layout;
      }
      
      public function set layout(value:LayoutBase) : void
      {
         if(this._layout == value)
         {
            return;
         }
         if(this._layout)
         {
            this._layout.target = null;
            this._layout.removeEventListener(PropertyChangeEvent.PROPERTY_CHANGE,this.redispatchLayoutEvent);
            if(this.clipAndEnableScrollingExplicitlySet)
            {
               this._layoutProperties = {"clipAndEnableScrolling":this._layout.clipAndEnableScrolling};
            }
         }
         this._layout = value;
         if(this._layout)
         {
            this._layout.target = this;
            this._layout.addEventListener(PropertyChangeEvent.PROPERTY_CHANGE,this.redispatchLayoutEvent);
            if(this._layoutProperties)
            {
               if(this._layoutProperties.clipAndEnableScrolling !== undefined)
               {
                  value.clipAndEnableScrolling = this._layoutProperties.clipAndEnableScrolling;
               }
               if(this._layoutProperties.verticalScrollPosition !== undefined)
               {
                  value.verticalScrollPosition = this._layoutProperties.verticalScrollPosition;
               }
               if(this._layoutProperties.horizontalScrollPosition !== undefined)
               {
                  value.horizontalScrollPosition = this._layoutProperties.horizontalScrollPosition;
               }
               this._layoutProperties = null;
            }
         }
         this.invalidateSize();
         this.invalidateDisplayList();
      }
      
      private function redispatchLayoutEvent(event:Event) : void
      {
         var pce:PropertyChangeEvent = event as PropertyChangeEvent;
         if(pce)
         {
            switch(pce.property)
            {
               case "verticalScrollPosition":
               case "horizontalScrollPosition":
                  dispatchEvent(event);
            }
         }
      }
      
      [Inspectable(minValue="0.0")]
      [Bindable(event="propertyChange")]
      public function get horizontalScrollPosition() : Number
      {
         if(this._layout)
         {
            return this._layout.horizontalScrollPosition;
         }
         if(Boolean(this._layoutProperties) && Boolean(this._layoutProperties.horizontalScrollPosition !== undefined))
         {
            return this._layoutProperties.horizontalScrollPosition;
         }
         return 0;
      }
      
      private function set _754184102horizontalScrollPosition(value:Number) : void
      {
         if(this._layout)
         {
            this._layout.horizontalScrollPosition = value;
         }
         else if(this._layoutProperties)
         {
            this._layoutProperties.horizontalScrollPosition = value;
         }
         else
         {
            this._layoutProperties = {"horizontalScrollPosition":value};
         }
      }
      
      [Inspectable(minValue="0.0")]
      [Bindable(event="propertyChange")]
      public function get verticalScrollPosition() : Number
      {
         if(this._layout)
         {
            return this._layout.verticalScrollPosition;
         }
         if(Boolean(this._layoutProperties) && Boolean(this._layoutProperties.verticalScrollPosition !== undefined))
         {
            return this._layoutProperties.verticalScrollPosition;
         }
         return 0;
      }
      
      private function set _1010846676verticalScrollPosition(value:Number) : void
      {
         if(this._layout)
         {
            this._layout.verticalScrollPosition = value;
         }
         else if(this._layoutProperties)
         {
            this._layoutProperties.verticalScrollPosition = value;
         }
         else
         {
            this._layoutProperties = {"verticalScrollPosition":value};
         }
      }
      
      public function get clipAndEnableScrolling() : Boolean
      {
         if(this._layout)
         {
            return this._layout.clipAndEnableScrolling;
         }
         if(Boolean(this._layoutProperties) && Boolean(this._layoutProperties.clipAndEnableScrolling !== undefined))
         {
            return this._layoutProperties.clipAndEnableScrolling;
         }
         return false;
      }
      
      public function set clipAndEnableScrolling(value:Boolean) : void
      {
         this.clipAndEnableScrollingExplicitlySet = true;
         if(this._layout)
         {
            this._layout.clipAndEnableScrolling = value;
         }
         else if(this._layoutProperties)
         {
            this._layoutProperties.clipAndEnableScrolling = value;
         }
         else
         {
            this._layoutProperties = {"clipAndEnableScrolling":value};
         }
         this.invalidateSize();
      }
      
      override public function get scrollRect() : Rectangle
      {
         return !this._scrollRectSet?null:super.scrollRect;
      }
      
      override public function set scrollRect(value:Rectangle) : void
      {
         if(Boolean(!this._scrollRectSet) && Boolean(!value))
         {
            return;
         }
         this._scrollRectSet = true;
         super.scrollRect = value;
      }
      
      [Inspectable(defaultValue="true")]
      public function get autoLayout() : Boolean
      {
         return this._autoLayout;
      }
      
      public function set autoLayout(value:Boolean) : void
      {
         if(this._autoLayout == value)
         {
            return;
         }
         this._autoLayout = value;
         if(value)
         {
            this.invalidateSize();
            this.invalidateDisplayList();
            invalidateParentSizeAndDisplayList();
         }
      }
      
      [Inspectable(category="General")]
      public function get overlay() : spark.components.supportClasses.DisplayLayer
      {
         if(!this._overlay)
         {
            this._overlay = new spark.components.supportClasses.DisplayLayer();
            this._overlay.addEventListener(DisplayLayerObjectExistenceEvent.OBJECT_ADD,this.overlay_objectAdd);
            this._overlay.addEventListener(DisplayLayerObjectExistenceEvent.OBJECT_REMOVE,this.overlay_objectRemove);
            invalidateProperties();
         }
         return this._overlay;
      }
      
      private function overlay_objectAdd(event:DisplayLayerObjectExistenceEvent) : void
      {
         super.addChildAt(event.object,event.index + numChildren - this._overlay.numDisplayObjects + 1);
      }
      
      private function overlay_objectRemove(event:DisplayLayerObjectExistenceEvent) : void
      {
         super.removeChild(event.object);
         if(this._overlay.numDisplayObjects == 1)
         {
            invalidateProperties();
         }
      }
      
      private function destroyOverlay() : void
      {
         this._overlay.removeEventListener(DisplayLayerObjectExistenceEvent.OBJECT_ADD,this.overlay_objectAdd);
         this._overlay.removeEventListener(DisplayLayerObjectExistenceEvent.OBJECT_REMOVE,this.overlay_objectRemove);
         this._overlay = null;
      }
      
      [Inspectable(defaultValue="noScale",category="General",enumeration="noScale,scale")]
      public function get resizeMode() : String
      {
         return this._resizeMode;
      }
      
      public function set resizeMode(value:String) : void
      {
         if(this._resizeMode == value)
         {
            return;
         }
         if(this._resizeMode == ResizeMode.SCALE)
         {
            setStretchXY(1,1);
         }
         this._resizeMode = value;
         this.invalidateSize();
         this.invalidateDisplayList();
      }
      
      [Inspectable(defaultValue="true",category="General",enumeration="true,false")]
      public function get mouseEnabledWhereTransparent() : Boolean
      {
         return this._mouseEnabledWhereTransparent;
      }
      
      public function set mouseEnabledWhereTransparent(value:Boolean) : void
      {
         if(value == this._mouseEnabledWhereTransparent)
         {
            return;
         }
         this._mouseEnabledWhereTransparent = value;
         if(this._hasMouseListeners)
         {
            this.invalidateDisplayList();
         }
      }
      
      mx_internal function drawBackground() : void
      {
         var tileSize:int = 0;
         var maxX:int = 0;
         var maxY:int = 0;
         var x:int = 0;
         var y:int = 0;
         var tileWidth:int = 0;
         var tileHeight:int = 0;
         if(Boolean(!this._mouseEnabledWhereTransparent) || Boolean(!this._hasMouseListeners))
         {
            return;
         }
         var w:Number = this._resizeMode == ResizeMode.SCALE?Number(measuredWidth):Number(unscaledWidth);
         var h:Number = this._resizeMode == ResizeMode.SCALE?Number(measuredHeight):Number(unscaledHeight);
         if(Boolean(isNaN(w)) || Boolean(isNaN(h)))
         {
            return;
         }
         graphics.clear();
         graphics.beginFill(16777215,0);
         if(Boolean(this.layout) && Boolean(this.layout.useVirtualLayout))
         {
            graphics.drawRect(this.horizontalScrollPosition,this.verticalScrollPosition,w,h);
         }
         else
         {
            tileSize = 4096;
            maxX = Math.round(Math.max(w,this.contentWidth));
            maxY = Math.round(Math.max(h,this.contentHeight));
            for(x = 0; x < maxX; x = x + tileSize)
            {
               for(y = 0; y < maxY; y = y + tileSize)
               {
                  tileWidth = Math.min(maxX - x,tileSize);
                  tileHeight = Math.min(maxY - y,tileSize);
                  graphics.drawRect(x,y,tileWidth,tileHeight);
               }
            }
         }
         graphics.endFill();
      }
      
      mx_internal function set hasMouseListeners(value:Boolean) : void
      {
         if(this._mouseEnabledWhereTransparent)
         {
            this.$invalidateDisplayList();
         }
         this._hasMouseListeners = value;
      }
      
      mx_internal function get hasMouseListeners() : Boolean
      {
         return this._hasMouseListeners;
      }
      
      override protected function canSkipMeasurement() : Boolean
      {
         return this._resizeMode == ResizeMode.SCALE?Boolean(false):Boolean(super.canSkipMeasurement());
      }
      
      override public function invalidateSize() : void
      {
         super.invalidateSize();
         this.layoutInvalidateSizeFlag = true;
      }
      
      override public function invalidateDisplayList() : void
      {
         super.invalidateDisplayList();
         this.layoutInvalidateDisplayListFlag = true;
      }
      
      override mx_internal function childXYChanged() : void
      {
         if(this.autoLayout)
         {
            this.invalidateSize();
            this.invalidateDisplayList();
         }
      }
      
      mx_internal function $invalidateSize() : void
      {
         super.invalidateSize();
      }
      
      mx_internal function $invalidateDisplayList() : void
      {
         super.invalidateDisplayList();
      }
      
      override protected function createChildren() : void
      {
         super.createChildren();
         if(!this.layout)
         {
            this.layout = new BasicLayout();
         }
      }
      
      override protected function commitProperties() : void
      {
         super.commitProperties();
         if(Boolean(this._overlay) && Boolean(this._overlay.numDisplayObjects == 0))
         {
            this.destroyOverlay();
         }
      }
      
      override protected function measure() : void
      {
         var oldMeasuredWidth:Number = NaN;
         var oldMeasuredHeight:Number = NaN;
         if(Boolean(this._layout) && Boolean(this.layoutInvalidateSizeFlag))
         {
            oldMeasuredWidth = measuredWidth;
            oldMeasuredHeight = measuredHeight;
            super.measure();
            this.layoutInvalidateSizeFlag = false;
            this._layout.measure();
            if(Boolean(this.clipAndEnableScrolling) || Boolean(this.resizeMode == ResizeMode.SCALE))
            {
               measuredMinWidth = 0;
               measuredMinHeight = 0;
            }
            if(Boolean(this._resizeMode == ResizeMode.SCALE) && (Boolean(measuredWidth != oldMeasuredWidth) || Boolean(measuredHeight != oldMeasuredHeight)))
            {
               this.invalidateDisplayList();
            }
         }
      }
      
      override protected function validateMatrix() : void
      {
         var stretchX:Number = NaN;
         var stretchY:Number = NaN;
         if(this._resizeMode == ResizeMode.SCALE)
         {
            stretchX = 1;
            stretchY = 1;
            if(measuredWidth != 0)
            {
               stretchX = width / measuredWidth;
            }
            if(measuredHeight != 0)
            {
               stretchY = height / measuredHeight;
            }
            setStretchXY(stretchX,stretchY);
         }
         super.validateMatrix();
      }
      
      override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         var shaderFilter:ShaderFilter = null;
         var shaderFilterIndex:int = 0;
         var len:int = 0;
         var luminosityMaskShader:LuminosityMaskShader = null;
         if(this._resizeMode == ResizeMode.SCALE)
         {
            unscaledWidth = measuredWidth;
            unscaledHeight = measuredHeight;
         }
         super.updateDisplayList(unscaledWidth,unscaledHeight);
         if(this.maskChanged)
         {
            this.maskChanged = false;
            if(this._mask)
            {
               this.maskTypeChanged = true;
               if(!this._mask.parent)
               {
                  this.overlay.addDisplayObject(this._mask,OverlayDepth.MASK);
                  MaskUtil.applyMask(this._mask,null);
               }
            }
         }
         if(this.luminositySettingsChanged)
         {
            this.luminositySettingsChanged = false;
            if(Boolean(this._mask) && Boolean(this._maskType == MaskType.LUMINOSITY) && Boolean(this._mask.filters.length > 0))
            {
               len = this._mask.filters.length;
               for(shaderFilterIndex = 0; shaderFilterIndex < len; shaderFilterIndex++)
               {
                  if(Boolean(this._mask.filters[shaderFilterIndex] is ShaderFilter) && Boolean(ShaderFilter(this._mask.filters[shaderFilterIndex]).shader is LuminosityMaskShader))
                  {
                     shaderFilter = this._mask.filters[shaderFilterIndex];
                     break;
                  }
               }
               if(Boolean(shaderFilter) && Boolean(shaderFilter.shader is LuminosityMaskShader))
               {
                  LuminosityMaskShader(shaderFilter.shader).mode = this.calculateLuminositySettings();
                  this._mask.filters[shaderFilterIndex] = shaderFilter;
                  this._mask.filters = this._mask.filters;
               }
            }
         }
         if(this.maskTypeChanged)
         {
            this.maskTypeChanged = false;
            if(this._mask)
            {
               if(this._maskType == MaskType.CLIP)
               {
                  this._mask.cacheAsBitmap = false;
                  this.originalMaskFilters = this._mask.filters;
                  this._mask.filters = [];
               }
               else if(this._maskType == MaskType.ALPHA)
               {
                  this._mask.cacheAsBitmap = true;
                  cacheAsBitmap = true;
               }
               else if(this._maskType == MaskType.LUMINOSITY)
               {
                  this._mask.cacheAsBitmap = true;
                  cacheAsBitmap = true;
                  luminosityMaskShader = new LuminosityMaskShader();
                  luminosityMaskShader.mode = this.calculateLuminositySettings();
                  shaderFilter = new ShaderFilter(luminosityMaskShader);
                  this._mask.filters = [shaderFilter];
               }
            }
         }
         if(this.layoutInvalidateDisplayListFlag)
         {
            this.layoutInvalidateDisplayListFlag = false;
            if(Boolean(this.autoLayout) && Boolean(this._layout))
            {
               this._layout.updateDisplayList(unscaledWidth,unscaledHeight);
            }
            if(this._layout)
            {
               this._layout.updateScrollRect(unscaledWidth,unscaledHeight);
            }
         }
      }
      
      private function calculateLuminositySettings() : int
      {
         var mode:int = 0;
         if(this.luminosityInvert)
         {
            mode = mode + 1;
         }
         if(this.luminosityClip)
         {
            mode = mode + 2;
         }
         return mode;
      }
      
      override public function styleChanged(styleProp:String) : void
      {
         var disabledAlpha:Number = NaN;
         super.styleChanged(styleProp);
         var allStyles:Boolean = Boolean(styleProp == null) || Boolean(styleProp == "styleName");
         if(Boolean(!enabled) && (Boolean(allStyles) || Boolean(styleProp == "disabledAlpha")))
         {
            disabledAlpha = getStyle("disabledAlpha");
            if(!isNaN(disabledAlpha))
            {
               super.alpha = disabledAlpha;
            }
         }
      }
      
      override public function globalToLocal(point:Point) : Point
      {
         var sX:Number = NaN;
         var sY:Number = NaN;
         var p:Point = null;
         if(Boolean(this.resizeMode == ResizeMode.SCALE) && Boolean(_layoutFeatures != null))
         {
            sX = _layoutFeatures.stretchX;
            sY = _layoutFeatures.stretchY;
            _layoutFeatures.stretchX = 1;
            _layoutFeatures.stretchY = 1;
            applyComputedMatrix();
            p = super.globalToLocal(point);
            _layoutFeatures.stretchX = sX;
            _layoutFeatures.stretchY = sY;
            applyComputedMatrix();
            return p;
         }
         return super.globalToLocal(point);
      }
      
      override public function localToGlobal(point:Point) : Point
      {
         var sX:Number = NaN;
         var sY:Number = NaN;
         var p:Point = null;
         if(Boolean(this.resizeMode == ResizeMode.SCALE) && Boolean(_layoutFeatures != null))
         {
            sX = _layoutFeatures.stretchX;
            sY = _layoutFeatures.stretchY;
            _layoutFeatures.stretchX = 1;
            _layoutFeatures.stretchY = 1;
            applyComputedMatrix();
            p = super.localToGlobal(point);
            _layoutFeatures.stretchX = sX;
            _layoutFeatures.stretchY = sY;
            applyComputedMatrix();
            return p;
         }
         return super.localToGlobal(point);
      }
      
      public function getHorizontalScrollPositionDelta(navigationUnit:uint) : Number
      {
         return Boolean(this.layout)?Number(this.layout.getHorizontalScrollPositionDelta(navigationUnit)):Number(0);
      }
      
      public function getVerticalScrollPositionDelta(navigationUnit:uint) : Number
      {
         return Boolean(this.layout)?Number(this.layout.getVerticalScrollPositionDelta(navigationUnit)):Number(0);
      }
      
      [Inspectable(category="General")]
      [Bindable("propertyChange")]
      public function get contentWidth() : Number
      {
         return this._contentWidth;
      }
      
      private function setContentWidth(value:Number) : void
      {
         if(value == this._contentWidth)
         {
            return;
         }
         var oldValue:Number = this._contentWidth;
         this._contentWidth = value;
         dispatchPropertyChangeEvent("contentWidth",oldValue,value);
      }
      
      [Inspectable(category="General")]
      [Bindable("propertyChange")]
      public function get contentHeight() : Number
      {
         return this._contentHeight;
      }
      
      private function setContentHeight(value:Number) : void
      {
         if(value == this._contentHeight)
         {
            return;
         }
         var oldValue:Number = this._contentHeight;
         this._contentHeight = value;
         dispatchPropertyChangeEvent("contentHeight",oldValue,value);
      }
      
      public function setContentSize(width:Number, height:Number) : void
      {
         if(Boolean(width == this._contentWidth) && Boolean(height == this._contentHeight))
         {
            return;
         }
         this.setContentWidth(width);
         this.setContentHeight(height);
      }
      
      override public function addEventListener(type:String, listener:Function, useCapture:Boolean = false, priority:int = 0, useWeakReference:Boolean = false) : void
      {
         super.addEventListener(type,listener,useCapture,priority,useWeakReference);
         if(Boolean(type == MouseEvent.CLICK) || Boolean(type == MouseEvent.DOUBLE_CLICK) || Boolean(type == MouseEvent.MOUSE_DOWN) || Boolean(type == MouseEvent.MOUSE_MOVE) || Boolean(type == MouseEvent.MOUSE_OVER) || Boolean(type == MouseEvent.MOUSE_OUT) || Boolean(type == MouseEvent.ROLL_OUT) || Boolean(type == MouseEvent.ROLL_OVER) || Boolean(type == MouseEvent.MOUSE_UP) || Boolean(type == MouseEvent.MOUSE_WHEEL))
         {
            if(this.mouseEventReferenceCount++ == 0)
            {
               this.hasMouseListeners = true;
            }
         }
      }
      
      override public function removeEventListener(type:String, listener:Function, useCapture:Boolean = false) : void
      {
         super.removeEventListener(type,listener,useCapture);
         if(Boolean(type == MouseEvent.CLICK) || Boolean(type == MouseEvent.DOUBLE_CLICK) || Boolean(type == MouseEvent.MOUSE_DOWN) || Boolean(type == MouseEvent.MOUSE_MOVE) || Boolean(type == MouseEvent.MOUSE_OVER) || Boolean(type == MouseEvent.MOUSE_OUT) || Boolean(type == MouseEvent.ROLL_OUT) || Boolean(type == MouseEvent.ROLL_OVER) || Boolean(type == MouseEvent.MOUSE_UP) || Boolean(type == MouseEvent.MOUSE_WHEEL))
         {
            if(--this.mouseEventReferenceCount == 0)
            {
               this.hasMouseListeners = false;
            }
         }
      }
      
      mx_internal function $addEventListener(type:String, listener:Function, useCapture:Boolean = false, priority:int = 0, useWeakReference:Boolean = false) : void
      {
         super.addEventListener(type,listener,useCapture,priority,useWeakReference);
      }
      
      mx_internal function $removeEventListener(type:String, listener:Function, useCapture:Boolean = false) : void
      {
         super.removeEventListener(type,listener,useCapture);
      }
      
      [Inspectable(environment="none")]
      override public function get focusPane() : Sprite
      {
         return this._focusPane;
      }
      
      override public function set focusPane(value:Sprite) : void
      {
         if(value)
         {
            this.overlay.addDisplayObject(value,OverlayDepth.FOCUS_PANE);
            value.x = 0;
            value.y = 0;
            value.scrollRect = null;
            this._focusPane = value;
         }
         else
         {
            this.overlay.removeDisplayObject(this._focusPane);
            this._focusPane = null;
         }
      }
      
      public function get numElements() : int
      {
         return -1;
      }
      
      public function getElementAt(index:int) : IVisualElement
      {
         return null;
      }
      
      public function getVirtualElementAt(index:int, eltWidth:Number = NaN, eltHeight:Number = NaN) : IVisualElement
      {
         return this.getElementAt(index);
      }
      
      public function getElementIndex(element:IVisualElement) : int
      {
         return -1;
      }
      
      [Inspectable(category="General")]
      override public function get mask() : DisplayObject
      {
         return this._mask;
      }
      
      override public function set mask(value:DisplayObject) : void
      {
         if(this._mask !== value)
         {
            if(Boolean(this._mask) && Boolean(this._mask.parent === this))
            {
               this.overlay.removeDisplayObject(this._mask);
            }
            this._mask = value;
            this.maskChanged = true;
            this.invalidateDisplayList();
         }
         super.mask = value;
      }
      
      [Inspectable(defaultValue="clip",category="General",enumeration="clip,alpha,luminosity")]
      [Bindable("propertyChange")]
      public function get maskType() : String
      {
         return this._maskType;
      }
      
      public function set maskType(value:String) : void
      {
         if(this._maskType != value)
         {
            this._maskType = value;
            this.maskTypeChanged = true;
            this.invalidateDisplayList();
         }
      }
      
      [Inspectable(defaultValue="false",category="General",enumeration="true,false")]
      public function get luminosityInvert() : Boolean
      {
         return this._luminosityInvert;
      }
      
      public function set luminosityInvert(value:Boolean) : void
      {
         if(this._luminosityInvert == value)
         {
            return;
         }
         this._luminosityInvert = value;
         this.luminositySettingsChanged = true;
         this.invalidateDisplayList();
      }
      
      [Inspectable(defaultValue="false",category="General",enumeration="true,false")]
      public function get luminosityClip() : Boolean
      {
         return this._luminosityClip;
      }
      
      public function set luminosityClip(value:Boolean) : void
      {
         if(this._luminosityClip == value)
         {
            return;
         }
         this._luminosityClip = value;
         this.luminositySettingsChanged = true;
         this.invalidateDisplayList();
      }
      
      public function set verticalScrollPosition(param1:Number) : void
      {
         var _loc2_:Object = this.verticalScrollPosition;
         if(_loc2_ !== param1)
         {
            this._1010846676verticalScrollPosition = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"verticalScrollPosition",_loc2_,param1));
            }
         }
      }
      
      public function set horizontalScrollPosition(param1:Number) : void
      {
         var _loc2_:Object = this.horizontalScrollPosition;
         if(_loc2_ !== param1)
         {
            this._754184102horizontalScrollPosition = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"horizontalScrollPosition",_loc2_,param1));
            }
         }
      }
   }
}
