package spark.components
{
   import spark.components.supportClasses.ScrollBarBase;
   import mx.core.mx_internal;
   import spark.core.IViewport;
   import flash.events.MouseEvent;
   import flash.geom.Point;
   import spark.core.NavigationUnit;
   import mx.events.PropertyChangeEvent;
   import mx.events.ResizeEvent;
   import mx.core.IInvalidating;
   
   use namespace mx_internal;
   
   [DefaultTriggerEvent("change")]
   [IconFile("VScrollBar.png")]
   public class VScrollBar extends ScrollBarBase
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function VScrollBar()
      {
         super();
      }
      
      private function updateMaximumAndPageSize() : void
      {
         var vsp:Number = viewport.verticalScrollPosition;
         var viewportHeight:Number = !!isNaN(viewport.height)?Number(0):Number(viewport.height);
         var cHeight:Number = viewport.contentHeight;
         maximum = cHeight == 0?Number(vsp):Number(cHeight - viewportHeight);
         pageSize = viewportHeight;
      }
      
      override public function set viewport(newViewport:IViewport) : void
      {
         var oldViewport:IViewport = super.viewport;
         if(oldViewport == newViewport)
         {
            return;
         }
         if(oldViewport)
         {
            oldViewport.removeEventListener(MouseEvent.MOUSE_WHEEL,this.mouseWheelHandler);
            removeEventListener(MouseEvent.MOUSE_WHEEL,this.mouseWheelHandler);
         }
         super.viewport = newViewport;
         if(newViewport)
         {
            this.updateMaximumAndPageSize();
            value = newViewport.verticalScrollPosition;
            newViewport.addEventListener(MouseEvent.MOUSE_WHEEL,this.mouseWheelHandler);
            addEventListener(MouseEvent.MOUSE_WHEEL,this.mouseWheelHandler);
         }
      }
      
      override protected function pointToValue(x:Number, y:Number) : Number
      {
         if(Boolean(!thumb) || Boolean(!track))
         {
            return 0;
         }
         var r:Number = track.getLayoutBoundsHeight() - thumb.getLayoutBoundsHeight();
         return minimum + (r != 0?y / r * (maximum - minimum):0);
      }
      
      override protected function updateSkinDisplayList() : void
      {
         var thumbPos:Point = null;
         if(Boolean(!thumb) || Boolean(!track))
         {
            return;
         }
         var trackSize:Number = track.getLayoutBoundsHeight();
         var range:Number = maximum - minimum;
         var thumbPosTrackY:Number = 0;
         var thumbPosParentY:Number = 0;
         var thumbSize:Number = trackSize;
         if(range > 0)
         {
            if(getStyle("fixedThumbSize") === false)
            {
               thumbSize = Math.min(pageSize / (range + pageSize) * trackSize,trackSize);
               thumbSize = Math.max(thumb.minHeight,thumbSize);
            }
            else
            {
               thumbSize = Boolean(thumb)?Number(thumb.height):Number(0);
            }
            thumbPosTrackY = (value - minimum) * ((trackSize - thumbSize) / range);
         }
         if(getStyle("fixedThumbSize") === false)
         {
            thumb.setLayoutBoundsSize(NaN,thumbSize);
         }
         if(getStyle("autoThumbVisibility") === true)
         {
            thumb.visible = thumbSize < trackSize;
         }
         thumbPos = track.localToGlobal(new Point(0,thumbPosTrackY));
         thumbPosParentY = thumb.parent.globalToLocal(thumbPos).y;
         thumb.setLayoutBoundsPosition(thumb.getLayoutBoundsX(),Math.round(thumbPosParentY));
      }
      
      override protected function setValue(value:Number) : void
      {
         super.setValue(value);
         if(viewport)
         {
            viewport.verticalScrollPosition = value;
         }
      }
      
      override public function changeValueByPage(increase:Boolean = true) : void
      {
         var oldPageSize:Number = NaN;
         if(viewport)
         {
            oldPageSize = pageSize;
            pageSize = Math.abs(viewport.getVerticalScrollPositionDelta(!!increase?uint(NavigationUnit.PAGE_DOWN):uint(NavigationUnit.PAGE_UP)));
         }
         super.changeValueByPage(increase);
         if(viewport)
         {
            pageSize = oldPageSize;
         }
      }
      
      override protected function animatePaging(newValue:Number, pageSize:Number) : void
      {
         var vpPageSize:Number = NaN;
         if(viewport)
         {
            vpPageSize = Math.abs(viewport.getVerticalScrollPositionDelta(newValue > value?uint(NavigationUnit.PAGE_DOWN):uint(NavigationUnit.PAGE_UP)));
            super.animatePaging(newValue,vpPageSize);
            return;
         }
         super.animatePaging(newValue,pageSize);
      }
      
      override public function changeValueByStep(increase:Boolean = true) : void
      {
         var oldStepSize:Number = NaN;
         if(viewport)
         {
            oldStepSize = stepSize;
            stepSize = Math.abs(viewport.getVerticalScrollPositionDelta(!!increase?uint(NavigationUnit.DOWN):uint(NavigationUnit.UP)));
         }
         super.changeValueByStep(increase);
         if(viewport)
         {
            stepSize = oldStepSize;
         }
      }
      
      override protected function partAdded(partName:String, instance:Object) : void
      {
         if(instance == thumb)
         {
            thumb.setConstraintValue("top",undefined);
            thumb.setConstraintValue("bottom",undefined);
            thumb.setConstraintValue("verticalCenter",undefined);
         }
         super.partAdded(partName,instance);
      }
      
      override mx_internal function viewportVerticalScrollPositionChangeHandler(event:PropertyChangeEvent) : void
      {
         if(viewport)
         {
            value = viewport.verticalScrollPosition;
         }
      }
      
      override mx_internal function viewportResizeHandler(event:ResizeEvent) : void
      {
         if(viewport)
         {
            this.updateMaximumAndPageSize();
         }
      }
      
      override mx_internal function viewportContentHeightChangeHandler(event:PropertyChangeEvent) : void
      {
         var viewportHeight:Number = NaN;
         if(viewport)
         {
            viewportHeight = !!isNaN(viewport.height)?Number(0):Number(viewport.height);
            maximum = viewport.contentHeight - viewport.height;
         }
      }
      
      mx_internal function mouseWheelHandler(event:MouseEvent) : void
      {
         var navigationUnit:uint = 0;
         var vspDelta:Number = NaN;
         var vp:IViewport = viewport;
         if(Boolean(event.isDefaultPrevented()) || Boolean(!vp) || Boolean(!vp.visible))
         {
            return;
         }
         var nSteps:uint = Math.abs(event.delta);
         navigationUnit = event.delta < 0?uint(NavigationUnit.DOWN):uint(NavigationUnit.UP);
         for(var vStep:int = 0; vStep < nSteps; vStep++)
         {
            vspDelta = vp.getVerticalScrollPositionDelta(navigationUnit);
            if(!isNaN(vspDelta))
            {
               vp.verticalScrollPosition = vp.verticalScrollPosition + vspDelta;
               if(vp is IInvalidating)
               {
                  IInvalidating(vp).validateNow();
               }
            }
         }
         event.preventDefault();
      }
   }
}
