package spark.components
{
   import spark.components.supportClasses.SkinnableContainerBase;
   import mx.core.mx_internal;
   import mx.utils.BitFlagUtil;
   import mx.collections.IList;
   import flash.events.Event;
   import mx.core.IFactory;
   import spark.layouts.supportClasses.LayoutBase;
   import mx.core.IVisualElement;
   import mx.core.IDataRenderer;
   import spark.events.RendererExistenceEvent;
   
   use namespace mx_internal;
   
   [IconFile("SkinnableDataContainer.png")]
   [DefaultProperty("dataProvider")]
   [Style(minValue="0.0",inherit="no",name="focusThickness",format="Length",type="Number")]
   [Style(inherit="yes",name="focusColor",format="Color",theme="spark",type="uint")]
   [Style(minValue="0.0",maxValue="1.0",inherit="no",name="focusAlpha",theme="spark",type="Number")]
   [Style(inherit="yes",name="typographicCase",type="String",enumeration="default,capsToSmallCaps,uppercase,lowercase,lowercaseToSmallCaps")]
   [Style(inherit="yes",name="trackingRight",type="Object")]
   [Style(inherit="yes",name="trackingLeft",type="Object")]
   [Style(inherit="yes",name="textJustify",type="String",enumeration="interWord,distribute")]
   [Style(inherit="yes",name="textDecoration",type="String",enumeration="none,underline")]
   [Style(minValue="0.0",maxValue="1.0",inherit="yes",name="textAlpha",type="Number")]
   [Style(inherit="yes",name="textAlignLast",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="textAlign",type="String",enumeration="start,end,left,right,center,justify")]
   [Style(inherit="yes",name="renderingMode",type="String",enumeration="cff,normal")]
   [Style(inherit="yes",name="locale",type="String")]
   [Style(inherit="yes",name="lineThrough",type="Boolean")]
   [Style(inherit="yes",name="lineHeight",type="Object")]
   [Style(inherit="yes",name="ligatureLevel",type="String",enumeration="common,minimum,uncommon,exotic")]
   [Style(inherit="yes",name="kerning",type="String",enumeration="auto,on,off")]
   [Style(inherit="yes",name="justificationStyle",type="String",enumeration="auto,prioritizeLeastAdjustment,pushInKinsoku,pushOutOnly")]
   [Style(inherit="yes",name="justificationRule",type="String",enumeration="auto,space,eastAsian")]
   [Style(inherit="yes",name="fontWeight",type="String",enumeration="normal,bold")]
   [Style(inherit="yes",name="fontStyle",type="String",enumeration="normal,italic")]
   [Style(minValue="1.0",maxValue="720.0",inherit="yes",name="fontSize",format="Length",type="Number")]
   [Style(inherit="yes",name="fontLookup",type="String",enumeration="auto,device,embeddedCFF")]
   [Style(inherit="yes",name="fontFamily",type="String")]
   [Style(inherit="yes",name="dominantBaseline",type="String",enumeration="auto,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   [Style(inherit="yes",name="direction",type="String",enumeration="ltr,rtl")]
   [Style(inherit="yes",name="digitWidth",type="String",enumeration="default,proportional,tabular")]
   [Style(inherit="yes",name="digitCase",type="String",enumeration="default,lining,oldStyle")]
   [Style(inherit="yes",name="color",format="Color",type="uint")]
   [Style(inherit="yes",name="cffHinting",type="String",enumeration="horizontalStem,none")]
   [Style(inherit="yes",name="baselineShift",type="Object")]
   [Style(inherit="yes",name="alignmentBaseline",type="String",enumeration="useDominantBaseline,roman,ascent,descent,ideographicTop,ideographicCenter,ideographicBottom")]
   [Event(name="rendererRemove",type="spark.events.RendererExistenceEvent")]
   [Event(name="rendererAdd",type="spark.events.RendererExistenceEvent")]
   public class SkinnableDataContainer extends SkinnableContainerBase implements IItemRendererOwner
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static const AUTO_LAYOUT_PROPERTY_FLAG:uint = 1 << 0;
      
      private static const DATA_PROVIDER_PROPERTY_FLAG:uint = 1 << 1;
      
      private static const ITEM_RENDERER_PROPERTY_FLAG:uint = 1 << 2;
      
      private static const ITEM_RENDERER_FUNCTION_PROPERTY_FLAG:uint = 1 << 3;
      
      private static const LAYOUT_PROPERTY_FLAG:uint = 1 << 4;
      
      private static const TYPICAL_ITEM_PROPERTY_FLAG:uint = 1 << 5;
       
      [SkinPart(required="false")]
      public var dataGroup:spark.components.DataGroup;
      
      private var dataGroupProperties:Object;
      
      public function SkinnableDataContainer()
      {
         this.dataGroupProperties = {};
         super();
      }
      
      [Inspectable(defaultValue="true")]
      public function get autoLayout() : Boolean
      {
         var v:* = undefined;
         if(this.dataGroup)
         {
            return this.dataGroup.autoLayout;
         }
         v = this.dataGroupProperties.autoLayout;
         return v === undefined?Boolean(true):Boolean(v);
      }
      
      public function set autoLayout(value:Boolean) : void
      {
         if(this.dataGroup)
         {
            this.dataGroup.autoLayout = value;
            this.dataGroupProperties = BitFlagUtil.update(this.dataGroupProperties as uint,AUTO_LAYOUT_PROPERTY_FLAG,true);
         }
         else
         {
            this.dataGroupProperties.autoLayout = value;
         }
      }
      
      [Bindable("dataProviderChanged")]
      public function get dataProvider() : IList
      {
         return Boolean(this.dataGroup)?this.dataGroup.dataProvider:this.dataGroupProperties.dataProvider;
      }
      
      public function set dataProvider(value:IList) : void
      {
         if(this.dataGroup)
         {
            this.dataGroup.dataProvider = value;
            this.dataGroupProperties = BitFlagUtil.update(this.dataGroupProperties as uint,DATA_PROVIDER_PROPERTY_FLAG,true);
         }
         else
         {
            this.dataGroupProperties.dataProvider = value;
         }
         dispatchEvent(new Event("dataProviderChanged"));
      }
      
      public function get itemRenderer() : IFactory
      {
         return Boolean(this.dataGroup)?this.dataGroup.itemRenderer:this.dataGroupProperties.itemRenderer;
      }
      
      public function set itemRenderer(value:IFactory) : void
      {
         if(this.dataGroup)
         {
            this.dataGroup.itemRenderer = value;
            this.dataGroupProperties = BitFlagUtil.update(this.dataGroupProperties as uint,ITEM_RENDERER_PROPERTY_FLAG,true);
         }
         else
         {
            this.dataGroupProperties.itemRenderer = value;
         }
      }
      
      public function get itemRendererFunction() : Function
      {
         return Boolean(this.dataGroup)?this.dataGroup.itemRendererFunction:this.dataGroupProperties.itemRendererFunction;
      }
      
      public function set itemRendererFunction(value:Function) : void
      {
         if(this.dataGroup)
         {
            this.dataGroup.itemRendererFunction = value;
            this.dataGroupProperties = BitFlagUtil.update(this.dataGroupProperties as uint,ITEM_RENDERER_FUNCTION_PROPERTY_FLAG,true);
         }
         else
         {
            this.dataGroupProperties.itemRendererFunction = value;
         }
      }
      
      public function get layout() : LayoutBase
      {
         return Boolean(this.dataGroup)?this.dataGroup.layout:this.dataGroupProperties.layout;
      }
      
      public function set layout(value:LayoutBase) : void
      {
         if(this.dataGroup)
         {
            this.dataGroup.layout = value;
            this.dataGroupProperties = BitFlagUtil.update(this.dataGroupProperties as uint,LAYOUT_PROPERTY_FLAG,true);
         }
         else
         {
            this.dataGroupProperties.layout = value;
         }
      }
      
      public function get typicalItem() : Object
      {
         return Boolean(this.dataGroup)?this.dataGroup.typicalItem:this.dataGroupProperties.typicalItem;
      }
      
      public function set typicalItem(value:Object) : void
      {
         if(this.dataGroup)
         {
            this.dataGroup.typicalItem = value;
            this.dataGroupProperties = BitFlagUtil.update(this.dataGroupProperties as uint,TYPICAL_ITEM_PROPERTY_FLAG,true);
         }
         else
         {
            this.dataGroupProperties.typicalItem = value;
         }
      }
      
      public function itemToLabel(item:Object) : String
      {
         if(item !== null)
         {
            return item.toString();
         }
         return " ";
      }
      
      public function updateRenderer(renderer:IVisualElement, itemIndex:int, data:Object) : void
      {
         renderer.owner = this;
         if(renderer is IItemRenderer)
         {
            IItemRenderer(renderer).itemIndex = itemIndex;
         }
         if(renderer is IItemRenderer)
         {
            IItemRenderer(renderer).label = this.itemToLabel(data);
         }
         if(Boolean(renderer is IDataRenderer) && Boolean(renderer !== data))
         {
            IDataRenderer(renderer).data = data;
         }
      }
      
      override protected function partAdded(partName:String, instance:Object) : void
      {
         var newDataGroupProperties:uint = 0;
         super.partAdded(partName,instance);
         if(instance == this.dataGroup)
         {
            newDataGroupProperties = 0;
            if(this.dataGroupProperties.layout !== undefined)
            {
               this.dataGroup.layout = this.dataGroupProperties.layout;
               newDataGroupProperties = BitFlagUtil.update(newDataGroupProperties as uint,LAYOUT_PROPERTY_FLAG,true);
            }
            if(this.dataGroupProperties.autoLayout !== undefined)
            {
               this.dataGroup.autoLayout = this.dataGroupProperties.autoLayout;
               newDataGroupProperties = BitFlagUtil.update(newDataGroupProperties as uint,AUTO_LAYOUT_PROPERTY_FLAG,true);
            }
            if(this.dataGroupProperties.dataProvider !== undefined)
            {
               this.dataGroup.dataProvider = this.dataGroupProperties.dataProvider;
               newDataGroupProperties = BitFlagUtil.update(newDataGroupProperties as uint,DATA_PROVIDER_PROPERTY_FLAG,true);
            }
            if(this.dataGroupProperties.itemRenderer !== undefined)
            {
               this.dataGroup.itemRenderer = this.dataGroupProperties.itemRenderer;
               newDataGroupProperties = BitFlagUtil.update(newDataGroupProperties as uint,ITEM_RENDERER_PROPERTY_FLAG,true);
            }
            if(this.dataGroupProperties.itemRendererFunction !== undefined)
            {
               this.dataGroup.itemRendererFunction = this.dataGroupProperties.itemRendererFunction;
               newDataGroupProperties = BitFlagUtil.update(newDataGroupProperties as uint,ITEM_RENDERER_FUNCTION_PROPERTY_FLAG,true);
            }
            if(this.dataGroupProperties.typicalItem !== undefined)
            {
               this.dataGroup.typicalItem = this.dataGroupProperties.typicalItem;
               newDataGroupProperties = BitFlagUtil.update(newDataGroupProperties as uint,TYPICAL_ITEM_PROPERTY_FLAG,true);
            }
            this.dataGroupProperties = newDataGroupProperties;
            this.dataGroup.rendererUpdateDelegate = this;
            if(hasEventListener(RendererExistenceEvent.RENDERER_ADD))
            {
               this.dataGroup.addEventListener(RendererExistenceEvent.RENDERER_ADD,dispatchEvent);
            }
            if(hasEventListener(RendererExistenceEvent.RENDERER_REMOVE))
            {
               this.dataGroup.addEventListener(RendererExistenceEvent.RENDERER_REMOVE,dispatchEvent);
            }
         }
      }
      
      override protected function partRemoved(partName:String, instance:Object) : void
      {
         var newDataGroupProperties:Object = null;
         super.partRemoved(partName,instance);
         if(instance == this.dataGroup)
         {
            this.dataGroup.removeEventListener(RendererExistenceEvent.RENDERER_ADD,dispatchEvent);
            this.dataGroup.removeEventListener(RendererExistenceEvent.RENDERER_REMOVE,dispatchEvent);
            newDataGroupProperties = {};
            if(BitFlagUtil.isSet(this.dataGroupProperties as uint,LAYOUT_PROPERTY_FLAG))
            {
               newDataGroupProperties.layout = this.dataGroup.layout;
            }
            if(BitFlagUtil.isSet(this.dataGroupProperties as uint,AUTO_LAYOUT_PROPERTY_FLAG))
            {
               newDataGroupProperties.autoLayout = this.dataGroup.autoLayout;
            }
            if(BitFlagUtil.isSet(this.dataGroupProperties as uint,DATA_PROVIDER_PROPERTY_FLAG))
            {
               newDataGroupProperties.dataProvider = this.dataGroup.dataProvider;
            }
            if(BitFlagUtil.isSet(this.dataGroupProperties as uint,ITEM_RENDERER_PROPERTY_FLAG))
            {
               newDataGroupProperties.itemRenderer = this.dataGroup.itemRenderer;
            }
            if(BitFlagUtil.isSet(this.dataGroupProperties as uint,ITEM_RENDERER_FUNCTION_PROPERTY_FLAG))
            {
               newDataGroupProperties.itemRendererFunction = this.dataGroup.itemRendererFunction;
            }
            if(BitFlagUtil.isSet(this.dataGroupProperties as uint,TYPICAL_ITEM_PROPERTY_FLAG))
            {
               newDataGroupProperties.typicalItem = this.dataGroup.typicalItem;
            }
            this.dataGroupProperties = newDataGroupProperties;
            this.dataGroup.dataProvider = null;
            this.dataGroup.layout = null;
            this.dataGroup.rendererUpdateDelegate = null;
         }
      }
      
      override public function addEventListener(type:String, listener:Function, useCapture:Boolean = false, priority:int = 0, useWeakReference:Boolean = false) : void
      {
         super.addEventListener(type,listener,useCapture,priority,useWeakReference);
         if(Boolean(type == RendererExistenceEvent.RENDERER_ADD) && Boolean(this.dataGroup))
         {
            this.dataGroup.addEventListener(RendererExistenceEvent.RENDERER_ADD,dispatchEvent);
         }
         if(Boolean(type == RendererExistenceEvent.RENDERER_REMOVE) && Boolean(this.dataGroup))
         {
            this.dataGroup.addEventListener(RendererExistenceEvent.RENDERER_REMOVE,dispatchEvent);
         }
      }
      
      override public function removeEventListener(type:String, listener:Function, useCapture:Boolean = false) : void
      {
         super.removeEventListener(type,listener,useCapture);
         if(Boolean(type == RendererExistenceEvent.RENDERER_ADD) && Boolean(this.dataGroup))
         {
            if(!hasEventListener(RendererExistenceEvent.RENDERER_ADD))
            {
               this.dataGroup.removeEventListener(RendererExistenceEvent.RENDERER_ADD,dispatchEvent);
            }
         }
         if(Boolean(type == RendererExistenceEvent.RENDERER_REMOVE) && Boolean(this.dataGroup))
         {
            if(!hasEventListener(RendererExistenceEvent.RENDERER_REMOVE))
            {
               this.dataGroup.removeEventListener(RendererExistenceEvent.RENDERER_REMOVE,dispatchEvent);
            }
         }
      }
   }
}
