package org.alivepdf.images
{
   import flash.utils.ByteArray;
   
   public class PDFImage implements IImage
   {
       
      protected var _width:int;
      
      protected var _height:int;
      
      protected var _resourceId:int;
      
      protected var _n:int;
      
      protected var _colorSpace:String;
      
      protected var _bitsPerComponent:int = 8;
      
      protected var _filter:String;
      
      protected var _transparency:String;
      
      protected var _parameters:String;
      
      protected var _pal:String;
      
      protected var ct:Number;
      
      protected var progressive:Boolean;
      
      protected var stream:ByteArray;
      
      public function PDFImage(imageStream:ByteArray, colorSpace:String, id:int)
      {
         super();
         this.stream = imageStream;
         this._colorSpace = colorSpace;
         this.resourceId = id;
         this.parse();
      }
      
      public function get transparency() : String
      {
         return this._transparency;
      }
      
      public function get resourceId() : int
      {
         return this._resourceId;
      }
      
      public function set resourceId(value:int) : void
      {
         this._resourceId = value;
      }
      
      public function get parameters() : String
      {
         return this._parameters;
      }
      
      public function set pal(value:String) : void
      {
         this._pal = value;
      }
      
      public function get pal() : String
      {
         return this._pal;
      }
      
      public function set n(value:int) : void
      {
         this._n = value;
      }
      
      public function get n() : int
      {
         return this._n;
      }
      
      public function get filter() : String
      {
         return this._filter;
      }
      
      public function set colorSpace(value:String) : void
      {
         this._colorSpace = value;
      }
      
      public function get colorSpace() : String
      {
         return this._colorSpace;
      }
      
      public function set bitsPerComponent(value:int) : void
      {
         this._bitsPerComponent = value;
      }
      
      public function get bitsPerComponent() : int
      {
         return this._bitsPerComponent;
      }
      
      public function get height() : int
      {
         return this._height;
      }
      
      public function get width() : int
      {
         return this._width;
      }
      
      protected function parse() : void
      {
      }
      
      public function get bytes() : ByteArray
      {
         return this.stream;
      }
   }
}
