package org.alivepdf.images
{
   import flash.utils.ByteArray;
   import org.alivepdf.decoding.Filter;
   
   public class JPEGImage extends PDFImage
   {
      
      public static const FORMAT:int = 0;
      
      public static const HEADER:int = 65496;
       
      protected var format:int;
      
      protected var physicalWidthDpi:int;
      
      protected var physicalHeightDpi:int;
      
      public function JPEGImage(imageStream:ByteArray, colorSpace:String, id:int)
      {
         super(imageStream,colorSpace,id);
         _filter = Filter.DCT_DECODE;
      }
      
      private static function equals(a1:ByteArray, offs1:int, a2:ByteArray, offs2:int, num:int) : Boolean
      {
         while(num-- > 0)
         {
            if(a1[offs1++] != a2[offs2++])
            {
               return false;
            }
         }
         return true;
      }
      
      override protected function parse() : void
      {
         var data:ByteArray = null;
         var marker:int = 0;
         var size:int = 0;
         var x:int = 0;
         var y:int = 0;
         data = new ByteArray();
         var appID:ByteArray = new ByteArray();
         appID.writeByte(74);
         appID.writeByte(70);
         appID.writeByte(73);
         appID.writeByte(70);
         appID.writeByte(0);
         while(true)
         {
            if(this.read(data,0,4) != 4)
            {
               return;
            }
            marker = this.getShortBigEndian(data,0);
            size = this.getShortBigEndian(data,2);
            if((marker & 65280) != 65280)
            {
               return;
            }
            if(marker == 65504)
            {
               if(size < 14)
               {
                  return;
               }
               if(this.read(data,0,12) != 12)
               {
                  return;
               }
               if(equals(appID,0,data,0,5))
               {
                  if(data[7] == 1)
                  {
                     this.physicalWidthDpi = this.getShortBigEndian(data,8);
                     this.physicalHeightDpi = this.getShortBigEndian(data,10);
                     if((data[12] & 255) == 1)
                     {
                        colorSpace = ColorSpace.DEVICE_GRAY;
                     }
                  }
                  else if(data[7] == 2)
                  {
                     x = this.getShortBigEndian(data,8);
                     y = this.getShortBigEndian(data,10);
                     if((data[12] & 255) == 1)
                     {
                        colorSpace = ColorSpace.DEVICE_GRAY;
                     }
                     this.physicalWidthDpi = int(x * 2.54);
                     this.physicalHeightDpi = int(y * 2.54);
                  }
               }
               stream.position = stream.position + (size - 14);
            }
            else if(Boolean(marker >= 65472) && Boolean(marker <= 65487) && Boolean(marker != 65476) && Boolean(marker != 65480))
            {
               if(this.read(data,0,6) != 6)
               {
                  return;
               }
               this.format = JPEGImage.FORMAT;
               bitsPerComponent = colorSpace != ColorSpace.DEVICE_RGB?int(8):int((data[0] & 255) * (data[5] & 255) / 3);
               progressive = Boolean(marker == 65474) || Boolean(marker == 65478) || Boolean(marker == 65482) || Boolean(marker == 65486);
               _width = this.getShortBigEndian(data,3);
               _height = this.getShortBigEndian(data,1);
               if((data[5] & 255) == 1)
               {
                  colorSpace = ColorSpace.DEVICE_GRAY;
               }
            }
            else
            {
               stream.position = stream.position + (size - 2);
            }
         }
      }
      
      private function read(dest:ByteArray, offset:int, num:int) : int
      {
         stream.readBytes(dest,offset,num);
         return num;
      }
      
      private function getShortBigEndian(a:ByteArray, offs:int) : int
      {
         return (a[offs] & 255) << 8 | a[offs + 1] & 255;
      }
   }
}
