package org.alivepdf.fonts
{
   import flash.utils.ByteArray;
   import org.alivepdf.events.CharacterEvent;
   
   public class EmbeddedFont extends CoreFont implements IFont
   {
       
      protected var _differences:String;
      
      protected var _stream:ByteArray;
      
      protected var _description:org.alivepdf.fonts.FontDescription;
      
      protected var _originalSize:int;
      
      protected var _version:String;
      
      protected var _weight:String;
      
      protected var _widths:Object;
      
      protected var _afmParser:org.alivepdf.fonts.AFMParser;
      
      protected var _encoding:Class;
      
      public function EmbeddedFont(stream:ByteArray, afm:ByteArray, codePage:Class)
      {
         this._afmParser = new org.alivepdf.fonts.AFMParser(stream,afm,codePage);
         this._widths = this._afmParser.widths;
         FontMetrics.add(this._afmParser.fontName,this._widths);
         super(this._afmParser.fontName);
         _type = FontType.TRUE_TYPE;
         this._encoding = codePage;
         this._description = new org.alivepdf.fonts.FontDescription(this._afmParser.weight,this._afmParser.missingWidth,this._afmParser.ascender,this._afmParser.descender,this._afmParser.capHeight,32,this._afmParser.boundingBox,this._afmParser.italicAngle,this._afmParser.stemV,this._afmParser.missingWidth);
         _underlinePosition = this._afmParser.underlinePosition;
         _underlineThickness = this._afmParser.underlineThickness;
         this._weight = this._afmParser.weight;
         this._differences = this._afmParser.differences;
         this._originalSize = stream.length;
         stream.compress();
         this._stream = stream;
      }
      
      private function characterMissing(e:CharacterEvent) : void
      {
         dispatchEvent(e);
      }
      
      public function get encoding() : Class
      {
         return this._encoding;
      }
      
      public function get widths() : Object
      {
         return this._widths;
      }
      
      public function get weight() : String
      {
         return this._weight;
      }
      
      public function get originalSize() : int
      {
         return this._originalSize;
      }
      
      public function get description() : org.alivepdf.fonts.FontDescription
      {
         return this._description;
      }
      
      public function get differences() : String
      {
         return this._differences;
      }
      
      public function set differences(differences:String) : void
      {
         this._differences = differences;
      }
      
      public function get stream() : ByteArray
      {
         return this._stream;
      }
      
      override public function toString() : String
      {
         return "[EmbeddedFont name=" + name + " weight=" + this.weight + " type=" + type + "]";
      }
   }
}
