package org.alivepdf.encoding
{
   import flash.utils.ByteArray;
   import flash.display.BitmapData;
   import flash.geom.Rectangle;
   
   public final class PNGEncoder
   {
       
      public function PNGEncoder()
      {
         super();
      }
      
      public static function encode(image:BitmapData, transparent:Boolean = false) : ByteArray
      {
         var IDAT:ByteArray = new ByteArray();
         if(transparent)
         {
            writeRaw(image,IDAT);
         }
         else
         {
            writeSub(image,IDAT);
         }
         IDAT.compress();
         return IDAT;
      }
      
      private static function writeRaw(img:BitmapData, IDAT:ByteArray) : void
      {
         var subImage:ByteArray = null;
         var p:uint = 0;
         var j:int = 0;
         var h:int = img.height;
         var w:int = img.width;
         var transparent:Boolean = img.transparent;
         var rectangle:Rectangle = new Rectangle(0,0,w,1);
         for(var i:int = 0; i < h; i++)
         {
            if(!transparent)
            {
               rectangle.y = i;
               subImage = img.getPixels(rectangle);
               subImage[0] = 0;
               IDAT.writeBytes(subImage);
               IDAT.writeByte(255);
            }
            else
            {
               IDAT.writeByte(0);
               for(j = 0; j < w; j++)
               {
                  p = img.getPixel32(j,i);
                  IDAT.writeUnsignedInt(uint((p & 16777215) << 8 | p >>> 24));
               }
            }
         }
      }
      
      private static function writeSub(image:BitmapData, IDAT:ByteArray) : void
      {
         var r1:uint = 0;
         var g1:uint = 0;
         var b1:uint = 0;
         var a1:uint = 0;
         var r2:uint = 0;
         var g2:uint = 0;
         var b2:uint = 0;
         var a2:uint = 0;
         var r3:uint = 0;
         var g3:uint = 0;
         var b3:uint = 0;
         var a3:uint = 0;
         var p:uint = 0;
         var j:int = 0;
         var k:int = 0;
         var h:int = image.height;
         var w:int = image.width;
         for(var i:int = 0; i < h; i++)
         {
            IDAT.writeByte(1);
            if(!image.transparent)
            {
               r1 = 0;
               g1 = 0;
               b1 = 0;
               a1 = 255;
               for(j = 0; j < w; j++)
               {
                  p = image.getPixel(j,i);
                  r2 = p >> 16 & 255;
                  g2 = p >> 8 & 255;
                  b2 = p & 255;
                  r3 = r2 - r1 + 256 & 255;
                  g3 = g2 - g1 + 256 & 255;
                  b3 = b2 - b1 + 256 & 255;
                  IDAT.writeByte(r3);
                  IDAT.writeByte(g3);
                  IDAT.writeByte(b3);
                  r1 = r2;
                  g1 = g2;
                  b1 = b2;
                  a1 = 0;
               }
            }
            else
            {
               r1 = 0;
               g1 = 0;
               b1 = 0;
               a1 = 0;
               for(k = 0; k < w; k++)
               {
                  p = image.getPixel32(k,i);
                  a2 = p >> 24 & 255;
                  r2 = p >> 16 & 255;
                  g2 = p >> 8 & 255;
                  b2 = p & 255;
                  r3 = r2 - r1 + 256 & 255;
                  g3 = g2 - g1 + 256 & 255;
                  b3 = b2 - b1 + 256 & 255;
                  a3 = a2 - a1 + 256 & 255;
                  IDAT.writeByte(r3);
                  IDAT.writeByte(g3);
                  IDAT.writeByte(b3);
                  IDAT.writeByte(a3);
                  r1 = r2;
                  g1 = g2;
                  b1 = b2;
                  a1 = a2;
               }
            }
         }
      }
   }
}
