package mx.utils
{
   import mx.core.mx_internal;
   import flash.utils.Dictionary;
   
   use namespace mx_internal;
   
   public class XMLNotifier
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      private static var instance:mx.utils.XMLNotifier;
       
      public function XMLNotifier(x:XMLNotifierSingleton)
      {
         super();
      }
      
      public static function getInstance() : mx.utils.XMLNotifier
      {
         if(!instance)
         {
            instance = new mx.utils.XMLNotifier(new XMLNotifierSingleton());
         }
         return instance;
      }
      
      mx_internal static function initializeXMLForNotification() : Function
      {
         var notificationFunction:Function = function(currentTarget:Object, ty:String, tar:Object, value:Object, detail:Object):void
         {
            var notifiable:* = null;
            var xmlWatchers:Dictionary = arguments.callee.watched;
            if(xmlWatchers != null)
            {
               for(notifiable in xmlWatchers)
               {
                  IXMLNotifiable(notifiable).xmlNotification(currentTarget,ty,tar,value,detail);
               }
            }
         };
         return notificationFunction;
      }
      
      public function watchXML(xml:Object, notifiable:IXMLNotifiable, uid:String = null) : void
      {
         var item:Object = null;
         var xmlItem:XML = null;
         var watcherFunction:Object = null;
         var xmlWatchers:Dictionary = null;
         if(Boolean(xml is XMLList) && Boolean(xml.length() > 1))
         {
            for each(item in xml)
            {
               this.watchXML(item,notifiable,uid);
            }
         }
         else
         {
            xmlItem = XML(xml);
            watcherFunction = xmlItem.notification();
            if(!(watcherFunction is Function))
            {
               watcherFunction = initializeXMLForNotification();
               xmlItem.setNotification(watcherFunction as Function);
               if(Boolean(uid) && Boolean(watcherFunction["uid"] == null))
               {
                  watcherFunction["uid"] = uid;
               }
            }
            if(watcherFunction["watched"] == undefined)
            {
               watcherFunction["watched"] = xmlWatchers = new Dictionary(true);
            }
            else
            {
               xmlWatchers = watcherFunction["watched"];
            }
            xmlWatchers[notifiable] = true;
         }
      }
      
      public function unwatchXML(xml:Object, notifiable:IXMLNotifiable) : void
      {
         var item:Object = null;
         var xmlItem:XML = null;
         var watcherFunction:Object = null;
         var xmlWatchers:Dictionary = null;
         if(Boolean(xml is XMLList) && Boolean(xml.length() > 1))
         {
            for each(item in xml)
            {
               this.unwatchXML(item,notifiable);
            }
         }
         else
         {
            xmlItem = XML(xml);
            watcherFunction = xmlItem.notification();
            if(!(watcherFunction is Function))
            {
               return;
            }
            if(watcherFunction["watched"] != undefined)
            {
               xmlWatchers = watcherFunction["watched"];
               delete xmlWatchers[notifiable];
            }
         }
      }
   }
}

class XMLNotifierSingleton
{
    
   function XMLNotifierSingleton()
   {
      super();
   }
}
