package mx.managers.layoutClasses
{
   import mx.core.mx_internal;
   import flash.utils.Dictionary;
   import mx.managers.ILayoutManagerClient;
   import flash.display.DisplayObject;
   import mx.core.IChildList;
   import mx.core.IRawChildrenContainer;
   import flash.display.DisplayObjectContainer;
   
   use namespace mx_internal;
   
   [ExcludeClass]
   public class PriorityQueue
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      private var arrayOfDictionaries:Array;
      
      private var minPriority:int = 0;
      
      private var maxPriority:int = -1;
      
      public var generation:int = 0;
      
      public function PriorityQueue()
      {
         this.arrayOfDictionaries = [];
         super();
      }
      
      public function addObject(obj:Object, priority:int) : void
      {
         if(!this.arrayOfDictionaries[priority])
         {
            this.arrayOfDictionaries[priority] = new Object();
            this.arrayOfDictionaries[priority].length = 0;
            this.arrayOfDictionaries[priority].items = new Dictionary(false);
         }
         if(this.arrayOfDictionaries[priority].items[obj] == null)
         {
            this.arrayOfDictionaries[priority].items[obj] = true;
            this.arrayOfDictionaries[priority].length++;
         }
         if(this.maxPriority < this.minPriority)
         {
            this.minPriority = this.maxPriority = priority;
         }
         else
         {
            if(priority < this.minPriority)
            {
               this.minPriority = priority;
            }
            if(priority > this.maxPriority)
            {
               this.maxPriority = priority;
            }
         }
         this.generation++;
      }
      
      public function removeLargest() : Object
      {
         var key:Object = null;
         var obj:* = null;
         if(this.minPriority <= this.maxPriority)
         {
            while(Boolean(!this.arrayOfDictionaries[this.maxPriority]) || Boolean(this.arrayOfDictionaries[this.maxPriority].length == 0))
            {
               this.maxPriority--;
               if(this.maxPriority < this.minPriority)
               {
                  return null;
               }
            }
            for(obj in this.arrayOfDictionaries[this.maxPriority].items)
            {
               this.removeChild(ILayoutManagerClient(key),this.maxPriority);
            }
            while(Boolean(!this.arrayOfDictionaries[this.maxPriority]) || Boolean(this.arrayOfDictionaries[this.maxPriority].length == 0))
            {
               this.maxPriority--;
               if(this.maxPriority < this.minPriority)
               {
                  break;
               }
            }
         }
         return obj;
      }
      
      public function removeLargestChild(client:ILayoutManagerClient) : Object
      {
         var key:* = null;
         var max:int = this.maxPriority;
         var min:int = client.nestLevel;
         while(true)
         {
            if(min <= max)
            {
               if(Boolean(this.arrayOfDictionaries[max]) && Boolean(this.arrayOfDictionaries[max].length > 0))
               {
                  if(max == client.nestLevel)
                  {
                     if(this.arrayOfDictionaries[max].items[client])
                     {
                        break;
                     }
                  }
                  else
                  {
                     for(key in this.arrayOfDictionaries[max].items)
                     {
                        if(Boolean(key is DisplayObject) && Boolean(this.contains(DisplayObject(client),DisplayObject(key))))
                        {
                           this.removeChild(ILayoutManagerClient(key),max);
                           return key;
                        }
                     }
                  }
                  max--;
                  continue;
               }
               if(max == this.maxPriority)
               {
                  this.maxPriority--;
               }
               max--;
               if(max >= min)
               {
                  continue;
               }
            }
            return null;
         }
         this.removeChild(ILayoutManagerClient(client),max);
         return client;
      }
      
      public function removeSmallest() : Object
      {
         var key:Object = null;
         var obj:* = null;
         if(this.minPriority <= this.maxPriority)
         {
            while(Boolean(!this.arrayOfDictionaries[this.minPriority]) || Boolean(this.arrayOfDictionaries[this.minPriority].length == 0))
            {
               this.minPriority++;
               if(this.minPriority > this.maxPriority)
               {
                  return null;
               }
            }
            for(obj in this.arrayOfDictionaries[this.minPriority].items)
            {
               this.removeChild(ILayoutManagerClient(key),this.minPriority);
            }
            while(Boolean(!this.arrayOfDictionaries[this.minPriority]) || Boolean(this.arrayOfDictionaries[this.minPriority].length == 0))
            {
               this.minPriority++;
               if(this.minPriority > this.maxPriority)
               {
                  break;
               }
            }
         }
         return obj;
      }
      
      public function removeSmallestChild(client:ILayoutManagerClient) : Object
      {
         var key:* = null;
         var min:int = client.nestLevel;
         while(true)
         {
            if(min <= this.maxPriority)
            {
               if(Boolean(this.arrayOfDictionaries[min]) && Boolean(this.arrayOfDictionaries[min].length > 0))
               {
                  if(min == client.nestLevel)
                  {
                     if(this.arrayOfDictionaries[min].items[client])
                     {
                        break;
                     }
                  }
                  else
                  {
                     for(key in this.arrayOfDictionaries[min].items)
                     {
                        if(Boolean(key is DisplayObject) && Boolean(this.contains(DisplayObject(client),DisplayObject(key))))
                        {
                           this.removeChild(ILayoutManagerClient(key),min);
                           return key;
                        }
                     }
                  }
                  min++;
                  continue;
               }
               if(min == this.minPriority)
               {
                  this.minPriority++;
               }
               min++;
               if(min <= this.maxPriority)
               {
                  continue;
               }
            }
            return null;
         }
         this.removeChild(ILayoutManagerClient(client),min);
         return client;
      }
      
      public function removeChild(client:ILayoutManagerClient, level:int = -1) : Object
      {
         var priority:int = level >= 0?int(level):int(client.nestLevel);
         if(Boolean(this.arrayOfDictionaries[priority]) && Boolean(this.arrayOfDictionaries[priority].items[client] != null))
         {
            delete this.arrayOfDictionaries[priority].items[client];
            this.arrayOfDictionaries[priority].length--;
            this.generation++;
            return client;
         }
         return null;
      }
      
      public function removeAll() : void
      {
         this.arrayOfDictionaries.splice(0);
         this.minPriority = 0;
         this.maxPriority = -1;
         this.generation = this.generation + 1;
      }
      
      public function isEmpty() : Boolean
      {
         return this.minPriority > this.maxPriority;
      }
      
      private function contains(parent:DisplayObject, child:DisplayObject) : Boolean
      {
         var rawChildren:IChildList = null;
         if(parent is IRawChildrenContainer)
         {
            rawChildren = IRawChildrenContainer(parent).rawChildren;
            return rawChildren.contains(child);
         }
         if(parent is DisplayObjectContainer)
         {
            return DisplayObjectContainer(parent).contains(child);
         }
         return parent == child;
      }
   }
}
