package mx.controls
{
   import mx.controls.scrollClasses.ScrollBar;
   import mx.core.mx_internal;
   import flash.ui.Keyboard;
   import mx.controls.scrollClasses.ScrollBarDirection;
   
   use namespace mx_internal;
   
   [Alternative(replacement="spark.components.VScrollBar",since="4.0")]
   [IconFile("VScrollBar.png")]
   [DefaultTriggerEvent("scroll")]
   [DefaultBindingProperty(destination="scrollPosition",source="scrollPosition")]
   [Exclude(kind="property",name="direction")]
   [Style(inherit="no",name="repeatInterval",format="Time",type="Number")]
   [Style(inherit="no",name="repeatDelay",format="Time",type="Number")]
   [Event(name="scroll",type="mx.events.ScrollEvent")]
   public class VScrollBar extends ScrollBar
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function VScrollBar()
      {
         super();
         super.direction = ScrollBarDirection.VERTICAL;
      }
      
      [Inspectable(environment="none")]
      override public function set direction(value:String) : void
      {
      }
      
      override public function get minWidth() : Number
      {
         return _minWidth;
      }
      
      override public function get minHeight() : Number
      {
         return _minHeight;
      }
      
      override protected function measure() : void
      {
         super.measure();
         measuredWidth = _minWidth;
         measuredHeight = _minHeight;
      }
      
      override mx_internal function isScrollBarKey(key:uint) : Boolean
      {
         if(key == Keyboard.UP)
         {
            lineScroll(-1);
            return true;
         }
         if(key == Keyboard.DOWN)
         {
            lineScroll(1);
            return true;
         }
         if(key == Keyboard.PAGE_UP)
         {
            pageScroll(-1);
            return true;
         }
         if(key == Keyboard.PAGE_DOWN)
         {
            pageScroll(1);
            return true;
         }
         return super.isScrollBarKey(key);
      }
   }
}
