package mx.controls
{
   import mx.core.UIComponent;
   import mx.core.IDataRenderer;
   import mx.controls.listClasses.IDropInListItemRenderer;
   import mx.managers.IFocusManagerComponent;
   import mx.controls.listClasses.IListItemRenderer;
   import mx.core.IFontContextComponent;
   import mx.core.IButton;
   import mx.core.mx_internal;
   import mx.core.UITextField;
   import mx.core.IFlexDisplayObject;
   import flash.utils.Timer;
   import mx.core.IUITextField;
   import mx.controls.dataGridClasses.DataGridListData;
   import mx.events.FlexEvent;
   import mx.core.IFlexModuleFactory;
   import flash.events.Event;
   import mx.controls.listClasses.BaseListData;
   import flash.display.DisplayObject;
   import mx.core.IUIComponent;
   import flash.text.TextLineMetrics;
   import mx.core.IBorder;
   import mx.core.IFlexAsset;
   import mx.core.EdgeMetrics;
   import mx.styles.ISimpleStyleClient;
   import mx.core.IProgrammaticSkin;
   import mx.core.IStateClient;
   import mx.core.ILayoutDirectionElement;
   import mx.core.IInvalidating;
   import mx.events.MoveEvent;
   import flash.text.TextFormatAlign;
   import mx.core.FlexVersion;
   import flash.events.TimerEvent;
   import flash.events.MouseEvent;
   import mx.events.SandboxMouseEvent;
   import flash.events.FocusEvent;
   import flash.events.KeyboardEvent;
   import flash.ui.Keyboard;
   
   use namespace mx_internal;
   
   [Alternative(replacement="spark.components.Button",since="4.0")]
   [IconFile("Button.png")]
   [DefaultTriggerEvent("click")]
   [DefaultBindingProperty(destination="label",source="selected")]
   [AccessibilityClass(implementation="mx.accessibility.ButtonAccImpl")]
   [Style(inherit="no",name="selectedDisabledIcon",type="Class")]
   [Style(inherit="no",name="selectedDownIcon",type="Class")]
   [Style(inherit="no",name="selectedOverIcon",type="Class")]
   [Style(inherit="no",name="selectedUpIcon",type="Class")]
   [Style(inherit="no",name="disabledIcon",type="Class")]
   [Style(inherit="no",name="downIcon",type="Class")]
   [Style(inherit="no",name="overIcon",type="Class")]
   [Style(inherit="no",name="upIcon",type="Class")]
   [Style(inherit="no",name="icon",type="Class",states="up, over, down, disabled, selectedUp, selectedOver, selectedDown, selectedDisabled")]
   [Style(inherit="no",name="selectedDisabledSkin",type="Class")]
   [Style(inherit="no",name="selectedDownSkin",type="Class")]
   [Style(inherit="no",name="selectedOverSkin",type="Class")]
   [Style(inherit="no",name="selectedUpSkin",type="Class")]
   [Style(inherit="no",name="emphasizedSkin",type="Class",states="up, over, down, disabled, selectedUp, selectedOver, selectedDown, selectedDisabled")]
   [Style(inherit="no",name="disabledSkin",type="Class")]
   [Style(inherit="no",name="downSkin",type="Class")]
   [Style(inherit="no",name="overSkin",type="Class")]
   [Style(inherit="no",name="upSkin",type="Class")]
   [Style(inherit="no",name="skin",type="Class",states="up, over, down, disabled, selectedUp, selectedOver, selectedDown, selectedDisabled")]
   [Style(inherit="no",name="verticalGap",format="Length",type="Number")]
   [Style(inherit="yes",name="textSelectedColor",format="Color",type="uint")]
   [Style(inherit="yes",name="textRollOverColor",format="Color",type="uint")]
   [Style(inherit="no",name="repeatInterval",format="Time",type="Number")]
   [Style(inherit="no",name="repeatDelay",format="Time",type="Number")]
   [Style(inherit="no",name="paddingTop",format="Length",type="Number")]
   [Style(inherit="no",name="paddingBottom",format="Length",type="Number")]
   [Style(inherit="no",name="labelVerticalOffset",format="Length",type="Number")]
   [Style(inherit="no",name="horizontalGap",format="Length",type="Number")]
   [Style(inherit="yes",name="focusColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="accentColor",format="Color",theme="spark",type="uint")]
   [Style(inherit="yes",name="textIndent",format="Length",type="Number")]
   [Style(inherit="no",name="textFieldClass",type="Class")]
   [Style(inherit="yes",name="textDecoration",type="String",enumeration="none,underline")]
   [Style(inherit="yes",name="textAlign",type="String",enumeration="left,center,right")]
   [Style(inherit="yes",name="locale",type="String")]
   [Style(inherit="yes",name="letterSpacing",type="Number")]
   [Style(inherit="yes",name="kerning",type="Boolean")]
   [Style(inherit="yes",name="fontWeight",type="String",enumeration="normal,bold")]
   [Style(inherit="yes",name="fontThickness",type="Number")]
   [Style(inherit="yes",name="fontStyle",type="String",enumeration="normal,italic")]
   [Style(inherit="yes",name="fontSize",format="Length",type="Number")]
   [Style(inherit="yes",name="fontSharpness",type="Number")]
   [Style(inherit="yes",name="fontGridFitType",type="String",enumeration="none,pixel,subpixel")]
   [Style(inherit="yes",name="fontFamily",type="String")]
   [Style(inherit="yes",name="fontAntiAliasType",type="String",enumeration="normal,advanced")]
   [Style(inherit="yes",name="disabledColor",format="Color",type="uint")]
   [Style(inherit="yes",name="direction",type="String",enumeration="ltr,rtl,inherit")]
   [Style(inherit="yes",name="color",format="Color",type="uint")]
   [Style(arrayType="Number",inherit="no",name="highlightAlphas",theme="halo",type="Array")]
   [Style(arrayType="uint",inherit="no",name="fillColors",format="Color",theme="halo",type="Array")]
   [Style(arrayType="Number",inherit="no",name="fillAlphas",theme="halo",type="Array")]
   [Style(inherit="no",name="cornerRadius",format="Length",theme="halo, spark",type="Number")]
   [Style(inherit="no",name="borderColor",format="Color",theme="halo",type="uint")]
   [Style(inherit="no",name="paddingRight",format="Length",type="Number")]
   [Style(inherit="no",name="paddingLeft",format="Length",type="Number")]
   [Style(inherit="yes",name="leading",format="Length",type="Number")]
   [Style(inherit="no",name="focusRoundedCorners",type="String")]
   [Style(inherit="no",name="focusAlpha",type="Number")]
   [Event(name="dataChange",type="mx.events.FlexEvent")]
   [Event(name="change",type="flash.events.Event")]
   [Event(name="buttonDown",type="mx.events.FlexEvent")]
   public class Button extends UIComponent implements IDataRenderer, IDropInListItemRenderer, IFocusManagerComponent, IListItemRenderer, IFontContextComponent, IButton
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
      
      mx_internal static var createAccessibilityImplementation:Function;
      
      mx_internal static var TEXT_WIDTH_PADDING:Number = UITextField.TEXT_WIDTH_PADDING + 1;
       
      private var skins:Array;
      
      mx_internal var currentSkin:IFlexDisplayObject;
      
      protected var icons:Array;
      
      mx_internal var currentIcon:IFlexDisplayObject;
      
      private var autoRepeatTimer:Timer;
      
      mx_internal var buttonOffset:Number = 0;
      
      mx_internal var centerContent:Boolean = true;
      
      mx_internal var extraSpacing:Number = 20.0;
      
      private var styleChangedFlag:Boolean = true;
      
      private var skinMeasuredWidth:Number;
      
      private var skinMeasuredHeight:Number;
      
      private var oldUnscaledWidth:Number;
      
      private var selectedSet:Boolean;
      
      private var labelSet:Boolean;
      
      mx_internal var checkedDefaultSkin:Boolean = false;
      
      mx_internal var defaultSkinUsesStates:Boolean = false;
      
      mx_internal var checkedDefaultIcon:Boolean = false;
      
      mx_internal var defaultIconUsesStates:Boolean = false;
      
      mx_internal var skinName:String = "skin";
      
      mx_internal var emphasizedSkinName:String = "emphasizedSkin";
      
      mx_internal var upSkinName:String = "upSkin";
      
      mx_internal var overSkinName:String = "overSkin";
      
      mx_internal var downSkinName:String = "downSkin";
      
      mx_internal var disabledSkinName:String = "disabledSkin";
      
      mx_internal var selectedUpSkinName:String = "selectedUpSkin";
      
      mx_internal var selectedOverSkinName:String = "selectedOverSkin";
      
      mx_internal var selectedDownSkinName:String = "selectedDownSkin";
      
      mx_internal var selectedDisabledSkinName:String = "selectedDisabledSkin";
      
      mx_internal var iconName:String = "icon";
      
      mx_internal var upIconName:String = "upIcon";
      
      mx_internal var overIconName:String = "overIcon";
      
      mx_internal var downIconName:String = "downIcon";
      
      mx_internal var disabledIconName:String = "disabledIcon";
      
      mx_internal var selectedUpIconName:String = "selectedUpIcon";
      
      mx_internal var selectedOverIconName:String = "selectedOverIcon";
      
      mx_internal var selectedDownIconName:String = "selectedDownIcon";
      
      mx_internal var selectedDisabledIconName:String = "selectedDisabledIcon";
      
      private var enabledChanged:Boolean = false;
      
      protected var textField:IUITextField;
      
      private var toolTipSet:Boolean = false;
      
      private var _autoRepeat:Boolean = false;
      
      private var _data:Object;
      
      mx_internal var _emphasized:Boolean = false;
      
      private var emphasizedChanged:Boolean = false;
      
      private var _label:String = "";
      
      private var labelChanged:Boolean = false;
      
      mx_internal var _labelPlacement:String = "right";
      
      private var _listData:BaseListData;
      
      private var _phase:String = "up";
      
      mx_internal var phaseChanged:Boolean = false;
      
      mx_internal var _selected:Boolean = false;
      
      public var selectedField:String = null;
      
      private var skinLayoutDirectionSet:Boolean = false;
      
      private var _skinLayoutDirection:String;
      
      public var stickyHighlighting:Boolean = false;
      
      mx_internal var _toggle:Boolean = false;
      
      mx_internal var toggleChanged:Boolean = false;
      
      protected var _currentButtonState:String;
      
      public function Button()
      {
         this.skins = [];
         this.icons = [];
         super();
         mouseChildren = false;
         addEventListener(MouseEvent.ROLL_OVER,this.rollOverHandler);
         addEventListener(MouseEvent.ROLL_OUT,this.rollOutHandler);
         addEventListener(MouseEvent.MOUSE_DOWN,this.mouseDownHandler);
         addEventListener(MouseEvent.MOUSE_UP,this.mouseUpHandler);
         addEventListener(MouseEvent.CLICK,this.clickHandler);
      }
      
      override public function get baselinePosition() : Number
      {
         if(!validateBaselinePosition())
         {
            return NaN;
         }
         return this.textField.y + this.textField.baselinePosition;
      }
      
      [Inspectable(defaultValue="true",category="General",enumeration="true,false")]
      override public function set enabled(value:Boolean) : void
      {
         if(super.enabled == value)
         {
            return;
         }
         super.enabled = value;
         this.enabledChanged = true;
         invalidateProperties();
         invalidateDisplayList();
      }
      
      [Inspectable(defaultValue="null",category="General")]
      override public function set toolTip(value:String) : void
      {
         super.toolTip = value;
         if(value)
         {
            this.toolTipSet = true;
         }
         else
         {
            this.toolTipSet = false;
            invalidateDisplayList();
         }
      }
      
      [Inspectable(defaultValue="false")]
      public function get autoRepeat() : Boolean
      {
         return this._autoRepeat;
      }
      
      public function set autoRepeat(value:Boolean) : void
      {
         this._autoRepeat = value;
         if(value)
         {
            this.autoRepeatTimer = new Timer(1);
         }
         else
         {
            this.autoRepeatTimer = null;
         }
      }
      
      [Inspectable(environment="none")]
      [Bindable("dataChange")]
      public function get data() : Object
      {
         return this._data;
      }
      
      public function set data(value:Object) : void
      {
         var newSelected:* = undefined;
         var newLabel:* = undefined;
         this._data = value;
         if(Boolean(this._listData) && Boolean(this._listData is DataGridListData) && Boolean(DataGridListData(this._listData).dataField != null))
         {
            newSelected = this._data[DataGridListData(this._listData).dataField];
            newLabel = "";
         }
         else if(this._listData)
         {
            if(this.selectedField)
            {
               newSelected = this._data[this.selectedField];
            }
            newLabel = this._listData.label;
         }
         else
         {
            newSelected = this._data;
         }
         if(Boolean(newSelected !== undefined) && Boolean(!this.selectedSet))
         {
            this.selected = newSelected as Boolean;
            this.selectedSet = false;
         }
         if(Boolean(newLabel !== undefined) && Boolean(!this.labelSet))
         {
            this.label = newLabel;
            this.labelSet = false;
         }
         dispatchEvent(new FlexEvent(FlexEvent.DATA_CHANGE));
      }
      
      [Inspectable(defaultValue="false",category="General")]
      public function get emphasized() : Boolean
      {
         return this._emphasized;
      }
      
      public function set emphasized(value:Boolean) : void
      {
         this._emphasized = value;
         this.emphasizedChanged = true;
         invalidateDisplayList();
      }
      
      public function get fontContext() : IFlexModuleFactory
      {
         return moduleFactory;
      }
      
      public function set fontContext(moduleFactory:IFlexModuleFactory) : void
      {
         this.moduleFactory = moduleFactory;
      }
      
      [Inspectable(defaultValue="",category="General")]
      [Bindable("labelChanged")]
      public function get label() : String
      {
         return this._label;
      }
      
      public function set label(value:String) : void
      {
         this.labelSet = true;
         if(this._label != value)
         {
            this._label = value;
            this.labelChanged = true;
            invalidateSize();
            invalidateDisplayList();
            dispatchEvent(new Event("labelChanged"));
         }
      }
      
      [Inspectable(defaultValue="right",category="General",enumeration="left,right,top,bottom")]
      [Bindable("labelPlacementChanged")]
      public function get labelPlacement() : String
      {
         return this._labelPlacement;
      }
      
      public function set labelPlacement(value:String) : void
      {
         this._labelPlacement = value;
         invalidateSize();
         invalidateDisplayList();
         dispatchEvent(new Event("labelPlacementChanged"));
      }
      
      [Inspectable(environment="none")]
      [Bindable("dataChange")]
      public function get listData() : BaseListData
      {
         return this._listData;
      }
      
      public function set listData(value:BaseListData) : void
      {
         this._listData = value;
      }
      
      mx_internal function get phase() : String
      {
         return this._phase;
      }
      
      mx_internal function set phase(value:String) : void
      {
         this._phase = value;
         this.phaseChanged = true;
         invalidateSize();
         invalidateProperties();
         invalidateDisplayList();
      }
      
      [Inspectable(defaultValue="false",category="General")]
      [Bindable("valueCommit")]
      [Bindable("click")]
      public function get selected() : Boolean
      {
         return this._selected;
      }
      
      public function set selected(value:Boolean) : void
      {
         this.selectedSet = true;
         this.setSelected(value,true);
      }
      
      mx_internal function setSelected(value:Boolean, isProgrammatic:Boolean = false) : void
      {
         if(this._selected != value)
         {
            this._selected = value;
            invalidateDisplayList();
            if(Boolean(this.toggle) && Boolean(!isProgrammatic))
            {
               dispatchEvent(new Event(Event.CHANGE));
            }
            dispatchEvent(new FlexEvent(FlexEvent.VALUE_COMMIT));
         }
      }
      
      mx_internal function set skinLayoutDirection(value:String) : void
      {
         this.skinLayoutDirectionSet = true;
         this._skinLayoutDirection = value;
      }
      
      [Inspectable(defaultValue="false",category="General")]
      [Bindable("toggleChanged")]
      public function get toggle() : Boolean
      {
         return this._toggle;
      }
      
      public function set toggle(value:Boolean) : void
      {
         this._toggle = value;
         this.toggleChanged = true;
         invalidateProperties();
         invalidateDisplayList();
         dispatchEvent(new Event("toggleChanged"));
      }
      
      override protected function initializeAccessibility() : void
      {
         if(Button.createAccessibilityImplementation != null)
         {
            Button.createAccessibilityImplementation(this);
         }
      }
      
      override protected function createChildren() : void
      {
         super.createChildren();
         if(!this.textField)
         {
            this.textField = IUITextField(createInFontContext(UITextField));
            this.textField.styleName = this;
            addChild(DisplayObject(this.textField));
         }
      }
      
      override protected function commitProperties() : void
      {
         var prevState:String = null;
         super.commitProperties();
         if(Boolean(hasFontContextChanged()) && Boolean(this.textField != null))
         {
            removeChild(DisplayObject(this.textField));
            this.textField = null;
         }
         if(!this.textField)
         {
            this.textField = IUITextField(createInFontContext(UITextField));
            this.textField.styleName = this;
            addChild(DisplayObject(this.textField));
            this.enabledChanged = true;
            this.toggleChanged = true;
         }
         if(!initialized)
         {
            this.viewSkin();
            this.viewIcon();
         }
         if(this.enabledChanged)
         {
            this.textField.enabled = enabled;
            if(Boolean(this.currentIcon) && Boolean(this.currentIcon is IUIComponent))
            {
               IUIComponent(this.currentIcon).enabled = enabled;
            }
            this.enabledChanged = false;
         }
         if(this.toggleChanged)
         {
            if(!this.toggle)
            {
               this.selected = false;
            }
            this.toggleChanged = false;
         }
         if(this.phaseChanged)
         {
            prevState = this._currentButtonState;
            if(prevState != this.getCurrentButtonState())
            {
               stateChanged(prevState,this._currentButtonState,false);
            }
            this.phaseChanged = false;
         }
      }
      
      override protected function measure() : void
      {
         var lineMetrics:TextLineMetrics = null;
         super.measure();
         var textWidth:Number = 0;
         var textHeight:Number = 0;
         if(this.label)
         {
            lineMetrics = measureText(this.label);
            textWidth = lineMetrics.width + TEXT_WIDTH_PADDING;
            textHeight = lineMetrics.height + UITextField.TEXT_HEIGHT_PADDING;
         }
         var tempCurrentIcon:IFlexDisplayObject = this.getCurrentIcon();
         var iconWidth:Number = Boolean(tempCurrentIcon)?Number(tempCurrentIcon.width):Number(0);
         var iconHeight:Number = Boolean(tempCurrentIcon)?Number(tempCurrentIcon.height):Number(0);
         var w:Number = 0;
         var h:Number = 0;
         if(Boolean(this.labelPlacement == ButtonLabelPlacement.LEFT) || Boolean(this.labelPlacement == ButtonLabelPlacement.RIGHT))
         {
            w = textWidth + iconWidth;
            if(Boolean(textWidth) && Boolean(iconWidth))
            {
               w = w + getStyle("horizontalGap");
            }
            h = Math.max(textHeight,iconHeight);
         }
         else
         {
            w = Math.max(textWidth,iconWidth);
            h = textHeight + iconHeight;
            if(Boolean(textHeight) && Boolean(iconHeight))
            {
               h = h + getStyle("verticalGap");
            }
         }
         if(Boolean(textWidth) || Boolean(iconWidth))
         {
            w = w + (getStyle("paddingLeft") + getStyle("paddingRight"));
            h = h + (getStyle("paddingTop") + getStyle("paddingBottom"));
         }
         var bm:EdgeMetrics = Boolean(this.currentSkin) && Boolean(this.currentSkin is IBorder) && Boolean(!(this.currentSkin is IFlexAsset))?IBorder(this.currentSkin).borderMetrics:null;
         if(bm)
         {
            w = w + (bm.left + bm.right);
            h = h + (bm.top + bm.bottom);
         }
         if(Boolean(this.currentSkin) && (Boolean(isNaN(this.skinMeasuredWidth)) || Boolean(isNaN(this.skinMeasuredHeight))))
         {
            this.skinMeasuredWidth = this.currentSkin.measuredWidth;
            this.skinMeasuredHeight = this.currentSkin.measuredHeight;
         }
         if(!isNaN(this.skinMeasuredWidth))
         {
            w = Math.max(this.skinMeasuredWidth,w);
         }
         if(!isNaN(this.skinMeasuredHeight))
         {
            h = Math.max(this.skinMeasuredHeight,h);
         }
         measuredMinWidth = measuredWidth = w;
         measuredMinHeight = measuredHeight = h;
      }
      
      override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         var skin:IFlexDisplayObject = null;
         var truncated:Boolean = false;
         super.updateDisplayList(unscaledWidth,unscaledHeight);
         if(this.emphasizedChanged)
         {
            this.changeSkins();
            this.emphasizedChanged = false;
         }
         var n:int = this.skins.length;
         for(var i:int = 0; i < n; i++)
         {
            skin = IFlexDisplayObject(this.skins[i]);
            skin.setActualSize(unscaledWidth,unscaledHeight);
         }
         this.viewSkin();
         this.viewIcon();
         this.layoutContents(unscaledWidth,unscaledHeight,this.phase == ButtonPhase.DOWN);
         if(Boolean(this.oldUnscaledWidth > unscaledWidth) || Boolean(this.textField.text != this.label) || Boolean(this.labelChanged) || Boolean(this.styleChangedFlag))
         {
            this.textField.text = this.label;
            truncated = this.textField.truncateToFit();
            if(!this.toolTipSet)
            {
               if(truncated)
               {
                  super.toolTip = this.label;
               }
               else
               {
                  super.toolTip = null;
               }
            }
            this.styleChangedFlag = false;
            this.labelChanged = false;
         }
         this.oldUnscaledWidth = unscaledWidth;
      }
      
      override public function styleChanged(styleProp:String) : void
      {
         this.styleChangedFlag = true;
         super.styleChanged(styleProp);
         if(Boolean(!styleProp) || Boolean(styleProp == "styleName"))
         {
            this.changeSkins();
            this.changeIcons();
            if(initialized)
            {
               this.viewSkin();
               this.viewIcon();
            }
         }
         else if(styleProp.toLowerCase().indexOf("skin") != -1)
         {
            this.changeSkins();
         }
         else if(styleProp.toLowerCase().indexOf("icon") != -1)
         {
            this.changeIcons();
            invalidateSize();
         }
      }
      
      override protected function adjustFocusRect(object:DisplayObject = null) : void
      {
         super.adjustFocusRect(!this.currentSkin?DisplayObject(this.currentIcon):this);
      }
      
      override protected function get currentCSSState() : String
      {
         return this.getCurrentButtonState();
      }
      
      mx_internal function viewSkin() : void
      {
         var tempSkinName:String = null;
         if(!enabled)
         {
            tempSkinName = !!this.selected?this.selectedDisabledSkinName:this.disabledSkinName;
         }
         else if(this.phase == ButtonPhase.UP)
         {
            tempSkinName = !!this.selected?this.selectedUpSkinName:this.upSkinName;
         }
         else if(this.phase == ButtonPhase.OVER)
         {
            tempSkinName = !!this.selected?this.selectedOverSkinName:this.overSkinName;
         }
         else if(this.phase == ButtonPhase.DOWN)
         {
            tempSkinName = !!this.selected?this.selectedDownSkinName:this.downSkinName;
         }
         this.viewSkinForPhase(tempSkinName,this.getCurrentButtonState());
      }
      
      mx_internal function viewSkinForPhase(tempSkinName:String, stateName:String) : void
      {
         var newSkin:IFlexDisplayObject = null;
         var labelColor:Number = NaN;
         var styleableSkin:ISimpleStyleClient = null;
         var newSkinClass:Class = Class(getStyle(tempSkinName));
         if(!newSkinClass)
         {
            newSkinClass = !!this._emphasized?Class(getStyle(this.emphasizedSkinName)):Class(getStyle(this.skinName));
            newSkinClass = Boolean(!newSkinClass) && Boolean(this._emphasized)?Class(getStyle(this.skinName)):newSkinClass;
            if(this.defaultSkinUsesStates)
            {
               tempSkinName = this.skinName;
            }
            if(Boolean(!this.checkedDefaultSkin) && Boolean(newSkinClass))
            {
               newSkin = IFlexDisplayObject(new newSkinClass());
               if(Boolean(!(newSkin is IProgrammaticSkin)) && Boolean(newSkin is IStateClient))
               {
                  this.defaultSkinUsesStates = true;
                  tempSkinName = this.skinName;
               }
               if(newSkin)
               {
                  this.checkedDefaultSkin = true;
                  if(Boolean(newSkin is ILayoutDirectionElement) && Boolean(this.skinLayoutDirectionSet))
                  {
                     ILayoutDirectionElement(newSkin).layoutDirection = this._skinLayoutDirection;
                  }
               }
            }
         }
         newSkin = IFlexDisplayObject(getChildByName(tempSkinName));
         if(!newSkin)
         {
            if(newSkinClass)
            {
               newSkin = IFlexDisplayObject(new newSkinClass());
               newSkin.name = tempSkinName;
               styleableSkin = newSkin as ISimpleStyleClient;
               if(styleableSkin)
               {
                  styleableSkin.styleName = this;
               }
               if(Boolean(newSkin is ILayoutDirectionElement) && Boolean(this.skinLayoutDirectionSet))
               {
                  ILayoutDirectionElement(newSkin).layoutDirection = this._skinLayoutDirection;
               }
               addChild(DisplayObject(newSkin));
               newSkin.setActualSize(unscaledWidth,unscaledHeight);
               if(Boolean(newSkin is IInvalidating) && Boolean(initialized))
               {
                  IInvalidating(newSkin).validateNow();
               }
               else if(Boolean(newSkin is IProgrammaticSkin) && Boolean(initialized))
               {
                  IProgrammaticSkin(newSkin).validateDisplayList();
               }
               this.skins.push(newSkin);
            }
         }
         if(this.currentSkin)
         {
            this.currentSkin.visible = false;
         }
         this.currentSkin = newSkin;
         if(Boolean(this.defaultSkinUsesStates) && Boolean(this.currentSkin is IStateClient))
         {
            IStateClient(this.currentSkin).currentState = stateName;
            if(this.currentSkin is IInvalidating)
            {
               IInvalidating(this.currentSkin).validateNow();
            }
         }
         if(this.currentSkin)
         {
            this.currentSkin.visible = true;
         }
         if(enabled)
         {
            if(this.phase == ButtonPhase.OVER)
            {
               labelColor = this.textField.getStyle("textRollOverColor");
            }
            else if(this.phase == ButtonPhase.DOWN)
            {
               labelColor = this.textField.getStyle("textSelectedColor");
            }
            else
            {
               labelColor = this.textField.getStyle("color");
            }
            this.textField.setColor(labelColor);
         }
      }
      
      mx_internal function getCurrentIconName() : String
      {
         var tempIconName:String = null;
         if(!enabled)
         {
            tempIconName = !!this.selected?this.selectedDisabledIconName:this.disabledIconName;
         }
         else if(this.phase == ButtonPhase.UP)
         {
            tempIconName = !!this.selected?this.selectedUpIconName:this.upIconName;
         }
         else if(this.phase == ButtonPhase.OVER)
         {
            tempIconName = !!this.selected?this.selectedOverIconName:this.overIconName;
         }
         else if(this.phase == ButtonPhase.DOWN)
         {
            tempIconName = !!this.selected?this.selectedDownIconName:this.downIconName;
         }
         return tempIconName;
      }
      
      mx_internal function getCurrentIcon() : IFlexDisplayObject
      {
         var tempIconName:String = this.getCurrentIconName();
         if(!tempIconName)
         {
            return null;
         }
         return this.viewIconForPhase(tempIconName);
      }
      
      mx_internal function viewIcon() : void
      {
         var tempIconName:String = this.getCurrentIconName();
         this.viewIconForPhase(tempIconName);
      }
      
      mx_internal function viewIconForPhase(tempIconName:String) : IFlexDisplayObject
      {
         var newIcon:IFlexDisplayObject = null;
         var sizeIcon:Boolean = false;
         var newIconClass:Class = Class(getStyle(tempIconName));
         if(!newIconClass)
         {
            newIconClass = Class(getStyle(this.iconName));
            if(this.defaultIconUsesStates)
            {
               tempIconName = this.iconName;
            }
            if(Boolean(!this.checkedDefaultIcon) && Boolean(newIconClass))
            {
               newIcon = IFlexDisplayObject(new newIconClass());
               if(Boolean(!(newIcon is IProgrammaticSkin)) && Boolean(newIcon is IStateClient))
               {
                  this.defaultIconUsesStates = true;
                  tempIconName = this.iconName;
               }
               if(newIcon)
               {
                  this.checkedDefaultIcon = true;
               }
            }
         }
         newIcon = IFlexDisplayObject(getChildByName(tempIconName));
         if(newIcon == null)
         {
            if(newIconClass != null)
            {
               newIcon = IFlexDisplayObject(new newIconClass());
               newIcon.name = tempIconName;
               if(newIcon is ISimpleStyleClient)
               {
                  ISimpleStyleClient(newIcon).styleName = this;
               }
               addChild(DisplayObject(newIcon));
               sizeIcon = false;
               if(newIcon is IInvalidating)
               {
                  IInvalidating(newIcon).validateNow();
                  sizeIcon = true;
               }
               else if(newIcon is IProgrammaticSkin)
               {
                  IProgrammaticSkin(newIcon).validateDisplayList();
                  sizeIcon = true;
               }
               if(Boolean(newIcon) && Boolean(newIcon is IUIComponent))
               {
                  IUIComponent(newIcon).enabled = enabled;
               }
               if(sizeIcon)
               {
                  newIcon.setActualSize(newIcon.measuredWidth,newIcon.measuredHeight);
               }
               this.icons.push(newIcon);
            }
         }
         if(this.currentIcon != null)
         {
            this.currentIcon.visible = false;
         }
         this.currentIcon = newIcon;
         if(Boolean(this.defaultIconUsesStates) && Boolean(this.currentIcon is IStateClient))
         {
            IStateClient(this.currentIcon).currentState = this.getCurrentButtonState();
            if(this.currentIcon is IInvalidating)
            {
               IInvalidating(this.currentIcon).validateNow();
            }
         }
         if(this.currentIcon != null)
         {
            this.currentIcon.visible = true;
         }
         return newIcon;
      }
      
      mx_internal function getCurrentButtonState() : String
      {
         this._currentButtonState = "";
         if(!enabled)
         {
            this._currentButtonState = !!this.selected?"selectedDisabled":"disabled";
         }
         else if(this.phase == ButtonPhase.UP)
         {
            this._currentButtonState = !!this.selected?"selectedUp":"up";
         }
         else if(this.phase == ButtonPhase.OVER)
         {
            this._currentButtonState = !!this.selected?"selectedOver":"over";
         }
         else if(this.phase == ButtonPhase.DOWN)
         {
            this._currentButtonState = !!this.selected?"selectedDown":"down";
         }
         return this._currentButtonState;
      }
      
      mx_internal function layoutContents(unscaledWidth:Number, unscaledHeight:Number, offset:Boolean) : void
      {
         var lineMetrics:TextLineMetrics = null;
         var moveEvent:MoveEvent = null;
         var labelWidth:Number = 0;
         var labelHeight:Number = 0;
         var labelX:Number = 0;
         var labelY:Number = 0;
         var iconWidth:Number = 0;
         var iconHeight:Number = 0;
         var iconX:Number = 0;
         var iconY:Number = 0;
         var horizontalGap:Number = 0;
         var verticalGap:Number = 0;
         var paddingLeft:Number = getStyle("paddingLeft");
         var paddingRight:Number = getStyle("paddingRight");
         var paddingTop:Number = getStyle("paddingTop");
         var paddingBottom:Number = getStyle("paddingBottom");
         var textWidth:Number = 0;
         var textHeight:Number = 0;
         if(this.label)
         {
            lineMetrics = measureText(this.label);
            textWidth = lineMetrics.width + TEXT_WIDTH_PADDING;
            textHeight = lineMetrics.height + UITextField.TEXT_HEIGHT_PADDING;
         }
         else
         {
            lineMetrics = measureText("Wj");
            textHeight = lineMetrics.height + UITextField.TEXT_HEIGHT_PADDING;
         }
         var n:Number = !!offset?Number(this.buttonOffset):Number(0);
         var textAlign:String = getStyle("textAlign");
         if(textAlign == "start")
         {
            textAlign = TextFormatAlign.LEFT;
         }
         else if(textAlign == "end")
         {
            textAlign = TextFormatAlign.RIGHT;
         }
         var viewWidth:Number = unscaledWidth;
         var viewHeight:Number = unscaledHeight;
         var bm:EdgeMetrics = Boolean(this.currentSkin) && Boolean(this.currentSkin is IBorder) && Boolean(!(this.currentSkin is IFlexAsset))?IBorder(this.currentSkin).borderMetrics:null;
         if(bm)
         {
            viewWidth = viewWidth - (bm.left + bm.right);
            viewHeight = viewHeight - (bm.top + bm.bottom);
         }
         if(this.currentIcon)
         {
            iconWidth = this.currentIcon.width;
            iconHeight = this.currentIcon.height;
         }
         if(Boolean(this.labelPlacement == ButtonLabelPlacement.LEFT) || Boolean(this.labelPlacement == ButtonLabelPlacement.RIGHT))
         {
            horizontalGap = getStyle("horizontalGap");
            if(Boolean(iconWidth == 0) || Boolean(textWidth == 0))
            {
               horizontalGap = 0;
            }
            if(textWidth > 0)
            {
               this.textField.width = labelWidth = Math.max(Math.min(viewWidth - iconWidth - horizontalGap - paddingLeft - paddingRight,textWidth),0);
            }
            else
            {
               this.textField.width = labelWidth = 0;
            }
            this.textField.height = labelHeight = Math.min(viewHeight,textHeight);
            if(textAlign == "left")
            {
               labelX = labelX + paddingLeft;
            }
            else if(textAlign == "right")
            {
               labelX = labelX + (viewWidth - labelWidth - iconWidth - horizontalGap - paddingRight);
            }
            else
            {
               labelX = labelX + ((viewWidth - labelWidth - iconWidth - horizontalGap - paddingLeft - paddingRight) / 2 + paddingLeft);
            }
            if(this.labelPlacement == ButtonLabelPlacement.RIGHT)
            {
               labelX = labelX + (iconWidth + horizontalGap);
               iconX = labelX - (iconWidth + horizontalGap);
            }
            else
            {
               iconX = labelX + labelWidth + horizontalGap;
            }
            iconY = (viewHeight - iconHeight - paddingTop - paddingBottom) / 2 + paddingTop;
            labelY = (viewHeight - labelHeight - paddingTop - paddingBottom) / 2 + paddingTop;
         }
         else
         {
            verticalGap = getStyle("verticalGap");
            if(Boolean(iconHeight == 0) || Boolean(this.label == ""))
            {
               verticalGap = 0;
            }
            if(textWidth > 0)
            {
               this.textField.width = labelWidth = Math.max(viewWidth - paddingLeft - paddingRight,0);
               this.textField.height = labelHeight = Math.min(viewHeight - iconHeight - paddingTop - paddingBottom - verticalGap,textHeight);
            }
            else
            {
               this.textField.width = labelWidth = 0;
               this.textField.height = labelHeight = 0;
            }
            labelX = paddingLeft;
            if(textAlign == "left")
            {
               iconX = iconX + paddingLeft;
            }
            else if(textAlign == "right")
            {
               iconX = iconX + Math.max(viewWidth - iconWidth - paddingRight,paddingLeft);
            }
            else
            {
               iconX = iconX + ((viewWidth - iconWidth - paddingLeft - paddingRight) / 2 + paddingLeft);
            }
            if(this.labelPlacement == ButtonLabelPlacement.TOP)
            {
               labelY = labelY + ((viewHeight - labelHeight - iconHeight - paddingTop - paddingBottom - verticalGap) / 2 + paddingTop);
               iconY = iconY + (labelY + labelHeight + verticalGap);
            }
            else
            {
               iconY = iconY + ((viewHeight - labelHeight - iconHeight - paddingTop - paddingBottom - verticalGap) / 2 + paddingTop);
               labelY = labelY + (iconY + iconHeight + verticalGap);
            }
         }
         var buffX:Number = n;
         var buffY:Number = n;
         if(bm)
         {
            buffX = buffX + bm.left;
            buffY = buffY + bm.top;
         }
         if(FlexVersion.compatibilityVersion >= FlexVersion.VERSION_4_0)
         {
            labelY = labelY + getStyle("labelVerticalOffset");
         }
         this.textField.x = Math.round(labelX + buffX);
         this.textField.y = Math.round(labelY + buffY);
         if(this.currentIcon)
         {
            iconX = iconX + buffX;
            iconY = iconY + buffY;
            moveEvent = new MoveEvent(MoveEvent.MOVE);
            moveEvent.oldX = this.currentIcon.x;
            moveEvent.oldY = this.currentIcon.y;
            this.currentIcon.x = Math.round(iconX);
            this.currentIcon.y = Math.round(iconY);
            this.currentIcon.dispatchEvent(moveEvent);
         }
         if(this.currentSkin)
         {
            setChildIndex(DisplayObject(this.currentSkin),numChildren - 1);
         }
         if(this.currentIcon)
         {
            setChildIndex(DisplayObject(this.currentIcon),numChildren - 1);
         }
         if(this.textField)
         {
            setChildIndex(DisplayObject(this.textField),numChildren - 1);
         }
      }
      
      mx_internal function changeSkins() : void
      {
         var n:int = this.skins.length;
         for(var i:int = 0; i < n; i++)
         {
            removeChild(this.skins[i]);
         }
         this.skins = [];
         this.skinMeasuredWidth = NaN;
         this.skinMeasuredHeight = NaN;
         this.checkedDefaultSkin = false;
         this.defaultSkinUsesStates = false;
         if(initialized)
         {
            this.viewSkin();
            invalidateSize();
         }
      }
      
      mx_internal function changeIcons() : void
      {
         var n:int = this.icons.length;
         for(var i:int = 0; i < n; i++)
         {
            removeChild(this.icons[i]);
         }
         this.icons = [];
         this.checkedDefaultIcon = false;
         this.defaultIconUsesStates = false;
      }
      
      mx_internal function buttonPressed() : void
      {
         this.phase = ButtonPhase.DOWN;
         dispatchEvent(new FlexEvent(FlexEvent.BUTTON_DOWN));
         if(this.autoRepeat)
         {
            this.autoRepeatTimer.delay = getStyle("repeatDelay");
            this.autoRepeatTimer.addEventListener(TimerEvent.TIMER,this.autoRepeatTimer_timerDelayHandler);
            this.autoRepeatTimer.start();
         }
      }
      
      mx_internal function buttonReleased() : void
      {
         systemManager.getSandboxRoot().removeEventListener(MouseEvent.MOUSE_UP,this.systemManager_mouseUpHandler,true);
         systemManager.getSandboxRoot().removeEventListener(SandboxMouseEvent.MOUSE_UP_SOMEWHERE,this.stage_mouseLeaveHandler);
         if(this.autoRepeatTimer)
         {
            this.autoRepeatTimer.removeEventListener(TimerEvent.TIMER,this.autoRepeatTimer_timerDelayHandler);
            this.autoRepeatTimer.removeEventListener(TimerEvent.TIMER,this.autoRepeatTimer_timerHandler);
            this.autoRepeatTimer.reset();
         }
      }
      
      mx_internal function getTextField() : IUITextField
      {
         return this.textField;
      }
      
      override protected function focusOutHandler(event:FocusEvent) : void
      {
         super.focusOutHandler(event);
         if(this.phase != ButtonPhase.UP)
         {
            this.phase = ButtonPhase.UP;
         }
      }
      
      override protected function keyDownHandler(event:KeyboardEvent) : void
      {
         if(!enabled)
         {
            return;
         }
         if(event.keyCode == Keyboard.SPACE)
         {
            this.buttonPressed();
         }
      }
      
      override protected function keyUpHandler(event:KeyboardEvent) : void
      {
         if(!enabled)
         {
            return;
         }
         if(event.keyCode == Keyboard.SPACE)
         {
            this.buttonReleased();
            if(this.phase == ButtonPhase.DOWN)
            {
               dispatchEvent(new MouseEvent(MouseEvent.CLICK));
            }
            this.phase = ButtonPhase.UP;
         }
      }
      
      protected function rollOverHandler(event:MouseEvent) : void
      {
         if(this.phase == ButtonPhase.UP)
         {
            if(event.buttonDown)
            {
               return;
            }
            this.phase = ButtonPhase.OVER;
            event.updateAfterEvent();
         }
         else if(this.phase == ButtonPhase.OVER)
         {
            this.phase = ButtonPhase.DOWN;
            event.updateAfterEvent();
            if(this.autoRepeatTimer)
            {
               this.autoRepeatTimer.start();
            }
         }
      }
      
      protected function rollOutHandler(event:MouseEvent) : void
      {
         if(this.phase == ButtonPhase.OVER)
         {
            this.phase = ButtonPhase.UP;
            event.updateAfterEvent();
         }
         else if(Boolean(this.phase == ButtonPhase.DOWN) && Boolean(!this.stickyHighlighting))
         {
            this.phase = ButtonPhase.OVER;
            event.updateAfterEvent();
            if(this.autoRepeatTimer)
            {
               this.autoRepeatTimer.stop();
            }
         }
      }
      
      protected function mouseDownHandler(event:MouseEvent) : void
      {
         if(!enabled)
         {
            return;
         }
         systemManager.getSandboxRoot().addEventListener(MouseEvent.MOUSE_UP,this.systemManager_mouseUpHandler,true);
         systemManager.getSandboxRoot().addEventListener(SandboxMouseEvent.MOUSE_UP_SOMEWHERE,this.stage_mouseLeaveHandler);
         this.buttonPressed();
         event.updateAfterEvent();
      }
      
      protected function mouseUpHandler(event:MouseEvent) : void
      {
         if(!enabled)
         {
            return;
         }
         this.phase = ButtonPhase.OVER;
         this.buttonReleased();
         if(!this.toggle)
         {
            event.updateAfterEvent();
         }
      }
      
      protected function clickHandler(event:MouseEvent) : void
      {
         if(!enabled)
         {
            event.stopImmediatePropagation();
            return;
         }
         if(this.toggle)
         {
            this.setSelected(!this.selected);
            event.updateAfterEvent();
         }
      }
      
      private function systemManager_mouseUpHandler(event:MouseEvent) : void
      {
         if(contains(DisplayObject(event.target)))
         {
            return;
         }
         this.phase = ButtonPhase.UP;
         this.buttonReleased();
         event.updateAfterEvent();
      }
      
      private function stage_mouseLeaveHandler(event:Event) : void
      {
         this.phase = ButtonPhase.UP;
         this.buttonReleased();
      }
      
      private function autoRepeatTimer_timerDelayHandler(event:Event) : void
      {
         if(!enabled)
         {
            return;
         }
         dispatchEvent(new FlexEvent(FlexEvent.BUTTON_DOWN));
         if(this.autoRepeat)
         {
            this.autoRepeatTimer.reset();
            this.autoRepeatTimer.removeEventListener(TimerEvent.TIMER,this.autoRepeatTimer_timerDelayHandler);
            this.autoRepeatTimer.delay = getStyle("repeatInterval");
            this.autoRepeatTimer.addEventListener(TimerEvent.TIMER,this.autoRepeatTimer_timerHandler);
            this.autoRepeatTimer.start();
         }
      }
      
      private function autoRepeatTimer_timerHandler(event:Event) : void
      {
         if(!enabled)
         {
            return;
         }
         dispatchEvent(new FlexEvent(FlexEvent.BUTTON_DOWN));
      }
   }
}
