package mx.containers
{
   import mx.core.mx_internal;
   import mx.core.ScrollPolicy;
   import mx.core.Container;
   
   use namespace mx_internal;
   
   [Alternative(replacement="none",since="4.0")]
   [IconFile("ControlBar.png")]
   [Exclude(kind="effect",name="focusOutEffect")]
   [Exclude(kind="effect",name="focusInEffect")]
   [Exclude(kind="style",name="shadowDistance")]
   [Exclude(kind="style",name="shadowDirection")]
   [Exclude(kind="style",name="focusThickness")]
   [Exclude(kind="style",name="focusSkin")]
   [Exclude(kind="style",name="focusBlendMode")]
   [Exclude(kind="style",name="dropShadowEnabled")]
   [Exclude(kind="style",name="dropShadowColor")]
   [Exclude(kind="style",name="borderThickness")]
   [Exclude(kind="style",name="borderSides")]
   [Exclude(kind="style",name="borderColor")]
   [Exclude(kind="style",name="backgroundColor")]
   [Exclude(kind="event",name="focusOut")]
   [Exclude(kind="event",name="focusIn")]
   [Exclude(kind="property",name="verticalScrollPolicy")]
   [Exclude(kind="property",name="horizontalScrollPolicy")]
   [Exclude(kind="property",name="direction")]
   public class ControlBar extends Box
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function ControlBar()
      {
         super();
         direction = BoxDirection.HORIZONTAL;
      }
      
      [Inspectable(defaultValue="true",category="General",enumeration="true,false")]
      override public function set enabled(value:Boolean) : void
      {
         if(value != super.enabled)
         {
            super.enabled = value;
            alpha = !!value?Number(1):Number(0.4);
         }
      }
      
      [Inspectable(environment="none")]
      override public function get horizontalScrollPolicy() : String
      {
         return ScrollPolicy.OFF;
      }
      
      override public function set horizontalScrollPolicy(value:String) : void
      {
      }
      
      [Inspectable(defaultValue="true",category="General")]
      override public function set includeInLayout(value:Boolean) : void
      {
         var p:Container = null;
         if(includeInLayout != value)
         {
            super.includeInLayout = value;
            p = parent as Container;
            if(p)
            {
               p.invalidateViewMetricsAndPadding();
            }
         }
      }
      
      [Inspectable(environment="none")]
      override public function get verticalScrollPolicy() : String
      {
         return ScrollPolicy.OFF;
      }
      
      override public function set verticalScrollPolicy(value:String) : void
      {
      }
      
      override public function invalidateSize() : void
      {
         super.invalidateSize();
         if(Boolean(parent) && Boolean(parent is Container))
         {
            Container(parent).invalidateViewMetricsAndPadding();
         }
      }
      
      override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         super.updateDisplayList(unscaledWidth,unscaledHeight);
         if(contentPane)
         {
            contentPane.opaqueBackground = null;
         }
      }
   }
}
