package mx.containers
{
   import mx.core.Container;
   import mx.core.mx_internal;
   import mx.containers.utilityClasses.BoxLayout;
   import flash.events.Event;
   import mx.core.IUIComponent;
   
   use namespace mx_internal;
   
   [Alternative(replacement="spark.components.BorderContainer",since="4.0")]
   [Alternative(replacement="spark.components.VGroup",since="4.0")]
   [Alternative(replacement="spark.components.HGroup",since="4.0")]
   [IconFile("Box.png")]
   [Exclude(kind="effect",name="focusOutEffect")]
   [Exclude(kind="effect",name="focusInEffect")]
   [Exclude(kind="style",name="focusThickness")]
   [Exclude(kind="style",name="focusSkin")]
   [Exclude(kind="style",name="focusBlendMode")]
   [Exclude(kind="event",name="focusOut")]
   [Exclude(kind="event",name="focusIn")]
   [Style(inherit="no",name="paddingTop",format="Length",type="Number")]
   [Style(inherit="no",name="paddingBottom",format="Length",type="Number")]
   [Style(inherit="no",name="verticalGap",format="Length",type="Number")]
   [Style(inherit="no",name="horizontalGap",format="Length",type="Number")]
   [Style(inherit="no",name="verticalAlign",type="String",enumeration="bottom,middle,top")]
   [Style(inherit="no",name="horizontalAlign",type="String",enumeration="left,center,right")]
   public class Box extends Container
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      mx_internal var layoutObject:BoxLayout;
      
      public function Box()
      {
         this.layoutObject = new BoxLayout();
         super();
         this.layoutObject.target = this;
      }
      
      [Inspectable(defaultValue="vertical",category="General",enumeration="vertical,horizontal")]
      [Bindable("directionChanged")]
      public function get direction() : String
      {
         return this.layoutObject.direction;
      }
      
      public function set direction(value:String) : void
      {
         this.layoutObject.direction = value;
         invalidateSize();
         invalidateDisplayList();
         dispatchEvent(new Event("directionChanged"));
      }
      
      override protected function measure() : void
      {
         super.measure();
         this.layoutObject.measure();
      }
      
      override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number) : void
      {
         super.updateDisplayList(unscaledWidth,unscaledHeight);
         this.layoutObject.updateDisplayList(unscaledWidth,unscaledHeight);
      }
      
      public function pixelsToPercent(pxl:Number) : Number
      {
         var child:IUIComponent = null;
         var size:Number = NaN;
         var perc:Number = NaN;
         var vertical:Boolean = this.isVertical();
         var totalPerc:Number = 0;
         var totalSize:Number = 0;
         var n:int = numChildren;
         for(var i:int = 0; i < n; i++)
         {
            child = getLayoutChildAt(i);
            size = !!vertical?Number(child.height):Number(child.width);
            perc = !!vertical?Number(child.percentHeight):Number(child.percentWidth);
            if(!isNaN(perc))
            {
               totalPerc = totalPerc + perc;
               totalSize = totalSize + size;
            }
         }
         var p:Number = 100;
         if(totalSize != pxl)
         {
            p = totalSize * totalPerc / (totalSize - pxl) - totalPerc;
         }
         return p;
      }
      
      mx_internal function isVertical() : Boolean
      {
         return this.direction != BoxDirection.HORIZONTAL;
      }
   }
}
