package mx.accessibility
{
   import mx.core.mx_internal;
   import mx.containers.Panel;
   import mx.core.UIComponent;
   
   use namespace mx_internal;
   
   public class PanelAccImpl extends AccImpl
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      public function PanelAccImpl(master:UIComponent)
      {
         super(master);
         role = AccConst.ROLE_SYSTEM_GROUPING;
      }
      
      public static function enableAccessibility() : void
      {
         Panel.createAccessibilityImplementation = createAccessibilityImplementation;
      }
      
      mx_internal static function createAccessibilityImplementation(component:UIComponent) : void
      {
         var titleBar:UIComponent = Panel(component).getTitleBar();
         titleBar.accessibilityImplementation = new PanelAccImpl(component);
      }
      
      override public function get_accState(childID:uint) : uint
      {
         var accState:uint = getState(childID);
         return accState;
      }
      
      override protected function getName(childID:uint) : String
      {
         return Panel(master).title;
      }
   }
}
