package flashx.textLayout.property
{
   import flashx.textLayout.formats.FormatValue;
   import flashx.textLayout.tlf_internal;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class NumberOrPercentProperty extends Property
   {
       
      private var _minNumberValue:Number;
      
      private var _maxNumberValue:Number;
      
      private var _minPercentValue:Number;
      
      private var _maxPercentValue:Number;
      
      public function NumberOrPercentProperty(nameValue:String, defaultValue:Object, inherited:Boolean, category:String, minValue:Number, maxValue:Number, minPercentValue:String, maxPercentValue:String)
      {
         super(nameValue,defaultValue,inherited,category);
         this._minNumberValue = minValue;
         this._maxNumberValue = maxValue;
         this._minPercentValue = toNumberIfPercent(minPercentValue);
         this._maxPercentValue = toNumberIfPercent(maxPercentValue);
      }
      
      private static function toNumberIfPercent(o:Object) : Number
      {
         if(!(o is String))
         {
            return NaN;
         }
         var s:String = String(o);
         var len:int = s.length;
         return Boolean(len != 0) && Boolean(s.charAt(len - 1) == "%")?Number(parseFloat(s)):Number(NaN);
      }
      
      public function get minNumberValue() : Number
      {
         return this._minNumberValue;
      }
      
      public function get maxNumberValue() : Number
      {
         return this._maxNumberValue;
      }
      
      public function get minPercentValue() : Number
      {
         return this._minPercentValue;
      }
      
      public function get maxPercentValue() : Number
      {
         return this._maxPercentValue;
      }
      
      override public function setHelper(currVal:*, newObject:*) : *
      {
         if(newObject === null)
         {
            newObject = undefined;
         }
         if(Boolean(newObject === undefined) || Boolean(newObject == FormatValue.INHERIT))
         {
            return newObject;
         }
         var newVal:Number = toNumberIfPercent(newObject);
         if(!isNaN(newVal))
         {
            if(Boolean(checkLowerLimit()) && Boolean(newVal < this._minPercentValue))
            {
               Property.errorHandler(this,newObject);
               return currVal;
            }
            if(Boolean(checkUpperLimit()) && Boolean(newVal > this._maxPercentValue))
            {
               Property.errorHandler(this,newObject);
               return currVal;
            }
            return newVal.toString() + "%";
         }
         newVal = parseFloat(newObject);
         if(isNaN(newVal))
         {
            Property.errorHandler(this,newObject);
            return currVal;
         }
         if(Boolean(checkLowerLimit()) && Boolean(newVal < this._minNumberValue))
         {
            Property.errorHandler(this,newObject);
            return currVal;
         }
         if(Boolean(checkUpperLimit()) && Boolean(newVal > this._maxNumberValue))
         {
            Property.errorHandler(this,newObject);
            return currVal;
         }
         return newVal;
      }
      
      override public function hash(val:Object, seed:uint) : uint
      {
         if(val == FormatValue.INHERIT)
         {
            return UintProperty.doHash(inheritHashValue,seed);
         }
         if(val is String)
         {
            return StringProperty.doHash(String(val),seed);
         }
         return NumberProperty.doHash(val as Number,seed);
      }
      
      public function computeActualPropertyValue(propertyValue:Object, percentInput:Number) : Number
      {
         var percent:Number = toNumberIfPercent(propertyValue);
         if(isNaN(percent))
         {
            return Number(propertyValue);
         }
         var rslt:Number = percentInput * (percent / 100);
         if(rslt < this._minNumberValue)
         {
            return this._minNumberValue;
         }
         if(rslt > this._maxNumberValue)
         {
            return this._maxNumberValue;
         }
         return rslt;
      }
   }
}
