package flashx.textLayout.property
{
   import flashx.textLayout.formats.FormatValue;
   import flashx.textLayout.tlf_internal;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class BooleanProperty extends Property
   {
       
      public function BooleanProperty(nameValue:String, defaultValue:Boolean, inherited:Boolean, category:String)
      {
         super(nameValue,defaultValue,inherited,category);
      }
      
      override public function setHelper(currVal:*, newObject:*) : *
      {
         if(newObject === null)
         {
            newObject = undefined;
         }
         if(Boolean(newObject === undefined) || Boolean(newObject is Boolean) || Boolean(newObject == FormatValue.INHERIT))
         {
            return newObject;
         }
         if(Boolean(newObject == "true") || Boolean(newObject == "false"))
         {
            return newObject == "true";
         }
         Property.errorHandler(this,newObject);
         return currVal;
      }
      
      override public function hash(val:Object, seed:uint) : uint
      {
         if(val == FormatValue.INHERIT)
         {
            return UintProperty.doHash(inheritHashValue,seed);
         }
         return UintProperty.doHash(!!(val as Boolean)?uint(1):uint(0),seed);
      }
   }
}
