package flashx.textLayout.elements
{
   import flashx.textLayout.tlf_internal;
   import flash.text.engine.TextElement;
   import flashx.textLayout.utils.CharacterUtil;
   import flash.utils.getQualifiedClassName;
   import flashx.textLayout.formats.TextLayoutFormatValueHolder;
   import flashx.textLayout.formats.FormatValue;
   import flashx.textLayout.formats.WhiteSpaceCollapse;
   import flashx.textLayout.events.ModelChange;
   import flashx.textLayout.container.ContainerController;
   import flash.text.engine.GroupElement;
   import flashx.textLayout.property.Property;
   
   use namespace tlf_internal;
   
   [DefaultProperty("mxmlChildren")]
   public class SpanElement extends FlowLeafElement
   {
      
      tlf_internal static const kParagraphTerminator:String = " ";
      
      private static const _dblSpacePattern:RegExp = /[ ]{2,}/g;
      
      private static const _newLineTabPattern:RegExp = /[\t\n\r]/g;
      
      private static const _tabPlaceholderPattern:RegExp = //g;
      
      private static const anyPrintChar:RegExp = /[^\t\n\r ]/g;
       
      public function SpanElement()
      {
         super();
      }
      
      override tlf_internal function createContentElement() : void
      {
         if(_blockElement)
         {
            return;
         }
         computedFormat;
         _blockElement = new TextElement(null,null);
         TextElement(_blockElement).replaceText(0,0,_text);
         _text = null;
         super.createContentElement();
      }
      
      override tlf_internal function releaseContentElement() : void
      {
         if(Boolean(_blockElement == null) || Boolean(!canReleaseContentElement()))
         {
            return;
         }
         _text = _blockElement.rawText;
         super.releaseContentElement();
      }
      
      private function getTextElement() : TextElement
      {
         return TextElement(_blockElement);
      }
      
      override public function shallowCopy(startPos:int = 0, endPos:int = -1) : FlowElement
      {
         if(endPos == -1)
         {
            endPos = textLength;
         }
         var retFlow:SpanElement = super.shallowCopy(startPos,endPos) as SpanElement;
         var startSpan:int = 0;
         var endSpan:int = startSpan + textLength;
         var leafElStartPos:int = startSpan >= startPos?int(startSpan):int(startPos);
         var leafElEndPos:int = endSpan < endPos?int(endSpan):int(endPos);
         if(Boolean(leafElEndPos == textLength) && Boolean(this.hasParagraphTerminator))
         {
            leafElEndPos--;
         }
         if(leafElStartPos > leafElEndPos)
         {
            throw RangeError(GlobalSettings.resourceStringFunction("badShallowCopyRange"));
         }
         var spanText:String = Boolean(_blockElement)?_blockElement.rawText:_text;
         if(Boolean(leafElStartPos != endSpan) && Boolean(CharacterUtil.isLowSurrogate(spanText.charCodeAt(leafElStartPos))) || Boolean(leafElEndPos != 0) && Boolean(CharacterUtil.isHighSurrogate(spanText.charCodeAt(leafElEndPos - 1))))
         {
            throw RangeError(GlobalSettings.resourceStringFunction("badSurrogatePairCopy"));
         }
         retFlow.replaceText(0,retFlow.textLength,String(spanText).substring(leafElStartPos,leafElEndPos));
         return retFlow;
      }
      
      override protected function get abstract() : Boolean
      {
         return false;
      }
      
      override public function get text() : String
      {
         var textValue:String = Boolean(_blockElement)?_blockElement.rawText:_text;
         if(Boolean(textLength) && Boolean(this.hasParagraphTerminator))
         {
            return textValue.substr(0,textLength - 1);
         }
         return textValue != null?textValue:"";
      }
      
      public function set text(textValue:String) : void
      {
         this.replaceText(0,textLength,textValue);
      }
      
      override public function getText(relativeStart:int = 0, relativeEnd:int = -1, paragraphSeparator:String = "\n") : String
      {
         var textValue:String = Boolean(_blockElement)?_blockElement.rawText:_text;
         if(Boolean(textLength) && Boolean(relativeEnd == textLength) && Boolean(this.hasParagraphTerminator))
         {
            relativeEnd--;
         }
         return Boolean(textValue)?textValue.substring(relativeStart,relativeEnd):"";
      }
      
      [RichTextContent]
      public function get mxmlChildren() : Array
      {
         return [this.text];
      }
      
      public function set mxmlChildren(array:Array) : void
      {
         var elem:Object = null;
         var str:String = new String();
         for each(elem in array)
         {
            if(elem is String)
            {
               str = str + (elem as String);
            }
            else if(elem is Number)
            {
               str = str + elem.toString();
            }
            else if(elem is BreakElement)
            {
               str = str + String.fromCharCode(8232);
            }
            else if(elem is TabElement)
            {
               str = str + String.fromCharCode(57344);
            }
            else if(elem != null)
            {
               throw new TypeError(GlobalSettings.resourceStringFunction("badMXMLChildrenArgument",[getQualifiedClassName(elem)]));
            }
         }
         this.replaceText(0,textLength,str);
      }
      
      tlf_internal function get hasParagraphTerminator() : Boolean
      {
         var p:ParagraphElement = getParagraph();
         return Boolean(p) && Boolean(p.getLastLeaf() == this);
      }
      
      override tlf_internal function applyWhiteSpaceCollapse(collapse:String) : void
      {
         var ffc:TextLayoutFormatValueHolder = this.formatForCascade;
         var wsc:* = Boolean(ffc)?ffc.whiteSpaceCollapse:undefined;
         if(Boolean(wsc !== undefined) && Boolean(wsc != FormatValue.INHERIT))
         {
            collapse = wsc;
         }
         var tempTxt:String = this.text;
         if(Boolean(!collapse) || Boolean(collapse == WhiteSpaceCollapse.COLLAPSE))
         {
            if(Boolean(impliedElement) && Boolean(parent != null))
            {
               if(tempTxt.search(anyPrintChar) == -1)
               {
                  parent.removeChild(this);
                  return;
               }
            }
            tempTxt = tempTxt.replace(_newLineTabPattern," ");
            tempTxt = tempTxt.replace(_dblSpacePattern," ");
         }
         this.replaceText(0,textLength,tempTxt.replace(_tabPlaceholderPattern,"\t"));
         super.applyWhiteSpaceCollapse(collapse);
      }
      
      public function replaceText(relativeStartPosition:int, relativeEndPosition:int, textValue:String) : void
      {
         if(Boolean(relativeStartPosition < 0) || Boolean(relativeEndPosition > textLength) || Boolean(relativeEndPosition < relativeStartPosition))
         {
            throw RangeError(GlobalSettings.resourceStringFunction("invalidReplaceTextPositions"));
         }
         var spanText:String = Boolean(_blockElement)?_blockElement.rawText:_text;
         if(Boolean(relativeStartPosition != 0) && Boolean(relativeStartPosition != textLength) && Boolean(CharacterUtil.isLowSurrogate(spanText.charCodeAt(relativeStartPosition))) || Boolean(relativeEndPosition != 0) && Boolean(relativeEndPosition != textLength) && Boolean(CharacterUtil.isHighSurrogate(spanText.charCodeAt(relativeEndPosition - 1))))
         {
            throw RangeError(GlobalSettings.resourceStringFunction("invalidSurrogatePairSplit"));
         }
         if(this.hasParagraphTerminator)
         {
            if(relativeStartPosition == textLength)
            {
               relativeStartPosition--;
            }
            if(relativeEndPosition == textLength)
            {
               relativeEndPosition--;
            }
         }
         if(relativeEndPosition != relativeStartPosition)
         {
            modelChanged(ModelChange.TEXT_DELETED,relativeStartPosition,relativeEndPosition - relativeStartPosition);
         }
         this.replaceTextInternal(relativeStartPosition,relativeEndPosition,textValue);
         if(Boolean(textValue) && Boolean(textValue.length))
         {
            modelChanged(ModelChange.TEXT_INSERTED,relativeStartPosition,textValue.length);
         }
      }
      
      private function replaceTextInternal(startPos:int, endPos:int, textValue:String) : void
      {
         var enclosingContainer:ContainerController = null;
         var textValueLength:int = textValue == null?int(0):int(textValue.length);
         var deleteTotal:int = endPos - startPos;
         var deltaChars:int = textValueLength - deleteTotal;
         if(_blockElement)
         {
            TextElement(_blockElement).replaceText(startPos,endPos,textValue);
         }
         else if(_text)
         {
            if(textValue)
            {
               _text = _text.slice(0,startPos) + textValue + _text.slice(endPos,_text.length);
            }
            else
            {
               _text = _text.slice(0,startPos) + _text.slice(endPos,_text.length);
            }
         }
         else
         {
            _text = textValue;
         }
         if(deltaChars != 0)
         {
            updateLengths(getAbsoluteStart() + startPos,deltaChars,true);
            deleteContainerText(endPos,deleteTotal);
            if(textValueLength != 0)
            {
               enclosingContainer = getEnclosingController(startPos);
               if(enclosingContainer)
               {
                  ContainerController(enclosingContainer).setTextLength(enclosingContainer.textLength + textValueLength);
               }
            }
         }
      }
      
      override tlf_internal function addParaTerminator() : void
      {
         this.replaceTextInternal(textLength,textLength,SpanElement.kParagraphTerminator);
         modelChanged(ModelChange.TEXT_INSERTED,textLength - 1,1);
      }
      
      override tlf_internal function removeParaTerminator() : void
      {
         this.replaceTextInternal(textLength - 1,textLength,"");
         modelChanged(ModelChange.TEXT_DELETED,textLength > 0?int(textLength - 1):int(0),1);
      }
      
      override public function splitAtPosition(relativePosition:int) : FlowElement
      {
         var newBlockElement:TextElement = null;
         var newSpanLength:int = 0;
         var group:GroupElement = null;
         var elementIndex:int = 0;
         if(Boolean(relativePosition < 0) || Boolean(relativePosition > textLength))
         {
            throw RangeError(GlobalSettings.resourceStringFunction("invalidSplitAtPosition"));
         }
         if(Boolean(relativePosition < textLength) && Boolean(CharacterUtil.isLowSurrogate(String(this.text).charCodeAt(relativePosition))))
         {
            throw RangeError(GlobalSettings.resourceStringFunction("invalidSurrogatePairSplit"));
         }
         var newSpan:SpanElement = new SpanElement();
         newSpan.id = this.id;
         newSpan.styleName = this.styleName;
         if(parent)
         {
            newSpanLength = textLength - relativePosition;
            if(_blockElement)
            {
               group = parent.createContentAsGroup();
               elementIndex = group.getElementIndex(_blockElement);
               group.splitTextElement(elementIndex,relativePosition);
               _blockElement = group.getElementAt(elementIndex);
               newBlockElement = group.getElementAt(elementIndex + 1) as TextElement;
            }
            else if(relativePosition < textLength)
            {
               newSpan.text = _text.substr(relativePosition);
               _text = _text.substring(0,relativePosition);
            }
            modelChanged(ModelChange.TEXT_DELETED,relativePosition,newSpanLength);
            newSpan.quickInitializeForSplit(this,newSpanLength,newBlockElement);
            setTextLength(relativePosition);
            parent.addChildAfterInternal(this,newSpan);
            newSpan.modelChanged(ModelChange.ELEMENT_ADDED,0,newSpan.textLength);
         }
         else
         {
            newSpan.format = format;
            if(relativePosition < textLength)
            {
               newSpan.text = String(this.text).substr(relativePosition);
               this.replaceText(relativePosition,textLength,null);
            }
         }
         return newSpan;
      }
      
      override tlf_internal function normalizeRange(normalizeStart:uint, normalizeEnd:uint) : void
      {
         var p:ParagraphElement = null;
         var prevLeaf:FlowLeafElement = null;
         if(this.textLength == 1)
         {
            p = getParagraph();
            if(Boolean(p) && Boolean(p.getLastLeaf() == this))
            {
               prevLeaf = getPreviousLeaf(p);
               if(prevLeaf)
               {
                  this.format = prevLeaf.format;
                  this.userStyles = Boolean(prevLeaf.userStyles)?Property.shallowCopy(prevLeaf.userStyles):null;
               }
            }
         }
         super.normalizeRange(normalizeStart,normalizeEnd);
      }
      
      override tlf_internal function mergeToPreviousIfPossible() : Boolean
      {
         var myidx:int = 0;
         var sib:SpanElement = null;
         var siblingInsertPosition:int = 0;
         if(Boolean(parent) && Boolean(!bindableElement) && Boolean(canReleaseContentElement()))
         {
            myidx = parent.getChildIndex(this);
            if(myidx != 0)
            {
               sib = parent.getChildAt(myidx - 1) as SpanElement;
               if(Boolean(sib != null) && Boolean(sib.canReleaseContentElement()) && (Boolean(equalStylesForMerge(sib)) || Boolean(this.textLength == 1) && Boolean(this.hasParagraphTerminator)))
               {
                  siblingInsertPosition = sib.textLength;
                  sib.replaceText(siblingInsertPosition,siblingInsertPosition,this.text);
                  parent.replaceChildren(myidx,myidx + 1,null);
                  return true;
               }
            }
         }
         return false;
      }
   }
}
