package flashx.textLayout.elements
{
   import flash.events.IEventDispatcher;
   import flashx.textLayout.tlf_internal;
   import flash.events.MouseEvent;
   import flash.display.DisplayObject;
   import flash.text.engine.TextLine;
   import flash.text.engine.TextLineMirrorRegion;
   import flash.text.engine.TextLineValidity;
   import flash.text.engine.GroupElement;
   import flash.ui.Mouse;
   import flash.ui.MouseCursor;
   import flashx.textLayout.events.FlowElementMouseEvent;
   import flashx.textLayout.compose.IFlowComposer;
   import flash.events.EventDispatcher;
   import flash.events.Event;
   import flashx.textLayout.events.ModelChange;
   import flashx.textLayout.formats.TextLayoutFormatValueHolder;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.container.ContainerController;
   import flash.display.Sprite;
   import flashx.textLayout.formats.BlockProgression;
   import flashx.textLayout.edit.EditingMode;
   import flash.net.URLRequest;
   import flash.net.navigateToURL;
   
   use namespace tlf_internal;
   
   [Event(name="click",type="flashx.textLayout.events.FlowElementMouseEvent")]
   [Event(name="rollOut",type="flashx.textLayout.events.FlowElementMouseEvent")]
   [Event(name="rollOver",type="flashx.textLayout.events.FlowElementMouseEvent")]
   [Event(name="mouseMove",type="flashx.textLayout.events.FlowElementMouseEvent")]
   [Event(name="mouseUp",type="flashx.textLayout.events.FlowElementMouseEvent")]
   [Event(name="mouseDown",type="flashx.textLayout.events.FlowElementMouseEvent")]
   public final class LinkElement extends SubParagraphGroupElement implements IEventDispatcher
   {
      
      private static var _mouseInLinkElement:flashx.textLayout.elements.LinkElement;
      
      tlf_internal static const LINK_NORMAL_FORMAT_NAME:String = "linkNormalFormat";
      
      tlf_internal static const LINK_ACTIVE_FORMAT_NAME:String = "linkActiveFormat";
      
      tlf_internal static const LINK_HOVER_FORMAT_NAME:String = "linkHoverFormat";
       
      private var _uriString:String;
      
      private var _targetString:String;
      
      private var _linkState:String;
      
      private var _ignoreNextMouseOut:Boolean = false;
      
      private var _mouseInLink:Boolean = false;
      
      private var _isSelecting:Boolean = false;
      
      private var _keyEventsAdded:Boolean = false;
      
      private var eventDispatcher:EventDispatcher;
      
      private var _mouseDownInLink:Boolean = false;
      
      public function LinkElement()
      {
         super();
         this.eventDispatcher = new EventDispatcher();
         this._linkState = LinkState.LINK;
         this._mouseDownInLink = false;
         this._isSelecting = false;
      }
      
      private static function addLinkToMouseInArray(linkEl:flashx.textLayout.elements.LinkElement) : void
      {
         _mouseInLinkElement = linkEl;
         attachContainerEventHandlers(linkEl);
      }
      
      private static function removeLinkFromMouseInArray(linkEl:flashx.textLayout.elements.LinkElement) : void
      {
         _mouseInLinkElement = null;
         detachContainerEventHandlers(linkEl);
      }
      
      private static function stageMouseMoveHandler(evt:MouseEvent) : void
      {
         var textLine:TextLine = null;
         var mirrorRegions:Vector.<TextLineMirrorRegion> = null;
         var found:Boolean = false;
         var i:int = 0;
         var target:DisplayObject = evt.target as DisplayObject;
         try
         {
            while(Boolean(target) && Boolean(!(target is TextLine)))
            {
               target = target.parent;
            }
         }
         catch(e:Error)
         {
            target = null;
         }
         if(target)
         {
            textLine = target as TextLine;
            if(textLine.validity != TextLineValidity.INVALID)
            {
               mirrorRegions = textLine.mirrorRegions;
               found = false;
               if(mirrorRegions)
               {
                  for(i = 0; i < mirrorRegions.length; i++)
                  {
                     if(_mouseInLinkElement.groupElement == mirrorRegions[i].element as GroupElement)
                     {
                        found = true;
                     }
                  }
               }
               if(!found)
               {
                  target = null;
               }
            }
         }
         if(!target)
         {
            LinkElement.setLinksToDefaultState(evt);
            Mouse.cursor = MouseCursor.AUTO;
         }
      }
      
      private static function setLinksToDefaultState(evt:MouseEvent, linkEl:flashx.textLayout.elements.LinkElement = null) : void
      {
         var linkElement:flashx.textLayout.elements.LinkElement = null;
         var mouseMoveEvt:MouseEvent = null;
         var event:FlowElementMouseEvent = null;
         if(Boolean(_mouseInLinkElement) && Boolean(linkEl != _mouseInLinkElement))
         {
            linkElement = _mouseInLinkElement;
            removeLinkFromMouseInArray(linkElement);
            linkElement._mouseInLink = false;
            linkElement._isSelecting = false;
            linkElement._mouseDownInLink = false;
            mouseMoveEvt = new MouseEvent(MouseEvent.MOUSE_OUT,evt.bubbles,evt.cancelable,evt.localX,evt.localY,evt.relatedObject,evt.ctrlKey,evt.altKey,evt.shiftKey,evt.buttonDown,evt.delta);
            event = new FlowElementMouseEvent(MouseEvent.ROLL_OUT,false,true,linkElement,mouseMoveEvt);
            if(linkElement.handleEvent(event))
            {
               return;
            }
            linkElement.setHandCursor(false);
            linkElement.setToState(LinkState.LINK);
            linkElement._ignoreNextMouseOut = false;
         }
      }
      
      private static function findRootForEventHandlers(linkElement:flashx.textLayout.elements.LinkElement) : DisplayObject
      {
         var flowComposer:IFlowComposer = null;
         var textFlow:TextFlow = linkElement.getTextFlow();
         if(textFlow)
         {
            flowComposer = textFlow.flowComposer;
            if(Boolean(flowComposer) && Boolean(flowComposer.numControllers != 0))
            {
               return flowComposer.getControllerAt(0).getContainerRoot();
            }
         }
         return null;
      }
      
      private static function attachContainerEventHandlers(linkElement:flashx.textLayout.elements.LinkElement) : void
      {
         var root:DisplayObject = findRootForEventHandlers(linkElement);
         if(root)
         {
            root.addEventListener(MouseEvent.MOUSE_MOVE,stageMouseMoveHandler,false,0,true);
         }
      }
      
      private static function detachContainerEventHandlers(linkElement:flashx.textLayout.elements.LinkElement) : void
      {
         var root:DisplayObject = findRootForEventHandlers(linkElement);
         if(root)
         {
            root.removeEventListener(MouseEvent.MOUSE_MOVE,stageMouseMoveHandler);
         }
      }
      
      override tlf_internal function createContentElement() : void
      {
         super.createContentElement();
         var eventMirror:EventDispatcher = getEventMirror(SubParagraphGroupElement.INTERNAL_ATTACHED_LISTENERS);
         eventMirror.addEventListener(MouseEvent.MOUSE_DOWN,this.mouseDownHandler,false,0,true);
         eventMirror.addEventListener(MouseEvent.MOUSE_MOVE,this.mouseMoveHandler,false,0,true);
         eventMirror.addEventListener(MouseEvent.MOUSE_OUT,this.mouseOutHandler,false,0,true);
         eventMirror.addEventListener(MouseEvent.MOUSE_OVER,this.mouseOverHandler,false,0,true);
         eventMirror.addEventListener(MouseEvent.MOUSE_UP,this.mouseUpHandler,false,0,true);
      }
      
      override tlf_internal function get precedence() : uint
      {
         return 800;
      }
      
      public function addEventListener(type:String, listener:Function, useCapture:Boolean = false, priority:int = 0, useWeakReference:Boolean = false) : void
      {
         this.eventDispatcher.addEventListener(type,listener,useCapture,priority,useWeakReference);
      }
      
      public function dispatchEvent(evt:Event) : Boolean
      {
         return this.eventDispatcher.dispatchEvent(evt);
      }
      
      public function hasEventListener(type:String) : Boolean
      {
         return this.eventDispatcher.hasEventListener(type);
      }
      
      public function removeEventListener(type:String, listener:Function, useCapture:Boolean = false) : void
      {
         this.eventDispatcher.removeEventListener(type,listener,useCapture);
      }
      
      public function willTrigger(type:String) : Boolean
      {
         return this.eventDispatcher.willTrigger(type);
      }
      
      override protected function get abstract() : Boolean
      {
         return false;
      }
      
      public function get href() : String
      {
         return this._uriString;
      }
      
      public function set href(newUriString:String) : void
      {
         this._uriString = newUriString;
         modelChanged(ModelChange.ELEMENT_MODIFIED,0,textLength);
      }
      
      public function get target() : String
      {
         return this._targetString;
      }
      
      public function set target(newTargetString:String) : void
      {
         this._targetString = newTargetString;
         modelChanged(ModelChange.ELEMENT_MODIFIED,0,textLength);
      }
      
      public function get linkState() : String
      {
         return this._linkState;
      }
      
      override public function shallowCopy(startPos:int = 0, endPos:int = -1) : FlowElement
      {
         if(endPos == -1)
         {
            endPos = textLength;
         }
         var retFlow:flashx.textLayout.elements.LinkElement = super.shallowCopy(startPos,endPos) as LinkElement;
         retFlow.href = this.href;
         retFlow.target = this.target;
         return retFlow;
      }
      
      override tlf_internal function mergeToPreviousIfPossible() : Boolean
      {
         var myidx:int = 0;
         var sib:flashx.textLayout.elements.LinkElement = null;
         var curFlowElement:FlowElement = null;
         var theParent:FlowGroupElement = parent;
         if(Boolean(theParent) && Boolean(!bindableElement))
         {
            myidx = theParent.getChildIndex(this);
            if(textLength == 0)
            {
               theParent.replaceChildren(myidx,myidx + 1,null);
               return true;
            }
            if(Boolean(myidx != 0) && Boolean((attachedListenerStatus & SubParagraphGroupElement.CLIENT_ATTACHED_LISTENERS) == 0))
            {
               sib = theParent.getChildAt(myidx - 1) as LinkElement;
               if(Boolean(sib != null) && Boolean((sib.attachedListenerStatus & SubParagraphGroupElement.CLIENT_ATTACHED_LISTENERS) == 0))
               {
                  if(Boolean(this.href == sib.href) && Boolean(this.target == sib.target) && Boolean(equalStylesForMerge(sib)))
                  {
                     curFlowElement = null;
                     if(numChildren > 0)
                     {
                        while(numChildren > 0)
                        {
                           curFlowElement = getChildAt(0);
                           replaceChildren(0,1);
                           sib.replaceChildren(sib.numChildren,sib.numChildren,curFlowElement);
                        }
                     }
                     theParent.replaceChildren(myidx,myidx + 1,null);
                     return true;
                  }
               }
            }
         }
         return false;
      }
      
      private function computeLinkFormat(formatName:String) : TextLayoutFormatValueHolder
      {
         var prop:* = null;
         var tf:TextFlow = null;
         var formatStr:String = null;
         var linkStyle:Object = getStyle(formatName);
         if(linkStyle == null)
         {
            tf = getTextFlow();
            formatStr = formatName.substr(1);
            return tf == null?null:tf.configuration["defaultL" + formatStr];
         }
         if(linkStyle is TextLayoutFormatValueHolder)
         {
            return TextLayoutFormatValueHolder(linkStyle);
         }
         var ca:TextLayoutFormatValueHolder = new TextLayoutFormatValueHolder();
         var desc:Object = TextLayoutFormat.description;
         for(prop in desc)
         {
            if(linkStyle[prop] != undefined)
            {
               ca[prop] = linkStyle[prop];
            }
         }
         return ca;
      }
      
      tlf_internal function get effectiveLinkElementTextLayoutFormat() : TextLayoutFormatValueHolder
      {
         var cf:TextLayoutFormatValueHolder = null;
         if(this._linkState == LinkState.ACTIVE)
         {
            cf = this.computeLinkFormat(LINK_ACTIVE_FORMAT_NAME);
            if(cf)
            {
               return cf;
            }
         }
         if(this._linkState == LinkState.HOVER)
         {
            cf = this.computeLinkFormat(LINK_HOVER_FORMAT_NAME);
            if(cf)
            {
               return cf;
            }
         }
         return this.computeLinkFormat(LINK_NORMAL_FORMAT_NAME);
      }
      
      override tlf_internal function get formatForCascade() : TextLayoutFormatValueHolder
      {
         var resultingTextLayoutFormat:TextLayoutFormatValueHolder = null;
         var superFormat:TextLayoutFormatValueHolder = _formatValueHolder;
         var effectiveFormat:TextLayoutFormatValueHolder = this.effectiveLinkElementTextLayoutFormat;
         if(Boolean(effectiveFormat) || Boolean(superFormat))
         {
            if(Boolean(effectiveFormat) && Boolean(superFormat))
            {
               resultingTextLayoutFormat = new TextLayoutFormatValueHolder(effectiveFormat);
               if(superFormat)
               {
                  resultingTextLayoutFormat.concatInheritOnly(superFormat);
               }
               return resultingTextLayoutFormat;
            }
            return Boolean(superFormat)?superFormat:effectiveFormat;
         }
         return null;
      }
      
      private function redrawLink(ignoreNextMouseOut:Boolean = true) : void
      {
         parent.formatChanged(true);
         var tf:TextFlow = getTextFlow();
         if(Boolean(tf) && Boolean(tf.flowComposer))
         {
            tf.flowComposer.updateAllControllers();
            if(this._linkState != LinkState.HOVER)
            {
               this._ignoreNextMouseOut = ignoreNextMouseOut;
            }
         }
      }
      
      private function setToState(linkState:String, ignoreNextMouseOut:Boolean = true) : void
      {
         var oldCharAttrs:ITextLayoutFormat = null;
         var newCharAttrs:ITextLayoutFormat = null;
         if(this._linkState != linkState)
         {
            oldCharAttrs = this.effectiveLinkElementTextLayoutFormat;
            this._linkState = linkState;
            newCharAttrs = this.effectiveLinkElementTextLayoutFormat;
            if(!TextLayoutFormat.isEqual(oldCharAttrs,newCharAttrs))
            {
               this.redrawLink(ignoreNextMouseOut);
            }
         }
      }
      
      private function setHandCursor(state:Boolean = true) : void
      {
         var setContainerHandCursor:Function = null;
         var wmode:String = null;
         setContainerHandCursor = function(controller:ContainerController):void
         {
            var container:Sprite = controller.container as Sprite;
            if(container)
            {
               container.buttonMode = state;
               container.useHandCursor = state;
            }
         };
         var tf:TextFlow = getTextFlow();
         if(Boolean(tf != null) && Boolean(tf.flowComposer) && Boolean(tf.flowComposer.numControllers))
         {
            this.doToAllControllers(setContainerHandCursor);
            if(state)
            {
               Mouse.cursor = MouseCursor.AUTO;
            }
            else
            {
               wmode = tf.computedFormat.blockProgression;
               if(Boolean(tf.interactionManager) && Boolean(wmode != BlockProgression.RL))
               {
                  Mouse.cursor = MouseCursor.IBEAM;
               }
               else
               {
                  Mouse.cursor = MouseCursor.AUTO;
               }
            }
         }
      }
      
      private function handleEvent(event:FlowElementMouseEvent) : Boolean
      {
         this.eventDispatcher.dispatchEvent(event);
         if(event.isDefaultPrevented())
         {
            return true;
         }
         var textFlow:TextFlow = getTextFlow();
         if(textFlow)
         {
            textFlow.dispatchEvent(event);
            if(event.isDefaultPrevented())
            {
               return true;
            }
         }
         return false;
      }
      
      private function mouseDownHandler(evt:MouseEvent) : void
      {
         var event:FlowElementMouseEvent = null;
         if(Boolean(evt.ctrlKey) || Boolean(getTextFlow().interactionManager == null) || Boolean(getTextFlow().interactionManager.editingMode == EditingMode.READ_SELECT))
         {
            if(this._mouseInLink)
            {
               this._mouseDownInLink = true;
               event = new FlowElementMouseEvent("mouseDown",false,true,this,evt);
               if(this.handleEvent(event))
               {
                  return;
               }
               this.setHandCursor(true);
               this.setToState(LinkState.ACTIVE,false);
            }
            evt.stopImmediatePropagation();
         }
         else
         {
            this.setHandCursor(false);
            this.setToState(LinkState.LINK);
         }
      }
      
      private function mouseMoveHandler(evt:MouseEvent) : void
      {
         var event:FlowElementMouseEvent = null;
         if(this._isSelecting)
         {
            return;
         }
         if(Boolean(evt.ctrlKey) || Boolean(getTextFlow().interactionManager == null) || Boolean(getTextFlow().interactionManager.editingMode == EditingMode.READ_SELECT))
         {
            if(this._mouseInLink)
            {
               event = new FlowElementMouseEvent("mouseMove",false,true,this,evt);
               if(this.handleEvent(event))
               {
                  return;
               }
               this.setHandCursor(true);
               if(evt.buttonDown)
               {
                  this.setToState(LinkState.ACTIVE,false);
               }
               else
               {
                  this.setToState(LinkState.HOVER);
               }
            }
         }
         else
         {
            this._mouseInLink = true;
            this.setHandCursor(false);
            this.setToState(LinkState.LINK);
         }
      }
      
      private function mouseOutHandler(evt:MouseEvent) : void
      {
         var event:FlowElementMouseEvent = null;
         if(!this._ignoreNextMouseOut)
         {
            this._mouseInLink = false;
            LinkElement.removeLinkFromMouseInArray(this);
            this._isSelecting = false;
            this._mouseDownInLink = false;
            event = new FlowElementMouseEvent(MouseEvent.ROLL_OUT,false,true,this,evt);
            if(this.handleEvent(event))
            {
               return;
            }
            this.setHandCursor(false);
            this.setToState(LinkState.LINK);
         }
         this._ignoreNextMouseOut = false;
      }
      
      private function doToAllControllers(functionToCall:Function) : void
      {
         var textFlow:TextFlow = getTextFlow();
         var flowComposer:IFlowComposer = textFlow.flowComposer;
         var start:int = getAbsoluteStart();
         var controllerIndex:int = flowComposer.findControllerIndexAtPosition(start);
         var lastController:int = flowComposer.findControllerIndexAtPosition(start + textLength - 1);
         while(controllerIndex <= lastController)
         {
            functionToCall(flowComposer.getControllerAt(controllerIndex));
            controllerIndex++;
         }
      }
      
      private function mouseOverHandler(evt:MouseEvent) : void
      {
         var event:FlowElementMouseEvent = null;
         if(this._mouseInLink)
         {
            return;
         }
         if(evt.buttonDown)
         {
            this._isSelecting = true;
         }
         if(this._isSelecting)
         {
            return;
         }
         this._mouseInLink = true;
         LinkElement.setLinksToDefaultState(evt,this);
         LinkElement.addLinkToMouseInArray(this);
         if(Boolean(evt.ctrlKey) || Boolean(getTextFlow().interactionManager == null) || Boolean(getTextFlow().interactionManager.editingMode == EditingMode.READ_SELECT))
         {
            event = new FlowElementMouseEvent(MouseEvent.ROLL_OVER,false,true,this,evt);
            if(this.handleEvent(event))
            {
               return;
            }
            this.setHandCursor(true);
            if(evt.buttonDown)
            {
               this.setToState(LinkState.ACTIVE,false);
            }
            else
            {
               this.setToState(LinkState.HOVER,false);
            }
         }
         else
         {
            this.setHandCursor(false);
            this.setToState(LinkState.LINK);
         }
      }
      
      private function mouseUpHandler(evt:MouseEvent) : void
      {
         var event:FlowElementMouseEvent = null;
         if(this._isSelecting)
         {
            this._isSelecting = false;
            return;
         }
         if(Boolean(this._mouseInLink) && (Boolean(evt.ctrlKey) || Boolean(getTextFlow().interactionManager == null) || Boolean(getTextFlow().interactionManager.editingMode == EditingMode.READ_SELECT)))
         {
            event = new FlowElementMouseEvent("mouseUp",false,true,this,evt);
            if(!this.handleEvent(event))
            {
               this.setHandCursor(true);
               this.setToState(LinkState.HOVER);
               evt.stopImmediatePropagation();
            }
            if(this._mouseDownInLink)
            {
               this.mouseClickHandler(evt);
            }
         }
         else
         {
            this.setHandCursor(false);
            this.setToState(LinkState.LINK);
         }
         this._mouseDownInLink = false;
      }
      
      private function mouseClickHandler(evt:MouseEvent) : void
      {
         var event:FlowElementMouseEvent = null;
         var u:URLRequest = null;
         if(this._isSelecting)
         {
            return;
         }
         if(Boolean(evt.ctrlKey) || Boolean(getTextFlow().interactionManager == null) || Boolean(getTextFlow().interactionManager.editingMode == EditingMode.READ_SELECT))
         {
            if(this._mouseInLink)
            {
               event = new FlowElementMouseEvent("click",false,true,this,evt);
               if(this.handleEvent(event))
               {
                  return;
               }
               if(this._uriString != null)
               {
                  if(Boolean(this._uriString.length > 6) && Boolean(this._uriString.substr(0,6) == "event:"))
                  {
                     event = new FlowElementMouseEvent(this._uriString.substring(6,this._uriString.length),false,true,this,evt);
                     this.handleEvent(event);
                  }
                  else
                  {
                     u = new URLRequest(encodeURI(this._uriString));
                     navigateToURL(u,this.target);
                  }
               }
            }
            evt.stopImmediatePropagation();
         }
      }
      
      override tlf_internal function acceptTextBefore() : Boolean
      {
         return false;
      }
      
      override tlf_internal function acceptTextAfter() : Boolean
      {
         return false;
      }
      
      override tlf_internal function appendElementsForDelayedUpdate(tf:TextFlow) : void
      {
         tf.appendOneElementForUpdate(this);
         super.appendElementsForDelayedUpdate(tf);
      }
      
      override tlf_internal function updateForMustUseComposer(textFlow:TextFlow) : Boolean
      {
         return true;
      }
   }
}
