package flashx.textLayout.conversion
{
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.elements.IConfiguration;
   
   public class TextConverter
   {
      
      public static const TEXT_FIELD_HTML_FORMAT:String = "textFieldHTMLFormat";
      
      public static const PLAIN_TEXT_FORMAT:String = "plainTextFormat";
      
      public static const TEXT_LAYOUT_FORMAT:String = "textLayoutFormat";
       
      public function TextConverter()
      {
         super();
      }
      
      public static function importToFlow(source:Object, format:String, config:IConfiguration = null) : TextFlow
      {
         var parser:ITextImporter = getImporter(format,config);
         return parser.importToFlow(source);
      }
      
      public static function export(source:TextFlow, format:String, conversionType:String) : Object
      {
         var exporter:ITextExporter = getExporter(format);
         return exporter.export(source,conversionType);
      }
      
      public static function getImporter(format:String, config:IConfiguration = null) : ITextImporter
      {
         switch(format)
         {
            case TEXT_LAYOUT_FORMAT:
               return new TextLayoutImporter(config);
            case PLAIN_TEXT_FORMAT:
               return new PlainTextImporter(config);
            case TEXT_FIELD_HTML_FORMAT:
               return new HtmlImporter(config);
            default:
               return null;
         }
      }
      
      public static function getExporter(format:String) : ITextExporter
      {
         switch(format)
         {
            case TEXT_LAYOUT_FORMAT:
               return new TextLayoutExporter();
            case PLAIN_TEXT_FORMAT:
               return new PlainTextExporter();
            case TEXT_FIELD_HTML_FORMAT:
               return new HtmlExporter();
            default:
               return null;
         }
      }
   }
}
