package flashx.textLayout.conversion
{
   import flashx.textLayout.elements.IConfiguration;
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.elements.ParagraphElement;
   import flashx.textLayout.elements.SpanElement;
   
   [ExcludeClass]
   class PlainTextImporter implements ITextImporter
   {
      
      private static const _newLineRegex:RegExp = /\n|\r\n?/g;
       
      protected var _config:IConfiguration;
      
      function PlainTextImporter(config:IConfiguration = null)
      {
         super();
         this._config = config;
      }
      
      public function importToFlow(source:Object) : TextFlow
      {
         if(source is String)
         {
            return this.importFromString(String(source));
         }
         return null;
      }
      
      protected function importFromString(source:String) : TextFlow
      {
         var paraText:String = null;
         var paragraph:ParagraphElement = null;
         var span:SpanElement = null;
         var paragraphStrings:Array = source.split(_newLineRegex);
         var textFlow:TextFlow = new TextFlow(this._config);
         for each(paraText in paragraphStrings)
         {
            paragraph = new ParagraphElement();
            span = new SpanElement();
            span.replaceText(0,0,paraText);
            paragraph.replaceChildren(0,0,span);
            textFlow.replaceChildren(textFlow.numChildren,textFlow.numChildren,paragraph);
         }
         return textFlow;
      }
      
      public function get errors() : Vector.<String>
      {
         return null;
      }
      
      public function get throwOnError() : Boolean
      {
         return false;
      }
      
      public function set throwOnError(value:Boolean) : void
      {
      }
   }
}
