package flashx.textLayout.compose
{
   import flash.utils.Dictionary;
   import flashx.textLayout.tlf_internal;
   import flash.text.engine.TextLine;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.elements.ParagraphElement;
   import flash.text.engine.TextBaseline;
   import flashx.textLayout.elements.InlineGraphicElement;
   import flash.display.DisplayObject;
   import flash.display.Shape;
   import flash.display.GraphicsPathCommand;
   import flash.display.GraphicsPathWinding;
   import flashx.textLayout.elements.TextFlow;
   import flash.geom.Rectangle;
   import flashx.textLayout.formats.LineBreak;
   import flashx.textLayout.formats.BlockProgression;
   import flashx.textLayout.formats.Direction;
   import flashx.textLayout.container.ContainerController;
   import flashx.textLayout.external.WeakRef;
   import flash.text.engine.TextLineValidity;
   import flash.text.engine.TextBlock;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.elements.FlowValueHolder;
   import flashx.textLayout.elements.TCYElement;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flashx.textLayout.elements.FlowElement;
   import flashx.textLayout.elements.SubParagraphGroupElement;
   import flashx.textLayout.formats.Float;
   import flash.text.engine.TextRotation;
   import flashx.textLayout.elements.SpanElement;
   import flashx.textLayout.utils.CharacterUtil;
   import flashx.textLayout.edit.SelectionFormat;
   import flashx.textLayout.edit.ISelectionManager;
   import flashx.textLayout.elements.ContainerFormattedElement;
   import flashx.textLayout.formats.LeadingModel;
   import flash.geom.Point;
   import flashx.textLayout.formats.JustificationRule;
   
   use namespace tlf_internal;
   
   public final class TextFlowLine implements IVerticalJustificationLine
   {
      
      private static var _selectionBlockCache:Dictionary = new Dictionary(true);
      
      private static const EMPTY_LINE_WIDTH:Number = 2;
       
      private var _absoluteStart:int;
      
      private var _textLength:int;
      
      private var _height:Number = 0;
      
      private var _x:Number = 0;
      
      private var _y:Number = 0;
      
      private var _outerTargetWidth:Number = 0;
      
      private var _boundsLeftTW:int = 2;
      
      private var _boundsRightTW:int = 1;
      
      private var _boundsTopTW:int;
      
      private var _boundsBottomTW:int;
      
      private var _para:ParagraphElement;
      
      private var _controller:ContainerController;
      
      private var _columnIndex:int;
      
      private var _adornCount:int = 0;
      
      private var _ascent:Number;
      
      private var _descent:Number;
      
      private var _targetWidth:Number;
      
      private var _validity:String;
      
      private var _textHeight:Number;
      
      private var _lineOffset:Number;
      
      private var _lineExtent:Number;
      
      private var _released:Boolean;
      
      private var _alignment:String;
      
      private var _hasGraphicElement:Boolean;
      
      private var _textLineCache:WeakRef;
      
      public function TextFlowLine(textLine:TextLine, paragraph:ParagraphElement, outerTargetWidth:Number = 0, lineOffset:Number = 0, absoluteStart:int = 0, numChars:int = 0)
      {
         super();
         this.initialize(paragraph,outerTargetWidth,lineOffset,absoluteStart,numChars,textLine);
      }
      
      tlf_internal static function getTextLineTypographicAscent(textLine:TextLine, elem:FlowLeafElement, elemStart:int, textLineEnd:int, para:ParagraphElement) : Number
      {
         for(var rslt:Number = textLine.getBaselinePosition(TextBaseline.ROMAN) - textLine.getBaselinePosition(TextBaseline.ASCENT); true; )
         {
            if(elem is InlineGraphicElement)
            {
               rslt = Math.max(rslt,InlineGraphicElement(elem).getTypographicAscent(textLine));
            }
            elemStart = elemStart + elem.textLength;
            if(elemStart >= textLineEnd)
            {
               break;
            }
            elem = elem.getNextLeaf(para);
         }
         return rslt;
      }
      
      private static function createSelectionRect(selObj:Shape, color:uint, x:Number, y:Number, width:Number, height:Number) : DisplayObject
      {
         selObj.graphics.beginFill(color);
         var cmds:Vector.<int> = new Vector.<int>();
         var pathPoints:Vector.<Number> = new Vector.<Number>();
         cmds.push(GraphicsPathCommand.MOVE_TO);
         pathPoints.push(x);
         pathPoints.push(y);
         cmds.push(GraphicsPathCommand.LINE_TO);
         pathPoints.push(x + width);
         pathPoints.push(y);
         cmds.push(GraphicsPathCommand.LINE_TO);
         pathPoints.push(x + width);
         pathPoints.push(y + height);
         cmds.push(GraphicsPathCommand.LINE_TO);
         pathPoints.push(x);
         pathPoints.push(y + height);
         cmds.push(GraphicsPathCommand.LINE_TO);
         pathPoints.push(x);
         pathPoints.push(y);
         selObj.graphics.drawPath(cmds,pathPoints,GraphicsPathWinding.NON_ZERO);
         return selObj;
      }
      
      tlf_internal static function constrainRectToColumn(tf:TextFlow, rect:Rectangle, columnRect:Rectangle, hScrollPos:Number, vScrollPos:Number, compositionWidth:Number, compositionHeight:Number) : void
      {
         if(tf.computedFormat.lineBreak == LineBreak.EXPLICIT)
         {
            return;
         }
         var bp:String = tf.computedFormat.blockProgression;
         var direction:String = tf.computedFormat.direction;
         if(Boolean(bp == BlockProgression.TB) && Boolean(!isNaN(compositionWidth)))
         {
            if(direction == Direction.LTR)
            {
               if(rect.left > columnRect.x + columnRect.width + hScrollPos)
               {
                  rect.left = columnRect.x + columnRect.width + hScrollPos;
               }
               if(rect.right > columnRect.x + columnRect.width + hScrollPos)
               {
                  rect.right = columnRect.x + columnRect.width + hScrollPos;
               }
            }
            else
            {
               if(rect.right < columnRect.x + hScrollPos)
               {
                  rect.right = columnRect.x + hScrollPos;
               }
               if(rect.left < columnRect.x + hScrollPos)
               {
                  rect.left = columnRect.x + hScrollPos;
               }
            }
         }
         else if(Boolean(bp == BlockProgression.RL) && Boolean(!isNaN(compositionHeight)))
         {
            if(direction == Direction.LTR)
            {
               if(rect.top > columnRect.y + columnRect.height + vScrollPos)
               {
                  rect.top = columnRect.y + columnRect.height + vScrollPos;
               }
               if(rect.bottom > columnRect.y + columnRect.height + vScrollPos)
               {
                  rect.bottom = columnRect.y + columnRect.height + vScrollPos;
               }
            }
            else
            {
               if(rect.bottom < columnRect.y + vScrollPos)
               {
                  rect.bottom = columnRect.y + vScrollPos;
               }
               if(rect.top < columnRect.y + vScrollPos)
               {
                  rect.top = columnRect.y + vScrollPos;
               }
            }
         }
      }
      
      private static function setRectangleValues(rect:Rectangle, x:Number, y:Number, width:Number, height:Number) : void
      {
         rect.x = x;
         rect.y = y;
         rect.width = width;
         rect.height = height;
      }
      
      tlf_internal function get hasGraphicElement() : Boolean
      {
         return this._hasGraphicElement;
      }
      
      public function get textHeight() : Number
      {
         return this._textHeight;
      }
      
      tlf_internal function isLineVisible(wmode:String, x:int, y:int, w:int, h:int) : Boolean
      {
         if(this._boundsLeftTW > this._boundsRightTW)
         {
            return false;
         }
         if(wmode == BlockProgression.RL)
         {
            return Boolean(this._boundsRightTW >= x) && Boolean(this._boundsLeftTW < x + w);
         }
         return Boolean(this._boundsBottomTW >= y) && Boolean(this._boundsTopTW < y + h);
      }
      
      tlf_internal function setLineBounds(x:int, y:int, w:int, h:int) : void
      {
         this._boundsLeftTW = x;
         this._boundsRightTW = x + w;
         this._boundsTopTW = y;
         this._boundsBottomTW = y + h;
      }
      
      tlf_internal function hasLineBounds() : Boolean
      {
         return this._boundsLeftTW <= this._boundsRightTW;
      }
      
      tlf_internal function initialize(paragraph:ParagraphElement, outerTargetWidth:Number = 0, lineOffset:Number = 0, absoluteStart:int = 0, numChars:int = 0, textLine:TextLine = null) : void
      {
         this._para = paragraph;
         this._outerTargetWidth = outerTargetWidth;
         this._absoluteStart = absoluteStart;
         this._textLength = numChars;
         this._released = textLine == null;
         if(textLine)
         {
            this._textLineCache = new WeakRef(textLine);
            textLine.userData = this;
            this._targetWidth = textLine.specifiedWidth;
            this._ascent = textLine.ascent;
            this._descent = textLine.descent;
            this._textHeight = textLine.textHeight;
            this._lineOffset = lineOffset;
            this._validity = TextLineValidity.VALID;
            this._hasGraphicElement = textLine.hasGraphicElement;
         }
         else
         {
            this._validity = TextLineValidity.INVALID;
         }
      }
      
      tlf_internal function releaseTextLine() : void
      {
         this._textLineCache = null;
      }
      
      tlf_internal function peekTextLine() : TextLine
      {
         return Boolean(this._textLineCache)?this._textLineCache.get():null;
      }
      
      public function get x() : Number
      {
         return this._x;
      }
      
      public function set x(lineX:Number) : void
      {
         this._x = lineX;
         this._boundsLeftTW = 2;
         this._boundsRightTW = 1;
      }
      
      public function get y() : Number
      {
         return this._y;
      }
      
      public function set y(lineY:Number) : void
      {
         this._y = lineY;
         this._boundsLeftTW = 2;
         this._boundsRightTW = 1;
      }
      
      tlf_internal function setXYAndHeight(lineX:Number, lineY:Number, lineHeight:Number) : void
      {
         this._x = lineX;
         this._y = lineY;
         this._height = lineHeight;
         this._boundsLeftTW = 2;
         this._boundsRightTW = 1;
      }
      
      public function get location() : int
      {
         var lineStart:int = 0;
         if(this._para)
         {
            lineStart = this._absoluteStart - this._para.getAbsoluteStart();
            if(lineStart == 0)
            {
               return this._textLength == this._para.textLength?int(TextFlowLineLocation.ONLY):int(TextFlowLineLocation.FIRST);
            }
            if(lineStart + this._textLength == this._para.textLength)
            {
               return TextFlowLineLocation.LAST;
            }
         }
         return TextFlowLineLocation.MIDDLE;
      }
      
      public function get controller() : ContainerController
      {
         return this._controller;
      }
      
      public function get columnIndex() : int
      {
         return this._columnIndex;
      }
      
      tlf_internal function setController(cont:ContainerController, colNumber:int) : void
      {
         this._controller = cont as ContainerController;
         this._columnIndex = colNumber;
      }
      
      public function get height() : Number
      {
         return this._height;
      }
      
      public function get ascent() : Number
      {
         return this._ascent;
      }
      
      public function get descent() : Number
      {
         return this._descent;
      }
      
      public function get lineOffset() : Number
      {
         return this._lineOffset;
      }
      
      public function get paragraph() : ParagraphElement
      {
         return this._para;
      }
      
      public function get absoluteStart() : int
      {
         return this._absoluteStart;
      }
      
      tlf_internal function setAbsoluteStart(val:int) : void
      {
         this._absoluteStart = val;
      }
      
      public function get textLength() : int
      {
         return this._textLength;
      }
      
      tlf_internal function setTextLength(val:int) : void
      {
         this._textLength = val;
         this.damage(TextLineValidity.INVALID);
      }
      
      public function get spaceBefore() : Number
      {
         return Boolean(this.location & TextFlowLineLocation.FIRST)?Number(this._para.computedFormat.paragraphSpaceBefore):Number(0);
      }
      
      public function get spaceAfter() : Number
      {
         return Boolean(this.location & TextFlowLineLocation.LAST)?Number(this._para.computedFormat.paragraphSpaceAfter):Number(0);
      }
      
      tlf_internal function get outerTargetWidth() : Number
      {
         return this._outerTargetWidth;
      }
      
      tlf_internal function set outerTargetWidth(val:Number) : void
      {
         this._outerTargetWidth = val;
      }
      
      tlf_internal function get targetWidth() : Number
      {
         return this._targetWidth;
      }
      
      public function getBounds() : Rectangle
      {
         var textLine:TextLine = this.getTextLine(true);
         if(!textLine)
         {
            return new Rectangle();
         }
         var bp:String = this.paragraph.getAncestorWithContainer().computedFormat.blockProgression;
         var shapeX:Number = this.createShapeX();
         var shapeY:Number = this.createShapeY(bp);
         if(bp == BlockProgression.TB)
         {
            shapeY = shapeY + (this.descent - textLine.height);
         }
         return new Rectangle(shapeX,shapeY,textLine.width,textLine.height);
      }
      
      public function get validity() : String
      {
         var textLine:TextLine = null;
         if(!this._released)
         {
            textLine = this.peekTextLine();
            if(Boolean(textLine) && (Boolean(this._validity == FlowDamageType.GEOMETRY || this._validity == TextLineValidity.VALID)) && Boolean(textLine.validity != TextLineValidity.VALID))
            {
               this._validity = textLine.validity;
            }
         }
         return this._validity;
      }
      
      public function get unjustifiedTextWidth() : Number
      {
         var textLine:TextLine = this.getTextLine(true);
         return textLine.unjustifiedTextWidth + (this._outerTargetWidth - this.targetWidth);
      }
      
      tlf_internal function get lineExtent() : Number
      {
         return this._lineExtent;
      }
      
      tlf_internal function set lineExtent(value:Number) : void
      {
         this._lineExtent = value;
      }
      
      tlf_internal function get alignment() : String
      {
         return this._alignment;
      }
      
      tlf_internal function set alignment(value:String) : void
      {
         this._alignment = value;
      }
      
      tlf_internal function isDamaged() : Boolean
      {
         var textLine:TextLine = null;
         if(this._validity != TextLineValidity.VALID)
         {
            return true;
         }
         if(!this._released)
         {
            textLine = this.peekTextLine();
            if(Boolean(textLine) && Boolean(textLine.validity != TextLineValidity.VALID))
            {
               return true;
            }
         }
         return false;
      }
      
      tlf_internal function clearDamage() : void
      {
         if(this._validity == TextLineValidity.VALID)
         {
            return;
         }
         this._validity = TextLineValidity.VALID;
         var textLine:TextLine = this.peekTextLine();
         if(Boolean(textLine) && Boolean(!this._released))
         {
            textLine.validity = TextLineValidity.VALID;
         }
      }
      
      tlf_internal function damage(damageType:String) : void
      {
         if(Boolean(this._validity == damageType) || Boolean(this._validity == TextLineValidity.INVALID))
         {
            return;
         }
         this._validity = damageType;
         var textLine:TextLine = this.peekTextLine();
         if(Boolean(textLine) && Boolean(textLine.validity != TextLineValidity.INVALID))
         {
            textLine.validity = this._validity;
         }
      }
      
      public function get textLineExists() : Boolean
      {
         return this.peekTextLine() != null;
      }
      
      public function getTextLine(forceValid:Boolean = false) : TextLine
      {
         var textBlock:TextBlock = null;
         var previousLine:TextLine = null;
         var currentLine:TextLine = null;
         var flowComposer:IFlowComposer = null;
         var lineIndex:int = 0;
         var line:TextFlowLine = null;
         var para:ParagraphElement = null;
         var paraStart:int = 0;
         var elem:FlowLeafElement = null;
         var elemStart:int = 0;
         var textLine:TextLine = this.peekTextLine();
         if(Boolean(!textLine) || Boolean(textLine.validity != TextLineValidity.VALID) && Boolean(forceValid))
         {
            if(Boolean(this.isDamaged()) && Boolean(this.validity != FlowDamageType.GEOMETRY))
            {
               return null;
            }
            textBlock = this.paragraph.getTextBlock();
            currentLine = textBlock.firstLine;
            flowComposer = this.paragraph.getTextFlow().flowComposer;
            lineIndex = flowComposer.findLineIndexAtPosition(this.paragraph.getAbsoluteStart());
            do
            {
               line = flowComposer.getLineAt(lineIndex);
               if(Boolean(currentLine != null) && Boolean(currentLine.validity == TextLineValidity.VALID))
               {
                  textLine = currentLine;
                  currentLine = currentLine.nextLine;
                  line.updateTextLineCache(textLine);
               }
               else
               {
                  textLine = line.recreateTextLine(textBlock,previousLine);
                  currentLine = null;
               }
               previousLine = textLine;
               lineIndex++;
            }
            while(line != this);
            
         }
         if(Boolean(textLine != null) && Boolean(textLine.numChildren == 0) && Boolean(this._adornCount > 0))
         {
            para = this.paragraph;
            paraStart = para.getAbsoluteStart();
            elem = para.findLeaf(this.absoluteStart - paraStart);
            elemStart = elem.getAbsoluteStart();
            this.createAdornments(para.getAncestorWithContainer().computedFormat.blockProgression,elem,elemStart);
         }
         return textLine;
      }
      
      tlf_internal function recreateTextLine(textBlock:TextBlock, previousLine:TextLine) : TextLine
      {
         var textLine:TextLine = null;
         if(!this._released)
         {
            textLine = this.peekTextLine();
            if(textLine)
            {
               return textLine;
            }
         }
         var textFlow:TextFlow = this.paragraph.getTextFlow();
         var flowComposer:IFlowComposer = textFlow.flowComposer;
         var swfContext:ISWFContext = Boolean(flowComposer.swfContext)?flowComposer.swfContext:BaseCompose.globalSWFContext;
         textLine = TextLineRecycler.getLineForReuse();
         if(textLine)
         {
            textLine = swfContext.callInContext(textBlock["recreateTextLine"],textBlock,[textLine,previousLine,this._targetWidth,this._lineOffset,true]);
         }
         else
         {
            textLine = swfContext.callInContext(textBlock.createTextLine,textBlock,[previousLine,this._targetWidth,this._lineOffset,true]);
         }
         textLine.x = this.createShapeX();
         textLine.y = this.createShapeY(textFlow.computedFormat.blockProgression);
         textLine.doubleClickEnabled = true;
         this.updateTextLineCache(textLine);
         return textLine;
      }
      
      private function updateTextLineCache(textLine:TextLine) : void
      {
         textLine.userData = this;
         var existingTextLine:TextLine = this.peekTextLine();
         if(Boolean(!existingTextLine) || Boolean(existingTextLine.parent == null))
         {
            if(existingTextLine != textLine)
            {
               this._textLineCache = new WeakRef(textLine);
            }
            this._released = false;
         }
      }
      
      tlf_internal function markReleased() : void
      {
         this._released = true;
      }
      
      tlf_internal function createShape(bp:String) : TextLine
      {
         var textLine:TextLine = this.getTextLine();
         var newX:Number = this.createShapeX();
         textLine.x = newX;
         var newY:Number = this.createShapeY(bp);
         textLine.y = newY;
         return textLine;
      }
      
      private function createShapeX() : Number
      {
         return this.x;
      }
      
      private function createShapeY(bp:String) : Number
      {
         return bp == BlockProgression.RL?Number(this.y):Number(this.y + this._ascent);
      }
      
      tlf_internal function createAdornments(blockProgression:String, elem:FlowLeafElement, elemStart:int) : void
      {
         var format:ITextLayoutFormat = null;
         var fvh:FlowValueHolder = null;
         var endPos:int = this._absoluteStart + this._textLength;
         for(this._adornCount = 0; true; )
         {
            format = elem.computedFormat;
            this._adornCount = this._adornCount + elem.updateAdornments(this,blockProgression);
            fvh = elem.format as FlowValueHolder;
            if(Boolean(fvh) && Boolean(fvh.userStyles) && Boolean(fvh.userStyles.imeStatus))
            {
               elem.updateIMEAdornments(this,blockProgression,fvh.userStyles.imeStatus as String);
            }
            elemStart = elemStart + elem.textLength;
            if(elemStart >= endPos)
            {
               break;
            }
            elem = elem.getNextLeaf(this._para);
         }
      }
      
      tlf_internal function getLineLeading(bp:String, elem:FlowLeafElement, elemStart:int) : Number
      {
         var elemLeading:Number = NaN;
         var endPos:int = this._absoluteStart + this._textLength;
         for(var totalLeading:Number = 0; true; )
         {
            if(!(Boolean(bp == BlockProgression.RL) && Boolean(elem.parent is TCYElement) && (Boolean(!isNaN(totalLeading)) || Boolean(elem.textLength != this.textLength))))
            {
               elemLeading = TextLayoutFormat.lineHeightProperty.computeActualPropertyValue(elem.computedFormat.lineHeight,elem.getEffectiveFontSize());
               totalLeading = Math.max(totalLeading,elemLeading);
            }
            elemStart = elemStart + elem.textLength;
            if(elemStart >= endPos)
            {
               break;
            }
            elem = elem.getNextLeaf(this._para);
         }
         return totalLeading;
      }
      
      tlf_internal function getLineTypographicAscent(elem:FlowLeafElement, elemStart:int) : Number
      {
         return getTextLineTypographicAscent(this.getTextLine(),elem,elemStart,this.absoluteStart + this.textLength,this._para);
      }
      
      private function isTextlineSubsetOfSpan(element:FlowLeafElement) : Boolean
      {
         var spanStart:int = element.getAbsoluteStart();
         var spanEnd:int = spanStart + element.textLength;
         var lineStart:int = this.absoluteStart;
         var lineEnd:int = this.absoluteStart + this._textLength;
         return Boolean(spanStart <= lineStart) && Boolean(spanEnd >= lineEnd);
      }
      
      private function getSelectionShapesCacheEntry(begIdx:int, endIdx:int, prevLine:TextFlowLine, nextLine:TextFlowLine, blockProgression:String) : SelectionCache
      {
         var drawRect:Rectangle = null;
         if(this.isDamaged())
         {
            return null;
         }
         var paraAbsStart:int = this._para.getAbsoluteStart();
         if(Boolean(begIdx == endIdx) && Boolean(paraAbsStart + begIdx == this.absoluteStart))
         {
            if(this.absoluteStart != this._para.getTextFlow().textLength - 1)
            {
               return null;
            }
            endIdx++;
         }
         var selectionCache:SelectionCache = _selectionBlockCache[this];
         if(Boolean(selectionCache) && Boolean(selectionCache.begIdx == begIdx) && Boolean(selectionCache.endIdx == endIdx))
         {
            return selectionCache;
         }
         var drawRects:Array = new Array();
         var tcyDrawRects:Array = new Array();
         if(selectionCache == null)
         {
            selectionCache = new SelectionCache();
            _selectionBlockCache[this] = selectionCache;
         }
         else
         {
            selectionCache.clear();
         }
         selectionCache.begIdx = begIdx;
         selectionCache.endIdx = endIdx;
         var textLine:TextLine = this.getTextLine();
         var heightAndAdj:Array = this.getRomanSelectionHeightAndVerticalAdjustment(prevLine,nextLine);
         this.calculateSelectionBounds(textLine,drawRects,begIdx,endIdx,blockProgression,heightAndAdj);
         for each(drawRect in drawRects)
         {
            selectionCache.pushSelectionBlock(drawRect);
         }
         if(textLine)
         {
            textLine.flushAtomData();
         }
         return selectionCache;
      }
      
      tlf_internal function calculateSelectionBounds(textLine:TextLine, rectArray:Array, begIdx:int, endIdx:int, blockProgression:String, heightAndAdj:Array) : void
      {
         var numCharsSelecting:int = 0;
         var endPos:int = 0;
         var tempFloatArray:Array = null;
         var leafBlockArray:Array = null;
         var leafBlockIter:int = 0;
         var tcyBlock:FlowElement = null;
         var tcyParentRelativeEnd:int = 0;
         var subParBlock:SubParagraphGroupElement = null;
         var largestTCYRise:Number = NaN;
         var lastTCYIdx:int = 0;
         var tcyRects:Array = null;
         var tcyRectArray:Array = null;
         var tcyBlockIter:int = 0;
         var tcyRect:Rectangle = null;
         var charCode:int = 0;
         var lastElemBlockArray:Array = null;
         var lastRect:Rectangle = null;
         var modifyRect:Rectangle = null;
         var tcyIter:int = 0;
         var floatIter:int = 0;
         var direction:String = this._para.computedFormat.direction;
         var paraAbsStart:int = this._para.getAbsoluteStart();
         var curIdx:int = begIdx;
         var curElem:FlowLeafElement = null;
         var largestRise:Number = 0;
         var blockRectArray:Array = new Array();
         var floatRectArray:Array = null;
         var tcyDrawRects:Array = null;
         while(curIdx < endIdx)
         {
            curElem = this._para.findLeaf(curIdx);
            if(curElem.textLength == 0)
            {
               curIdx++;
            }
            else if(Boolean(curElem is InlineGraphicElement) && Boolean((curElem as InlineGraphicElement).float != Float.NONE))
            {
               if(floatRectArray == null)
               {
                  floatRectArray = new Array();
               }
               tempFloatArray = this.makeSelectionBlocks(curIdx,curIdx + 1,paraAbsStart,blockProgression,direction,heightAndAdj);
               floatRectArray.push(tempFloatArray[0]);
               curIdx++;
            }
            else
            {
               numCharsSelecting = curElem.textLength + curElem.getElementRelativeStart(this._para) - curIdx;
               endPos = numCharsSelecting + curIdx > endIdx?int(endIdx):int(numCharsSelecting + curIdx);
               if(Boolean(blockProgression != BlockProgression.RL) || Boolean(textLine.getAtomTextRotation(textLine.getAtomIndexAtCharIndex(curIdx)) != TextRotation.ROTATE_0))
               {
                  leafBlockArray = this.makeSelectionBlocks(curIdx,endPos,paraAbsStart,blockProgression,direction,heightAndAdj);
                  for(leafBlockIter = 0; leafBlockIter < leafBlockArray.length; leafBlockIter++)
                  {
                     blockRectArray.push(leafBlockArray[leafBlockIter]);
                  }
                  curIdx = endPos;
               }
               else
               {
                  tcyBlock = curElem.getParentByType(TCYElement);
                  tcyParentRelativeEnd = tcyBlock.parentRelativeEnd;
                  subParBlock = tcyBlock.getParentByType(SubParagraphGroupElement) as SubParagraphGroupElement;
                  while(subParBlock)
                  {
                     tcyParentRelativeEnd = tcyParentRelativeEnd + subParBlock.parentRelativeStart;
                     subParBlock = subParBlock.getParentByType(SubParagraphGroupElement) as SubParagraphGroupElement;
                  }
                  largestTCYRise = 0;
                  lastTCYIdx = endIdx < tcyParentRelativeEnd?int(endIdx):int(tcyParentRelativeEnd);
                  tcyRects = new Array();
                  while(curIdx < lastTCYIdx)
                  {
                     curElem = this._para.findLeaf(curIdx);
                     numCharsSelecting = curElem.textLength + curElem.getElementRelativeStart(this._para) - curIdx;
                     endPos = numCharsSelecting + curIdx > endIdx?int(endIdx):int(numCharsSelecting + curIdx);
                     tcyRectArray = this.makeSelectionBlocks(curIdx,endPos,paraAbsStart,blockProgression,direction,heightAndAdj);
                     for(tcyBlockIter = 0; tcyBlockIter < tcyRectArray.length; tcyBlockIter++)
                     {
                        tcyRect = tcyRectArray[tcyBlockIter];
                        if(tcyRect.height > largestTCYRise)
                        {
                           largestTCYRise = tcyRect.height;
                        }
                        tcyRects.push(tcyRect);
                     }
                     curIdx = endPos;
                  }
                  if(!tcyDrawRects)
                  {
                     tcyDrawRects = new Array();
                  }
                  this.normalizeRects(tcyRects,tcyDrawRects,largestTCYRise,BlockProgression.TB,direction);
               }
            }
         }
         if(Boolean(blockRectArray.length > 0) && Boolean(paraAbsStart + begIdx == this.absoluteStart) && Boolean(paraAbsStart + endIdx == this.absoluteStart + this.textLength))
         {
            curElem = this._para.findLeaf(begIdx);
            if(Boolean(curElem.getAbsoluteStart() + curElem.textLength < this.absoluteStart + this.textLength) && Boolean(endPos >= 2))
            {
               charCode = this._para.getCharCodeAtPosition(endPos - 1);
               if(Boolean(charCode != SpanElement.kParagraphTerminator.charCodeAt(0)) && Boolean(CharacterUtil.isWhitespace(charCode)))
               {
                  lastElemBlockArray = this.makeSelectionBlocks(endPos - 1,endPos - 1,paraAbsStart,blockProgression,direction,heightAndAdj);
                  lastRect = lastElemBlockArray[lastElemBlockArray.length - 1];
                  modifyRect = blockRectArray[blockRectArray.length - 1] as Rectangle;
                  if(blockProgression != BlockProgression.RL)
                  {
                     if(modifyRect.width == lastRect.width)
                     {
                        blockRectArray.pop();
                     }
                     else
                     {
                        modifyRect.width = modifyRect.width - lastRect.width;
                        if(direction == Direction.RTL)
                        {
                           modifyRect.left = modifyRect.left - lastRect.width;
                        }
                     }
                  }
                  else if(modifyRect.height == lastRect.height)
                  {
                     blockRectArray.pop();
                  }
                  else
                  {
                     modifyRect.height = modifyRect.height - lastRect.height;
                     if(direction == Direction.RTL)
                     {
                        modifyRect.top = modifyRect.top + lastRect.height;
                     }
                  }
               }
            }
         }
         this.normalizeRects(blockRectArray,rectArray,largestRise,blockProgression,direction);
         if(Boolean(tcyDrawRects) && Boolean(tcyDrawRects.length > 0))
         {
            for(tcyIter = 0; tcyIter < tcyDrawRects.length; tcyIter++)
            {
               rectArray.push(tcyDrawRects[tcyIter]);
            }
         }
         if(floatRectArray)
         {
            for(floatIter = 0; floatIter < floatRectArray.length; floatIter++)
            {
               rectArray.push(floatRectArray[floatIter]);
            }
         }
      }
      
      private function createSelectionShapes(selObj:Shape, selFormat:SelectionFormat, container:DisplayObject, begIdx:int, endIdx:int, prevLine:TextFlowLine, nextLine:TextFlowLine) : void
      {
         var drawRect:Rectangle = null;
         var selMgr:ISelectionManager = null;
         var contElement:ContainerFormattedElement = this._para.getAncestorWithContainer();
         var blockProgression:String = contElement.computedFormat.blockProgression;
         var selCache:SelectionCache = this.getSelectionShapesCacheEntry(begIdx,endIdx,prevLine,nextLine,blockProgression);
         if(!selCache)
         {
            return;
         }
         var color:uint = selFormat.rangeColor;
         if(Boolean(this._para) && Boolean(this._para.getTextFlow()))
         {
            selMgr = this._para.getTextFlow().interactionManager;
            if(Boolean(selMgr) && Boolean(selMgr.anchorPosition == selMgr.activePosition))
            {
               color = selFormat.pointColor;
            }
         }
         for each(drawRect in selCache.selectionBlocks)
         {
            drawRect = drawRect.clone();
            this.convertLineRectToContainer(drawRect,true);
            createSelectionRect(selObj,color,drawRect.x,drawRect.y,drawRect.width,drawRect.height);
         }
      }
      
      tlf_internal function getRomanSelectionHeightAndVerticalAdjustment(prevLine:TextFlowLine, nextLine:TextFlowLine) : Array
      {
         var isFirstLine:Boolean = false;
         var isLastLine:Boolean = false;
         var top:Number = NaN;
         var bottom:Number = NaN;
         var rectHeight:Number = 0;
         var verticalAdj:Number = 0;
         if(ParagraphElement.useUpLeadingDirection(this._para.getEffectiveLeadingModel()))
         {
            rectHeight = this.height > this._textHeight?Number(this.height):Number(this._textHeight);
         }
         else
         {
            isFirstLine = Boolean(!prevLine) || Boolean(prevLine.controller != this.controller) || Boolean(prevLine.columnIndex != this.columnIndex);
            isLastLine = Boolean(!nextLine) || Boolean(nextLine.controller != this.controller) || Boolean(nextLine.columnIndex != this.columnIndex) || Boolean(nextLine.paragraph.getEffectiveLeadingModel() == LeadingModel.ROMAN_UP);
            if(isLastLine)
            {
               if(!isFirstLine)
               {
                  rectHeight = this._textHeight;
               }
               else
               {
                  rectHeight = this.height > this._textHeight?Number(this.height):Number(this._textHeight);
               }
            }
            else if(!isFirstLine)
            {
               rectHeight = nextLine.height > this._textHeight?Number(nextLine.height):Number(this._textHeight);
               verticalAdj = rectHeight - this._textHeight;
            }
            else
            {
               top = this._descent - (this.height > this._textHeight?this.height:this._textHeight);
               bottom = (nextLine.height > this._textHeight?nextLine.height:this._textHeight) - this._ascent;
               rectHeight = bottom - top;
               verticalAdj = bottom - this._descent;
            }
         }
         if(Boolean(!prevLine) || Boolean(prevLine.columnIndex != this.columnIndex) || Boolean(prevLine.controller != this.controller))
         {
            rectHeight = rectHeight + this.descent;
            verticalAdj = Math.floor(this.descent / 2);
         }
         return [rectHeight,verticalAdj];
      }
      
      private function makeSelectionBlocks(begIdx:int, endIdx:int, paraAbsStart:int, blockProgression:String, direction:String, heightAndAdj:Array) : Array
      {
         var globalStart:Point = null;
         var justRule:String = null;
         var eaStartElem:int = 0;
         var eaStartRect:Rectangle = null;
         var begElementIndex:int = 0;
         var endElementIndex:int = 0;
         var begIsBidi:Boolean = false;
         var endIsBidi:Boolean = false;
         var bidiBlock:Array = null;
         var bidiBlockIter:int = 0;
         var curIdx:int = 0;
         var incrementor:int = 0;
         var activeStartIndex:int = 0;
         var activeEndIndex:int = 0;
         var curElementIndex:int = 0;
         var activeEndIsBidi:Boolean = false;
         var curIsBidi:Boolean = false;
         var testILG:InlineGraphicElement = null;
         var blockArray:Array = new Array();
         var blockRect:Rectangle = new Rectangle();
         var startElem:FlowLeafElement = this._para.findLeaf(begIdx);
         var startMetrics:Rectangle = startElem.getComputedFontMetrics().emBox;
         var textLine:TextLine = this.getTextLine(true);
         if(Boolean(paraAbsStart + begIdx == this.absoluteStart) && Boolean(paraAbsStart + endIdx == this.absoluteStart + this.textLength))
         {
            globalStart = new Point(0,0);
            justRule = this._para.getEffectiveJustificationRule();
            if(justRule != JustificationRule.EAST_ASIAN)
            {
               if(blockProgression == BlockProgression.RL)
               {
                  globalStart.x = globalStart.x - heightAndAdj[1];
                  blockRect.width = heightAndAdj[0];
                  blockRect.height = textLine.textWidth == 0?Number(EMPTY_LINE_WIDTH):Number(textLine.textWidth);
               }
               else
               {
                  globalStart.y = globalStart.y + heightAndAdj[1];
                  blockRect.height = heightAndAdj[0];
                  blockRect.width = textLine.textWidth == 0?Number(EMPTY_LINE_WIDTH):Number(textLine.textWidth);
               }
            }
            else
            {
               eaStartElem = textLine.getAtomIndexAtCharIndex(begIdx);
               eaStartRect = textLine.getAtomBounds(eaStartElem);
               if(blockProgression == BlockProgression.RL)
               {
                  blockRect.width = eaStartRect.width;
                  blockRect.height = textLine.textWidth;
               }
               else
               {
                  blockRect.height = eaStartRect.height;
                  blockRect.width = textLine.textWidth;
               }
            }
            blockRect.x = globalStart.x;
            blockRect.y = globalStart.y;
            if(blockProgression == BlockProgression.RL)
            {
               blockRect.x = blockRect.x - textLine.descent;
            }
            else
            {
               blockRect.y = blockRect.y + (textLine.descent - blockRect.height);
            }
            if(Boolean(startElem.computedFormat.textRotation == TextRotation.ROTATE_180) || Boolean(startElem.computedFormat.textRotation == TextRotation.ROTATE_90))
            {
               if(blockProgression != BlockProgression.RL)
               {
                  blockRect.y = blockRect.y + blockRect.height / 2;
               }
               else
               {
                  blockRect.x = blockRect.x - blockRect.width;
               }
            }
            blockArray.push(blockRect);
         }
         else
         {
            begElementIndex = textLine.getAtomIndexAtCharIndex(begIdx);
            endElementIndex = this.adjustEndElementForBidi(begIdx,endIdx,begElementIndex,direction);
            if(Boolean(direction == Direction.RTL) && Boolean(textLine.getAtomBidiLevel(endElementIndex) % 2 != 0))
            {
               if(Boolean(endElementIndex == 0) && Boolean(begIdx < endIdx - 1))
               {
                  blockArray = this.makeSelectionBlocks(begIdx,endIdx - 1,paraAbsStart,blockProgression,direction,heightAndAdj);
                  bidiBlock = this.makeSelectionBlocks(endIdx - 1,endIdx - 1,paraAbsStart,blockProgression,direction,heightAndAdj);
                  bidiBlockIter = 0;
                  while(bidiBlockIter < bidiBlock.length)
                  {
                     blockArray.push(bidiBlock[bidiBlockIter]);
                     bidiBlockIter++;
                  }
                  return blockArray;
               }
            }
            begIsBidi = begElementIndex != -1?Boolean(this.isAtomBidi(begElementIndex,direction)):Boolean(false);
            endIsBidi = endElementIndex != -1?Boolean(this.isAtomBidi(endElementIndex,direction)):Boolean(false);
            if(Boolean(begIsBidi) || Boolean(endIsBidi))
            {
               curIdx = begIdx;
               incrementor = begIdx != endIdx?int(1):int(0);
               activeStartIndex = begElementIndex;
               activeEndIndex = begElementIndex;
               curElementIndex = begElementIndex;
               activeEndIsBidi = begIsBidi;
               do
               {
                  curIdx = curIdx + incrementor;
                  curElementIndex = textLine.getAtomIndexAtCharIndex(curIdx);
                  curIsBidi = curElementIndex != -1?Boolean(this.isAtomBidi(curElementIndex,direction)):Boolean(false);
                  if(Boolean(curElementIndex != -1) && Boolean(curIsBidi != activeEndIsBidi))
                  {
                     blockRect = this.makeBlock(activeStartIndex,activeEndIndex,startMetrics,blockProgression,direction,heightAndAdj);
                     blockArray.push(blockRect);
                     activeStartIndex = curElementIndex;
                     activeEndIndex = curElementIndex;
                     activeEndIsBidi = curIsBidi;
                  }
                  else
                  {
                     if(curIdx == endIdx)
                     {
                        blockRect = this.makeBlock(activeStartIndex,activeEndIndex,startMetrics,blockProgression,direction,heightAndAdj);
                        blockArray.push(blockRect);
                     }
                     activeEndIndex = curElementIndex;
                  }
               }
               while(curIdx < endIdx);
               
            }
            else
            {
               testILG = startElem as InlineGraphicElement;
               if(Boolean(!testILG) || Boolean(testILG.float == Float.NONE))
               {
                  blockRect = this.makeBlock(begElementIndex,endElementIndex,startMetrics,blockProgression,direction,heightAndAdj);
               }
               else
               {
                  blockRect = testILG.graphic.getBounds(textLine);
               }
               blockArray.push(blockRect);
            }
         }
         return blockArray;
      }
      
      private function makeBlock(param1:int, param2:int, param3:Rectangle, param4:String, param5:String, param6:Array) : Rectangle
      {
         var _loc16_:int = 0;
         var _loc7_:Rectangle = new Rectangle();
         var _loc8_:Point = new Point(0,0);
         if(param1 > param2)
         {
            _loc16_ = param2;
            param2 = param1;
            param1 = _loc16_;
         }
         var _loc9_:TextLine = this.getTextLine(true);
         var _loc10_:Rectangle = _loc9_.getAtomBounds(param1);
         var _loc11_:Rectangle = _loc9_.getAtomBounds(param2);
         var _loc12_:String = this._para.getEffectiveJustificationRule();
         if(Boolean(param4 == BlockProgression.RL) && Boolean(_loc9_.getAtomTextRotation(param1) != TextRotation.ROTATE_0))
         {
            _loc8_.y = _loc10_.y;
            _loc7_.height = param1 != param2?Number(_loc11_.bottom - _loc10_.top):Number(_loc10_.height);
            if(_loc12_ == JustificationRule.EAST_ASIAN)
            {
               _loc7_.width = _loc10_.width;
            }
            else
            {
               _loc7_.width = param6[0];
               _loc8_.x = _loc8_.x - param6[1];
            }
         }
         else
         {
            _loc8_.x = _loc10_.x < _loc11_.x?Number(_loc10_.x):Number(_loc11_.x);
            if(param4 == BlockProgression.RL)
            {
               _loc8_.y = _loc10_.y + param3.width / 2;
            }
            if(_loc12_ != JustificationRule.EAST_ASIAN)
            {
               _loc7_.height = param6[0];
               if(param4 == BlockProgression.RL)
               {
                  _loc8_.x = _loc8_.x - param6[1];
               }
               else
               {
                  _loc8_.y = _loc8_.y + param6[1];
               }
               _loc7_.width = param1 != param2?Number(Math.abs(_loc11_.right - _loc10_.left)):Number(_loc10_.width);
            }
            else
            {
               _loc7_.height = _loc10_.height;
               _loc7_.width = param1 != param2?Number(Math.abs(_loc11_.right - _loc10_.left)):Number(_loc10_.width);
            }
         }
         _loc7_.x = _loc8_.x;
         _loc7_.y = _loc8_.y;
         if(param4 == BlockProgression.RL)
         {
            if(_loc9_.getAtomTextRotation(param1) != TextRotation.ROTATE_0)
            {
               _loc7_.x = _loc7_.x - _loc9_.descent;
            }
            else
            {
               _loc7_.y = _loc7_.y - _loc7_.height / 2;
            }
         }
         else
         {
            _loc7_.y = _loc7_.y + (_loc9_.descent - _loc7_.height);
         }
         var _loc13_:TextFlowLine = _loc9_.userData as TextFlowLine;
         var _loc14_:FlowLeafElement = this._para.findLeaf(_loc9_.textBlockBeginIndex + param1);
         var _loc15_:String = _loc14_.computedFormat.textRotation;
         if(Boolean(_loc15_ == TextRotation.ROTATE_180) || Boolean(_loc15_ == TextRotation.ROTATE_90))
         {
            if(param4 != BlockProgression.RL)
            {
               _loc7_.y = _loc7_.y + _loc7_.height / 2;
            }
            else if(_loc14_.getParentByType(TCYElement) == null)
            {
               if(_loc15_ == TextRotation.ROTATE_90)
               {
                  _loc7_.x = _loc7_.x - _loc7_.width;
               }
               else
               {
                  _loc7_.x = _loc7_.x - _loc7_.width * 0.75;
               }
            }
            else if(_loc15_ == TextRotation.ROTATE_90)
            {
               _loc7_.y = _loc7_.y + _loc7_.height;
            }
            else
            {
               _loc7_.y = _loc7_.y + _loc7_.height * 0.75;
            }
         }
         return _loc7_;
      }
      
      tlf_internal function convertLineRectToContainer(rect:Rectangle, constrainShape:Boolean) : void
      {
         var tf:TextFlow = null;
         var columnRect:Rectangle = null;
         var textLine:TextLine = this.getTextLine();
         rect.x = rect.x + textLine.x;
         rect.y = rect.y + textLine.y;
         if(constrainShape)
         {
            tf = this._para.getTextFlow();
            columnRect = this.controller.columnState.getColumnAt(this.columnIndex);
            constrainRectToColumn(tf,rect,columnRect,this.controller.horizontalScrollPosition,this.controller.verticalScrollPosition,this.controller.compositionWidth,this.controller.compositionHeight);
         }
      }
      
      tlf_internal function hiliteBlockSelection(selObj:Shape, selFormat:SelectionFormat, container:DisplayObject, begIdx:int, endIdx:int, prevLine:TextFlowLine, nextLine:TextFlowLine) : void
      {
         if(Boolean(this.isDamaged()) || Boolean(!this._controller))
         {
            return;
         }
         var textLine:TextLine = this.peekTextLine();
         if(Boolean(!textLine) || Boolean(!textLine.parent))
         {
            return;
         }
         var paraStart:int = this._para.getAbsoluteStart();
         begIdx = begIdx - paraStart;
         endIdx = endIdx - paraStart;
         this.createSelectionShapes(selObj,selFormat,container,begIdx,endIdx,prevLine,nextLine);
      }
      
      tlf_internal function hilitePointSelection(selFormat:SelectionFormat, idx:int, container:DisplayObject, prevLine:TextFlowLine, nextLine:TextFlowLine) : void
      {
         var rect:Rectangle = this.computePointSelectionRectangle(idx,container,prevLine,nextLine,true);
         if(rect)
         {
            this._controller.drawPointSelection(selFormat,rect.x,rect.y,rect.width,rect.height);
         }
      }
      
      tlf_internal function computePointSelectionRectangle(idx:int, container:DisplayObject, prevLine:TextFlowLine, nextLine:TextFlowLine, constrainSelRect:Boolean) : Rectangle
      {
         var prevElementIndex:int = 0;
         if(Boolean(this.isDamaged()) || Boolean(!this._controller))
         {
            return null;
         }
         var textLine:TextLine = this.peekTextLine();
         if(Boolean(!textLine) || Boolean(!textLine.parent))
         {
            return null;
         }
         idx = idx - this._para.getAbsoluteStart();
         textLine = this.getTextLine(true);
         var endIdx:int = idx;
         var elementIndex:int = textLine.getAtomIndexAtCharIndex(idx);
         var isTCYBounds:Boolean = false;
         var paraLeadingTCY:Boolean = false;
         var contElement:ContainerFormattedElement = this._para.getAncestorWithContainer();
         var blockProgression:String = contElement.computedFormat.blockProgression;
         var direction:String = this._para.computedFormat.direction;
         if(blockProgression == BlockProgression.RL)
         {
            if(idx == 0)
            {
               if(textLine.getAtomTextRotation(0) == TextRotation.ROTATE_0)
               {
                  paraLeadingTCY = true;
               }
            }
            else
            {
               prevElementIndex = textLine.getAtomIndexAtCharIndex(idx - 1);
               if(prevElementIndex != -1)
               {
                  if(Boolean(textLine.getAtomTextRotation(elementIndex) == TextRotation.ROTATE_0) && Boolean(textLine.getAtomTextRotation(prevElementIndex) != TextRotation.ROTATE_0))
                  {
                     elementIndex = prevElementIndex;
                     idx--;
                     isTCYBounds = true;
                  }
                  else if(textLine.getAtomTextRotation(prevElementIndex) == TextRotation.ROTATE_0)
                  {
                     elementIndex = prevElementIndex;
                     idx--;
                     isTCYBounds = true;
                  }
               }
            }
         }
         var heightAndAdj:Array = this.getRomanSelectionHeightAndVerticalAdjustment(prevLine,nextLine);
         var blockRectArray:Array = this.makeSelectionBlocks(idx,endIdx,this._para.getAbsoluteStart(),blockProgression,direction,heightAndAdj);
         var rect:Rectangle = blockRectArray[0];
         this.convertLineRectToContainer(rect,constrainSelRect);
         var drawOnRight:Boolean = direction == Direction.RTL;
         if(Boolean(drawOnRight) && Boolean(textLine.getAtomBidiLevel(elementIndex) % 2 == 0) || Boolean(!drawOnRight) && Boolean(textLine.getAtomBidiLevel(elementIndex) % 2 != 0))
         {
            drawOnRight = !drawOnRight;
         }
         if(Boolean(blockProgression == BlockProgression.RL) && Boolean(textLine.getAtomTextRotation(elementIndex) != TextRotation.ROTATE_0))
         {
            if(!drawOnRight)
            {
               setRectangleValues(rect,rect.x,!isTCYBounds?Number(rect.y):Number(rect.y + rect.height),rect.width,1);
            }
            else
            {
               setRectangleValues(rect,rect.x,!isTCYBounds?Number(rect.y + rect.height):Number(rect.y),rect.width,1);
            }
         }
         else if(!drawOnRight)
         {
            setRectangleValues(rect,!isTCYBounds?Number(rect.x):Number(rect.x + rect.width),rect.y,1,rect.height);
         }
         else
         {
            setRectangleValues(rect,!isTCYBounds?Number(rect.x + rect.width):Number(rect.x),rect.y,1,rect.height);
         }
         textLine.flushAtomData();
         return rect;
      }
      
      tlf_internal function selectionWillIntersectScrollRect(scrollRect:Rectangle, begIdx:int, endIdx:int, prevLine:TextFlowLine, nextLine:TextFlowLine) : int
      {
         var pointSelRect:Rectangle = null;
         var paraStart:int = 0;
         var selCache:SelectionCache = null;
         var drawRect:Rectangle = null;
         var contElement:ContainerFormattedElement = this._para.getAncestorWithContainer();
         var blockProgression:String = contElement.computedFormat.blockProgression;
         var textLine:TextLine = this.getTextLine(true);
         if(begIdx == endIdx)
         {
            pointSelRect = this.computePointSelectionRectangle(begIdx,DisplayObject(this.controller.container),prevLine,nextLine,false);
            if(pointSelRect)
            {
               if(scrollRect.containsRect(pointSelRect))
               {
                  return 2;
               }
               if(scrollRect.intersects(pointSelRect))
               {
                  return 1;
               }
            }
         }
         else
         {
            paraStart = this._para.getAbsoluteStart();
            selCache = this.getSelectionShapesCacheEntry(begIdx - paraStart,endIdx - paraStart,prevLine,nextLine,blockProgression);
            if(selCache)
            {
               for each(drawRect in selCache.selectionBlocks)
               {
                  drawRect = drawRect.clone();
                  drawRect.x = drawRect.x + textLine.x;
                  drawRect.y = drawRect.y + textLine.y;
                  if(scrollRect.intersects(drawRect))
                  {
                     if(blockProgression == BlockProgression.RL)
                     {
                        if(Boolean(drawRect.left >= scrollRect.left) && Boolean(drawRect.right <= scrollRect.right))
                        {
                           return 2;
                        }
                     }
                     else if(Boolean(drawRect.top >= scrollRect.top) && Boolean(drawRect.bottom <= scrollRect.bottom))
                     {
                        return 2;
                     }
                     return 1;
                  }
               }
            }
         }
         return 0;
      }
      
      private function normalizeRects(srcRects:Array, dstRects:Array, largestRise:Number, blockProgression:String, direction:String) : void
      {
         var rect:Rectangle = null;
         var lastRect:Rectangle = null;
         var rectIter:int = 0;
         while(rectIter < srcRects.length)
         {
            rect = srcRects[rectIter++];
            if(blockProgression == BlockProgression.RL)
            {
               if(rect.width < largestRise)
               {
                  rect.width = largestRise;
               }
            }
            else if(rect.height < largestRise)
            {
               rect.height = largestRise;
            }
            if(lastRect == null)
            {
               lastRect = rect;
            }
            else if(blockProgression == BlockProgression.RL)
            {
               if(Boolean(lastRect.y < rect.y) && Boolean(lastRect.y + lastRect.height >= rect.top) && Boolean(lastRect.x == rect.x))
               {
                  lastRect.height = lastRect.height + rect.height;
               }
               else if(Boolean(rect.y < lastRect.y) && Boolean(lastRect.y <= rect.bottom) && Boolean(lastRect.x == rect.x))
               {
                  lastRect.height = lastRect.height + rect.height;
                  lastRect.y = rect.y;
               }
               else
               {
                  dstRects.push(lastRect);
                  lastRect = rect;
               }
            }
            else if(Boolean(lastRect.x < rect.x) && Boolean(lastRect.x + lastRect.width >= rect.left) && Boolean(lastRect.y == rect.y))
            {
               lastRect.width = lastRect.width + rect.width;
            }
            else if(Boolean(rect.x < lastRect.x) && Boolean(lastRect.x <= rect.right) && Boolean(lastRect.y == rect.y))
            {
               lastRect.width = lastRect.width + rect.width;
               lastRect.x = rect.x;
            }
            else
            {
               dstRects.push(lastRect);
               lastRect = rect;
            }
            if(rectIter == srcRects.length)
            {
               dstRects.push(lastRect);
            }
         }
      }
      
      private function adjustEndElementForBidi(begIdx:int, endIdx:int, begElementIndex:int, direction:String) : int
      {
         var endElementIndex:int = begElementIndex;
         var textLine:TextLine = this.getTextLine(true);
         if(endIdx != begIdx)
         {
            if((Boolean(direction == Direction.LTR) && Boolean(textLine.getAtomBidiLevel(begElementIndex) % 2 != 0) || Boolean(direction == Direction.RTL) && Boolean(textLine.getAtomBidiLevel(begElementIndex) % 2 == 0)) && Boolean(textLine.getAtomTextRotation(begElementIndex) != TextRotation.ROTATE_0))
            {
               endElementIndex = textLine.getAtomIndexAtCharIndex(endIdx);
            }
            else
            {
               endElementIndex = textLine.getAtomIndexAtCharIndex(endIdx - 1);
            }
         }
         if(Boolean(endElementIndex == -1) && Boolean(endIdx > 0))
         {
            return this.adjustEndElementForBidi(begIdx,endIdx - 1,begElementIndex,direction);
         }
         return endElementIndex;
      }
      
      private function isAtomBidi(elementIdx:int, direction:String) : Boolean
      {
         var textLine:TextLine = this.getTextLine(true);
         return Boolean(textLine.getAtomBidiLevel(elementIdx) % 2 != 0) && Boolean(direction == Direction.LTR) || Boolean(textLine.getAtomBidiLevel(elementIdx) % 2 == 0) && Boolean(direction == Direction.RTL);
      }
      
      tlf_internal function get adornCount() : int
      {
         return this._adornCount;
      }
   }
}

import flash.geom.Rectangle;

final class SelectionCache
{
    
   private var _begIdx:int = -1;
   
   private var _endIdx:int = -1;
   
   private var _selectionBlocks:Array = null;
   
   function SelectionCache()
   {
      super();
   }
   
   public function get begIdx() : int
   {
      return this._begIdx;
   }
   
   public function set begIdx(val:int) : void
   {
      this._begIdx = val;
   }
   
   public function get endIdx() : int
   {
      return this._endIdx;
   }
   
   public function set endIdx(val:int) : void
   {
      this._endIdx = val;
   }
   
   public function pushSelectionBlock(drawRect:Rectangle) : void
   {
      if(!this._selectionBlocks)
      {
         this._selectionBlocks = new Array();
      }
      this._selectionBlocks.push(drawRect.clone());
   }
   
   public function get selectionBlocks() : Array
   {
      return this._selectionBlocks;
   }
   
   public function clear() : void
   {
      this._selectionBlocks = null;
      this._begIdx = -1;
      this._endIdx = -1;
   }
}
