package flashx.textLayout.compose
{
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.container.ContainerController;
   import flashx.textLayout.formats.BlockProgression;
   import flash.geom.Rectangle;
   import flashx.textLayout.container.ColumnState;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.formats.LineBreak;
   import flashx.textLayout.container.ScrollPolicy;
   import flash.text.engine.TextLine;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class ParcelList implements IParcelList
   {
      
      private static const MAX_HEIGHT:Number = 900000000;
      
      private static const MAX_WIDTH:Number = 900000000;
      
      private static var _sharedParcelList:flashx.textLayout.compose.ParcelList;
       
      protected var _flowComposer:flashx.textLayout.compose.IFlowComposer;
      
      protected var _totalDepth:Number;
      
      protected var _hasContent:Boolean;
      
      private var _parcelArray:Array;
      
      private var _numParcels:int;
      
      private var _singleParcel:flashx.textLayout.compose.Parcel;
      
      protected var _currentParcelIndex:int;
      
      protected var _currentParcel:flashx.textLayout.compose.Parcel;
      
      protected var _notifyOnParcelChange:Function;
      
      private var _columnIndex:int;
      
      private var _columnController:ContainerController;
      
      private var _explicitLineBreaks:Boolean;
      
      protected var _blockProgression:String;
      
      public function ParcelList()
      {
         super();
         this._numParcels = 0;
      }
      
      tlf_internal static function getParcelList() : flashx.textLayout.compose.ParcelList
      {
         var rslt:flashx.textLayout.compose.ParcelList = Boolean(_sharedParcelList)?_sharedParcelList:new flashx.textLayout.compose.ParcelList();
         _sharedParcelList = null;
         return rslt;
      }
      
      tlf_internal static function releaseParcelList(list:IParcelList) : void
      {
         if(_sharedParcelList == null)
         {
            _sharedParcelList = list as ParcelList;
            if(_sharedParcelList)
            {
               _sharedParcelList.releaseAnyReferences();
            }
         }
      }
      
      tlf_internal function releaseAnyReferences() : void
      {
         this._flowComposer = null;
         this._columnController = null;
         this._numParcels = 0;
         this._parcelArray = null;
         if(this._singleParcel)
         {
            this._singleParcel.releaseAnyReferences();
         }
      }
      
      protected function get numParcels() : int
      {
         return this._numParcels;
      }
      
      protected function getParcelAtIndex(idx:int) : flashx.textLayout.compose.Parcel
      {
         return this._numParcels == 1?this._singleParcel:this._parcelArray[idx];
      }
      
      protected function insertParcel(startIdx:int, parcel:flashx.textLayout.compose.Parcel) : void
      {
         if(this._numParcels == 0)
         {
            this._singleParcel = parcel;
         }
         else
         {
            if(this._numParcels == 1)
            {
               this._parcelArray = [this._singleParcel];
            }
            this._parcelArray.splice(startIdx,0,parcel);
         }
         this._numParcels++;
      }
      
      protected function set parcels(newParcels:Array) : void
      {
         this._numParcels = newParcels.length;
         if(this._numParcels == 0)
         {
            this._parcelArray = null;
         }
         else if(this._numParcels == 1)
         {
            this._parcelArray = null;
            this._singleParcel = newParcels[0];
         }
         else
         {
            this._parcelArray = newParcels;
         }
      }
      
      public function get left() : Number
      {
         return this._currentParcel.left;
      }
      
      public function get right() : Number
      {
         return this._currentParcel.right;
      }
      
      public function get top() : Number
      {
         return this._currentParcel.top;
      }
      
      public function get bottom() : Number
      {
         return this._currentParcel.bottom;
      }
      
      public function get width() : Number
      {
         return this._currentParcel.width;
      }
      
      public function get height() : Number
      {
         return this._currentParcel.height;
      }
      
      public function get fitAny() : Boolean
      {
         return this._currentParcel.fitAny;
      }
      
      public function get controller() : ContainerController
      {
         return this._columnController;
      }
      
      public function get columnIndex() : int
      {
         return this._columnIndex;
      }
      
      public function get explicitLineBreaks() : Boolean
      {
         return this._explicitLineBreaks;
      }
      
      private function get measureWidth() : Boolean
      {
         if(this._explicitLineBreaks)
         {
            return true;
         }
         if(!this._currentParcel)
         {
            return false;
         }
         if(this._blockProgression == BlockProgression.TB)
         {
            return this._currentParcel.measureWidth;
         }
         return this._currentParcel.measureHeight;
      }
      
      private function get measureHeight() : Boolean
      {
         if(!this._currentParcel)
         {
            return false;
         }
         if(this._blockProgression == BlockProgression.TB)
         {
            return this._currentParcel.measureHeight;
         }
         return this._currentParcel.measureWidth;
      }
      
      public function get totalDepth() : Number
      {
         return this._totalDepth;
      }
      
      public function get notifyOnParcelChange() : Function
      {
         return this._notifyOnParcelChange;
      }
      
      public function set notifyOnParcelChange(val:Function) : void
      {
         this._notifyOnParcelChange = val;
      }
      
      public function addTotalDepth(value:Number) : Number
      {
         this._hasContent = true;
         this._totalDepth = this._totalDepth + value;
         return this._totalDepth;
      }
      
      protected function reset() : void
      {
         this._totalDepth = 0;
         this._hasContent = false;
         this._columnIndex = 0;
         this._currentParcelIndex = 0;
         if(this._numParcels != 0)
         {
            this._currentParcel = this.getParcelAtIndex(this._currentParcelIndex);
            this._columnController = this._currentParcel.controller;
            this._columnIndex = 0;
         }
         else
         {
            this._currentParcel = null;
            this._columnController = null;
            this._columnIndex = -1;
         }
      }
      
      private function addParcel(column:Rectangle, cont:ContainerController, col:int, colCoverage:int) : void
      {
         var newParcel:flashx.textLayout.compose.Parcel = Boolean(this._numParcels == 0) && Boolean(this._singleParcel)?this._singleParcel.initialize(column.x,column.y,column.width,column.height,cont,col,colCoverage):new flashx.textLayout.compose.Parcel(column.x,column.y,column.width,column.height,cont,col,colCoverage);
         if(this._numParcels == 0)
         {
            this._singleParcel = newParcel;
         }
         else if(this.numParcels == 1)
         {
            this._parcelArray = [this._singleParcel,newParcel];
         }
         else
         {
            this._parcelArray.push(newParcel);
         }
         this._numParcels++;
      }
      
      protected function addOneControllerToParcelList(controllerToInitialize:ContainerController) : void
      {
         var column:Rectangle = null;
         var columnState:ColumnState = controllerToInitialize.columnState;
         for(var columnIndex:int = 0; columnIndex < columnState.columnCount; columnIndex++)
         {
            column = columnState.getColumnAt(columnIndex);
            if(!column.isEmpty())
            {
               this.addParcel(column,controllerToInitialize,columnIndex,Parcel.FULL_COLUMN);
            }
         }
      }
      
      public function beginCompose(composer:flashx.textLayout.compose.IFlowComposer, controllerEndIndex:int, composeToPosition:Boolean) : void
      {
         var idx:int = 0;
         this._flowComposer = composer;
         var rootFormat:ITextLayoutFormat = composer.rootElement.computedFormat;
         this._explicitLineBreaks = rootFormat.lineBreak == LineBreak.EXPLICIT;
         this._blockProgression = rootFormat.blockProgression;
         if(composer.numControllers != 0)
         {
            if(controllerEndIndex < 0)
            {
               controllerEndIndex = composer.numControllers - 1;
            }
            else
            {
               controllerEndIndex = Math.min(controllerEndIndex,composer.numControllers - 1);
            }
            idx = 0;
            do
            {
               this.addOneControllerToParcelList(ContainerController(composer.getControllerAt(idx)));
            }
            while(idx++ != controllerEndIndex);
            
            if(controllerEndIndex == composer.numControllers - 1)
            {
               this.adjustForScroll(ContainerController(ContainerController(composer.getControllerAt(composer.numControllers - 1))),composeToPosition);
            }
         }
         this.reset();
      }
      
      private function adjustForScroll(containerToInitialize:ContainerController, composeToPosition:Boolean) : void
      {
         var p:flashx.textLayout.compose.Parcel = null;
         var verticalPaddingAmount:Number = NaN;
         var horizontalPaddingAmount:Number = NaN;
         if(this._blockProgression != BlockProgression.RL)
         {
            if(containerToInitialize.verticalScrollPolicy != ScrollPolicy.OFF)
            {
               p = this.getParcelAtIndex(this._numParcels - 1);
               if(p)
               {
                  verticalPaddingAmount = containerToInitialize.effectivePaddingBottom + containerToInitialize.effectivePaddingTop;
                  p.bottom = containerToInitialize.verticalScrollPosition + p.height + verticalPaddingAmount;
                  p.fitAny = true;
                  p.composeToPosition = composeToPosition;
               }
            }
         }
         else if(containerToInitialize.horizontalScrollPolicy != ScrollPolicy.OFF)
         {
            p = this.getParcelAtIndex(this._numParcels - 1);
            if(p)
            {
               horizontalPaddingAmount = containerToInitialize.effectivePaddingRight + containerToInitialize.effectivePaddingLeft;
               p.left = containerToInitialize.horizontalScrollPosition - p.width - horizontalPaddingAmount;
               p.fitAny = true;
               p.composeToPosition = composeToPosition;
            }
         }
      }
      
      public function getComposeXCoord(o:Rectangle) : Number
      {
         return this._blockProgression == BlockProgression.RL?Number(o.right):Number(o.left);
      }
      
      public function getComposeYCoord(o:Rectangle) : Number
      {
         return o.top;
      }
      
      public function getComposeWidth(o:Rectangle) : Number
      {
         if(this.measureWidth)
         {
            return TextLine.MAX_LINE_WIDTH;
         }
         return this._blockProgression == BlockProgression.RL?Number(o.height):Number(o.width);
      }
      
      public function getComposeHeight(o:Rectangle) : Number
      {
         if(this.measureHeight)
         {
            return TextLine.MAX_LINE_WIDTH;
         }
         return this._blockProgression == BlockProgression.RL?Number(o.width):Number(o.height);
      }
      
      public function isColumnStart() : Boolean
      {
         return Boolean(!this._hasContent) && Boolean(this._currentParcel.topOfColumn);
      }
      
      public function atLast() : Boolean
      {
         return Boolean(this._numParcels == 0) || Boolean(this._currentParcelIndex == this._numParcels - 1);
      }
      
      public function atEnd() : Boolean
      {
         return Boolean(this._numParcels == 0) || Boolean(this._currentParcelIndex >= this._numParcels);
      }
      
      public function next() : Boolean
      {
         var nextController:ContainerController = null;
         var nextParcelIsValid:Boolean = this._currentParcelIndex + 1 < this._numParcels;
         this._notifyOnParcelChange(!!nextParcelIsValid?this.getParcelAtIndex(this._currentParcelIndex + 1):null);
         this._currentParcelIndex = this._currentParcelIndex + 1;
         this._totalDepth = 0;
         this._hasContent = false;
         if(nextParcelIsValid)
         {
            this._currentParcel = this.getParcelAtIndex(this._currentParcelIndex);
            nextController = this._currentParcel.controller;
            if(nextController == this._columnController)
            {
               this._columnIndex++;
            }
            else
            {
               this._columnIndex = 0;
               this._columnController = nextController;
            }
         }
         else
         {
            this._currentParcel = null;
            this._columnIndex = -1;
            this._columnController = null;
         }
         return nextParcelIsValid;
      }
      
      public function createParcel(parcel:Rectangle, blockProgression:String, verticalJump:Boolean) : Boolean
      {
         return false;
      }
      
      public function createParcelExperimental(parcel:Rectangle, wrapType:String) : Boolean
      {
         return false;
      }
      
      public function get currentParcel() : flashx.textLayout.compose.Parcel
      {
         return this._currentParcel;
      }
      
      public function getLineSlug(slugRect:Rectangle, height:Number, minWidth:Number = 0) : Boolean
      {
         var tileWidth:Number = NaN;
         if(this._currentParcelIndex < this._numParcels)
         {
            tileWidth = this.getComposeWidth(this._currentParcel);
            if(tileWidth > minWidth)
            {
               if(Boolean(this.currentParcel.composeToPosition) || Boolean(this._totalDepth + (!!this._currentParcel.fitAny?1:int(height)) <= this.getComposeHeight(this._currentParcel)))
               {
                  if(this._blockProgression != BlockProgression.RL)
                  {
                     slugRect.x = this.left;
                     slugRect.y = this._currentParcel.top + this._totalDepth;
                     slugRect.width = tileWidth;
                     slugRect.height = height;
                  }
                  else
                  {
                     slugRect.x = this.left;
                     slugRect.y = this._currentParcel.top;
                     slugRect.width = this._currentParcel.width - this._totalDepth;
                     slugRect.height = tileWidth;
                  }
                  return true;
               }
            }
         }
         return false;
      }
   }
}
