package flashx.textLayout.compose
{
   import flash.geom.Rectangle;
   import flashx.textLayout.container.ContainerController;
   import flashx.textLayout.tlf_internal;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class Parcel extends Rectangle
   {
      
      public static const TOP_OF_COLUMN:int = 1;
      
      public static const BOT_OF_COLUMN:int = 2;
      
      public static const FULL_COLUMN:int = 3;
       
      private var _controller:ContainerController;
      
      private var _columnCoverage:int;
      
      private var _column:int;
      
      private var _fitAny:Boolean;
      
      private var _composeToPosition:Boolean;
      
      public function Parcel(x:Number, y:Number, width:Number, height:Number, cont:ContainerController, col:int, colCoverage:int)
      {
         super(x,y,width,height);
         this._controller = cont;
         this._column = col;
         this._columnCoverage = colCoverage;
         this._fitAny = false;
         this._composeToPosition = false;
      }
      
      public function initialize(x:Number, y:Number, width:Number, height:Number, cont:ContainerController, col:int, colCoverage:int) : Parcel
      {
         this.x = x;
         this.y = y;
         this.width = width;
         this.height = height;
         this._controller = cont;
         this._column = col;
         this._columnCoverage = colCoverage;
         this._fitAny = false;
         this._composeToPosition = false;
         return this;
      }
      
      tlf_internal function releaseAnyReferences() : void
      {
         this._controller = null;
      }
      
      public function replaceBounds(r:Rectangle) : void
      {
         this.x = r.x;
         this.y = r.y;
         this.width = r.width;
         this.height = r.height;
      }
      
      public function get controller() : ContainerController
      {
         return this._controller;
      }
      
      public function get topOfColumn() : Boolean
      {
         return (this._columnCoverage & TOP_OF_COLUMN) == TOP_OF_COLUMN;
      }
      
      public function get columnCoverage() : int
      {
         return this._columnCoverage;
      }
      
      public function set columnCoverage(val:int) : void
      {
         this._columnCoverage = val;
      }
      
      public function get column() : int
      {
         return this._column;
      }
      
      public function get fitAny() : Boolean
      {
         return this._fitAny;
      }
      
      public function set fitAny(value:Boolean) : void
      {
         this._fitAny = value;
      }
      
      public function get composeToPosition() : Boolean
      {
         return this._composeToPosition;
      }
      
      public function set composeToPosition(value:Boolean) : void
      {
         this._composeToPosition = value;
      }
      
      public function get measureWidth() : Boolean
      {
         return this.controller.measureWidth;
      }
      
      public function get measureHeight() : Boolean
      {
         return this.controller.measureHeight;
      }
   }
}
