package flashx.textLayout.compose
{
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.formats.VerticalAlign;
   import flashx.textLayout.elements.FlowGroupElement;
   import flashx.textLayout.container.ContainerController;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.elements.FlowLeafElement;
   import flash.text.engine.TextLine;
   import flashx.textLayout.formats.BlockProgression;
   import flashx.textLayout.formats.Direction;
   import flashx.textLayout.elements.ParagraphElement;
   import flash.geom.Rectangle;
   import flash.text.engine.TextBlock;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class ComposeState extends BaseCompose
   {
      
      private static var _sharedComposeState:flashx.textLayout.compose.ComposeState;
       
      protected var _curLineIndex:int;
      
      protected var vjBeginLineIndex:int;
      
      protected var vjDisableThisParcel:Boolean;
      
      public function ComposeState()
      {
         super();
      }
      
      tlf_internal static function getComposeState() : flashx.textLayout.compose.ComposeState
      {
         var rslt:flashx.textLayout.compose.ComposeState = Boolean(_sharedComposeState)?_sharedComposeState:new flashx.textLayout.compose.ComposeState();
         _sharedComposeState = null;
         return rslt;
      }
      
      tlf_internal static function releaseComposeState(state:flashx.textLayout.compose.ComposeState) : void
      {
         if(_sharedComposeState == null)
         {
            _sharedComposeState = state;
            if(_sharedComposeState)
            {
               _sharedComposeState.releaseAnyReferences();
            }
         }
      }
      
      override protected function createParcelList() : IParcelList
      {
         return ParcelList.getParcelList();
      }
      
      override protected function releaseParcelList(list:IParcelList) : void
      {
         ParcelList.releaseParcelList(list);
      }
      
      override public function composeTextFlow(textFlow:TextFlow, composeToPosition:int, controllerEndIndex:int) : int
      {
         this._curLineIndex = 0;
         this.vjBeginLineIndex = 0;
         this.vjDisableThisParcel = false;
         return super.composeTextFlow(textFlow,composeToPosition,controllerEndIndex);
      }
      
      override protected function initializeForComposer(composer:IFlowComposer, composeToPosition:int, controllerEndIndex:int) : void
      {
         super.initializeForComposer(composer,composeToPosition,controllerEndIndex);
         _startComposePosition = composer.damageAbsoluteStart;
         var controllerIndex:int = composer.findControllerIndexAtPosition(_startComposePosition);
         if(controllerIndex == -1)
         {
            controllerIndex = composer.numControllers - 1;
            while(Boolean(controllerIndex != 0) && Boolean(composer.getControllerAt(controllerIndex).textLength == 0))
            {
               controllerIndex--;
            }
         }
         _startController = composer.getControllerAt(controllerIndex);
         if(_startController.computedFormat.verticalAlign != VerticalAlign.TOP)
         {
            _startComposePosition = _startController.absoluteStart;
         }
      }
      
      override protected function composeInternal(composeRoot:FlowGroupElement, absStart:int) : void
      {
         super.composeInternal(composeRoot,absStart);
         if(_curElement)
         {
            while(this._curLineIndex < _flowComposer.numLines)
            {
               _flowComposer.getLineAt(this._curLineIndex++).setController(null,-1);
            }
         }
      }
      
      override protected function doVerticalAlignment(canVerticalAlign:Boolean, nextParcel:Parcel) : Boolean
      {
         var controller:ContainerController = null;
         var vjtype:String = null;
         var end:int = 0;
         var result:Boolean = false;
         if(Boolean(canVerticalAlign && _curParcel && this.vjBeginLineIndex != this._curLineIndex) && Boolean(!this.vjDisableThisParcel) && Boolean(_curParcel.columnCoverage == Parcel.FULL_COLUMN))
         {
            controller = _curParcel.controller;
            vjtype = controller.computedFormat.verticalAlign;
            if(vjtype != VerticalAlign.TOP)
            {
               end = _flowComposer.findLineIndexAtPosition(_curElementStart + _curElementOffset);
               if(this.vjBeginLineIndex < end)
               {
                  applyVerticalAlignmentToColumn(controller,vjtype,_flowComposer.lines,this.vjBeginLineIndex,end - this.vjBeginLineIndex);
                  result = true;
               }
            }
         }
         this.vjDisableThisParcel = false;
         this.vjBeginLineIndex = this._curLineIndex;
         return result;
      }
      
      override protected function finalParcelAdjustment(controller:ContainerController) : void
      {
         var line:TextFlowLine = null;
         var edgeAdjust:Number = NaN;
         var curParaFormat:ITextLayoutFormat = null;
         var leafElement:FlowLeafElement = null;
         var adjustedAscent:Number = NaN;
         var minX:Number = TextLine.MAX_LINE_WIDTH;
         var minY:Number = TextLine.MAX_LINE_WIDTH;
         var maxX:Number = -TextLine.MAX_LINE_WIDTH;
         var maxY:Number = -TextLine.MAX_LINE_WIDTH;
         var verticalText:Boolean = _blockProgression == BlockProgression.RL;
         var lineIndex:int = _flowComposer.findLineIndexAtPosition(controller.absoluteStart);
         while(lineIndex < this._curLineIndex)
         {
            line = _flowComposer.getLineAt(lineIndex);
            if(verticalText)
            {
               maxX = Math.max(line.x + line.ascent,maxX);
               minX = Math.min(line.x,minX);
            }
            else
            {
               minY = Math.min(line.y,minY);
            }
            if(line.hasGraphicElement)
            {
               leafElement = _textFlow.findLeaf(line.absoluteStart);
               adjustedAscent = line.getLineTypographicAscent(leafElement,leafElement.getAbsoluteStart());
               if(!verticalText)
               {
                  minY = Math.min(line.y + line.ascent - adjustedAscent,minY);
               }
               else
               {
                  maxX = Math.max(line.x + adjustedAscent,maxX);
               }
            }
            curParaFormat = line.paragraph.computedFormat;
            if(curParaFormat.direction == Direction.LTR)
            {
               edgeAdjust = Math.max(line.lineOffset,0);
            }
            else
            {
               edgeAdjust = curParaFormat.paragraphEndIndent;
            }
            if(verticalText)
            {
               minY = Math.min(line.y - edgeAdjust,minY);
            }
            else
            {
               minX = Math.min(line.x - edgeAdjust,minX);
            }
            lineIndex++;
         }
         if(_blockProgression == BlockProgression.RL)
         {
            minX = minX - _lastLineDescent;
         }
         if(Boolean(minX != TextLine.MAX_LINE_WIDTH) && Boolean(Math.abs(minX - _parcelLeft) >= 1))
         {
            _parcelLeft = minX;
         }
         if(Boolean(maxX != -TextLine.MAX_LINE_WIDTH) && Boolean(Math.abs(maxX - _parcelRight) >= 1))
         {
            _parcelRight = maxX;
         }
         if(Boolean(minY != TextLine.MAX_LINE_WIDTH) && Boolean(Math.abs(minY - _parcelTop) >= 1))
         {
            _parcelTop = minY;
         }
         if(Boolean(maxY != -TextLine.MAX_LINE_WIDTH) && Boolean(Math.abs(maxY - _parcelBottom) >= 1))
         {
            _parcelBottom = maxY;
         }
      }
      
      private function finalizeLine(useExistingLine:Boolean, curLine:TextFlowLine) : void
      {
         if(!useExistingLine)
         {
            _flowComposer.addLine(curLine,this._curLineIndex);
         }
         this._curLineIndex++;
         commitLastLineState(curLine);
      }
      
      override protected function composeParagraphElement(elem:ParagraphElement, absStart:int) : Boolean
      {
         _curParaElement = elem;
         _curParaStart = absStart;
         _curParaFormat = elem.computedFormat;
         if(_startComposePosition == 0)
         {
            _curElement = elem.getFirstLeaf();
            _curElementStart = _curParaStart;
         }
         else
         {
            _curElement = elem.findLeaf(_startComposePosition - absStart);
            _curElementStart = _curElement.getAbsoluteStart();
            _curElementOffset = _startComposePosition - _curElementStart;
            this._curLineIndex = _flowComposer.findLineIndexAtPosition(_curElementStart + _curElementOffset);
            _startComposePosition = 0;
         }
         return composeParagraphElementIntoLines();
      }
      
      override protected function composeNextLine() : TextFlowLine
      {
         var prevLine:TextFlowLine = null;
         var line:TextFlowLine = this._curLineIndex < _flowComposer.numLines?_flowComposer.lines[this._curLineIndex]:null;
         var useExistingLine:Boolean = Boolean(line) && (Boolean(!line.isDamaged()) || Boolean(line.validity == FlowDamageType.GEOMETRY));
         var curLine:TextFlowLine = !!useExistingLine?line:null;
         var startCompose:int = _curElementStart + _curElementOffset - _curParaStart;
         if(startCompose != 0)
         {
            prevLine = _flowComposer.lines[this._curLineIndex - 1];
            if(prevLine.absoluteStart < _curParaStart)
            {
               prevLine = null;
            }
         }
         var finishLineSlug:Rectangle = _parcelList.currentParcel;
         while(true)
         {
            if(true)
            {
               while(!curLine)
               {
                  useExistingLine = false;
                  curLine = this.createTextLine(prevLine,startCompose,_parcelList.getComposeXCoord(finishLineSlug),_parcelList.getComposeYCoord(finishLineSlug),_parcelList.getComposeWidth(finishLineSlug));
                  if(curLine != null)
                  {
                     break;
                  }
                  if(!_parcelList.next())
                  {
                     return null;
                  }
               }
               curLine = fitLineToParcel(curLine,!useExistingLine);
               if(!Boolean(curLine))
               {
                  if(_parcelList.atEnd())
                  {
                     break;
                  }
                  finishLineSlug = _lineSlug;
                  continue;
               }
            }
            if(curLine.validity == FlowDamageType.GEOMETRY)
            {
               curLine.clearDamage();
            }
            this.finalizeLine(useExistingLine,curLine);
            return curLine;
         }
         return null;
      }
      
      protected function createTextLine(prevLine:TextFlowLine, lineStart:int, x:Number, y:Number, targetWidth:Number) : TextFlowLine
      {
         var lineOffset:Number = Number(_curParaFormat.paragraphStartIndent);
         if(prevLine == null)
         {
            lineOffset = lineOffset + Number(_curParaFormat.textIndent);
         }
         var outerTargetWidth:Number = targetWidth;
         targetWidth = targetWidth - (Number(_curParaFormat.paragraphEndIndent) + lineOffset);
         if(targetWidth < 0)
         {
            targetWidth = 0;
         }
         else if(targetWidth > TextLine.MAX_LINE_WIDTH)
         {
            targetWidth = TextLine.MAX_LINE_WIDTH;
         }
         var textLine:TextLine = TextLineRecycler.getLineForReuse();
         var textBlock:TextBlock = _curParaElement.getTextBlock();
         if(textLine)
         {
            textLine = swfContext.callInContext(textBlock["recreateTextLine"],textBlock,[textLine,Boolean(prevLine)?prevLine.getTextLine(true):null,targetWidth,lineOffset,true]);
         }
         else
         {
            textLine = swfContext.callInContext(textBlock.createTextLine,textBlock,[Boolean(prevLine)?prevLine.getTextLine(true):null,targetWidth,lineOffset,true]);
         }
         if(textLine == null)
         {
            return null;
         }
         var line:TextFlowLine = new TextFlowLine(textLine,_curParaElement,outerTargetWidth,lineOffset,lineStart + _curParaStart,textLine.rawTextLength);
         textLine.doubleClickEnabled = true;
         return line;
      }
   }
}
