package flashx.textLayout.compose
{
   import flash.geom.Rectangle;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.elements.ParagraphElement;
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.elements.ContainerFormattedElement;
   import flashx.textLayout.container.ContainerController;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.elements.FlowGroupElement;
   import flashx.textLayout.elements.FlowElement;
   import flashx.textLayout.formats.FlowElementDisplayType;
   import flashx.textLayout.elements.Configuration;
   import flashx.textLayout.formats.BlockProgression;
   import flashx.textLayout.formats.TextAlign;
   import flash.text.engine.TextLine;
   import flashx.textLayout.formats.Direction;
   import flashx.textLayout.elements.OverflowPolicy;
   import flashx.textLayout.formats.BaselineOffset;
   import flashx.textLayout.formats.VerticalAlign;
   import flashx.textLayout.utils.LocaleUtil;
   import flashx.textLayout.formats.LeadingModel;
   import flash.text.engine.TextBaseline;
   import flashx.textLayout.elements.InlineGraphicElement;
   import flashx.textLayout.elements.TCYElement;
   import flashx.textLayout.formats.FormatValue;
   import flashx.textLayout.formats.TextLayoutFormat;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class BaseCompose
   {
      
      protected static var _candidateLineSlug:Rectangle = new Rectangle();
      
      protected static var _lineSlug:Rectangle = new Rectangle();
      
      private static var _alignLines:Array;
       
      protected var _parcelList:flashx.textLayout.compose.IParcelList;
      
      protected var _curElement:FlowLeafElement;
      
      protected var _curElementStart:int;
      
      protected var _curElementOffset:int;
      
      protected var _curParaElement:ParagraphElement;
      
      protected var _curParaFormat:ITextLayoutFormat;
      
      protected var _curParaStart:int;
      
      private var _curLineLeadingModel:String = "";
      
      private var _curLineLeading:Number;
      
      protected var _lastLineLeadingModel:String = "";
      
      protected var _lastLineLeading:Number;
      
      protected var _lastLineDescent:Number;
      
      protected var _spaceCarried:Number;
      
      protected var _blockProgression:String;
      
      private var _controllerLeft:Number;
      
      private var _controllerTop:Number;
      
      private var _controllerRight:Number;
      
      private var _controllerBottom:Number;
      
      protected var _contentLogicalExtent:Number;
      
      protected var _contentCommittedExtent:Number;
      
      protected var _parcelLeft:Number;
      
      protected var _parcelTop:Number;
      
      protected var _parcelRight:Number;
      
      protected var _parcelBottom:Number;
      
      protected var _textFlow:TextFlow;
      
      private var _releaseLineCreationData:Boolean;
      
      protected var _flowComposer:flashx.textLayout.compose.StandardFlowComposer;
      
      protected var _rootElement:ContainerFormattedElement;
      
      protected var _stopComposePos:int;
      
      protected var _startController:ContainerController;
      
      protected var _startComposePosition:int;
      
      protected var _curParcel:flashx.textLayout.compose.Parcel;
      
      protected var _curParcelStart:int;
      
      public function BaseCompose()
      {
         super();
      }
      
      public static function get globalSWFContext() : ISWFContext
      {
         return GlobalSWFContext.globalSWFContext;
      }
      
      private static function doNothingOnParcelChange(newParcel:flashx.textLayout.compose.Parcel) : void
      {
      }
      
      public function get parcelList() : flashx.textLayout.compose.IParcelList
      {
         return this._parcelList;
      }
      
      protected function createParcelList() : flashx.textLayout.compose.IParcelList
      {
         return null;
      }
      
      protected function releaseParcelList(list:flashx.textLayout.compose.IParcelList) : void
      {
      }
      
      public function get startController() : ContainerController
      {
         return this._startController;
      }
      
      tlf_internal function releaseAnyReferences() : void
      {
         this._curElement = null;
         this._curParaElement = null;
         this._curParaFormat = null;
         this._flowComposer = null;
         this._parcelList = null;
         this._rootElement = null;
         this._startController = null;
         this._textFlow = null;
      }
      
      protected function initializeForComposer(composer:IFlowComposer, composeToPosition:int, controllerEndIndex:int) : void
      {
         this._parcelList = this.createParcelList();
         this._parcelList.notifyOnParcelChange = this.parcelHasChanged;
         this._spaceCarried = 0;
         this._blockProgression = composer.rootElement.computedFormat.blockProgression;
         this._stopComposePos = composeToPosition >= 0?int(Math.min(this._textFlow.textLength,composeToPosition)):int(this._textFlow.textLength);
         this._parcelList.beginCompose(composer,controllerEndIndex,composeToPosition > 0);
         this._contentLogicalExtent = 0;
         this._contentCommittedExtent = 0;
      }
      
      protected function composeFloat(elem:ContainerFormattedElement, composeFrame:ContainerController) : void
      {
      }
      
      protected function startLine() : void
      {
      }
      
      protected function endLine() : void
      {
      }
      
      private function composeBlockElement(elem:FlowGroupElement, absStart:int) : Boolean
      {
         var idx:int = 0;
         var child:FlowElement = null;
         var para:ParagraphElement = null;
         var rslt:Boolean = false;
         if(this._startComposePosition != 0)
         {
            idx = elem.findChildIndexAtPosition(this._startComposePosition - absStart);
            absStart = absStart + elem.getChildAt(idx).parentRelativeStart;
         }
         else
         {
            idx = 0;
         }
         while(Boolean(idx < elem.numChildren) && (Boolean(absStart <= this._stopComposePos) || Boolean(!this.parcelList.atLast())))
         {
            child = elem.getChildAt(idx);
            para = child as ParagraphElement;
            if(para)
            {
               rslt = this.composeParagraphElement(para,absStart);
               if(this.releaseLineCreationData)
               {
                  para.releaseLineCreationData();
               }
               if(!rslt)
               {
                  return false;
               }
            }
            else if(child.display == FlowElementDisplayType.FLOAT)
            {
               this.composeFloat(ContainerFormattedElement(child),this._parcelList.controller);
               if(this._parcelList.atEnd())
               {
                  return false;
               }
            }
            else if(!this.composeBlockElement(FlowGroupElement(child),absStart))
            {
               return false;
            }
            absStart = absStart + child.textLength;
            idx++;
         }
         return true;
      }
      
      public function composeTextFlow(textFlow:TextFlow, composeToPosition:int, controllerEndIndex:int) : int
      {
         var cacheNotify:Function = null;
         var previousElement:FlowLeafElement = null;
         var startLineIndex:int = 0;
         var startLine:TextFlowLine = null;
         var startParcel:int = 0;
         var parcelIndex:int = 0;
         var lineIndex:int = 0;
         var line:TextFlowLine = null;
         var lineExtent:Number = NaN;
         var alignData:AlignData = null;
         var paraFormat:ITextLayoutFormat = null;
         this._textFlow = textFlow;
         this._releaseLineCreationData = Boolean(textFlow.configuration.releaseLineCreationData) && Boolean(Configuration.playerEnablesArgoFeatures);
         this._flowComposer = this._textFlow.flowComposer as StandardFlowComposer;
         this._rootElement = textFlow;
         this._curElementOffset = 0;
         this._curElement = this._rootElement.getFirstLeaf();
         this._curElementStart = 0;
         this._curParcel = null;
         this.initializeForComposer(this._flowComposer,composeToPosition,controllerEndIndex);
         this.resetControllerBounds();
         if(this._startController != this._flowComposer.getControllerAt(0))
         {
            cacheNotify = this._parcelList.notifyOnParcelChange;
            this._parcelList.notifyOnParcelChange = doNothingOnParcelChange;
            while(this._parcelList.currentParcel.controller != this._startController)
            {
               this._parcelList.next();
            }
            this._parcelList.notifyOnParcelChange = cacheNotify;
         }
         if(this._startComposePosition > 0)
         {
            previousElement = this._textFlow.findLeaf(this._startComposePosition - 1);
            this._curElement = previousElement;
            this._curElementStart = previousElement.getAbsoluteStart();
            this._curElementOffset = this._startComposePosition - this._curElementStart;
            this._curLineLeadingModel = previousElement.getParagraph().getEffectiveLeadingModel();
            startLineIndex = this._flowComposer.findLineIndexAtPosition(this._startComposePosition - 1);
            startLine = this._flowComposer.getLineAt(startLineIndex);
            this._spaceCarried = startLine.spaceAfter;
            this.commitLastLineState(startLine);
            startParcel = startLine.columnIndex;
            parcelIndex = 0;
            while(Boolean(this._parcelList.currentParcel) && Boolean(this._parcelList.columnIndex < startParcel))
            {
               this._parcelList.next();
               parcelIndex++;
            }
            if(this._blockProgression == BlockProgression.TB)
            {
               this._parcelList.addTotalDepth(startLine.y + startLine.ascent - this._parcelList.top);
            }
            else
            {
               this._parcelList.addTotalDepth(this._parcelList.right - startLine.x);
            }
            lineIndex = this._flowComposer.findLineIndexAtPosition(this._startController.absoluteStart);
            for(startLineIndex = this._flowComposer.findLineIndexAtPosition(this._startComposePosition); lineIndex < startLineIndex; )
            {
               line = this._flowComposer.getLineAt(lineIndex);
               lineExtent = line.lineExtent;
               this._contentLogicalExtent = Math.max(this._contentLogicalExtent,lineExtent);
               if(Boolean(!line.alignment) || Boolean(!this.startController.measureWidth))
               {
                  this._contentCommittedExtent = Math.max(this._contentCommittedExtent,lineExtent);
               }
               else
               {
                  alignData = new AlignData();
                  alignData.textLine = line.getTextLine();
                  alignData.center = line.alignment == TextAlign.CENTER;
                  paraFormat = line.paragraph.computedFormat;
                  alignData.rightSideGap = this.getRightSideGap(line,paraFormat,line.alignment != null);
                  alignData.leftSideGap = this.getLeftSideGap(line,paraFormat);
                  alignData.lineWidth = line.lineExtent - (alignData.rightSideGap + alignData.leftSideGap);
                  if(!_alignLines)
                  {
                     _alignLines = [];
                  }
                  _alignLines.push(alignData);
               }
               lineIndex++;
            }
         }
         this.parcelHasChanged(this._parcelList.currentParcel);
         for(this.composeInternal(this._rootElement,0); true; )
         {
            if(this.parcelList.atEnd())
            {
               this.parcelHasChanged(null);
               break;
            }
            this.parcelList.next();
         }
         this.releaseParcelList(this._parcelList);
         this._parcelList = null;
         return this._curElementStart + this._curElementOffset;
      }
      
      private function resetControllerBounds() : void
      {
         this._controllerLeft = TextLine.MAX_LINE_WIDTH;
         this._controllerTop = TextLine.MAX_LINE_WIDTH;
         this._controllerRight = -TextLine.MAX_LINE_WIDTH;
         this._controllerBottom = -TextLine.MAX_LINE_WIDTH;
      }
      
      protected function get releaseLineCreationData() : Boolean
      {
         return this._releaseLineCreationData;
      }
      
      protected function composeInternal(composeRoot:FlowGroupElement, absStart:int) : void
      {
         this.composeBlockElement(composeRoot,absStart);
      }
      
      protected function composeParagraphElement(elem:ParagraphElement, absStart:int) : Boolean
      {
         return false;
      }
      
      protected function composeParagraphElementIntoLines() : Boolean
      {
         var curLine:TextFlowLine = null;
         var alignData:AlignData = null;
         while(true)
         {
            if(true)
            {
               if(this._parcelList.atEnd())
               {
                  break;
               }
               this.startLine();
               curLine = this.composeNextLine();
               if(curLine == null)
               {
                  return false;
               }
               alignData = this.calculateTextAlign(curLine,curLine.getTextLine());
               if((Boolean(curLine.spaceBefore != 0) || Boolean(this._spaceCarried != 0)) && Boolean(!this._parcelList.isColumnStart()))
               {
                  this._parcelList.addTotalDepth(Math.max(curLine.spaceBefore,this._spaceCarried));
               }
               this._spaceCarried = 0;
               this._parcelList.addTotalDepth(curLine.height);
               this._curElementOffset = this._curElementOffset + curLine.textLength;
               this.calculateLineAlignmentAndBounds(curLine,alignData);
               if(this._parcelList.atEnd())
               {
                  return false;
               }
               this.endLine();
               if(this._curElementOffset >= this._curElement.textLength)
               {
                  do
                  {
                     this._curElementOffset = this._curElementOffset - this._curElement.textLength;
                     this._curElementStart = this._curElementStart + this._curElement.textLength;
                     if(this._curElementStart == this._curParaStart + this._curParaElement.textLength)
                     {
                        this._curElement = null;
                        break;
                     }
                     this._curElement = this._curElement.getNextLeaf();
                  }
                  while(Boolean(this._curElementOffset >= this._curElement.textLength) || Boolean(this._curElement.textLength == 0));
                  
               }
               this._spaceCarried = curLine.spaceAfter;
               if(this._curElement != null)
               {
                  continue;
               }
            }
            return true;
         }
         return false;
      }
      
      private function calculateLineWidthExplicit(curLine:TextFlowLine) : Number
      {
         var isRTL:Boolean = this._curParaElement.computedFormat.direction == Direction.RTL;
         var textLine:TextLine = curLine.getTextLine(true);
         var lastAtom:int = textLine.atomCount - 1;
         var endOfParagraph:Boolean = this._curElementStart + this._curElementOffset == this._curParaStart + this._curParaElement.textLength;
         if(Boolean(endOfParagraph) && Boolean(!isRTL))
         {
            lastAtom--;
         }
         var bounds:Rectangle = textLine.getAtomBounds(lastAtom >= 0?int(lastAtom):int(0));
         var lineWidth:Number = this._blockProgression == BlockProgression.TB?lastAtom >= 0?Number(bounds.right):Number(bounds.left):lastAtom >= 0?Number(bounds.bottom):Number(bounds.top);
         if(isRTL)
         {
            bounds = textLine.getAtomBounds(Boolean(lastAtom != 0) && Boolean(endOfParagraph)?int(1):int(0));
            lineWidth = lineWidth - (this._blockProgression == BlockProgression.TB?bounds.left:bounds.top);
         }
         textLine.flushAtomData();
         return lineWidth;
      }
      
      private function getRightSideGap(curLine:TextFlowLine, paraFormat:ITextLayoutFormat, aligned:Boolean) : Number
      {
         var rightSideGap:Number = paraFormat.direction == Direction.LTR?Number(paraFormat.paragraphEndIndent):Number(paraFormat.paragraphStartIndent);
         if(Boolean(paraFormat.direction == Direction.RTL) && Boolean(curLine.location & TextFlowLineLocation.FIRST))
         {
            if(Boolean(aligned) && (Boolean(this._blockProgression == BlockProgression.TB) && Boolean(!curLine.controller.measureWidth) || Boolean(this._blockProgression == BlockProgression.RL) && Boolean(!curLine.controller.measureHeight)))
            {
               rightSideGap = rightSideGap + paraFormat.textIndent;
            }
         }
         return rightSideGap;
      }
      
      private function getLeftSideGap(curLine:TextFlowLine, paraFormat:ITextLayoutFormat) : Number
      {
         var leftSideGap:Number = paraFormat.direction == Direction.LTR?Number(paraFormat.paragraphStartIndent):Number(paraFormat.paragraphEndIndent);
         if(Boolean(paraFormat.direction == Direction.LTR) && Boolean(curLine.location & TextFlowLineLocation.FIRST))
         {
            leftSideGap = leftSideGap + paraFormat.textIndent;
         }
         return leftSideGap;
      }
      
      private function calculateLineAlignmentAndBounds(curLine:TextFlowLine, alignData:AlignData) : void
      {
         var textLine:TextLine = curLine.getTextLine();
         var lineWidth:Number = !!this._parcelList.explicitLineBreaks?Number(this.calculateLineWidthExplicit(curLine)):Number(textLine.textWidth);
         var rightSideGap:Number = this.getRightSideGap(curLine,this._curParaFormat,alignData != null);
         var leftSideGap:Number = this.getLeftSideGap(curLine,this._curParaFormat);
         if(alignData)
         {
            alignData.rightSideGap = rightSideGap;
            alignData.leftSideGap = leftSideGap;
            alignData.lineWidth = lineWidth;
         }
         var lineExtent:Number = lineWidth + leftSideGap + rightSideGap;
         curLine.lineExtent = lineExtent;
         this._contentLogicalExtent = Math.max(this._contentLogicalExtent,lineExtent);
         if(!alignData)
         {
            this._contentCommittedExtent = Math.max(this._contentCommittedExtent,lineExtent);
         }
      }
      
      protected function composeNextLine() : TextFlowLine
      {
         return null;
      }
      
      protected function fitLineToParcel(curLine:TextFlowLine, isNewLine:Boolean) : TextFlowLine
      {
         for(var spaceBefore:Number = NaN; true; )
         {
            if(this._parcelList.getLineSlug(_candidateLineSlug,0))
            {
               break;
            }
            this._parcelList.next();
            if(this._parcelList.atEnd())
            {
               return null;
            }
            this._spaceCarried = 0;
         }
         curLine.setController(this._parcelList.controller,this._parcelList.columnIndex);
         loop1:
         for(spaceBefore = Math.max(curLine.spaceBefore,this._spaceCarried); true; )
         {
            this.finishComposeLine(curLine,_candidateLineSlug,isNewLine);
            if(this._parcelList.getLineSlug(_lineSlug,spaceBefore + (Boolean(this._parcelList.atLast()) && Boolean(this._textFlow.configuration.overflowPolicy != OverflowPolicy.FIT_DESCENDERS)?curLine.height - curLine.ascent:curLine.height + curLine.descent)))
            {
               break;
            }
            spaceBefore = curLine.spaceBefore;
            while(true)
            {
               if(true)
               {
                  this._parcelList.next();
                  if(this._parcelList.atEnd())
                  {
                     break;
                  }
                  if(!this._parcelList.getLineSlug(_candidateLineSlug,0))
                  {
                     continue;
                  }
               }
               curLine.setController(this._parcelList.controller,this._parcelList.columnIndex);
               continue loop1;
            }
            return null;
         }
         return this._parcelList.getComposeWidth(_lineSlug) == curLine.outerTargetWidth?curLine:null;
      }
      
      protected function finishComposeLine(curLine:TextFlowLine, lineSlug:Rectangle, isNewLine:Boolean) : void
      {
         var firstBaselineOffsetBasis:String = null;
         var firstLineAdjustment:LeadingAdjustment = null;
         var spaceAdjust:Number = NaN;
         var curLeadingDirectionUp:Boolean = false;
         var prevLeadingDirectionUp:Boolean = false;
         var prevLineFirstElement:FlowLeafElement = null;
         var adjustment:LeadingAdjustment = null;
         var curTextLine:TextLine = curLine.getTextLine();
         var lineHeight:Number = 0;
         var rise:Number = this._blockProgression != BlockProgression.RL?Number(this.parcelList.getComposeYCoord(lineSlug)):Number(this._parcelList.getComposeXCoord(lineSlug));
         var run:Number = this._blockProgression != BlockProgression.RL?Number(this.parcelList.getComposeXCoord(lineSlug)):Number(this._parcelList.getComposeYCoord(lineSlug));
         if(this._curParaFormat.direction == Direction.LTR)
         {
            run = run + curLine.lineOffset;
         }
         else
         {
            run = run + (curLine.outerTargetWidth - curLine.lineOffset - curLine.targetWidth);
            if(Boolean(curLine.outerTargetWidth == TextLine.MAX_LINE_WIDTH) && Boolean(curLine.location & TextFlowLineLocation.FIRST))
            {
               run = run + curLine.paragraph.computedFormat.textIndent;
            }
         }
         this._curLineLeading = curLine.getLineLeading(this._blockProgression,this._curElement,this._curElementStart);
         this._curLineLeadingModel = this._curParaElement.getEffectiveLeadingModel();
         var containerAttrs:ITextLayoutFormat = this._parcelList.controller.computedFormat;
         var baselineType:Object = BaselineOffset.LINE_HEIGHT;
         if(this._parcelList.isColumnStart())
         {
            if(Boolean(containerAttrs.firstBaselineOffset != BaselineOffset.AUTO) && Boolean(containerAttrs.verticalAlign != VerticalAlign.BOTTOM) && Boolean(containerAttrs.verticalAlign != VerticalAlign.MIDDLE))
            {
               baselineType = containerAttrs.firstBaselineOffset;
               firstBaselineOffsetBasis = LocaleUtil.leadingModel(containerAttrs.locale) == LeadingModel.IDEOGRAPHIC_TOP_DOWN?TextBaseline.IDEOGRAPHIC_BOTTOM:TextBaseline.ROMAN;
               lineHeight = lineHeight - curTextLine.getBaselinePosition(firstBaselineOffsetBasis);
            }
            else if(this._curLineLeadingModel == LeadingModel.APPROXIMATE_TEXT_FIELD)
            {
               lineHeight = lineHeight + (Math.round(curTextLine.descent) + Math.round(curTextLine.ascent));
               if(this._blockProgression == BlockProgression.TB)
               {
                  lineHeight = Math.round(rise + lineHeight) - rise;
               }
               else
               {
                  lineHeight = rise - Math.round(rise - lineHeight);
               }
               baselineType = 0;
            }
            else
            {
               baselineType = BaselineOffset.ASCENT;
               if(curTextLine.hasGraphicElement)
               {
                  firstLineAdjustment = this.getLineAdjustmentForInline(curLine,this._curLineLeadingModel,true);
                  if(firstLineAdjustment != null)
                  {
                     if(this._blockProgression == BlockProgression.RL)
                     {
                        firstLineAdjustment.rise = -firstLineAdjustment.rise;
                     }
                     this._curLineLeading = this._curLineLeading + firstLineAdjustment.leading;
                     rise = rise + firstLineAdjustment.rise;
                  }
               }
               lineHeight = lineHeight - curTextLine.getBaselinePosition(TextBaseline.ROMAN);
            }
         }
         else if(Boolean(curLine.spaceBefore != 0) || Boolean(this._spaceCarried != 0))
         {
            spaceAdjust = Math.max(curLine.spaceBefore,this._spaceCarried);
            rise = rise + (this._blockProgression == BlockProgression.RL?-spaceAdjust:spaceAdjust);
         }
         if(baselineType == BaselineOffset.ASCENT)
         {
            lineHeight = lineHeight + curLine.getLineTypographicAscent(this._curElement,this._curElementStart);
         }
         else if(baselineType == BaselineOffset.LINE_HEIGHT)
         {
            if(this._curLineLeadingModel == LeadingModel.APPROXIMATE_TEXT_FIELD)
            {
               lineHeight = lineHeight + (Math.round(this._lastLineDescent) + Math.round(curTextLine.ascent) + Math.round(curTextLine.descent) + Math.round(this._curLineLeading));
            }
            else if(this._curLineLeadingModel == LeadingModel.ASCENT_DESCENT_UP)
            {
               lineHeight = lineHeight + (this._lastLineDescent + curTextLine.ascent + this._curLineLeading);
            }
            else
            {
               curLeadingDirectionUp = !!this._parcelList.isColumnStart()?Boolean(true):Boolean(ParagraphElement.useUpLeadingDirection(this._curLineLeadingModel));
               prevLeadingDirectionUp = Boolean(this._parcelList.isColumnStart()) || Boolean(this._lastLineLeadingModel == "")?Boolean(true):Boolean(ParagraphElement.useUpLeadingDirection(this._lastLineLeadingModel));
               if(curLeadingDirectionUp)
               {
                  lineHeight = lineHeight + this._curLineLeading;
               }
               else if(!prevLeadingDirectionUp)
               {
                  lineHeight = lineHeight + this._lastLineLeading;
               }
               else
               {
                  lineHeight = lineHeight + (this._lastLineDescent + curTextLine.ascent);
               }
            }
         }
         else
         {
            lineHeight = lineHeight + Number(baselineType);
         }
         rise = rise + (this._blockProgression == BlockProgression.RL?-lineHeight:lineHeight - curTextLine.ascent);
         if(Boolean(curTextLine.hasGraphicElement) && Boolean(baselineType != BaselineOffset.ASCENT))
         {
            adjustment = this.getLineAdjustmentForInline(curLine,this._curLineLeadingModel,false);
            if(adjustment != null)
            {
               if(this._blockProgression == BlockProgression.RL)
               {
                  adjustment.rise = -adjustment.rise;
               }
               this._curLineLeading = this._curLineLeading + adjustment.leading;
               rise = rise + adjustment.rise;
            }
         }
         if(this._blockProgression == BlockProgression.TB)
         {
            curLine.setXYAndHeight(run,rise,lineHeight);
         }
         else
         {
            curLine.setXYAndHeight(rise,run,lineHeight);
         }
         if(isNewLine)
         {
            curLine.createAdornments(this._blockProgression,this._curElement,this._curElementStart);
         }
      }
      
      private function calculateTextAlign(curLine:TextFlowLine, curTextLine:TextLine) : AlignData
      {
         var location:int = 0;
         var alignData:AlignData = null;
         var textAlignment:String = this._curParaFormat.textAlign;
         if(Boolean(textAlignment == TextAlign.JUSTIFY) && Boolean(this._curParaFormat.textAlignLast != null))
         {
            location = curLine.location;
            if(Boolean(location == TextFlowLineLocation.LAST) || Boolean(location == TextFlowLineLocation.ONLY))
            {
               textAlignment = this._curParaFormat.textAlignLast;
            }
         }
         switch(textAlignment)
         {
            case TextAlign.START:
               textAlignment = this._curParaFormat.direction == Direction.LTR?TextAlign.LEFT:TextAlign.RIGHT;
               break;
            case TextAlign.END:
               textAlignment = this._curParaFormat.direction == Direction.LTR?TextAlign.RIGHT:TextAlign.LEFT;
         }
         var createAlignData:Boolean = Boolean(textAlignment == TextAlign.CENTER) || Boolean(textAlignment == TextAlign.RIGHT);
         if(Configuration.playerEnablesArgoFeatures)
         {
            if(curTextLine["hasTabs"])
            {
               if(this._curParaFormat.direction == Direction.LTR)
               {
                  createAlignData = false;
               }
               else
               {
                  createAlignData = true;
                  textAlignment = TextAlign.RIGHT;
               }
            }
         }
         if(createAlignData)
         {
            alignData = new AlignData();
            alignData.textLine = curTextLine;
            alignData.center = textAlignment == TextAlign.CENTER;
            if(!_alignLines)
            {
               _alignLines = [];
            }
            _alignLines.push(alignData);
            curLine.alignment = textAlignment;
            return alignData;
         }
         return null;
      }
      
      private function applyTextAlign(effectiveParcelWidth:Number) : void
      {
         var textLine:TextLine = null;
         var line:TextFlowLine = null;
         var alignData:AlignData = null;
         var coord:Number = NaN;
         var delta:Number = NaN;
         var adjustedLogicalRight:Number = NaN;
         var extraSpace:Number = NaN;
         var leftSideGap:Number = NaN;
         var rightSideGap:Number = NaN;
         if(this._blockProgression == BlockProgression.TB)
         {
            for each(alignData in _alignLines)
            {
               textLine = alignData.textLine;
               rightSideGap = alignData.rightSideGap;
               leftSideGap = alignData.leftSideGap;
               line = textLine.userData as TextFlowLine;
               extraSpace = effectiveParcelWidth - leftSideGap - rightSideGap - textLine.textWidth;
               delta = leftSideGap + (!!alignData.center?extraSpace / 2:extraSpace);
               coord = this._curParcel.left + delta;
               if(line)
               {
                  line.x = coord;
               }
               textLine.x = coord;
               adjustedLogicalRight = alignData.lineWidth + coord + Math.max(rightSideGap,0);
               this._parcelRight = Math.max(adjustedLogicalRight,this._parcelRight);
            }
         }
         else
         {
            for each(alignData in _alignLines)
            {
               textLine = alignData.textLine;
               rightSideGap = alignData.rightSideGap;
               leftSideGap = alignData.leftSideGap;
               line = textLine.userData as TextFlowLine;
               extraSpace = effectiveParcelWidth - leftSideGap - rightSideGap - textLine.textWidth;
               delta = leftSideGap + (!!alignData.center?extraSpace / 2:extraSpace);
               coord = this._curParcel.top + delta;
               if(line)
               {
                  line.y = coord;
               }
               textLine.y = coord;
               adjustedLogicalRight = alignData.lineWidth + coord + Math.max(rightSideGap,0);
               this._parcelBottom = Math.max(adjustedLogicalRight,this._parcelBottom);
            }
         }
         _alignLines.length = 0;
      }
      
      protected function commitLastLineState(curLine:TextFlowLine) : void
      {
         this._lastLineDescent = curLine.descent;
         this._lastLineLeading = this._curLineLeading;
         this._lastLineLeadingModel = this._curLineLeadingModel;
      }
      
      protected function doVerticalAlignment(canVerticalAlign:Boolean, nextParcel:flashx.textLayout.compose.Parcel) : Boolean
      {
         return false;
      }
      
      protected function finalParcelAdjustment(controller:ContainerController) : void
      {
      }
      
      protected function finishParcel(controller:ContainerController, nextParcel:flashx.textLayout.compose.Parcel) : Boolean
      {
         var effectiveParcelWidth:Number = NaN;
         if(this._curParcelStart == this._curElementStart + this._curElementOffset)
         {
            return false;
         }
         var doTextAlign:Boolean = Boolean(_alignLines) && Boolean(_alignLines.length > 0);
         var totalDepth:Number = this._parcelList.totalDepth;
         if(Boolean(this._textFlow.configuration.overflowPolicy == OverflowPolicy.FIT_DESCENDERS) && Boolean(!isNaN(this._lastLineDescent)))
         {
            totalDepth = totalDepth + this._lastLineDescent;
         }
         if(this._blockProgression == BlockProgression.TB)
         {
            this._parcelLeft = this._curParcel.left;
            this._parcelTop = this._curParcel.top;
            this._parcelRight = this._contentCommittedExtent + this._curParcel.left;
            this._parcelBottom = totalDepth + this._curParcel.top;
         }
         else
         {
            this._parcelLeft = this._curParcel.right - totalDepth;
            this._parcelTop = this._curParcel.top;
            this._parcelRight = this._curParcel.right;
            this._parcelBottom = this._contentCommittedExtent + this._curParcel.top;
         }
         if(doTextAlign)
         {
            if(this._blockProgression == BlockProgression.TB)
            {
               effectiveParcelWidth = !!controller.measureWidth?Number(this._contentLogicalExtent):Number(this._curParcel.width);
            }
            else
            {
               effectiveParcelWidth = !!controller.measureHeight?Number(this._contentLogicalExtent):Number(this._curParcel.height);
            }
            this.applyTextAlign(effectiveParcelWidth);
         }
         var canVerticalAlign:Boolean = false;
         if(this._blockProgression == BlockProgression.TB)
         {
            if(Boolean(!controller.measureHeight) && (Boolean(!this._curParcel.fitAny) || Boolean(this._curElementStart + this._curElementOffset >= this._textFlow.textLength)))
            {
               canVerticalAlign = true;
            }
         }
         else if(Boolean(!controller.measureWidth) && (Boolean(!this._curParcel.fitAny) || Boolean(this._curElementStart + this._curElementOffset >= this._textFlow.textLength)))
         {
            canVerticalAlign = true;
         }
         if(this.doVerticalAlignment(canVerticalAlign,nextParcel))
         {
            doTextAlign = true;
         }
         this.finalParcelAdjustment(controller);
         this._contentLogicalExtent = 0;
         this._contentCommittedExtent = 0;
         return true;
      }
      
      protected function applyVerticalAlignmentToColumn(controller:ContainerController, vjType:String, lines:Array, beginIndex:int, numLines:int) : void
      {
         var firstLineCoord:Number = NaN;
         var lastLineCoord:Number = NaN;
         var firstLine:IVerticalJustificationLine = lines[beginIndex];
         var lastLine:IVerticalJustificationLine = lines[beginIndex + numLines - 1];
         if(this._blockProgression == BlockProgression.TB)
         {
            firstLineCoord = firstLine.y;
            lastLineCoord = lastLine.y;
         }
         else
         {
            firstLineCoord = firstLine.x;
            lastLineCoord = lastLine.x;
         }
         VerticalJustifier.applyVerticalAlignmentToColumn(controller,vjType,lines,beginIndex,numLines);
         if(this._blockProgression == BlockProgression.TB)
         {
            this._parcelTop = this._parcelTop + (firstLine.y - firstLineCoord);
            this._parcelBottom = this._parcelBottom + (lastLine.y - lastLineCoord);
         }
         else
         {
            this._parcelRight = this._parcelRight + (firstLine.x - firstLineCoord);
            this._parcelLeft = this._parcelLeft + (lastLine.x - lastLineCoord);
         }
      }
      
      private function finishController(controller:ContainerController) : void
      {
         var paddingLeft:Number = NaN;
         var paddingTop:Number = NaN;
         var paddingRight:Number = NaN;
         var paddingBottom:Number = NaN;
         var controllerTextLength:int = this._curElementStart + this._curElementOffset - controller.absoluteStart;
         if(controllerTextLength != 0)
         {
            paddingLeft = controller.effectivePaddingLeft;
            paddingTop = controller.effectivePaddingTop;
            paddingRight = controller.effectivePaddingRight;
            paddingBottom = controller.effectivePaddingBottom;
            if(this._blockProgression == BlockProgression.TB)
            {
               if(this._controllerLeft > 0)
               {
                  if(this._controllerLeft < paddingLeft)
                  {
                     this._controllerLeft = 0;
                  }
                  else
                  {
                     this._controllerLeft = this._controllerLeft - paddingLeft;
                  }
               }
               if(this._controllerTop > 0)
               {
                  if(this._controllerTop < paddingTop)
                  {
                     this._controllerTop = 0;
                  }
                  else
                  {
                     this._controllerTop = this._controllerTop - paddingTop;
                  }
               }
               if(isNaN(controller.compositionWidth))
               {
                  this._controllerRight = this._controllerRight + paddingRight;
               }
               else if(this._controllerRight < controller.compositionWidth)
               {
                  if(this._controllerRight > controller.compositionWidth - paddingRight)
                  {
                     this._controllerRight = controller.compositionWidth;
                  }
                  else
                  {
                     this._controllerRight = this._controllerRight + paddingRight;
                  }
               }
               this._controllerBottom = this._controllerBottom + paddingBottom;
            }
            else
            {
               this._controllerLeft = this._controllerLeft - paddingLeft;
               if(this._controllerTop > 0)
               {
                  if(this._controllerTop < paddingTop)
                  {
                     this._controllerTop = 0;
                  }
                  else
                  {
                     this._controllerTop = this._controllerTop - paddingTop;
                  }
               }
               if(this._controllerRight < 0)
               {
                  if(this._controllerRight > -paddingRight)
                  {
                     this._controllerRight = 0;
                  }
                  else
                  {
                     this._controllerRight = this._controllerRight + paddingRight;
                  }
               }
               if(isNaN(controller.compositionHeight))
               {
                  this._controllerBottom = this._controllerBottom + paddingBottom;
               }
               else if(this._controllerBottom < controller.compositionHeight)
               {
                  if(this._controllerBottom > controller.compositionHeight - paddingBottom)
                  {
                     this._controllerBottom = controller.compositionHeight;
                  }
                  else
                  {
                     this._controllerBottom = this._controllerBottom + paddingBottom;
                  }
               }
            }
            controller.setContentBounds(this._controllerLeft,this._controllerTop,this._controllerRight - this._controllerLeft,this._controllerBottom - this._controllerTop);
         }
         else
         {
            controller.setContentBounds(0,0,0,0);
         }
         controller.setTextLength(controllerTextLength);
      }
      
      private function clearControllers(oldController:ContainerController, newController:ContainerController) : void
      {
         var controllerToClear:ContainerController = null;
         var firstToClear:int = Boolean(oldController)?int(this._flowComposer.getControllerIndex(oldController) + 1):int(0);
         var lastToClear:int = Boolean(newController)?int(this._flowComposer.getControllerIndex(newController)):int(this._flowComposer.numControllers - 1);
         while(firstToClear <= lastToClear)
         {
            controllerToClear = ContainerController(this._flowComposer.getControllerAt(firstToClear));
            controllerToClear.setContentBounds(0,0,0,0);
            controllerToClear.setTextLength(0);
            firstToClear++;
         }
      }
      
      protected function parcelHasChanged(newParcel:flashx.textLayout.compose.Parcel) : void
      {
         var oldController:ContainerController = Boolean(this._curParcel)?ContainerController(this._curParcel.controller):null;
         var newController:ContainerController = Boolean(newParcel)?ContainerController(newParcel.controller):null;
         if(this._curParcel != null)
         {
            if(this.finishParcel(oldController,newParcel))
            {
               if(this._parcelLeft < this._controllerLeft)
               {
                  this._controllerLeft = this._parcelLeft;
               }
               if(this._parcelRight > this._controllerRight)
               {
                  this._controllerRight = this._parcelRight;
               }
               if(this._parcelTop < this._controllerTop)
               {
                  this._controllerTop = this._parcelTop;
               }
               if(this._parcelBottom > this._controllerBottom)
               {
                  this._controllerBottom = this._parcelBottom;
               }
            }
         }
         if(oldController != newController)
         {
            if(oldController)
            {
               this.finishController(oldController);
            }
            this.resetControllerBounds();
            if(this._flowComposer.numControllers > 1)
            {
               if(Boolean(oldController == null) && Boolean(this._startController))
               {
                  this.clearControllers(this._startController,newController);
               }
               else
               {
                  this.clearControllers(oldController,newController);
               }
            }
         }
         this._curParcel = newParcel;
         this._curParcelStart = this._curElementStart;
      }
      
      private function getLineAdjustmentForInline(curLine:TextFlowLine, curLeadingDir:String, isFirstLine:Boolean) : LeadingAdjustment
      {
         var inlineImg:InlineGraphicElement = null;
         var domBaseline:String = null;
         var elemLeading:Number = NaN;
         var curAdjustment:LeadingAdjustment = null;
         var tempSize:Number = NaN;
         var adjustment:LeadingAdjustment = null;
         var curTextLine:TextLine = curLine.getTextLine();
         var para:ParagraphElement = curLine.paragraph;
         var flowElem:FlowLeafElement = this._curElement;
         var curPos:int = flowElem.getAbsoluteStart();
         var largestPointSize:Number = flowElem.getEffectiveFontSize();
         var largestImg:Number = 0;
         while(Boolean(flowElem) && Boolean(curPos < curLine.absoluteStart + curLine.textLength))
         {
            if(Boolean(curPos >= curLine.absoluteStart) || Boolean(curPos + flowElem.textLength >= curLine.absoluteStart))
            {
               if(flowElem is InlineGraphicElement)
               {
                  inlineImg = flowElem as InlineGraphicElement;
                  if(!(Boolean(this._blockProgression == BlockProgression.RL) && Boolean(flowElem.parent is TCYElement)))
                  {
                     if(largestImg < inlineImg.getEffectiveFontSize())
                     {
                        largestImg = inlineImg.getEffectiveFontSize();
                        if(largestImg >= largestPointSize)
                        {
                           largestImg = largestImg;
                           domBaseline = flowElem.computedFormat.dominantBaseline;
                           if(domBaseline == FormatValue.AUTO)
                           {
                              domBaseline = LocaleUtil.dominantBaseline(para.computedFormat.locale);
                           }
                           if(domBaseline == TextBaseline.IDEOGRAPHIC_CENTER)
                           {
                              elemLeading = TextLayoutFormat.lineHeightProperty.computeActualPropertyValue(inlineImg.computedFormat.lineHeight,inlineImg.getEffectiveFontSize());
                              curAdjustment = this.calculateLinePlacementAdjustment(curTextLine,domBaseline,curLeadingDir,inlineImg,isFirstLine);
                              if(Boolean(!adjustment) || Boolean(Math.abs(curAdjustment.rise) > Math.abs(adjustment.rise)) || Boolean(Math.abs(curAdjustment.leading) > Math.abs(adjustment.leading)))
                              {
                                 if(adjustment)
                                 {
                                    adjustment.rise = curAdjustment.rise;
                                    adjustment.leading = curAdjustment.leading;
                                 }
                                 else
                                 {
                                    adjustment = curAdjustment;
                                 }
                              }
                           }
                        }
                     }
                  }
               }
               else
               {
                  tempSize = flowElem.getEffectiveFontSize();
                  if(largestPointSize <= tempSize)
                  {
                     largestPointSize = tempSize;
                  }
                  if(Boolean(adjustment) && Boolean(largestImg < largestPointSize))
                  {
                     adjustment.leading = 0;
                     adjustment.rise = 0;
                  }
               }
            }
            curPos = curPos + flowElem.textLength;
            flowElem = flowElem.getNextLeaf(para);
         }
         return adjustment;
      }
      
      public function get swfContext() : ISWFContext
      {
         var composerContext:ISWFContext = this._flowComposer.swfContext;
         return Boolean(composerContext)?composerContext:GlobalSWFContext.globalSWFContext;
      }
      
      private function calculateLinePlacementAdjustment(curTextLine:TextLine, domBaseline:String, curLeadingDir:String, inlineImg:InlineGraphicElement, isFirstLine:Boolean) : LeadingAdjustment
      {
         var curAdjustment:LeadingAdjustment = new LeadingAdjustment();
         var imgHeight:Number = TextLayoutFormat.lineHeightProperty.computeActualPropertyValue(inlineImg.computedFormat.lineHeight,inlineImg.getEffectiveFontSize());
         var lineLeading:Number = TextLayoutFormat.lineHeightProperty.computeActualPropertyValue(inlineImg.computedFormat.lineHeight,curTextLine.textHeight);
         if(domBaseline == TextBaseline.IDEOGRAPHIC_CENTER)
         {
            if(!isFirstLine)
            {
               curAdjustment.rise = curAdjustment.rise + (imgHeight - lineLeading) / 2;
            }
            else
            {
               curAdjustment.leading = curAdjustment.leading - (imgHeight - lineLeading) / 2;
            }
         }
         return curAdjustment;
      }
   }
}

import flash.text.engine.TextLine;

class AlignData
{
    
   public var textLine:TextLine;
   
   public var lineWidth:Number;
   
   public var center:Boolean;
   
   public var leftSideGap:Number;
   
   public var rightSideGap:Number;
   
   function AlignData()
   {
      super();
   }
}

import flashx.textLayout.compose.ISWFContext;

class GlobalSWFContext implements ISWFContext
{
   
   public static const globalSWFContext:GlobalSWFContext = new GlobalSWFContext();
    
   function GlobalSWFContext()
   {
      super();
   }
   
   public function callInContext(fn:Function, thisArg:Object, argsArray:Array, returns:Boolean = true) : *
   {
      if(returns)
      {
         return fn.apply(thisArg,argsArray);
      }
      fn.apply(thisArg,argsArray);
   }
}

class LeadingAdjustment
{
    
   public var rise:Number = 0;
   
   public var leading:Number = 0;
   
   public var lineHeight:Number = 0;
   
   function LeadingAdjustment()
   {
      super();
   }
}
