package com.beka.util.calc
{
   public class Calc_ei
   {
       
      private var n0:Array;
      
      private var a0:Array;
      
      private var b0:Array;
      
      private var a1:Array;
      
      private var b1:Array;
      
      public function Calc_ei()
      {
         super();
         this.n0 = new Array();
         this.n0[0] = -6024.5282;
         this.n0[1] = 24.7219;
         this.n0[2] = 0.010613868;
         this.n0[3] = -0.000013198825;
         this.n0[4] = -0.49382577;
         this.a0 = new Array();
         this.a0[0] = 0.00098830022;
         this.a0[1] = 0.000057429701;
         this.a0[2] = 8.9023096e-7;
         this.a0[3] = 6.2038841e-9;
         this.b0 = new Array();
         this.b0[0] = -10.415113;
         this.b0[1] = 0.091177156;
         this.b0[2] = 0.000051128274;
         this.b0[3] = 3.5499292e-6;
         this.a1 = new Array();
         this.a1[0] = 0.000361345;
         this.a1[1] = 0.000029471685;
         this.a1[2] = 5.2191167e-7;
         this.a1[3] = 5.019421e-9;
         this.b1 = new Array();
         this.b1[0] = -10.7401;
         this.b1[1] = 0.073698447;
         this.b1[2] = -0.00026890021;
         this.b1[3] = 1.5395086e-6;
      }
      
      public function calculate(p:Number, t:Number, clean:Boolean) : Number
      {
         var ei:Number = 0;
         if(Boolean(t >= -100) && Boolean(t <= 0.01))
         {
            ei = this.calc(t);
         }
         else
         {
            ei = NaN;
         }
         if(clean)
         {
            return ei;
         }
         return ei * this.fw(p,t,ei);
      }
      
      public function calc(t:Number) : Number
      {
         t = t + 273.15;
         return Math.exp(this.n0[0] / t + this.n0[1] + this.n0[2] * t + this.n0[3] * Math.pow(t,2) + this.n0[4] * Math.log(t));
      }
      
      public function fw(p:Number, t:Number, ei:Number) : Number
      {
         var i:int = 0;
         var j:int = 0;
         if(Boolean(t > 10) || Boolean(t < -105))
         {
            return NaN;
         }
         var alpha:Number = 0;
         var beta:Number = 0;
         if(ei > p)
         {
            return 1;
         }
         if(t < -50)
         {
            for(i = 0; i < 4; i++)
            {
               alpha = alpha + this.a0[i] * Math.pow(t,i);
               beta = beta + this.b0[i] * Math.pow(t,i);
            }
         }
         else
         {
            for(j = 0; j < 4; j++)
            {
               alpha = alpha + this.a1[j] * Math.pow(t,j);
               beta = beta + this.b1[j] * Math.pow(t,j);
            }
         }
         beta = Math.exp(beta);
         var result:Number = Math.exp(alpha * (1 - ei / p) + beta * (p / ei - 1));
         if(result < 1)
         {
            return 1;
         }
         return result;
      }
   }
}
