package com.beka.util
{
   import flash.events.EventDispatcher;
   import flash.utils.Dictionary;
   
   public class EEMath extends EventDispatcher
   {
      
      private static var instance:com.beka.util.EEMath;
       
      private const errorEvt:String = "ErrEvt";
      
      private var calc:com.beka.util.EECalculator;
      
      private var isCleanPhase:Boolean;
      
      private const tDev:Number = 0.1;
      
      private const tiDev:Number = 0.1;
      
      private const twDev:Number = 0.1;
      
      private const tfDev:Number = 0.1;
      
      private const tdDev:Number = 0.1;
      
      private const uiDev:Number = 0.1;
      
      private const uwDev:Number = 0.1;
      
      public function EEMath()
      {
         super();
         this.calc = new com.beka.util.EECalculator();
         this.isCleanPhase = false;
      }
      
      public static function getInstance() : com.beka.util.EEMath
      {
         if(instance == null)
         {
            instance = new com.beka.util.EEMath();
         }
         return instance;
      }
      
      public function setCleanPhase(cleanPhase:Boolean) : void
      {
         this.isCleanPhase = cleanPhase;
      }
      
      public function checkParameters(p:Number, t:Number) : String
      {
         return "";
      }
      
      public function checkValues(e:Number, p:Number, t:Number, ei:Number, ew:Number) : String
      {
         var ret:String = "";
         if(e < 0)
         {
            ret = "esz";
         }
         if(e > p)
         {
            ret = "egp";
         }
         if(Boolean(t <= 0.01) && Boolean(e > ei))
         {
            ret = "egei";
         }
         if(Boolean(t > 0.01) && Boolean(e > ew))
         {
            ret = "egew";
         }
         return ret;
      }
      
      public function calcValuesFrom_ti(p:Number, t:Number, ei:Number, ew:Number, value:Number) : Dictionary
      {
         var result:Dictionary = new Dictionary();
         if(Boolean(t > 0.01) || Boolean(p > 1500))
         {
            if(t > 0.01)
            {
               dispatchEvent(new BekaErrorEvent(this.errorEvt,"ti","or","tori"));
            }
            if(p > 1500)
            {
               dispatchEvent(new BekaErrorEvent(this.errorEvt,"ti","or","por"));
            }
            return null;
         }
         if(value > t)
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"ti","or","tigt"));
            return null;
         }
         if(value > 0.01)
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"ti","or","tior"));
            return null;
         }
         var e:Number = this.calc.getEForTi(p,t,value,this.isCleanPhase);
         if(e < this.calc.calc_ei(p,-100,this.isCleanPhase))
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"ti","or","egrei100"));
            return null;
         }
         var errCode:String = this.checkValues(e,p,t,ei,ew);
         if(errCode != "")
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"ti","or",errCode));
            return null;
         }
         result["tw"] = this.calc.calc_tw(p,t,e);
         result["qv"] = this.calc.calc_qv(p,e);
         result["wv"] = this.calc.calc_wv(p,e);
         result["dv"] = this.calc.calc_dv(t,e);
         result["r"] = this.calc.calc_r(p,e);
         result["tf"] = this.calc.calc_tf(p,e);
         result["td"] = this.calc.calc_td(p,e);
         result["ui"] = this.calc.calc_ui(e,ei);
         result["uw"] = this.calc.calc_uw(e,ew);
         result["e"] = e;
         result["h"] = this.calc.calc_h(t,result["r"]);
         return result;
      }
      
      public function calcValuesFrom_tw(p:Number, t:Number, ei:Number, ew:Number, value:Number) : Dictionary
      {
         var result:Dictionary = new Dictionary();
         if(p > 1500)
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"tw","or","por"));
            return null;
         }
         if(value > t)
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"tw","or","twgt"));
            return null;
         }
         if(Boolean(value < -10) || Boolean(value > 115))
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"tw","or","twor"));
            return null;
         }
         var e:Number = this.calc.getEForTw(p,t,value,this.isCleanPhase);
         if(e < this.calc.calc_ew(p,-100,this.isCleanPhase))
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"tw","or","egrew100"));
            return null;
         }
         var errCode:String = this.checkValues(e,p,t,ei,ew);
         if(errCode != "")
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"tw","or",errCode));
            return null;
         }
         result["ti"] = this.calc.calc_ti(p,t,e);
         result["qv"] = this.calc.calc_qv(p,e);
         result["wv"] = this.calc.calc_wv(p,e);
         result["dv"] = this.calc.calc_dv(t,e);
         result["r"] = this.calc.calc_r(p,e);
         result["tf"] = this.calc.calc_tf(p,e);
         result["td"] = this.calc.calc_td(p,e);
         result["ui"] = this.calc.calc_ui(e,ei);
         result["uw"] = this.calc.calc_uw(e,ew);
         result["e"] = e;
         result["h"] = this.calc.calc_h(t,result["r"]);
         return result;
      }
      
      public function calcValuesFrom_qv(p:Number, t:Number, ei:Number, ew:Number, qv:Number) : Dictionary
      {
         var result:Dictionary = new Dictionary();
         var e:Number = p * qv / (qv * 0.378022 + 621.978);
         var errCode:String = this.checkValues(e,p,t,ei,ew);
         if(errCode != "")
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"qv","or",errCode));
            return null;
         }
         result["ti"] = this.calc.calc_ti(p,t,e);
         result["tw"] = this.calc.calc_tw(p,t,e);
         result["wv"] = this.calc.calc_wv(p,e);
         result["dv"] = this.calc.calc_dv(t,e);
         result["r"] = this.calc.calc_r(p,e);
         result["tf"] = this.calc.calc_tf(p,e);
         result["td"] = this.calc.calc_td(p,e);
         result["ui"] = this.calc.calc_ui(e,ei);
         result["uw"] = this.calc.calc_uw(e,ew);
         result["e"] = e;
         result["h"] = this.calc.calc_h(t,result["r"]);
         return result;
      }
      
      public function calcValuesFrom_wv(p:Number, t:Number, ei:Number, ew:Number, wv:Number) : Dictionary
      {
         var result:Dictionary = new Dictionary();
         var e:Number = wv / 100 * p;
         var errCode:String = this.checkValues(e,p,t,ei,ew);
         if(errCode != "")
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"wv","or",errCode));
            return null;
         }
         result["ti"] = this.calc.calc_ti(p,t,e);
         result["tw"] = this.calc.calc_tw(p,t,e);
         result["qv"] = this.calc.calc_qv(p,e);
         result["dv"] = this.calc.calc_dv(t,e);
         result["r"] = this.calc.calc_r(p,e);
         result["tf"] = this.calc.calc_tf(p,e);
         result["td"] = this.calc.calc_td(p,e);
         result["ui"] = this.calc.calc_ui(e,ei);
         result["uw"] = this.calc.calc_uw(e,ew);
         result["e"] = e;
         result["h"] = this.calc.calc_h(t,result["r"]);
         return result;
      }
      
      public function calcValuesFrom_dv(p:Number, t:Number, ei:Number, ew:Number, dv:Number) : Dictionary
      {
         var result:Dictionary = new Dictionary();
         var e:Number = dv / 216.673 * (t + 273.15);
         if(this.isCleanPhase)
         {
            p = e;
         }
         var errCode:String = this.checkValues(e,p,t,ei,ew);
         if(errCode != "")
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"dv","or",errCode));
            return null;
         }
         result["tf"] = this.calc.calc_tf(p,e);
         result["td"] = this.calc.calc_td(p,e);
         result["ui"] = this.calc.calc_ui(e,ei);
         result["uw"] = this.calc.calc_uw(e,ew);
         result["e"] = e;
         if(!this.isCleanPhase)
         {
            result["r"] = this.calc.calc_r(p,e);
            result["wv"] = this.calc.calc_wv(p,e);
            result["qv"] = this.calc.calc_qv(p,e);
            result["tw"] = this.calc.calc_tw(p,t,e);
            result["ti"] = this.calc.calc_ti(p,t,e);
            result["h"] = this.calc.calc_h(t,result["r"]);
         }
         return result;
      }
      
      public function calcValuesFrom_r(p:Number, t:Number, ei:Number, ew:Number, r:Number) : Dictionary
      {
         var result:Dictionary = new Dictionary();
         var e:Number = r * p / (621.978 + r);
         var errCode:String = this.checkValues(e,p,t,ei,ew);
         if(errCode != "")
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"r","or",errCode));
            return null;
         }
         result["ti"] = this.calc.calc_ti(p,t,e);
         result["tw"] = this.calc.calc_tw(p,t,e);
         result["qv"] = this.calc.calc_qv(p,e);
         result["wv"] = this.calc.calc_wv(p,e);
         result["dv"] = this.calc.calc_dv(t,e);
         result["tf"] = this.calc.calc_tf(p,e);
         result["td"] = this.calc.calc_td(p,e);
         result["ui"] = this.calc.calc_ui(e,ei);
         result["uw"] = this.calc.calc_uw(e,ew);
         result["e"] = e;
         result["h"] = this.calc.calc_h(t,result["r"]);
         return result;
      }
      
      public function calcValuesFrom_tf(p:Number, t:Number, ei:Number, ew:Number, tf:Number) : Dictionary
      {
         var result:Dictionary = new Dictionary();
         if(t > 0.01)
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"tf","or","tori"));
            return null;
         }
         if(Boolean(tf < -100) || Boolean(tf > 0.01))
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"tf","or","tfor"));
            return null;
         }
         var e:Number = this.calc.getEForTf(p,tf,this.isCleanPhase);
         if(this.isCleanPhase)
         {
            p = e;
         }
         var errCode:String = this.checkValues(e,p,t,ei,ew);
         if(errCode != "")
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"tf","or",errCode));
            return null;
         }
         result["dv"] = this.calc.calc_dv(t,e);
         result["td"] = this.calc.calc_td(p,e);
         result["ui"] = this.calc.calc_ui(e,ei);
         result["uw"] = this.calc.calc_uw(e,ew);
         result["e"] = e;
         if(!this.isCleanPhase)
         {
            result["r"] = this.calc.calc_r(p,e);
            result["wv"] = this.calc.calc_wv(p,e);
            result["qv"] = this.calc.calc_qv(p,e);
            result["tw"] = this.calc.calc_tw(p,t,e);
            result["ti"] = this.calc.calc_ti(p,t,e);
            result["h"] = this.calc.calc_h(t,result["r"]);
         }
         return result;
      }
      
      public function calcValuesFrom_td(p:Number, t:Number, ei:Number, ew:Number, td:Number) : Dictionary
      {
         var result:Dictionary = new Dictionary();
         if(Boolean(td < -100) || Boolean(td > 200))
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"td","or","tdor"));
            return null;
         }
         var e:Number = this.calc.getEForTd(p,td,this.isCleanPhase);
         if(this.isCleanPhase)
         {
            p = e;
         }
         var errCode:String = this.checkValues(e,p,t,ei,ew);
         if(errCode != "")
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"td","or",errCode));
            return null;
         }
         result["dv"] = this.calc.calc_dv(t,e);
         result["tf"] = this.calc.calc_tf(p,e);
         result["ui"] = this.calc.calc_ui(e,ei);
         result["uw"] = this.calc.calc_uw(e,ew);
         result["e"] = e;
         if(!this.isCleanPhase)
         {
            result["r"] = this.calc.calc_r(p,e);
            result["wv"] = this.calc.calc_wv(p,e);
            result["qv"] = this.calc.calc_qv(p,e);
            result["tw"] = this.calc.calc_tw(p,t,e);
            result["ti"] = this.calc.calc_ti(p,t,e);
            result["h"] = this.calc.calc_h(t,result["r"]);
         }
         return result;
      }
      
      public function calcValuesFrom_ui(p:Number, t:Number, ei:Number, ew:Number, ui:Number) : Dictionary
      {
         var result:Dictionary = new Dictionary();
         if(t > 0.01)
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"ui","or","tori"));
            return null;
         }
         var e:Number = ui / 100 * ei;
         if(this.isCleanPhase)
         {
            p = e;
         }
         var errCode:String = this.checkValues(e,p,t,ei,ew);
         if(errCode != "")
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"ui","or",errCode));
            return null;
         }
         result["dv"] = this.calc.calc_dv(t,e);
         result["tf"] = this.calc.calc_tf(p,e);
         result["td"] = this.calc.calc_td(p,e);
         result["uw"] = this.calc.calc_uw(e,ew);
         result["e"] = e;
         if(!this.isCleanPhase)
         {
            result["r"] = this.calc.calc_r(p,e);
            result["wv"] = this.calc.calc_wv(p,e);
            result["qv"] = this.calc.calc_qv(p,e);
            result["tw"] = this.calc.calc_tw(p,t,e);
            result["ti"] = this.calc.calc_ti(p,t,e);
            result["h"] = this.calc.calc_h(t,result["r"]);
         }
         return result;
      }
      
      public function calcValuesFrom_uw(p:Number, t:Number, ei:Number, ew:Number, uw:Number) : Dictionary
      {
         var result:Dictionary = new Dictionary();
         var e:Number = uw / 100 * ew;
         if(this.isCleanPhase)
         {
            p = e;
         }
         var errCode:String = this.checkValues(e,p,t,ei,ew);
         if(errCode != "")
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"uw","or",errCode));
            return null;
         }
         result["dv"] = this.calc.calc_dv(t,e);
         result["tf"] = this.calc.calc_tf(p,e);
         result["td"] = this.calc.calc_td(p,e);
         result["ui"] = this.calc.calc_ui(e,ei);
         result["e"] = e;
         if(!this.isCleanPhase)
         {
            result["r"] = this.calc.calc_r(p,e);
            result["wv"] = this.calc.calc_wv(p,e);
            result["qv"] = this.calc.calc_qv(p,e);
            result["tw"] = this.calc.calc_tw(p,t,e);
            result["ti"] = this.calc.calc_ti(p,t,e);
            result["h"] = this.calc.calc_h(t,result["r"]);
         }
         return result;
      }
      
      public function calcValuesFrom_e(p:Number, t:Number, ei:Number, ew:Number, e:Number) : Dictionary
      {
         var result:Dictionary = new Dictionary();
         if(this.isCleanPhase)
         {
            p = e;
         }
         var errCode:String = this.checkValues(e,p,t,ei,ew);
         if(errCode != "")
         {
            dispatchEvent(new BekaErrorEvent(this.errorEvt,"e","or",errCode));
            return null;
         }
         result["dv"] = this.calc.calc_dv(t,e);
         result["tf"] = this.calc.calc_tf(p,e);
         result["td"] = this.calc.calc_td(p,e);
         result["ui"] = this.calc.calc_ui(e,ei);
         result["uw"] = this.calc.calc_uw(e,ew);
         if(!this.isCleanPhase)
         {
            result["r"] = this.calc.calc_r(p,e);
            result["wv"] = this.calc.calc_wv(p,e);
            result["qv"] = this.calc.calc_qv(p,e);
            result["tw"] = this.calc.calc_tw(p,t,e);
            result["ti"] = this.calc.calc_ti(p,t,e);
            result["h"] = this.calc.calc_h(t,result["r"]);
         }
         return result;
      }
      
      public function calcValuesFrom_p_t(p:Number, t:Number) : Dictionary
      {
         var result:Dictionary = new Dictionary();
         if(Boolean(t < -100) || Boolean(t > 200) || Boolean(p <= 0) || Boolean(p > 100000))
         {
            if(Boolean(t < -100) || Boolean(t > 200))
            {
               dispatchEvent(new BekaErrorEvent(this.errorEvt,"t","or","tor"));
            }
            if(Boolean(p <= 0) || Boolean(p > 100000))
            {
               dispatchEvent(new BekaErrorEvent(this.errorEvt,"p","or","ppor"));
            }
            return null;
         }
         result["ew"] = this.calc.calc_ew(p,t,this.isCleanPhase);
         result["ei"] = this.calc.calc_ei(p,t,this.isCleanPhase);
         if(!this.isCleanPhase)
         {
            result["rs"] = this.calc.calc_rs(p,t,result["ew"],result["ei"]);
         }
         return result;
      }
      
      public function calcDeviationFrom_p_t(p:Number, dp:Number, t:Number, dt:Number, ei:Number, ew:Number) : Dictionary
      {
         var dev1:Number = NaN;
         var dev2:Number = NaN;
         var dev3:Number = NaN;
         var rs_p_pos:Number = NaN;
         var rs_p_neg:Number = NaN;
         var rs_t_pos:Number = NaN;
         var rs_t_neg:Number = NaN;
         var result:Dictionary = new Dictionary();
         var pDev:Number = p * 0.001;
         if(pDev < 1)
         {
            pDev = 1;
         }
         var pPos:Number = p + pDev;
         var pNeg:Number = p - pDev;
         if(pPos > 100000)
         {
            pPos = p;
            pNeg = p - 2 * pDev;
         }
         if(pNeg < 0)
         {
            pPos = p + 2 * pDev;
            pNeg = p;
         }
         var tsNeg:Number = t - this.tdDev;
         var tbNeg:Number = t - this.tDev;
         var tsPos:Number = t + this.tDev;
         var tbPos:Number = t + this.tDev;
         if(Boolean(tsNeg < -100) || Boolean(tbNeg < -100))
         {
            tsNeg = tbNeg = t;
            tsPos = tbPos = t + 2 * this.tDev;
         }
         if(tsPos > 0.01)
         {
            tsNeg = t - 2 * this.tDev;
            tsPos = t;
         }
         if(tbPos > 200)
         {
            tbNeg = t - 2 * this.tDev;
            tbPos = t;
         }
         var ew_p_pos:Number = this.calc.calc_ew(pPos,t,this.isCleanPhase);
         var ew_p_neg:Number = this.calc.calc_ew(pNeg,t,this.isCleanPhase);
         dev1 = (ew_p_pos - ew_p_neg) / 2 / pDev;
         dev1 = dev1 * dp;
         var ew_t_pos:Number = this.calc.calc_ew(p,tbPos,this.isCleanPhase);
         var ew_t_neg:Number = this.calc.calc_ew(p,tbNeg,this.isCleanPhase);
         dev2 = (ew_t_pos - ew_t_neg) / 2 / this.tDev;
         dev2 = dev2 * dt;
         var ewData:Dictionary = new Dictionary();
         ewData["pPos"] = ew_p_pos;
         ewData["pNeg"] = ew_p_neg;
         ewData["tPos"] = ew_t_pos;
         ewData["tNeg"] = ew_t_neg;
         ewData["noMod"] = ew;
         result["ew"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2));
         result["ewData"] = ewData;
         var ei_p_pos:Number = this.calc.calc_ei(pPos,t,this.isCleanPhase);
         var ei_p_neg:Number = this.calc.calc_ei(pNeg,t,this.isCleanPhase);
         dev1 = (ei_p_pos - ei_p_neg) / 2 / pDev;
         dev1 = dev1 * dp;
         var ei_t_pos:Number = this.calc.calc_ei(p,tsPos,this.isCleanPhase);
         var ei_t_neg:Number = this.calc.calc_ei(p,tsNeg,this.isCleanPhase);
         dev2 = (ei_t_pos - ei_t_neg) / 2 / this.tDev;
         dev2 = dev2 * dt;
         var eiData:Dictionary = new Dictionary();
         eiData["pPos"] = ei_p_pos;
         eiData["pNeg"] = ei_p_neg;
         eiData["tPos"] = ei_t_pos;
         eiData["tNeg"] = ei_t_neg;
         eiData["noMod"] = ei;
         result["ei"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2));
         result["eiData"] = eiData;
         if(!this.isCleanPhase)
         {
            rs_p_pos = this.calc.calc_rs(p + pDev,t,ew_p_pos,ei_p_pos);
            rs_p_neg = this.calc.calc_rs(p - pDev,t,ew_p_neg,ei_p_neg);
            dev1 = (rs_p_pos - rs_p_neg) / 2 / pDev;
            dev1 = dev1 * dp;
            rs_t_pos = this.calc.calc_rs(p,t + this.tDev,ew_t_pos,ei_t_pos);
            rs_t_neg = this.calc.calc_rs(p,t - this.tDev,ew_t_neg,ei_t_neg);
            dev2 = (rs_t_pos - rs_t_neg) / 2 / this.tDev;
            dev2 = dev2 * dt;
            result["rs"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2));
         }
         return result;
      }
      
      public function calcDeviation(inputShort:String, p:Number, dp:Number, t:Number, dt:Number, e:Number, eiData:Dictionary, ewData:Dictionary, value:Number, dv:Number) : Dictionary
      {
         var dev1:Number = NaN;
         var dev2:Number = NaN;
         var dev3:Number = NaN;
         var ti_p_pos:Number = NaN;
         var ti_p_neg:Number = NaN;
         var ti_t_pos:Number = NaN;
         var ti_t_neg:Number = NaN;
         var ti_v_pos:Number = NaN;
         var ti_v_neg:Number = NaN;
         var tw_p_pos:Number = NaN;
         var tw_p_neg:Number = NaN;
         var tw_t_pos:Number = NaN;
         var tw_t_neg:Number = NaN;
         var tw_v_pos:Number = NaN;
         var tw_v_neg:Number = NaN;
         var qv_p_pos:Number = NaN;
         var qv_p_neg:Number = NaN;
         var qv_t_pos:Number = NaN;
         var qv_t_neg:Number = NaN;
         var qv_v_pos:Number = NaN;
         var qv_v_neg:Number = NaN;
         var wv_p_pos:Number = NaN;
         var wv_p_neg:Number = NaN;
         var wv_t_pos:Number = NaN;
         var wv_t_neg:Number = NaN;
         var wv_v_pos:Number = NaN;
         var wv_v_neg:Number = NaN;
         var dv_p_pos:Number = NaN;
         var dv_p_neg:Number = NaN;
         var dv_t_pos:Number = NaN;
         var dv_t_neg:Number = NaN;
         var dv_v_pos:Number = NaN;
         var dv_v_neg:Number = NaN;
         var r_p_pos:Number = NaN;
         var r_p_neg:Number = NaN;
         var r_t_pos:Number = NaN;
         var r_t_neg:Number = NaN;
         var r_v_pos:Number = NaN;
         var r_v_neg:Number = NaN;
         var tf_p_pos:Number = NaN;
         var tf_p_neg:Number = NaN;
         var tf_t_pos:Number = NaN;
         var tf_t_neg:Number = NaN;
         var tf_v_pos:Number = NaN;
         var tf_v_neg:Number = NaN;
         var td_p_pos:Number = NaN;
         var td_p_neg:Number = NaN;
         var td_t_pos:Number = NaN;
         var td_t_neg:Number = NaN;
         var td_v_pos:Number = NaN;
         var td_v_neg:Number = NaN;
         var ui_p_pos:Number = NaN;
         var ui_p_neg:Number = NaN;
         var ui_t_pos:Number = NaN;
         var ui_t_neg:Number = NaN;
         var ui_v_pos:Number = NaN;
         var ui_v_neg:Number = NaN;
         var uw_p_pos:Number = NaN;
         var uw_p_neg:Number = NaN;
         var uw_t_pos:Number = NaN;
         var uw_t_neg:Number = NaN;
         var uw_v_pos:Number = NaN;
         var uw_v_neg:Number = NaN;
         var h_p_pos:Number = NaN;
         var h_p_neg:Number = NaN;
         var h_t_pos:Number = NaN;
         var h_t_neg:Number = NaN;
         var h_v_pos:Number = NaN;
         var h_v_neg:Number = NaN;
         var result:Dictionary = new Dictionary();
         var pDev:Number = p * 0.001;
         if(pDev < 1)
         {
            pDev = 1;
         }
         var pPos:Number = p + pDev;
         var pNeg:Number = p - pDev;
         if(pPos > 100000)
         {
            pPos = p;
            pNeg = p - 2 * pDev;
         }
         if(pNeg < 0)
         {
            pPos = p + 2 * pDev;
            pNeg = p;
         }
         var tsNeg:Number = t - this.tdDev;
         var tbNeg:Number = t - this.tDev;
         var tsPos:Number = t + this.tDev;
         var tbPos:Number = t + this.tDev;
         if(Boolean(tsNeg < -100) || Boolean(tbNeg < -100))
         {
            tsNeg = tbNeg = t;
            tsPos = tbPos = t + 2 * this.tDev;
         }
         if(tsPos > 0.01)
         {
            tsNeg = t - 2 * this.tDev;
            tsPos = t;
         }
         if(tbPos > 200)
         {
            tbNeg = t - 2 * this.tDev;
            tbPos = t;
         }
         var eDict:Dictionary = this.getEFor(inputShort,p,dp,pPos,pNeg,t,dt,eiData,ewData,value,dv);
         if(this.isCleanPhase)
         {
            p = e;
            dp = eDict["e"];
         }
         if(inputShort != "e")
         {
            result["e"] = eDict["e"];
         }
         if(Boolean(inputShort != "ti") && Boolean(!this.isCleanPhase))
         {
            ti_p_pos = this.calc.calc_ti(pPos,t,eDict["epPos"]);
            ti_p_neg = this.calc.calc_ti(pNeg,t,eDict["epNeg"]);
            dev1 = (ti_p_pos - ti_p_neg) / 2 / pDev;
            dev1 = dev1 * dp;
            ti_t_pos = this.calc.calc_ti(p,tsPos,eDict["etPos"]);
            ti_t_neg = this.calc.calc_ti(p,tsNeg,eDict["etNeg"]);
            dev2 = (ti_t_pos - ti_t_neg) / 2 / this.tDev;
            dev2 = dev2 * dt;
            ti_v_pos = this.calc.calc_ti(p,t,eDict["evPos"]);
            ti_v_neg = this.calc.calc_ti(p,t,eDict["evNeg"]);
            dev3 = (ti_v_pos - ti_v_neg) / 2 / eDict["vDev"];
            dev3 = dev3 * dv;
            result["ti"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2) + Math.pow(dev3,2));
         }
         if(Boolean(inputShort != "tw") && Boolean(!this.isCleanPhase))
         {
            tw_p_pos = this.calc.calc_tw(pPos,t,eDict["epPos"]);
            tw_p_neg = this.calc.calc_tw(pNeg,t,eDict["epNeg"]);
            dev1 = (tw_p_pos - tw_p_neg) / 2 / pDev;
            dev1 = dev1 * dp;
            tw_t_pos = this.calc.calc_tw(p,tbPos,eDict["etPos"]);
            tw_t_neg = this.calc.calc_tw(p,tbNeg,eDict["etNeg"]);
            dev2 = (tw_t_pos - tw_t_neg) / 2 / this.tDev;
            dev2 = dev2 * dt;
            tw_v_pos = this.calc.calc_tw(p,t,eDict["evPos"]);
            tw_v_neg = this.calc.calc_tw(p,t,eDict["evNeg"]);
            dev3 = (tw_v_pos - tw_v_neg) / 2 / eDict["vDev"];
            dev3 = dev3 * dv;
            result["tw"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2) + Math.pow(dev3,2));
         }
         if(Boolean(inputShort != "qv") && Boolean(!this.isCleanPhase))
         {
            qv_p_pos = this.calc.calc_qv(p + pDev,eDict["epPos"]);
            qv_p_neg = this.calc.calc_qv(p - pDev,eDict["epNeg"]);
            dev1 = (qv_p_pos - qv_p_neg) / 2 / pDev;
            dev1 = dev1 * dp;
            qv_t_pos = this.calc.calc_qv(p,eDict["etPos"]);
            qv_t_neg = this.calc.calc_qv(p,eDict["etNeg"]);
            dev2 = (qv_t_pos - qv_t_neg) / 2 / this.tDev;
            dev2 = dev2 * dt;
            qv_v_pos = this.calc.calc_qv(p,eDict["evPos"]);
            qv_v_neg = this.calc.calc_qv(p,eDict["evNeg"]);
            dev3 = (qv_v_pos - qv_v_neg) / 2 / eDict["vDev"];
            dev3 = dev3 * dv;
            result["qv"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2) + Math.pow(dev3,2));
         }
         if(Boolean(inputShort != "wv") && Boolean(!this.isCleanPhase))
         {
            wv_p_pos = this.calc.calc_wv(p + pDev,eDict["epPos"]);
            wv_p_neg = this.calc.calc_wv(p - pDev,eDict["epNeg"]);
            dev1 = (wv_p_pos - wv_p_neg) / 2 / pDev;
            dev1 = dev1 * dp;
            wv_t_pos = this.calc.calc_wv(p,eDict["etPos"]);
            wv_t_neg = this.calc.calc_wv(p,eDict["etNeg"]);
            dev2 = (wv_t_pos - wv_t_neg) / 2 / this.tDev;
            dev2 = dev2 * dt;
            wv_v_pos = this.calc.calc_wv(p,eDict["evPos"]);
            wv_v_neg = this.calc.calc_wv(p,eDict["evNeg"]);
            dev3 = (wv_v_pos - wv_v_neg) / 2 / eDict["vDev"];
            dev3 = dev3 * dv;
            result["wv"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2) + Math.pow(dev3,2));
         }
         if(inputShort != "dv")
         {
            dv_p_pos = this.calc.calc_dv(t,eDict["epPos"]);
            dv_p_neg = this.calc.calc_dv(t,eDict["epNeg"]);
            dev1 = (dv_p_pos - dv_p_neg) / 2 / pDev;
            dev1 = dev1 * dp;
            dv_t_pos = this.calc.calc_dv(t + this.tDev,eDict["etPos"]);
            dv_t_neg = this.calc.calc_dv(t - this.tDev,eDict["etNeg"]);
            dev2 = (dv_t_pos - dv_t_neg) / 2 / this.tDev;
            dev2 = dev2 * dt;
            dv_v_pos = this.calc.calc_dv(t,eDict["evPos"]);
            dv_v_neg = this.calc.calc_dv(t,eDict["evNeg"]);
            dev3 = (dv_v_pos - dv_v_neg) / 2 / eDict["vDev"];
            dev3 = dev3 * dv;
            result["dv"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2) + Math.pow(dev3,2));
         }
         if(Boolean(inputShort != "r") && Boolean(!this.isCleanPhase))
         {
            r_p_pos = this.calc.calc_r(p + pDev,eDict["epPos"]);
            r_p_neg = this.calc.calc_r(p - pDev,eDict["epNeg"]);
            dev1 = (r_p_pos - r_p_neg) / 2 / pDev;
            dev1 = dev1 * dp;
            r_t_pos = this.calc.calc_r(p,eDict["etPos"]);
            r_t_neg = this.calc.calc_r(p,eDict["etNeg"]);
            dev2 = (r_t_pos - r_t_neg) / 2 / this.tDev;
            dev2 = dev2 * dt;
            r_v_pos = this.calc.calc_r(p,eDict["evPos"]);
            r_v_neg = this.calc.calc_r(p,eDict["evNeg"]);
            dev3 = (r_v_pos - r_v_neg) / 2 / eDict["vDev"];
            dev3 = dev3 * dv;
            result["r"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2) + Math.pow(dev3,2));
         }
         if(inputShort != "tf")
         {
            tf_p_pos = this.calc.calc_tf(pPos,eDict["epPos"]);
            tf_p_neg = this.calc.calc_tf(pNeg,eDict["epNeg"]);
            dev1 = (tf_p_pos - tf_p_neg) / 2 / pDev;
            dev1 = dev1 * dp;
            tf_t_pos = this.calc.calc_tf(p,eDict["etPos"]);
            tf_t_neg = this.calc.calc_tf(p,eDict["etNeg"]);
            dev2 = (tf_t_pos - tf_t_neg) / 2 / this.tDev;
            dev2 = dev2 * dt;
            tf_v_pos = this.calc.calc_tf(p,eDict["evPos"]);
            tf_v_neg = this.calc.calc_tf(p,eDict["evNeg"]);
            dev3 = (tf_v_pos - tf_v_neg) / 2 / eDict["vDev"];
            dev3 = dev3 * dv;
            result["tf"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2) + Math.pow(dev3,2));
         }
         if(inputShort != "td")
         {
            td_p_pos = this.calc.calc_td(pPos,eDict["epPos"]);
            td_p_neg = this.calc.calc_td(pNeg,eDict["epNeg"]);
            dev1 = (td_p_pos - td_p_neg) / 2 / pDev;
            dev1 = dev1 * dp;
            td_t_pos = this.calc.calc_td(p,eDict["etPos"]);
            td_t_neg = this.calc.calc_td(p,eDict["etNeg"]);
            dev2 = (td_t_pos - td_t_neg) / 2 / this.tDev;
            dev2 = dev2 * dt;
            td_v_pos = this.calc.calc_td(p,eDict["evPos"]);
            td_v_neg = this.calc.calc_td(p,eDict["evNeg"]);
            dev3 = (td_v_pos - td_v_neg) / 2 / eDict["vDev"];
            dev3 = dev3 * dv;
            result["td"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2) + Math.pow(dev3,2));
         }
         if(inputShort != "ui")
         {
            ui_p_pos = this.calc.calc_ui(eDict["epPos"],eiData["pPos"]);
            ui_p_neg = this.calc.calc_ui(eDict["epNeg"],eiData["pNeg"]);
            dev1 = (ui_p_pos - ui_p_neg) / 2 / pDev;
            dev1 = dev1 * dp;
            ui_t_pos = this.calc.calc_ui(eDict["etPos"],eiData["tPos"]);
            ui_t_neg = this.calc.calc_ui(eDict["etNeg"],eiData["tNeg"]);
            dev2 = (ui_t_pos - ui_t_neg) / 2 / this.tDev;
            dev2 = dev2 * dt;
            ui_v_pos = this.calc.calc_ui(eDict["evPos"],eiData["noMod"]);
            ui_v_neg = this.calc.calc_ui(eDict["evNeg"],eiData["noMod"]);
            dev3 = (ui_v_pos - ui_v_neg) / 2 / eDict["vDev"];
            dev3 = dev3 * dv;
            result["ui"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2) + Math.pow(dev3,2));
         }
         if(inputShort != "uw")
         {
            uw_p_pos = this.calc.calc_uw(eDict["epPos"],ewData["pPos"]);
            uw_p_neg = this.calc.calc_uw(eDict["epNeg"],ewData["pNeg"]);
            dev1 = (uw_p_pos - uw_p_neg) / 2 / pDev;
            dev1 = dev1 * dp;
            uw_t_pos = this.calc.calc_uw(eDict["etPos"],ewData["tPos"]);
            uw_t_neg = this.calc.calc_uw(eDict["etNeg"],ewData["tNeg"]);
            dev2 = (uw_t_pos - uw_t_neg) / 2 / this.tDev;
            dev2 = dev2 * dt;
            uw_v_pos = this.calc.calc_uw(eDict["evPos"],ewData["noMod"]);
            uw_v_neg = this.calc.calc_uw(eDict["evNeg"],ewData["noMod"]);
            dev3 = (uw_v_pos - uw_v_neg) / 2 / eDict["vDev"];
            dev3 = dev3 * dv;
            result["uw"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2) + Math.pow(dev3,2));
         }
         if(!this.isCleanPhase)
         {
            h_p_pos = this.calc.calc_h(t,r_p_pos);
            h_p_neg = this.calc.calc_h(t,r_p_neg);
            dev1 = (h_p_pos - h_p_neg) / 2 / pDev;
            dev1 = dev1 * dp;
            h_t_pos = this.calc.calc_h(t + this.tDev,r_t_pos);
            h_t_neg = this.calc.calc_h(t - this.tDev,r_t_neg);
            dev2 = (h_t_pos - h_t_neg) / 2 / this.tDev;
            dev2 = dev2 * dt;
            h_v_pos = this.calc.calc_h(t,r_v_pos);
            h_v_neg = this.calc.calc_h(t,r_v_neg);
            dev3 = (h_v_pos - h_v_neg) / 2 / eDict["vDev"];
            dev3 = dev3 * dv;
            result["h"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2) + Math.pow(dev3,2));
         }
         return result;
      }
      
      private function getEFor(inputShort:String, p:Number, dp:Number, pPos:Number, pNeg:Number, t:Number, dt:Number, eiData:Dictionary, ewData:Dictionary, value:Number, dv:Number) : Dictionary
      {
         var e_p_pos:Number = NaN;
         var e_p_neg:Number = NaN;
         var e_t_pos:Number = NaN;
         var e_t_neg:Number = NaN;
         var e_v_pos:Number = NaN;
         var e_v_neg:Number = NaN;
         var dev1:Number = NaN;
         var dev2:Number = NaN;
         var dev3:Number = NaN;
         var qvDev:Number = NaN;
         var wvDev:Number = NaN;
         var dvDev:Number = NaN;
         var rDev:Number = NaN;
         var eDev:Number = NaN;
         var result:Dictionary = new Dictionary();
         var pDev:Number = p * 0.001;
         if(pDev < 1)
         {
            pDev = 1;
         }
         var tsNeg:Number = t - this.tdDev;
         var tbNeg:Number = t - this.tDev;
         var tsPos:Number = t + this.tDev;
         var tbPos:Number = t + this.tDev;
         if(Boolean(tsNeg < -100) || Boolean(tbNeg < -100))
         {
            tsNeg = tbNeg = t;
            tsPos = tbPos = t + 2 * this.tDev;
         }
         if(tsPos > 0.01)
         {
            tsNeg = t - 2 * this.tDev;
            tsPos = t;
         }
         if(tbPos > 200)
         {
            tbNeg = t - 2 * this.tDev;
            tbPos = t;
         }
         switch(inputShort)
         {
            case "ti":
               e_p_pos = this.calc.getEForTi(pPos,t,value,this.isCleanPhase);
               e_p_neg = this.calc.getEForTi(pNeg,t,value,this.isCleanPhase);
               dev1 = (e_p_pos - e_p_neg) / 2 / pDev;
               dev1 = dev1 * dp;
               e_t_pos = this.calc.getEForTi(p,tsPos,value,this.isCleanPhase);
               e_t_neg = this.calc.getEForTi(p,tsNeg,value,this.isCleanPhase);
               dev2 = (e_t_pos - e_t_neg) / 2 / this.tDev;
               dev2 = dev2 * dt;
               if(value + this.tiDev > 0.01)
               {
                  e_v_pos = this.calc.getEForTi(p,t,value,this.isCleanPhase);
                  e_v_neg = this.calc.getEForTi(p,t,value - 2 * this.tiDev,this.isCleanPhase);
               }
               else if(value - this.tiDev < -100)
               {
                  e_v_pos = this.calc.getEForTi(p,t,value + 2 * this.tiDev,this.isCleanPhase);
                  e_v_neg = this.calc.getEForTi(p,t,value,this.isCleanPhase);
               }
               else
               {
                  e_v_pos = this.calc.getEForTi(p,t,value + this.tiDev,this.isCleanPhase);
                  e_v_neg = this.calc.getEForTi(p,t,value - this.tiDev,this.isCleanPhase);
               }
               dev3 = (e_v_pos - e_v_neg) / 2 / this.tiDev;
               dev3 = dev3 * dv;
               result["vDev"] = this.tiDev;
               break;
            case "tw":
               e_p_pos = this.calc.getEForTw(pPos,t,value,this.isCleanPhase);
               e_p_neg = this.calc.getEForTw(pNeg,t,value,this.isCleanPhase);
               dev1 = (e_p_pos - e_p_neg) / 2 / pDev;
               dev1 = dev1 * dp;
               e_t_pos = this.calc.getEForTw(p,tbPos,value,this.isCleanPhase);
               e_t_neg = this.calc.getEForTw(p,tbNeg,value,this.isCleanPhase);
               dev2 = (e_t_pos - e_t_neg) / 2 / this.tDev;
               dev2 = dev2 * dt;
               if(value + this.twDev > 200)
               {
                  e_v_pos = this.calc.getEForTw(p,t,value,this.isCleanPhase);
                  e_v_neg = this.calc.getEForTw(p,t,value - 2 * this.twDev,this.isCleanPhase);
               }
               else if(value - this.twDev < -100)
               {
                  e_v_pos = this.calc.getEForTw(p,t,value + 2 * this.twDev,this.isCleanPhase);
                  e_v_neg = this.calc.getEForTw(p,t,value,this.isCleanPhase);
               }
               else
               {
                  e_v_pos = this.calc.getEForTw(p,t,value + this.twDev,this.isCleanPhase);
                  e_v_neg = this.calc.getEForTw(p,t,value - this.twDev,this.isCleanPhase);
               }
               dev3 = (e_v_pos - e_v_neg) / 2 / this.twDev;
               dev3 = dev3 * dv;
               result["vDev"] = this.twDev;
               break;
            case "qv":
               qvDev = value * 0.001;
               if(qvDev < 1.0e-6)
               {
                  qvDev = 1.0e-6;
               }
               e_p_pos = (p + pDev) / (0.378022 + 621.978 / value);
               e_p_neg = (p - pDev) / (0.378022 + 621.978 / value);
               dev1 = (e_p_pos - e_p_neg) / 2 / pDev;
               dev1 = dev1 * dp;
               e_t_pos = p / (0.378022 + 621.978 / value);
               e_t_neg = p / (0.378022 + 621.978 / value);
               dev2 = (e_t_pos - e_t_neg) / 2 / this.tDev;
               dev2 = dev2 * dt;
               e_v_pos = p / (0.378022 + 621.978 / (value + qvDev));
               e_v_neg = p / (0.378022 + 621.978 / (value - qvDev));
               dev3 = (e_v_pos - e_v_neg) / 2 / qvDev;
               dev3 = dev3 * dv;
               result["vDev"] = qvDev;
               break;
            case "wv":
               wvDev = value * 0.001;
               if(wvDev < 1.0e-9)
               {
                  wvDev = 1.0e-9;
               }
               e_p_pos = value / 100 * (p + pDev);
               e_p_neg = value / 100 * (p - pDev);
               dev1 = (e_p_pos - e_p_neg) / 2 / pDev;
               dev1 = dev1 * dp;
               e_t_pos = value / 100 * p;
               e_t_neg = value / 100 * p;
               dev2 = (e_t_pos - e_t_neg) / 2 / this.tDev;
               dev2 = dev2 * dt;
               e_v_pos = (value + wvDev) / 100 * p;
               e_v_neg = (value - wvDev) / 100 * p;
               dev3 = (e_v_pos - e_v_neg) / 2 / wvDev;
               dev3 = dev3 * dv;
               result["vDev"] = wvDev;
               break;
            case "dv":
               dvDev = value * 0.001;
               if(dvDev < 1.0e-6)
               {
                  dvDev = 1.0e-6;
               }
               e_p_pos = value / 216.673 * (t + 273.15);
               e_p_neg = value / 216.673 * (t + 273.15);
               dev1 = (e_p_pos - e_p_neg) / 2 / pDev;
               dev1 = dev1 * dp;
               e_t_pos = value / 216.673 * (t + this.tDev + 273.15);
               e_t_neg = value / 216.673 * (t - this.tDev + 273.15);
               dev2 = (e_t_pos - e_t_neg) / 2 / this.tDev;
               dev2 = dev2 * dt;
               e_v_pos = (value + dvDev) / 216.673 * (t + 273.15);
               e_v_neg = (value - dvDev) / 216.673 * (t + 273.15);
               dev3 = (e_v_pos - e_v_neg) / 2 / dvDev;
               dev3 = dev3 * dv;
               result["vDev"] = dvDev;
               break;
            case "r":
               rDev = value * 0.001;
               if(rDev < 1.0e-6)
               {
                  rDev = 1.0e-6;
               }
               e_p_pos = (p + pDev) / (1 + 621.978 / value);
               e_p_neg = (p - pDev) / (1 + 621.978 / value);
               dev1 = (e_p_pos - e_p_neg) / 2 / pDev;
               dev1 = dev1 * dp;
               e_t_pos = p / (1 + 621.978 / value);
               e_t_neg = p / (1 + 621.978 / value);
               dev2 = (e_t_pos - e_t_neg) / 2 / this.tDev;
               dev2 = dev2 * dt;
               e_v_pos = p / (1 + 621.978 / (value + rDev));
               e_v_neg = p / (1 + 621.978 / (value - rDev));
               dev3 = (e_v_pos - e_v_neg) / 2 / rDev;
               dev3 = dev3 * dv;
               result["vDev"] = rDev;
               break;
            case "tf":
               e_p_pos = this.calc.getEForTf(pPos,value,this.isCleanPhase);
               e_p_neg = this.calc.getEForTf(pNeg,value,this.isCleanPhase);
               dev1 = (e_p_pos - e_p_neg) / 2 / pDev;
               dev1 = dev1 * dp;
               e_t_pos = this.calc.getEForTf(p,value,this.isCleanPhase);
               e_t_neg = this.calc.getEForTf(p,value,this.isCleanPhase);
               dev2 = (e_t_pos - e_t_neg) / 2 / this.tDev;
               dev2 = dev2 * dt;
               if(value + this.tfDev > 0.01)
               {
                  e_v_pos = this.calc.getEForTf(p,value,this.isCleanPhase);
                  e_v_neg = this.calc.getEForTf(p,value - 2 * this.tfDev,this.isCleanPhase);
               }
               else if(value - this.tfDev < -100)
               {
                  e_v_pos = this.calc.getEForTf(p,value + 2 * this.tfDev,this.isCleanPhase);
                  e_v_neg = this.calc.getEForTf(p,value,this.isCleanPhase);
               }
               else
               {
                  e_v_pos = this.calc.getEForTf(p,value + this.tfDev,this.isCleanPhase);
                  e_v_neg = this.calc.getEForTf(p,value - this.tfDev,this.isCleanPhase);
               }
               dev3 = (e_v_pos - e_v_neg) / 2 / this.tfDev;
               dev3 = dev3 * dv;
               result["vDev"] = this.tfDev;
               break;
            case "td":
               e_p_pos = this.calc.getEForTd(pPos,value,this.isCleanPhase);
               e_p_neg = this.calc.getEForTd(pNeg,value,this.isCleanPhase);
               dev1 = (e_p_pos - e_p_neg) / 2 / pDev;
               dev1 = dev1 * dp;
               e_t_pos = this.calc.getEForTd(p,value,this.isCleanPhase);
               e_t_neg = this.calc.getEForTd(p,value,this.isCleanPhase);
               dev2 = (e_t_pos - e_t_neg) / 2 / this.tDev;
               dev2 = dev2 * dt;
               if(value + this.tdDev > 200)
               {
                  e_v_pos = this.calc.getEForTd(p,value,this.isCleanPhase);
                  e_v_neg = this.calc.getEForTd(p,value - 2 * this.tdDev,this.isCleanPhase);
               }
               else if(value - this.tdDev < -100)
               {
                  e_v_pos = this.calc.getEForTd(p,value + 2 * this.tdDev,this.isCleanPhase);
                  e_v_neg = this.calc.getEForTd(p,value,this.isCleanPhase);
               }
               else
               {
                  e_v_pos = this.calc.getEForTd(p,value + this.tdDev,this.isCleanPhase);
                  e_v_neg = this.calc.getEForTd(p,value - this.tdDev,this.isCleanPhase);
               }
               dev3 = (e_v_pos - e_v_neg) / 2 / this.tdDev;
               dev3 = dev3 * dv;
               result["vDev"] = this.tdDev;
               break;
            case "ui":
               e_p_pos = value / 100 * eiData["pPos"];
               e_p_neg = value / 100 * eiData["pNeg"];
               dev1 = (e_p_pos - e_p_neg) / 2 / pDev;
               dev1 = dev1 * dp;
               e_t_pos = value / 100 * eiData["tPos"];
               e_t_neg = value / 100 * eiData["tNeg"];
               dev2 = (e_t_pos - e_t_neg) / 2 / this.tDev;
               dev2 = dev2 * dt;
               if(value + this.uiDev > 100)
               {
                  e_v_pos = value / 100 * eiData["noMod"];
                  e_v_neg = (value - 2 * this.uiDev) / 100 * eiData["noMod"];
               }
               else if(value - this.uiDev <= 0)
               {
                  e_v_pos = (value + 2 * this.uiDev) / 100 * eiData["noMod"];
                  e_v_neg = value / 100 * eiData["noMod"];
               }
               else
               {
                  e_v_pos = (value + this.uiDev) / 100 * eiData["noMod"];
                  e_v_neg = (value - this.uiDev) / 100 * eiData["noMod"];
               }
               dev3 = (e_v_pos - e_v_neg) / 2 / this.uiDev;
               dev3 = dev3 * dv;
               result["vDev"] = this.uiDev;
               break;
            case "uw":
               e_p_pos = value / 100 * ewData["pPos"];
               e_p_neg = value / 100 * ewData["pNeg"];
               dev1 = (e_p_pos - e_p_neg) / 2 / pDev;
               dev1 = dev1 * dp;
               e_t_pos = value / 100 * ewData["tPos"];
               e_t_neg = value / 100 * ewData["tNeg"];
               dev2 = (e_t_pos - e_t_neg) / 2 / this.tDev;
               dev2 = dev2 * dt;
               if(value + this.uwDev > 100)
               {
                  e_v_pos = value / 100 * ewData["noMod"];
                  e_v_neg = (value - 2 * this.uwDev) / 100 * ewData["noMod"];
               }
               else if(value - this.uwDev <= 0)
               {
                  e_v_pos = (value + 2 * this.uwDev) / 100 * ewData["noMod"];
                  e_v_neg = value / 100 * ewData["noMod"];
               }
               else
               {
                  e_v_pos = (value + this.uwDev) / 100 * ewData["noMod"];
                  e_v_neg = (value - this.uwDev) / 100 * ewData["noMod"];
               }
               dev3 = (e_v_pos - e_v_neg) / 2 / this.uwDev;
               dev3 = dev3 * dv;
               result["vDev"] = this.uwDev;
         }
         if(inputShort != "e")
         {
            result["e"] = Math.sqrt(Math.pow(dev1,2) + Math.pow(dev2,2) + Math.pow(dev3,2));
            result["epPos"] = e_p_pos;
            result["epNeg"] = e_p_neg;
            result["etPos"] = e_t_pos;
            result["etNeg"] = e_t_neg;
            result["evPos"] = e_v_pos;
            result["evNeg"] = e_v_neg;
         }
         else
         {
            eDev = value * 0.001;
            if(value + eDev > 100000)
            {
               e_v_pos = value;
               e_v_neg = value - 2 * eDev;
            }
            else if(value - eDev < 0)
            {
               e_v_pos = value + 2 * eDev;
               e_v_neg = value;
            }
            else
            {
               e_v_pos = value + eDev;
               e_v_neg = value - eDev;
            }
            dev1 = (e_v_pos - e_v_neg) / 2 / eDev;
            dev1 = dev1 * dv;
            result["vDev"] = eDev;
            result["epPos"] = value;
            result["epNeg"] = value;
            result["etPos"] = value;
            result["etNeg"] = value;
            result["evPos"] = e_v_pos;
            result["evNeg"] = e_v_neg;
            result["e"] = dev1;
         }
         return result;
      }
   }
}
