////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2024 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user plugin.  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// crwdaq data analysis plugin.                                               //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20241030 - Sample created by A.K.                                          //
// 20241104 - Translated from DPR source by A.K.                              //
////////////////////////////////////////////////////////////////////////////////

{
[Manual.Rus]
Эта утилита служит для сглаживания кривой.
Для этого надо задать в полях ввода абсолютную и относительную
ширину окна сглаживания, степень полинома (-1 соответствует интегралу),
а также параметры ядра сглаживания K(x)=(1-x^K1)^K2.
[]
[Manual.Eng]
This plugin uses to smooth curve to suppress noise.
You have to specify absolute and relative smooth window width,
polynom power (-1 mean integral) and kernel parameters K(x)=(1-x^K1)^K2.
[]
[Arguments.Rus]
Имя окна = Результат:"Сглаживание кривой"
Заголовок = ^CЗаголовок^N^L  Y
Легенда = ^RX  ^N^CЛегенда
Абс.Окно = 0
Отн.Окно = 0.05
Степень = 1
K1 = 2
K2 = 2
[]
[Arguments.Eng]
Caption = Result:"Smooth curve"
Title = ^CTitle^N^L  Y
Legend = ^RX  ^N^CLegend
Abs.Window = 0
Rel.Window = 0.05
Power = 1
K1 = 2
K2 = 2
[]
}

library _curve_smooth;

{$I _crw_sysdef}

{$IFDEF FPC}{$mode Delphi}{$ENDIF}{$H+}

{$R *.res}

uses
 _crw_sharemem, // NB: THIS UNIT MUST BE FIRST !!!
 {$IFDEF UNIX} cthreads, dl, {$ENDIF}
 {$IFDEF WINDOWS} windows, {$ENDIF}
 sysutils, classes, math, graphics,
 _crw_crwapi;

//////////////////////////////////////////////////
{$I _crw_plugin_declare} // Declare CRWDAQ_PLUGIN.
//////////////////////////////////////////////////
// function CRWDAQ_PLUGIN(CrwApi:TCrwApi):Integer;
//////////////////////////////////////////////////
const
 swin = +1; // Source window reference
 twin = -1; // Target window reference
 cwin =  0; // Clipboard window reference
 CheckFlags = cfInvalid + cfNoData + cfTooSmall + cfNotSortedX + cfDuplicatesX + cfNanInf;
var
 AbsEps, RelEps, Window : Double;
 p : TPoint2D;
 i, k1, k2, Power, c1, c2, cFirst, cLast : Integer;
 procedure Refreshment(Delta:Integer);
 const LastTicks : Cardinal = 0;
 begin
  if LastTicks=0 then LastTicks:=GetTickCount;
  if abs(GetTickCount-LastTicks) > Delta then begin
   with CrwApi,GuiApi do begin ApplicationProcessMessages; UpdateSystemConsole; end;
   LastTicks:=GetTickCount;
  end;
 end;
begin
 Result:=0;					
 with CrwApi,SysApi,GuiApi,DanApi do
 try
  RedirectStdIn(Input);				
  RedirectStdOut(Output);
  if Target <> ForDataAnalysis 
  then Raise EDanApi.Create(RusEng('Неверное значение Target!',
                                   'Invalid Target!'));
  if not WindowExists(swin) 
  then Raise EDanApi.Create(RusEng('Не найдено окно - источник!',
                                   'Source window not found!'));
  if not WindowExists(twin) 
  then Raise EDanApi.Create(RusEng('Не найдено окно - приемник!',
                                   'Target window not found!'));
  if CurvesCount[swin]=0 
  then Raise EDanApi.Create(RusEng('Нет данных для обработки!',
                                   'No input data curves found!'));
  WindowRoi[twin]:=WindowRoi[swin];
  WindowCaption[twin]:=GetArgumentAsString(RusEng('Имя окна','Caption'));
  WindowTitle[twin]:=GetArgumentAsString(RusEng('Заголовок','Title'));
  WindowLegend[twin]:=GetArgumentAsString(RusEng('Легенда','Legend'));
  if not GetArgumentAsDouble(RusEng('Абс.Окно','Abs.Window'),AbsEps) or
     not GetArgumentAsDouble(RusEng('Отн.Окно','Rel.Window'),RelEps) or
     not GetArgumentAsInteger(RusEng('Степень','Power'),Power) or
     not GetArgumentAsInteger(RusEng('K1','K1'),k1) or
     not GetArgumentAsInteger(RusEng('K2','K2'),k2)
  then Raise EDanApi.Create(RusEng('Ошибка задания аргументов!',
                                   'Invalid input arguments!'));
  if SelectedCurve[swin]>0 then begin
   cFirst:=SelectedCurve[swin];
   cLast:=SelectedCurve[swin];
  end else begin
   if YesNo(RusEng('Выполнить для всех кривых в окне?',
                   'Execute for all curves in window?'))<>mrYes
   then Raise EDanApi.Create(RusEng('Пользователь прервал!','User break!'));
   cFirst:=1;
   cLast:=CurvesCount[swin];
  end;
  for c1:=cFirst to cLast do begin
   if CurveFlags(c1,0,1E-10,3) and CheckFlags <> 0
   then Raise EDanApi.Create(Format(RusEng('Кривая %d непригодна для сглаживания!',
                                          'Curve %d is not convenient for smoothing!'),[c1]));
   Window:=Max(Abs(AbsEps),Abs(RelEps*Rect2DSize(CurveLimits[c1]).X));
   c2:=CreateCurve(twin,CurveName[c1],CurveColor[c1],CurveStyle[c1],CurveComment[c1]);
   CurveLength[c2]:=CurveLength[c1];
   for i:=0 to CurveLength[c1]-1 do begin
    p:=CurvePoint[c1,i];
    p.y:=CurveSmoothAt(c1,p.x,Window,Power,k1,k2);
    CurvePoint[c2,i]:=p;
    Refreshment(100);
   end;
  end;
  if SelectedCurve[swin]>0 then SelectedCurve[twin]:=1 else SelectedCurve[twin]:=0;
 except
  on E:Exception do begin
   Result:=-1;
   if WindowExists(twin) then CurvesCount[twin]:=0; 
   Echo(E.Message);
   if UsesBlaster then Voice('EXCEPTION');
   Error(E.Message);
  end;
 end;
end;

//////////////////////////////////////////////////
{$I _crw_plugin_exports} // Exports CRWDAQ_PLUGIN.
//////////////////////////////////////////////////
// exports CRWDAQ_PLUGIN name CRWDAQ_PLUGIN_ID; //
//////////////////////////////////////////////////
begin
end.

//////////////
// END OF FILE
//////////////
 
